/* hash.h: A header for the ircd hashtable code.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: hash.h,v 1.29 2005/01/27 11:48:01 musirc Exp $
 */

#ifndef INCLUDED_hash_h
#define INCLUDED_hash_h

struct Client;
struct Channel;
struct JupeChannel;
struct UserHost;

extern struct Channel *get_or_create_channel(char *, int *);

extern void init_hash(void);
extern void hash_add_client(struct Client *);
extern void hash_del_client(struct Client *);
extern void hash_add_channel(struct Channel *);
extern void hash_del_channel(struct Channel *);
extern void hash_add_jupe(struct JupeChannel *);
extern void hash_del_jupe(struct JupeChannel *);
extern void hash_add_userhost(struct UserHost *);
extern void hash_del_userhost(struct UserHost *);
extern struct UserHost *hash_find_userhost(const char *);
extern struct Client *find_client(const char *);
extern struct Client *find_server(const char *);
extern struct Channel *hash_find_channel(const char *);
extern struct Channel *hash_get_chptr(unsigned int);
extern struct JupeChannel *hash_find_jupe(const char *);
extern void free_list_task(struct ListTask *, struct Client *);
extern void safe_list_channels(struct Client *, struct ListTask *, int, int);
extern void listmode(unsigned int, char[], char, char);
#endif
