/* hostmask.h: A header for the hostmask code.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: hostmask.h,v 1.11 2005/01/27 11:48:01 musirc Exp $
 */

#ifndef INCLUDE_hostmask_h
#define INCLUDE_hostmask_h 1
enum
{
 HM_HOST,
 HM_IPV4,
 HM_IPV6
};

struct HostMaskEntry
{
  int type, subtype;
  unsigned long precedence;
  char *hostmask;
  void *data;
  struct HostMaskEntry *next, *nexthash;
};

int parse_netmask(const char *, struct irc_ssaddr *, int *);
struct AccessItem *find_conf_by_address(const char *, struct irc_ssaddr *,
                                        int, int, const char *, char *);
void add_conf_by_address(int, struct AccessItem *);
void delete_one_address_conf(const char *, struct AccessItem *);
void clear_out_address_conf(void);
void init_host_hash(void);
struct AccessItem* find_address_conf(const char *, const char *,
				     struct irc_ssaddr *, int, char *);
struct AccessItem* find_kline_conf(const char*, const char*,
                                   struct irc_ssaddr *, int);
struct AccessItem* find_dline_conf(struct irc_ssaddr *, int);
int match_ipv6(struct irc_ssaddr*, struct irc_ssaddr *, int);
int match_ipv4(struct irc_ssaddr*, struct irc_ssaddr *, int);

void report_Klines(struct Client *, int);
void report_auth(struct Client *);

/* Hashtable stuff... */
#define ATABLE_SIZE 0x1000

extern struct AddressRec *atable[ATABLE_SIZE];

struct AddressRec
{
  /* masktype: HM_HOST, HM_IPV4, HM_IPV6 -A1kmm */
  int masktype;

  union
  {
    struct
    {
      /* Pointer into AccessItem... -A1kmm */
      struct irc_ssaddr addr;
      int bits;
    } ipa;

  /* Pointer into AccessItem... -A1kmm */
  const char *hostname;
  } Mask;

  /* type: CONF_CLIENT, CONF_DLINE, CONF_KLINE etc... -A1kmm */
  int type;

  /* Higher precedences overrule lower ones... */
  unsigned long precedence;

  /* Only checked if !(type & 1)... */
  const char *username;
  struct AccessItem *aconf;

  /* The next record in this hash bucket. */
  struct AddressRec *next;
};

extern char *
show_iline_prefix(struct Client *, struct AccessItem *, char *);

#endif
