/* inet_misc.h - Supplemental structs, functions, and definitions required to build ircd
 * on some exotic platforms.
 * $Id: inet_misc.h,v 1.11 2005/01/27 11:48:01 musirc Exp $
 * Copyright (c) 1980, 1983, 1988, 1993
 * The Regents of the University of California.  All rights reserved.
 * Portions Copyright (c) 1993 by Digital Equipment Corporation.
 */

#ifndef INCLUDED_inet_misc_h
#define INCLUDED_inet_misc_h

#include "stdinc.h"

#ifndef AI_PASSIVE
#define AI_PASSIVE      0x00000001 /* get address to use bind() */
#endif

#ifndef AI_NUMERICHOST
#define AI_NUMERICHOST  0x00000004 /* prevent name resolution */
#endif

#ifndef EAI_FAIL
#define EAI_FAIL         4      /* non-recoverable failure in name resolution */
#endif

#ifndef EAI_FAMILY
#define EAI_FAMILY       5      /* ai_family not supported */
#endif

#ifndef EAI_MEMORY
#define EAI_MEMORY       6      /* memory allocation failure */
#endif

#ifndef EAI_NONAME
#define EAI_NONAME       8      /* hostname nor servname provided, or not known */
#endif

#ifndef EAI_SYSTEM
#define EAI_SYSTEM      11      /* system error returned in errno */
#endif

#ifndef NI_NUMERICHOST
#define NI_NUMERICHOST	0x00000002
#endif

#ifndef NI_NAMEREQD
#define NI_NAMEREQD     0x00000004
#endif

#ifndef NI_NUMERICSERV
#define NI_NUMERICSERV  0x00000008
#endif

#ifndef NI_DGRAM
#define NI_DGRAM        0x00000010
#endif

#ifndef INADDR_NONE
#define INADDR_NONE ((unsigned int) 0xffffffff)
#endif

#ifndef HAVE_STRUCT_SOCKADDR_STORAGE
#ifdef SOCKADDR_IN_HAS_LEN /* BSD style sockaddr_storage for BSD style
			      sockaddr_in */
struct sockaddr_storage {
	unsigned char ss_len;
	sa_family_t ss_family;
	char __ss_pad1[((sizeof(int64_t)) - sizeof(unsigned char) -
			sizeof(sa_family_t) )];
	int64_t __ss_align;
	char __ss_pad2[(128 - sizeof(unsigned char) - sizeof(sa_family_t) -
			((sizeof(int64_t)) - sizeof(unsigned char) -
			 sizeof(sa_family_t)) - (sizeof(int64_t)))];
};
#else /* Linux style for everything else (for now) */
struct sockaddr_storage
{
	sa_family_t ss_family;
	u_int32_t __ss_align;
	char __ss_padding[(128 - (2 * sizeof (u_int32_t)))];
};
#endif /* SOCKADDR_IN_HAS_LEN */
#endif /* HAVE_STRUCT_SOCKADDR_STORAGE */

#ifndef HAVE_STRUCT_ADDRINFO
struct addrinfo {
	int ai_flags;
	int ai_family;
	int ai_socktype;
	int ai_protocol;
	size_t ai_addrlen;
	char *ai_canonname;
	struct sockaddr *ai_addr;
	struct addrinfo *ai_next;
};
#endif

#ifdef NO_IN6ADDR_ANY
extern const struct in6_addr in6addr_any;
#endif

#ifdef NO_INET_NTOP
const char * inet_ntop(int, const void *, char *, size_t);
#endif

#ifdef NO_INET_PTON
int inet_pton(int, const char *, void *);
#endif

#ifdef NO_INET_ATON
int inet_aton(const char *, struct in_addr *);
#endif

#endif
