/* info.h: A header for the information sent by /info
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: info.h,v 1.13 2005/01/27 11:48:01 musirc Exp $
 */

#ifndef INCLUDED_info_h
#define INCLUDED_info_h

#include "setup.h"
#include "defaults.h"

typedef struct Information
{
  const char *name;     /* name of item                     */
  const char *strvalue; /* value of item if it's a boolean  */
  int intvalue;         /* value of item if it's an integer */
  const char *desc;     /* short description of item        */
} Info;

Info MyInformation[] = {

#ifdef CPATH
  { "CPATH", CPATH, 0, "Path to Main Configuration File" },
#else
  { "CPATH", "NONE", 0, "Path to Main Configuration File" },
#endif

#ifdef DPATH
  { "DPATH", DPATH, 0, "Directory Containing Configuration Files" },
#else
  { "DPATH", "NONE", 0, "Directory Containing Configuration Files" },
#endif

#ifdef DLPATH
  { "DLPATH", DLPATH, 0, "Path to D-Line File" },
#else
  { "DLPATH", "NONE", 0, "Path to D-Line File" },
#endif

  { "HARD_FDLIMIT", "", HARD_FDLIMIT, "Maximum Number of File Descriptors Available" },

#ifdef SOMAXCONN
  { "IRCD_SOMAXCONN", "", SOMAXCONN, "Maximum Queue Length of Pending Connections" },
#else
  { "IRCD_SOMAXCONN", "", IRCD_SOMAXCONN, "Maximum Queue Length of Pending Connections" },
#endif

#ifdef KPATH
  { "KPATH", KPATH, 0, "Path to K-Line File" },
#else
  { "KPATH", "NONE", 0, "Path to K-Line File" },
#endif

#ifdef LPATH
  { "LPATH", LPATH, 0, "Path to Log File" },
#else
  { "LPATH", "NONE", 0, "Path to Log File" },
#endif

  { "MAX_BUFFER", "", MAX_BUFFER, "Maximum Buffer Connections Allowed" },

  { "MAX_CONNECTIONS", "", MAXCONN, "Maximum Number of Network Connections Allowed" },

#ifdef MODPATH
  { "MODPATH", MODPATH, 0, "Path to modules" },
#else
  { "MODPATH", "NONE", 0, "Path to modules" },
#endif

#ifdef MPATH
  { "MPATH", MPATH, 0, "Path to MOTD File" },
#else
  { "MPATH", "NONE", 0, "Path to MOTD File" },
#endif

#ifdef OPATH
  { "OPATH", OPATH, 0, "Path to Operator MOTD File" },
#else
  { "OPATH", "NONE", 0, "Path to Operator MOTD File" },
#endif

#ifdef PPATH
  { "PPATH", PPATH, 0, "Path to Pid File" },
#else
  { "PPATH", "NONE", 0, "Path to Pid File" },
#endif

  { "SELECT_TYPE", SELECT_TYPE, 0, "Method of Multiplexed I/O" },

#ifdef SPATH
  { "SPATH", SPATH, 0, "Path to Server Executable" },
#else
  { "SPATH", "NONE", 0, "Path to Server Executable" },
#endif

  { "TS_MAX_DELTA_DEFAULT", "", TS_MAX_DELTA_DEFAULT, "Maximum Allowed TS Delta from another Server" },
  { "TS_WARN_DELTA_DEFAULT", "", TS_WARN_DELTA_DEFAULT, "Maximum TS Delta before Sending Warning" },
  { 0, 0, 0, 0 }
};
#endif
