/* jupe.h: A header for the C/NJUPE functions.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: jupe.h,v 1.4 2005/01/27 11:48:01 musirc Exp $
 */

#ifndef INCLUDED_jupe_h
#define INCLUDED_jupe_h

struct JupeChannel
{
  dlink_node node;
  struct JupeChannel *hnext;
  /* +1 for \0 */
  char name[CHANNELLEN + 1];
  char *reason;
  int conf;         /* 1 if set from ircd.conf, 0 if from elsewhere */
};

extern dlink_list cjupe_list;
extern struct ConfItem *create_cjupe(char *, char *, int);
extern struct ConfItem *create_njupe(char *, char *, int);
extern int find_cjupe(const char *);
extern int clean_jupe_nick(char *);
extern int delete_cjupe(struct JupeChannel *);
extern void clear_conf_jupe(void);
extern void report_jupe(struct Client *);
extern int valid_wild_card_simple(char *);
extern dlink_list njupe_items;
#endif
