/* listener.h: A header for the listener code.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: listener.h,v 1.13 2005/01/27 11:48:01 musirc Exp $
 */

#ifndef INCLUDED_listener_h
#define INCLUDED_listener_h

#include "defs.h"
#include "tools.h"

struct Client;

struct Listener
{
  dlink_node listener_node; /* list node pointer */
  const char *name;               /* listener name */
  int fd;                 /* file descriptor */
  int port;               /* listener IP port */
  int ref_count;          /* number of connection references */
  int active;             /* current state of listener */
  int index;              /* index into poll array */
  time_t last_accept;        /* last time listener accepted */
  struct irc_ssaddr addr;              /* virtual address or SSADDR_ANY */
  struct DNSQuery *dns_query;
  char vhost[HOSTLEN + 1]; /* virtual name of listener */
};

extern void add_listener(int, const char *);
extern void close_listeners(void);
extern const char *get_listener_name(const struct Listener *);
extern void show_ports(struct Client *);
extern void free_listener(struct Listener *);
#endif
