/* log.h: A header for the logger functions.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: log.h,v 1.6 2005/01/27 11:48:01 musirc Exp $
 */

#ifndef INCLUDED_log_h
#define INCLUDED_log_h

struct Client;

#define CRIT   0
#define ERROR  1
#define WARN   2
#define NOTICE 3
#define TRACE  4
#define INFO   5

extern void init_log(const char *);
extern void reopen_log(const char *);
extern void set_log_level(const int);
extern int get_log_level(void);
#ifdef __GNUC__
extern void ilog(const int, const char *, ...) __attribute__((format(printf, 2, 3)));
#else
extern void ilog(const int, const char *, ...);
#endif
extern const char *get_log_level_as_string(int);
extern void log_user_exit(struct Client *);
extern void log_oper(struct Client *, const char *);
extern void log_failed_oper(struct Client *, const char *);

#endif
