/* memory.h: A header for the memory functions.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: memory.h,v 1.14 2005/01/27 11:48:01 musirc Exp $
 */

#ifndef _I_MEMORY_H
#define _I_MEMORY_H

#include "defs.h"
#include "balloc.h"

/* Needed to use uintptr_t for some pointer manipulation. */
#ifdef HAVE_INTTYPES_H
#include <inttypes.h>
#else /* No inttypes.h */
#ifndef HAVE_UINTPTR_T
typedef unsigned long uintptr_t;
#endif
#endif

extern void outofmemory(void);

extern void *MyMalloc(size_t);
extern void *MyRealloc(void *, size_t);
extern void MyFree(void *);
extern void _DupString(char **, const char *);

/* forte (and maybe others) don't like double declarations,
 * so we don't declare the inlines unless GNUC
 */
#ifdef __GNUC__
extern inline void *
MyMalloc(size_t size)
{
  void *ret = calloc(1, size);

  if (ret == NULL)
    outofmemory();
  return(ret);
}

extern inline void *
MyRealloc(void *x, size_t y)
{
  void *ret = realloc(x, y);
  
  if (ret == NULL)
    outofmemory();
  return(ret);    
}

extern inline void
MyFree(void *x)
{
  if (x != NULL)
    free(x);
}

extern inline void
_DupString(char **x, const char *y)
{
  (*x) = malloc(strlen(y) + 1);

  if (x == NULL)
    outofmemory();
  strcpy((*x), y); 
}
#endif /* __GNUC__ */

#define DupString(x,y) _DupString(&x, y)

#ifndef WE_ARE_MEMORY_C
#undef strdup
#undef malloc
#undef realloc
#undef calloc
#undef free
#define malloc do_not_call_old_memory_functions!call_My*functions
#define calloc do_not_call_old_memory_functions!call_My*functions
#define realloc do_not_call_old_memory_functions!call_My*functions
#define strdup do_not_call_old_memory_functions!call_My*functions
#define free do_not_call_old_memory_functions!call_My*functions
#endif

#endif
