/* motd.h: A header for the MOTD functions.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: motd.h,v 1.13 2005/01/27 11:48:01 musirc Exp $
 */

#ifndef INCLUDED_motd_h
#define INCLUDED_motd_h
#include "defs.h"   

#define MESSAGELINELEN 256

typedef enum {
  USER_MOTD,
  USER_LINKS,
  OPER_MOTD
} MotdType;

struct MessageFileLine
{
  char line[MESSAGELINELEN + 1];
  struct MessageFileLine *next;
};

typedef struct MessageFileLine MessageFileLine;

struct MessageFile
{
  char fileName[PATH_MAX + 1];
  MotdType motdType;
  MessageFileLine *contentsOfFile;
};

typedef struct MessageFile MessageFile;

struct Client;

extern void init_message_file(MotdType, const char *, struct MessageFile *);
extern int send_message_file(struct Client *, struct MessageFile *);
extern int read_message_file(MessageFile *);
#endif
