/* numeric.h: A header for the numeric functions.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: numeric.h,v 1.37 2005/01/27 11:48:01 musirc Exp $
 */

#ifndef INCLUDED_numeric_h
#define INCLUDED_numeric_h

#define LOCALE_LENGTH 64  /* maximum length of locale name + 1 */

struct NumericInfo
{
  const char *name;     /* common name of the numeric */
  const char *standard; /* standard numeric text      */
  char *translated;     /* translated numeric text    */
};

extern const char *form_str(int);
extern void set_locale(const char *);
extern const char *get_locale(void);

/* Reserve numerics 000-099 for server-client connections where the client
 * is local to the server. If any server is passed a numeric in this range
 * from another server then it is remapped to 100-199. -avalon
 */
#define RPL_WELCOME          001
#define RPL_YOURHOST         002
#define RPL_CREATED          003
#define RPL_MYINFO           004
#define RPL_ISUPPORT         005
#define RPL_MAP		     15
#define RPL_MAPEND	     17

/* Numeric replies from server commands.
 * These are currently in the range 200-399.
 */
#define RPL_TRACELINK        200
#define RPL_TRACECONNECTING  201
#define RPL_TRACEHANDSHAKE   202
#define RPL_TRACEUNKNOWN     203
#define RPL_TRACEOPERATOR    204
#define RPL_TRACEUSER        205
#define RPL_TRACESERVER      206
#define RPL_TRACENEWTYPE     208
#define RPL_TRACECLASS       209
#define RPL_STATSLINKINFO    211
#define RPL_STATSCLINE       213
#define RPL_STATSNLINE       214
#define RPL_STATSILINE       215
#define RPL_STATSKLINE       216
#define RPL_STATSQLINE       217
#define RPL_STATSYLINE       218
#define RPL_ENDOFSTATS       219
#define RPL_STATSPLINE       220
#define RPL_UMODEIS          221
#define RPL_STATSFLINE       224
#define RPL_STATSDLINE       225
#define RPL_STATSALINE	     226
#define RPL_STATSLLINE       241
#define RPL_STATSUPTIME      242
#define RPL_STATSOLINE       243
#define RPL_STATSHLINE       244
#define RPL_STATSXLINE       247
#define RPL_STATSULINE       248
#define RPL_STATSDEBUG       249
#define RPL_LUSERCLIENT      251
#define RPL_LUSEROP          252
#define RPL_LUSERUNKNOWN     253
#define RPL_LUSERCHANNELS    254
#define RPL_LUSERME          255
#define RPL_ADMINME          256
#define RPL_ADMINLOC1        257
#define RPL_ADMINLOC2        258
#define RPL_ADMINEMAIL       259
#define RPL_ENDOFTRACE       262
#define RPL_LOAD2HI          263
#define RPL_LOCALUSERS       265
#define RPL_GLOBALUSERS      266
#define RPL_ACCEPTLIST	     281
#define RPL_ENDOFACCEPT      282
#define RPL_ISMESSAGING      283

/* numeric_replies */
#define RPL_AWAY             301
#define RPL_USERHOST         302
#define RPL_ISON             303
#define RPL_UNAWAY           305
#define RPL_NOWAWAY          306
#define RPL_WHOISSERVICE     310
#define RPL_WHOISUSER        311
#define RPL_WHOISSERVER      312
#define RPL_WHOISOPERATOR    313
#define RPL_WHOWASUSER       314
#define RPL_ENDOFWHO         315
#define RPL_WHOISIDLE        317
#define RPL_ENDOFWHOIS       318
#define RPL_WHOISCHANNELS    319
#define RPL_LISTSTART        321
#define RPL_LIST             322
#define RPL_LISTEND          323
#define RPL_CHANNELMODEIS    324
#define RPL_CREATIONTIME     329
#define RPL_NOTOPIC          331
#define RPL_TOPIC            332
#define RPL_TOPICWHOTIME     333
#define RPL_WHOISACTUALLY    338
#define RPL_INVITING         341
#define RPL_INVITELIST       346
#define RPL_ENDOFINVITELIST  347
#define RPL_EXCEPTLIST       348
#define RPL_ENDOFEXCEPTLIST  349
#define RPL_VERSION          351
#define RPL_WHOREPLY         352
#define RPL_NAMREPLY         353
#define RPL_CLOSING          362
#define RPL_CLOSEEND         363
#define RPL_LINKS            364
#define RPL_ENDOFLINKS       365
#define RPL_ENDOFNAMES       366
#define RPL_BANLIST          367
#define RPL_ENDOFBANLIST     368
#define RPL_ENDOFWHOWAS      369
#define RPL_INFO             371
#define RPL_MOTD             372
#define RPL_INFOSTART        373
#define RPL_ENDOFINFO        374
#define RPL_MOTDSTART        375
#define RPL_ENDOFMOTD        376
#define RPL_OMOTDSTART       377
#define RPL_OMOTD            378
#define RPL_ENDOFOMOTD       379
#define RPL_YOUREOPER        381
#define RPL_REHASHING        382
#define RPL_TIME             391

/* Errors are in the range from 400-599 currently and are grouped by what
 * commands they come from.
 */
#define ERR_NOSUCHNICK       401
#define ERR_NOSUCHSERVER     402
#define ERR_NOSUCHCHANNEL    403
#define ERR_CANNOTSENDTOCHAN 404
#define ERR_TOOMANYCHANNELS  405
#define ERR_WASNOSUCHNICK    406
#define ERR_TOOMANYTARGETS   407
#define ERR_NOCONTROL	     408
#define ERR_NOORIGIN         409
#define ERR_NORECIPIENT      411
#define ERR_NOTEXTTOSEND     412
#define ERR_NOTOPLEVEL       413
#define ERR_WILDTOPLEVEL     414
#define ERR_UNKNOWNCOMMAND   421
#define ERR_NOMOTD           422
#define ERR_NOADMININFO      423
#define ERR_NONICKNAMEGIVEN  431
#define ERR_ERRONEUSNICKNAME 432
#define ERR_NICKNAMEINUSE    433
#define ERR_NICKCOLLISION    436
#define ERR_UNAVAILRESOURCE  437
#define ERR_NICKTOOFAST	     438
#define ERR_SERVICESDOWN     440
#define ERR_USERNOTINCHANNEL 441
#define ERR_NOTONCHANNEL     442
#define ERR_USERONCHANNEL    443
#define ERR_NOTREGISTERED    451
#define ERR_ACCEPTFULL       456
#define ERR_ACCEPTEXIST      457
#define ERR_ACCEPTNOT        458
#define ERR_NEEDMOREPARAMS   461
#define ERR_ALREADYREGISTRED 462
#define ERR_PASSWDMISMATCH   464
#define ERR_YOUREBANNEDCREEP 465
#define ERR_CHANNELISFULL    471
#define ERR_UNKNOWNMODE      472
#define ERR_INVITEONLYCHAN   473
#define ERR_BANNEDFROMCHAN   474
#define ERR_BADCHANNELKEY    475
#define ERR_BANLISTFULL      478
#define ERR_BADCHANNAME      479
#define ERR_NOPRIVILEGES     481
#define ERR_CHANOPRIVSNEEDED 482
#define ERR_CANTKILLSERVER   483
#define ERR_RESTRICTED       484
#define ERR_NOOPERHOST       491
#define ERR_ISSERVICE	     498
#define ERR_UMODEUNKNOWNFLAG 501
#define ERR_USERSDONTMATCH   502
#define ERR_GHOSTEDCLIENT    503
#define ERR_USERNOTONSERV    504
#define ERR_WRONGPONG	     513
#define ERR_LISTSYNTAX	     521
#define ERR_HELPNOTFOUND     524
#define RPL_MODLIST          702
#define RPL_ENDOFMODLIST     703
#define RPL_HELPSTART        704
#define RPL_HELPTXT          705
#define RPL_ENDOFHELP        706
#define RPL_KNOCK	     710
#define RPL_KNOCKDLVR	     711
#define ERR_TOOMANYKNOCK     712
#define ERR_CHANOPEN         713
#define ERR_KNOCKONCHAN      714
#define ERR_KNOCKDISABLED    715
#define ERR_LAST_ERR_MSG     999
#endif
