/* send.h: A header for the message sending functions.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: send.h,v 1.36 2005/01/27 11:48:01 musirc Exp $
 */

#ifndef INCLUDED_send_h
#define INCLUDED_send_h

/* For those unfamiliar with GNU format attributes, a is the 1 based
 * argument number of the format string, and b is the 1 based argument
 * number of the variadic ... */
#ifdef __GNUC__
#define AFP(a,b) __attribute__((format (printf, a, b)))
#else
#define AFP(a,b)
#endif

struct Client;
struct Channel;
struct dlink_list;
extern unsigned long current_serial;
extern void send_queued_write(struct Client *);
extern void send_queued_all(void);
extern void sendto_one(struct Client *, const char *, ...) AFP(2, 3);
extern void sendto_channel_butone(struct Client *, struct Client *,
		                  struct Channel *, const char *,
                                  const char *, ...) AFP(5, 6);
extern void sendto_common_channels_local(struct Client *, int,
		                         const char *, ...) AFP(3, 4);
extern void sendto_channel_local(int type, struct Channel *,
                                 const char *, ...) AFP(3, 4);
extern void sendto_channel_local_butone(struct Client *, int, struct Channel *,
                                        const char *, ...) AFP(4,5);
extern void sendto_channel_remote(struct Client *, int, struct Channel *,
				  const char *, ...) AFP(4, 5);
extern void sendto_server(struct Client *, struct Channel *, const char *, ...);
extern void sendto_match_butone(struct Client *, struct Client *, 
                                char *, int, const char *, ...)
                                AFP(5, 6);
extern void sendto_match_servs(struct Client *, const char *, const char *, ...) AFP(3, 4);
extern void sendto_realops_flags(unsigned int, int, const char *, ...) AFP(3, 4);
extern void sendto_wallops_flags(unsigned int, struct Client *, const char *, ...)
           AFP(3, 4);
extern void ts_warn(const char *, ...) AFP(1, 2);
extern void sendto_anywhere(struct Client *, struct Client *, const char *, ...) AFP(3, 4);
extern void kill_client(struct Client *, struct Client *, const char *, ... ) AFP(3, 4);

#define ALL_MEMBERS  0
#define NON_CHANOPS  1
#define ONLY_CHANOPS_VOICED  2
#define ONLY_CHANOPS 3

#define L_ALL 	0
#define L_OPER 	1
#define L_ADMIN	2

/* used when sending to #mask or $mask */
#define MATCH_SERVER  1
#define MATCH_HOST    2

#endif
