/* m_admin.c: Sends administrative information to a user.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: m_admin.c,v 1.27 2005/01/27 11:48:01 musirc Exp $
 */

#include "handlers.h"
#include "ircd.h"
#include "numeric.h"
#include "config.h"
#include "server.h"
#include "send.h"
#include "modules.h"
#include "istring.h"

static void m_admin(struct Client *, struct Client *, int, char **);
static void mr_admin(struct Client *, struct Client *, int, char **);
static void ms_admin(struct Client *, struct Client *, int, char **);
static void do_admin(struct Client *);

struct Message admin_msgtab = {
  "ADMIN", 0, MFLG_SLOW | MFLG_UNREG,
  {mr_admin, m_admin, ms_admin, ms_admin}
};

#ifndef STATIC_MODULES
void
_modinit(void)
{
  mod_add_cmd(&admin_msgtab);
}

void
_moddeinit(void)
{
  mod_del_cmd(&admin_msgtab);
}
const char *_version = "$Revision: 1.27 $";
#endif

/* parv[0] = sender prefix   
 * parv[1] = servername   
 */
static void
mr_admin(struct Client *client_p, struct Client *source_p,
         int parc, char *parv[])
{
  static time_t last_used = 0;
 
  if ((last_used + ConfigFileEntry.pace_wait) > CurrentTime)
  {
    sendto_one(source_p,form_str(RPL_LOAD2HI),
  	       me.name, EmptyString(parv[0]) ? "*" : parv[0]);
    return;
  }
  else
    last_used = CurrentTime;

  do_admin(source_p);
}

/* parv[0] = sender prefix
 * parv[1] = servername
 */
static void
m_admin(struct Client *client_p, struct Client *source_p,
        int parc, char *parv[])
{
  static time_t last_used = 0;

  if ((last_used + ConfigFileEntry.pace_wait) > CurrentTime)
  {
    sendto_one(source_p,form_str(RPL_LOAD2HI),
	       me.name, source_p->name);
    return;
  }
  else
    last_used = CurrentTime;

  if (!ConfigFileEntry.disable_remote)
  {
    if (hunt_server(client_p, source_p, ":%s ADMIN :%s", 1, parc, parv) != HUNTED_ISME)
      return;
  }
  do_admin(source_p);
}

/* parv[0] = sender prefix
 * parv[1] = servername
 */
static void
ms_admin(struct Client *client_p, struct Client *source_p,
         int parc, char *parv[])
{
  if (hunt_server(client_p, source_p, ":%s ADMIN :%s", 1, parc, parv) != HUNTED_ISME)
    return;

  if (IsClient(source_p))
    do_admin(source_p);
}

/* inputs	- pointer to client to report to
 * side effects	- admin info is sent to client given
 */
static void
do_admin(struct Client *source_p)
{
  if (!IsPerson(source_p))
    return;

  sendto_one(source_p, form_str(RPL_ADMINME),
             me.name, source_p->name, me.name);
  if (AdminInfo.name != NULL)
    sendto_one(source_p, form_str(RPL_ADMINLOC1),
               me.name, source_p->name, AdminInfo.name);
  if (AdminInfo.description != NULL)
    sendto_one(source_p, form_str(RPL_ADMINLOC2),
               me.name, source_p->name, AdminInfo.description);
  if (AdminInfo.email != NULL)
    sendto_one(source_p, form_str(RPL_ADMINEMAIL),
               me.name, source_p->name, AdminInfo.email);
}
