/* m_away.c: Sets/removes away status on a user.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: m_away.c,v 1.23 2005/01/27 11:48:01 musirc Exp $
 */

#include "handlers.h"
#include "ircd.h"
#include "istring.h"
#include "numeric.h"
#include "send.h"
#include "msg.h"
#include "modules.h"
#include "config.h"
#include "server.h"
#include "packet.h"

static void m_away(struct Client *, struct Client *, int, char **);
static void mo_away(struct Client *, struct Client *, int, char **);
static void ms_away(struct Client *, struct Client *, int, char **);

struct Message away_msgtab = {
  "AWAY", 0, MFLG_SLOW,
  {m_unregistered, m_away, ms_away, mo_away}
};

#ifndef STATIC_MODULES
void
_modinit(void)
{
  mod_add_cmd(&away_msgtab);
}

void
_moddeinit(void)
{
  mod_del_cmd(&away_msgtab);
}
const char *_version = "$Revision: 1.23 $";
#endif

/* parv[0] = sender prefix
 * parv[1] = away message
 */
static void
m_away(struct Client *client_p, struct Client *source_p,
       int parc, char *parv[])
{
  char *cur_away_msg = source_p->user->away;
  char *new_away_msg;
  size_t nbytes = 0;

  if (!IsFloodDone(source_p))
    flood_endgrace(source_p);

  if (parc < 2 || EmptyString(parv[1]))
  {
    /* Marking as not away */
    if (cur_away_msg)
    {
      sendto_server(client_p, NULL, ":%s AWAY", source_p->name);

      MyFree(cur_away_msg);
      source_p->user->away = NULL;
    }

    sendto_one(source_p, form_str(RPL_UNAWAY),
               me.name, source_p->name);
    return;
  }

  /* Marking as away */
  if ((CurrentTime - source_p->user->last_away) < ConfigFileEntry.pace_wait)
  {
    sendto_one(source_p, form_str(RPL_LOAD2HI),
               me.name, source_p->name);
    return;
  }
  source_p->user->last_away = CurrentTime;
  new_away_msg = parv[1];
  nbytes = strlen(new_away_msg);

  if (nbytes > (size_t)TOPICLEN)
  {
    new_away_msg[TOPICLEN] = '\0';
    nbytes = TOPICLEN;
  }

  /* we now send this only if they
   * weren't away already --is */
  if (!cur_away_msg)
    sendto_server(client_p, NULL, ":%s AWAY :%s", source_p->name, new_away_msg);
  else
    MyFree(cur_away_msg);

  cur_away_msg = MyMalloc(nbytes + 1);
  strcpy(cur_away_msg, new_away_msg);
  source_p->user->away = cur_away_msg;
  sendto_one(source_p, form_str(RPL_NOWAWAY), me.name, source_p->name);
}

static void
mo_away(struct Client *client_p, struct Client *source_p,
        int parc, char *parv[])
{
  char *cur_away_msg = source_p->user->away;
  char *new_away_msg;
  size_t nbytes = 0;

  if (!IsFloodDone(source_p))
    flood_endgrace(source_p);

  if (parc < 2 || EmptyString(parv[1]))
  {
    /* Marking as not away */
    if (cur_away_msg)
    {
      sendto_server(client_p, NULL, ":%s AWAY", source_p->name);

      MyFree(cur_away_msg);
      source_p->user->away = NULL;
    }

    sendto_one(source_p, form_str(RPL_UNAWAY),
               me.name, source_p->name);
    return;
  }

  source_p->user->last_away = CurrentTime;
  new_away_msg = parv[1];

  nbytes = strlen(new_away_msg);
  if (nbytes > (size_t)TOPICLEN)
  {
    new_away_msg[TOPICLEN] = '\0';
    nbytes = TOPICLEN;
  }

  /* we now send this only if they
   * weren't away already --is */
  if (!cur_away_msg)
    sendto_server(client_p, NULL, ":%s AWAY :%s", source_p->name, new_away_msg);
  else
    MyFree(cur_away_msg);

  cur_away_msg = MyMalloc(nbytes + 1);
  strcpy(cur_away_msg, new_away_msg);
  source_p->user->away = cur_away_msg;
  sendto_one(source_p, form_str(RPL_NOWAWAY), me.name, source_p->name);
}

static void
ms_away(struct Client *client_p, struct Client *source_p,
        int parc, char *parv[])
{
  char *cur_away_msg, *new_away_msg;
  size_t nbytes = 0;

  if (!IsClient(source_p))
    return;

  cur_away_msg = source_p->user->away;

  if (parc < 2 || EmptyString(parv[1]))
  {
    /* Marking as not away */
    if (cur_away_msg)
    {
      sendto_server(client_p, NULL, ":%s AWAY", source_p->name);
      MyFree(cur_away_msg);
      source_p->user->away = NULL;
    }

    return;
  }
  source_p->user->last_away = CurrentTime;
  new_away_msg = parv[1];
  nbytes = strlen(new_away_msg);

  if (nbytes > (size_t)TOPICLEN)
  {
    new_away_msg[TOPICLEN] = '\0';
    nbytes = TOPICLEN;
  }

  /* we now send this only if they
   * weren't away already --is */
  if (!cur_away_msg)
    sendto_server(client_p, NULL, ":%s AWAY :%s", source_p->name, new_away_msg);
  else
    MyFree(cur_away_msg);

  cur_away_msg = MyMalloc(nbytes + 1);
  strcpy(cur_away_msg, new_away_msg);
  source_p->user->away = cur_away_msg;
}
