/* m_help.c: Provides help information to a user/operator.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: m_help.c,v 1.25 2005/01/27 11:48:02 musirc Exp $
 */

#include "handlers.h"
#include "ircd.h"
#include "defaults.h"
#include "numeric.h"
#include "config.h"
#include "send.h"
#include "log.h"
#include "modules.h"
#include "istring.h"

static void m_help(struct Client *, struct Client *, int, char **);
static void mo_help(struct Client *, struct Client *, int, char **);
static void dohelp(struct Client *, const char *, char *);

struct Message help_msgtab = {
  "HELP", 0, MFLG_SLOW,
  {m_unregistered, m_help, m_ignore, mo_help}
};

#ifndef STATIC_MODULES
void
_modinit(void)
{
  mod_add_cmd(&help_msgtab);
}

void
_moddeinit(void)
{
  mod_del_cmd(&help_msgtab);
}

const char *_version = "$Revision: 1.25 $";
#endif

static void
m_help(struct Client *client_p, struct Client *source_p,
       int parc, char *parv[])
{
  static time_t last_used = 0;

  if ((last_used + ConfigFileEntry.pace_wait_simple) > CurrentTime)
  {
    sendto_one(source_p,form_str(RPL_LOAD2HI),
               me.name, source_p->name);
    return;
  }
  else
    last_used = CurrentTime;

  dohelp(source_p, HPATH, parv[1]);
}

static void
mo_help(struct Client *client_p, struct Client *source_p,
        int parc, char *parv[])
{
  dohelp(source_p, HPATH, parv[1]);
}

static void
dohelp(struct Client *source_p, const char *hpath, char *topic)
{
  FBFILE *file;
  char line[400], path[MAXPATHLEN + 1], started = 0;
  int type, i;
  struct stat sb;

  if (topic != NULL)
  {
    if (*topic == '\0')
      topic = "index";
    else
    {
      /* convert to lower case */
      for (i = 0; topic[i] != '\0'; i++)
        topic[i] = ToLower(topic[i]);
    }
  }
  else
    topic = "index"; /* list available help topics */

  if (strchr(topic, '/'))
  {
    sendto_one(source_p, form_str(ERR_HELPNOTFOUND),
               me.name, source_p->name, topic);
    return;
  }

  if (strlen(hpath) + strlen(topic) + 1 > MAXPATHLEN)
  {
    sendto_one(source_p, form_str(ERR_HELPNOTFOUND),
               me.name, source_p->name, topic);
    return;
  }

  snprintf(path, sizeof(path), "%s/%s", hpath, topic);

  if (stat(path, &sb) < 0)
  {
    ilog(NOTICE, "help file %s not found", path);
    sendto_one(source_p, form_str(ERR_HELPNOTFOUND),
               me.name, source_p->name, topic);
    return;
  }

  if (!S_ISREG(sb.st_mode))
  {
    ilog(NOTICE, "help file %s not found", path);
    sendto_one(source_p, form_str(ERR_HELPNOTFOUND),
               me.name, source_p->name, topic);
    return;
  }

  if ((file = fbopen(path, "r")) == NULL)
  {
    sendto_one(source_p, form_str(ERR_HELPNOTFOUND),
               me.name, source_p->name, topic);
    return;
  }

  if (fbgets(line, sizeof(line), file) == NULL)
  {
    sendto_one(source_p, form_str(ERR_HELPNOTFOUND),
               me.name, source_p->name, topic);
    return;
  }
  else if (line[0] != '#')
  {
    line[strlen(line) - 1] = '\0';     
    sendto_one(source_p, form_str(RPL_HELPSTART),
               me.name, source_p->name, line);
    started = 1;
  }

  while (fbgets(line, sizeof(line), file))
  {
    line[strlen(line) - 1] = '\0';
    if(line[0] != '#')
    {
      if (!started)
      {
        type = RPL_HELPSTART;
	started = 1;
      }
      else
        type = RPL_HELPTXT;
     
      sendto_one(source_p, form_str(RPL_HELPTXT),
                 me.name, source_p->name, line);
    }
  }
  fbclose(file);
  sendto_one(source_p, form_str(RPL_ENDOFHELP),
             me.name, source_p->name, topic);

  sendto_realops_flags(UMODE_SPY, L_ALL, "HELP '%s' by %s (%s@%s)",
                       topic, source_p->name, source_p->username, source_p->host);
}
