/* m_info.c: Sends information about the server.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: m_info.c,v 1.67 2005/02/15 09:02:11 musirc Exp $
 */

#include "info.h"
#include "client.h"
#include "istring.h"
#include "ircd.h"
#include "numeric.h"
#include "server.h"
#include "user.h"
#include "send.h"
#include "config.h"
#include "handlers.h"
#include "modules.h"

static void send_conf_options(struct Client *);
static void send_birthdate_online_time(struct Client *);
static void send_info_text(struct Client *);
static void m_info(struct Client *, struct Client *, int, char **);
static void ms_info(struct Client *, struct Client *, int, char **);
static void mo_info(struct Client *, struct Client *, int, char **);

struct Message info_msgtab = {
  "INFO", 0, MFLG_SLOW,
  {m_unregistered, m_info, ms_info, mo_info}
};
#ifndef STATIC_MODULES

void
_modinit(void)
{
  mod_add_cmd(&info_msgtab);
}

void
_moddeinit(void)
{
  mod_del_cmd(&info_msgtab);
}
const char *_version = "$Revision: 1.67 $";
#endif

struct InfoStruct
{
  const char *name;     /* Displayed variable name      */
  unsigned int output_type;       /* See below #defines */
  void *option;            /* Pointer reference to the value */
  const char *desc;     /* ASCII description of the variable */
};

/* Types for output_type in InfoStruct */
#define OUTPUT_STRING      0x01 /* Output option as %s w/ dereference */
#define OUTPUT_STRING_PTR  0x02 /* Output option as %s w/out deference */
#define OUTPUT_DECIMAL     0x04 /* Output option as decimal (%d) */
#define OUTPUT_BOOLEAN     0x08 /* Output option as "ON" or "OFF" */
#define OUTPUT_BOOLEAN_YN  0x10 /* Output option as "YES" or "NO" */
#define OUTPUT_BOOLEAN2	   0x20 /* Output option as "YES/NO/MASKED" */

static struct InfoStruct info_table[] =
{
  {
    "anti_nick_flood",
    OUTPUT_BOOLEAN,
    &ConfigFileEntry.anti_nick_flood,
    "NICK flood protection"
  },
  {
    "anti_spam_exit_message_time",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.anti_spam_exit_message_time,
    "Duration a client must be connected for to have an exit message"
  },
  {
    "autodline_drones",
    OUTPUT_BOOLEAN_YN,
    &ConfigFileEntry.autodline_drones,
    "Automatic D-Line of drones"
  },
  {
    "client_flood",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.client_flood,
    "Maximum amount of data in a client's queue before they are disconnected",
  },
  {
    "cjupe_dline",
    OUTPUT_BOOLEAN_YN,
    &ConfigChannel.cjupe_dline,
    "Disconnect users for joining cjuped channels",
  },
  {
    "cjupe_dline_time",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.cjupe_dline_time,
    "Duration of automatic cjupe dlines"
  },
  {
    "crypt_oper_password",
    OUTPUT_BOOLEAN_YN,
    &ConfigFileEntry.crypt_oper_password,
    "crypted oper passwords",
  },
  {
    "default_floodcount",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.default_floodcount,
    "Startup value of FLOODCOUNT",
  },
  {
    "default_floodjoin",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.default_floodjoin,
    "Startup value of FLOODJOIN",
  },
  {
    "default_split_server_count",
    OUTPUT_DECIMAL,
    &ConfigChannel.default_split_server_count,
    "Startup value of SPLITNUM",
  },
  {
    "default_split_user_count",
    OUTPUT_DECIMAL,
    &ConfigChannel.default_split_user_count,
    "Startup value of SPLITUSERS",
  },
  {
    "disable_hidden",
    OUTPUT_BOOLEAN_YN,
    &ConfigServerHide.disable_hidden,
    "Prevent servers from hiding themselves from a flattened /links",
  },
  {
    "disable_local_channels",
    OUTPUT_BOOLEAN_YN,
    &ConfigChannel.disable_local_channels,
    "Prevent users from joining &channels",
  },
  {
    "disable_remote_commands",
    OUTPUT_BOOLEAN_YN,
    &ConfigFileEntry.disable_remote,
    "Prevent users issuing commands on remote servers",
  },
  {
    "dots_in_ident",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.dots_in_ident,
    "Number of permissable dots in an ident"
  },
  {
    "drone_detect",
    OUTPUT_BOOLEAN_YN,
    &ConfigFileEntry.drone_detect,
    "Automatic detection of drones"
  },
  {
    "drone_dline_time",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.drone_dline_time,
    "Duration of automatic drone dlines"
  },
  {
    "ffailed_operlog",
    OUTPUT_STRING_PTR,
    &ConfigLoggingEntry.failed_operlog,
    "Failed operator log file"
  },
  {
    "flatten_links",
    OUTPUT_BOOLEAN_YN,
    &ConfigServerHide.flatten_links,
    "Flatten /links list",
  },
  {
    "foperlog",
    OUTPUT_STRING_PTR,
    &ConfigLoggingEntry.operlog,
    "Operator log file"
  },
  {
    "fuserlog",
    OUTPUT_STRING_PTR,
    &ConfigLoggingEntry.userlog,
    "User log file"
  },
  {
    "hide_ban_reason",
    OUTPUT_BOOLEAN_YN,
    &ConfigFileEntry.hide_ban_reason,
    "Banned clients sign off with 'K/D/X-Lined'"
  },
  {
    "hide_servers",
    OUTPUT_BOOLEAN_YN,
    &ConfigServerHide.hide_servers,
    "Hide servernames from users",
  },
  {
    "hide_spoof_ips",
    OUTPUT_BOOLEAN_YN,
    &ConfigFileEntry.hide_spoof_ips,
    "Hide spoofed IPs"
  },
  {
    "hidden",
    OUTPUT_BOOLEAN_YN,
    &ConfigServerHide.hidden,
    "Hide this server from a flattened /links on remote servers",
  },
  {
    "hub",
    OUTPUT_BOOLEAN_YN,
    &ServerInfo.hub,
    "Server is a hub"
  },
  {
    "idletime",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.idletime,
    "Number of seconds before a client is considered idle"
  },
  {
    "kill_chase_time_limit",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.kill_chase_time_limit,
    "Duration of nick tracking for KILL"
  },
  {
    "knock_delay",
    OUTPUT_DECIMAL,
    &ConfigChannel.knock_delay,
    "Delay between a users KNOCK attempts"
  },
  {
    "knock_delay_channel",
    OUTPUT_DECIMAL,
    &ConfigChannel.knock_delay_channel,
    "Delay between KNOCK attempts to a channel",
  },
  {
    "links_delay",
    OUTPUT_DECIMAL,
    &ConfigServerHide.links_delay,
    "Links rehash delay"
  },
  {
    "max_accept",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.max_accept,
    "Maximum numer of nicknames on accept list",
  },
  {
    "max_bans",
    OUTPUT_DECIMAL,
    &ConfigChannel.max_bans,
    "Total +b/e/I modes allowed in a channel",
  },
  {
    "max_chans_per_user",
    OUTPUT_DECIMAL,
    &ConfigChannel.max_chans_per_user,
    "Maximum number of channels a user can join",
  },
  {
    "max_nick_changes",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.max_nick_changes,
    "NICK change threshhold setting"
  },
  {
    "max_nick_time",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.max_nick_time,
    "NICK flood protection time interval"
  },
  {
    "max_targets",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.max_targets,
    "The maximum number of PRIVMSG/NOTICE targets"
  },
  {
    "maximum_links",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.maximum_links,
    "Class default maximum links count",
  },
  {
    "min_nonwildcard",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.min_nonwildcard,
    "Minimum non-wildcard chars in K/D lines",
  },
  {
    "network_name",
    OUTPUT_STRING,
    &ServerInfo.network_name,
    "Network name"
  },
  {
    "no_create_on_split",
    OUTPUT_BOOLEAN_YN,
    &ConfigChannel.no_create_on_split,
    "Disallow creation of channels when split",
  },
  {
    "no_join_on_split",
    OUTPUT_BOOLEAN_YN,
    &ConfigChannel.no_join_on_split,
    "Disallow joining channels when split",
  },
  {
    "no_oper_flood",
    OUTPUT_BOOLEAN,
    &ConfigFileEntry.no_oper_flood,
    "Reduce flood control for operators",
  },
  {
    "nochanidletime",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.nochanidletime,
    "Number of seconds before a client not in any channels is considered idle"
  },
  {
    "oper_pass_jupes",
    OUTPUT_BOOLEAN_YN,
    &ConfigFileEntry.oper_pass_jupes,
    "Opers can over-ride C/NJUPES",
  },
  {
    "pace_wait",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.pace_wait,
    "Minimum delay between uses of certain commands"
  },
  {
    "pace_wait_simple",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.pace_wait_simple,
    "Minimum delay between uses of less intensive commands"
  },
  {
    "quiet_on_ban",
    OUTPUT_BOOLEAN_YN,
    &ConfigChannel.quiet_on_ban,
    "Banned users may not send text to the channel"
  },
  {
    "server_side_ignore_wait",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.ssignore_wait,
    "Minimum delay between notifying UMODE +I users of messages"
  },
  {
    "stats_i_oper_only",
    OUTPUT_BOOLEAN2,
    &ConfigFileEntry.stats_i_oper_only,
    "STATS I output is only shown to operators",
  },
  {
    "stats_k_oper_only",
    OUTPUT_BOOLEAN2,
    &ConfigFileEntry.stats_k_oper_only,
    "STATS K output is only shown to operators",
  },
  {
    "stats_o_oper_only",
    OUTPUT_BOOLEAN_YN,
    &ConfigFileEntry.stats_o_oper_only,
    "STATS O output is only shown to operators",
  },
  {
    "stats_P_oper_only",
    OUTPUT_BOOLEAN_YN,
    &ConfigFileEntry.stats_P_oper_only,
    "STATS P is only shown to operators",
  },
  {
    "throttle_time",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.throttle_time,
    "Minimum time between client reconnects",
  },
  {
    "true_no_oper_flood",
    OUTPUT_BOOLEAN,
    &ConfigFileEntry.true_no_oper_flood,
    "Completely disable flood control for operators",
  },
  {
    "ts_max_delta",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.ts_max_delta,
    "Maximum permitted TS delta from another server"
  },
  {
    "ts_warn_delta",
    OUTPUT_DECIMAL,
    &ConfigFileEntry.ts_warn_delta,
    "Maximum permitted TS delta before displaying a warning"
  },
  {
    "use_logging",
    OUTPUT_BOOLEAN_YN,
    &ConfigLoggingEntry.use_logging,
    "Enable logging"
  },
  {
    "use_services",
    OUTPUT_BOOLEAN_YN,
    &ConfigFileEntry.use_services,
    "Server supports services"
  },
  {
    (char *) 0,
    (unsigned int) 0,
    (void *) 0,
    (char *) 0
  }
};

/* parv[0] = sender prefix
 * parv[1] = servername
 */
static void
m_info(struct Client *client_p, struct Client *source_p,
       int parc, char *parv[])
{
  static time_t last_used = 0;

  if ((last_used + ConfigFileEntry.pace_wait) > CurrentTime)
  {
    /* safe enough to give this on a local connect only */
    sendto_one(source_p, form_str(RPL_LOAD2HI),
               me.name, source_p->name);
    return;
  }
  else
    last_used = CurrentTime;

  if (!ConfigFileEntry.disable_remote)
  {
    if (hunt_server(client_p,source_p,
        ":%s INFO :%s", 1, parc, parv) != HUNTED_ISME)
      return;
  }

  send_info_text(source_p);
  send_birthdate_online_time(source_p);

  sendto_one(source_p, form_str(RPL_ENDOFINFO),
             me.name, source_p->name);
  sendto_realops_flags(UMODE_SPY, L_ALL, "INFO by %s (%s@%s) [%s]",
                       source_p->name, source_p->username,
                       source_p->host, source_p->user->server->name);
}

/* parv[0] = sender prefix
 * parv[1] = servername
 */
static void mo_info(struct Client *client_p, struct Client *source_p,
                    int parc, char *parv[])
{
  if (hunt_server(client_p,source_p,":%s INFO :%s",1,parc,parv) == HUNTED_ISME)
  {
    send_info_text(source_p);
    send_conf_options(source_p);
    send_birthdate_online_time(source_p);
    sendto_one(source_p, form_str(RPL_ENDOFINFO),
               me.name, source_p->name);
    sendto_realops_flags(UMODE_SPY, L_ALL, "INFO by %s (%s@%s) [%s]",
                         source_p->name, source_p->username,
                         source_p->host, source_p->user->server->name);
  }
}

/* parv[0] = sender prefix
 * parv[1] = servername
 */
static void
ms_info(struct Client *client_p, struct Client *source_p,
        int parc, char *parv[])
{
  if (!IsClient(source_p))
    return;
  
  if (hunt_server(client_p, source_p, ":%s INFO :%s", 1, parc, parv) == HUNTED_ISME)
  {
    send_info_text(source_p); 

    if (IsOper(source_p))
      send_conf_options(source_p);
      
    send_birthdate_online_time(source_p);
    sendto_one(source_p, form_str(RPL_ENDOFINFO),
               me.name, source_p->name);
    sendto_realops_flags(UMODE_SPY, L_ALL, "INFO by %s (%s@%s) [%s]",
                         source_p->name, source_p->username,
                         source_p->host, source_p->user->server->name);
  }
}
/* inputs	- client pointer to send info text to
 * side effects	- info text is sent to client
 */
static void
send_info_text(struct Client *source_p)
{
  const char **text = infotext;

  while (*text)
    sendto_one(source_p, form_str(RPL_INFO),
               me.name, source_p->name, *text++);
}

/* inputs       - client pointer to send to
 * side effects - birthdate and online time are sent
 */
static void
send_birthdate_online_time(struct Client *source_p)
{
  sendto_one(source_p, ":%s %d %s :Birth Date: %s, compile # %s",
             me.name, RPL_INFO, source_p->name,
             creation, generation);
  sendto_one(source_p, ":%s %d %s :On-line since %s",
             me.name, RPL_INFO, source_p->name,
             myctime(me.firsttime));
}

/* inputs       - client pointer to send to
 * side effects - send config options to client
 */
static void
send_conf_options(struct Client *source_p)
{
  Info *infoptr;
  int i = 0;

  for (infoptr = MyInformation; infoptr->name; infoptr++)
  {
    if (infoptr->intvalue)
      sendto_one(source_p, ":%s %d %s :%-30s %-5d [%s]",
                 me.name, RPL_INFO, source_p->name, infoptr->name,
                 infoptr->intvalue, infoptr->desc);
    else
      sendto_one(source_p, ":%s %d %s :%-30s %-5s [%s]",
                 me.name, RPL_INFO, source_p->name, infoptr->name,
                 infoptr->strvalue, infoptr->desc);
  }

  for (i = 0; info_table[i].name; i++)
  {
    switch (info_table[i].output_type)
    {
      /* For "char *" references */
      case OUTPUT_STRING:
      {
        char *option = *((char **)info_table[i].option);

        sendto_one(source_p, ":%s %d %s :%-30s %-5s [%s]",
                   me.name, RPL_INFO, source_p->name,
                   info_table[i].name, option ? option : "NONE",
                   info_table[i].desc ? info_table[i].desc : "<none>");
        break;
      }

      /* For "char foo[]" references */
      case OUTPUT_STRING_PTR:
      {
        char *option = (char *)info_table[i].option;

        sendto_one(source_p, ":%s %d %s :%-30s %-5s [%s]",
                   me.name, RPL_INFO, source_p->name,
                   info_table[i].name, option ? option : "NONE",
                   info_table[i].desc ? info_table[i].desc : "<none>");
        break;
      }

      /* Output info_table[i].option as a decimal value. */
      case OUTPUT_DECIMAL:
      {
        int option = *((int *)info_table[i].option);

        sendto_one(source_p, ":%s %d %s :%-30s %-5d [%s]",
                   me.name, RPL_INFO, source_p->name, info_table[i].name,
                   option, info_table[i].desc ? info_table[i].desc : "<none>");
        break;
      }

      /* Output info_table[i].option as "ON" or "OFF" */
      case OUTPUT_BOOLEAN:
      {
        int option = *((int *)info_table[i].option);

        sendto_one(source_p, ":%s %d %s :%-30s %-5s [%s]",
                   me.name, RPL_INFO, source_p->name,
                   info_table[i].name, option ? "ON" : "OFF",
                   info_table[i].desc ? info_table[i].desc : "<none>");

        break;
      }

      /* Output info_table[i].option as "YES" or "NO" */
      case OUTPUT_BOOLEAN_YN:
      {
        int option = *((int *)info_table[i].option);

        sendto_one(source_p, ":%s %d %s :%-30s %-5s [%s]",
                   me.name, RPL_INFO, source_p->name,
                   info_table[i].name, option ? "YES" : "NO",
                   info_table[i].desc ? info_table[i].desc : "<none>");
        break;
      }
    }
  }

  if (IsAdmin(source_p))
    sendto_one(source_p, ":%s %d %s :Compiled on [%s]",
               me.name, RPL_INFO, source_p->name, platform);
}
