/* m_ison.c: Provides a single line answer of whether a user is online.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: m_ison.c,v 1.25 2005/01/27 11:48:02 musirc Exp $
 */

#include "handlers.h"
#include "client.h"
#include "istring.h"
#include "sprintf.h"
#include "ircd.h"
#include "numeric.h"
#include "send.h"
#include "config.h"
#include "modules.h"
#include "server.h"

static void m_ison(struct Client *, struct Client *, int, char **);

struct Message ison_msgtab = {
  "ISON", 1, MFLG_SLOW,
  {m_unregistered, m_ison, m_ignore, m_ison}
};

#ifndef STATIC_MODULES
void
_modinit(void)
{
  mod_add_cmd(&ison_msgtab);
}

void
_moddeinit(void)
{
  mod_del_cmd(&ison_msgtab);
}
const char *_version = "$Revision: 1.25 $";
#endif

static void
m_ison(struct Client *client_p, struct Client *source_p,
       int parc, char *parv[])
{
  struct Client *target_p;
  char *nick, *p, *current_insert_point, *current_insert_point2,
       buf[BUFSIZE], buf2[BUFSIZE];
  int len, i, done = 0;

  current_insert_point2 = buf2;
  *buf2 = '\0';
  len = ircsprintf(buf, form_str(RPL_ISON), me.name, parv[0]);
  current_insert_point = buf + len;

  /* rfc1459 is ambigious about how to handle ISON
   * this should handle both interpretations.
   */
  for (i = 1; i < parc; i++)
  {
    for (nick = strtoken(&p, parv[i], " "); nick;
         nick = strtoken(&p, NULL, " "))
    {
      if ((target_p = find_person(nick)))
      {
        len = strlen(target_p->name);
        if ((current_insert_point + (len + 5)) < (buf + sizeof(buf)))
        {
          memcpy((void *)current_insert_point,
                 (void *)target_p->name, len);
          current_insert_point += len;
          *current_insert_point++ = ' ';
        }
        else
        {
          done = 1;
          break;
        }
      }
    }
    if (done)
      break;
  }

  /* current_insert_point--;
   * Do NOT take out the trailing space, it breaks ircII
   */
  *current_insert_point = '\0';
  *current_insert_point2 = '\0';   
  sendto_one(source_p, "%s", buf);
}
