/* m_list.c: List channel given or all channels.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: m_list.c,v 1.54 2005/01/27 11:48:02 musirc Exp $
 */

#include "handlers.h"
#include "channel.h"
#include "channel_mode.h"
#include "client.h"
#include "hash.h"
#include "istring.h"
#include "ircd.h"
#include "numeric.h"
#include "config.h"
#include "server.h"
#include "send.h"
#include "list.h"
#include "modules.h"

static void m_list(struct Client *, struct Client *, int, char **);
static void mo_olist(struct Client *, struct Client *, int, char **);
static void mo_list(struct Client *, struct Client *, int, char **);

struct Message list_msgtab = {
  "LIST", 0, MFLG_SLOW,
  {m_unregistered, m_list, m_ignore, mo_list}
};
struct Message olist_msgtab = {
  "OLIST", 0, MFLG_SLOW,
  {m_unregistered, m_ignore, m_ignore, mo_olist}
};
#ifndef STATIC_MODULES

void
_modinit(void)
{
  mod_add_cmd(&list_msgtab);
  mod_add_cmd(&olist_msgtab);
}

void
_moddeinit(void)
{
  mod_del_cmd(&list_msgtab);
  mod_del_cmd(&olist_msgtab);
}
const char *_version = "$Revision: 1.54 $";
#endif

static void
do_list(struct Client *source_p, int parc, char *parv[], int type)
{
  struct ListTask *lt;
  int no_masked_channels;

  if (source_p->localClient->list_task != NULL)
  {
    free_list_task(source_p->localClient->list_task, source_p);
    sendto_one(source_p, form_str(RPL_LISTEND), me.name, source_p->name);
    return;
  }
  lt = (struct ListTask *)MyMalloc(sizeof(struct ListTask));
  lt->users_max = UINT_MAX;
  lt->created_max = UINT_MAX;
  lt->topicts_max = UINT_MAX;
  source_p->localClient->list_task = lt;
  no_masked_channels = 1;

  if (parc > 1)
  {
    char *opt, *save;
    dlink_list *list;
    int i, errors = 0;

    for (opt = strtoken(&save, parv[1], ","); opt != NULL;
         opt = strtoken(&save, NULL, ","))
    {
      switch (*opt)
      {
        case '<': if ((i = atoi(opt + 1)) > 0)
                    lt->users_max = (unsigned int)i - 1;
                  else
                    errors = 1;
                  break;
        case '>': if ((i = atoi(opt + 1)) >= 0)
                    lt->users_min = (unsigned int)i + 1;
                  else
                    errors = 1;
                  break;
        case '-': break;
        case 'C':
        case 'c': switch (*++opt)
        {
          case '<': if ((i = atoi(opt + 1)) >= 0)
                        lt->created_max = (unsigned int)(CurrentTime - 60 * i);
                    else
                      errors = 1;
                    break;
          case '>': if ((i = atoi(opt + 1)) >= 0)
                    lt->created_min = (unsigned int)(CurrentTime - 60 * i);
                    else
                      errors = 1;
                    break;
          default: errors = 1;
        }
        break;
        case 'T':
        case 't': switch (*++opt)
        {
          case '<': if ((i = atoi(opt + 1)) >= 0)
                        lt->topicts_min = (unsigned int)(CurrentTime - 60 * i);
                    else
                      errors = 1;
                    break;
          case '>': if ((i = atoi(opt + 1)) >= 0)
                        lt->topicts_max = (unsigned int)(CurrentTime - 60 * i);
                    else
                      errors = 1;
                    break;
          default: errors = 1;
        }
        break;
        default: if (*opt == '!')
        {
          list = &lt->hide_mask;
          opt++;
        }
        else list = &lt->show_mask;
        if (strpbrk(opt, "?*") != NULL)
        {
          if (list == &lt->show_mask)
            no_masked_channels = 0;
        }
        else if (!IsChanPrefix(*opt))
          errors = 1;
        if (!errors)
        {
          char *s;
          DupString(s, opt);
          dlinkAdd(s, make_dlink_node(), list);
        }
      }
    }
    if (errors)
    {
      free_list_task(lt, source_p);
      sendto_one(source_p, form_str(ERR_LISTSYNTAX),
                 me.name, source_p->name);
      return;
    }
  }

  sendto_one(source_p, form_str(RPL_LISTSTART),
             me.name, source_p->name);
  safe_list_channels(source_p, lt, no_masked_channels &&
                     lt->show_mask.head != NULL, type);
}

/* parv[0] = sender prefix
 * parv[1] = channel
 */
static void
m_list(struct Client *client_p, struct Client *source_p, int parc, char *parv[])
{
  static time_t last_used = 0L;

  if(((last_used + ConfigFileEntry.pace_wait) > CurrentTime))
  {
    sendto_one(source_p,form_str(RPL_LOAD2HI),
	       me.name, source_p->name);
    return;
  }
  else
    last_used = CurrentTime;

  do_list(source_p, parc, parv, 0);
  sendto_realops_flags(UMODE_SPY, L_ALL, "LIST by %s (%s@%s)",
                       source_p->name, source_p->username,
                       source_p->host);
}

/* parv[0] = sender prefix
 * parv[1] = channel
 */
static void
mo_list(struct Client *client_p, struct Client *source_p, int parc, char *parv[])
{
  do_list(source_p, parc, parv, 0);
  sendto_realops_flags(UMODE_SPY, L_ALL, "LIST by %s (%s@%s)",
                       source_p->name, source_p->username, source_p->host);
}

/* parv[0] = sender prefix
 * parv[1] = channel
 */
static void
mo_olist(struct Client *client_p, struct Client *source_p, int parc, char *parv[])
{
  do_list(source_p, parc, parv, 1);
  sendto_realops_flags(UMODE_SPY, L_ALL, "OLIST by %s (%s@%s)",
                       source_p->name, source_p->username, source_p->host);
}
