/* m_motd.c: Shows the current message of the day.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: m_motd.c,v 1.24 2005/01/27 11:48:02 musirc Exp $
 */

#include "motd.h"
#include "ircd.h"
#include "send.h"
#include "numeric.h"
#include "handlers.h"
#include "server.h"
#include "modules.h"
#include "config.h"

static void m_motd(struct Client*, struct Client*, int, char**);
static void mo_motd(struct Client*, struct Client*, int, char**);
static void mo_omotd(struct Client*, struct Client*, int, char**);

struct Message motd_msgtab = {
  "MOTD", 0, MFLG_SLOW,
  {m_unregistered, m_motd, mo_motd, mo_motd}
};
struct Message omotd_msgtab = {
  "OMOTD", 0, MFLG_SLOW,
  {m_unregistered, m_not_oper, mo_omotd, mo_omotd}
};

#ifndef STATIC_MODULES
void
_modinit(void)
{
  mod_add_cmd(&motd_msgtab);
  mod_add_cmd(&omotd_msgtab);
}

void
_moddeinit(void)
{
  mod_del_cmd(&motd_msgtab);
  mod_del_cmd(&omotd_msgtab);
}
const char *_version = "$Revision: 1.24 $";
#endif

/* parv[0] = sender prefix
 * parv[1] = servername
 */
static void
m_motd(struct Client *client_p, struct Client *source_p,
       int parc, char *parv[])
{
  static time_t last_used = 0;

  if((last_used + ConfigFileEntry.pace_wait) > CurrentTime)
  {
    sendto_one(source_p,form_str(RPL_LOAD2HI),me.name,source_p->name);
    return;
  }
  else
    last_used = CurrentTime;

  if (!ConfigFileEntry.disable_remote && !ConfigServerHide.hide_servers)
    if (hunt_server(client_p, source_p, ":%s MOTD :%s", 1,parc,parv)!=HUNTED_ISME)
      return;

  send_message_file(source_p,&ConfigFileEntry.motd);
  sendto_realops_flags(UMODE_SPY, L_ALL, "MOTD by %s (%s@%s) [%s]",
                       source_p->name, source_p->username,
                       source_p->host, source_p->user->server->name);
}

/* parv[0] = sender prefix
 * parv[1] = servername
 */
static void
mo_motd(struct Client *client_p, struct Client *source_p,
        int parc, char *parv[])
{
  if (!IsClient(source_p))
    return;

  if (hunt_server(client_p, source_p, ":%s MOTD :%s", 1,parc,parv) != HUNTED_ISME)
    return;

  send_message_file(source_p, &ConfigFileEntry.motd);

  sendto_realops_flags(UMODE_SPY, L_ALL, "MOTD by %s (%s@%s) [%s]",
                       source_p->name, source_p->username,
                       source_p->host, source_p->user->server->name);

}

static void
mo_omotd(struct Client *client_p, struct Client *source_p,
         int parc, char *parv[])
{
  if (!IsClient(source_p))
    return;

  if (hunt_server(client_p, source_p, ":%s OMOTD :%s", 1, parc, parv) != HUNTED_ISME)
    return;

  sendto_realops_flags(UMODE_SPY, L_ALL, "OMOTD by %s (%s@%s) [%s]",
                       source_p->name, source_p->username,
                       source_p->host, source_p->user->server->name);

  send_message_file(source_p, &ConfigFileEntry.opermotd);
}
