/* m_names.c: Shows the users who are online.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: m_names.c,v 1.43 2005/01/27 11:48:02 musirc Exp $
 */

#include "handlers.h"
#include "channel.h"
#include "channel_mode.h"
#include "client.h"
#include "hash.h"
#include "client.h"
#include "istring.h"
#include "sprintf.h"
#include "ircd.h"
#include "numeric.h"
#include "send.h"
#include "server.h"
#include "config.h"
#include "modules.h"

static void names_all_visible_channels(struct Client *);
static void names_non_public_non_secret(struct Client *);
static void m_names(struct Client *, struct Client *, int, char **);
static void mo_onames(struct Client *, struct Client *, int, char **);

struct Message names_msgtab = {
  "NAMES", 0, MFLG_SLOW,
  {m_unregistered, m_names, m_ignore, m_names}
};
struct Message onames_msgtab = {
  "ONAMES", 1, MFLG_SLOW,
  {m_ignore, m_ignore, m_ignore, mo_onames}
};

#ifndef STATIC_MODULES
void
_modinit(void)
{
  mod_add_cmd(&names_msgtab);
  mod_add_cmd(&onames_msgtab);
}

void
_moddeinit(void)
{
  mod_del_cmd(&names_msgtab);
  mod_del_cmd(&onames_msgtab);
}

const char *_version = "$Revision: 1.43 $";
#endif

/* parv[0] = sender prefix
 * parv[1] = channel
 */
static void
m_names(struct Client *client_p, struct Client *source_p,
	int parc, char *parv[])
{ 
  struct Channel *chptr = NULL;
  char *s, *para = parc > 1 ? parv[1] : NULL;

  if (!EmptyString(para))
  {
    while (*para == ',')
      para++;
    if ((s = strchr(para, ',')) != NULL)
      *s = '\0';
    if (!*para)
      return;

    if (!check_channel_name(para))
    { 
      sendto_one(source_p, form_str(ERR_BADCHANNAME),
                 me.name, source_p->name, para);
      return;
    }

    if ((chptr = hash_find_channel(para)) != NULL)
      channel_member_names(source_p, chptr, 1, 0);
    else
      sendto_one(source_p, form_str(RPL_ENDOFNAMES),
		 me.name, source_p->name, para);
  }
  else
  {
    names_all_visible_channels(source_p);
    names_non_public_non_secret(source_p);
    sendto_one(source_p, form_str(RPL_ENDOFNAMES),
	       me.name, source_p->name, "*");
  }
}

/* parv[0] = sender prefix
 * parv[1] = channel
 */
static void
mo_onames(struct Client *client_p, struct Client *source_p,
          int parc, char *parv[])
{
  struct Channel *chptr = NULL;
  char *s, *para = parv[1];

  while (*para == ',')
    para++;

  if ((s = strchr(para, ',')) != NULL)
    *s = '\0';

  if (!*para)
    return;

  if (!check_channel_name(para))
  {
    sendto_one(source_p, form_str(ERR_BADCHANNAME),
               me.name, source_p->name, para);
    return;
  }

  if ((chptr = hash_find_channel(para)) != NULL)
  {
    channel_member_names(source_p, chptr, 1, 1);
    sendto_realops_flags(UMODE_SPY, L_ALL, "ONAMES '%s' by %s (%s@%s)",
                         para, source_p->name, source_p->username, source_p->host);
  }
  else
    sendto_one(source_p, form_str(ERR_NOSUCHCHANNEL),
               me.name, source_p->name, para);
}

/* inputs       - pointer to client struct requesting names
 * side effects - lists all visible channels whee!
 */
static void
names_all_visible_channels(struct Client *source_p)
{
  dlink_node *ptr;
  struct Channel *chptr;

  /* First, do all visible channels (public and the one user self is) */
  DLINK_FOREACH(ptr, global_channel_list.head)
  {
    chptr = ptr->data;
    /* Find users on same channel (defined by chptr) */
    channel_member_names(source_p, chptr, 0, 0);
  }
}

/* inputs       - pointer to client struct requesting names
 * side effects - lists all non public non secret channels
 */
static void
names_non_public_non_secret(struct Client *source_p)
{
  int mlen, tlen, cur_len, reply_to_send = 0, dont_show = 0;
  dlink_node *gcptr, *lp;
  struct Client *cptr;
  struct Channel *chptr2 = NULL;
  char buf[BUFSIZE], *t;

  mlen = ircsprintf(buf, form_str(RPL_NAMREPLY),
		    me.name, source_p->name, "*", "*");
  cur_len = mlen;
  t = buf + mlen;

  /* Second, do all non-public, non-secret channels in one big sweep */
  DLINK_FOREACH(gcptr, global_client_list.head)
  {
    cptr = gcptr->data;
    if (!IsPerson(cptr) || IsInvisible(cptr))
      continue;
    /* dont show a client if they are on a secret channel or
     * they are on a channel source_p is on since they have already
     * been shown earlier. -avalon
     */
    DLINK_FOREACH(lp, cptr->user->channel.head)
    {
      chptr2 = ((struct Membership *)lp->data)->chptr;

      if ((!PubChannel(chptr2) || IsMember(source_p, chptr2)) ||
          (SecretChannel(chptr2)))
      {
        dont_show = 1;
        break;
      }
    }
    if (dont_show) /* on any secret channels or shown already? */
      continue;

    if(lp == NULL)    /* Nothing to do. yay */
      continue;

    if ((cur_len + NICKLEN + 2)  > (BUFSIZE - 3))
    {
      sendto_one(source_p, "%s", buf);
      cur_len = mlen;
      t = buf + mlen;
    }
    ircsprintf(t, "%s%s ", get_member_status(find_channel_link(cptr, chptr2),
 	       				     0), cptr->name);
    tlen = strlen(t);
    cur_len += tlen;
    t += tlen;
    reply_to_send = 1;
  }
  if (reply_to_send)
    sendto_one(source_p, "%s", buf);
}
