/* Copyright (C) 2005 by MusIRCd Development.
 * $Id: m_topic.c,v 1.60 2005/01/27 11:48:02 musirc Exp $
 */

#include "handlers.h"
#include "client.h"
#include "channel.h"
#include "channel_mode.h"
#include "hash.h"
#include "istring.h"
#include "sprintf.h"
#include "ircd.h"
#include "numeric.h"
#include "send.h"
#include "server.h"
#include "config.h"
#include "modules.h"
#include "packet.h"

static void m_topic(struct Client *, struct Client *, int, char **);
static void ms_topic(struct Client *, struct Client *, int, char **);
static void mo_otopic(struct Client *, struct Client *, int, char **);
static void ms_tburst(struct Client *, struct Client *, int, char **);

struct Message topic_msgtab = {
  "TOPIC", 2, MFLG_SLOW,
  {m_unregistered, m_topic, ms_topic, m_topic}
};
struct Message otopic_msgtab = {
  "OTOPIC", 2, MFLG_SLOW,
  {m_ignore, m_ignore, m_ignore, mo_otopic}
};
struct Message tburst_msgtab = {
  "TBURST", 6, MFLG_SLOW,
  {m_ignore, m_ignore, ms_tburst, m_ignore}
};

#ifndef STATIC_MODULES
void
_modinit(void)
{
  mod_add_cmd(&topic_msgtab);
  mod_add_cmd(&otopic_msgtab);
  mod_add_cmd(&tburst_msgtab);
}

void
_moddeinit(void)
{
  mod_del_cmd(&topic_msgtab);
  mod_del_cmd(&tburst_msgtab);
  mod_del_cmd(&otopic_msgtab);
}

const char *_version = "$Revision: 1.60 $";
#endif

/* parv[0] = sender prefix
 * parv[1] = channel name
 * parv[2] = new topic, if setting topic
 */
static void
m_topic(struct Client *client_p, struct Client *source_p,
        int parc, char *parv[])
{
  struct Channel *chptr = NULL;
  char *p;
  struct Membership *ms;

  if ((p = strchr(parv[1], ',')) != NULL)
    *p = '\0';

  if (MyClient(source_p) && !IsFloodDone(source_p))
    flood_endgrace(source_p);

  if (IsChanPrefix(*parv[1]))
  {
    if ((chptr = hash_find_channel(parv[1])) == NULL)
    {
      sendto_one(source_p, form_str(ERR_NOSUCHCHANNEL),
                 me.name, source_p->name, parv[1]);
      return;
    }

    if (parc > 2)
    {
      if ((ms = find_channel_link(source_p, chptr)) == NULL)
      {
        sendto_one(source_p, form_str(ERR_NOTONCHANNEL), me.name,
                   source_p->name, parv[1]);
	return;
      }
      if ((chptr->mode.mode & MODE_TOPICLIMIT) == 0 ||
          has_member_flags(ms, CHFL_CHANOP|CHFL_HALFOP))
      {
        char topic_info[USERHOST_REPLYLEN];
        ircsprintf(topic_info, "%s", source_p->name);
        set_channel_topic(chptr, parv[2], topic_info, CurrentTime);

        sendto_server(client_p, chptr, ":%s TOPIC %s :%s",
                      source_p->name, chptr->name,
                      chptr->topic == NULL ? "" : chptr->topic);
        sendto_channel_local(ALL_MEMBERS,
                             chptr, ":%s TOPIC %s :%s",
                             source_p->name,
                             chptr->name, chptr->topic == NULL ?
                             "" : chptr->topic);
      }
      else
        sendto_one(source_p, form_str(ERR_CHANOPRIVSNEEDED),
                   me.name, source_p->name, parv[1]);
    }
    else /* only asking for topic */
    {
      if (!SecretChannel(chptr) || IsMember(source_p, chptr))
      {
        if (chptr->topic == NULL)
	  sendto_one(source_p, form_str(RPL_NOTOPIC),
                     me.name, source_p->name, parv[1]);
        else
        {
          sendto_one(source_p, form_str(RPL_TOPIC),
                     me.name, source_p->name,
                     chptr->name, chptr->topic);

          sendto_one(source_p, form_str(RPL_TOPICWHOTIME),
                     me.name, source_p->name, chptr->name,
                     chptr->topic_info, chptr->topic_time);
        }
      }
      else
      {
        sendto_one(source_p, form_str(ERR_NOTONCHANNEL),
                   me.name, source_p->name, parv[1]);
        return;
      }
    }
  }
  else
  {
    sendto_one(source_p, form_str(ERR_NOSUCHCHANNEL),
               me.name, source_p->name, parv[1]);
  }
}

/* parv[0] = sender prefix
 * parv[1] = channel name
 * parv[2] = topic_info
 * parv[3] = topic_info time
 * parv[4] = new channel topic
 */
static void
ms_topic(struct Client *client_p, struct Client *source_p,
         int parc, char *parv[])
{
  struct Channel *chptr = NULL;
  
  if (!IsServer(source_p))
  {
    m_topic(client_p, source_p, parc, parv);
    return;
  }

  if (parc < 5)
    return;

  if (parv[1] && IsChanPrefix(*parv[1]))
  {
    if ((chptr = hash_find_channel(parv[1])) == NULL)
      return;
      
    set_channel_topic(chptr, parv[4], parv[2], atoi(parv[3]));
    if (ConfigServerHide.hide_servers)
      sendto_channel_local(ALL_MEMBERS,
			   chptr, ":%s TOPIC %s :%s",
			   me.name, parv[1],
			   chptr->topic == NULL ? "" : chptr->topic);
    else
      sendto_channel_local(ALL_MEMBERS,
			   chptr, ":%s TOPIC %s :%s",
			   source_p->name, parv[1],
			   chptr->topic == NULL ? "" : chptr->topic);
  }
}

/* parv[0] = sender prefix
 * parv[1] = channel name
 */
static void
mo_otopic(struct Client *client_p, struct Client *source_p,
          int parc, char *parv[])
{
  struct Channel *chptr = NULL;

  if ((chptr = hash_find_channel(parv[1])) == NULL)
  {
    sendto_one(source_p, form_str(ERR_NOSUCHCHANNEL),
	       me.name, source_p->name, parv[1]);
    return;
  }

  if (chptr->topic == NULL)
    sendto_one(source_p, form_str(RPL_NOTOPIC),
	       me.name, source_p->name, chptr->name);
  else
  {
    sendto_one(source_p, form_str(RPL_TOPIC), me.name, source_p->name,
               chptr->name, chptr->topic);
    sendto_one(source_p, form_str(RPL_TOPICWHOTIME), me.name,
               source_p->name, chptr->name, chptr->topic_info,
               chptr->topic_time);
  }
  sendto_realops_flags(UMODE_SPY, L_ALL, "OTOPIC '%s' by %s (%s@%s)",
                       chptr->name, source_p->name, source_p->username,
                       source_p->host);
}

/* parv[0] = sender prefix
 * parv[1] = channel timestamp
 * parv[2] = channel
 * parv[3] = topic timestamp
 * parv[4] = topic setter
 * parv[5] = topic
 */
static void
ms_tburst(struct Client *client_p, struct Client *source_p,
          int parc, char *parv[])
{
  struct Channel *chptr;
  time_t oldchannelts = atol(parv[1]), oldtopicts = atol(parv[3]);
  const char *topicwho = parv[4], *topic = parv[5];

  if (!(chptr = hash_find_channel(parv[2])))
    return;

  if ((chptr->topic != NULL) && !strcmp(chptr->topic, topic))
    return;

  if ((oldchannelts <= chptr->channelts) &&
      ((chptr->topic == NULL) || (oldtopicts > chptr->topic_time)))
  {
    set_channel_topic(chptr, topic, topicwho, oldtopicts);
    sendto_channel_local(ALL_MEMBERS, chptr, ":%s TOPIC %s :%s",
                         ConfigServerHide.hide_servers ? me.name : source_p->name,
                         chptr->name, chptr->topic == NULL ?
                         "" : chptr->topic);
    sendto_server(source_p, chptr, ":%s TBURST %ld %s %ld %s :%s",
                  source_p->name, (unsigned long)chptr->channelts, chptr->name,
                  (unsigned long)chptr->topic_time,
                  chptr->topic_info == NULL ? "" : chptr->topic_info,
                  chptr->topic == NULL ? "" : chptr->topic);
  }
}
