/* m_users.c: Gives some basic user statistics.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: m_users.c,v 1.55 2005/01/27 11:48:02 musirc Exp $
 */

#include "handlers.h"
#include "client.h"
#include "istring.h"
#include "sprintf.h"
#include "ircd.h"
#include "numeric.h"
#include "server.h"
#include "user.h"
#include "config.h"
#include "send.h"
#include "modules.h"
#include "log.h"

static char buf[BUFSIZE];
static void m_userhost(struct Client *, struct Client *, int, char **);
static void mr_user(struct Client *, struct Client *, int, char **);

struct Message userhost_msgtab = {
  "USERHOST", 1, MFLG_SLOW,
  {m_unregistered, m_userhost, m_userhost, m_userhost}
};
struct Message user_msgtab = {
  "USER", 5, MFLG_SLOW,
  {mr_user, m_registered, m_ignore, m_registered}
};

#ifndef STATIC_MODULES
void
_modinit(void)
{
  mod_add_cmd(&userhost_msgtab);
  mod_add_cmd(&user_msgtab);
}

void
_moddeinit(void)
{
  mod_del_cmd(&userhost_msgtab);
  mod_del_cmd(&user_msgtab);
}

const char *_version = "$Revision: 1.55 $";
#endif

static void
m_userhost(struct Client *client_p, struct Client *source_p,
           int parc, char *parv[])
{
  struct Client *target_p;
  char response[NICKLEN*2+USERLEN+HOSTLEN+30], *t;
  int i, cur_len, rl;

  cur_len = ircsprintf(buf,form_str(RPL_USERHOST),me.name, parv[0], "");
  t = buf + cur_len;

  for ( i = 0; i < 5; i++)
  {
    if (parv[i+1] == NULL)
      break;

    if ((target_p = find_person(parv[i+1])) != NULL)
    {
      /* Show real IP for USERHOST on yourself.
       * This is needed for things like mIRC, which do a server-based
       * lookup (USERHOST) to figure out what the clients' local IP
       * is.  Useful for things like NAT, and dynamic dial-up users.
       */
      if (MyClient(target_p) && (target_p == source_p))
        rl = ircsprintf(response, "%s%s=%c%s@%s ",
                        target_p->name, IsOper(target_p) ? "*" : "",
                        (target_p->user->away) ? '-' : '+',
                        target_p->username, target_p->localClient->sockhost);
      else
        rl = ircsprintf(response, "%s%s=%c%s@%s ",
                        target_p->name, IsOper(target_p) ? "*" : "",
                        (target_p->user->away) ? '-' : '+',
                        target_p->username, target_p->host);
      if((rl + cur_len) < (BUFSIZE-10))
      {
        ircsprintf(t,"%s",response);
        t += rl;
        cur_len += rl;
      }
      else
        break;
    }
  }
  sendto_one(source_p, "%s", buf);
}

/* parv[0] = sender prefix
 * parv[1] = username (login name, account)
 * parv[2] = client host name (used only from other servers)
 * parv[3] = server host name (used only from other servers)
 * parv[4] = users real name info
 */
static void
mr_user(struct Client* client_p, struct Client* source_p,
        int parc, char *parv[])
{
  char *p;

  if ((p = strchr(parv[1],'@')) != NULL)
    *p = '\0';

  if (ConfigFileEntry.drone_detect)
  {
    char *name = NULL;
    unsigned int len;

    len = strlen(parv[4]) + 3;
    name = MyMalloc(len + 1);
    snprintf(name, len, "\"%s\"", parv[4]);

    if (!strcmp(parv[4], source_p->localClient->sockhost) ||
	!strcmp(parv[2], name) || !strcmp(parv[4], "*"))
    {
      if (ConfigFileEntry.autodline_drones)
      {
        struct ConfItem *conf;
        struct AccessItem *aconf;

        conf = make_conf_item(DLINE_TYPE);
        aconf = (struct AccessItem *)map_to_conf(conf);
        DupString(aconf->host, source_p->localClient->sockhost);
        DupString(aconf->reason, "Drones");
	if (!strcmp(parv[4], "*"))
 	  DupString(aconf->oper_reason, "Auto D-Line for * as gecos");
	else
	  DupString(aconf->oper_reason, "Auto D-Line for matching ip/gecos");
        aconf->hold = CurrentTime + ConfigFileEntry.drone_dline_time;
        exit_client(client_p, source_p, source_p, "D-Lined");
        add_tdline(aconf);
        sendto_realops_flags(UMODE_ALL, L_ALL, "AUTODLINE: %d min. D-Line %s for matching ip/gecos",
                             ConfigFileEntry.drone_dline_time/60,
                             source_p->localClient->sockhost);
        ilog(TRACE, "AUTODLINE: %d min. D-Line %s for matching ip/gecos",
             ConfigFileEntry.drone_dline_time/60,
             source_p->localClient->sockhost);
      }
      exit_client(client_p, source_p, source_p, "Drone Autokill");
      MyFree(name);
      return;
    }
    MyFree(name);
  }
  do_local_user(parv[0], client_p, source_p,
                parv[1],        /* username */
                parv[2],        /* host */
                parv[3],        /* server */
                parv[4] /* users real name */ );
}
