/* m_wallops.c: Sends a message to all operators.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: m_wallops.c,v 1.27 2005/01/27 11:48:02 musirc Exp $
 */

#include "handlers.h"
#include "ircd.h"
#include "istring.h"
#include "numeric.h"
#include "send.h"
#include "config.h"
#include "server.h"
#include "modules.h"

static void ms_wallops(struct Client *, struct Client *, int, char **);
static void mo_wallops(struct Client *, struct Client *, int, char **);
static void m_locops(struct Client *, struct Client *, int, char **);

struct Message wallops_msgtab = {
  "WALLOPS", 2, MFLG_SLOW,
  {m_unregistered, m_not_oper, ms_wallops, mo_wallops}
};
struct Message locops_msgtab = {
  "LOCOPS", 2, MFLG_SLOW,
  {m_unregistered, m_not_oper, m_ignore, m_locops}
};

#ifndef STATIC_MODULES
void
_modinit(void)
{
  mod_add_cmd(&wallops_msgtab);
  mod_add_cmd(&locops_msgtab);
}

void
_moddeinit(void)
{
  mod_del_cmd(&wallops_msgtab);
  mod_del_cmd(&locops_msgtab);
} 
const char *_version = "$Revision: 1.27 $";
#endif

/* parv[0] = sender prefix
 * parv[1] = message text
 */
static void
mo_wallops(struct Client *client_p, struct Client *source_p,
           int parc, char *parv[])
{ 
  sendto_wallops_flags(UMODE_WALLOP, source_p, "WALLOPS - %s", parv[1]);
  sendto_server(NULL, NULL, ":%s WALLOPS :%s", source_p->name, parv[1]);
}

/* parv[0] = sender prefix
 * parv[1] = message text
 */
static void
ms_wallops(struct Client *client_p, struct Client *source_p,
           int parc, char *parv[])
{
  if (EmptyString(parv[1]))
    return;

  if (IsClient(source_p))
    sendto_wallops_flags(UMODE_WALLOP, source_p, "WALLOPS - %s", parv[1]);
  else
    sendto_wallops_flags(UMODE_WALLOP, source_p, "%s", parv[1]);

  sendto_server(client_p, NULL, ":%s WALLOPS :%s", source_p->name, parv[1]);
}

/* parv[0] = sender prefix
 * parv[1] = message text
 */
static void
m_locops(struct Client *client_p, struct Client *source_p,
         int parc, char *parv[])
{
  sendto_wallops_flags(UMODE_LOCOPS, source_p, "LOCOPS - %s", parv[1]);
}
