/* fdlist.c: Maintains a list of file descriptors.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: fdlist.c,v 1.25 2005/01/27 11:48:04 musirc Exp $
 */

#include "fdlist.h"
#include "client.h"
#include "istring.h"
#include "ircd.h"
#include "bsd.h"
#include "send.h"
#include "numeric.h"

fde_t *fd_table = NULL;
static void fdlist_update_biggest(int);
int highest_fd = -1, number_fd = 0;

static void
fdlist_update_biggest(int fd)
{ 
  if (fd < highest_fd)
    return;

  if (fd > highest_fd)
  {
    highest_fd = fd;
    return;
  }
  while (highest_fd >= 0 && !fd_table[highest_fd].flags.open)
    highest_fd--;
}

void
fdlist_init(void)
{
  static int initialized = 0;

  if (!initialized)
  {
    /* Since we're doing this once .. */
    fd_table = MyMalloc((HARD_FDLIMIT + 1) * sizeof(fde_t));
    initialized = 1;
  }
}

void
fd_open(int fd, unsigned int type, const char *desc)
{
  fde_t *F = &fd_table[fd];
  
  if (F->flags.open)
      fd_close(fd);

  F->fd = fd;
  F->type = type;
  F->flags.open = 1;
  fdlist_update_biggest(fd);
  F->comm_index = -1;
  F->list = FDLIST_NONE;
  if (desc)
    strlcpy(F->desc, desc, sizeof(F->desc));
  number_fd++;
}

void
fd_close(int fd)
{
  fde_t *F = &fd_table[fd];
  comm_setselect(fd, FDLIST_NONE, COMM_SELECT_WRITE|COMM_SELECT_READ,
		 NULL, NULL, 0);

  if (F->dns_query != NULL)
  {
    delete_resolver_queries(F->dns_query);
    MyFree(F->dns_query);
    F->dns_query = NULL;
  }
  F->flags.open = 0;
  fdlist_update_biggest(fd);
  number_fd--;
  memset(F, '\0', sizeof(fde_t));
  F->timeout = 0;
  close(fd);
}
