/* getopt.c: Uses getopt to fetch the command line options.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: getopt.c,v 1.12 2005/01/27 11:48:04 musirc Exp $
 */

#include "stdinc.h"
#include "getopts.h"

#define OPTCHAR '-'

static void usage(const char *);

void
parseargs(int *argc, char ***argv, struct lgetopt *opts)
{
  int i;
  char *progname = (*argv)[0];

  /* loop through each argument */
  for (;;)
  {
    int found = 0;

    (*argc)--;
    (*argv)++;
      
    if (*argc < 1)
      return;
      
      /* check if it *is* an arg.. */
    if ((*argv)[0][0] != OPTCHAR)
      return;
      
    (*argv)[0]++;

    /* search through our argument list, and see if it matches */
    for (i = 0; opts[i].opt; i++) 
    {
      if (!strcmp(opts[i].opt, (*argv)[0]))
      {
        /* found our argument */
        found = 1;

        switch (opts[i].argtype)
	{
	  case YESNO:
	  *((int *)opts[i].argloc) = 1;
	  break;
          case INTEGER:
          if (*argc < 2)
          {
            fprintf(stderr, "Error: option '%c%s' requires an argument\n",
                    OPTCHAR, opts[i].opt);
  		    usage((*argv)[0]);
          }
          *((int *)opts[i].argloc) = atoi((*argv)[1]);
	  (*argc)--;
	  (*argv)++;
          break;
          case STRING:
          if (*argc < 2)
          {
            fprintf(stderr, "error: option '%c%s' requires an argument\n",
                    OPTCHAR, opts[i].opt);
                    usage(progname);
          }
	  *((char**)opts[i].argloc) = malloc(strlen((*argv)[1]) + 1);
	  strcpy(*((char**)opts[i].argloc), (*argv)[1]);
	  (*argc)--;
	  (*argv)++;
	  break;

	  case USAGE:
	  usage(progname);
	  /*NOTREACHED*/

	  default:
	  fprintf(stderr, "Error: internal error in parseargs() at %s:%d\n",
		__FILE__, __LINE__);
	  exit(EXIT_FAILURE);
	}
      }
    }
    if (!found)
    {
      fprintf(stderr, "error: unknown argument '%c%s'\n", OPTCHAR, (*argv)[0]);
      usage(progname);
    }
  }
}

static void 
usage(const char *name)
{
  int i;
  
  fprintf(stderr, "Usage: %s [options]\n", name);
  fprintf(stderr, "Where valid options are:\n");
  
  for (i = 0; myopts[i].opt; i++)
  {
    fprintf(stderr, "\t%c%-10s %-20s%s\n", OPTCHAR, myopts[i].opt, 
	   (myopts[i].argtype == YESNO || myopts[i].argtype == USAGE) ? "" : 
           myopts[i].argtype == INTEGER ? "<number>" : "<string>",
           myopts[i].desc);
  }
  
  exit(EXIT_FAILURE);
}
