/* memory.c: Memory utilities.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: memory.c,v 1.12 2005/01/27 11:48:05 musirc Exp $
 */

#define WE_ARE_MEMORY_C

#include "memory.h"
#include "log.h"
#include "restart.h"

void *
MyMalloc(size_t size)
{
  void *ret = calloc(1, size);
  if (ret == NULL)
    outofmemory();
  return(ret);
}

void *
MyRealloc(void *x, size_t y)
{
  void *ret = realloc(x, y);

  if (ret == NULL)
    outofmemory();
  return(ret);
}

void
MyFree(void *x)
{
  if (x)
    free(x);
}

void
_DupString(char **x, const char *y)
{
  (*x) = malloc(strlen(y) + 1);
  strcpy((*x), y);
}

/* side effects - simply try to report there is a problem.
 *		  Abort if it was called more than once
 */
void
outofmemory(void)
{
  static int was_here = 0;

  if (was_here)
    abort();

  was_here = 1;

  ilog(CRIT, "Out of memory: restarting server...");
  restart("Out of Memory");
}
