/* motd.c: Message of the day.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: motd.c,v 1.24 2005/01/27 11:48:05 musirc Exp $
 */

#include "motd.h"
#include "ircd.h"
#include "config.h"
#include "send.h"
#include "numeric.h"
#include "istring.h"
#include "sprintf.h"
#include "server.h"

void
init_message_file(MotdType motdType, const char *fileName, MessageFile *motd)
{
  strlcpy(motd->fileName, fileName, sizeof(motd->fileName));
  motd->motdType = motdType;
  motd->contentsOfFile = NULL;
}

/* This function split off so a server notice could be generated on a
 * user requested motd, but not on each connecting client. 
 */
int
send_message_file(struct Client *source_p, MessageFile *motdToPrint)
{
  MessageFileLine *linePointer;
  MotdType motdType;

  if (motdToPrint == NULL)
   return(-1);

  motdType = motdToPrint->motdType;

  switch (motdType)
  {
    case USER_MOTD:
      if (motdToPrint->contentsOfFile == NULL)
      {
        sendto_one(source_p, form_str(ERR_NOMOTD),
                   me.name, source_p->name);
        return(0);
      }

      sendto_one(source_p, form_str(RPL_MOTDSTART),
                 me.name, source_p->name, me.name);

      for (linePointer = motdToPrint->contentsOfFile; linePointer;
           linePointer = linePointer->next)
      {
        sendto_one(source_p, form_str(RPL_MOTD),
                   me.name, source_p->name, linePointer->line);
      }

      sendto_one(source_p, form_str(RPL_ENDOFMOTD), me.name, source_p->name);
      return(0);
      break;

    case USER_LINKS:
      if (motdToPrint->contentsOfFile == NULL)
        return(-1);

      for (linePointer = motdToPrint->contentsOfFile; linePointer;
           linePointer = linePointer->next)
        sendto_one(source_p, ":%s 364 %s %s",
                   me.name, source_p->name, linePointer->line);

      return(0);
      break;

    case OPER_MOTD:
      if (motdToPrint->contentsOfFile == NULL)
        return(-1);

      sendto_one(source_p, form_str(RPL_OMOTDSTART),
                 me.name, source_p->name);
      break;

    default:
      return(0);
  }

  for (linePointer = motdToPrint->contentsOfFile; linePointer;
       linePointer = linePointer->next)
    sendto_one(source_p, form_str(RPL_OMOTD),
               me.name, source_p->name, linePointer->line);

  sendto_one(source_p, form_str(RPL_ENDOFOMOTD), me.name, source_p->name);
  return(0);
}

/* inputs - pointer to MessageFileptr */
int 
read_message_file(MessageFile *MessageFileptr)
{
  struct stat sb;
  MessageFileLine *mptr = 0, *next_mptr = 0, *newMessageLine = 0, *currentMessageLine = 0;
  char buffer[MESSAGELINELEN], *p;
  FBFILE *file;

  for (mptr = MessageFileptr->contentsOfFile; mptr; mptr = next_mptr)
  {
    next_mptr = mptr->next;
    MyFree(mptr);
  }

  MessageFileptr->contentsOfFile = NULL;
  if (stat(MessageFileptr->fileName, &sb) < 0)
    return(-1);

  if ((file = fbopen(MessageFileptr->fileName, "r")) == NULL)
    return(-1);

  while (fbgets(buffer, sizeof(buffer), file))
  {
    if ((p = strchr(buffer, '\n')) != NULL)
      *p = '\0';
    newMessageLine = (MessageFileLine *)MyMalloc(sizeof(MessageFileLine));

    strlcpy(newMessageLine->line, buffer, sizeof(newMessageLine->line));
    newMessageLine->next = NULL;
 
    if (MessageFileptr->contentsOfFile != NULL)
    {
      if (currentMessageLine)
        currentMessageLine->next = newMessageLine;

      currentMessageLine = newMessageLine;
    }
    else
    {
      MessageFileptr->contentsOfFile = newMessageLine;
      currentMessageLine = newMessageLine;
    }
  }

  fbclose(file);
  return(0);
}
