/* restart.c: Functions to allow the ircd to restart.
 * Copyright (C) 2005 by MusIRCd Development.
 * $Id: restart.c,v 1.16 2005/01/27 11:48:05 musirc Exp $
 */

#include "restart.h"
#include "ircd.h"
#include "send.h"
#include "log.h"
#include "client.h"

void
restart(const char *mesg)
{
  static int was_here = 0; /* redundant due to restarting flag below */

  if (was_here)
    abort();
  was_here = 1;

  ilog(NOTICE, "Restarting Server because: %s, memory data limit: %ld",
         mesg, get_maxrss());
  server_reboot();
}

void
server_reboot(void)
{
  int i;
  write_stats();
  sendto_realops_flags(UMODE_ALL, L_ALL, "Restarting server...");
  ilog(NOTICE, "Restarting server... (%s)", SPATH);
  send_queued_all();
  for (i = 3; i < HARD_FDLIMIT; ++i)
    close(i);
  unlink(pidFileName);
  execv(SPATH, myargv);
  fprintf(stderr, "ircd: execv() failed: %s\n",
	  strerror(errno));
  exit(-1);
}
