/* Copyright (C) 2005 by MusIRCd Development
 * $Id: signal.c,v 1.8 2005/01/27 11:48:05 musirc Exp $
 */

#include "ircd.h"
#include "restart.h"
#include "log.h"

/* exit the server */
static void 
sigterm_handler(int n)  
{
  write_stats();
  ilog(CRIT, "Server killed By SIGTERM");
  exit(-1);
}
  
/* reread the server configuration */
static void 
sighup_handler(int n)
{
  dorehash = 1;
}

/* reread the motd file */
static void
sigusr1_handler(int n)
{
  doremotd = 1;
}

/* side effects - Reaps zombies periodically */
static void
sigchld_handler(int n)
{
  int status;
  waitpid(-1, &status, WNOHANG);
}

/* sigint_handler - restart the server */
static void 
sigint_handler(int n)
{
  static int restarting = 0;

  if (server_state.foreground) 
  {
    ilog(WARN, "Server exiting on SIGINT");
    exit(0);
  }
  else
  {
    ilog(WARN, "Server Restarting on SIGINT");
    if (restarting == 0) 
    {
      restarting = 1;
      server_reboot();
    }
  }
}

/* initialize signal handlers for server */
void 
setup_signals()
{
  struct sigaction act;

  act.sa_flags = 0;
  act.sa_handler = SIG_IGN;
  sigemptyset(&act.sa_mask);
  sigaddset(&act.sa_mask, SIGPIPE);
  sigaddset(&act.sa_mask, SIGALRM);
#ifdef SIGTRAP
  sigaddset(&act.sa_mask, SIGTRAP);
#endif

#ifdef SIGWINCH
  sigaddset(&act.sa_mask, SIGWINCH);
  sigaction(SIGWINCH, &act, 0);
#endif
  sigaction(SIGPIPE, &act, 0);
#ifdef SIGTRAP
  sigaction(SIGTRAP, &act, 0);
#endif
  sigaction(SIGALRM, &act, 0);

  act.sa_handler = sighup_handler;
  sigemptyset(&act.sa_mask);
  sigaddset(&act.sa_mask, SIGHUP);
  sigaction(SIGHUP, &act, 0);

  act.sa_handler = sigint_handler;
  sigaddset(&act.sa_mask, SIGINT);
  sigaction(SIGINT, &act, 0);

  act.sa_handler = sigterm_handler;
  sigaddset(&act.sa_mask, SIGTERM);
  sigaction(SIGTERM, &act, 0);

  act.sa_handler = sigusr1_handler;
  sigaddset(&act.sa_mask, SIGUSR1);
  sigaction(SIGUSR1, &act, 0);
  
  act.sa_handler = sigchld_handler;
  sigaddset(&act.sa_mask, SIGCHLD);
  sigaction(SIGCHLD, &act, 0);
}
