/* Services configuration.
 *
 * SirvNET Services is copyright (c) 1998-2001 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * Originally based on EsperNet Services(c) by Andy Church.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#ifndef CONFIG_H
#define CONFIG_H


/* Should we try and deal with old (v2.x) databases?  (Don't undefine this
 * unless you know what you're doing!) */
#define COMPATIBILITY_V2

/******* General configuration *******/

#define CONFIG_FILE "../services.conf"
#define O_CONFIG_FILE "../oper.conf"

/******* End of runtime-configurable options. *******/

/* Log filename in services directory */
#define LOG_FILENAME    "./logs/debug.log"

/* File for Message of the Day (/motd command) */
#define MOTD_FILENAME   "./logs/services.motd"

#define SERVICES_SIG    "../services.sig"
#define CUSTOM_AUTH      "../auth.email"

/* Database filenames */
#define NICKSERV_DB	"nick.db"
#define CHANSERV_DB	"chan.db"
#define MEMOSERV_DB	"memo.db"
#define OS_SA_DB	"os_sa.db"
#define OS_SRA_DB       "os_sra.db"
#define OS_SOP_DB       "os_sop.db"
#define OS_HOP_DB       "os_hop.db"
#define AKILL_DB	"akill.db"
#define AUTOKILL_DB     "nick_kill.db"
#define IGNORE_DB       "ignore.db"
#define JUPE_DB         "jupe.db"
#define QLINE_DB        "qline.db"
#define GLINE_DB        "gline.db"
#define ZLINE_DB        "zline.db"
#define AT_DB		"abuse.db"
#define TRIGGER_DB	"trigger.db"
#define SENDLOG_DB      "sendlog.db"
#define LOG_DB          "log.db"
#define EMAIL_DB        "email.db"

/* If you don't mind Services not being able to make a backup of database
 * while writing them, define this; this can allow Services to continue
 * operation under some conditions when it might otherwise fail.  (Note
 * that this can cause data loss under some error conditions, so make SURE
 * you know what you're doing if you define it!) */
/* #define NO_BACKUP_OKAY */

/* File containing process ID */
#define PID_FILE	"services.pid"

/******* Services pseudo-client names *******/

#define ROOTSERV2_NAME          "RootServ2"
#define OPERSERV2_NAME          "OperServ2"
#define ABUSESERV_NAME		"AbuseServ"


/******* NickServ configuration *******/

/* Minimum number of seconds between consecutive uses of the REGISTER
 * command.  Set to 0 to disable this limit.
 */

/* How often to update last-seen times for all users currently online, in
 * seconds.  Set to 0 to disable automatic checking.  (You probably want to
 * set this really high, like a day or more, or else disable it, if your
 * network has more than 5,000 users online at once or more than 100,000
 * registered nicks; but be aware that if you disable it, anyone who stays
 * logged on longer than the expiration period will lose their nick.)
 */
#define NS_LAST_SEEN_DELAY (60*60)

/******* OperServ configuration *******/

/* How big a hostname list do we keep for clone detection?  On large nets
 * (over 500 simultaneous users or so), you may want to increase this. */
#define CLONE_DETECT_SIZE 60

/* How much time (in seconds) has to elapse between successive users
 * before we decide they're not clones? */
#define CLONE_MAX_DELAY 60

/* Send a wallops if a non-oper tries to use OperServ? */
#define WARN_BAD_OPERSERV


/***** AbuseServ Config ********/

#define MAX_ABUSE 10

/******* Miscellaneous - it should be save to leave these untouched *******/

#define MAX_SENDLOGS 32

#define CHANMAX  64
#define NICKMAX  32
#define PASSMAX  32
#define MAX_IDS  32

#define MAX_SERVROOTS   32
#define MAX_SERVADMINS  32
#define MAX_SERVOPERS   32
#define MAX_HELPOPS     32

/* Size of input buffer (note: this is different from BUFSIZ) */
#define BUFSIZE		1024


/**************************************************************************/

/* System-specific defines */
#include "sysconf.h"

#if !HAVE_STRICMP && HAVE_STRCASECMP
# define stricmp strcasecmp
# define strnicmp strncasecmp
#endif

#endif	/* CONFIG_H */
