/* Prototypes and external variable declarations.
 *
 * SirvNET Services is copyright (c) 1998-2001 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * Originally based on EsperNet Services(c) by Andy Church.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#ifndef EXTERN_H
#define EXTERN_H

#define getrandom(min, max) ((rand() % (int)(((max)+1) - (min))) + (min))
#define E extern

E Channel *chanlist;

#define encrypt _encrypt


/**** channels.c ****/

E void load_sjoin_mem();
E void do_sjoin(char *source, int ac, char **av);
E void get_channel_stats(long *nrec, long *memuse);
E Channel *findchan(const char *chan);
E void chan_adduser(User *user, const char *chan);
E void chan_deluser(User *user, Channel *c);
E void do_cmode(const char *source, int ac, char **av);
E void do_topic(const char *source, int ac, char **av);
E int only_one_user(const char *chan);
E int isin_chan(char *nick, const char *chan);

/**** chanserv.c ****/

E void listchans(int count_only, const char *chan);
E void get_chanserv_stats(long *nrec, long *memuse);

E void chanserv(const char *source, char *buf);
E void load_cs_dbase(void);
E void save_cs_dbase(void);
E void check_modes(const char *chan);
E int check_valid_op(User *user, const char *chan, int newchan);
E void inline check_welcome(User *user, const char *chan);
E int check_should_op(User *user, const char *chan);
E int check_should_voice(User *user, const char *chan);
E int check_akick(User *user, const char *chan);
E void record_topic(const char *chan);
E void restore_topic(const char *chan);
E int check_topiclock(const char *source, const char *chan);
E void check_temp_os(User *u);
E void expire_chans(void);
E void cs_remove_nick(const char *nick);
E ChannelInfo *cs_findchan(const char *chan);
E int check_access(User *user, ChannelInfo *ci, int what);
E int get_access(User *user, ChannelInfo *ci);
E int check_opguard(User *user, const char *chan);
E int check_invite(User *user, const char *chan);

/**** datafiles.c ****/

E void check_file_version(FILE *f, const char *filename);
E int write_file_version(FILE *f, const char *filename);
E FILE *open_db(const char *service, const char *filename, const char *mode);
E void close_db(FILE *dbfile, const char *filename);
E void show_next_db(const char *source, const char *service);
E void show_u_next_db(User *u, const char *service);
E void backup_database();

/**** helpserv.c ****/

E void helpserv(const char *whoami, const char *source, char *buf);


/**** list.c ****/

E void do_listnicks(int ac, char **av);
E void do_listchans(int ac, char **av);


/**** main.c ****/

E char *services_dir;
E short snoop;
E short snooplog_okay;
E short sndebug;
E short debug;
E short sendstat;
E short nofork;
E short op_checking;
E unsigned long dbcnt;
E short backdb;
#if REG_SAVES > 0
E short regcnt;
#endif
E int news_size;
E short FIX_NSDB;
E char *snchan;
E char *snnick;
E short DISPLAY_UPDATES;

E int quitting;
E int delayed_quit;
E char *quitmsg;
E char inbuf[BUFSIZE];
E int servsock;
E int save_data;
E int got_alarm;
E time_t start_time;
E time_t d_check_time;
E time_t h_check_time;
E time_t m_check_time;
E time_t last_update;

E void fatal(const char *fmt,...);
E void fatal_perror(const char *fmt,...);
E void introduce_users(const char *);


/**** memory.c ****/

E void *smalloc(long size);
E void *scalloc(long elsize, long els);
E void *srealloc(void *oldptr, long newsize);
E char *sstrdup(const char *s);


/**** memoserv.c ****/

E void get_memoserv_stats(long *nrec, long *memuse);

E void memoserv(const char *source, char *buf);
E void load_ms_dbase(void);
E void save_ms_dbase(void);
E void check_memos(const char *nick);
E void clear_memos(const char *nick);
E void expire_memos(void);
E void check_del_memos(User *user);
E void sendpass_ns(const char *source, NickInfo *ni);
E void sendpass_cs(const char *source, ChannelInfo *ci);

/**** messages.c ****/

E unsigned long serv_com;
E unsigned long day_serv_com;
E unsigned long hour_serv_com;
E unsigned long min_serv_com;

/**** misc.c ****/

E char *sgets2(char *buf, long size, int sock);
E char *strscpy(char *d, const char *s, size_t len);
#if !HAVE_SNPRINTF
# if BAD_SNPRINTF
#  define vsnprintf my_vsnprintf
#  define snprintf my_snprintf
# endif
E int vsnprintf(char *buf, size_t size, const char *fmt, va_list args);
E int snprintf(char *buf, size_t size, const char *fmt, ...);
#endif
#if !HAVE_STRICMP && !HAVE_STRCASECMP
E int stricmp(const char *s1, const char *s2);
E int strnicmp(const char *s1, const char *s2, size_t len);
#endif
#if !HAVE_STRDUP
E char *strdup(const char *s);
#endif
#if !HAVE_STRSPN
E size_t strspn(const char *s, const char *accept);
#endif
E char *stristr(char *s1, char *s2);
#if !HAVE_STRERROR
E char *strerror(int errnum);
#endif
#if !HAVE_STRSIGNAL
char *strsignal(int signum);
#endif
E char *merge_args(int argc, char **argv);
E int match_wild(const char *pattern, const char *str);
E int match_wild_nocase(const char *pattern, const char *str);
E char *month_name(int month);
E char *strupper(char *s);
E char *strlower(char *s);
E char *read_string(FILE *f, const char *filename);
E char *write_string(const char *s, FILE *f, const char *filename);
E int check_servii_kill (const char *source, int ac, char **av);
E void load_sigfile();
E void custom_auth();

/**** nickserv.c ****/

E void listnicks(int count_only, const char *nick);
E void get_nickserv_stats(long *nrec, long *memuse);
E int is_on_access(User *u, NickInfo *ni);
E char *get_os_access(NickInfo *ni);

E void nickserv(const char *source, char *buf);
E void load_ns_dbase(void);
E void save_ns_dbase(void);
E int validate_user(User *u);
E void cancel_user(User *u);
E void expire_nicks(void);
E NickInfo *findnick(const char *nick);
E NickInfo *retnick(int i);

/**** operserv.c ****/

E char *sendlogs[MAX_SENDLOGS];
E void expire_admins();

E void operserv(const char *source, char *buf);
E void load_os_dbase(void);
E void save_os_dbase(void);
E int is_services_coder(const char *nick);
E int is_services_root(const char *nick);
E int is_services_admin(const char *nick);
E int is_services_oper(const char *nick);
E int is_services_helpop(const char *nick);
E int rec_services_root(const char *nick);
E int rec_services_admin(const char *nick);
E int rec_services_oper(const char *nick);
E int rec_services_coder(const char *nick);
E int is_autokilled(const char *nick);
E void os_remove_nick(const char *nick);
E void load_akill(void);
E void save_akill(void);
E void load_trigger(void);
E void save_trigger(void);
E void load_autokill(void);
E void save_autokill(void);
E int check_akill(const char *nick, const char *username, const char *host);
E int check_ignore(const char *nick, const char *username, const char *host);
E void check_jupes();
E void check_qlines();
E void check_slines();
E void check_zlines();
E void check_del_clones(User *user);
E void check_jupe_squit(char *source, char *server);
E void add_ignore(const char *mask, const char *who, const char *expiry);
E void check_clones(User *user);


/**** process.c ****/

E C_SuspendData *c_suspend[];

E void m_version(char *source, int ac, char **av);
E int do_update_flood(User *u, unsigned short idflood);
E C_SuspendData *get_c_suspend(const char *chan);
E void add_c_suspend(const char *chan, time_t delta);
E int split_buf(char *buf, char ***argv, int colon_special);
E void process(void);


/**** send.c ****/

E void send_cmd(const char *source, const char *fmt, ...);
E void vsend_cmd(const char *source, const char *fmt, va_list args);
E void wallops(const char *source, const char *fmt, ...);
E void chatops(const char *source, const char *fmt, ...);
E void notice(const char *source, const char *dest, const char *fmt, ...);
E void notice_list(const char *source, const char *dest, const char **text);
E void privmsg(const char *source, const char *dest, const char *fmt, ...);


/**** sockutil.c ****/

E int sgetc(int s);
E char *sgets(char *buf, unsigned int len, int s);
E int inline sputs(char *str, int s);
E int sockprintf(int s, char *fmt,...);
E int conn(char *host, int port);
E void disconn(int s);


/**** users.c ****/

E unsigned int usercnt, opcnt, maxusercnt;

E void get_user_stats(long *nusers, long *memuse);
E User *finduser(const char *nick);
E User *first_user(void);

E int is_on_id_list(const char *source, const char *nick);

E void delete_user(User *user);
E void do_nick(const char *source, int ac, char **av);
E void do_join(const char *source, int ac, char **av);
E void do_part(const char *source, int ac, char **av);
E void do_kick(const char *source, int ac, char **av);
E void do_umode(const char *source, int ac, char **av);
E void do_quit(const char *source, int ac, char **av);
E void do_kill(const char *source, int ac, char **av);

E int inline is_oper(const char *nick);
E int is_on_chan(const char *nick, const char *chan);
E int is_chanop(const char *nick, const char *chan);
E int is_voiced(const char *nick, const char *chan);

E int match_usermask(const char *mask, User *user);
E void split_usermask(const char *mask, char **nick, char **user, char **host);
E char *create_mask(User *u);
E void mass_check_akill();
E int check_akill_num(char *mask);
E int check_ignore_num(const char *mask);
E User *userlist;

/****************** AbuseServ ***********************/

E const char s_AbuseServ[];
E void abuseserv(const char *source, char *buf);
E int is_abuse(const char *nick);
E int rec_abuse(const char *nick);
E void load_at_db(void);
E void save_at_db(void);

/**** taglines.c ****/

E void do_tagline(void);


/**** log.c ****/

E FILE *logfile;
E FILE *slogfile;
E FILE *templog;

E char *log_filename;

E void log(const char *fmt,...);
E void slog(const char *fmt,...);
E void log_perror(const char *fmt,...);

E void do_break_log(const char *service, const char *fmt, ...);
E void check_logs();

E void load_log_db(void);
E void save_log_db(void);
E void load_sendlogs();
E void save_sendlogs();


/***** RootServ *****/

E void rootserv(const char *source, char *buf);


/***** conf.c *****/
E void init_conf(void);

E char *REMOTE_SERVER;
E unsigned long REMOTE_PORT;
E char *PASSWORD;
E char *SERVER_NAME;
E char *SERVER_DESC;
E char *SERVICES_USER;
E char *SERVICES_HOST;
E char *NETWORK_NAME;
E char *SERVICES_MASTER;

E char *NICKSERV_NAME;
E char *CHANSERV_NAME;
E char *MEMOSERV_NAME;
E char *HELPSERV_NAME;
E char *OPERSERV_NAME;
E char *ROOTSERV_NAME;

E char *s_NickServ;
E char *s_ChanServ;
E char *s_MemoServ;
E char *s_HelpServ;
E char *s_OperServ;
E char *s_RootServ;
E char *s_GlobalNoticer;

E char *TIME_ZONE;
E char *SLOG_FILENAME;
E char *HELPSERV_DIR;
E unsigned long UPDATE_TIMEOUT;
E short UPDATE_TAGLINES;
E short TIMEOUT_CHECK;
E short READ_TIMEOUT;
E short BAD_PW_LIMIT;
E short BAD_PW_TIMEOUT;
E short CHANNEL_MAXREG;
E short CHANNEL_EXPIRE;
E short AKICK_MAX;
E char *DEF_AKICK_REASON;
E short NS_REG_DELAY;
E short NICK_EXPIRE;
E short RELEASE_TIMEOUT;
E short DEF_MAX_MEMOS;
E short MEMO_SEND_WAIT;
E short MEMO_EXPIRE;
/*
E short MAX_SERVROOTS;
E short MAX_SERVADMINS;
E short MAX_SERVOPERS;
E short MAX_HELPOPS;
*/
E short MAX_AUTOKILLS;
E short MAX_JUPES;
E short MAX_TRIGGERS;
E int AKILL_DEF_EXPIRY;
E int IGNORE_DEF_EXPIRY;
E short CLONE_MIN_USERS;
E short CLONE_WARNING_DELAY;
E short MAX_MEMO_LENGTH;
E short ENABLE_LOGS;
E short CHAN_ACCESS_MAX;
E short USER_ACCESS_MAX;
E short MAX_SUSPEND;
E short ENABLE_R_MODES;
E short ENABLE_UMODE_a;
E short MAX_QLINES;
#if BAH_V >= 147
   E short MAX_GLINES;
#endif
E short MAX_ZLINES;
E short ALLOW_EMAIL;
E short F_TLEV;
E short F_RESET;
E short BACKUP_DB;
E short USE_ABUSESERV;
E short CUSTOM_NOTICE;
E short GENERIC_NOTICE;
E short INCLUDE_AKILL_REASON;
E short EXTRA_SNOOP;
E char *snoopchan;
E short REG_SAVES;
E short CHANNEL_INHABIT;
E short MOTD_UPTIME;
E short MOTD_UPDATE;
E char *DEF_MLOCKS;
E short TOPIC_PROBS;
E float AKILL_PERCENT;
E short REMINDER;
E unsigned short SVAR;
E char *SENDMAIL_PATH;
E char *RETURN_EMAIL;
E short auth_email;
E short switch_list;
E short nsecure;
E short accsecure;
E short cremove;
E char *hindex;
E short dumphtml;
E short AKILL_CLONES;
E char *CKILL_TIME;
E short db_change;
E short authdel;

E short NOHOST_CONF;
E short AUTO_NOHOST;

// Auto Settings

E short allow_flood;
E short allow_ignore;
E short dumplog;
E short readonly;
E short clone_detect;
E short realname;

// *Auto Settings

E char *time_zone;
E char *slog_filename;
E short update_timeout;
E char *services_roots[];
E char *services_admins[];
E char *services_opers[];
E char *services_helpers[];
E char *snchan;


E char *remote_server;
E unsigned long remote_port;
E char *password;
E char *server_name;
E char *server_desc;
E char *services_user;
E char *services_host;

/***** opercon.c *****/

E void load_oconf_defaults();
E void init_o_conf();
E int check_o_access(const char *source, const char *command);
E void serv_os_help(const char *source, const char *service, const char *s);
E char *find_level(const char *cmd);

/* MSG CALLS */

E unsigned short nsreg, csreg;
E unsigned long nsid, csid;
E unsigned long nsidf, csidf, ghost;
E unsigned int nsset, csset;
E unsigned short nsdrop, csdrop;
E unsigned short nsgp, csgp, csremove;
E unsigned long news, csop;


#endif	/* EXTERN_H */
