/* Main header for Services.
 *
 * SirvNET Services is copyright (c) 1998-2001 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * Originally based on EsperNet Services(c) by Andy Church.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#ifndef SERVICES_H
#define SERVICES_H

/*************************************************************************/

#include "config.h"

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <time.h>
#include <errno.h>
#include <dirent.h>
#include <grp.h>
#include <limits.h>
#include <netdb.h>
#include <netinet/in.h>
#include <setjmp.h>
#include <sys/socket.h> 
#include <sys/stat.h>   /* for umask() on some systems */
#include <sys/types.h>
#include <sys/time.h>

#include <ctype.h>

/* We have our own versions of toupper()/tolower(). */
#undef tolower
#undef toupper
#define tolower tolower_
#define toupper toupper_
extern int toupper(char), tolower(char);

#include "defs.h"
#include "messages.h"

/*************************************************************************/

/* Configuration sanity-checking: */

#if CHANNEL_MAXREG > 65535
# define CHANNEL_MAXREG	0
#endif
#if DEF_MAX_MEMOS > 65535
# define DEF_MAX_MEMOS	0
#endif

/*************************************************************************/

/* Version number for data files; if structures below change, increment
 * this.  (Otherwise -very- bad things will happen!) */

#define FILE_VERSION    7

/*************************************************************************/

/* Nickname info structure.  Each nick structure is stored in one of 256
 * lists; the list is determined by the first character of the nick.  Nicks
 * are stored in alphabetical order within lists. */

typedef struct nickinfo_ NickInfo;
struct nickinfo_ {
    NickInfo *next, *prev;
    char nick[NICKMAX];
    char pass[PASSMAX];
    char *last_usermask;
    char *last_realname;
    time_t time_registered;
    time_t last_seen;
    long accesscount;	/* # of entries */
    char **access;	/* Array of strings */
    long flags;		/* See below */
    time_t id_timestamp;/* TS8 timestamp of user who last ID'd for nick */
    unsigned short memomax;
    unsigned short channelcount;/* Number of channels currently registered */
    char *url;
    char *email;
    char *forward;
    char *hold;       /*  }                                       */
    char *mark;       /*  }   --   Identities (what svsadmin did it?)  */
    char *forbid;     /*  }                                       */
    int news;
    char *regemail;                     /* Original e-mail */
    long icq;
    long auth;
    long reserved[2];                   /* For future expansion -- set to 0 */
};

#define NI_KILLPROTECT	0x00000001  /* Kill others who take this nick */
#define NI_SECURE	0x00000002  /* Don't recognize unless IDENTIFY'd */
#define NI_VERBOTEN	0x00000004  /* Nick may not be registered or used */
#define NI_ENCRYPTEDPW	0x00000008  /* Nickname password is encrypted */
#define NI_MEMO_SIGNON	0x00000010  /* Notify of memos at signon and un-away */
#define NI_MEMO_RECEIVE	0x00000020  /* Notify of new memos when sent */
#define NI_PRIVATE	0x00000040  /* Don't show in LIST to non-servadmins */
#define NI_HIDE_EMAIL   0x00000080
#define NI_MARK		0x00000100
#define NI_HOLD		0x00000200
#define NI_EMAILMEMOS   0x00000400
#define NI_NOOP         0x00000800
#define NI_NOMEMO       0x00001000
#define NI_NOHOST	0x00002000
#define NI_SENDLOGS     0x00004000
#define NI_NEVEROP      0x00008000
#define NI_REMIND       0x00010000
#define NI_AUTH         0x00020000

#define NI_IDENTIFIED	0x80000000  /* User has IDENTIFY'd */
#define NI_RECOGNIZED	0x40000000  /* User comes from a known addy */
#define NI_KILL_HELD	0x20000000  /* Nick is being held after a kill */

/*************************************************************************/

/* Channel info structures.  Stored similarly to the nicks, except that
 * the second character of the channel name, not the first, is used to
 * determine the list.  (Hashing based on the first character of the name
 * wouldn't get very far. ;) ) */

/* Access levels for users. */
typedef struct {
    short level;
#ifdef COMPATIBILITY_V2
    short is_nick;	/* 1 if this is a nick, 0 if a user@host mask.  If
			 * -1, then this entry is currently unused (a hack
			 * to get numbered lists to have consistent
			 * numbering). */
# define in_use is_nick
#else
    short in_use;      /* pretty well obsolete  - Mar 26, 99 */
#endif
    char *name;
} ChanAccess;

#define ACCESS_FOUNDER	10000	/* Numeric level indicating founder access */
#define ACCESS_INVALID	-10000	/* Used in levels[] for disabled settings */

/* AutoKick data. */
typedef struct {
    short is_nick;
    short pad;
    char *name;
    char *reason;
} AutoKick;

typedef struct chaninfo_ ChannelInfo;
struct chaninfo_ {
    ChannelInfo *next, *prev;
    char name[CHANMAX];
    char founder[NICKMAX];		/* Always a reg'd nick */
    char founderpass[PASSMAX];
    char *desc;
    time_t time_registered;
    time_t last_used;
    long accesscount;
    ChanAccess *access;			/* List of authorized users */
    long akickcount;
    AutoKick *akick;
    short mlock_on, mlock_off;		/* See channel modes below */
    long mlock_limit;			/* 0 if no limit */
    char *mlock_key;			/* NULL if no key */
    char *last_topic;			/* Last topic on the channel */
    char last_topic_setter[NICKMAX];	/* Who set the last topic */
    time_t last_topic_time;		/* When the last topic was set */
    long flags;				/* See below */
    short *levels;			/* Access levels for commands */
    char *url;
    char *email;
    char *welcome;
    char *hold;       /*  }                                         */
    char *mark;       /*  }   --   Identities (what admin did it?)  */
    char *freeze;     /*  }   --                                    */
    char *forbid;     /*  }                                         */
    int topic_allow;                  /* Who's allowed to change topic */
    long auth;
    long reserved[4];                   /* For future expansion -- set to 0 */
};

#define CI_KEEPTOPIC	0x00000001
#define CI_OPGUARD	0x00000002
#define CI_PRIVATE	0x00000004
#define CI_TOPICLOCK	0x00000008
#define CI_RESTRICTED	0x00000010
#define SVER 514
#define CI_LEAVEOPS	0x00000020
#define CI_IDENT	0x00000040
#define CI_VERBOTEN	0x00000080
#define CI_ENCRYPTEDPW	0x00000100
#define CI_HELDCHAN     0x00000200
#define CI_MARKCHAN     0x00000400
#define CI_OPERONLY     0x00000800
#define CI_SOPONLY      0x00001000
#define CI_SAONLY       0x00002000
#define CI_SRAONLY      0x00004000
#define CI_CODERONLY    0x00008000
#define CI_ABUSEONLY	0x00010000
#define CI_FREEZECHAN   0x00020000
#define CI_MEMO_AV      0x00040000
#define CI_MEMO_AOP     0x00080000
#define CI_MEMO_SOP     0x00100000
#define CI_MEMO_CF      0x00200000
#define CI_MEMO_FR      0x00400000
#define CI_MEMO_NONE    0x00800000
#define CI_UNSECURE     0x01000000
#define CI_REMIND       0x02000000
#define CI_PROTECTED    0x04000000
#define CI_CLOSED       0x08000000

#ifdef COMPATIBILITY_V2
/* Channel's access list has masks in it, not just registered nicks */
#define CI_HAS_MASKS	0x80000000
#endif

/* Indices for cmd_access[]: */
#define CA_INVITE	0
#define CA_AKICK	1
#define CA_SET		2	/* but not FOUNDER or PASSWORD */
#define CA_UNBAN	3
#define CA_AUTOOP	4
#define CA_AUTODEOP	5	/* Maximum, not minimum */
#define CA_AUTOVOICE	6
#define CA_OPDEOP	7	/* ChanServ commands OP and DEOP */
#define CA_ACCESS_LIST	8
#define CA_CLEAR	9
#define CA_NOJOIN	10	/* Maximum */
#define CA_ACCESS_CHANGE 11

#define CA_SIZE		12

/*************************************************************************/

/* MemoServ data.  Only nicks that actually have memos get records in
 * MemoServ's lists, which are stored the same way NickServ's are. */

typedef struct memo_ Memo;

struct memo_ {
    char sender[NICKMAX];
    long number;	/* Index number -- not necessarily array position! */
    time_t time;	/* When it was sent */
    char *text;
    char *chan;
    short flags;
    short reserved_s;
    long reserved[3];   /* For future expansion -- set to 0 */
};

#define MF_UNREAD	0x0001	/* Memo has not yet been read */
#define MF_DEL          0x0002  /* Memo marked as deleted */

typedef struct memolist_ MemoList;

struct memolist_ {
    MemoList *next, *prev;
    char nick[NICKMAX];	/* Owner of the memos */
    long n_memos;	/* Number of memos */
    Memo *memos;	/* The memos themselves */
    long reserved[4];   /* For future expansion -- set to 0 */
};

/*************************************************************************/

/* Online user and channel data. */

typedef struct user_ User;
typedef struct channel_ Channel;

struct user_ {
    User *next, *prev;
    char nick[NICKMAX];
    char *username;
    char *host;				/* user's hostname */
    char *realname;
    char *server;			/* name of server user is on */
    time_t signon;
    time_t my_signon;			/* when did _we_ see the user? */
    long mode;				/* see below */
    long flags;
    struct u_chanlist {
	struct u_chanlist *next, *prev;
	Channel *chan;
    } *chans;				/* channels user has joined */
    struct u_chaninfolist {
	struct u_chaninfolist *next, *prev;
	ChannelInfo *chan;
    } *founder_chans;			/* channels user has identified for */
    char *id_nicks[MAX_IDS];
    short invalid_pw_count;		/* # of invalid password attempts */
    time_t invalid_pw_time;		/* time of last invalid password */
    time_t lastmemosend;		/* last time MS SEND command used */
    time_t lastnickreg;			/* last time NS REGISTER cmd used */
    time_t flood_time;                  /* time until reset flood level */
    short floodlev, floodlev2;         /* current flood level */
    short motd, version;               /* additional flood monitors */
};

#define UMODE_O 0x00000001
#define UMODE_I 0x00000002
#define UMODE_S 0x00000004
#define UMODE_W 0x00000008
#define UMODE_G 0x00000010
#define UMODE_H 0x00000020
#define UMODE_A 0x00000040

#define U_ABUSIVE 0x00000001
#define U_NOOPER  0x00000002
#define U_NOSERV  0x00000004

struct channel_ {
    Channel *next, *prev;
    char name[CHANMAX];
    time_t creation_time;		/* when channel was created */
    char *topic;
    char topic_setter[NICKMAX];		/* who set the topic */
    time_t topic_time;			/* when topic was set */
    long mode;				/* binary modes only */
    long limit;				/* 0 if none */
    char *key;				/* NULL if none */
    int bancount, bansize;
    char **bans;
    struct c_userlist {
	struct c_userlist *next, *prev;
	User *user;
    } *users, *chanops, *voices;
};

#define CMODE_I 0x00000001
#define CMODE_M 0x00000002
#define CMODE_N 0x00000004
#define CMODE_P 0x00000008
#define CMODE_S 0x00000010
#define CMODE_T 0x00000020
#define CMODE_K 0x00000040		/* These two used only by ChanServ */
#define CMODE_L 0x00000080
#define CMODE_R 0x00000100
#define CMODE_J 0x00000200
#define CMODE_r 0x00000400
#define CMODE_C 0x00000800
#define CMODE_o 0x00001000

/*************************************************************************/

/* Channel Suspend data. */

typedef struct c_suspend_data {
    struct c_suspend_data *next;
    char chan[CHANMAX];
    time_t time;        /* When do we stop suspending? */
} C_SuspendData;

/*************************************************************************/


#include "extern.h"

/*************************************************************************/

#endif	/* SERVICES_H */
