/* ChanServ special help texts.
 *
 * SirvNET Services is copyright (c) 1998-2001 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * Originally based on EsperNet Services(c) by Andy Church.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

/*************************************************************************/

static const char *cs_servadmin_help[] = {
"ChanServ commands:",
"",
"    FLIST      Lists channels with speicified flag",
"",
"The following commands are available to Services Operators:",
"",
"    FREEZE     Prevent ChanServ from interacting with a channel",
"    LEVEL      Set channel access level",
"    SUSPEND    Suspend a channel temporarily",
"    TOPIC      Change a channel topic",
"",
"The following commands are available to Services Administrators:",
"    GETPASS    Retrieve the founder password for a channel",
"    FORBID     Prevent a channel from being used",
"    HOLD       Prevents a channel from expiring",
"    MARK       Prevents the GETPASSing of a channel",
"    SENDPASS   E-Mail channel password to the founder",
"    WIPE       Wipe channel access lists",
"",
"The following commands are avalible to Services Roots:",
"    DELETE     Drop a currently registered channel",
NULL
};

/*************************************************************************/

static const char *flush_help[] = {
"Syntax: \2FLUSH <#chan>",
"",
"This command removes the authorization information",
"from a channel. Use of this command is for a user to",
"be able retreive another authorization code for",
"verification to drop a channel.",
"By using the FLUSH command you defeat the purpose of",
"the extra security of a channel, so use this command",
"with caution.",
NULL
};


/*************************************************************************/

static const char *flist_help[] = {
"Syntax: \2FLIST [\37HELD\37|\37MARKED\37|\37FORBIDDEN\37|\37FROZEN\37]\2",
"",
"Lists all registered channels that have the specified",
"flag settings.",
NULL
};
 

/*************************************************************************/

static const char *oper_delete_help[] = {
"Syntax: \2DELETE \37channel\37\2",
"",
"Unregisters the named channel.  Only \2Services Roots\2",
"can delete a channel for which they have not identified.",
NULL
};

/*************************************************************************/

static const char *getpass_help[] = {
"Syntax: \2GETPASS \37channel\37\2",
"",
"Returns the password for the given channel.  \2Note that\2",
"\2whenever this command is used, a message including the\2",
"\2person who issued the command and the channel it was used\2",
"\2on will be logged and sent out as a GLOBOPS.\2",
NULL
};

/*************************************************************************/


static const char *freeze_help[] = {
"Syntax: \2FREEZE \37channel\37\2",
"Syntax: \2FREEZE -\37channel\37\2",
"",
"Prevents ChanServ from setting user or channel modes.",
"By adding a '-' infront of the channel will remove it",
"as frozen",
NULL
};

/*************************************************************************/

static const char *level_help[] = {
"Syntax: \2LEVEL \37channel\37 \37who\37\2",
"",
"The \"who\" can be one of the following:",
"    OPERS    Disallow access to non-opers",
"    SOP      Disallow access to non-SOP",
"    SA       Disallow access to non-SA",
"    SRA      Disallow access to non-SRA",
"    MASTERS  Disallow access to non-MASTER",
"    NONE     Allow anyone to join",
"",
NULL
};

/*************************************************************************/

static const char *forbid_help[] = {
"Syntax: \2FORBID \37channel\37\2",
"Syntax: \2FORBID -\37channel\37\2",
"",
"Disallows a channel from being registered or used by",
"anyone.  May be cancelled by deleting the channel.",
"Adding a '-' infront of the channel will remove it as forbidden",
NULL
};

/*************************************************************************/

static const char *mark_help[] = {
"Syntax: \2MARK \37channel\37\2",
"Syntax: \2MARK -\37channel\37\2",
"",
"Disallows a channel from being getpassed.",
"MARK is generally used if a services admin has denied",
"a user from receiving a password, and is used to inform",
"the rest of the network not to getpass the channel.",
"Adding a '-' infront of the channel will remove it as marked",
NULL
};


/*************************************************************************/

static const char *hold_help[] = {
"Syntax: \2HOLD \37channel\37\2",
"Syntax: \2HOLD -\37channel\37\2",
"",
"Prevents a channel from being expired.",
"Adding a '-' infront of the channel will remove it as held",
NULL
};

/*************************************************************************/

static const char *ostopic_help[] = {
"Syntax: TOPIC \37channel\37 \37new_topic\37",
"",
"Forces OperServ to change the topic of a given channel",
"",
NULL
};

/*************************************************************************/

static const char *suspend_help[] = {
"Syntax: SUSPEND \2ADD\2 \37channel\37 \37time\37",
"        SUSPEND \2ADD\2 \37channel\37 0",
"        SUSPEND \2DEL\2 \37channel\37",
"        SUSPEND \2LIST\2",
"",
"Suspending a channel will kick all users residing",
"or joining the channel. Similar to FORBID however",
"its time limited, and the registration is not dropped.",
"\2time\2 is in minutes.",
"If '0' is given for \2time\2 then the channel is",
"closed permanetly.",
"A channel may be re-opened if \2DEL\2 is used.",
NULL
};

/*************************************************************************/

static const char *wipe_help[] = {
"Syntax: WIPE \37channel\37 [\37CFOUNDER\37] [\37SOP\37] [\37AOP\37]",
"[\37AVOICE\37] [\37ALL\37]",
"",
"Wipes the given access list of a channel.",
"Example: /MSG CHANSERV WIPE #USERSCHAN SOP",
NULL
};

/*************************************************************************/

static const char *sendpass_help[] = {
"Syntax: \2SENDPASS \37#channel\37\2",
"",
"Sends the channel password to the Channel Founder's",
"E-Mail address. This option only works if the email",
"has been specified.",
NULL
};
