/* Definitions of IRC message functions and list of messages.
 *
 * SirvNET Services is copyright (c) 1998-2001 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * Originally based on EsperNet Services(c) by Andy Church.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#include "../inc/services.h"

unsigned long serv_com = 0;
unsigned long day_serv_com = 0;
unsigned long hour_serv_com = 0;
unsigned long min_serv_com = 0;

unsigned short nsreg=0, csreg=0;
unsigned long nsid=0, csid=0;
unsigned long nsidf=0, csidf=0;
unsigned long ghost=0, news=0;
unsigned int nsset=0, csset=0;
unsigned short nsdrop=0, csdrop=0;
unsigned short nsgp=0, csgp=0, csremove;
unsigned long csop=0;
/* List of messages is at the bottom of the file. */

/*************************************************************************/
/*************************************************************************/

static void m_nickcoll(char *source, int ac, char **av)
{
    do_quit(source, ac, av);

}

/*************************************************************************/

static void m_server(char *source, int ac, char **av)
{
    if (ac < 1)
	return;
    check_jupes();
    check_zlines();
}

/*************************************************************************/

static void m_squit(char *source, int ac, char **av)
{
    if (ac < 1)
	return;
    check_jupe_squit(source, av[0]);
}


/*************************************************************************/

static void m_ping(char *source, int ac, char **av)
{
    if (ac < 1)
	return;
    send_cmd(server_name, "PONG %s %s", ac>1 ? av[1] : server_name, av[0]);

}

/*************************************************************************/
#ifndef SKELETON

static void m_away(char *source, int ac, char **av)
{
    if (ac == 0 || *av[0] == 0)		/* un-away */
	check_memos(source);
}
#endif

/*************************************************************************/

static void m_join(char *source, int ac, char **av)
{
    if (ac != 1)
	return;
    do_join(source, ac, av);
}

/*************************************************************************/

static void m_sjoin(char *source, int ac, char **av)
{
   do_sjoin(source, ac, av);
}

/*************************************************************************/

static void m_kick(char *source, int ac, char **av)
{
    if (ac != 3)
	return;
    do_kick(source, ac, av);
}

/*************************************************************************/

static void m_kill(char *source, int ac, char **av)
{
    if (ac != 2)
	return;
    do_kill(source, ac, av);
}

/*************************************************************************/

static void m_mode(char *source, int ac, char **av)
{
    char *modestr = av[1];
    char *s, *nick;
    int add = 0, i, x=0, x2=0;
    User *u;

    if (*av[0] == '#' || *av[0] == '&') {

        char newmodes[128], *rlist[5], *rrlist[5];
        char c, *mchange = newmodes;
        char **bv = av, *nv[8], *ov[8], *reop[8];
        int bc = ac, start = 2, ostart = 2, rstart = 2;
        int vmode = 0;

        for (i=2; i < 8; i++) {
           ov[i] = NULL;
           reop[i] = NULL;
        }

	if (ac < 2)
	    return;
        s = modestr;

        bc -= 2;
        bv += 2;

        while (*s) {
            int repeat = 0;
            char *mv[3];
            switch(c = *s++) {
               case '+':
                  if (*mchange-1 != '+')
                     *mchange++ = '+';
                  add = 1;
                  break;
               case '-':
                  if (*mchange-1 != '-')
                     *mchange++ = '-';
                  add = 0;
                  break;

               case 'b':
                 mv[0] = av[0];
                 if (add)
                    mv[1] = "+b";
                 else
                    mv[1] = "-b";

                 if (--bc < 0) {
                   log("channel: MODE %s %s: missing parameter for %cb",
                                     av[0], modestr, add ? '+' : '-');
                   break;
                 }
                 mv[2] = *bv++;
                 
                 do_cmode(source, 3, mv);
                 break;

               case 'v':
                 mv[0] = av[0];
                 if (add)
                    mv[1] = "+v";
                 else
                    mv[1] = "-v";

                 if (--bc < 0) {
                   log("channel: MODE %s %s: missing parameter for %cv",
                                     av[0], modestr, add ? '+' : '-');
                   break;
                 }
                 mv[2] = *bv++;
                 do_cmode(source, 3, mv);
                 break;


               case 'o':
                 mv[0] = av[0];
                 mv[1] = "+o";
                 repeat = 0;


                 if (--bc < 0) {
                   log("channel: MODE %s %s: missing parameter for %co",
                                     av[0], modestr, add ? '+' : '-');
                   break;
                 }

                 nick = *bv++;

                 for (i=0; i < x; i++) {
                    if (rlist[i] && stricmp(rlist[i], nick) == 0)
                        repeat++;
                 }
                 rlist[x++] = nick;

                 
                 mv[2] = nick;
                 if (add) {
                     u = finduser(nick);
                     if (!u)
                        break;
#ifndef SKELETON

                     if (!check_valid_op(u, av[0], 0) &&
                         stricmp(source, u->nick) && !repeat) {
                        ov[ostart++] = nick;
                        do_cmode(source, 3, mv);
                        break;
                     } else
#endif
{

                       if (!repeat)
                          do_cmode(source, 3, mv);
}
                 } else {
                         ChannelInfo *ci;
                         int ulev = 0;
                         mv[1] = "-o";

#ifndef SKELETON
                     ci = cs_findchan(av[0]);
                     u = finduser(nick);
                     if (!u)
                        break;

                 if (ci && (ci->flags & CI_PROTECTED)) {
                     for (i=0; i < x2; i++) {
                        if (rrlist[i] && stricmp(rrlist[i], nick) == 0)
                           repeat++;
                     }
                     rrlist[x2++] = nick;
                     ulev = get_access(u, ci);
                     if (ci && ulev >= get_access(finduser(source), ci)) {
                        if (ci && (ulev > 3) && !repeat
                               && (stricmp(source, nick) != 0) && is_chanop(nick, av[0]))
                           reop[rstart++] = nick;
                        else
#endif
                            do_cmode(source, 3, mv);
#ifndef SKELETON

                     }
                   } else
                       do_cmode(source, 3, mv);
#endif
                 }
                 break;
              default:

                   *mchange++ = c;
                   if (c == 'l' && add)
                         nv[start++] = *bv++;
                   else if (c == 'k')
                      nv[start++] = *bv++;
                   else vmode = 1;
                   break;
            }  
       }

       if (start > 2 || vmode) {
           nv[0] = av[0];
           nv[1] = newmodes;
           do_cmode(source, start-1, nv);
       }

       if (ov[2])
          send_cmd(s_ChanServ, "MODE %s -%s%s%s%s%s%s %s %s %s %s %s %s",
                 av[0], "o", ov[3] ? "o" : "",
                 ov[4] ? "o" : "", ov[5] ? "o" : "",
                 ov[6] ? "o" : "", ov[7] ? "o" : "",
                 ov[2], ov[3] ? ov[3] : "",
                 ov[4] ? ov[4] : "", ov[5] ? ov[5] : "",
                 ov[6] ? ov[6] : "", ov[7] ? ov[7] : "");

       if (reop[2])
          send_cmd(s_ChanServ, "MODE %s +%s%s%s%s%s%s %s %s %s %s %s %s",
                 av[0], "o", reop[3] ? "o" : "",
                 reop[4] ? "o" : "", reop[5] ? "o" : "",
                 reop[6] ? "o" : "", reop[7] ? "o" : "",
                 reop[2], reop[3] ? reop[3] : "",
                 reop[4] ? reop[4] : "", reop[5] ? reop[5] : "",
                 reop[6] ? reop[6] : "", reop[7] ? reop[7] : "");

    } else {
	if (ac != 2)
	    return;
	do_umode(source, ac, av);
    }
}

/*************************************************************************/

static void m_motd(char *source, int ac, char **av)
{
    FILE *f;
    char buf[BUFSIZE];
    char buf2[BUFSIZE];
    char *x;
    int i, all=0, avail=0;
    time_t uptime = time(NULL) - start_time;
    User *u = finduser(source);

    if (u && allow_flood == 1)
        do_update_flood(u, 2);


    f = fopen(MOTD_FILENAME, "r");
    send_cmd(server_name, "375 %s :- %s Message of the Day",
		source, server_name);
   if (f) {
	while (fgets(buf, sizeof(buf), f)) {
	    buf[strlen(buf)-1] = 0;
	    send_cmd(server_name, "372 %s :- %s", source, buf);
	}
	fclose(f);
    }

    send_cmd(server_name, "372 %s :-", source);

    send_cmd(server_name, "372 %s :- This list of people can retrieve"
                " lost passwords:", source);

    send_cmd(server_name, "372 %s :-", source);

    *buf = 0;
    *buf2 = 0;

    for (i = 0; i < MAX_SERVADMINS; i++) {
        if (services_admins[i]) {
            all++;
            if (finduser(services_admins[i])) {
                strcat(buf2, services_admins[i]);
                strcat(buf2, " ");
                avail++;
            }
            if (!finduser(services_admins[i])) {
                strcat(buf, services_admins[i]);
                strcat(buf, " ");
            }
        }
    }
    for (i = 0; i < MAX_SERVROOTS; i++) {
        if (services_roots[i]) {
            all++;
            if (finduser(services_roots[i])) {
                strcat(buf2, services_roots[i]);
                strcat(buf2, " ");
                avail++;
            }
            if (!finduser(services_roots[i])) {
                strcat(buf, services_roots[i]);
                strcat(buf, " ");
            }
        }
    }
    if (!*buf && !*buf2)
        strcpy(buf, "List: Not Currently Available");

    send_cmd(server_name, "372 %s :- \2%s \n\2", source, buf2);
    send_cmd(server_name, "372 %s :-", source);
    send_cmd(server_name, "372 %s :- %s \n", source, buf);

    send_cmd(server_name, "372 %s :-", source);
    send_cmd(server_name, "372 %s :- %d of %d nicks available.",
         source, avail, all);

    send_cmd(server_name, "372 %s :- Note: The nicks that are in \2bold\2"
                 " are currently online", source);

    send_cmd(server_name, "372 %s :-", source);

    if (MOTD_UPDATE && !readonly) {
       i = (UPDATE_TIMEOUT - (time(NULL) - last_update));
       send_cmd(server_name, "372 %s :- Next DataBase Update: %d Minute%s, %d second%s",
           source, i/60, i==1 ? "" : "s",
           i%60, i==1 ? "" : "s");
       i=0;
    }

    if (MOTD_UPTIME) {
      if (uptime > 86400)
          send_cmd(server_name, "372 %s :- "
                        "Services up \2%d\2 day%s, \2%02d:%02d\2", source,
                        uptime/86400, (uptime/86400 == 1) ? "" : "s",
                        (uptime/3600) % 24, (uptime/60) % 60);
      else if (uptime > 3600)
          send_cmd(server_name, "372 %s :- "
                        "Services up \2%d hour%s, %d minute%s\2", source,
                        uptime/3600, uptime/3600==1 ? "" : "s",
                        (uptime/60) % 60, (uptime/60)%60==1 ? "" : "s");
      else
          send_cmd(server_name, "372 %s :- "
                        "Services up \2%d minute%s, %d second%s\2", source,
                        uptime/60, uptime/60==1 ? "" : "s",
                        uptime%60, uptime%60==1 ? "" : "s");
    }


    send_cmd(server_name, "372 %s :-", source);

    send_cmd(server_name, "372 %s :- SirvNET Services are copyright (c) "
                "1998-2001 Trevor Klingbeil.", source);
    send_cmd(server_name, "376 %s :End of /MOTD command.", source);
}
/*************************************************************************/

static void m_nick(char *source, int ac, char **av)
{
#ifndef BAHAMUT
    if (ac == 8) {
	/* Get rid of the useless extra parameter. */
	av[6] = av[7];
	ac--;
    }

    if ((!*source && ac != 7) || (*source && ac != 2))
	return;
#endif
    do_nick(source, ac, av);
}

/*************************************************************************/

static void m_part(char *source, int ac, char **av)
{
    if (ac < 1 || ac > 2)
	return;
    do_part(source, ac, av);
}

/*************************************************************************/

static void m_privmsg(char *source, int ac, char **av)
{
    time_t starttime, stoptime;	/* When processing started and finished */
    time_t now = time(NULL);
    char *nick;
    User *u;


    if (ac != 2 || !source || !av[0])
	return;
    else if (!(u = finduser(source)))
        return;

    if(strchr(av[0], '@')) {
	nick = strtok(av[0], "@");
	av[0] = nick;
    }

    /* Check if we have a flooder.  Operators are ignored. */

    if (allow_flood == 1) {
        if (do_update_flood(u, 0) == 1)
            return;
    }

    /* Check if we should ignore.  Operators always get through. */


    if ((allow_ignore == 1) && !is_oper(source)) {
         if (check_ignore(u->nick, u->username, u->host) != 0)
              return;
    }


    if (u->flags & U_NOSERV) {
	log("Access denied to services from %s", source);
	return;
    }

    if ((debug == 1) && ((stricmp(av[0], s_OperServ) == 0)
       || (stricmp(av[0], s_OperServ) == 0)
       || (stricmp(av[0], s_RootServ) == 0)
       || (stricmp(av[0], s_NickServ) == 0)
       || (stricmp(av[0], s_MemoServ) == 0)
       || (stricmp(av[0], s_ChanServ) == 0)
       || (stricmp(av[0], s_HelpServ) == 0))
       && (!stricmp(av[1], "identify") ==0))
            log("%s: %s", source, inbuf);

    if ((sndebug == 1) && ((stricmp(av[0], s_OperServ) == 0)
       || (stricmp(av[0], s_OperServ) == 0)
       || (stricmp(av[0], s_RootServ) == 0)
       || (stricmp(av[0], s_NickServ) == 0)
       || (stricmp(av[0], s_MemoServ) == 0)
       || (stricmp(av[0], s_ChanServ) == 0)
       || (stricmp(av[0], s_HelpServ) == 0))
       && (!stricmp(av[1], "identify") ==0))
           send_cmd(s_OperServ, "PRIVMSG %s :%s: %s", snoopchan, source, inbuf);

    serv_com += 1;

    if (now > d_check_time) {
       d_check_time = time(NULL) + 86400;
       day_serv_com = 1;
    } else {
        day_serv_com += 1;
    }

    if (now > h_check_time) {
       h_check_time = time(NULL) + 3600;
       hour_serv_com = 1;
    } else {
        hour_serv_com += 1;
    }

   if (now > m_check_time) {
      m_check_time = time(NULL) + 60;
      min_serv_com = 1;
   } else {
       min_serv_com += 1;
   }

    starttime = time(NULL);


    if (stricmp(av[0], s_OperServ) == 0) {
        if (is_oper(source) && !(u->flags & U_ABUSIVE))
	    operserv(source, av[1]);
    } else if (stricmp(av[0], s_AbuseServ) == 0) {
	if (is_abuse(source) || is_services_coder(source))
	    abuseserv(source, av[1]);
	else {
            if (is_oper(source))
               notice(s_AbuseServ, source, "Access denied.");
	}
    } else if (stricmp(av[0], s_RootServ) == 0) {
        if (is_services_root(source))
            rootserv(source, av[1]);
	else {
            if (is_oper(source))
               notice(s_RootServ, source, "Access denied.");
	}
    } else if (stricmp(av[0], s_NickServ) == 0) {
	nickserv(source, av[1]);
    } else if (stricmp(av[0], s_ChanServ) == 0) {
	chanserv(source, av[1]);
    } else if (stricmp(av[0], s_MemoServ) == 0) {
	memoserv(source, av[1]);
    } else if (stricmp(av[0], s_HelpServ) == 0) {
	helpserv(s_HelpServ, source, av[1]);
    } else if (snchan && (stricmp(av[0], snchan) == 0)) {
	send_cmd(s_OperServ, "PRIVMSG %s :<%s/%s> %s", snoopchan, source, snchan, av[1]);
    }

    /* Add to ignore list if the command took a significant amount of time. */
/*
    if (allow_ignore) {
	stoptime = time(NULL);
	if (stoptime > starttime && *source && !strchr(source, '.'))
            add_ignore(mask, source, 10);
    }
*/
}

/*************************************************************************/

static void m_quit(char *source, int ac, char **av)
{
    if (ac != 1)
	return;
    do_quit(source, ac, av);
}

/*************************************************************************/

static void m_topic(char *source, int ac, char **av)
{
    if (ac != 4)
	return;
    do_topic(source, ac, av);
}

/*************************************************************************/

static void m_stats(char *source, int ac, char **av)
{
    time_t uptime = time(NULL) - start_time;
    long count, count2, mem, mem2;

    if (ac != 2)
        return;
    
     switch(*av[0]) {


      case 'u':
      case 'U':
      if (uptime > 86400)
          send_cmd(server_name, "372 %s :"
                        "Services up %d day%s, %02d:%02d", source,
                        uptime/86400, (uptime/86400 == 1) ? "" : "s",
                        (uptime/3600) % 24, (uptime/60) % 60);

      else if (uptime > 3600)
          send_cmd(server_name, "372 %s :"
                        "Services up %d hour%s, %d minute%s", source,
                        uptime/3600, uptime/3600==1 ? "" : "s",
                        (uptime/60) % 60, (uptime/60)%60==1 ? "" : "s");

      else
          send_cmd(server_name, "372 %s :"
                        "Services up %d minute%s, %d second%s", source,
                        uptime/60, uptime/60==1 ? "" : "s",
                        uptime%60, uptime%60==1 ? "" : "s");
      break;

    case 'S':
    case 's':
          send_cmd(server_name, "372 %s :%s", source, server_name);

          break;


    case 'M':
    case 'm':
          if (!is_oper(source))
             return;
          send_cmd(server_name, "372 %s :%d minute", source, min_serv_com);
          send_cmd(server_name, "372 %s :%d hour", source, hour_serv_com);
          send_cmd(server_name, "372 %s :%d day", source, day_serv_com);
          send_cmd(server_name, "372 %s :%d commands", source, serv_com);
          send_cmd(server_name, "372 %s :%d/%d nsreg/csreg",
                   source, nsreg, csreg);
          send_cmd(server_name, "372 %s :%d/%d nsid/fails",
                   source, nsid, nsidf);
          send_cmd(server_name, "372 %s :%d/%d csid/fails",
                   source, csid, csidf);
          send_cmd(server_name, "372 %s :%d/%d ns/cs set",
                   source, nsset, csset);
          send_cmd(server_name, "372 %s :%d/%d ns/cs drops",
                   source, nsdrop, csdrop);
          send_cmd(server_name, "372 %s :%d/%d ns/cs getpass",
                   source, nsgp, csgp);
          send_cmd(server_name, "372 %s :%d/%d op/remove",
                   source, csop, csremove);
          send_cmd(server_name, "372 %s :%d ghosts",
                   source, ghost);
          send_cmd(server_name, "372 %s :%d news",
                   source, news);

    
          break;

     case 'R':
     case 'r':

         if (!is_oper(source))
             return;

         get_nickserv_stats(&count, &mem);
         get_chanserv_stats(&count2, &mem2);


         send_cmd(server_name, "372 %s :%d/%d nicks/chans",
              source, count, count2);
         send_cmd(server_name, "372 %s :%d/%d kb",
              source, ((mem+512) / 1024), ((mem2+512) / 1024));
         send_cmd(server_name, "372 %s :(%s) 4/%d/%d LEV/TLEV/RESET",
              source, allow_flood==1 ? "on" : "off", F_TLEV, F_RESET);
         send_cmd(server_name, "372 %s :st%s %d - tn%s %d",
              source, ":", start_time, ":", time(NULL));

            
         break;
     }
}

/*************************************************************************/
/*************************************************************************/

Message messages[] = {

    { "436",       m_nickcoll },
    { "401",	   NULL },
    { "HELP",	   NULL },
#ifndef SKELETON
    { "AWAY",      m_away },
#else
    { "AWAY",      NULL },
#endif
    { "JOIN",      m_join },
    { "SJOIN",     m_sjoin },
    { "KICK",      m_kick },
    { "KILL",      m_kill },
    { "MODE",      m_mode },
    { "MOTD",      m_motd },
    { "NICK",      m_nick },
    { "NOTICE",    NULL },
    { "PART",      m_part },
    { "PASS",      NULL },
    { "PING",      m_ping },
    { "PRIVMSG",   m_privmsg },
    { "QUIT",      m_quit },
    { "SERVER",    m_server },
    { "SQUIT",     m_squit },
    { "TOPIC",     m_topic },
    { "WALLOPS",   NULL },
    { "VERSION",   m_version },
    { "AKILL",     NULL },
    { "GLOBOPS",   NULL },
    { "CHATOPS",   NULL },
    { "GNOTICE",   NULL },
    { "GOPER",     NULL },
    { "RAKILL",    NULL },
    { "CAPAB",     NULL },
    { "SVINFO",    NULL },
    { "SQLINE",    NULL },
    { "SVSMODE",   NULL },
    { "STATS",     m_stats },
    { NULL }

};

/*************************************************************************/

Message *find_message(const char *name)
{
    Message *m;

    for (m = messages; m->name; m++) {
	if (stricmp(name, m->name) == 0)
	    return m;
    }
    return NULL;
}

/*************************************************************************/
