/*
 * SirvNET Services is copyright (c) 1998-2001 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#include "../inc/services.h"

static int o_conf_break();

struct oper_con {
   char *command;
   char *service;
   short level;
} *opercon = NULL;

/*
 *  Permission levels:
 *
 *     0 = oper
 *     1 = sop
 *     2 = sa
 *     3 = sra
 *     4 = master
 */


void load_oconf_defaults()
{
  unsigned int i=0, x=0;

  opercon = smalloc(sizeof(*opercon) * 64);

/*  DO NOT, I REPEAT, *DO NOT* TOUCH THE ORDER OF THESE COMMANDS! */

/*  Oper  */
  opercon[x].command = "TRIGGER";
  opercon[x++].service = "OS";
  opercon[x].command = "UINFO";
  opercon[x++].service = "OS";
/*  SOP  */
  opercon[x].command = "FORBID";
  opercon[x++].service = "BOTH";
  opercon[x].command = "FREEZE";
  opercon[x++].service = "CS";
  opercon[x].command = "LEVEL";
  opercon[x++].service = "CS";
  opercon[x].command = "TOPIC";
  opercon[x++].service = "CS";
  opercon[x].command = "AKILL";
  opercon[x++].service = "OS";
  opercon[x].command = "CLEAR";
  opercon[x++].service = "OS";
  opercon[x].command = "IGNORE";
  opercon[x++].service = "OS";
  opercon[x].command = "SUSPEND";
  opercon[x++].service = "CS";
  opercon[x].command = "OSEND";
  opercon[x++].service = "MS";
/*  SA  */
  opercon[x].command = "GETPASS";
  opercon[x++].service = "BOTH";
  opercon[x].command = "HOLD";
  opercon[x++].service = "BOTH";
  opercon[x].command = "MARK";
  opercon[x++].service = "BOTH";
  opercon[x].command = "SENDPASS";
  opercon[x++].service = "BOTH";
  opercon[x].command = "WIPE";
  opercon[x++].service = "CS";
  opercon[x].command = "INFO";
  opercon[x++].service = "MS";
  opercon[x].command = "LIMIT";
  opercon[x++].service = "MS";
  opercon[x].command = "FLUSH";
  opercon[x++].service = "NS";
  opercon[x].command = "JUPE";
  for (i=x; i < x+8; i++)
     opercon[i].service = "OS";
  x++;
  opercon[x++].command = "SENDLOGS";
  opercon[x++].command = "HOP";
  opercon[x++].command = "SOP";
  opercon[x++].command = "SQLINE";
  opercon[x++].command = "UPDATE";
  opercon[x++].command = "ZLINE";
  opercon[x++].command = "SGLINE";
/*  SRA  */
  opercon[x].command = "DELETE";
  opercon[x++].service = "BOTH";
  opercon[x].command = "GLOBAL";
  opercon[x++].service = "MS";
  opercon[x].command = "SA";
  for (i=x; i < x+8; i++)
     opercon[i].service = "RS";
  x++;
  opercon[x++].command = "CHANSNOOP";
  opercon[x++].command = "FLOODRESET";
  opercon[x++].command = "INJECT";
  opercon[x++].command = "SET";
  opercon[x++].command = "SRAW";
  opercon[x++].command = "SEARCH";
/*  Master  */
  opercon[x].command = "SRA";


  for (i=0; i < 2; i++)
     opercon[i].level = 0;
  for (i=2; i < 11; i++)
     opercon[i].level = 1;
  for (i=11; i < 27; i++)
     opercon[i].level = 2;
  for (i=27; i < 36; i++)
     opercon[i].level = 3;
  opercon[36].level = 4;


}

void init_o_conf(void)
{
  FILE *o_conf;
  unsigned char linbuff[1024];
  char *pargv[100];
  char *tmp, tmp2;
  int p;

  if ((o_conf = fopen(O_CONFIG_FILE, "rb")) == NULL)
  {
    log("Error opening oper permissions configuration file = %s",
         O_CONFIG_FILE);
    log("Using defaults for permissions");
    return;
  }

  while (!feof(o_conf))
  {
     if ((fgets(linbuff, 1024, o_conf)) == NULL)
     {
         break;
     }
     p = 0;
     tmp = strtok(linbuff, ": \n\r,");

     if (tmp != NULL)
     {
         pargv[p++] = tmp;
         while ((tmp = strtok(NULL, ": \n\r,")) != NULL)
         {
            pargv[p++] = tmp;
            if (p > 100) {
               break;
            }
         }
         if (o_conf_break(p, pargv) == -1) {
            log("Services Terminated on illegal oper configuration");
            exit(1);
         }
    }
  }
  fclose(o_conf);
  log("Sucessfully loaded oper permissions configuration");
  return;
}


int o_conf_break(int pargc, char **pargv)
{
  char buf[64];
  int p, i;

   *buf=0;

   if (strlen(pargv[0]) > 1) {

     strcat(buf, pargv[0]);

     for (i=0; opercon[i].command; i++) {

        if (!stricmp(opercon[i].command, buf)) {
            opercon[i].level = atoi(pargv[1]);
            return 0;
        }
     }


/*  We can just make it crap out here, since it wouldn't reach this far
 *  unless there is a problem anyways 
 */

     fatal_perror("Unknown Option \"%s\" in %s", pargv[0], O_CONFIG_FILE);
     return -1;

  }

  switch (pargv[0][0])
  {
     case '#':
       {
          return 0;
       }
     default:
       {
         fatal_perror("Unknown Field in oper conf file: (%c)\n", pargv[0][0]);
         return -1;
       }
   }

  return 0;
}


/**********************************************************************/

int check_o_access(const char *source, const char *command)
{
  int access = -1;
  int i=0;

  if (!source || !command)
     return 0;

  if (is_oper(source))
      access = 0;
  if (is_services_oper(source))
      access = 1;
  if (is_services_admin(source))
      access = 2;
  if (is_services_root(source))
      access = 3;
  if (is_services_coder(source))
      access = 4;

  for (i=0; opercon[i].command; i++) {
     if (stricmp(opercon[i].command, command) == 0) {
         if (access >= opercon[i].level)
              return 1;
     }
  }


  return 0;

}

/**********************************************************************/
/**********************************************************************/


void serv_os_help(const char *source, const char *service, const char *s)
{
   char *first;
   int i=0, x=0, y=0;

   notice(s, source, "%s Commands:", s);

   if ((!stricmp(s, "NickServ")) || (!stricmp(s, "ChanServ")))
      notice(s, source, "%15s", "FLIST");

   if (!stricmp(s, "OperServ")) {
      notice(s, source, "%15s %20s", "STATS", "MEM");
      notice(s, source, "%15s %20s", "SETTINGS", "VERSION");
      notice(s, source, "%15s", "GLOBAL");
   }

   if (!stricmp(s, "RootServ"))
       goto rootserv;


   for (i=0; opercon[i].command != NULL; i++) {

       if (((stricmp(opercon[i].service, service) == 0)
          || ((stricmp(opercon[i].service, "BOTH") == 0)
            && (!stricmp(s, "NickServ") || !stricmp(s, "ChanServ"))))
          && opercon[i].level == 0) {
             x++;
             if (x==1)
                first = sstrdup(opercon[i].command);
             else {
                notice(s, source, "%15s %20s", first, opercon[i].command);
                x=0;
             }
          }
   }
   if (x > 0)
       notice(s, source, "%15s", first); x=0;

   notice(s, source,
        "These commands are available to \2Services Operators\2:", s);

   for (i=0; opercon[i].command; i++) {
       if (((stricmp(opercon[i].service, service) == 0)
           || ((stricmp(opercon[i].service, "BOTH") == 0)
            && (!stricmp(s, "NickServ") || !stricmp(s, "ChanServ"))))
           && opercon[i].level == 1) {
             x++; y++;
             if (x==1)
                first = sstrdup(opercon[i].command);
             else {
                notice(s, source, "%15s %20s", first, opercon[i].command);
                x=0;
             }
          }
   }
   if (y == 0)
       notice(s, source, "No Commands Available");
   if (x > 0)
       notice(s, source, "%15s", first); x=0; y=0;


   notice(s, source,
        "These commands are available to \2Services Admins\2:");

   for (i=0; opercon[i].command; i++) {
       if (((stricmp(opercon[i].service, service) == 0)
           || ((stricmp(opercon[i].service, "BOTH") == 0)
            && (!stricmp(s, "NickServ") || !stricmp(s, "ChanServ"))))
           && opercon[i].level == 2) {
             x++; y++;
             if (x==1)
                first = sstrdup(opercon[i].command);
             else {
                notice(s, source, "%15s %20s", first, opercon[i].command);
                x=0;
             }
          }
   }
   if (y == 0)
       notice(s, source, "No Commands Available");
   if (x > 0)
       notice(s, source, "%15s", first); x=0; y=0;


rootserv:
   if (stricmp(service, "OS") != 0)
      notice(s, source,
          "These commands are available to \2Services Roots\2:");
   else
      notice(s, source,
          "For Services Roots commands type: /msg %s OHELP", s_RootServ);

   if (!stricmp(s, "RootServ"))
       notice(s, source, "%15s", "REFERENCE");


   for (i=0; opercon[i].command; i++) {
       if (((stricmp(opercon[i].service, service) == 0)
           || ((stricmp(opercon[i].service, "BOTH") == 0)
            && (!stricmp(s, "NickServ") || !stricmp(s, "ChanServ"))))
           && opercon[i].level > 2) {
             x++; y++;
             if (x==1) {
                if (opercon[i].level > 3)
                   sprintf(first, "[M] %s", opercon[i].command);
                else
                    first = sstrdup(opercon[i].command);
             } else {
                if (opercon[i].level == 3)
                   notice(s, source, "%15s %20s", first, opercon[i].command);
                else if (opercon[i].level > 3)
                   notice(s, source, "%15s %20s [M]",
                       first, opercon[i].command);
                x=0;
             }
          }
   }
   if ((y == 0) && (stricmp(service, "OS") != 0))
       notice(s, source, "No Commands Available");
   if (x > 0)
       notice(s, source, "%15s", first); x=0; y=0;


   if (!stricmp(s, "RootServ"))
        notice(s, source, "Other commands: QUIT, RESTART, SHUTDOWN");
   notice(s, source,
        "Type: \2/MSG %s OHELP <command>\2 for more information",s);

}

/**********************************************************************/

char *find_level(const char *cmd)
{
  int i=0;

   for (i=0; opercon[i].command; i++) {
      if (stricmp(cmd, opercon[i].command) == 0) {
          switch(opercon[i].level) {
             case 0:
                 return "IRC Operators";
             case 1:
                 return "Services Operators";
             case 2:
                 return "Services Administrators";
             case 3:
                 return "Services Roots";
             case 4:
                 return "Services Master";
             default:
                 return "IRC Operators";
          }
      }
   }
   return NULL;
}

/**********************************************************************/
/**********************************************************************/

