/*
 * SirvNET Services is copyright (c) 1998-2001 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * Originally based on EsperNet Services(c) by Andy Church.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

static const char *os_ohelp[] = {
"OperServ commands:",
"   GLOBAL     Send a message to all users",
"   STATS      Show status of Services and network",
"   MEM        Show memory status",
"   SETTINGS   View Services settings",
"   TRIGGER    Control clone warnings",
"   UINFO      View additional details about a client",
"   VERSION    Show version status",
"",
"Commands available to Services Operators only:",
"   AKILL      Manipulate the AKILL list",
"   CLEAR      Wipe channel modes/users",
"   IGNORE     Manipulate the IGNORE list",
"",
"Commands available to Services admins only:",
"   HOP        Modify the Help Operator list",
"   JUPE       \"Jupiter\" a server",
"   SOP        Modify the SOP list",
"   SENDLOGS   Have services send you logs",
"   SQLINE     Have serivces (UN)SQLINE a nick",
"   SGLINE     Have services (UN)GLINE a realname field",
"   UPDATE     Flush DataBases to disk",
"   ZLINE      Add a global Z:LINE to the network",
"",
"Commands available to the Services Roots only:",
"   -- REFER TO ROOTSERV --",
"",
"\2Notice:\2 Additional Information may be found via \"OHELP <command>\"",
"",
"\2Notice:\2 All commands sent to OperServ are logged!",
NULL
};

/*************************************************************************/

static const char *uinfo_help[] = {
"Syntax: UINFO \37nick\37",
"",
"Allows IRC Operators to view additional status about a client.",
"IE: Flood levels, or channels joined regardless of modes (+s)",
"The numbers surrounded in brackets in the flood settings is the",
"MOTD and VERSION request monitors, respectively.",
"*Note: If the user has registered a nick, sent a memo, or given",
"   invalid identify passwords, uinfo will display additional info.",
NULL
};

/*************************************************************************/

static const char *sqline_help[] = {
"Syntax: SQLINE \2{ADD|DEL|LIST} [nick] [\37reason\37]",
"",
"Services will send out a global s(ervices)q-line to all",
"servers. Also can be viewed via /stats q",
NULL
};

/*************************************************************************/

static const char *sgline_help[] = {
"Syntax: SGLINE \2{ADD|DEL|LIST} [*][<field>][*] : [\37reason\37]",
"",
"Services will send out a global s(ervices)g-line to all",
"servers. Any client connecting to a server that matches FIELD",
"in its \"real-name\" field will be disconnected.",
"Also can be shown via /stats g",
"Example: SGLINE ADD *IRC*?perat?r* : You're not an IRC Operator",
NULL
};

/*************************************************************************/


static const char *mode_help[] = {
"Syntax: MODE \37channel\37 \37modes\37",
"",
"Replaced by /samode.",
"Contact your administrator for more information",
NULL
};

/*************************************************************************/

static const char *clear_help[] = {
"Syntax: CLEAR \37channel\37 [OPS|BANS|MODES|USERS|VOICES]",
"Syntax: CLEAR \37channel\37 USERS <reason>",
"",
"Clears a specified channel of ops, bans, channel modes,",
"all clients, or voices.",
NULL
};
/*************************************************************************/

static const char *autokill_help[] = {
"Syntax: AUTOKILL ADD \37nick\37 \37reason\37",
"        AUTOKILL DEL [\37nick\37|\37num\37]",
"        AUTOKILL LIST",
"        AUTOKILL INFO [\37nick\37|\37num\37] -- [SRA]",
"",
"Allows IRCops to manipulate the AUTOKILL list.",
"The difference between AKILL and AUTOKILL is that an AKILL",
"bans the user by mask. An AUTOKILL only kills any user that",
"identifies to the nicks listed. AUTOKILL does not place a ban.",
"If a situation may arises, an online SOP may resort to an",
"AUTOKILL INFO, permits Services Roots to change a listed reason.",
"This may be used to inappropriate reasons, or to further describe",
"in detail what the AUTOKILL was placed for.",
"The \37reason\37 is intended for use by IRC operators only, and",
"will not be displayed to users in KILL messages.",
NULL
};




/*************************************************************************/


static const char *akill_help[] = {
"Syntax: AKILL ADD \37mask\37 \37reason\37",
"        AKILL TIME \37expiry\37 \37mask\37 \37reason\37",
"        AKILL DEL [\37mask\37|\37num\37]",
"        AKILL LIST [\37mask\37]",
"        AKILL INFO [\37mask\37|\37num\37] -- [SRA]",
"",
"Allows IRCops to manipulate the AKILL list.  If a user",
"matching an AKILL mask attempts to connect, Services will",
"issue a KILL for that user and, on supported server types,",
"will instruct all servers to add a ban (K-line) for the",
"mask which the user matched.",
"",
"AKILL ADD adds the given user@host mask to the AKILL",
"list for the given reason (which \2must\2 be given).",
"AKILL DEL removes the given mask from the AKILL list if it",
"is present.  AKILL LIST shows all current AKILLs; if the",
"optional mask is given, the list is limited to those",
"AKILLs matching the mask.  AKILL VIEW is a more verbose",
"version of AKILL LIST, and will show who added an AKILL,",
"the date it was added, and when it expires, as well as the",
"user@host mask and reason.",
"",
"Optionally, an expiry time can be given with the AKILL TIME",
"command.  The expiry time precedes the user@host mask, and",
"is specified as an integer followed by one of \37d\37 (days),",
"\37h\37 (hours), or \37m\37 (minutes).  Combinations (such as \371h30m\37)",
"are not permitted.  If a unit specifier is not included,",
"the default is days (so \37+30\37 by itself means 30 days).  To",
"add an AKILL which does not expire, use \37+0\37.  If the",
"usermask to be added starts with a \37+\37, an expiry time must",
"be given, even if it is the same as the default.  The",
"current AKILL default expiry time can be found with the",
"\2SETTINGS\2 command.",
"",
"AKILL INFO, permits Services Roots to change an akill reason.",
"This may be used to inappropriate reasons, or to further describe",
"in detail what the AKILL was places for",
"The \37reason\37 is intended for use by IRC operators only, and",
"will not be displayed to users in KILL messages.",
NULL
};

/*************************************************************************/

static const char *settings_help[] = {
"Syntax: \2SETTINGS\2",
"",
"Settings shows a variety of services settings to operators.",
"Each setting is explained briefly below:",
"",
"Default Akill: If an akill time isn't specified, this is default",
"",
"Clone Trigger - Default number of clones to set off warning.",
"Wait Warnings - If clones continue, this setting controls",
"                the time between warnings.",
"",
"Memo Limit  - Max # of memos per nick account.",
"Memo Length - Max characters permitted per memo.",
" Send Wait  - x time to elapse before next memo send",
"",
"Expiry Times - Time for nicks/chans/memo to expire",
"Maximums - Max ammount of the given category permitted",
"",
"Nick Release - Time until dropping enforced nick",
"Bad PW Limit - x ammount of bad passes until killed",
"Max Chan Reg - Ammount of channels allowed per nick",
"",
"Flood Levels: Flood levels have 3 status numbers.",
"   (first) LEV: There are 4 flood levels. If a user reaches",
"                one of these levels, it does not reset until",
"                the user goes offline.",
" (second) TLEV: Temp Level - This climbs with ever service command",
"                sent from the client. This number resets if a LEV",
"                level is reached. (usually around 10).",
" (third) RESET: This is the time it takes until the TLEV value",
"                is reset.",
" Summary: In a nutshell, if TLEV reaches a certain peak, it",
"  increases LEV, then resets until it reaches the next LEV.",
"  LEV 2 warns the network, LEV 3 warns SEVERELY, and",
"  LEV 4 then kills the user.",
"",
"Update Timeout - Time between database expire/update",
"Options - Options current enabled",
"        NOTE: RNC - Real Name Catching",
NULL
};

/*************************************************************************/

static const char *stats_help[] = {
"Syntax: \2STATS\2",
"",
"Stats shows a variety of services statistics to operators.",
"Each statstic is explained briefly below:",
"",
"Current Users: User count discluding service clients",
"Nicks/Chans/Akills/Jupes/Qlines - Straight forward statistics.",
"",
"Services up: Uptime of services",
"Services Commands: Counts the amount of services commands received.",
" A = ALL (since uptime), D = Daily, H = Hourly, M = Minutely",
NULL
};

/************************************************************************/

static const char *jupe_help[] = {
"Syntax: \2JUPE {ADD|DEL|LIST} \37server\37 [\37reason\37]\2",
"",
"Tells Services to jupiter a server -- that is, to create",
"a fake \"server\" connected to Services which prevents",
"the real server of that name from connecting.  The jupe",
"may \2not\2 be removed using a standard \2SQUIT\2.",
"To be used \2only\2 in a situation where a server is",
"disrupting the network and must be juped.",
NULL
};

/*************************************************************************/

static const char *trigger_help[] = {
"Syntax: \2TRIGGER [\37user@host\37] [\37value\37]",
"        \2TRIGGER [\37host\37] [\37value\37]",
"",
"Trigger is used to control clone warnings.",
"The value specified will be the number of clones",
"from that user@host until services warns the network.",
"If the user@host already exists, the value is",
"re-triggered, and the network is notified",
"If setting the value to 0 will reset the trigger.",
"NOTE: If services has automatic clone akill enabled,",
"      triggered hosts will never be auto-akilled.",
NULL
};

/*************************************************************************/
static const char *sendlog_help[] = {
"Syntax: \2SENDLOGS\2 [list]",
"",
"SENDLOGS is a toggle option to have services send",
"logs to your email alias. If SENDLOGS is turned off",
"for your nick, this command will turn it on, and if",
"SENDLOGS is turned on, this command will turn it off.",
"When the LIST paramater is specified, a list of people",
"who are receiving logs are listed.",
"",
"\2Your NickServ email field must be valid for this to work!\2",
NULL
};
/*************************************************************************/

static const char *ignore_help[] = {
"Syntax: IGNORE ADD \37mask\37",
"        IGNORE TIME \37expiry\37 \37mask\37",
"        IGNORE DEL [\37mask\37|\37num\37]",
"        IGNORE LIST [\37mask\37]",
"",
"IGNORE is a useful tool to prevent abusive users",
"from using services. When an ignore mask is set,",
"any user matches the mask will be ignored by services.",

"IGNORE ADD adds the given user@host mask to the IGNORE list.",
"IGNORE DEL removes the given mask from the IGNORE list if it",
"is present.  IGNORE LIST shows all current IGNOREs; if the",
"optional mask is given, the list is limited to those",
"IGNOREs matching the mask.",
"",
"Optionally, an expiry time can be given with the TIME",
"command.  The expiry time precedes the user@host mask, and",
"is specified as an integer followed by one of \37d\37 (days),",
"\37h\37 (hours), or \37m\37 (minutes).  Combinations (such as \371h30m\37)",
"are not permitted.  If a unit specifier is not included,",
"the default is days (so \37+30\37 by itself means 30 days).  To",
"add an IGNORE which does not expire, use \37+0\37.  If the",
"usermask to be added starts with a \37+\37, an expiry time must",
"be given, even if it is the same as the default.  The",
"current IGNORE default expiry time can be found with the",
"\2SETTINGS\2 command.",
NULL
};

/*************************************************************************/

static const char *zline_help[] = {
"Syntax: ZLINE ADD \37IP\37 \37reason\37",
"        ZLINE DEL \37IP\37",
"",
"ZLINE is a powerful banning utility. It works the same",
"way as the ircd /zline command, except it is added to",
"all servers. Services ZLINES may be viewed via",
"/STATS K (will be shown as S:IP).",
"",
"ZLINES are similar to k:lines, but are much more powerful.",
"A ZLINE will not allow any users from the specified IP,",
"very useful to prevent vhost evading/cloning.",
"Many abusers evade bans by using vhosts which can be found",
"on the same C-class IP. Wild cards are valid, for example,",
"adding a ZLINE for 200.200.200.* is legal, preventing all",
"users from that C-class IP.",
"",
"When using the ADD command, the \37reason\37 MUST be",
"specified.",
NULL
};

static const char *os_acc_help[] = {
"The HOP, SOP, SA, and SRA commands all work the same.",
"Syntax: <level> ADD \37nick\37",
"Syntax: <level> DEL \37nick\37",
"Syntax: <level> LIST",
"",
"HOP (Help Operators) are set +h when they identifiy",
"to their nick, allowing them to see /help messages.",
"",
"SOP (Services Operators) should only be given to",
"IRC Operators. SOPs have additional privledges that",
"regular IRC Operators do not. Commands such as AKILL,",
"and IGNORE.",
"",
"SA (Services Administrators) have even more privledges",
"than the SOP level. More powerful commands such as",
"JUPE and GETPASS are available.",
"Only trusted IRC Operators should have this level."
"",
"SRA (Services Root) is the highest level that may",
"be achieved. Only a selected few should have this",
"level of services access. SRA level gives dangerous",
"commands such as SHUTDOWN and SRAW (Services raw).",
"",
"All commands available for each level are clearily",
"defined in the OHELP index files.",
"IE: /msg operserv OHELP, /msg chanserv OHELP, etc",
NULL
};
