/*
 * SirvNET Services is copyright (c) 1998-2001 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */


static const char *rs_ohelp[] = {
"RootServ commands:",
"   CHANSNOOP   Channel Snoop Feature",
"   FLOODRESET  Reset someone's flev",
"   INJECT      Send Raw command to Services",
"   REHASH      Rehash the services.conf and oper.conf files",
"   SET         Set various global Services options",
"   SA          Modify the Services admin list",
"   SRA         Modify the Services Root list",
"   SRAW        Send Raw command to Server",
"",
"   SRA OTHER: RESTART, QUIT, SHUTDOWN",
"",
"\2Notice:\2 Additional Information may be found via \"OHELP <command>\"",
"",
"\2Notice:\2 All commands sent to OperServ are logged!",
NULL
};

/*************************************************************************/
/*************************************************************************/

static const char *reference_help[] = {
"Syntax: REFERENCE [NS|CS|MS]",
"",
"Lists all log/snoop references for the specified service.",
"",
"Example: REFERENCE NS",
NULL
};

/*************************************************************************/

static const char *chansnoop_help[] = {
"Syntax: CHANSNOOP [\2ON\2|\2OFF\2] [<\37channel\37]> [<\37nick!user@host\37>] [realname]",
"",
"CHANSNOOP sends a pseudo client into the given channel",
"and then copies any channel text into the SRA snooping channel.",
"You can have any user nick and mask you want for services to use.",
"REALNAME is what will appear in the \"real name\" field of /whois.",
"If REALNAME isn't given, a default will be used.",
"This command should only be used for investigation purposes.",
"",
"Example: CHANSNOOP ON #sirv zErOcOOl!bad@ip-4.shhhh.sirv.net",
"Example: CHANSNOOP ON #sirv zErOcOOl!bad@ip-4.shhhh.sirv.net hello",
"Example: CHANSNOOP OFF",
NULL
};

/*************************************************************************/

static const char *search_help[] = {
"Syntax: SEARCH [\2TODAY\2|\2HISTORY\2] <[*]string[*]>",
"",
"\2SEARCH\2 allows services roots to retreive any",
"case-insensitive sub-string search from the log files.",
"If \2TODAY\2 is specified, then only the current day's",
"logfile will be searched. If \2HISTORY\2 is specified",
"then all dated logfiles will be searched.",
"",
"\2STRING\2 may contain wildcards. (* and ?).",
"\2STRING\2 should be either a nick, channel, or",
"host.",
"",
"-- NOTE: A * should usually be used at the beinning and",
"end of each search.",
"",
"Example: SEARCH history *Priority1*",
"Example: SEARCH history *Pri?rity1*",
"Example: SEARCH today *dialup-54-2??.myhost.com*",
"Example: SEARCH history *CS D #Sirv*",
NULL
};


/*************************************************************************/

static const char *inject_help[] = {
"Syntax: INJECT \2\37nick\37 \37service\37 \37service-command\37\2",
"",
"Inject allows Services Roots to inject any services command",
"to ay online client.",
"",
"Example: INJECT Priority1 NickServ info TeRReT",
NULL
};

/*************************************************************************/

static const char *set_help[] = {
"Syntax: \2SET \37option\37 \37setting\37\2",
"",
"Sets various global Services options.  Option names",
"currently defined are:",
"",
"    \2CLONES\2     Clone Detection",
"    \2DUMPLOG\2    Write to log files",
"    \2DUMPHTML\2   Write to html files",
"    \2FLOOD\2      Flood Levels",
"    \2IGNORE\2     Ignore code",
"    \2REALNAME\2   Real name catching",
"    \2READONLY\2   Set read-only or read-write mode",
"    \2SENDLOGS\2   Send Logs at 12:00am to SA+ sendlogs list",
NULL
};

/*************************************************************************/

static const char *set_readonly_help[] = {
"Syntax: \2SET READONLY [ON|OFF]\2",
"",
"Sets read-only mode on or off.  In read-only mode, normal",
"users will not be allowed to modify any Services data,",
"including channel and nickname access lists, etc. IRCops",
"will be able to modify Services' AKILL list and drop or",
"forbid nicknames and channels, but any such changes will",
"not be saved unless read-only mode is deactivated before",
"Services is terminated.",
"",
"This option is equivalent to the command-line option",
"\2-readonly\2.",
};

/*************************************************************************/

static const char *update_help[] = {
"Syntax: \2UPDATE\2",
"",
"Forces Services to update the channel, nick, and memo",
"databases as soon as you send the command.  Useful",
"before shutdowns.",
NULL
};

/************************************************************************/

static const char *quit_help[] = {
"Syntax: \2QUIT\2",
"",
"Causes Services to do an immediate shutdown.  It is",
"a good idea to update the databases using the",
"\2UPDATE\2 command beforehand.",
"\2NOTE:\2 This command is NOT to be toyed with--using",
"it without good reason can disrupt network operations,",
"especially if a person with access to restart Services",
"is not around.",
"Limited to \2Services Roots\2.",
NULL
};

/************************************************************************/

static const char *shutdown_help[] = {
"Syntax: \2SHUTDOWN\2",
"",
"Tells Services to shut down, but save databases.  It is",
"a \"clean\" alternative to \2QUIT\2.",
"\2NOTE:\2 This command is NOT to be toyed with--using",
"it without good reason can disrupt network operations,",
"especially if a person with access to restart Services",
"is not around.",
"Limited to \2Services Roots\2.",
NULL
}; 

/************************************************************************/

static const char *restart_help[] = {
"Syntax: \2RESTART\2",
"",
"Tells Services to save databases and restart (i.e. exit",
"and immediately re-run the executable).",
"Limited to \2Services Roots\2.",
NULL
};

/*************************************************************************/

static const char *sraw_help[] = {
"Syntax: \2SRAW \37text\37\2",
"",
"Sends a string of text directly to the server to which",
"Services is connected.  This command has a very limited",
"range of uses, and can wreak havoc on a network if used",
"improperly.  \2DO NOT USE THIS COMMAND\2 unless you are",
"absolutely certain you know what you are doing!",
NULL
};

/*************************************************************************/

static const char *admin_help[] = {
"Syntax: SA ADD \37nick\37",
"        SA DEL \37nick\37",
"        SA LIST",
"",
"Allows the Services Roots to add or remove nicknames",
"to or from the Services admin list.  A user whose nickname",
"is on the Services admin list and who has identified to",
"NickServ will be able to access Services admin commands.",
NULL
};

/*************************************************************************/
