/* Various routines to perform simple actions.
 *
 * SirvNET Services is copyright (c) 1998-2002 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * Originally based on EsperNet Services (c) by Andy Church.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#include "../inc/services.h"

/*************************************************************************/

/* Remove a user from the IRC network.  `source' is the nick which should
 * generate the kill, or NULL for a server-generated kill.
 */

void kill_user(const char *source, const char *user, const char *reason)
{
    char *av[2];

    if (!user || !*user)
	return;
    if (!source || !*source)
	source = SERVER_NAME;
    if (!reason)
	reason = "";
    av[0] = sstrdup(user);
    av[1] = smalloc(strlen(source)+strlen(reason)+4);
    sprintf(av[1], "%s (%s)", source, reason);
    do_kill(source, 2, av);
    send_cmd(source, "KILL %s :%s", av[0], av[1]);
    free(av[0]);
    free(av[1]);
}

/*************************************************************************/

/* Note a bad password attempt for the given user.  If they've used up
 * their limit, toss them off.
 */

void bad_password(User *u, char *target)
{
  if (BAD_PW_LIMIT == 0)
     return;
  else {
    time_t now = time(NULL);

    if (BAD_PW_TIMEOUT > 0) {
        if (u->invalid_pw_time > 0 && u->invalid_pw_time < now-BAD_PW_TIMEOUT)
            u->invalid_pw_count = 0;
    }
    u->invalid_pw_count++;
    u->invalid_pw_time = now;
    if (u->invalid_pw_count >= BAD_PW_LIMIT) {
         if (*target == '#') {
               slog("CS *I %s (%s!%s@%s) [Abusive - Killed]",
                    target, u->nick, u->username, u->host);
              do_break_log("CS_I", "CS *I %s (%s!%s@%s) [Abusive - Killed]",
                    target, u->nick, u->username, u->host);
              kill_user(s_ChanServ, u->nick, "Too many invalid chan passwords");
         } else {
               slog("NS *I %s (%s!%s@%s) [Abusive - Killed]",
                     target, u->nick, u->username, u->host);
               do_break_log("NS_I", "NS *I %s (%s!%s@%s) [Abusive - Killed]",
                    target, u->nick, u->username, u->host);
               kill_user(s_NickServ, u->nick, "Too many invalid nick passwords");
         }
     } 

   }
}

/*************************************************************************/
