/*
 * SirvNET Services is copyright (c) 1998-2002 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * Originally based on EsperNet Services(c) by Andy Church.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#include "../inc/services.h"

Channel *chanlist = NULL;

void get_sjoin_list(char *list, int newchan);
inline void extract_nicks();
static void add_suser(char *nick, char *channel);
static void update_last_used(const char *chan);
static void scheck_ops(char *chan, char **checklist, int count);

static int smembers = 1;
static int schans = 0;
static int ssize = 0;

static struct sjoin_list {
   char *nick;
} *slist = NULL;


/* Crappy little function to allocate sjoin memory */

inline void load_sjoin_mem()
{
       slist = smalloc(sizeof(*slist) * 1024);
       ssize = 1024;
}


/*************************************************************************/

/* Bahamut (TS3) SJOIN procedure */

void do_sjoin(char *source, int ac, char **av)
{
/*  SF = SJOIN Format.. 1.5 lost the dual TS */

   Channel *chan;
#if BAH_V >= 150
   int sf = 1;
#else
   int sf = 0;
#endif
   char *schan = av[2-sf];
   char *s, *who, *tmpwho;
   char *mv[3], *checklist[1024];
   int args = 0, start = 4, x=0, i=0;
   int newchan = 0, bogus=0, check=0;
   User *user;   

   checklist[0] = 0;

/* Did the server or client spawn the sjoin? */

   chan = findchan(av[2-sf]);
   if (!chan) {

      if (debug)
           log("Creating new channel %s via sjoin", av[2-sf]);

      chan = scalloc(sizeof(Channel), 1);
      chan->next = chanlist;
      if (chanlist)
          chanlist->prev = chan;
      chanlist = chan;
      strscpy(chan->name, av[2-sf], sizeof(chan->name));
      chan->creation_time = time(NULL);
      newchan = 1;

   }

/* Sweet, we don't need to go thru the entire sjoin process, rejoice! */

#if BAH_V >= 150
   if (!strchr(source, '.')) {
        if (!(user = finduser(source))) {
             bogus=0; smembers=0;
             goto bogus_join;
        }
        chan_adduser(user, schan);
        add_suser(source, chan->name);
        mv[0] = sstrdup(schan); mv[1] = "+o"; mv[2] = sstrdup(source);
        do_cmode(source, 3, mv);
        free(mv[0]); free(mv[2]);
        return;
   }
#endif

   if (stricmp(av[3-sf], "0") == 0)
      goto skipmodes;


   s = av[3-sf];


   while (*s) {
        switch(*s++) {

            case 'i':
                chan->mode |= CMODE_I;

                break;

            case 'm':
                chan->mode |= CMODE_M;
                break;

           case 'M':
                chan->mode |= CMODE_m;
                break;

            case 'R':
                chan->mode |= CMODE_r;
                break;

            case 'n':
                chan->mode |= CMODE_N;
                break;

            case 'p':
                chan->mode |= CMODE_P;
                break;

            case 's':
                chan->mode |= CMODE_S;
                break;

            case 't':
                chan->mode |= CMODE_T;
                break;

            case 'c':
                chan->mode |= CMODE_C;
                break;

            case 'O':
                chan->mode |= CMODE_o;
                break;


            case 'l':
                if (chan->limit > 0)
                   chan->limit = 0;
                chan->limit = atoi(av[4-sf]);

                break;



            case 'k':
                if (chan->key) {
                   free(chan->key);
                   chan->key = NULL;
                }
                if (chan->limit)
                     chan->key = sstrdup(av[5-sf]);
                else
                     chan->key = sstrdup(av[4-sf]);
                args++;
                break;

        }
    
   }         



#ifndef SKELETON
     check_modes(chan->name);
#endif


   if (stricmp(av[3-sf], "+") != 0) {

       if (chan->key && (chan->limit > 0))
           start += 2;    
       else if ((!chan->key && (chan->limit > 0)) || 
                 (chan->key && (chan->limit == 0)))
           start++;
   }

skipmodes:


   mv[0] = sstrdup(chan->name);

   get_sjoin_list(av[start-sf], newchan);

/* incase of lag, or akills processed before the sjoin synch, we gotta
   search for bogus users.. if all of the users are bogus (like 20 clones)
   then we must delete the channel as well */

  for (x = 0; x < smembers; x++) {

         if (strchr(slist[x].nick, '@') && strchr(slist[x].nick, '+')) {
             if (!(user = finduser(strtok(slist[x].nick, "@+")))) {
                bogus++; continue;
             }
             mv[2] = sstrdup(user->nick);
             add_suser(mv[2], mv[0]);
#ifndef SKELETON
             if (check_valid_op(user, mv[0], 1)) {
#endif
                mv[1] = "+o";
                do_cmode(source, 3, mv);
                update_last_used(mv[0]);

#ifndef SKELETON
             } else {
                 send_cmd(s_ChanServ, "MODE %s -o %s", mv[0], mv[2]);
                 notice(s_ChanServ, mv[2],
                   "This channel has been registered with %s.", s_ChanServ);
                 i = -5;
             }
#endif
             mv[1] = "+v";
             do_cmode(source, 3, mv);
             
         } else if (strchr(slist[x].nick, '@')) {
             if (!(user = finduser(strtok(slist[x].nick, "@")))) {
                bogus++; continue;
             }
             mv[2] = sstrdup(user->nick);
             add_suser(mv[2], mv[0]);
#ifndef SKELETON
             if (check_valid_op(user, mv[0], 1)) {
#endif
                mv[1] = "+o";
                do_cmode(source, 3, mv);
                update_last_used(mv[0]);

#ifndef SKELETON
             } else {
                 send_cmd(s_ChanServ, "MODE %s -o %s", mv[0], mv[2]);
                 notice(s_ChanServ, mv[2],
                   "This channel has been registered with %s.", s_ChanServ);
                 i = -5;
             }
#endif
         } else if (strchr(slist[x].nick, '+')) {
             if (!(user = finduser(strtok(slist[x].nick, "+")))) {
                bogus++; continue;
             }
             mv[2] = sstrdup(user->nick);
             add_suser(mv[2], mv[0]);
             mv[1] = "+v";
             do_cmode(source, 3, mv);

         } else {
             if (!(user = finduser(slist[x].nick))) {
                bogus++; continue;
             }
             mv[2] = sstrdup(slist[x].nick);
             add_suser(mv[2], mv[0]);
         }
         if ((bogus == smembers) && newchan)
             goto bogus_join;
      
      if (!is_chanop(mv[2], schan) && (i != -5))
           checklist[check++] = user->nick;

      free(slist[x].nick); slist[x].nick = sstrdup(mv[2]);
      free(mv[2]);


#ifndef SKELETON
      check_welcome(user, chan->name);
      if (newchan && (x < 1)) /* x to prevent repeated topics */
            restore_topic(chan->name);
#endif

   mv[1] = NULL; 

   }
   if (checklist[0]) {
      scheck_ops(mv[0], checklist, check);
      checklist[0] = 0;
}
   free(mv[0]);

bogus_join:
   if ((bogus == smembers) && newchan) {
       if (chan->next)
            chan->next->prev = chan->prev;
       if (chan->prev)
            chan->prev->next = chan->next;
       else
            chanlist = chan->next;
       free(chan); free(mv[2]);
   }

   for (x = 0; x < smembers; x++) {
#ifndef SKELETON
       user = finduser(slist[x].nick);
       if (user) {
            check_kick(user, chan->name);
            if (!rec_services_root(user->nick))
                check_invite(user, chan->name);
       }

#endif
           free(slist[x].nick);
   }

}

/*************************************************************************/

static void add_suser(char *nick, char *channel)
{

   Channel *chan = findchan(channel);
   struct c_userlist *u; 
   struct u_chanlist *c;
   User *user = finduser(nick);


      u = smalloc(sizeof(struct c_userlist));
      u->next = chan->users;
      u->prev = NULL;
      if (chan->users)
         chan->users->prev = u;
      chan->users = u;
      u->user = user;


      c = smalloc(sizeof(*c));
      c->next = user->chans;
      c->prev = NULL;
      if (user->chans)
          user->chans->prev = c;
      user->chans = c;
      c->chan = findchan(chan->name);        

}


/*************************************************************************/


void get_sjoin_list(char *list, int newchan)
{
    char *tmp = strtok(list, " ");
    smembers = 1;

    slist[0].nick = sstrdup(tmp);
    if (newchan)
      ++schans;


    extract_nicks();
}

/*************************************************************************/

static void scheck_ops(char *chan, char **checklist, int count)
{

#ifndef SKELETON
  ChannelInfo *ci = cs_findchan(chan);
  Channel *c = findchan(chan);
  struct c_userlist *u;
  char buf[1024], buf2[128];
  User *user;
  int i, modes=0, acc=0;

  *buf=0; *buf2=0;


  if (!ci)
    return;

  for (i = 0; i < count; i++) {
    user = finduser(checklist[i]);
    if (!user)
        continue;

    acc = get_access(user, ci);

    if (acc == 3) {
        if (*buf)
           strcat(buf, " ");
        else
           strcat(buf2, "+");
        strcat(buf, user->nick);
        strcat(buf2, "v");
        modes++;
	u = smalloc(sizeof(struct c_userlist));
	u->next = c->voices;
	u->prev = NULL;
	if (c->voices)
	    c->voices->prev = u;
	c->voices = u;
	u->user = user;
    }
    if (acc > 3) {
        update_last_used(chan);
        if (*buf)
           strcat(buf, " ");
        else
           strcat(buf2, "+");


        strcat(buf, user->nick);
        strcat(buf2, "o");
        modes++;
	u = smalloc(sizeof(struct c_userlist));
	u->next = c->chanops;
	u->prev = NULL;
	if (c->chanops)
	    c->chanops->prev = u;
	c->chanops = u;
	u->user = user;
    }
    if (modes > 5) {
       send_cmd(s_ChanServ, "MODE %s %s %s", chan, buf2, buf);
       modes = 0;
       *buf = 0; *buf2 = 0;
    }
  }
  if (*buf)
     send_cmd(s_ChanServ, "MODE %s %s %s", chan, buf2, buf);
#endif

}

/*************************************************************************/

static void update_last_used(const char *chan)
{
#ifndef SKELETON
   ChannelInfo *ci = cs_findchan(chan);

   if (!ci)
      return;
   else
      ci->last_used = time(NULL);
#endif

}

/*************************************************************************/

void extract_nicks()
{
   char *tmp;
   int i = 1;

   while ((tmp = strtok(NULL, " ")) != NULL)
   {
       slist[i++].nick = sstrdup(tmp);
   }

   smembers = i;

}


/*************************************************************************/



/* Return statistics.  Pointers are assumed to be valid. */

void get_channel_stats(long *nrec, long *memuse)
{
    long count = 0, mem = 0;
    Channel *chan;
    struct c_userlist *cu;
    int i;

    for (chan = chanlist; chan; chan = chan->next) {
	count++;
	mem += sizeof(*chan);
	if (chan->topic)
	    mem += strlen(chan->topic)+1;
	if (chan->key)
	    mem += strlen(chan->key)+1;
	mem += sizeof(char *) * chan->bansize;
	for (i = 0; i < chan->bancount; i++) {
	    if (chan->bans[i])
		mem += strlen(chan->bans[i])+1;
	}
	for (cu = chan->users; cu; cu = cu->next)
	    mem += sizeof(*cu);
	for (cu = chan->chanops; cu; cu = cu->next)
	    mem += sizeof(*cu);
	for (cu = chan->voices; cu; cu = cu->next)
	    mem += sizeof(*cu);
    }
    *nrec = count;
    *memuse = mem;
}

/*************************************************************************/

/* Return the Channel structure corresponding to the named channel, or NULL
 * if the channel was not found. */

Channel *findchan(const char *chan)
{
    Channel *c = chanlist;

    while (c) {
	if (stricmp(c->name, chan) == 0)
	    return c;
	c = c->next;
    }
    return NULL;
}

/*************************************************************************/

/* Add/remove a user to/from a channel, creating or deleting the channel as
 * necessary. */

void chan_adduser(User *user, const char *chan)
{
    Channel *c = findchan(chan);
    int newchan = !c;
    struct c_userlist *u;


#ifndef BAHAMUT
    if (newchan) {
	if (debug)
	    log("debug: Creating channel %s", chan);
	/* Allocate pre-cleared memory */
	c = scalloc(sizeof(Channel), 1);
	c->next = chanlist;
	if (chanlist)
	    chanlist->prev = c;
	chanlist = c;
	strscpy(c->name, chan, sizeof(c->name));
	c->creation_time = time(NULL);

#ifndef SKELETON
	/* This will restore locked modes and saved topic */

        check_invite(user, chan);
	check_modes(chan);
        restore_topic(chan);

#endif
    }
#endif  /* not bahamut */

#ifndef SKELETON    
    if (check_should_voice(user, chan)) {
	u = smalloc(sizeof(struct c_userlist));
	u->next = c->voices;
	u->prev = NULL;
	if (c->voices)
	    c->voices->prev = u;
	c->voices = u;
	u->user = user;
    }

    if (!check_opguard(user, chan) || newchan)
        ;

    else if (check_should_op(user, chan)) {
	u = smalloc(sizeof(struct c_userlist));
	u->next = c->chanops;
	u->prev = NULL;
	if (c->chanops)
	    c->chanops->prev = u;
	c->chanops = u;
	u->user = user;
    }

#endif

#ifndef BAHAMUT
    u = smalloc(sizeof(struct c_userlist));
    u->next = c->users;
    u->prev = NULL;
    if (c->users)
	c->users->prev = u;
    c->users = u;
    u->user = user;
#endif

}

void chan_deluser(User *user, Channel *c)
{
    struct c_userlist *u;
    struct c_userlist *u2;
    int i;

    if (!user || !c)
       return;

    u2 = c->users;
    if (!u2)
      return;

    for (u = c->users; u && u->user != user; u = u->next)
	;
    if (!u)
	return;
    if (u->next)
	u->next->prev = u->prev;
    if (u->prev)
	u->prev->next = u->next;
    else
	c->users = u->next;
    free(u);


    for (u = c->chanops; u && u->user != user; u = u->next)
    ;
    if (u) {
	if (u->next)
	    u->next->prev = u->prev;
	if (u->prev)
	    u->prev->next = u->next;
	else
	    c->chanops = u->next;
	free(u);
    }

    for (u = c->voices; u && u->user != user; u = u->next)
	;
    if (u) {
	if (u->next)
	    u->next->prev = u->prev;
	if (u->prev)
	    u->prev->next = u->next;
	else
	    c->voices = u->next;
	free(u);
    }

    if (!c->users) {
        --schans;
	if (debug)
	    log("debug: Deleting channel %s", c->name);
	if (c->topic)
	    free(c->topic);
	if (c->key)
	    free(c->key);
	if (c->bancount) {
	    int i;
	    for (i = 0; i < c->bancount; ++i)
		free(c->bans[i]);
	}
	if (c->bansize)
	    free(c->bans);
	if (c->chanops || c->voices)
	    log("channel: Memory leak freeing %s: %s%s%s %s non-NULL!",
			c->name,
			c->chanops ? "c->chanops" : "",
			c->chanops && c->voices ? " and " : "",
			c->voices ? "c->voices" : "",
			c->chanops && c->voices ? "are" : "is");
	if (c->next)
	    c->next->prev = c->prev;
	if (c->prev)
	    c->prev->next = c->next;
	else
	    chanlist = c->next;
	free(c);
    }
}

/*************************************************************************/

/* Handle a channel MODE command. */

void do_cmode(const char *source, int ac, char **av)
{
    Channel *chan;
    struct c_userlist *u;
    User *user;
    char *s, *nick;
    int add = 1;		/* 1 if adding modes, 0 if deleting */
    int serverop = 0;
    char *modestr = av[1];

    chan = findchan(av[0]);
    if (!chan) {
	log("channel: MODE %s for nonexistent channel %s",
                                     merge_args(ac-1, av+1), av[0]);
	return;
    }
    s = modestr;
    ac -= 2;
    av += 2;

    while (*s) {

	switch (*s++) {

	case '+':
	    add = 1; break;

	case '-':
	    add = 0; break;

	case 'i':
	    if (add)
		chan->mode |= CMODE_I;
	    else
		chan->mode &= ~CMODE_I;
	    break;

	case 'm':
	    if (add)
		chan->mode |= CMODE_M;
	    else
		chan->mode &= ~CMODE_M;
	    break;

	case 'O':
	    if (add)
		chan->mode |= CMODE_o;
	    else
		chan->mode &= ~CMODE_o;
	    break;

	case 'M':
	    if (add)
		chan->mode |= CMODE_m;
	    else
		chan->mode &= ~CMODE_m;
	    break;


        case 'R':
	    if (add)
                chan->mode |= CMODE_r;
	    else
                chan->mode &= ~CMODE_r;
	    break;

	case 'n':
	    if (add)
		chan->mode |= CMODE_N;
	    else
		chan->mode &= ~CMODE_N;
	    break;

	case 'p':
	    if (add)
		chan->mode |= CMODE_P;
	    else
		chan->mode &= ~CMODE_P;
	    break;

	case 's':
	    if (add)
		chan->mode |= CMODE_S;
	    else
		chan->mode &= ~CMODE_S;
	    break;

	case 't':
	    if (add)
		chan->mode |= CMODE_T;
	    else
		chan->mode &= ~CMODE_T;
	    break;

	case 'c':
	    if (add)
		chan->mode |= CMODE_C;
	    else
		chan->mode &= ~CMODE_C;
	    break;

	case 'k':
	    if (chan->key) {
		free(chan->key);
		chan->key = NULL;
	    }
	    if (add)
		chan->key = sstrdup(*av++);
	    break;

	case 'l':
	    if (add) {
		chan->limit = atoi(*av++);
	    } else {
		chan->limit = 0;
	    }
	    break;

	case 'b':
	    if (--ac < 0) {
		log("channel: MODE %s %s: missing parameter for %cb",
					chan->name, modestr, add ? '+' : '-');
		break;
	    }
	    if (add) {
		if (chan->bancount >= chan->bansize) {
		    chan->bansize += 8;
		    chan->bans = srealloc(chan->bans,
					sizeof(char *) * chan->bansize);
		}
		chan->bans[chan->bancount++] = sstrdup(*av++);
	    } else {
		char **s = chan->bans;
		int i = 0;
		while (i < chan->bancount && strcmp(*s, *av) != 0) {
		    ++i; ++s;
		}
		if (i < chan->bancount) {
		    --chan->bancount;
		    if (i < chan->bancount)
			bcopy(s+1, s, sizeof(char *) * (chan->bancount-i));
		}
		++av;
	    }
	    break;

	case 'o':
	    if (--ac < 0) {
		log("channel: MODE %s %s: missing parameter for %co",
					chan->name, modestr, add ? '+' : '-');
		break;
	    }
	    nick = *av++;
	    if (add) {
		for (u = chan->chanops; u && stricmp(u->user->nick, nick) != 0;
								u = u->next)
		    ;
		if (u)
		    break;
		user = finduser(nick);
		if (!user) {
		    log("channel: MODE %s +o for nonexistent user %s",
							chan->name, nick);
		    break;
		}

		if (debug)
		    log("debug: Setting +o on %s for %s", chan->name, nick);
#ifndef SKELETON
/*
 *              if (stricmp(source, s_ChanServ) == 0)
 *                    serverop = 1;
 *              if (!check_valid_op(user, chan->name, serverop)) {
 *                     send_cmd(s_ChanServ, "MODE %s -o %s", chan->name, nick);
 *                     break;
 *              } else {
 */
#endif
		u = smalloc(sizeof(*u));
		u->next = chan->chanops;
		u->prev = NULL;
		if (chan->chanops)
		    chan->chanops->prev = u;
		chan->chanops = u;
		u->user = user;

#ifndef SKELETON

#endif
	    } else {
		for (u = chan->chanops; u && stricmp(u->user->nick, nick);
								u = u->next)
		    ;
		if (!u)
		    break;
		if (u->next)
		    u->next->prev = u->prev;
		if (u->prev)
		    u->prev->next = u->next;
		else
		    chan->chanops = u->next;
		free(u);
	    }
	    break;

	case 'v':
	    if (--ac < 0) {
		log("channel: MODE %s %s: missing parameter for %cv",
					chan->name, modestr, add ? '+' : '-');
		break;
	    }
	    nick = *av++;
	    if (add) {
		for (u = chan->voices; u && stricmp(u->user->nick, nick);
								u = u->next)
		    ;
		if (u)
		    break;
		user = finduser(nick);
		if (!user) {
		    log("channel: MODE %s +v for nonexistent user %s",
							chan->name, nick);
		    break;
		}
		if (debug)
		    log("debug: Setting +v on %s for %s", chan->name, nick);
		u = smalloc(sizeof(*u));
		u->next = chan->voices;
		u->prev = NULL;
		if (chan->voices)
		    chan->voices->prev = u;
		chan->voices = u;
		u->user = user;

	    } else {
		for (u = chan->voices; u && stricmp(u->user->nick, nick);
								u = u->next)
		    ;
		if (!u)
		    break;
		if (u->next)
		    u->next->prev = u->prev;
		if (u->prev)
		    u->prev->next = u->next;
		else
		    chan->voices = u->next;
		free(u);
	    }
	    break;

	} /* switch */

    } /* while (*s) */

#ifndef SKELETON
    /* Check modes against ChanServ mode lock */
         check_modes(chan->name);
#endif
}

/*************************************************************************/

/* Handle a TOPIC command. */

void do_topic(const char *source, int ac, char **av)
{
    Channel *c = findchan(av[0]);

    if (!c) {
	log("channel: TOPIC %s for nonexistent channel %s",
						merge_args(ac-1, av+1), av[0]);
	return;
    }
#ifndef SKELETON
    if (!strchr(source, '.')) {
        if (check_topiclock(source, av[0]))
           return;
    } else
           return;


#endif
    strscpy(c->topic_setter, av[1], sizeof(c->topic_setter));
    c->topic_time = atol(av[2]);
    if (c->topic) {
	free(c->topic);
	c->topic = NULL;
    }
    if (ac > 3 && *av[3])
	c->topic = sstrdup(av[3]);
#ifndef SKELETON
    record_topic(av[0]);
#endif
}

/*************************************************************************/

/* Does the given channel have only one user? */

/* Note:  This routine is not currently used, but is kept around in case it
 * might be handy someday. */

#if 0
int only_one_user(const char *chan)
{
    Channel *c;

    for (c = chanlist; c; c = c->next) {
	if (stricmp(c->name, chan) == 0)
	    return (c->users && !c->users->next) ? 1 : 0;
    }
    return 0;
}
#endif

int isin_chan(char *nick, const char *chan)
{
    Channel *c;
    struct c_userlist *cu;

    for (c = chanlist; c; c = c->next) {
        if (stricmp(c->name, chan) == 0) {
	    for (cu = c->users; cu; cu = c->users->next) {
		if (stricmp(cu->user->nick, nick) == 0)
		    return 1;
	    }
	    return 0;
	}
    }
    return 0;
}


/*************************************************************************/
