
/*
 * SirvNET Services is copyright (c) 1998-2002 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#include "../inc/services.h"

char *REMOTE_SERVER = NULL;
unsigned long REMOTE_PORT = 0;
char *PASSWORD = NULL;
char *SERVER_NAME = NULL;
char *SERVER_DESC = NULL;
char *SERVICES_USER = NULL;
char *SERVICES_HOST = NULL;
char *NETWORK_NAME = NULL;
char *SERVICES_MASTER = NULL;

char *remote_server = NULL;    /* -remote server[:port] */
unsigned long remote_port = 0;
char *password = NULL;
char *server_name = NULL;        /* -name servername */
char *server_desc = NULL;        /* -desc serverdesc */
char *services_user = NULL;    /* -user username */
char *services_host = NULL;    /* -host hostname */

char *NICKSERV_NAME = "NickServ";
char *CHANSERV_NAME = "ChanServ";
char *MEMOSERV_NAME = "MemoServ";
char *HELPSERV_NAME = "HelpServ";
char *OPERSERV_NAME = "OperServ";
char *ROOTSERV_NAME = "RootServ";
char *GLOBAL_NOTICER_NAME = "Global";

char *s_NickServ = "NickServ";
char *s_ChanServ = "ChanServ";
char *s_MemoServ = "MemoServ";
char *s_HelpServ = "HelpServ";
char *s_OperServ = "OperServ";
char *s_RootServ = "RootServ";
char *s_GlobalNoticer = "Global";

char *TIMEZONE = "GMT";
char *SLOG_FILENAME = "./logs/services.log";
char *HELPSERV_DIR = "helpfiles";
unsigned long UPDATE_TIMEOUT = 1800;
short UPDATE_TAGLINES = 0;
short TIMEOUT_CHECK = 2;
short READ_TIMEOUT = 9;
short BAD_PW_LIMIT = 5;
short BAD_PW_TIMEOUT = 3600;
short CHANNEL_MAXREG = 20;
short CHANNEL_EXPIRE = 30;
short AKICK_MAX = 100;
char *DEF_AKICK_REASON = "User has been banned from the channel";
short NS_REG_DELAY = 15;
short NICK_EXPIRE = 30;
short RELEASE_TIMEOUT = 30;
short DEF_MAX_MEMOS = 50;
short MEMO_SEND_WAIT = 5;
short MEMO_EXPIRE = 30;
/*
short MAX_SERVROOTS = 32;
short MAX_SERVADMINS = 32;
short MAX_SERVOPERS = 32;
short MAX_HELPOPS = 32;
*/
short MAX_AUTOKILLS = 256;
short MAX_JUPES = 12;
short MAX_TRIGGERS = 128;
int AKILL_DEF_EXPIRY = (24*60*60);
int IGNORE_DEF_EXPIRY = (24*60*60);
short CLONE_MIN_USERS = 5;
short CLONE_WARNING_DELAY = 10;
short MAX_MEMO_LENGTH = 255;
short ENABLE_LOGS = 1;
short CHAN_ACCESS_MAX = 900;
short USER_ACCESS_MAX = 20;
short MAX_SUSPEND = 256;
short ENABLE_R_MODES = 0;
short ENABLE_UMODE_a = 1;
short MAX_QLINES = 64;
short MAX_GLINES = 64;
short MAX_ZLINES = 128;
short ALLOW_EMAIL = 1;
short F_TLEV = 10;
short F_RESET = 15;
short BACKUP_DB = 10;
short USE_ABUSESERV = 0;
short CUSTOM_NOTICE = 0;
short GENERIC_NOTICE = 1;
short INCLUDE_AKILL_REASON = 1;
short EXTRA_SNOOP = 1;
char *snoopchan = "#Snoop";
short REG_SAVES = 0;
short DISPLAY_UPDATES = 1;
short CHANNEL_INHABIT = 15;
short MOTD_UPTIME = 1;
short MOTD_UPDATE = 1;
char *DEF_MLOCKS = "+nt";
char *RETURN_EMAIL = "sirv@localhost";
char *SENDMAIL_PATH = "/usr/sbin/sendmail";
char *hindex = "index.html";
short dumphtml = 0;
short AKILL_CLONES = 0;
char *CKILL_TIME = "30m";
short db_change = 1;
short authdel = 0;

short auth_email = 1;
short switch_list = 1;
short nsecure = 0;
short accsecure = 0;
short cremove = 1;

short TOPIC_PROBS = 0;
float AKILL_PERCENT = 50.0;
short REMINDER = 3;

short NOHOST_CONF = 0;
short AUTO_NOHOST = 0;

short getpass_enable = 1;
short listchans_enable = 1;
short enforce_default = 0;

char *services_roots[MAX_SERVROOTS];
char *services_admins[MAX_SERVADMINS];
char *services_opers[MAX_SERVOPERS];
char *services_helpers[MAX_HELPOPS];


// Auto Settings

#ifdef SKELETON
short realname = 0;
short clone_detect = 0;                   /* -SKELETION clone detection */

#else
short clone_detect = 1;                   /* -clone detection */
short realname = 1;
#endif
short readonly = 0;			/* -readonly */
short snoop = 0;
short dumplog = 1;
short allow_flood = 1;
short allow_ignore = 1;

// *Auto Settings


char *time_zone = "GMT";
char *slog_filename = "./logs/services.log";
short update_timeout = 1800;

static int conf_break();

void init_conf(void)
{
  FILE *conf;
  unsigned char linbuff[1024];
  char *pargv[100];
  char *tmp, tmp2;
  int p, i;


  if ((conf = fopen(CONFIG_FILE, "rb")) == NULL)
  {
    fatal_perror("Error opening configuration file = %s", CONFIG_FILE);
  }

  while (!feof(conf))
  {
     if ((fgets(linbuff, 1024, conf)) == NULL)
     {
         break;
     }
     p = 0;
     tmp = strtok(linbuff, ": \n\r,");

     if (tmp != NULL)
     {
         pargv[p++] = tmp;
         for(i=0; i < 3; i++) {
            while ((tmp = strtok(NULL, ": \n\r,")) != NULL)
            {
               pargv[p++] = tmp;
               if (p > 100) {
                  break;
               }
            }
         }
         if (conf_break(p, pargv) == -1) {
            log("Services Terminated on illegal configuration");
            exit(1);
         }
    }
  }
  fclose(conf);
  if (!REMOTE_SERVER) {
     fatal_perror("ERROR: Missing S: line");
     exit(1);
  } else if (!REMOTE_PORT) {
     fatal_perror("ERROR: Missing P: line");
     exit(1);
  } else if (!PASSWORD) {
     fatal_perror("ERROR: Missing X: line");
     exit(1);
  } else if (!SERVER_NAME) {
     fatal_perror("ERROR: Missing N: line");
     exit(1);
  } else if (!SERVER_DESC) {
     fatal_perror("ERROR: Missing D: line");
     exit(1);
  } else if (!SERVICES_USER) {
     fatal_perror("ERROR: Missing U: line");
     exit(1);
  } else if (!SERVICES_HOST) {
     fatal_perror("ERROR: Missing H: line");
     exit(1);
  } else if (!NETWORK_NAME) {
     fatal_perror("ERROR: Missing A: line");
     exit(1);
  } else if (!SERVICES_MASTER) {
     fatal_perror("ERROR: Missing M: line");
     exit(1);
  } else if (!ALLOW_EMAIL && auth_email) {
     fatal_perror("ERROR: Must have EMAIL enabled to use REGEMAIL");
     exit(1);
  } else if (!auth_email && nsecure) {
     fatal_perror("ERROR: Must have REGEMAIL enabled to use XAUTH");
     exit(1);
  } else if (!auth_email && accsecure) {
     fatal_perror("ERROR: Must have REGEMAIL enabled to use XAUTHACC");
     exit(1);
  } else if (!auth_email && authdel) {
     fatal_perror("ERROR: Must have REGEMAIL enabled to use AUTODEL");
     exit(1);

  } else
     return;
}


int conf_break(int pargc, char **pargv)
{
  char buf[64];
  int p, i;

   *buf=0;

   if (strlen(pargv[0]) > 1) {

     strcat(buf, pargv[0]);

     if ((pargc != 2) && (stricmp(buf, "AKICK_REASON") != 0)) {
        fatal_perror("Error in Option \"%s\"", pargv[0]);
        return -1;
     }
     if (!stricmp(buf, "NICKSERV") || !stricmp(buf, "NS")) {
         NICKSERV_NAME = sstrdup(pargv[1]);
         s_NickServ = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "CHANSERV") || !stricmp(buf, "CS")) {
         CHANSERV_NAME = sstrdup(pargv[1]);
         s_ChanServ = sstrdup(pargv[1]);
         return 0;
     
     } else if (!stricmp(buf, "MEMOSERV") || !stricmp(buf, "MS")) {
         MEMOSERV_NAME = sstrdup(pargv[1]);
         s_MemoServ = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "HELPSERV") || !stricmp(buf, "HS")) {
         HELPSERV_NAME = sstrdup(pargv[1]);
         s_HelpServ = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "OPERSERV") || !stricmp(buf, "OS")) {
         OPERSERV_NAME = sstrdup(pargv[1]);
         s_OperServ = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "ROOTSERV") || !stricmp(buf, "RS")) {
         ROOTSERV_NAME = sstrdup(pargv[1]);
         s_RootServ = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "GLOBAL")) {
         GLOBAL_NOTICER_NAME = sstrdup(pargv[1]);
         s_GlobalNoticer = sstrdup(pargv[1]);
         return 0;


     } else if (!stricmp(buf, "TIMEZONE") || !stricmp(buf, "TZ")) {
         TIMEZONE = sstrdup(pargv[1]);
         time_zone = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "LOG")) {
         SLOG_FILENAME = sstrdup(pargv[1]);
         slog_filename = sstrdup(pargv[1]);
         return 0;


     } else if (!stricmp(buf, "HELP")) {
          HELPSERV_DIR = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "UPDATE")) {
         UPDATE_TIMEOUT = atoi(pargv[1]);
         update_timeout = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "TAG")) {
         UPDATE_TAGLINES = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "TIMEOUT")) {
         TIMEOUT_CHECK = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "READ")) {
         READ_TIMEOUT = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "PW_LIMIT")) {
         BAD_PW_LIMIT = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "PW_TIMEOUT")) {
         BAD_PW_TIMEOUT = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "CHANREG")) {
         CHANNEL_MAXREG = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "CHANEXP")) {
         CHANNEL_EXPIRE = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "AKICK")) {
         AKICK_MAX = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "AKICK_REASON")) {
         char tmpbuf[256];
         int x = 1;
         *tmpbuf = 0;

         while(x < pargc) {
            strcat(tmpbuf, pargv[x]);
            x++;
            if (x < pargc)
                strcat(tmpbuf, " ");
         }

         DEF_AKICK_REASON = sstrdup(tmpbuf);
log("DEF: %s", DEF_AKICK_REASON);
         return 0;

     } else if (!stricmp(buf, "NICKREG")) {
         NS_REG_DELAY = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "NICKEXP")) {
         NICK_EXPIRE = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "RELEASE")) {
         RELEASE_TIMEOUT = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "MEMOMAX")) {
         DEF_MAX_MEMOS = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "MEMO_WAIT")) {
         MEMO_SEND_WAIT = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "MEMOEXP")) {
         MEMO_EXPIRE = atoi(pargv[1]);
         return 0;
     } else if (!stricmp(buf, "ROOTS")) {
         return 0;

     } else if (!stricmp(buf, "ADMINS")) {
         return 0;

     } else if (!stricmp(buf, "OPERS")) {
         return 0;

     } else if (!stricmp(buf, "HELPOPS")) {
         return 0;

     } else if (!stricmp(buf, "AKILLS")) {
         MAX_AUTOKILLS = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "JUPES")) {
         MAX_JUPES = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "TRIGGERS")) {
         MAX_TRIGGERS = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "AKILLEXP")) {
         AKILL_DEF_EXPIRY = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "IGNEXP")) {
         IGNORE_DEF_EXPIRY = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "CLONES")) {
         CLONE_MIN_USERS = atoi(pargv[1]);
         return 0;


     } else if (!stricmp(buf, "CLONE_WARN")) {
         CLONE_WARNING_DELAY = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "MEMO_LEN")) {
         MAX_MEMO_LENGTH = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "LOGS")) {
         ENABLE_LOGS = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "C_ACC_MAX")) {
         CHAN_ACCESS_MAX = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "U_ACC_MAX")) {
         USER_ACCESS_MAX = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SUSPEND")) {
         MAX_SUSPEND = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "R_MODES")) {
         ENABLE_R_MODES = atoi(pargv[1]);
         return 0;
     
     } else if (!stricmp(buf, "UMODE_a")) {
         ENABLE_UMODE_a = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "QLINES")) {
         MAX_QLINES = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "GLINES")) {
         MAX_GLINES = atoi(pargv[1]);
         return 0;
     
     } else if (!stricmp(buf, "ZLINES")) {
         MAX_ZLINES = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "EMAIL")) {
         ALLOW_EMAIL = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "TLEV")) {
         F_TLEV = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "RESET")) {
         F_RESET = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "BACKUP")) {
         BACKUP_DB = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "USE_ABUSE")) {
         USE_ABUSESERV = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SNOOPCHAN")) {
         snoopchan = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SET_FLOOD")) {
         allow_flood = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SET_IGNORE")) {
         allow_ignore = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SET_RO")) {
         readonly = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SET_CLONES")) {
         clone_detect = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SET_RN")) {
         realname = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SET_LOG")) {
         dumplog = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SET_SNOOP")) {
         snoop = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "CUSTOM")) {
         CUSTOM_NOTICE = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "GENERIC")) {
         GENERIC_NOTICE = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "AKILL_REASON")) {
         INCLUDE_AKILL_REASON = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "EXTRA_SNOOP")) {
         EXTRA_SNOOP = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "REG_SAVES")) {
         REG_SAVES = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "DISPLAY_UPDATES")) {
         DISPLAY_UPDATES = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "CHANNEL_INHABIT")) {
         CHANNEL_INHABIT = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "UPTIME")) {
         MOTD_UPTIME = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "MOTD_UPDATE")) {
         MOTD_UPDATE = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "GETPASS")) {
         getpass_enable = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "LISTCHANS")) {
         listchans_enable = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "ENFORCE")) {
         enforce_default = atoi(pargv[1]);
         return 0;



     } else if (!stricmp(buf, "MLOCK")) {
         char tmp[128];
         int add = 1;
         DEF_MLOCKS = sstrdup(pargv[1]);
            *tmp = 0;
            while (*DEF_MLOCKS) {
               switch(*DEF_MLOCKS++) {

                   case '+':
                      add = 1; strcat(tmp, "+"); break;

                   case '-':
                      add = 0; strcat(tmp, "-"); break;

                   case 'n':
                        strcat(tmp, "n");
                     break;

                   case 't':
                        strcat(tmp, "t");
                     break;

                   case 'i':
                        strcat(tmp, "i");
                     break;

                   case 'm':
                        strcat(tmp, "m");
                     break;

                   case 'p':
                        strcat(tmp, "p");
                     break;

                   case 's':
                        strcat(tmp, "s");
                    break;

                   case 'c':
                        strcat(tmp, "c");
                     break;

                   case 'R':
                        strcat(tmp, "R");
                     break;

                }
            }
            DEF_MLOCKS = sstrdup(tmp);
    
            if (!strchr(DEF_MLOCKS, 'n') && !strchr(DEF_MLOCKS, 't')
               && !strchr(DEF_MLOCKS, 'i') && !strchr(DEF_MLOCKS, 'm')
               && !strchr(DEF_MLOCKS, 's') && !strchr(DEF_MLOCKS, 'p')
               && !strchr(DEF_MLOCKS, 'c') && !strchr(DEF_MLOCKS, 'R')
               && !strchr(DEF_MLOCKS, '+')) {

            fatal_perror("Invalid MLOCKS \"%s\" in conf option MLOCK", pargv[1]);
            return -1;
         }
         return 0;


     } else if (!stricmp(buf, "TOPICFIX")) {
         TOPIC_PROBS = atoi(pargv[1]);
         return 0;

    } else if (!stricmp(buf, "PERCENT")) {
         AKILL_PERCENT = atof(pargv[1]);
         AKILL_PERCENT += .0;
         return 0;

    } else if (!stricmp(buf, "REMIND")) {
         REMINDER = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "AUTO_HIDE")) {
         AUTO_NOHOST = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "NOHOST")) {
         NOHOST_CONF = atoi(pargv[1]);
         return 0;


     } else if (!stricmp(buf, "RETURN")) {
         RETURN_EMAIL = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SENDMAIL")) {
         SENDMAIL_PATH = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "REGEMAIL")) {
         auth_email = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "LIST")) {
         switch_list = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "XAUTH")) {
         nsecure = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "XAUTHACC")) {
         accsecure = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "REMOVE")) {
         cremove = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "INDEX") || !stricmp(buf, "HINDEX")) {
         hindex = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "HTML")) {
         dumphtml = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "DEBUG")) {
         debug = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "CLONEKILL")) {
         AKILL_CLONES = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "CLONETIME")) {
         CKILL_TIME = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "DATACHANGE")) {
         db_change = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "AUTODEL")) {
         authdel = atoi(pargv[1]);
         return 0;


     } else {
        fatal_perror("Unknown Option \"%s\"", pargv[0]);
        return -1;
    }

   return 0;
  }

  switch (pargv[0][0])
  {
     case '#':
       {
          return 0;
       }
     case 'C':
       {
          if (pargc != 5) {
             fatal_perror("Invalid C: line");
             return -1;
          }
          SERVER_NAME = sstrdup(pargv[1]);
          server_name = sstrdup(pargv[1]);

          PASSWORD = sstrdup(pargv[2]);
          password = sstrdup(pargv[2]);

          REMOTE_SERVER = sstrdup(pargv[3]);
          remote_server = sstrdup(pargv[3]);

          REMOTE_PORT = atoi(pargv[4]);
          remote_port = atoi(pargv[4]);

          return 0;
       }
     case 'S':
       {
          if (pargc != 2) {
             fatal_perror("Invalid S: line");
             return -1;
          }
          log("(Accepted) Obselete S: line - read about C: line");
          REMOTE_SERVER = sstrdup(pargv[1]);
          remote_server = sstrdup(pargv[1]);
          return 0;
       }

     case 'P':
       {
          if (pargc != 2) {
             fatal_perror("Invalid P: line");
             return -1;
          }
          log("(Accepted) Obselete P: line - read about C: line");
          REMOTE_PORT = atoi(pargv[1]);
          remote_port = atoi(pargv[1]);
          return 0;
       }
     case 'X':
       {
          if (pargc != 2) {
             fatal_perror("Invalid X: line");
             return -1;
          }
          log("(Accepted) Obselete X: line - read about C: line");
          PASSWORD = sstrdup(pargv[1]);
          password = sstrdup(pargv[1]);
          return 0;
       }
     case 'N':
       {
          if (pargc != 2) {
             fatal_perror("Invalid N: line");
             return -1;
          }
          log("(Accepted) Obselete N: line - read about C: line");
          SERVER_NAME = sstrdup(pargv[1]);
          server_name = sstrdup(pargv[1]);

          return 0;
       }
     case 'D':
       {
          if (pargc == 0) {
            fatal_perror("Invalid D: line, DESC must contain atleast 1 param");
            return -1;
          }
          *buf = 0;
          i=1;

          while(i < pargc) {
             strcat(buf, pargv[i]);
             i++;
             if (i < pargc)
                strcat(buf, " ");
          }

          SERVER_DESC = sstrdup(buf);
          server_desc = sstrdup(buf);
          return 0;
       }
     case 'U':
       {
          if (pargc != 2) {
             fatal_perror("Invalid U: line");
             return -1;
          }
           SERVICES_USER = sstrdup(pargv[1]);
           services_user = sstrdup(pargv[1]);
          return 0;
       }
     case 'H':
       {
          if (pargc != 2) {
             fatal_perror("Invalid H: line");
             return -1;
          }
          SERVICES_HOST = sstrdup(pargv[1]);
          services_host = sstrdup(pargv[1]);
          return 0;
       }
     case 'A':
       {
          if (pargc != 2) {
             fatal_perror("Invalid A: line");
             return -1;
          }
          NETWORK_NAME = sstrdup(pargv[1]);
          return 0;
       }
     case 'M':
       {
          if (pargc != 2) {
             fatal_perror("Invalid M: line");
             return -1;
          }
          SERVICES_MASTER = sstrdup(pargv[1]);
          return 0;
       }
     default:
       {
         fatal_perror("Unknown Field in conf file: (%c)\n", pargv[0][0]);
         return -1;
       }
   }

  return 0;
}
