/*
 * SirvNET Services is copyright (c) 1998-2002 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#include "../inc/services.h"

char *log_filename = LOG_FILENAME;	/* -log filename */
char *log_day[1];

static void dump_html(const char *yday, const char *ymon);
static void kill_logs(const char *yday2, const char *ymon2);
void load_log_db(void);

FILE *logfile;
FILE *slogfile;

/*************************************************************************/
// Get Last Update Day

void load_log_db(void)
{
    FILE *f;
    int i;

    if (!(f = open_db("LOG", LOG_DB, "r")))
        return;
    switch (i = get_file_version(f, LOG_DB)) {
      case 5:
      case 6:
      case 7:
      case 8:
         i = fgetc(f)<<8 | fgetc(f);
         while (--i >= 0)
             log_day[0] = read_string(f, LOG_DB);
        break;
      default:
        fatal("Unsupported version (%d) on %s", i, LOG_DB);
    } /* switch (version) */

    close_db(f, LOG_DB);
}


void save_log_db(void)
{
    FILE *f;
    int i;
    unsigned count = 0;

    if (!(f = open_db("LOG", LOG_DB, "w")))
       return;

    for (i = 0; i < 1; i++) {
        if (log_day[i])
            count++;
    }

    fputc(count>>8, f);
    fputc(count & 255, f);
   if (log_day[0])
        write_string(log_day[0], f, LOG_DB);

    close_db(f, LOG_DB);
}

/*************************************************************************/
/*************************************************************************/

void save_sendlogs(void)
{
    FILE *f;
    int i;
    unsigned count = 0;

    if (!(f = open_db(s_OperServ, SENDLOG_DB, "w")))
        return;
    for (i = 0; i < MAX_SENDLOGS; i++) {
        if (sendlogs[i])
            count++;
    }
    fputc(count>>8, f);
    fputc(count & 255, f);
    for (i = 0; i < MAX_SENDLOGS; i++) {
        if (sendlogs[i])
            write_string(sendlogs[i], f, SENDLOG_DB);
    }
    close_db(f, SENDLOG_DB);
}

void load_sendlogs(void)
{
    FILE *f;
    int i;

    if (!(f = open_db(s_OperServ, SENDLOG_DB, "r")))
        return;
    switch (i = get_file_version(f, SENDLOG_DB)) {
      case 5:
      case 6:
      case 7:
      case 8:

        i = fgetc(f)<<8 | fgetc(f);
        while (--i >= 0)
            sendlogs[i] = read_string(f, SENDLOG_DB);
        break;
      default:
        fatal("Unsupported version (%d) on %s", i, SENDLOG_DB);
    } /* switch (version) */
    close_db(f, SENDLOG_DB);
}


/*************************************************************************/
/*************************************************************************/

/* Open the services log file. */

void create_dummy_logs(void)
{
  FILE *templog;

  templog = fopen("./logs/temp.log", "a");
  fclose(templog);
  templog = fopen("./logs/os.log", "a");
  fclose(templog);
  templog = fopen("./logs/as.log", "a");
  fclose(templog);
  templog = fopen("./logs/rs.log", "a");
  fclose(templog);
  templog = fopen("./logs/ns_id.log", "a");
  fclose(templog);
  templog = fopen("./logs/ns_reg.log", "a");
  fclose(templog);
  templog = fopen("./logs/ns_own.log", "a");
  fclose(templog);
  templog = fopen("./logs/ns_exp.log", "a");
  fclose(templog);
  templog = fopen("./logs/ns_gpd.log", "a");
  fclose(templog);
  templog = fopen("./logs/ns_flags.log", "a");
  fclose(templog);
  templog = fopen("./logs/cs_id.log", "a");
  fclose(templog);
  templog = fopen("./logs/cs_reg.log", "a");
  fclose(templog);
  templog = fopen("./logs/cs_own.log", "a");
  fclose(templog);
  templog = fopen("./logs/cs_exp.log", "a");
  fclose(templog);
  templog = fopen("./logs/cs_gpd.log", "a");
  fclose(templog);
  templog = fopen("./logs/cs_flags.log", "a");
  fclose(templog);
  templog = fopen("./logs/ms_oper.log", "a");
  fclose(templog);
  templog = fopen("./logs/ms_exp.log", "a");
  fclose(templog);
}


void open_log(void)
{
  if (logfile)
     return;
  logfile = fopen(LOG_FILENAME, "a");
  if (logfile)
        setbuf(logfile, NULL);
}

void close_log(void)
{
    if (!logfile)
	return;
    fclose(logfile);
    logfile = NULL;
}

void open_slog(void)
{
    if (slogfile)
	return;
    slogfile = fopen(slog_filename, "a");
    if (slogfile)
        setbuf(slogfile, NULL);
}

/* Close the services log file. */

void close_slog(void)
{
    if (!slogfile)
	return;
    fclose(slogfile);
    slogfile = NULL;
}

/*************************************************************************/


/* Log stuff to stderr with a datestamp. */

/* log() = Debug, slog = main log */

void slog(const char *fmt,...)
{
    va_list args;
    time_t t;
    struct tm tm;
    char buf[256];
    char tmp[256];
    char *service;

    va_start(args, fmt);
    time(&t);
    tm = *localtime(&t);
    strftime(buf, sizeof(buf)-1, "[%b %d %H:%M:%S %Y] ", &tm);


    if (slogfile) {
        fputs(buf, slogfile);
        vfprintf(slogfile, fmt, args);
        fputc('\n', slogfile);
    }
    if (nofork) {
	fputs(buf, stderr);
	vfprintf(stderr, fmt, args);
	fputc('\n', stderr);
    }

    if (snooplog_okay != 1)
      return;

    vsprintf(tmp, fmt, args);
    if (snoop == 1)
       send_cmd(s_OperServ, "PRIVMSG %s :%s", snoopchan, tmp);

}

void log(const char *fmt,...)
{
    va_list args;
    time_t t;
    struct tm tm;
    char buf[256];
    char tmp[256];

    if (!debug)
       return;

    va_start(args, fmt);
    time(&t);
    tm = *localtime(&t);
    strftime(buf, sizeof(buf)-1, "[%b %d %H:%M:%S %Y] ", &tm);

    if (logfile) {
	fputs(buf, logfile);
	vfprintf(logfile, fmt, args);
	fputc('\n', logfile);
    }
    if (nofork) {
	fputs(buf, stderr);
	vfprintf(stderr, fmt, args);
	fputc('\n', stderr);
    }

    if (snooplog_okay != 1)
      return;

    vsprintf(tmp, fmt, args);
    if (snoop == 1 && sndebug)
       send_cmd(s_OperServ, "PRIVMSG %s :%s", snoopchan, tmp);

}

/* Like log(), but tack a ": " and a system error message (as returned by
 * strerror()) onto the end.
 */

void log_perror(const char *fmt,...)
{
    va_list args;
    time_t t;
    struct tm tm;
    char buf[256];

    va_start(args, fmt);
    time(&t);
    tm = *localtime(&t);
    strftime(buf, sizeof(buf)-1, "[%b %d %H:%M:%S %Y] ", &tm);
    if (logfile) {
	fputs(buf, logfile);
	vfprintf(logfile, fmt, args);
	fprintf(logfile, ": %s\n", strerror(errno));
    }
    if (nofork) {
	fputs(buf, stderr);
	vfprintf(stderr, fmt, args);
	fprintf(stderr, ": %s\n", strerror(errno));
    }
}

/*************************************************************************/

void dump_html(const char *yday, const char *ymon)
{
   char buf[256], cmdbuf[1024];
   FILE *fhtml, *tmp;

   strcpy(buf, "./html/"); strcat(buf, hindex);
   tmp = fopen(buf, "r");

   if (!tmp) {
      fhtml = fopen(buf, "a");
      fprintf(fhtml, "<HTML>\n<HEAD><TITLE>Services Logs</TITLE></HEAD>\n");
      fprintf(fhtml, "<BODY bgcolor=#FFFFFF color=#000000>\n");
      fprintf(fhtml, "<FONT size=+2>Services Log Dates:</FONT><BR><P>\n");
   } else {
      fhtml = fopen(buf, "a");
      fclose(tmp);
   }

   *buf=0;
   strcat(buf, ymon);
   strcat(buf, "_");
   strcat(buf, yday);
   fprintf(fhtml, "<BR>\n<A HREF=\"%s\">%s</A><BR>",buf,buf);
   fclose(fhtml);




}

/*************************************************************************/

void check_logs(void)
{
   FILE *templog, *sourcelog;
   NickInfo *ni;
   char timebuf[64], cmdbuf[512];
   char *yday, yday2[64], ymon2[64], year_s[64], sent_time[64];
   time_t uptime = time(NULL) - start_time, tbuff = time(NULL);
   struct tm tm;
   int i, i2, x;

   tm = *localtime(&tbuff);
   strftime(timebuf, sizeof(timebuf), "%b %d", &tm);
   strftime(yday2, sizeof(yday2), "%d", &tm);
   strftime(ymon2, sizeof(ymon2), "%b", &tm);
   strftime(year_s, sizeof(year_s), "%Y", &tm);
   strftime(sent_time, sizeof(sent_time), "%H:%M:%S %Z", &tm);
   timebuf[sizeof(timebuf)-1] = 0;

   if (log_day[0] == NULL)
      log_day[0] = sstrdup(timebuf);

   if (stricmp(log_day[0], timebuf) == 0)
      return;

   yday = sstrdup(log_day[0]);
   free(log_day[0]);
   log_day[0] = sstrdup(timebuf);

   templog = fopen("./logs/temp.log", "a");
   if (templog)
      setbuf(templog, NULL);
   else {
      free(yday);
      return;
   }
   fprintf(templog, "* Services logs for %s %s ( Sorted At: %s )\n\n",
        yday, year_s, sent_time);
   free(yday);

   fprintf(templog, "[OperServ Commands]:\n");
   if (sourcelog = fopen("./logs/os.log", "r")) {
       fseek(sourcelog, 0L, SEEK_END); i = ftell(sourcelog); rewind(sourcelog);
       for (x=0; x < i; x++)
          fputc(fgetc(sourcelog), templog);
      fclose(sourcelog);
      fputc('\n', templog); fputc('\n', templog);
   }

   fprintf(templog, "[AbuseServ Commands]:\n");
   if (sourcelog = fopen("./logs/as.log", "r")) {
      fseek(sourcelog, 0L, SEEK_END); i = ftell(sourcelog); rewind(sourcelog);
      for (x=0; x < i; x++)
         fputc(fgetc(sourcelog), templog);
      fclose(sourcelog);
      fputc('\n', templog); fputc('\n', templog);
   }

   fprintf(templog, "[RootServ Commands]:\n");
   if (sourcelog = fopen("./logs/rs.log", "r")) {
      fseek(sourcelog, 0L, SEEK_END); i = ftell(sourcelog); rewind(sourcelog);
      for (x=0; x < i; x++)
          fputc(fgetc(sourcelog), templog);
      fclose(sourcelog);
      fputc('\n', templog); fputc('\n', templog);
   }

   fprintf(templog, "[NickServ Identifies/Fails]:\n");
   if (sourcelog = fopen("./logs/ns_id.log", "r")) {
      fseek(sourcelog, 0L, SEEK_END); i = ftell(sourcelog); rewind(sourcelog);
      for (x=0; x < i; x++)
         fputc(fgetc(sourcelog), templog);
      fclose(sourcelog);
      fputc('\n', templog); fputc('\n', templog);
   }

   fprintf(templog, "[NickServ Registry]:\n");
   if (sourcelog = fopen("./logs/ns_reg.log", "r")) {
      fseek(sourcelog, 0L, SEEK_END); i = ftell(sourcelog); rewind(sourcelog);
      for (x=0; x < i; x++)
         fputc(fgetc(sourcelog), templog);
      fclose(sourcelog);
      fputc('\n', templog); fputc('\n', templog);
   }

   fprintf(templog, "[NickServ Ownership Commands]:\n");
   if (sourcelog = fopen("./logs/ns_own.log", "r")) {
      fseek(sourcelog, 0L, SEEK_END); i = ftell(sourcelog); rewind(sourcelog);
      for (x=0; x < i; x++)
         fputc(fgetc(sourcelog), templog);
      fclose(sourcelog);
      fputc('\n', templog); fputc('\n', templog);
   }

   fprintf(templog, "[NickServ Expiry]:\n");
   if (sourcelog = fopen("./logs/ns_exp.log", "r")) {
      fseek(sourcelog, 0L, SEEK_END); i = ftell(sourcelog); rewind(sourcelog);
      for (x=0; x < i; x++)
          fputc(fgetc(sourcelog), templog);
      fclose(sourcelog);
      fputc('\n', templog); fputc('\n', templog);
   }

   fprintf(templog, "[NickServ Getpass Commands]:\n");
   if (sourcelog = fopen("./logs/ns_gpd.log", "r")) {
      fseek(sourcelog, 0L, SEEK_END); i = ftell(sourcelog); rewind(sourcelog);
      for (x=0; x < i; x++)
         fputc(fgetc(sourcelog), templog);
      fclose(sourcelog);
      fputc('\n', templog); fputc('\n', templog);
   }

   fprintf(templog, "[NickServ Flag Settings]:\n");
   if (sourcelog = fopen("./logs/ns_flags.log", "r")) {
      fseek(sourcelog, 0L, SEEK_END); i = ftell(sourcelog); rewind(sourcelog);
      for (x=0; x < i; x++)
          fputc(fgetc(sourcelog), templog);
      fclose(sourcelog);
      fputc('\n', templog); fputc('\n', templog);
   }

   fprintf(templog, "[ChanServ Identifies/Fails]:\n");
   if (sourcelog = fopen("./logs/cs_id.log", "r")) {
      fseek(sourcelog, 0L, SEEK_END); i = ftell(sourcelog); rewind(sourcelog);
      for (x=0; x < i; x++)
         fputc(fgetc(sourcelog), templog);
      fclose(sourcelog);
      fputc('\n', templog); fputc('\n', templog);
   }

   fprintf(templog, "[ChanServ Registry]:\n");
   if (sourcelog = fopen("./logs/cs_reg.log", "r")) {
      fseek(sourcelog, 0L, SEEK_END); i = ftell(sourcelog); rewind(sourcelog);
      for (x=0; x < i; x++)
         fputc(fgetc(sourcelog), templog);
      fclose(sourcelog);
      fputc('\n', templog); fputc('\n', templog);
   }

   fprintf(templog, "[ChanServ Ownership Commands]:\n");
   if (sourcelog = fopen("./logs/cs_own.log", "r")) {
      fseek(sourcelog, 0L, SEEK_END); i = ftell(sourcelog); rewind(sourcelog);
      for (x=0; x < i; x++)
         fputc(fgetc(sourcelog), templog);
      fclose(sourcelog);
      fputc('\n', templog); fputc('\n', templog);
   }

   fprintf(templog, "[ChanServ Expiry]:\n");
   if (sourcelog = fopen("./logs/cs_exp.log", "r")) {
      fseek(sourcelog, 0L, SEEK_END); i = ftell(sourcelog); rewind(sourcelog);
      for (x=0; x < i; x++)
         fputc(fgetc(sourcelog), templog);
      fclose(sourcelog);
      fputc('\n', templog); fputc('\n', templog);
   }

   fprintf(templog, "[ChanServ Getpass Commands]:\n");
   if (sourcelog = fopen("./logs/cs_gpd.log", "r")) {
      fseek(sourcelog, 0L, SEEK_END); i = ftell(sourcelog); rewind(sourcelog);
      for (x=0; x < i; x++)
         fputc(fgetc(sourcelog), templog);
      fclose(sourcelog);
      fputc('\n', templog); fputc('\n', templog);
   }

   fprintf(templog, "[ChanServ Flag Settings]:\n");
   if (sourcelog = fopen("./logs/cs_flags.log", "r")) {
      fseek(sourcelog, 0L, SEEK_END); i = ftell(sourcelog); rewind(sourcelog);
      for (x=0; x < i; x++)
         fputc(fgetc(sourcelog), templog);
      fclose(sourcelog);
      fputc('\n', templog); fputc('\n', templog);
   }

   fprintf(templog, "[MemoServ Oper Commands]:\n");
   if (sourcelog = fopen("./logs/ms_oper.log", "r")) {
      fseek(sourcelog, 0L, SEEK_END); i = ftell(sourcelog); rewind(sourcelog);
      for (x=0; x < i; x++)
         fputc(fgetc(sourcelog), templog);
      fclose(sourcelog);
      fputc('\n', templog); fputc('\n', templog);
   }

   fprintf(templog, "[MemoServ Expiry]:\n");
   if (sourcelog = fopen("./logs/ms_exp.log", "r")) {
      fseek(sourcelog, 0L, SEEK_END); i = ftell(sourcelog); rewind(sourcelog);
      for (x=0; x < i; x++)
         fputc(fgetc(sourcelog), templog);
      fclose(sourcelog);
      fputc('\n', templog); fputc('\n', templog);
   }

   fclose(templog);

   for (i = 0, i2 = 0; i < MAX_SENDLOGS; i++) {
      if (sendlogs[i]) {
         ni = findnick(sendlogs[i]);
         if (!ni) {
             wallops(SERVER_NAME, "Deleted Expired nick \"%s\" from SENDLOGS list",
                   sendlogs[i]);
             free(sendlogs[i]);
             sendlogs[i] = NULL;
          i2--;  /* Will cancel out upcomming increment */
         }
          i2++;
      }
   }

   if (ENABLE_LOGS != 1) {
       kill_logs(yday2, ymon2);
       if (uptime > 60)
            wallops(SERVER_NAME, "Sorted services logs (%d) [Not sent via email - Disabled]", i2);
       return;
   }
   
#ifndef SKELETON 
  for (i = 0; i < MAX_SENDLOGS; i++) {
       if (sendlogs[i]) {
          if ((ni = findnick(sendlogs[i])) && ni->email) {
              sprintf(cmdbuf, "mail -s \"Services Logs\" %s < ./logs/temp.log",
                 ni->email);
              system(cmdbuf);
              *cmdbuf = 0;
          }
       }
   }
#endif


   kill_logs(yday2, ymon2);
#ifndef SKELETON
   if (uptime > 60)
     wallops(SERVER_NAME, "Sorted and E-Mailed services logs (%d)", i2);
#endif

}


static void kill_logs(const char *yday, const char *ymon)
{
   char cmdbuf[1024];
   char buf[128];

   *buf = 0;
   *cmdbuf = 0;

   strcat(buf, ymon);
   strcat(buf, "_");
   strcat(buf, yday);


   if (dumphtml) {
      dump_html(yday, ymon);
      sprintf(cmdbuf, "cp ./logs/temp.log ./html/%s", buf);
      system(cmdbuf);
      *cmdbuf = 0;
   }
   if (dumplog) {
       sprintf(cmdbuf, "mv ./logs/temp.log ./logs/%s", buf);
       system(cmdbuf);
       *cmdbuf = 0;
   } else
       system("rm ./logs/temp.log");

   close_slog();
      sprintf(cmdbuf, "rm %s", slog_filename);
      system(cmdbuf);
   open_slog();

                 
   system("rm ./logs/os.log");
   system("rm ./logs/as.log");
   system("rm ./logs/rs.log");
   system("rm ./logs/ns_id.log");
   system("rm ./logs/ns_reg.log");
   system("rm ./logs/ns_own.log");
   system("rm ./logs/ns_exp.log");
   system("rm ./logs/ns_gpd.log");
   system("rm ./logs/ns_flags.log");
   system("rm ./logs/cs_id.log");
   system("rm ./logs/cs_reg.log");
   system("rm ./logs/cs_own.log");
   system("rm ./logs/cs_exp.log");
   system("rm ./logs/cs_gpd.log");
   system("rm ./logs/cs_flags.log");
   system("rm ./logs/ms_oper.log");
   system("rm ./logs/ms_exp.log");

   create_dummy_logs();

}

/*************************************************************************/
/*************************************************************************/
//                      BREAK LOG JUNK
/*************************************************************************/
/*************************************************************************/


void do_break_log(const char *service, const char *fmt,...)
{
    FILE *templog;
    va_list args;
    time_t t;
    struct tm tm;
    char buf[256];

    va_start(args, fmt);
    time(&t);
    tm = *localtime(&t);
    strftime(buf, sizeof(buf)-1, "[%b %d %H:%M:%S %Y] ", &tm);

   if (stricmp(service, "OS") == 0) {
        templog = fopen("./logs/os.log", "a");
        fputs(buf, templog);
        vfprintf(templog, fmt, args);
        fputc('\n', templog);
        fclose(templog);

   } else if (stricmp(service, "AS") == 0) {
        templog = fopen("./logs/as.log", "a");
        fputs(buf, templog);
        vfprintf(templog, fmt, args);
        fputc('\n', templog);
        fclose(templog);

   } else if (stricmp(service, "RS") == 0) {
        templog = fopen("./logs/rs.log", "a");
        fputs(buf, templog);
        vfprintf(templog, fmt, args);
        fputc('\n', templog);
        fclose(templog);

   } else if (stricmp(service, "NS_I") == 0) {
            templog = fopen("./logs/ns_id.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);

   } else if (stricmp(service, "NS_R") == 0) {
            templog = fopen("./logs/ns_reg.log", "a");
            if (templog) {
                fputs(buf, templog);
                vfprintf(templog, fmt, args);
                fputc('\n', templog);
                fclose(templog);
            }

   } else if (stricmp(service, "NS_O") == 0) {
            templog = fopen("./logs/ns_own.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);

   } else if (stricmp(service, "NS_X") == 0) {
            templog = fopen("./logs/ns_exp.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);

   } else if (stricmp(service, "NS_G") == 0) {
            templog = fopen("./logs/ns_gpd.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);

   } else if (stricmp(service, "NS_F") == 0) {
            templog = fopen("./logs/ns_flags.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);


   } else if (stricmp(service, "CS_I") == 0) {
            templog = fopen("./logs/cs_id.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);

   } else if (stricmp(service, "CS_R") == 0) {
            templog = fopen("./logs/cs_reg.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);

   } else if (stricmp(service, "CS_X") == 0) {
            templog = fopen("./logs/cs_exp.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);

   } else if (stricmp(service, "CS_G") == 0) {
            templog = fopen("./logs/cs_gpd.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);

   } else if (stricmp(service, "CS_F") == 0) {
            templog = fopen("./logs/cs_flags.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);

   } else if (stricmp(service, "CS_O") == 0) {
            templog = fopen("./logs/cs_own.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);

   } else if (stricmp(service, "MS_L") == 0) {
            templog = fopen("./logs/ms_oper.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);

   } else if (stricmp(service, "MS_X") == 0) {
            templog = fopen("./logs/ms_exp.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);

   }
}

