/* NickServ special help texts.
 *
 * SirvNET Services is copyright (c) 1998-2002 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * Originally based on EsperNet Services(c) by Andy Church.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

/*************************************************************************/

static const char *oper_delete_help[] = {
"Syntax: \2DELETE \37nickname\37\2",
"",
"Without a parameter, drops your nickname from the",
"NickServ database.",
NULL
};

/*************************************************************************/

static const char *flist_help[] = {
"Syntax: \2FLIST [\37HELD\37|\37MARKED\37|\37FORBIDDEN\37]\2",
"",
"Lists all registered nicknames that have the specified",
"flag settings.",
NULL
};

/*************************************************************************/

static const char *oper_list_help[] = {
"Syntax: \2LIST \37pattern\37\2",
"",
"Lists all registered nicknames which match the given",
"pattern, in \37nick!user@host\37 format.  Nicks with the",
"PRIVATE option set will only be displayed to Services",
"admins.",
"",
"Examples:",
"",
"    \2LIST *!joeuser@foo.com\2",
"        Lists all nicks owned by joeuser@foo.com.",
"",
"    \2LIST *Bot*!*\2",
"        Lists all registered nicks with Bot in their",
"        names (case insensitive).",
"",
"    \2LIST *!*@*.bar.org\2",
"        Lists all nicks owned by users in the bar.org",
"        domain.",
NULL
};

/*************************************************************************/

static const char *flush_help[] = {
"Syntax: \2FLUSH \37nickname\37\2",
"",
"This command removes the Registration E-Mail information",
"from a nick. Use of this command is for a user to",
"be able re-authorize the nick's email for verification.",
"This is usually because of an e-mail address change.",
"USE THIS COMMAND WITH EXTREME CAUTION!",
"Unless you know for absolute sure that the user's",
"email address has changed, don't issue this command.",
"By using the FLUSH command you defeat the purpose of",
"the extra security of a nick in regards to SENDPASS.",
NULL
};


/*************************************************************************/

static const char *getpass_help[] = {
"Syntax: \2GETPASS \37nickname\37\2",
"",
"Returns the password for the given nickname.  \2Note\2 that",
"whenever this command is used, a message including the",
"person who issued the command and the nickname it was used",
"on will be logged and sent out as a GLOBOPS.",
NULL
};

/*************************************************************************/

static const char *forbid_help[] = {
"Syntax: \2FORBID \37nickname\37\2",
"Syntax: \2FORBID -\37nickname\37\2",
"",
"Disallows a nickname from being registered or used by",
"anyone.  May be cancelled by deleting the nick.",
"Adding a '-' infront of the nick will remove it as forbidden",
NULL
};

/*************************************************************************/

static const char *mark_help[] = {
"Syntax: \2MARK \37nickname\37\2",
"Syntax: \2MARK -\37nickname\37\2",
"",
"Disallows a nickname from being getpassed.",
"MARK is generally used if a services admin has denied",
"a user from receiving a password, and is used to inform",
"the rest of the network not to getpass the nick.",
"Adding a '-' infront of the nick will remove it as marked",
NULL
};

/*************************************************************************/


static const char *hold_help[] = {
"Syntax: \2HOLD \37nickname\37\2",
"Syntax: \2HOLD -\37nickname\37\2",
"",
"Prevents a nickname from being expired.",
"Adding a '-' infront of the nick will remove it as held",
NULL
};


/*************************************************************************/
