/* Main processing code for Services.
 *
 * SirvNET Services is copyright (c) 1998-2002 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * Originally based on EsperNet Services(c) by Andy Church.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#include "../inc/services.h"
#include "../inc/version.h"

/*************************************************************************/

/* Response to the VERSION message. */

void m_version(char *source, int ac, char **av)
{
    User *u = finduser(source);

    if (source)
	send_cmd(server_name, "351 %s %s %s :-- %s",
			source, version_number, server_name, version_build);
    if (u)
       do_update_flood(u, 1);

}

/*************************************************************************/
/*************************************************************************/

/* Channel to suspend (hashed by first character of chan). */
C_SuspendData *c_suspend[256];

/*************************************************************************/

/* Updates flood levels of a user. If exceeds max, warn, if continues,
   kill user */

int do_update_flood(User *u, unsigned short idflood)
{
   time_t now = time(NULL);

   if (u->flood_time < now) {
       u->flood_time = now + F_RESET;
       u->floodlev = 0;

   } else if (u->flood_time > now) {
       u->flood_time = now + F_RESET;
       u->floodlev += 1;
  }

   if (idflood == 2)
         u->motd += 1;
   else if (idflood == 1)
         u->version += 1;

   if ((u->motd == 30) || (u->version == 30)
        || (u->motd == 50) || (u->version == 50)) {
       wallops(SERVER_NAME, "WARNING: User %s!%s@%s has been found "
         "sending atleast %d %s requests to services",
         u->nick, u->username, u->host,
         u->motd == 30 ? u->motd : u->version,
         u->motd == 30 ? "MOTD" : "VERSION");
       notice(s_GlobalNoticer, u->nick,
            "You have been constantly sending %s "
            "requests to services. Please stop immediately.",
            u->motd == 30 ? "MOTD" : "VERSION");
       if (idflood == 2)         //
             u->motd += 1;       //      to prevent repeated notices
       else if (idflood == 1)    //
            u->version += 1;     //
   }

 
   if ((u->floodlev == 5) && (u->floodlev2 == 3)) {
      u->floodlev2 = 4;
      if (is_oper(u->nick))
         wallops(SERVER_NAME, "Oper %s has been SEVERELY flooding services", u->nick);
      if (!is_oper(u->nick)) {
         kill_user(s_OperServ, u->nick, "Stop flooding services");
         return 1;
      }

   } else if ((u->floodlev == F_TLEV) && (u->floodlev2 == 2)) {
      u->floodlev2 = 3;
      u->floodlev = 1;
      notice(s_OperServ, u->nick, "You have been warned twice. STOP FLOODING SERVICES");
      if (!is_oper(u->nick))
        wallops(SERVER_NAME, "Services are being \2SEVERELY\2 flooded by %s!%s@%s",
           u->nick, u->username, u->host);

   } else if ((u->floodlev == F_TLEV) && (u->floodlev2 == 1)) {
      u->floodlev2 = 2;
      u->floodlev = 1;
      notice(s_OperServ, u->nick, "You are flooding services, please slow down");
      if (!is_oper(u->nick))
        wallops(SERVER_NAME, "Services are being flooded by %s!%s@%s",
           u->nick, u->username, u->host);

   } else if ((u->floodlev == 8) && (u->floodlev2 == 0)) {
      u->floodlev2 = 1;
   }
   return 0;
}

/*************************************************************************/

/* add_c_suspend: Add a channel to the suspend list for the next `delta'
 *             seconds.
 */

void add_c_suspend(const char *wchan, time_t delta)
{
    C_SuspendData *c_spn;
    C_SuspendData **whichlist = &c_suspend[tolower(wchan[0])];
    char chan[CHANMAX];
    time_t now = time(NULL);

    strscpy(chan, wchan, CHANMAX);
    for (c_spn = *whichlist; c_spn; c_spn = c_spn->next) {
        if (stricmp(c_spn->chan, chan) == 0)
	    break;
    }
    if (c_spn) {
        if (c_spn->time > now)
            c_spn->time += delta;
	else
            c_spn->time = now + delta;
    } else {
        c_spn = smalloc(sizeof(*c_spn));
        strcpy(c_spn->chan, chan);
        c_spn->time = now + delta;
        c_spn->next = *whichlist;
        *whichlist = c_spn;
    }
}

/*************************************************************************/

/* get_c_suspend: Retrieve a suspend record for a chan.  If the chan isn't
 *             being suspended, return NULL and flush the record from the
 *             in-core list if it exists (i.e. suspend timed out).
 */

C_SuspendData *get_c_suspend(const char *chan)
{
    C_SuspendData *c_spn, *prev;
    time_t now = time(NULL);
    C_SuspendData **whichlist = &c_suspend[tolower(chan[0])];

    for (c_spn = *whichlist, prev = NULL; c_spn; prev = c_spn, c_spn = c_spn->next) {
        if (stricmp(c_spn->chan, chan) == 0)
	    break;
    }
    if (c_spn && c_spn->time <= now) {
	if (prev)
            prev->next = c_spn->next;
	else
            *whichlist = c_spn->next;
        free(c_spn);
        c_spn = NULL;
    }
    return c_spn;
}


/*************************************************************************/
/*************************************************************************/

/* split_buf:  Split a buffer into arguments and store the arguments in an
 *             argument vector pointed to by argv (which will be malloc'd
 *             as necessary); return the argument count.  If colon_special
 *             is non-zero, then treat a parameter with a leading ':' as
 *             the last parameter of the line, per the IRC RFC.  Destroys
 *             the buffer by side effect.
 */

int split_buf(char *buf, char ***argv, int colon_special)
{
    int argvsize = 8;
    int argc;
    char *s, *t;

    *argv = smalloc(sizeof(char *) * argvsize);
    argc = 0;
    while (*buf) {
	if (argc == argvsize) {
	    argvsize += 8;
	    *argv = srealloc(*argv, sizeof(char *) * argvsize);
	}
	if (*buf == ':') {
	    (*argv)[argc++] = buf+1;
	    buf = "";
	} else {
	    s = strpbrk(buf, " ");
	    if (s) {
		*s++ = 0;
		while (isspace(*s))
		    s++;
	    } else {
		s = buf + strlen(buf);
	    }
	    (*argv)[argc++] = buf;
	    buf = s;
	}
    }
    return argc;
}

/*************************************************************************/

/* process:  Main processing routine.  Takes the string in inbuf (global
 *           variable) and does something appropriate with it. */

void process()
{
    char source[64];
    char cmd[64];
    char buf[512];		/* Longest legal IRC command line */
    char *s;
    int ac;			/* Parameters for the command */
    char **av;
    Message *m;


    /* If debugging, log the buffer. */
    if (debug)
	log("debug: Received: %s", inbuf);


    /* First make a copy of the buffer so we have the original in case we
     * crash - in that case, we want to know what we crashed on. */
    strscpy(buf, inbuf, sizeof(buf));

    /* Split the buffer into pieces. */
    if (*buf == ':') {
	s = strpbrk(buf, " ");
	if (!s)
	    return;
	*s = 0;
	while (isspace(*++s))
	    ;
	strscpy(source, buf+1, sizeof(source));
	strcpy(buf, s);
    } else {
	*source = 0;
    }
    if (!*buf)
	return;
    s = strpbrk(buf, " ");
    if (s) {
	*s = 0;
	while (isspace(*++s))
	    ;
    } else
	s = buf + strlen(buf);
    strscpy(cmd, buf, sizeof(cmd));
    ac = split_buf(s, &av, 1);

    /* Do something with the message. */
    if (m = find_message(cmd)) {
	if (m->func)
	    m->func(source, ac, av);
    } else {
	log("unknown message from server (%s)", inbuf);
    }

    /* Free argument list we created */
    free(av);
}

/*************************************************************************/
