/*
 * SirvNET Services is copyright (c) 1998-2002 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#include "../inc/services.h"
#include "rs-help.c"
#ifdef BAHAMUT
   #define NICK(nick,user,host,name) do { send_cmd(NULL, "NICK %s 1 %lu %s %s %s %s 0 :%s", (nick), time(NULL), "+", (user), (host), server_name, (name)); } while (0)
#else
   #define NICK(nick,user,host,name) do { send_cmd(NULL, "NICK %s 1 %lu %s %s %s 0 :%s", (nick), time(NULL), (user), (host), server_name, (name)); } while (0)
#endif

unsigned long lsearch=0;

static char *sgnick;

static void do_sa(const char *source);
static void do_reference(const char *source);
static void do_reference_ns(const char *source);
static void do_reference_cs(const char *source);
static void do_reference_ms(const char *source);
static void do_sra(const char *source);
static void do_set(const char *source);
static void do_chansnoop(const char *source);
static void do_inject(const char *source);
static void do_flood_reset(const char *source);
static void do_ohelp(const char *source);
static void do_rehash(const char *source);
static void do_logsearch(const char *source);
static int search_log(const char *source, const char *logfile, const char *search);

/*************************************************************************/
/*************************************************************************/

/* Main RootServ routine. */

void rootserv(const char *source, char *buf)
{
    NickInfo *ni;
    char *cmd;
    char *s, *chan, *nick, *host;
    int i;
    User *u = finduser(source);

#ifdef SKELETON
    ni = findnick(source);
#endif

    log("RS (%s!%s@%s) [%s]",
                source,u->username,u->host,buf);
    do_break_log("RS", "RS (%s!%s@%s) [%s]",
                source,u->username,u->host,buf);


    cmd = strtok(buf, " ");

    if (!cmd) {
        notice(s_RootServ, source, "Type \"/msg RootServ OHELP\" for a listing RootServ commands.");
        return;

#ifdef SKELETON
    } else if (!ni || (!(ni->flags & NI_IDENTIFIED))) {
        notice(s_RootServ, source,
                "Permission denied", cmd, s_RootServ);
#endif

    } else if (!is_services_root(source)) {
        notice(s_RootServ, source,
                "Permission denied", cmd, s_RootServ);

    } else if (stricmp(cmd, "OHELP") == 0) {
        do_ohelp(source);

    } else if (stricmp(cmd, "REHASH") == 0) {
        do_rehash(source);

    } else if (stricmp(cmd, "SET") == 0) {
	do_set(source);

    } else if (stricmp(cmd, "SRAW") == 0) {
	const char *text = strtok(NULL, "");
	if (!text)
            notice(s_RootServ, source, "Syntax: \2SRAW\2 <parameters>");
	else
	    send_cmd(NULL, text);

    } else if (stricmp(cmd, "INJECT") == 0) {
        do_inject(source);

    } else if (stricmp(cmd, "SEARCH") == 0) {
        do_logsearch(source);

    } else if (stricmp(cmd, "SA") == 0) {
        do_sa(source);

    } else if (stricmp(cmd, "SRA") == 0) {
        do_sra(source);

    } else if (stricmp(cmd, "TEST") == 0) {
        check_logs();

    } else if (stricmp(cmd, "FLOODRESET") == 0) {
        do_flood_reset(source);

    } else if (stricmp(cmd, "REFERENCE") == 0) {
        do_reference(source);

    } else if (stricmp(cmd, "CHANSNOOP") == 0) {
        do_chansnoop(source);

    } else if (stricmp(cmd, "QUIT") == 0) {
	quitmsg = malloc(28 + strlen(source));
	if (!quitmsg)
	    quitmsg = "QUIT command received, but out of memory!";
	else
	    sprintf(quitmsg, "QUIT command received from %s", source);
        do_break_log("OS", "!! Terminating Services (No Save)");
        log("!! Terminating Services (No Save)");
        send_cmd(SERVER_NAME, "SQUIT %s :%s", server_name, quitmsg);
        exit(1);

    } else if (stricmp(cmd, "SHUTDOWN") == 0) {
	quitmsg = malloc(32 + strlen(source));
	if (!quitmsg)
	    quitmsg = "SHUTDOWN command received, but out of memory!";
	else
	    sprintf(quitmsg, "SHUTDOWN command received from %s", source);
        log("!! Terminating Services (Saving Databases)");
        do_break_log("OS", "!! Terminating Services (Saving Databases)");
	save_data = 1;
	delayed_quit = 1;

    } else if (stricmp(cmd, "RESTART") == 0) {
#ifdef SERVICES_BIN
	quitmsg = malloc(31 + strlen(source));
	if (!quitmsg)
	    quitmsg = "RESTART command received, but out of memory!";
	else
            log("!! Restarting Services");
            do_break_log("OS", "!! Restarting Services");
	    sprintf(quitmsg, "RESTART command received from %s", source);
            raise(SIGHUP);
#else
        notice(s_RootServ, source,
		"SERVICES_BIN not defined; cannot restart.  Rerun the "
		"\2configure\2 script and recompile Services to enable "
		"the RESTART command.");
#endif

    } else if (!is_services_coder(source)) {
        notice(s_RootServ, source,
                "Permission denied", cmd, s_RootServ);


    } else if (stricmp(cmd, "CLONELIST") == 0) {
        operserv(source, buf);

    } else {
         notice(s_RootServ, source,
		"Unrecognized command \2%s\2.  Type \"/msg %s OHELP\" for help.",
                cmd, s_RootServ);

    }
}

/*************************************************************************/

static void do_ohelp(const char *source)
{
    const char *cmd = strtok(NULL, " ");
    char *access;

    if (!cmd)
       serv_os_help(source, "RS", s_RootServ);
    else if (stricmp(cmd, "CHANSNOOP") == 0)
        notice_list(s_RootServ, source, chansnoop_help);
    else if (stricmp(cmd, "SET") == 0) {
	cmd = strtok(NULL, " ");
	if (!cmd)
            notice_list(s_RootServ, source, set_help);
	else if (!stricmp(cmd, "READONLY"))
            notice_list(s_RootServ, source, set_readonly_help);
	else
            notice(s_RootServ, source, "Unknown SET option \2%s\2.", cmd);
    } else if (stricmp(cmd, "QUIT") == 0)
        notice_list(s_RootServ, source, quit_help);
    else if (stricmp(cmd, "UPDATE") == 0)
        notice_list(s_RootServ, source, update_help);
    else if (stricmp(cmd, "REFERENCE") == 0)
        notice_list(s_RootServ, source, reference_help);
    else if (stricmp(cmd, "SHUTDOWN") == 0)
        notice_list(s_RootServ, source, shutdown_help);
    else if (stricmp(cmd, "RESTART") == 0)
        notice_list(s_RootServ, source, restart_help);
    else if (stricmp(cmd, "SA") == 0)
	notice_list(s_OperServ, source, admin_help);
    else if (stricmp(cmd, "SRAW") == 0)
        notice_list(s_RootServ, source, sraw_help);
    else if (stricmp(cmd, "INJECT") == 0)
        notice_list(s_RootServ, source, inject_help);
    else if (stricmp(cmd, "SEARCH") == 0)
        notice_list(s_RootServ, source, search_help);
    else {
        notice(s_RootServ, source,
			"No help topic for \2%s\2 found", cmd);
        return;
    }
    if (cmd) {
       if (access = find_level(cmd))
          notice(s_RootServ, source,
            "This command is limited to \2%s\2.", access);
    }


    notice(s_RootServ, source,
       "\2END OF OHELP\2");

}

/*************************************************************************/

static void do_reference(const char *source)
{
   const char *service = strtok(NULL, " ");
   User *u = finduser(source);


   if (!u)
      return;

   if (!service) {
      notice(s_RootServ, source,
         "Syntax: \2REFERENCE\2 [NS|CS|MS]");
      return;
   }

   if (stricmp(service, "NS") == 0)
      do_reference_ns(source);

   if (stricmp(service, "CS") == 0)
      do_reference_cs(source);

   if (stricmp(service, "MS") == 0)
      do_reference_ms(source);

   notice(s_RootServ, source, "END OF %s REFERENCES", service);

}

static void do_reference_ns(const char *source)
{

  notice(s_RootServ, source, "Help/Command Index for NS \2%s\2:", snoopchan);
  notice(s_RootServ, source, "NS R = Registered Nick");
  notice(s_RootServ, source, "NS [*]I = [Failed] Nick Identify");
  notice(s_RootServ, source, "NS [-+]M = [un]Marked Nick");
  notice(s_RootServ, source, "NS [-+]H = [un]Held Nick");
  notice(s_RootServ, source, "NS [*-+]F = [Failed] (un)Forbid Nick");
  notice(s_RootServ, source, "NS *C = Invalid Command");
  notice(s_RootServ, source, "NS *H = Invalid Help Index");
  notice(s_RootServ, source, "NS X = Nick Expired");
  notice(s_RootServ, source, "NS +D = Deleted Nick");
  notice(s_RootServ, source, "NS [*]D = [Failed] Nick Drop");
  notice(s_RootServ, source, "NS E = Set Email");
  notice(s_RootServ, source, "NS *R = Failed Recovery");
  notice(s_RootServ, source, "NS *Re = Failed Released");
  notice(s_RootServ, source, "NS *K = Failed Ghost Kill");
  notice(s_RootServ, source, "NS [*]G = [Failed] Getpass");

}

static void do_reference_cs(const char *source)
{

  notice(s_RootServ, source, "Help/Command Index for CS \2%s\2:", snoopchan);
  notice(s_RootServ, source, "CS R = Registered Chan");
  notice(s_RootServ, source, "CS [*]I = [Failed] Chan Identify");
  notice(s_RootServ, source, "CS [-+]M = [un]Marked Chan");
  notice(s_RootServ, source, "CS [-+]H = [un]Held Chan");
  notice(s_RootServ, source, "CS [-+]Z = [un]Freeze Chan");
  notice(s_RootServ, source, "CS [*-+]F = [Failed] (un)Forbid Chan");
  notice(s_RootServ, source, "CS *C = Invalid Command");
  notice(s_RootServ, source, "CS *H = Invalid Help Index");
  notice(s_RootServ, source, "CS X = Chan Expired");
  notice(s_RootServ, source, "CS +D = Deleted Chan");
  notice(s_RootServ, source, "CS [*]D = [Failed] Chan Drop");
  notice(s_RootServ, source, "CS *R = Failed Registry");
  notice(s_RootServ, source, "CS *P = Failed Password Change");
  notice(s_RootServ, source, "CS P = Password Change");
  notice(s_RootServ, source, "CS [-]W = Welcome Message");
  notice(s_RootServ, source, "CS +I = Invite");
  notice(s_RootServ, source, "CS C = Clear Channel");
  notice(s_RootServ, source, "CS [*]G = [Failed] Getpass");

}

static void do_reference_ms(const char *source)
{
  notice(s_RootServ, source, "Help/Command Index for MS \2%s\2:", snoopchan);
  notice(s_RootServ, source, "MS *C = Failed Command");
  notice(s_RootServ, source, "MS S+ = CSEND Command");
  notice(s_RootServ, source, "MS [-]F = Forwarding nick");
  notice(s_RootServ, source, "MS L = Set Memo Limit");
  notice(s_RootServ, source, "MS G = Global Memo");
  notice(s_RootServ, source, "MS X[+] = Memo Expire [Email Warning]");
  notice(s_RootServ, source, "MS I = Memo Information");

}

/*************************************************************************/

/* Services root list modification. */
static void do_sra(const char *source)
{
    char *cmd, *nick;
    NickInfo *ni;
    int i;

    cmd = strtok(NULL, " ");
    if (!cmd)
        cmd = "";

    if (stricmp(cmd, "ADD") == 0) {
        nick = strtok(NULL, " ");
        if (!is_services_coder(source)) {
           notice(s_RootServ, source, "Only the services master is permitted to add nicks to the SRA List");
           return;
        }
        if (nick) {
            if (!findnick(nick)) {
                notice(s_RootServ, source, "Nick %s isn't registered!", nick);
                return;
            }
            for (i = 0; services_roots[i]; i++) {
		if (services_roots[i] && !stricmp(nick,services_roots[i])) {
                    notice(s_RootServ, source, "%s is already a SRA",
			nick);
		    return;
		}

		if (!services_roots[i])
		    break;
	    }
            if ((i < MAX_SERVROOTS) || (MAX_SERVROOTS == 0)) {
                services_roots[i] = sstrdup(nick);
                log("!! Added \2%s\2 to SRA List",nick);
                do_break_log("RS", "!! Added %s to SRA List",nick);
                wallops(SERVER_NAME, "%s added %s to the SRA List", source, nick);
                notice(s_RootServ, source,
                        "%s added to Services root list.", nick);

                for (i = 0; i < MAX_HELPOPS; i++) {
                    if (services_helpers[i] && !stricmp(nick, services_helpers[i]))
                        services_helpers[i] = NULL;
                }

                for (i = 0; i < MAX_SERVOPERS; i++) {
                    if (services_opers[i] && !stricmp(nick, services_opers[i]))
                        services_opers[i] = NULL;
                }

                for (i = 0; i < MAX_SERVADMINS; i++) {
                    if (services_admins[i] && !stricmp(nick, services_admins[i]))
                        services_admins[i] = NULL;
                }


            } else {
                notice(s_RootServ, source,
                        "Too many entries (%d) on Services root list; cannot add more",
                        MAX_SERVROOTS);
                wallops(s_RootServ, "\2Warning\2: Services root list is full! (%d)", MAX_SERVROOTS);
            }
            if (readonly) {
                notice(s_RootServ, source,
                    "\2Notice:\2 Changes will not be saved!  Services is in readonly mode.");
            }
        } else {
            notice(s_RootServ, source, "Syntax: \2SRA ADD\2 <nick>");
        }

    } else if (stricmp(cmd, "DEL") == 0) {
        if (!is_services_coder(source)) {
           notice(s_RootServ, source, "Only the services master is permitted to delete nicks from the SRA List");
           return;
        }
        if (nick = strtok(NULL, " ")) {
            for (i = 0; i < MAX_SERVROOTS; i++) {
                if (services_roots[i] && stricmp(nick,services_roots[i]) == 0)
                    break;
            }
            if ((i < MAX_SERVROOTS) || (MAX_SERVROOTS == 0)) {
                free(services_roots[i]);
                services_roots[i] = NULL;
                log("!! Deleted %s from SRA list",nick);
                do_break_log("RS", "!! Deleted \2%s\2 from SRA List",nick);
                wallops(SERVER_NAME, "%s deleted %s from the SRA List",source,nick);
                notice(s_RootServ, source,
                        "%s removed from Services root list.", nick);
                if (readonly) {
                    notice(s_RootServ, source,
                            "\2Notice:\2 Changes will not be saved! Services is in readonly mode.");
                }
            } else {
                notice(s_RootServ, source,
                        "%s not found on Services root list.", nick);
            }
        } else {
            notice(s_RootServ, source, "Syntax: \2SRA DEL\2 <nick>");
        }

    } else if (stricmp(cmd, "LIST") == 0) {
           notice(s_RootServ, source, "\2Services Root Administrators:\2");
           notice(s_RootServ, source, "");
           for (i = 0; i < MAX_SERVROOTS; i++) {

        if (services_roots[i]) {
            if (stricmp(services_roots[i], SERVICES_MASTER) == 0) { 
                   if (ni = findnick(services_roots[i]))
                      notice(s_RootServ, source, "%s (%s) [Master]", services_roots[i], ni->last_usermask);
            }
            else {
#ifndef SKELETON
              if (ni = findnick(services_roots[i])) {
                 notice(s_RootServ, source, "%s (%s)", services_roots[i], ni->last_usermask);
              }
#else
              notice(s_RootServ, source, "%s (N/A in SKELETON version)", services_roots[i]);
#endif
            }
         }
     }
     notice(s_RootServ, source, "\2End of List\2");


    } else {
        notice(s_RootServ, source,
                "Syntax: \2SRA\2 [ADD|DEL|LIST] [<nick>]");
        notice(s_RootServ, source,
                "For help: \2/msg %s HELP SRA\2", s_RootServ);
    }
}


/*************************************************************************/

/* Rehash the conf file */

static void do_rehash(const char *source)
{
    NickInfo *ni;
    FILE *f;
    User *u;
    char newspath[128];

    *newspath = 0;
    strcat(newspath, HELPSERV_DIR); strcat(newspath, "/news");

    log("Rehashing conf files by request of: %s", source);
    wallops(SERVER_NAME, "Rehashing conf files by request of: %s", source);
    log("Rehashing %s", CONFIG_FILE);
    init_conf();
    log("Rehashing %s complete. Now rehasing %s", CONFIG_FILE, O_CONFIG_FILE);
    init_o_conf();
    log("Sucessfully rehashed conf files");
    log("Re-loading news information");
    f = fopen(newspath, "rb");
    if (f != NULL) {
       fseek(f, 0L, SEEK_END);
       news_size = ftell(f);
       fclose(f);
    }
    for (u = userlist; u && news_size > 0; u = u->next) {
       ni = findnick(u->nick);
       if (ni && (news_size != ni->news))
           notice(s_MemoServ, u->nick,
              "New %s news is available! "
              "type /msg %s NEWS", NETWORK_NAME, s_MemoServ);
    }

    log("Rehash process complete.");
}


/*************************************************************************/

/* Set various Services runtime options. */

static void do_set(const char *source)
{
    const char *option = strtok(NULL, " ");
    const char *setting = strtok(NULL, " ");


    if (!option || !setting) {
        notice(s_RootServ, source,
                        "Syntax: \2SET\2 <option> <value>");

    } else if (stricmp(option, "SNOOP") == 0) {
	if (stricmp(setting, "on") == 0) {
            if (snoop == 1) {
               notice(s_RootServ, source, "Snoop already enabled");
               return;
            }
            snoop = 1;
            notice(s_RootServ, source, "Snoop Enabled");
	} else if (stricmp(setting, "off") == 0) {
            if (snoop != 1) {
               notice(s_RootServ, source, "Snoop already disabled");
               return;
            }
            snoop = 0;
            notice(s_RootServ, source, "Snoop Disabled.");
	} else {
            notice(s_RootServ, source,
                    "Setting for \2SNOOP\2 must be \2ON\2 or \2OFF\2.");
	}


    } else if (stricmp(option, "IGNORE") == 0) {
	if (stricmp(setting, "on") == 0) {
            if (allow_ignore == 1) {
               notice(s_RootServ, source, "Ignore code already enabled");
               return;
            }
	    allow_ignore = 1;
            notice(s_RootServ, source, "Ignore code \2will\2 be used.");
            wallops(SERVER_NAME, "Services Mode: Ignore Code Enabled (%s)",
                  source);
	} else if (stricmp(setting, "off") == 0) {
            if (allow_ignore != 1) {
               notice(s_RootServ, source, "Ignore code already disabled");
               return;
            }
	    allow_ignore = 0;
            notice(s_RootServ, source, "Ignore code \2will not\2 be used.");
            wallops(SERVER_NAME, "Services Mode: Ignore Code Disabled (%s)",
                  source);
	} else {
            notice(s_RootServ, source,
		    "Setting for \2IGNORE\2 must be \2ON\2 or \2OFF\2.");
	}
    } else if (stricmp(option, "SDEBUG") == 0) {
        if (stricmp(setting, "on") == 0) {
            if (sndebug == 1) {
               notice(s_RootServ, source, "Snoop debug already enabled");
               return;
            }
           sndebug = 1;
           notice(s_RootServ, source, "Snoop Debug Activated");
           log("Snoop Debug Activated");
        }
        if (stricmp(setting, "off") == 0) {
            if (sndebug != 1) {
               notice(s_RootServ, source, "Snoop debug already disabled");
               return;
            }
           sndebug = 0;
           notice(s_RootServ, source, "Snoop Debug Deactivated");
           log("Snoop Debug De-Activated");
        }

    } else if (stricmp(option, "DEBUG") == 0) {
        if (stricmp(setting, "on") == 0) {
            if (debug == 1) {
               notice(s_RootServ, source, "Debug already enabled");
               return;
            }
           debug = 1;
           notice(s_RootServ, source, "Debug Activated");
           log("Debug Activated");
        }
        if (stricmp(setting, "off") == 0) {
            if (debug != 1) {
               notice(s_RootServ, source, "Debug already disabled");
               return;
            }
           debug = 0;
           notice(s_RootServ, source, "Debug Deactivated");
           log("Debug De-Activated");
        }

    } else if (stricmp(option, "SENDLOGS") == 0) {
	if (stricmp(setting, "on") == 0) {
            if (sendstat == 1) {
               notice(s_RootServ, source, "Sending logs already enabled");
               return;
            }
           clone_detect = 0;
           log("Sending Logs Enabled");
           notice(s_RootServ, source, "Services will now send logs");
           wallops(SERVER_NAME, "Services Mode: Send Logs [ON] (%s)",
                  source);
	} else if (stricmp(setting, "off") == 0) {
            if (sendstat != 1) {
               notice(s_RootServ, source, "Send Logs already disabled");
               return;
            }
            sendstat = 0;
            log("Send Logs Disabled");
            notice(s_RootServ, source, "Services will NOT send logs.");
            wallops(SERVER_NAME, "Services Mode: Send Logs [OFF] (%s)",
                  source);
	} else {
            notice(s_RootServ, source,
                    "Setting for \2SENDLOGS\2 must be \2ON\2 or \2OFF\2.");
	}

    } else if (stricmp(option, "DUMPLOG") == 0) {
	if (stricmp(setting, "on") == 0) {
            if (dumplog == 1) {
               notice(s_RootServ, source, "Dumping Log already Active");
               return;
            }
           dumplog = 0;
           log("DumpLog Enabled");
           notice(s_RootServ, source, "Services will now dump logs");
	} else if (stricmp(setting, "off") == 0) {
            if (dumplog != 1) {
               notice(s_RootServ, source, "Dump Logs already disabled");
               return;
            }
            dumplog = 0;
            log("Dump Logs Disabled");
            notice(s_RootServ, source, "Services will NOT dump logs.");
	} else {
            notice(s_RootServ, source,
                    "Setting for \2DUMPLOG\2 must be \2ON\2 or \2OFF\2.");
	}


    } else if (stricmp(option, "DUMPHTML") == 0) {
	if (stricmp(setting, "on") == 0) {
            if (dumphtml == 1) {
               notice(s_RootServ, source, "Dumping HTML already Active");
               return;
            }
           dumphtml = 0;
           log("DumpHTML Enabled");
           notice(s_RootServ, source, "Services will now dump HTML");
	} else if (stricmp(setting, "off") == 0) {
            if (dumphtml != 1) {
               notice(s_RootServ, source, "Dump HTML already disabled");
               return;
            }
            dumphtml = 0;
            log("Dump HTML Disabled");
            notice(s_RootServ, source, "Services will not dump HTML.");
	} else {
            notice(s_RootServ, source,
                    "Setting for \2DUMPHTML\2 must be \2ON\2 or \2OFF\2.");
	}


    } else if (stricmp(option, "CLONES") == 0) {
	if (stricmp(setting, "on") == 0) {
            if (clone_detect == 1) {
               notice(s_RootServ, source, "Clone detection already enabled");
               return;
            }
           clone_detect = 1;
           log("Clone Detection Enabled");
           notice(s_RootServ, source, "Services is now clone detecting");
           wallops(SERVER_NAME, "Services Mode: Clone Detection (%s)",
                  source);
	} else if (stricmp(setting, "off") == 0) {
            if (clone_detect != 1) {
               notice(s_RootServ, source, "Clone detection already disabled");
               return;
            }
            clone_detect = 0;
            log("Clone Detect Deactivated");
            notice(s_RootServ, source, "Services will NOT clone detect.");
            wallops(SERVER_NAME, "Services Mode: Clone Detection Disabled (%s)",
                  source);
	} else {
            notice(s_RootServ, source,
                    "Setting for \2CLONES\2 must be \2ON\2 or \2OFF\2.");
	}

    } else if (stricmp(option, "FLOOD") == 0) {
	if (stricmp(setting, "on") == 0) {
            if (allow_flood == 1) {
               notice(s_RootServ, source, "Flood levels already enabled");
               return;
            }
           allow_flood = 1;
           log("Flood Levels Enabled");
           notice(s_RootServ, source, "Services is now flood detecting");
           wallops(SERVER_NAME, "Services Mode: Flood Level Activated (%s)",
                  source);
	} else if (stricmp(setting, "off") == 0) {
            if (allow_flood != 1) {
               notice(s_RootServ, source, "Flood levels already disabled");
               return;
            }
            allow_flood = 0;
            log("Flood levels Deactivated");
            notice(s_RootServ, source, "Services will NOT use flood levels.");
            wallops(SERVER_NAME, "Services Mode: Flood Levels Disabled (%s)",
                  source);
	} else {
            notice(s_RootServ, source,
                    "Setting for \2FLOOD\2 must be \2ON\2 or \2OFF\2.");
	}

    } else if (stricmp(option, "REALNAME") == 0) {
	if (stricmp(setting, "on") == 0) {
            if (realname == 1) {
               notice(s_RootServ, source, "Real Name Catching already enabled");
               return;
            }
           realname = 1;
           log("Real Name Catching Enabled");
           notice(s_RootServ, source, "Services is now Real Name Catching");
           wallops(SERVER_NAME, "Services Mode: Real Name Catching (%s)",
                  source);
	} else if (stricmp(setting, "off") == 0) {
            if (realname != 1) {
               notice(s_RootServ, source, "Real Name Catching already disabled");
               return;
            }
            realname = 0;
            log("Real Name Catching Deactivated");
            notice(s_RootServ, source, "Real Name Catching disabled.");
            wallops(SERVER_NAME, "Services Mode: Real Name Catching Disabled (%s)",
                  source);
	} else {
            notice(s_RootServ, source,
                    "Setting for \2REALNAME\2 must be \2ON\2 or \2OFF\2.");
	}


    } else if (stricmp(option, "READONLY") == 0) {
	if (stricmp(setting, "on") == 0) {
            if (readonly == 1) {
               notice(s_RootServ, source, "Read only already enabled");
               return;
            }
	    readonly = 1;
	    log("Read-only mode activated");
	    close_log();
            notice(s_RootServ, source, "Services is now in read-only mode.");
            wallops(SERVER_NAME, "Services Mode: READ-ONLY (%s)",
                  source);
	} else if (stricmp(setting, "off") == 0) {
            if (readonly != 1) {
               notice(s_RootServ, source, "Read/Write already enabled");
               return;
            }
	    readonly = 0;
	    open_log();
	    log("Read-only mode deactivated");
            notice(s_RootServ, source, "Services is now in read/write mode.");
            wallops(SERVER_NAME, "Services Mode: READ/WRITE (%s)",
                  source);
	} else {
            notice(s_RootServ, source,
		    "Setting for \2READONLY\2 must be \2ON\2 or \2OFF\2.");
	}

 
   } else {
        notice(s_RootServ, source, "Unknown option \2%s\2.", option);
    }
}

/*************************************************************************/

static void do_chansnoop(const char *source)
{

    const char *cmd = strtok(NULL, " ");
    const char *chan = strtok(NULL, " ");
    const char *mask = strtok(NULL, " ");
    const char *realname = strtok(NULL, "");
    char *snick, *suser, *shost;

    if (snoop != 1) {
       notice(s_RootServ, source, "Snoop functions have been disabled");
       return;
    }

    if (!cmd || ((cmd && stricmp(cmd, "ON") == 0) && (!chan || !mask))) {
        notice(s_RootServ, source, "Syntax: \2CHANSNOOP\2 [ON|OFF] [<#channel>] [<nick!user@host>] [realname]");
        return;
    }

    if (stricmp(cmd,"ON") == 0) {
	if (snchan) {
            notice(s_RootServ, source, "Already ChanSnooping %s.", snchan);
	    return;
        } else if ((!strchr(mask, '!')) || (!strchr(mask, '@'))) {
             notice(s_RootServ, source,
                 "The mask must be in the format: nick!user@host.com");
             notice(s_RootServ, source,
                 "\2/MSG %s OHELP chansnoop\2 for more information",
                  s_RootServ);
             return;
        }

        snick = sstrdup(mask);
        suser = strchr(snick, '!');
        shost = strchr(suser, '@');
        *suser++ = 0; *shost++ = 0;

        if (!strchr(shost, '.')) {
            notice(s_RootServ, source, "Host should contain an . (com)");
            return;
        } else if ((stricmp(snick, "") == 0) || (stricmp(shost, "") == 0)) {
            notice(s_RootServ, source, "Invalid mask for chansnoop");
            notice(s_RootServ, source,
                 "\2/MSG %s OHELP chansnoop\2 for more information",
                  s_RootServ);
            return;
        } else if (strchr(snick, '.')) {
             notice(s_RootServ, source, "Invalid characters for nick");
             return;
        }

	snchan = sstrdup(chan);
        snnick = sstrdup(snick);
        if (sgnick)
          free(sgnick);
        sgnick = sstrdup(snnick);
        if (realname)
           NICK(snick, suser, shost, realname);
        else
           NICK(snick, suser, shost, "http://www.sirv.net");
   
        send_cmd(snick, "JOIN %s", chan);
        notice(s_RootServ, source, "ChanSnoop activated for Channel %s",
                          chan);
        log("%s is using \2CHANSNOOP\2 on channel \2%s\2 (%s)", 
           source, chan, mask);
        free(snnick); free(snick);


   } else if (stricmp(cmd, "OFF") == 0) {
	if (!snchan) {
            notice(s_RootServ, source, "ChanSnoop is already de-activated");
	    return;
        }
        notice(s_RootServ, source, "ChanSnoop for %s deactivated.",
	    snchan);
	send_cmd(sgnick, "PART %s", snchan);
        send_cmd(sgnick, "QUIT :quit");
        send_cmd(s_OperServ, "PRIVMSG %s :ChanSnoop deactivated for Channel"
            " %s", snoopchan, snchan);
	free(snchan); free(sgnick);
        snchan = NULL; sgnick = NULL;

  }
}

/*************************************************************************/

static void do_flood_reset(const char *source)
{
    const char *nick = strtok(NULL, " ");
    time_t now = time(NULL);
    User *u;
 


     if (!is_services_root(source)) {
         notice(s_RootServ, source,
             "Unrecognized command \2flood\2.  Type \"/msg %s OHELP\" for help.",
              s_RootServ);
          return;
     }

     if (!nick) {
        notice(s_RootServ, source, "Syntax: \2FLOODRESET\2 <nick>");
        return;

     } else if (!(u = finduser(nick))) {
        notice(s_RootServ, source, "User %s is not online", nick);
        return;
     }

     u->floodlev = 0;
     u->floodlev2 = 0;
     u->motd = 0; u->version = 0;
     notice(s_RootServ, source, "Flood levels for %s reset", u->nick);
     wallops(SERVER_NAME, "%s reset flood levels for nick \2%s\2",
            source, u->nick);

     return;

}

/*************************************************************************/


static void do_inject(const char *source)
{
    const char *nick = strtok(NULL, " ");
    const char *snick = strtok(NULL, " ");
    char *cmd = strtok(NULL, "");
    char buf[BUFSIZE];

#ifdef SKELETON

     notice(s_RootServ, source, "INJECT disabled in SKELETON mode");
#else

    if (!nick || !snick || !cmd)
	return;

    if (stricmp(snick, s_OperServ) == 0)
	operserv(nick,cmd);
    if (stricmp(snick, s_RootServ) == 0)
        rootserv(nick,cmd);
    if (stricmp(snick, s_NickServ) == 0)
	nickserv(nick,cmd);
    if (stricmp(snick, s_ChanServ) == 0)
        chanserv(nick,cmd);
    if (stricmp(snick, s_MemoServ) == 0)
	memoserv(nick,cmd);
#endif
}

/*************************************************************************/

/* Services admin list modification. */

static void do_sa(const char *source)
{
    char *cmd, *nick;
    NickInfo *ni;
    int i;

    cmd = strtok(NULL, " ");
    if (!cmd)
	cmd = "";

    if (stricmp(cmd, "ADD") == 0) {
	if (!is_services_root(source)) {
            notice(s_RootServ, source, "Permission denied.");
	    return;
	}
	nick = strtok(NULL, " ");
	if (nick) {
	    if (!findnick(nick)) {
                notice(s_RootServ, source, "Nick %s isn't registered!", nick);
		return;
	    }
            for (i = 0; services_admins[i]; i++) {
                if (services_admins[i] && !stricmp(nick,services_admins[i])) {
                    notice(s_RootServ, source, "%s is already a SA",
                        nick);
                    return;
                }
                if (is_services_root(nick)) {
                    notice(s_RootServ, source, "Error - %s is a higher access than Services Administrator", nick);
                    return;
                }

                if (!services_admins[i])
                    break;
            }
            if ((i < MAX_SERVADMINS) || (MAX_SERVADMINS == 0)) {
		services_admins[i] = sstrdup(nick);
                log("!! Added \2%s\2 to SA List", nick);
                do_break_log("OS", "!! Added %s to SA List", nick);
                wallops(SERVER_NAME, "%s added %s to the SA List", source, nick);
                notice(s_RootServ, source,
			"%s added to Services admin list.", nick);

                for (i = 0; i < MAX_HELPOPS; i++) {
                    if (services_helpers[i] && !stricmp(nick, services_helpers[i]))
                        services_helpers[i] = NULL;
                }

                for (i = 0; i < MAX_SERVOPERS; i++) {
                    if (services_opers[i] && !stricmp(nick, services_opers[i]))
                        services_opers[i] = NULL;
                }


	    } else {
                notice(s_RootServ, source,
			"Too many entries (%d) on Services admin list; cannot add more.",
			MAX_SERVADMINS);
                wallops(s_RootServ, "\2Warning\2: Services Admin list is full! (%d)", MAX_SERVADMINS);
	    }
	    if (readonly) {
                notice(s_RootServ, source,
		    "\2Notice:\2 Changes will not be saved!  Services is in read-only mode.");
	    }
	} else {
            notice(s_RootServ, source, "Syntax: \2SA ADD\2 <nick>");
	}

    } else if (stricmp(cmd, "DEL") == 0) {
	if (!is_services_root(source)) {
            notice(s_RootServ, source, "Permission denied.");
	    return;
	}
	if (nick = strtok(NULL, " ")) {
	    for (i = 0; i < MAX_SERVADMINS; i++) {
		if (services_admins[i] && stricmp(nick,services_admins[i]) == 0)
		    break;
	    }
            if ((i < MAX_SERVADMINS) || (MAX_SERVADMINS == 0)) {
		free(services_admins[i]);
                services_admins[i] = NULL;
                log("!! Deleted \2%s\2 from SA List", nick);
                do_break_log("OS", "!! Deleted %s from SA List", nick);
                wallops(SERVER_NAME, "%s deleted %s from the SA List", source, nick);
                notice(s_RootServ, source,
			"%s removed from Services admin list.", nick);
		if (readonly) {
                    notice(s_RootServ, source,
			    "\2Notice:\2 Changes will not be saved!  Services is in read-only mode.");
		}
	    } else {
                notice(s_RootServ, source,
			"%s not found on Services admin list.", nick);
	    }
	} else {
            notice(s_RootServ, source, "Syntax: \2SA DEL\2 <nick>");
	}

    } else if (stricmp(cmd, "LIST") == 0) {
           notice(s_RootServ, source, "\2Services Administrators:\2");
           notice(s_RootServ, source, "");
	for (i = 0; i < MAX_SERVADMINS; i++) {
	    if (services_admins[i]) {
              if (ni = findnick(services_admins[i]))
                 notice(s_RootServ, source, "%s (%s)", services_admins[i], ni->last_usermask);
            }
        }
           notice(s_RootServ, source, "\2End of List\2");

    } else {
        notice(s_RootServ, source,
                "Syntax: \2SA\2 [ADD|DEL|LIST] [<nick>]");
        notice(s_RootServ, source,
                "For help: \2/msg %s OHELP SA\2", s_RootServ);
    }
}

/*************************************************************************/


static void do_logsearch(const char *source)
{
   DIR *dir;
   struct dirent *ent;
   const char *cmd = strtok(NULL, " ");
   const char *search = strtok(NULL, "");
   int sresult=0;

   if (!search) {
      notice(s_RootServ, source,
           "Syntax: SEARCH [HISTORY|TODAY] <string>");
      return;
   }
   if (stricmp(cmd, "TODAY") == 0) {
        notice(s_RootServ, source,
            "Searching today's logfile for: %s", search);
        search_log(source, slog_filename, search);
   } else if (stricmp(cmd, "HISTORY") == 0) {
        notice(s_RootServ, source,
            "Searching logfile(s) for: %s", search);
       dir = opendir("./logs"); chdir("./logs");
       while ((ent = readdir(dir)) != NULL)
       {
          if (strchr(ent->d_name, '_')
             && !match_wild_nocase("*.log", ent->d_name)) {
             if (sresult = search_log(source, ent->d_name, search) == 1)
                 break;
          }
       }
       closedir(dir); chdir("..");
   } else {
      notice(s_RootServ, source,
           "Syntax: SEARCH [HISTORY|TODAY] <[*]string[*]>");
      return;
   }

   if (lsearch == 0)
       notice(s_RootServ, source,
           "No Enteries found matching search criteria");
   else
     notice(s_RootServ, source,
         "End of search - %d/%d matches shown",
             lsearch>50 ? 50 : lsearch, lsearch);

    notice(s_RootServ, source,
            "This search has been logged.");

   log("(LOG)SEARCH requested by %s: %s", source, search);
   lsearch = 0;
}

static int search_log(const char *source, const char *logfile, const char *search)
{

   FILE *f = fopen(logfile, "r");
   char buf[1024];


   if (!f) {
      log("ERROR: Can't open %s on (LOG)SEARCH request!", logfile);
      notice(s_RootServ, source,
           "Sorry, an error has occured retreiving the log file(s)");
      return 1;
   } else {
      while (fgets(buf, 1024, f)) {
          if (match_wild_nocase(search, buf)) {
               if (lsearch++ <= 50)
                   notice(s_RootServ, source,
                       "LOG(%d): %5s", lsearch, buf);
          }
    }
    fclose(f);
  }





}


/*************************************************************************/
/*************************************************************************/

