/* ChanServ functions.
 * 
 * Auspice Services is copyright (c) 2000-2001 In Mean
 *  http://www.auspice.org
 * Originally based on SirvNET Services(c) by Trevor Klingbeil.
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */

/*************************************************************************/

#include "../inc/services.h"
#include "../inc/timeout.h"

# define MODE_SENDER s_ChanServ

/*************************************************************************/

static ChannelInfo *chanlists[256];

static int def_levels[][2] = {
    { CA_AUTOOP,             5 },
    { CA_AUTOHOP,            4 },
    { CA_AUTOVOICE,          3 },
    { CA_USEROP,	    	     2 },
    { CA_AUTODEOP,          -1 },
    { CA_NOJOIN,            -1 },
    { CA_INVITE,             5 },
    { CA_AKICK,             10 },
    { CA_SET,               13 },
    { CA_CLEAR,             13 },
    { CA_UNBAN,              5 },
    { CA_OPDEOP,             5 },
    { CA_ACCESS_LIST,        3 },
    { CA_ACCESS_CHANGE,      1 },
    { -1 }
};
/*************************************************************************/

void expire_ur_chans();
inline void check_welcome(User *user, const char *chan);
void do_aglist(const char *source);
void do_glist(const char *source);
// void do_doop(const char *source);
int is_relatenick(NickInfo *ni, const char *nick);
static void do_set_autovop(User *u, ChannelInfo *ci, const char *param);
static void do_set_autohop(User *u, ChannelInfo *ci, const char *param);
static void do_set_autoop(User *u, ChannelInfo *ci, const char *param);
static void do_set_newsset(User *u, ChannelInfo *ci, const char *param);
static void do_set_badwords(const char *source);
static void do_set_protect(User *u, ChannelInfo *ci, const char *param);
static void do_set_leaveop(User *u, ChannelInfo *ci, const char *param);
static void do_set_verbose(User *u, ChannelInfo *ci, const char *param);
static void do_set_badchan(User *u, ChannelInfo *ci, const char *param);
static void do_set_gb(User *u, ChannelInfo *ci, const char *param);
static void do_set_badnick(User *u, ChannelInfo *ci, const char *param);
static void do_set_news(const char *source);
static void alpha_insert_chan(ChannelInfo *ci);
static ChannelInfo *makechan(const char *chan);
static int delchan(ChannelInfo *ci);
static void reset_levels(ChannelInfo *ci);
static int is_founder(User *user, NickInfo *ni, ChannelInfo *ci, int set);
static int is_successor(User *user, NickInfo *ni, ChannelInfo *ci, int set);
static int is_identified(User *user, ChannelInfo *ci);
static void do_ohelp(const char *source);
static void do_ostopic(const char *source);
static void do_help(const char *source);
static void do_register(const char *source);
static void do_identify(const char *source);
static void do_delete(const char *source);
static void do_drop(const char *source);
static void do_set(const char *source);
static void do_set_founder(User *u, ChannelInfo *ci);
static void do_set_successor(User *u, ChannelInfo *ci, const char *param);
static void do_unset_successor(User *u, ChannelInfo *ci, char *param);
static void do_set_password(User *u, ChannelInfo *ci, const char *param);
static void do_set_desc(User *u, ChannelInfo *ci, const char *param);
static void do_set_welcome(User *u, ChannelInfo *ci, const char *param);
static void do_set_url(User *u, ChannelInfo *ci, const char *param);
static void do_memolev(User *u, ChannelInfo *ci, const char *param);
static void do_set_email(User *u, ChannelInfo *ci, const char *param);
static void do_set_topic(User *u, ChannelInfo *ci, const char *param);
static void do_set_mlock(User *u, ChannelInfo *ci, const char *param);
static void do_set_keeptopic(User *u, ChannelInfo *ci, const char *param);
static void do_set_topiclock(User *u, ChannelInfo *ci, const char *param);
static void do_set_private(User *u, ChannelInfo *ci, const char *param);
static void do_set_opguard(User *u, ChannelInfo *ci, const char *param);
#ifdef DEFHALFOP
static void do_set_hopguard(User *u, ChannelInfo *ci, const char *param);
#endif
static void do_set_chanjoin(User *u, ChannelInfo *ci, const char *param);
static void do_set_restricted(User *u, ChannelInfo *ci, const char *param);
static void do_set_ident(User *u, ChannelInfo *ci, const char *param);
static void do_set_unsecure(User *u, ChannelInfo *ci, const char *param);
static void do_cfounder(const char *source);
static void do_avoice(const char *source);
#ifdef DEFHALFOP
static void do_hop(const char *source);
#endif
static void do_sop(const char *source);
static void do_aop(const char *source);
static void do_akick(const char *source);
static void do_info(const char *source);
static void do_list(const char *source);
static void do_flist(const char *source);
static void do_invite(const char *source);
static void do_op(const char *source);
static void do_voice (const char *source);
static void do_devoice (const char *source);
#ifdef DEFHALFOP
static void do_halfop (const char *source);
static void do_dehalfop (const char *source);
#endif
static void do_deop(const char *source);
static void do_unban(const char *source);
static void do_clear(const char *source);
static void do_wipe(const char *source);
static void do_count(const char *source);
static void do_getpass(const char *source);
#ifndef CYGWIN
static void do_sendpass(const char *source);
#endif
static void do_forbid(const char *source);
static void do_freeze(const char *source);
static void do_suspend(const char *source);
static void do_close(const char *source);
static void do_reopen(const char *source);
static void do_why(const char *source);
static void do_level(const char *source);
static void do_hold(const char *source);
static void do_mark(const char *source);
void do_cs_join(const char *chan);
void do_cs_part(const char *chan);
static void do_setpass(const char *source);
static void do_setfounder(const char *source);
#ifdef DEFPROTECT
static void do_protect (const char *source);
static void do_deprotect (const char *source);
#endif
static void do_mkick(const char *source);
static void do_getkey(const char *source);
char *who_access(User *user, ChannelInfo *ci);
char *addedby(ChannelInfo *ci, const char *nick);
char *inbadchannel(const char *source, ChannelInfo *ci);
int is_badnick(ChannelInfo *ci, char *text1, char *text2, char *text3, char *text4);
static int newcheck_opguard(ChannelInfo *ci, User *user, const char *chan, int newchan);
static void do_timeop(const char *source);
static void cimassop(User *user, ChannelInfo *ci, NickInfo *ni, Channel *c);

#ifdef MERGE
void load_csmerge_dbase(void);
#endif
static int isexpire(ChannelInfo *ci, time_t expire_time);
static int isvalidzone(int accflag);
/*************************************************************************/
/*************************************************************************/

/* Display total number of registered channels and info about each; or, if
 * a specific channel is given, display information about that channel
 * (like /msg ChanServ INFO <channel>).  If count_only != 0, then only
 * display the number of registered channels (the channel parameter is
 * ignored).
 */

void listchans(int count_only, const char *chan)
{
    long count = 0;
    ChannelInfo *ci;
    int i;

    if (count_only) {

	for (i = 33; i < 256; ++i)
	    for (ci = chanlists[i]; ci; ci = ci->next)
		++count;
	printf("%li channels registered.\n", count);

    } else if (chan) {

	struct tm tm;
	NickInfo *ni;
	char *t;

	if (!(ci = cs_findchan(chan))) {
	    printf("Channel %s not registered.\n", chan);
	    return;
	}
	ni = findnick(ci->founder);
	if (ni)
	    t = ni->last_usermask;
	else
	    t = NULL;
	if (ci->flags & CI_VERBOTEN) {
	    printf("Channel %s is FORBIDden.\n", ci->name);
	} else {
	    printf("Information about channel %s:\n", ci->name);
	    printf("        Founder: %s%s%s%s\n",
			ci->founder, t ? " (" : "", t ? t : "", t ? ")" : "");
	    printf("    Description: %s\n", ci->desc);
	    tm = *localtime(&ci->time_registered);
	    printf("     Registered: %s %2d %02d:%02d:%02d '%d\n",
			month_name(tm.tm_mon+1), tm.tm_mday, tm.tm_hour,
			tm.tm_min, tm.tm_sec, tm.tm_year);
	    tm = *localtime(&ci->last_used);
	    printf("      Last used: %s %2d %02d:%02d:%02d '%d\n",
			month_name(tm.tm_mon+1), tm.tm_mday, tm.tm_hour,
			tm.tm_min, tm.tm_sec, tm.tm_year);
	    if (ci->last_topic) {
		printf("     Last topic: %s\n", ci->last_topic);
		printf("   Topic set by: %s\n", ci->last_topic_setter);
	    }
	    if (ci->url)
		printf("            URL: %s\n", ci->url);
	    if (ci->email)
		printf(" E-mail address: %s\n", ci->email);
	    printf("        Options: ");
	    if (!ci->flags) {
		printf("None\n");
	    } else {
		int need_comma = 0;
		static const char commastr[] = ", ";
		if (ci->flags & CI_PRIVATE) {
		    printf("Private");
		    need_comma = 1;
		}
		if (ci->flags & CI_KEEPTOPIC) {
		    printf("%sTopic Retention", need_comma ? commastr : "");
		    need_comma = 1;
		}
		if (ci->flags & CI_TOPICLOCK) {
		    printf("%sTopic Lock", need_comma ? commastr : "");
		    need_comma = 1;
		}
		if (ci->flags & CI_OPGUARD) {
		    printf("%sOp Guard", need_comma ? commastr : "");
		    need_comma = 1;
		}
		if (ci->flags & CI_RESTRICTED) {
		    printf("%sRestricted Access", need_comma ? commastr : "");
		    need_comma = 1;
		}
		if (ci->flags & CI_IDENT) {
		    printf("%sIdent", need_comma ? commastr : "");
		    need_comma = 1;
		}
                if (ci->flags & CI_HELDCHAN) {
                    printf("%sHeld", need_comma ? commastr : "");
                    need_comma = 1;
                }
                if (ci->flags & CI_MARKCHAN) {
                    printf("%sMarked", need_comma ? commastr : "");
                    need_comma = 1;
                }
	    }
	    printf("      Mode lock: +%s-%s", ci->mlock_on, ci->mlock_off);
	    if (ci->mlock_key)
		printf(" %s", ci->mlock_key);
	    if (ci->mlock_limit)
		printf(" %ld", ci->mlock_limit);
	    printf("\n");
	}

    } else {

	for (i = 33; i < 256; ++i) {
	    for (ci = chanlists[i]; ci; ci = ci->next) {
		printf("%-20s  %s\n", ci->name,
			ci->flags & CI_VERBOTEN ? "Disallowed (FORBID)"
			                        : ci->desc);
		++count;
	    }
	}
	printf("%li channels registered.\n", count);

    }
}

/*************************************************************************/

/* Return information on memory use.  Assumes pointers are valid. */

void get_chanserv_stats(long *nrec, long *memuse)
{
    long count = 0, mem = 0;
    int i, j;
    ChannelInfo *ci;
    char **inmean;
    for (i = 0; i < 256; i++) {
	for (ci = chanlists[i]; ci; ci = ci->next) {
	    count++;
	    mem += sizeof(*ci);
	    if (ci->desc)
		mem += strlen(ci->desc)+1;
	    mem += ci->accesscount * sizeof(ChanAccess);
	    mem += ci->akickcount * sizeof(AutoKick);
	    for (j = 0; j < ci->akickcount; j++) {
		if (ci->akick[j].name)
		    mem += strlen(ci->akick[j].name)+1;
		if (ci->akick[j].reason)
		    mem += strlen(ci->akick[j].reason)+1;
	    }
	    if (ci->mlock_key)
		mem += strlen(ci->mlock_key)+1;
	    if (ci->mlock_link)
		mem += strlen(ci->mlock_link)+1;
	    if (ci->mlock_flood)
		mem += strlen(ci->mlock_flood)+1;
	    if (ci->last_topic)
		mem += strlen(ci->last_topic)+1;
	    if (ci->levels)
		mem += sizeof(*ci->levels) * CA_SIZE;
            if (ci->url)
                mem += strlen(ci->url)+1;
            if (ci->email)
                mem += strlen(ci->email)+1;
            if (ci->successor)
                mem += strlen(ci->successor)+1;
            if (ci->welcome)
                mem += strlen(ci->welcome)+1;
            if (ci->hold)
                mem += strlen(ci->hold)+1;
            if (ci->mark)
                mem += strlen(ci->mark)+1;
            if (ci->forbid)
                mem += strlen(ci->forbid)+1;
            if (ci->freeze)
                mem += strlen(ci->freeze)+1;
            if (ci->bot)
                mem += strlen(ci->bot)+1;

            if (ci->markreason)
                mem += strlen(ci->markreason)+1;

            if (ci->freezereason)
                mem += strlen(ci->freezereason)+1;

            if (ci->holdreason)
                mem += strlen(ci->holdreason)+1;

            if (ci->lastgetpass)
                mem += strlen(ci->lastgetpass)+1;

            mem += sizeof(char *) * ci->newsline;
            for (inmean=ci->news, j=0; j < ci->newsline; inmean++, j++) {
                if (*inmean)
                    mem += strlen(*inmean)+1;
            }
            mem += sizeof(char *) * ci->badwline;
            for (inmean=ci->badwords, j=0; j < ci->badwline; inmean++, j++) {
                if (*inmean)
                    mem += strlen(*inmean)+1;
            }

	}
    }
    *nrec = count;
    *memuse = mem;
}

/*************************************************************************/

/*************************************************************************/

/* Main ChanServ routine. */

void chanserv(const char *source, char *buf)
{
    char *cmd, *s;

    cmd = strtok(buf, " ");

    if (!cmd) {
	return;
    } else if (stricmp(cmd, "\1PING") == 0) {
	if (!(s = strtok(NULL, "")))
	    s = "\1";
	notice(s_ChanServ, source, "\1PING %s", s);

    } else if (stricmp (cmd, "\1VERSION\1") == 0) {

        if (!(s = strtok (NULL, "")))
            s = "\1";
        notice(s_ChanServ, source, "%sVERSION Auspice IRC Services %s", s, s);

    } else if (stricmp(cmd, "HELP") == 0) {
	do_help(source);

    } else if (stricmp(cmd, "REGISTER") == 0) {
	do_register(source);
#ifdef MERGE
    } else if (stricmp(cmd, "MERGE") == 0) {
	load_csmerge_dbase();
#endif
    } else if (stricmp(cmd, "IDENTIFY") == 0) {
	do_identify(source);

    } else if (stricmp(cmd, "ID") == 0) {
	do_identify(source);

    } else if (stricmp(cmd, "GETKEY") == 0) {
	do_getkey(source);

    } else if (stricmp(cmd, "DROP") == 0) {
	do_drop(source);

    } else if (stricmp(cmd, "SET") == 0) {
	do_set(source);

    } else if (stricmp(cmd, "CFOUNDER") == 0) {
        do_cfounder(source);

    } else if (stricmp(cmd, "CF") == 0) {
        do_cfounder(source);

    } else if (stricmp(cmd, "VOP") == 0) {
        do_avoice(source);
#ifdef DEFHALFOP
    } else if (stricmp(cmd, "HOP") == 0) {
        do_hop(source);
#endif
    } else if (stricmp(cmd, "SOP") == 0) {
        do_sop(source);

    } else if (stricmp(cmd, "AOP") == 0) {
	do_aop(source);

    } else if (stricmp(cmd, "TIMEOP") == 0) {
	do_timeop(source);

    } else if (stricmp(cmd, "BADWORDS") == 0) {
	do_set_badwords(source);

    } else if (stricmp(cmd, "NEWS") == 0) {
	do_set_news(source);

    } else if (stricmp(cmd, "AKICK") == 0) {
	do_akick(source);

    } else if (stricmp(cmd, "INVITE") == 0) {
	do_invite(source);

    } else if (stricmp(cmd, "UNBAN") == 0) {
	do_unban(source);

    } else if (stricmp(cmd, "INFO") == 0) {
	do_info(source);
    } else if (stricmp(cmd, "WHY") == 0) {
        do_why(source);
    } else if (stricmp(cmd, "OP") == 0) {
	do_op(source);
#ifdef DEFPROTECT
    } else if (stricmp(cmd, "PROTECT") == 0) {
	do_protect(source);
    } else if (stricmp(cmd, "DEPROTECT") == 0) {
	do_deprotect(source);
#endif
    } else if (stricmp(cmd, "HACK") == 0) {
	char *chan = strtok(NULL, " ");
	if (is_admin(source)) {
		if (chan) {
			Channel *c = findchan(chan);
			if (c) {
				notice(s_ChanServ, source, "*** \2Hacking %s\2 ***", chan);
				if (c->ngames) {
					notice(s_ChanServ, source, "Guess Number: %d", c->ngames);
				}
				if (c->havebot) {
					notice(s_ChanServ, source, "Have bot in");
				}
				if (c->modes) {
					notice(s_ChanServ, source, "Mode: %s", c->modes);
				}
				notice(s_ChanServ, source, "*** \2Hacked\2 ***");
			}
		}
	}
    } else if (stricmp(cmd, "Zone") == 0) {
	notice(s_ChanServ, source, "You are in zone %d", getzone());
#ifdef TEST
    } else if (stricmp(cmd, "ADD") == 0) {
	char *chan = strtok(NULL, " ");
	ChannelInfo *ci = cs_findchan(chan);
	log("%s", addedby(ci, source));
    } else if (stricmp(cmd, "CRASH") == 0) {
	char *chan;
	free(chan);
    } else if (stricmp(cmd, "test") == 0) {
	char *chan = strtok(NULL, " ");
	char *cmode = strtok(NULL, " ");
	notice(s_ChanServ, source, changemode(chan, cmode));
#endif
    } else if (stricmp(cmd, "MKICK") == 0) {
	do_mkick(source);

    } else if (stricmp(cmd, "DEOP") == 0) {
	do_deop(source);

    } else if (stricmp(cmd, "VOICE") == 0) {
	do_voice(source);

    } else if (stricmp(cmd, "DEVOICE") == 0) {
	do_devoice(source);

#ifdef DEFHALFOP
    } else if (stricmp(cmd, "HALFOP") == 0) {
	do_halfop(source);

    } else if (stricmp(cmd, "DEHALFOP") == 0) {
	do_dehalfop(source);
#endif
    } else if (stricmp(cmd, "CLEAR") == 0) {
	do_clear(source);
    } else if (stricmp(cmd, "COUNT") == 0) {
        do_count(source);

    } else if (stricmp(cmd, "MOP") == 0) {
	char *chan = strtok(NULL, " ");
	Channel *c;
        ChannelInfo *ci;
        User *u = finduser(source);

	if (!chan) {
		notice(s_ChanServ, source, "Syntax: MOP #channel");
		return;
	}		

	c = findchan(chan);

	if (!c) {
	        notice(s_ChanServ, source, "Channel %s does not exist.", chan);
	} else if (!(ci = cs_findchan(chan))) {
	        notice(s_ChanServ, source, "Channel %s is not registered.", chan);
	} else if (ci->flags & CI_FREEZECHAN) {
	        notice(s_ChanServ, source, "Channel %s is Frozen.", chan);
	} else if (!u || !check_access(u, ci, CA_CLEAR)) {
	        notice(s_ChanServ, source, toknmsg[26], chan);
	} else {
		struct c_userlist *cu, *next;
		for (cu = c->users; cu; cu = next) {
	            next = cu->next;
		if (!is_chanop(cu->user->nick, chan))
		       change_cmode (s_ChanServ, chan, "+o", cu->user->nick);
		}
		notice(s_ChanServ, source, "Masse +o all user in %s.", chan);
	}

    } else if (stricmp(cmd, "ULIST") == 0) {
	char *chan = strtok(NULL, " ");
	Channel *c;

	if (!chan) {
		notice(s_ChanServ, source, "Syntax: ULIST #channel");
		return;
	}	
	c = findchan(chan);	
	if (!c) {
	        notice(s_ChanServ, source, "Channel %s does not exist.", chan);
	} else {
		struct c_userlist *cu, *next;
		for (cu = c->users; cu; cu = next) {
	            next = cu->next;
			notice(s_ChanServ, source, "User: %s", cu->user->nick);
		}
	}

    } else if (stricmp(cmd, "MDEOP") == 0) {
	Channel *c;
        ChannelInfo *ci;
	char *chan = strtok(NULL, " ");
        User *u = finduser(source);

	if (!chan) {
		notice(s_ChanServ, source, "Syntax: MDEOP #channel");
		return;
	}	

	if (!(c = findchan(chan))) {
	        notice(s_ChanServ, source, "Channel %s does not exist.", chan);
	} else if (!(ci = cs_findchan(chan))) {
	        notice(s_ChanServ, source, "Channel %s is not registered.", chan);
	} else if (ci->flags & CI_FREEZECHAN) {
	        notice(s_ChanServ, source, "Channel %s is Frozen.", chan);
	} else if (!u || !check_access(u, ci, CA_CLEAR)) {
	        notice(s_ChanServ, source, toknmsg[26], chan);
	} else {
		struct c_userlist *cu, *next;
		for (cu = c->users; cu; cu = next) {
	            next = cu->next;
	            if (is_chanop(cu->user->nick, chan))
		       change_cmode (s_ChanServ, chan, "-o", cu->user->nick);
		}
		notice(s_ChanServ, source, "Masse -o all user in %s.", chan);
	}

    } else if (!is_services_helpop(source)) {
        notice(s_ChanServ, source, NS_UNKNOWC, cmd, s_ChanServ);
        return;

    } else if (!is_oper(source)) {
        notice(s_ChanServ, source, NS_UNKNOWC, cmd, s_ChanServ);
            return;

#ifndef CYGWIN
    } else if (stricmp(cmd, "SENDPASS") == 0) {
	do_sendpass(source);
#endif
    } else if (stricmp(cmd, "FLIST") == 0) {
	do_flist(source);

    } else if (stricmp(cmd, "OHELP") == 0) {
	do_ohelp(source);

    } else if (!rec_services_oper(source)) {
	notice(s_ChanServ, source,
		"Unrecognized command \2%s\2.  Type \"/msg %s HELP\" for help.",
		cmd, s_ChanServ);

    } else if (stricmp(cmd, "SUSPEND") == 0) {
       do_suspend(source);

    } else if (stricmp(cmd, "FREEZE") == 0) {
        do_freeze(source);

    } else if (stricmp(cmd, "TOPIC") == 0) {
        do_ostopic(source);

    } else if (!is_services_admin(source)) {
        notice(s_ChanServ, source, NS_UNKNOWC, cmd, s_ChanServ);
            return;
    } else if (stricmp(cmd, "LEVEL") == 0) {
        do_level(source);
    } else if (stricmp(cmd, "WIPE") == 0) {
         do_wipe(source);
    } else if (stricmp(cmd, "HOLD") == 0) {
	do_hold(source);
    } else if (stricmp(cmd, "MARK") == 0) {
	do_mark(source);
    } else if (stricmp(cmd, "GETPASS") == 0) {
	do_getpass(source);

    } else if (!is_services_root(source)) {
        notice(s_ChanServ, source, NS_UNKNOWC, cmd, s_ChanServ);
           return;

    } else if (stricmp(cmd, "FORBID") == 0) {
        do_forbid(source);
    } else if (stricmp(cmd, "CLOSE") == 0) {
        do_close(source);
    } else if (stricmp(cmd, "REOPEN") == 0) {
        do_reopen(source);
    } else if (stricmp(cmd, "SETPASS") == 0) {
        do_setpass(source);
    } else if (stricmp(cmd, "SETFOUNDER") == 0) {
        do_setfounder(source);
    } else if (stricmp(cmd, "LIST") == 0) {
	do_list(source);
    } else if (stricmp(cmd, "DELETE") == 0) {
        do_delete(source);
    } else {
        User *u = finduser(source);
	notice(s_ChanServ, source,
		"Unrecognized command \2%s\2.  Type \"/msg %s HELP\" for help.",
		cmd, s_ChanServ);
        slog("CS *C %s (%s@%s) [%s]",
            source, u->username, u->host, cmd);

    }

}

/*************************************************************************/
/* Load/save data files. */

void load_cs_dbase(void)
{
    FILE *f = fopen(CHANSERV_DB, "r");
    int ver, j;
    ChannelInfo *ci;

    if (!(f = open_db(s_ChanServ, CHANSERV_DB, "r",1)))
	return;

    switch (ver = get_file_version(f, CHANSERV_DB)) {

      case 7:
	{
	int i;
	ChannelInfo7 *old_ci;
        for (i = 33; i < 256; ++i) {
            while (fgetc(f) == 1) {

                ci = smalloc(sizeof(ChannelInfo));
                old_ci = smalloc(sizeof(ChannelInfo7));
       	        if (1 != fread(old_ci, sizeof(ChannelInfo7), 1, f))
                    fatal_perror("Read error on %s", CHANSERV_DB);

                if (old_ci->flags & CI_ENCRYPTEDPW) {
                    fatal("%s: load database: password for %s encrypted"
                          "but encryption disabled, aborting",
                          s_ChanServ, old_ci->name);
                }

		strscpy(ci->mlock_on, old_ci->mlock_on, sizeof(ci->mlock_on));
		strscpy(ci->mlock_off, old_ci->mlock_off, sizeof(ci->mlock_off));
                strscpy(ci->name, old_ci->name, sizeof(ci->name));
                strscpy(ci->founder, old_ci->founder, sizeof(ci->founder));
                strscpy(ci->founderpass, old_ci->founderpass,
                                                sizeof(ci->founderpass));
                strscpy(ci->last_topic_setter, old_ci->last_topic_setter,
                                        sizeof(ci->last_topic_setter));
                ci->time_registered = old_ci->time_registered;
                ci->last_used = old_ci->last_used;
                ci->accesscount = old_ci->accesscount;
                ci->akickcount = old_ci->akickcount;
                ci->mlock_limit = old_ci->mlock_limit;
                ci->last_topic_time = old_ci->last_topic_time;
                ci->flags = old_ci->flags;
                ci->levels = old_ci->levels;
                ci->topic_allow = old_ci->topic_allow;
		ci->botflag = old_ci->botflag;
		ci->newsline = old_ci->newsline;
		ci->badwline = old_ci->badwline;
                alpha_insert_chan(ci);

		if (old_ci->desc) {
        	        old_ci->desc = read_string(f, CHANSERV_DB);
			if (strlen(old_ci->desc)>0) {
	        	        ci->desc = sstrdup(old_ci->desc);
			} else
				ci->desc = NULL;
	                free (old_ci->desc);
		} else
			ci->desc = NULL;

                if (old_ci->url) {
                    old_ci->url = read_string(f, CHANSERV_DB);
                    if (strlen(old_ci->url) > 0)
                        ci->url = sstrdup(old_ci->url);
                    else
                        ci->url = NULL;
                    free (old_ci->url);
		} else
                    ci->url = NULL;
		
                if (old_ci->email) {
                    old_ci->email = read_string(f, CHANSERV_DB);
                    if (strlen(old_ci->email) > 0)
                        ci->email = sstrdup(old_ci->email);
                    else
                        ci->email = NULL;
                    free (old_ci->email);
		} else
                        ci->email = NULL;

                if (old_ci->mlock_key)
                {
                    old_ci->mlock_key = read_string(f, CHANSERV_DB);
                    if (strlen(old_ci->mlock_key) > 0)
	                    ci->mlock_key = sstrdup(old_ci->mlock_key);
		    else
			    ci->mlock_key = NULL;
                    free(old_ci->mlock_key);
                }
                else
                    ci->mlock_key = NULL;

                if (old_ci->last_topic) {
                    old_ci->last_topic = read_string(f, CHANSERV_DB);
		    if (strlen(old_ci->last_topic)>0)
	                    ci->last_topic = sstrdup(old_ci->last_topic);
		    else
			    ci->last_topic = NULL;
                    free (old_ci->last_topic);
                } else
                    ci->last_topic = NULL;

		if (old_ci->welcome) {
		    old_ci->welcome = read_string(f, CHANSERV_DB);
		    if (strlen(old_ci->welcome)>0)
	                    ci->welcome = sstrdup(old_ci->welcome);
		    else
			    ci->welcome = NULL;
                    free (old_ci->welcome);
		} else
                    ci->welcome = NULL;


                if (old_ci->hold) {
                    old_ci->hold = read_string(f, CHANSERV_DB);
		    if (strlen(old_ci->hold)>0)
			    ci->hold = sstrdup(old_ci->hold);
		    else
			    ci->hold = NULL;
		    free(old_ci->hold);
		} else
                    ci->hold = NULL;

                if (old_ci->mark) {
                    old_ci->mark = read_string(f, CHANSERV_DB);
		    if (strlen(old_ci->mark)>0)
			    ci->mark = sstrdup(old_ci->mark);
		    else
			    ci->mark = NULL;
		    free(old_ci->mark);
		} else
		    ci->mark = NULL;

                if (old_ci->freeze) {
                    old_ci->freeze = read_string(f, CHANSERV_DB);
		    if (strlen(old_ci->freeze)>0)
			    ci->freeze = sstrdup(old_ci->freeze);
		    else
			    ci->freeze = NULL;
		    free(old_ci->freeze);
		} else
		    ci->freeze = NULL;

                if (old_ci->forbid) {
                    old_ci->forbid = read_string(f, CHANSERV_DB);
		    if (strlen(old_ci->forbid)>0)
			    ci->forbid = sstrdup(old_ci->forbid);
		    else
			    ci->forbid = NULL;
		    free(old_ci->forbid);
		} else
		    ci->forbid = NULL;

                if (old_ci->successor) {
                    old_ci->successor = read_string(f, CHANSERV_DB);
		    if (strlen(old_ci->successor)>0)
			    ci->successor = sstrdup(old_ci->successor);
		    else
			    ci->successor = NULL;
		    free(old_ci->successor);
		} else
		    ci->successor = NULL;

		if (old_ci->mlock_link) {
                    old_ci->mlock_link = read_string(f, CHANSERV_DB);
		    if (strlen(old_ci->mlock_link)>0)
			    ci->mlock_link = sstrdup(old_ci->mlock_link);
		    else
			    ci->mlock_link = NULL;
		    free(old_ci->mlock_link);
		} else
		    ci->mlock_link = NULL;

       		if (old_ci->mlock_flood) {
                    old_ci->mlock_flood = read_string(f, CHANSERV_DB);
		    if (strlen(old_ci->mlock_flood)>0)
			    ci->mlock_flood = sstrdup(old_ci->mlock_flood);
		    else
			   ci->mlock_flood = NULL;
		    free(old_ci->mlock_flood);
		} else
		    ci->mlock_flood = NULL;

       		if (old_ci->bot) {
                    old_ci->bot = read_string(f, CHANSERV_DB);
		    if (strlen(old_ci->bot)>0)
			    ci->bot = sstrdup(old_ci->bot);
		    else
			ci->bot=NULL;
		    free(old_ci->bot);
		} else
		    ci->bot = NULL;

                if (ci->accesscount) {
                    ChanAccess *access1;
                    ChanAccess7 *old_access;
                    old_access = smalloc(sizeof(ChanAccess7) * old_ci->accesscount);
                    access1 = smalloc(sizeof(ChanAccess) * ci->accesscount);

                    old_ci->access = old_access;
                    ci->access = access1;

                    if (ci->accesscount != fread(old_access,sizeof(ChanAccess7),
                                                        ci->accesscount, f))
                        fatal_perror("Read error on ", CHANSERV_DB);

                    for (j = 0; j < ci->accesscount; ++j, ++access1, ++old_access) {
			if (old_access->name)
	                        access1->name = read_string(f, CHANSERV_DB);
			else
			   access1->name = NULL;
			if (old_access->adder)
	                        access1->adder = read_string(f, CHANSERV_DB);
			else
				access1->adder = NULL;
			access1->is_nick = old_access->is_nick;
			access1->level = old_access->level;
			access1->in_use = old_access->in_use;
			access1->accflag = 0;
		    }

		    access1 = ci->access;
		    j=0;

                    /* Clear out unused entries */
                    while (j < ci->accesscount) {
                        if (!findnick(access1->name))
			{
                            --ci->accesscount;
			if (access1->name) {
                            free(access1->name);
			}
			if (access1->adder) {
                            free(access1->adder);
			}
                        if (j < ci->accesscount)
			    memmove(access1, access1+1,sizeof(*access1) * (ci->accesscount - j));

                        } else {
                            access1->is_nick = 1;
                            ++j; ++access1;
                        }
                    }

                    if (old_ci->accesscount) {
                        ci->access = srealloc(ci->access,sizeof(ChanAccess) * ci->accesscount);
                    } else {
                        ci->access = NULL;
                        free(ci->access);
                    }
                } else {
                        ci->access = NULL;
                        free(ci->access);
		} 


                if (ci->akickcount) {
                    AutoKick *akick;
                    akick = smalloc(sizeof(AutoKick) * ci->akickcount);
                    ci->akick = akick;
                    if (ci->akickcount !=
                            fread(akick, sizeof(AutoKick), ci->akickcount, f))
                        fatal_perror("Read error on %s", CHANSERV_DB);
                    for (j = 0; j < ci->akickcount; ++j, ++akick) {
                        akick->name = read_string(f, CHANSERV_DB);
                        if (akick->reason)
                            akick->reason = read_string(f, CHANSERV_DB);
                    }
                    j = 0; akick = ci->akick;
                    while (j < ci->akickcount) {
                        if (akick->is_nick < 0) {
                            --ci->akickcount;
                            free(akick->name);
                            if (akick->reason)
                                free(akick->reason);
                            if (j < ci->akickcount)
				    memmove(akick, akick+1, sizeof(*akick) * (ci->akickcount - j));
                        } else {
                            ++j; ++akick;
                        }
                    }
                    if (ci->akickcount) {
                        ci->akick = srealloc(ci->akick,
                                        sizeof(AutoKick) * ci->akickcount);
                    } else {
                        free(ci->akick);
                        ci->akick = NULL;
                    }
                }

                if (ci->levels) {
                    int n_entries;
                    ci->levels = NULL;
                    reset_levels(ci);
                    n_entries = fgetc(f)<<8 | fgetc(f);
                    if (n_entries < 0)
                        fatal_perror("Read error on %s", CHANSERV_DB);
                    /* Ignore earlier, incompatible levels list */
                    if (n_entries == 6) {
                        fseek(f, sizeof(short) * n_entries, SEEK_CUR);
                    } else
                    if (n_entries <= CA_SIZE) {
                        fread(ci->levels, sizeof(short), n_entries, f);
                    } else {
                        fread(ci->levels, sizeof(short), CA_SIZE, f);
                        fseek(f, sizeof(short) * (n_entries - CA_SIZE),
                                                                SEEK_CUR);
                    }
                } else {
                    reset_levels(ci);
                }

                if (ci->newsline) {
                    char **channews;
                    channews = smalloc(sizeof(char *) * ci->newsline);
                    ci->news = channews;
                    for (j = 0; j < ci->newsline; ++j, ++channews) {
                        *channews = read_string(f, CHANSERV_DB);
                    }
                }

                if (ci->badwline) {
                    char **badwords;
                    badwords = smalloc(sizeof(char *) * ci->badwline);
                    ci->badwords = badwords;
                    for (j = 0; j < ci->badwline; ++j, ++badwords) {
                        *badwords = read_string(f, CHANSERV_DB);
                    }
                }

		ci->markreason = NULL;
		ci->freezereason = NULL;
		ci->holdreason = NULL;
		ci->lastgetpass = NULL;

		ci->ttb = 5; /* Default ban 5 minutes */
		ci->capsmin = 10;
		ci->capspercent = 25; /* 25% */
		ci->floodlines = 5;
		ci->floodsecs = 2;
		ci->repeattimes = 4;

            } 

        } 

        break; 
	}

      case 8:
		  {
		  int i;
        for (i = 33; i < 256; ++i) {
            while (fgetc(f) == 1) {
                ci = smalloc(sizeof(ChannelInfo));
       	        if (1 != fread(ci, sizeof(ChannelInfo), 1, f))
                    fatal_perror("Read error on %s", CHANSERV_DB);

                /* Can't guarantee the file is in a particular order...
                 * (Well, we can, but we don't have to depend on it.) */
                alpha_insert_chan(ci);

                if (ver < 3) {
                    NickInfo *ni = findnick(ci->founder);
                    if (ni && ni->channelcount+1 > ni->channelcount)
                        ni->channelcount++;
                }

                ci->desc = read_string(f, CHANSERV_DB);

                if (ci->url) {
                    ci->url = read_string(f, CHANSERV_DB);
		} else
                    ci->url = NULL;
		
                if (ci->email) {
                    ci->email = read_string(f, CHANSERV_DB);
		} else
                        ci->email = NULL;
		
                if (ci->mlock_key) {
                    ci->mlock_key = read_string(f, CHANSERV_DB);
                } else
                    ci->mlock_key = NULL;

                if (ci->last_topic) {
                    ci->last_topic = read_string(f, CHANSERV_DB);
                } else
                    ci->last_topic = NULL;

		if (ci->welcome)
		    ci->welcome = read_string(f, CHANSERV_DB);
                if (ci->hold)
                    ci->hold = read_string(f, CHANSERV_DB);
                if (ci->mark)
                    ci->mark = read_string(f, CHANSERV_DB);
                if (ci->freeze)
                    ci->freeze = read_string(f, CHANSERV_DB);
                if (ci->forbid)
                    ci->forbid = read_string(f, CHANSERV_DB);

                if (ci->successor) {
                    ci->successor = read_string(f, CHANSERV_DB);
		} else
		    ci->successor = NULL;

		if (ci->mlock_link)
                    ci->mlock_link = read_string(f, CHANSERV_DB);
		else
		    ci->mlock_link = NULL;

       		if (ci->mlock_flood)
                    ci->mlock_flood = read_string(f, CHANSERV_DB);
		else
		    ci->mlock_flood = NULL;

       		if (ci->bot)
                    ci->bot = read_string(f, CHANSERV_DB);
		else
		    ci->bot = NULL;

       		if (ci->markreason)
                    ci->markreason = read_string(f, CHANSERV_DB);
		else
		    ci->markreason = NULL;

       		if (ci->freezereason)
                    ci->freezereason = read_string(f, CHANSERV_DB);
		else
		    ci->freezereason = NULL;

       		if (ci->holdreason)
                    ci->holdreason = read_string(f, CHANSERV_DB);
		else
		    ci->holdreason = NULL;

       		if (ci->lastgetpass)
                    ci->lastgetpass = read_string(f, CHANSERV_DB);
		else
		    ci->lastgetpass = NULL;


                if (ci->accesscount) {
                    ChanAccess *access1;
                    access1 = smalloc(sizeof(ChanAccess) * ci->accesscount);
                    ci->access = access1;
                    if (ci->accesscount != fread(access1, sizeof(ChanAccess),
                                                        ci->accesscount, f))
                        fatal_perror("Read error on ", CHANSERV_DB);
                    for (j = 0; j < ci->accesscount; ++j, ++access1) {
                        access1->name = read_string(f, CHANSERV_DB);
                        access1->adder = read_string(f, CHANSERV_DB);
		    }
                    access1 = ci->access;
                    /* Clear out unused entries */
                    while (j < ci->accesscount) {
                        if (access1->is_nick < 0
			|| (access1->is_nick == 0 && !findnick(access1->name)))
			{
                            --ci->accesscount;
                            free(access1->name);
                            free(access1->adder);
                            if (j < ci->accesscount)
				memmove(access1, access1+1, sizeof(*access1) * (ci->accesscount - j));
                        } else {
                            access1->is_nick = 1;
                            ++j; ++access1;
                        }
                    }
                    if (ci->accesscount) {
                        ci->access = srealloc(ci->access, sizeof(ChanAccess) * ci->accesscount);
                    } else {
                        ci->access = NULL;
                        free(ci->access);
                    }
                } else {
                        ci->access = NULL;
                        free(ci->access);
		} /* if (ci->accesscount) */

                if (ci->akickcount) {
                    AutoKick *akick;
                    akick = smalloc(sizeof(AutoKick) * ci->akickcount);
                    ci->akick = akick;
                    if (ci->akickcount !=
                            fread(akick, sizeof(AutoKick), ci->akickcount, f))
                        fatal_perror("Read error on %s", CHANSERV_DB);
                    for (j = 0; j < ci->akickcount; ++j, ++akick) {
                        akick->name = read_string(f, CHANSERV_DB);
                        if (akick->reason)
                            akick->reason = read_string(f, CHANSERV_DB);
                    }
                    j = 0; akick = ci->akick;
                    while (j < ci->akickcount) {
                        if (akick->is_nick < 0) {
                            --ci->akickcount;
                            free(akick->name);
                            if (akick->reason)
                                free(akick->reason);
                            if (j < ci->akickcount)
				memmove (akick, akick+1, sizeof(*akick) * (ci->akickcount - j));
                        } else {
                            ++j; ++akick;
                        }
                    }
                    if (ci->akickcount) {
                        ci->akick = srealloc(ci->akick,
                                        sizeof(AutoKick) * ci->akickcount);
                    } else {
                        free(ci->akick);
                        ci->akick = NULL;
                    }
                } /* if (ci->akickcount) */
                if (ci->levels) {
                    int n_entries;
                    ci->levels = NULL;
                    reset_levels(ci);
                    n_entries = fgetc(f)<<8 | fgetc(f);
                    if (n_entries < 0)
                        fatal_perror("Read error on %s", CHANSERV_DB);
                    /* Ignore earlier, incompatible levels list */
                    if (n_entries == 6) {
                        fseek(f, sizeof(short) * n_entries, SEEK_CUR);
                    } else
                    if (n_entries <= CA_SIZE) {
                        fread(ci->levels, sizeof(short), n_entries, f);
                    } else {
                        fread(ci->levels, sizeof(short), CA_SIZE, f);
                        fseek(f, sizeof(short) * (n_entries - CA_SIZE),
                                                                SEEK_CUR);
                    }
                } else {
                    reset_levels(ci);
                }

                if (ci->newsline) {
                    char **channews;
                    channews = smalloc(sizeof(char *) * ci->newsline);
                    ci->news = channews;
                    for (j = 0; j < ci->newsline; ++j, ++channews) {
                        *channews = read_string(f, CHANSERV_DB);
                    }
                } else {
			 ci->news = NULL;
		    }

                if (ci->badwline) {
                    char **badwords;
                    badwords = smalloc(sizeof(char *) * ci->badwline);
                    ci->badwords = badwords;
                    for (j = 0; j < ci->badwline; ++j, ++badwords) {
                        *badwords = read_string(f, CHANSERV_DB);
                    }
                } else {
			ci->badwords = NULL;
                }


            } /* while (fgetc(f) == 1) */
}
        } /* for (i) */
	break;
      default:
	fatal("Unsupported version number (%d) on %s", ver, CHANSERV_DB);

    } /* switch (version) */

    close_db(f, CHANSERV_DB);
}
/************************************************************************/
#ifdef MERGE
void load_csmerge_dbase(void)
{
    FILE *f = fopen("chan2.db", "r");
    int ver, i, j;
    ChannelInfo *ci;

    if (!(f = open_db(s_ChanServ, "chan2.db", "r",1)))
	return;

    switch (ver = get_file_version(f, "chan2.db")) {
      case 7:
        for (i = 33; i < 256; ++i) {
            while (fgetc(f) == 1) {
                ci = smalloc(sizeof(ChannelInfo));
       	        if (1 != fread(ci, sizeof(ChannelInfo), 1, f))
                    fatal_perror("Read error on %s", "chan2.db");

                /* Can't guarantee the file is in a particular order...
                 * (Well, we can, but we don't have to depend on it.) */
                alpha_insert_chan(ci);

                if (ver < 3) {
                    NickInfo *ni = findnick(ci->founder);
                    if (ni && ni->channelcount+1 > ni->channelcount)
                        ni->channelcount++;
                }

                ci->desc = read_string(f, "chan2.db");

                if (ci->url) {
                    ci->url = read_string(f, "chan2.db");
		} else
                    ci->url = NULL;
		
                if (ci->email) {
                    ci->email = read_string(f, "chan2.db");
		} else
                        ci->email = NULL;
		
                if (ci->mlock_key) {
                    ci->mlock_key = read_string(f, "chan2.db");
                } else
                    ci->mlock_key = NULL;

                if (ci->last_topic) {
                    ci->last_topic = read_string(f, "chan2.db");
                } else
                    ci->last_topic = NULL;

		if (ci->welcome)
		    ci->welcome = read_string(f, "chan2.db");
                if (ci->hold)
                    ci->hold = read_string(f, "chan2.db");
                if (ci->mark)
                    ci->mark = read_string(f, "chan2.db");
                if (ci->freeze)
                    ci->freeze = read_string(f, "chan2.db");
                if (ci->forbid)
                    ci->forbid = read_string(f, "chan2.db");

                if (ci->successor) {
                    ci->successor = read_string(f, "chan2.db");
		} else
		    ci->successor = NULL;

		if (ci->mlock_link)
                    ci->mlock_link = read_string(f, "chan2.db");
		else
		    ci->mlock_link = NULL;

       		if (ci->mlock_flood)
                    ci->mlock_flood = read_string(f, "chan2.db");
		else
		    ci->mlock_flood = NULL;

       		if (ci->bot)
                    ci->bot = read_string(f, "chan2.db");
		else
		    ci->bot = NULL;

                if (ci->accesscount) {
                    ChanAccess *access1;
                    access1 = smalloc(sizeof(ChanAccess) * ci->accesscount);
                    ci->access = access1;
                    if (ci->accesscount != fread(access1, sizeof(ChanAccess),
                                                        ci->accesscount, f))
                        fatal_perror("Read error on ", "chan2.db");
                    for (j = 0; j < ci->accesscount; ++j, ++access1) {
                        access1->name = read_string(f, "chan2.db");
			if (access1->adder)
                        access1->adder = read_string(f, "chan2.db");
		    }
                    j = 0; access1 = ci->access;
                    /* Clear out unused entries */
                    while (j < ci->accesscount) {
                        if (access1->is_nick < 0
			|| (access1->is_nick == 0 && !findnick(access1->name)))
			{

                            --ci->accesscount;
                            free(access1->name);
			    if(access1->adder)
                            free(access1->adder);
                            if (j < ci->accesscount)
				memmove(access1, access1+1, sizeof(*access1) * (ci->accesscount - j));
                        } else {
                            access1->is_nick = 1;
                            ++j; ++access1;
                        }
                    }
                    if (ci->accesscount) {
                        ci->access = srealloc(ci->access, sizeof(ChanAccess) * ci->accesscount);
                    } else {
                        ci->access = NULL;
                        free(ci->access);
                    }
                } else {
                        ci->access = NULL;
                        free(ci->access);
		} /* if (ci->accesscount) */

                if (ci->akickcount) {
                    AutoKick *akick;
                    akick = smalloc(sizeof(AutoKick) * ci->akickcount);
                    ci->akick = akick;
                    if (ci->akickcount !=
                            fread(akick, sizeof(AutoKick), ci->akickcount, f))
                        fatal_perror("Read error on %s", "chan2.db");
                    for (j = 0; j < ci->akickcount; ++j, ++akick) {
                        akick->name = read_string(f, "chan2.db");
                        if (akick->reason)
                            akick->reason = read_string(f, "chan2.db");
                    }
                    j = 0; akick = ci->akick;
                    while (j < ci->akickcount) {
                        if (akick->is_nick < 0) {
                            --ci->akickcount;
                            free(akick->name);
                            if (akick->reason)
                                free(akick->reason);
                            if (j < ci->akickcount)
				memmove(akick, akick+1, sizeof(*akick) * (ci->akickcount - j));
                        } else {
                            ++j; ++akick;
                        }
                    }
                    if (ci->akickcount) {
                        ci->akick = srealloc(ci->akick,
                                        sizeof(AutoKick) * ci->akickcount);
                    } else {
                        free(ci->akick);
                        ci->akick = NULL;
                    }
                } /* if (ci->akickcount) */
                if (ci->levels) {
                    int n_entries;
                    ci->levels = NULL;
                    reset_levels(ci);
                    n_entries = fgetc(f)<<8 | fgetc(f);
                    if (n_entries < 0)
                        fatal_perror("Read error on %s", "chan2.db");
                    /* Ignore earlier, incompatible levels list */
                    if (n_entries == 6) {
                        fseek(f, sizeof(short) * n_entries, SEEK_CUR);
                    } else
                    if (n_entries <= CA_SIZE) {
                        fread(ci->levels, sizeof(short), n_entries, f);
                    } else {
                        fread(ci->levels, sizeof(short), CA_SIZE, f);
                        fseek(f, sizeof(short) * (n_entries - CA_SIZE),
                                                                SEEK_CUR);
                    }
                } else {
                    reset_levels(ci);
                }

                if (ci->newsline) {
                    char **channews;
                    channews = smalloc(sizeof(char *) * ci->newsline);
                    ci->news = channews;
                    for (j = 0; j < ci->newsline; ++j, ++channews) {
                        *channews = read_string(f, "chan2.db");
                    }
                } else {
			 ci->news = NULL;
		    }

                if (ci->badwline) {
                    char **badwords;
                    badwords = smalloc(sizeof(char *) * ci->badwline);
                    ci->badwords = badwords;
                    for (j = 0; j < ci->badwline; ++j, ++badwords) {
                        *badwords = read_string(f, "chan2.db");
                    }
                } else {
			ci->badwords = NULL;
                }


            } /* while (fgetc(f) == 1) */

        } /* for (i) */
	break;
      default:
	fatal("Unsupported version number (%d) on %s", ver, "chan2.db");

    } /* switch (version) */

    close_db(f, "chan2.db");
}
#endif
/*************************************************************************/
void save_cs_dbase(void)
{
    FILE *f;
    int i, j;
    ChannelInfo *ci;

    if (!(f = open_db(s_ChanServ, CHANSERV_DB, "w", CS_VERSION)))
	return;

    for (i = 33; i < 256; ++i) {
	for (ci = chanlists[i]; ci; ci = ci->next) {
	    fputc(1, f);
	    if (1 != fwrite(ci, sizeof(ChannelInfo), 1, f))
		fatal_perror("Write error on %s", CHANSERV_DB);
	    write_string(ci->desc ? ci->desc : "", f, CHANSERV_DB);
	    if (ci->url)
		write_string(ci->url, f, CHANSERV_DB);
	    if (ci->email)
		write_string(ci->email, f, CHANSERV_DB);
	    if (ci->mlock_key)
		write_string(ci->mlock_key, f, CHANSERV_DB);
	    if (ci->last_topic)
		write_string(ci->last_topic, f, CHANSERV_DB);
	    if (ci->welcome)
		write_string(ci->welcome, f, CHANSERV_DB);
            if (ci->hold)
                write_string(ci->hold, f, CHANSERV_DB);
            if (ci->mark)
                write_string(ci->mark, f, CHANSERV_DB);
            if (ci->freeze)
                write_string(ci->freeze, f, CHANSERV_DB);
            if (ci->forbid)
                write_string(ci->forbid, f, CHANSERV_DB);
            if (ci->successor)
                write_string(ci->successor, f, CHANSERV_DB);
            if (ci->mlock_link)
                write_string(ci->mlock_link, f, CHANSERV_DB);
            if (ci->mlock_flood)
                write_string(ci->mlock_flood, f, CHANSERV_DB);

            if (ci->bot)
                write_string(ci->bot, f, CHANSERV_DB);

            if (ci->markreason)
                write_string(ci->markreason, f, CHANSERV_DB);

            if (ci->freezereason)
                write_string(ci->freezereason, f, CHANSERV_DB);

            if (ci->holdreason)
                write_string(ci->holdreason, f, CHANSERV_DB);

            if (ci->lastgetpass)
                write_string(ci->lastgetpass, f, CHANSERV_DB);

	    if (ci->accesscount) {
		ChanAccess *access1 = ci->access;
		if (ci->accesscount !=
			fwrite(access1, sizeof(ChanAccess), ci->accesscount, f))
		    fatal_perror("Write error on %s", CHANSERV_DB);
		for (j = 0; j < ci->accesscount; ++j, ++access1) {
		    if (access1->in_use) {
			write_string(access1->name, f, CHANSERV_DB);
			if (access1->adder)
				write_string(access1->adder, f, CHANSERV_DB);
		    } else {
			write_string("", f, CHANSERV_DB);
			if (access1->adder)
				write_string("", f, CHANSERV_DB);
		    }
		}
	    }

	    if (ci->akickcount) {
		AutoKick *akick = ci->akick;
		if (ci->akickcount !=
			fwrite(akick, sizeof(AutoKick), ci->akickcount, f))
		    fatal_perror("Write error on %s", CHANSERV_DB);
		for (j = 0; j < ci->akickcount; ++j, ++akick) {
		    if (akick->is_nick >= 0) {
			write_string(akick->name, f, CHANSERV_DB);
			if (akick->reason)
			    write_string(akick->reason, f, CHANSERV_DB);
		    } else {
			write_string("", f, CHANSERV_DB);
			if (akick->reason)
	  		    write_string("", f, CHANSERV_DB);
		    }
		}
	    }

	    if (ci->levels) {
		fputc(CA_SIZE >> 8, f);
		fputc(CA_SIZE & 0xFF, f);
		fwrite(ci->levels, sizeof(short), CA_SIZE, f);
	    }

	  if (ci->newsline) {
	  char **channews;
          for (channews = ci->news, j = 0; j < ci->newsline; ++channews, ++j)
                     write_string(*channews, f, CHANSERV_DB);
	  }
	  if (ci->badwline) {
	  char **badwords;
          for (badwords = ci->badwords, j = 0; j < ci->badwline; ++badwords, ++j)
                     write_string(*badwords, f, CHANSERV_DB);
          }  
	} /* for (chanlists[i]) */

	fputc(0, f);

    } /* for (i) */

    close_db(f, CHANSERV_DB);
}

/*************************************************************************/

/* Check the current modes on a channel; if they conflict with a mode lock,
 * fix them. */

void check_modes(const char *chan, const char *source)
{
    Channel *c = findchan(chan);
    ChannelInfo *ci = cs_findchan(chan);
    char new_on[MODEMAX], new_off[MODEMAX];
    char buf[64];
    *buf = 0;
    *new_on = 0;
    *new_off = 0;

    if (!c || !ci)
	return;

    if (c->bouncy_modes)
	return;

    if ((ci->flags & CI_FREEZECHAN) || (ci->flags & CI_CLOSED))
        return;

    if (c->server_modecount >= 5 && c->chanserv_modecount >= 5) {
       	wallops(NULL, "Warning: unable to set modes on channel %s.  "
               "Is servers %s U:lines configured correctly?", chan, source);
        log("%s: Bouncy modes on channel %s", s_ChanServ, c->name);
       	c->bouncy_modes = 1;
        return;
    }

    if (c->chanserv_modetime != CTime) {
        c->chanserv_modecount = 0;
        c->chanserv_modetime = CTime;
    }
    c->chanserv_modecount++;

#ifdef BAHAMUT
    filter_modes (c->name, ci->mlock_on, ci->mlock_off);
#else

    strscpy(new_on, strlen(ci->mlock_on) ? changemode(ci->mlock_on, c->modes) : "", sizeof(new_on));
    strscpy(new_off, strlen(ci->mlock_off) ? ci->mlock_off : "",sizeof(new_off));

    if (ci->mlock_limit && c->limit != ci->mlock_limit)
    {
        change_cmode (s_ChanServ, c->name, "-l", "");
	change_cmode (s_ChanServ, c->name, "+l", myitoa(ci->mlock_limit));
    }

    if (c->limit && hasmode("l", ci->mlock_off))
    {
        change_cmode (s_ChanServ, c->name, "-l", "");
	c->limit = 0;
    }


    if (ci->mlock_key && (!c->key || strcmp(c->key, ci->mlock_key)!=0))
    {
	if (c->key)
	        change_cmode (s_ChanServ, c->name, "-k", c->key);
        change_cmode (s_ChanServ, c->name, "+k", ci->mlock_key);
	if (c->key)
		free(c->key);
	c->key = sstrdup (ci->mlock_key);

    }

    if (c->key && hasmode("k", ci->mlock_off))
    {
        change_cmode (s_ChanServ, c->name, "-k", c->key);
        free (c->key);
        c->key = NULL;
    }

#ifdef UNREAL

    if (ci->mlock_link && stricmp(c->link, ci->mlock_link))
    {
        change_cmode (s_ChanServ, c->name, "+L", ci->mlock_link);

	free(c->link);
	c->link = sstrdup (ci->mlock_link);
    }

    if (c->link && hasmode("L", ci->mlock_off))
    {
        change_cmode (s_ChanServ, c->name, "-L", "");
        free (c->link);
        c->link = NULL;
    }

    if (ci->mlock_flood && stricmp(c->flood, ci->mlock_flood))
    {
        change_cmode (s_ChanServ, c->name, "+f", ci->mlock_flood);
	free(c->flood);
	c->flood = sstrdup (ci->mlock_flood);
    }

   if (c->flood && hasmode("f", ci->mlock_off))
    {
        change_cmode (s_ChanServ, c->name, "-f", "");
        free (c->flood);
        c->flood = NULL;
    }

#endif


    if (strlen(new_off) + strlen(new_on)) {
        strscpy(new_on, changemode("-lk", new_on), sizeof(new_on));
        strscpy(new_off, changemode("-lk", new_off), sizeof(new_off));
#ifdef UNREAL
        strscpy(new_on, changemode("-Lf", new_on), sizeof(new_on));
        strscpy(new_off, changemode("-Lf", new_off), sizeof(new_off));
#endif
	*buf = 0;
        snprintf (buf, sizeof (buf), "%s%s%s%s",
                strlen(new_on) ? "+" : "",
                strlen(new_on) ? new_on : "",
                strlen(new_off) ? "-" : "",
                strlen(new_off) ? new_off : "");
	        change_cmode (s_ChanServ, c->name, buf, "");
    }

#endif /* BAHAMUT */
}

/*************************************************************************/

/* Check whether a user is allowed to be opped on a channel; if they
 * aren't, deop them.  If serverop is 1, the +o was done by a server.
 * Return 1 if the user is allowed to be opped, 0 otherwise. */

int check_valid_op(User *user, const char *chan, int serverop)
{
    ChannelInfo *ci = cs_findchan(chan);
    Channel *c = findchan(chan);
    NickInfo *ni;

    ni = findnick(user->nick);
    
    if (!ci && is_oper_cando(user->nick, 5))
	return 1;

    if (!ci || !c)
      return 1;


    if (!ni || (ni && !(ni->flags & NI_NEVEROP))) {
	    if ((c->usercount == 1) && ci->flags & CI_LEAVEOPS)
        	   return 1;
    }

    if (is_services_root(user->nick))
 	return 1;

    if (ci->flags & (CI_VERBOTEN | CI_CLOSED))
	return 0;
	/* check_kick() will get them out; we needn't explain. */

    if (ci->flags & CI_FREEZECHAN)
        return 0;

    if (ni && (ni->flags & NI_NEVEROP))
	return 0;

    if ((!check_access(user, ci, CA_AUTOOP)) 
	&& (!(ci->flags & CI_OPGUARD)) && !(c->usercount == 1))
		return 1;

    if (ci->flags & CI_OPGUARD || (c->usercount == 1)) {
         if (!newcheck_opguard(ci, user, chan, c->usercount == 1))
            return 0;
         else
            return 1;
    }

    if (check_access(user, ci, CA_AUTODEOP))
	return 0;

    return 1;
}
#ifdef DEFHALFOP
int check_valid_hop(User *user, const char *chan, int serverop)
{
    ChannelInfo *ci = cs_findchan(chan);
    Channel *c = findchan(chan);
    NickInfo *ni;

    ni = findnick(user->nick);
    
    if (!ci || !c)
      return 1;

    if (is_oper_cando(user->nick, 5))
	return 1;

    if (!ni || (ni && (ni->flags & NI_NEVEROP))) {
	    if (ci->flags & CI_LEAVEOPS)
        	   return 1;
    }

    if (is_services_root(user->nick))
 	return 1;

    if (ci->flags & (CI_VERBOTEN | CI_CLOSED))
	return 0;
	/* check_kick() will get them out; we needn't explain. */

    if (ci->flags & CI_FREEZECHAN)
        return 0;

    if (ni && (ni->flags & NI_NEVEROP))
	return 0;

    if ((!check_access(user, ci, CA_AUTOHOP)) &&
           (!(ci->botflag & CBI_HOPGUARD)) && !serverop)
       return 1;

    if (ci->botflag & CBI_HOPGUARD) {
         if (!check_hopguard(user, chan, 0))
            return 0;
         else
            return 1;
    }
    if (check_access(user, ci, CA_AUTODEOP))
	return 0;
    return 1;
}
#endif
/*************************************************************************/
void check_welcome(User *user, const char *chan)
{
    ChannelInfo *ci = cs_findchan(chan);
    NickInfo *ni = findnick(user->nick);
    char **channews;
    int i;

    if (!ci)
	return;

    if ((ci->flags & CI_FREEZECHAN) || (ci->flags & CI_CLOSED))
	return;

    for (channews = ci->news, i = 0; i < ci->newsline; ++channews, ++i) {
	if (ci->botflag & CBI_NORMALMSG) {
		send_cmd(SERVER_NAME, "304 %s :%s %s", user->nick, ci->name,*channews);
	} else
	if (ci->bot)
            notice(ci->bot, user->nick, "%s: %s", chan, *channews);
	else
            notice(s_ChanServ, user->nick, "%s: %s", chan, *channews);  
    }

    if (ci->welcome) {
	if (ci->botflag & CBI_NORMALMSG) {
		send_cmd(SERVER_NAME, "304 %s :%s \2Welcome\2:%s", user->nick, ci->name, ci->welcome);
	} else
	if (ci->bot)
	        notice(ci->bot, user->nick, "(\2%s\2): %s",chan, ci->welcome);
	else
	        notice(s_ChanServ, user->nick, "(\2%s\2): %s",chan, ci->welcome);
    }

    if (ci->url)
	send_cmd(SERVER_NAME, "304 %s :%s %s", user->nick, ci->name, ci->url);

    if (!ni)
	return;

    if (ci->botflag & CBI_GREET)
	if (get_access(user, ci) >= 2) 
	if (ni->info && (ni->flags & NI_IDENTIFIED)) {
	if (ci->bot)
		send_cmd(ci->bot, "PRIVMSG %s :\2[\2 %s \2]\2  %s", chan, ni->nick, ni->info);
	else
		send_cmd(s_ChanServ, "PRIVMSG %s :\2[\2 %s \2]\2  %s", chan, ni->nick, ni->info);
	}

#ifdef GAMES
    if (ci->botflag & CBI_GUESSWRD) {
	notice(s_ChanServ, user->nick, "%s: !Gword <word or char> to play wordgame in this channel", chan);
    }
    if (ci->botflag & CBI_GUESSNUM) {
	notice(s_ChanServ, user->nick, "%s: !GNum <number> to play number in this channel", chan);
    }
#endif

}
/*************************************************************************/
/* Check whether a user should be opped on a channel, and if so, do it.
 * Return 1 if the user was opped, 0 otherwise.  (Updates the channel's
 * last used time if the user was opped.) */

void checkmassop(User *user, const char *chan) {
    ChannelInfo *ci = cs_findchan(chan);
    NickInfo *ni;
    char *av[3];
    int acc, toop=0, tovoi=0, toha=0, topro=0, tofd=0;
    ni = findnick(user->nick);

    if (!ci || (ci->flags & CI_CLOSED) || (ci->flags & CI_VERBOTEN) || !ci->levels[CA_AUTOOP] || *chan == '+')
	return;

    if (ni && (ni->flags & NI_NEVEROP)) 
	return;

    if (ci && ci->flags & CI_FREEZECHAN)
        return;

    acc = get_access(user, ci);

if ((acc > 0) || (ci->flags & CI_AUTOVOP) || (ci->flags & CI_AUTOHOP) || (ci->flags & CI_AUTOOP)) {
    av[0] = sstrdup(chan);
    av[2] = sstrdup(user->nick);
#ifdef UNREAL
    if (acc == 15) {
	tofd = 1;
	av[1] = sstrdup("+q");
	do_cmode(s_ChanServ, 3, av);
	free(av[1]);
    }
#endif
    if (acc > 9) {
	topro = 1;
	av[1] = sstrdup("+a");
	do_cmode(s_ChanServ, 3, av);
	free(av[1]);
    }
    if ((acc > 4) || (ci->flags & CI_AUTOOP)) {
	toop = 1;
	av[1] = sstrdup("+o");
	do_cmode(s_ChanServ, 3, av);
	free(av[1]);
        ci->last_used = CTime;
#ifdef UNREAL
    } else if ((acc == 4) || (ci->flags & CI_AUTOHOP)) {
	toha = 1;
	av[1] = sstrdup("+h");
	do_cmode(s_ChanServ, 3, av);
	free(av[1]);
#endif
    } else if ((acc == 3) || (ci->flags & CI_AUTOVOP)) {
	tovoi = 1;
	av[1] = sstrdup("+v");
	do_cmode(s_ChanServ, 3, av);
	free(av[1]);
    }
    free(av[0]);
    free(av[2]);
if (tovoi || toha || toop || topro || tofd) {
#ifndef NONSUPER
    if ((ci->mark) && is_tokn(9) && (ci->hold))
           send_cmd(s_ServicesX, "MODE %s +%s%s%s%s%s %s%s%s%s%s%s%s%s%s", chan,
	   tofd?"q":"", topro?"a":"", toop?"o":"", toha?"h":"", tovoi?"v":"",
	   tofd?user->nick:"",topro?" ":"", topro?user->nick:"", 
	   toop?" ":"", toop?user->nick:"", toha?" ":"", toha?user->nick:"",
	   tovoi?" ":"", tovoi?user->nick:"");
    else
#endif
	   send_cmd(MODE_SENDER, "MODE %s +%s%s%s%s%s %s%s%s%s%s%s%s%s%s", chan,
	   tofd?"q":"", topro?"a":"", toop?"o":"", toha?"h":"", tovoi?"v":"",
	   tofd?user->nick:"",topro?" ":"", topro?user->nick:"", 
	   toop?" ":"", toop?user->nick:"", toha?" ":"", toha?user->nick:"",
	   tovoi?" ":"", tovoi?user->nick:"");
} /* acc > 0 */
}
}

static void cimassop(User *user, ChannelInfo *ci, NickInfo *ni, Channel *c) {
    char *av[3];
    int acc, toop=0, tovoi=0, toha=0, topro=0, tofd=0;

    if (!ci || (ci->flags & CI_CLOSED) || (ci->flags & CI_VERBOTEN) || !ci->levels[CA_AUTOOP])
	return;

    if (ni->flags & NI_NEVEROP)
	return;

    if (ci && ci->flags & CI_FREEZECHAN)
        return;

    acc = get_access(user, ci);

if (acc > 0) {
    av[0] = sstrdup(ci->name);
    av[2] = sstrdup(user->nick);
#ifdef UNREAL
    if (acc == 15) {
	if (!has_chan_status(user, c, CSTATUS_OWNER)) {
		tofd = 1;
		av[1] = sstrdup("+q");
		do_cmode(s_ChanServ, 3, av);
		free(av[1]);
	}
    }
#endif
    if (acc > 9) {
	if (!has_chan_status(user, c, CSTATUS_PROTECT)) {
		topro = 1;
		av[1] = sstrdup("+a");
		do_cmode(s_ChanServ, 3, av);
		free(av[1]);
	}
    }
    if (acc > 4) {
	if (!has_chan_status(user, c, CSTATUS_OP)) {
		toop = 1;
		av[1] = sstrdup("+o");
		do_cmode(s_ChanServ, 3, av);
		free(av[1]);
	        ci->last_used = CTime;
	}
#ifdef UNREAL
    } else if (acc == 4) {
	if (!has_chan_status(user, c, CSTATUS_HALFOP)) {
		toha = 1;
		av[1] = sstrdup("+h");
		do_cmode(s_ChanServ, 3, av);
		free(av[1]);
	}
#endif
    } else if (acc == 3) {
	if (!has_chan_status(user, c, CSTATUS_VOICE)) {
		tovoi = 1;
		av[1] = sstrdup("+v");
		do_cmode(s_ChanServ, 3, av);
		free(av[1]);
	}
    }
    free(av[0]);
    free(av[2]);
if (tovoi || toha || toop || topro || tofd) {
#ifndef NONSUPER
    if ((ci->mark) && is_tokn(9) && (ci->hold))
           send_cmd(s_ServicesX, "MODE %s +%s%s%s%s%s %s%s%s%s%s%s%s%s%s", ci->name,
	   tofd?"q":"", topro?"a":"", toop?"o":"", toha?"h":"", tovoi?"v":"",
	   tofd?user->nick:"",topro?" ":"", topro?user->nick:"", 
	   toop?" ":"", toop?user->nick:"", toha?" ":"", toha?user->nick:"",
	   tovoi?" ":"", tovoi?user->nick:"");
    else
#endif
	   send_cmd(MODE_SENDER, "MODE %s +%s%s%s%s%s %s%s%s%s%s%s%s%s%s", ci->name,
	   tofd?"q":"", topro?"a":"", toop?"o":"", toha?"h":"", tovoi?"v":"",
	   tofd?user->nick:"",topro?" ":"", topro?user->nick:"", 
	   toop?" ":"", toop?user->nick:"", toha?" ":"", toha?user->nick:"",
	   tovoi?" ":"", tovoi?user->nick:"");
} /* acc > 0 */
}
}

int check_should_op(User *user, const char *chan)
{
    ChannelInfo *ci = cs_findchan(chan);
    NickInfo *ni;
    ni = findnick(user->nick);
    
    if (is_oper_cando(user->nick, 5)) {
        send_cmd(MODE_SENDER, "MODE %s +o %s", chan, user->nick);
	return 1;
    }

    if (!ci || (ci->flags & CI_CLOSED) || (ci->flags & CI_VERBOTEN) ||  !ci->levels[CA_AUTOOP] ||
		*chan == '+')
	return 0;

    if (ni && (ni->flags & NI_NEVEROP)) 
	return 0;

    if (ci && ci->flags & CI_FREEZECHAN)
        return 0;

    if (ci && !(ci->flags & CI_VERBOTEN) && (ci->flags & CI_AUTOOP)) {
	    if (!is_chanop(user->nick, chan)) {
#ifndef NONSUPER
	    if ((ci->mark) && is_tokn(9) && (ci->hold))
	           send_cmd(s_ServicesX, "MODE %s +o %s", chan, user->nick);
	    else
#endif
	           send_cmd(MODE_SENDER, "MODE %s +o %s", chan, user->nick);
	    }
       ci->last_used = CTime;
	return 1;
    }

    if (ci->flags & CI_IDENT) {
        if (!ni || !(ni->flags & NI_IDENTIFIED))
	    return 0;
   }

   if (check_access(user, ci, CA_AUTOOP)) {
	   if (!is_chanop(user->nick, chan)) {
#ifndef NONSUPER
	   if ((ci->mark) && is_tokn(9) && (ci->hold))
        	   send_cmd(s_ServicesX, "MODE %s +o %s", chan, user->nick);
	    else
#endif
	           send_cmd(MODE_SENDER, "MODE %s +o %s", chan, user->nick);
	   }
	   ci->last_used = CTime;
           return 1;
      }
    
    return 0;
}
/*************************************************************************/
#ifdef UNREAL
int check_should_founderize(User *user, const char *chan)
{
    ChannelInfo *ci = cs_findchan(chan);
    NickInfo *ni;
    ni = findnick(user->nick);

    if (!ci || (ci->flags & CI_CLOSED) || (ci->flags & CI_VERBOTEN))
	return 0;

    if (ni && (ni->flags & NI_NEVEROP)) 
	return 0;

    if (ni) {
	    if (!ci || (ci->flags & CI_VERBOTEN) || *chan == '+')
        	return 0;
#ifdef UNREAL     
	    if (is_founder(user, ni, ci, 0) && !(is_cfounder(user->nick,chan))) {
#ifndef NONSUPER
	    if ((ci->mark) && is_tokn(9) && (ci->hold))
	           send_cmd(s_ServicesX, "MODE %s +q %s", chan, user->nick);
	    else
#endif
	           send_cmd(MODE_SENDER, "MODE %s +q %s", chan, user->nick);
	        return 1;
	    } 
#endif
    }
    return 0;
}
#endif
/*************************************************************************/
#ifdef DEFPROTECT
int check_should_protect(User *user, const char *chan)
{
    ChannelInfo *ci = cs_findchan(chan);
    NickInfo *ni;
    int acc=0;
    ni = findnick(user->nick);

    if (!ci || (ci->flags & CI_CLOSED) || (ci->flags & CI_VERBOTEN) || *chan == '+')
        return 0;

    if (ni && (ni->flags & NI_NEVEROP))
	return 0;

    acc = get_access(user, ci);

    if (acc > 9) {
#ifndef NONSUPER
	    if ((ci->mark) && is_tokn(9) && (ci->hold))
#if defined(LIQUID)
	           send_cmd(s_ServicesX, "MODE %s +u %s", chan, user->nick);
#else
	           send_cmd(s_ServicesX, "MODE %s +a %s", chan, user->nick);
#endif
	    else
#endif /* NON Super */
#if defined(LIQUID)
	           send_cmd(MODE_SENDER, "MODE %s +u %s", chan, user->nick);
#else
	           send_cmd(MODE_SENDER, "MODE %s +a %s", chan, user->nick);
#endif
        return 1;
    }

    return 0;
}
#endif
/*************************************************************************/
/* Check whether a user should be voiced on a channel, and if so, do it.
 * Return 1 if the user was voiced, 0 otherwise. */

int check_should_voice(User *user, const char *chan)
{
    ChannelInfo *ci = cs_findchan(chan);
    NickInfo *ni;

    if (!ci || (ci->flags & CI_CLOSED) || (ci->flags & CI_VERBOTEN) || !ci->levels[CA_AUTOVOICE] ||
		*chan == '+')
	return 0;

    if (ci && (ci->flags & CI_AUTOVOP) && !(ci->flags & CI_VERBOTEN)) {
        send_cmd(MODE_SENDER, "MODE %s +v %s", chan, user->nick);
        return 1;
    }

    if (ci && ci->flags & CI_FREEZECHAN)
        return 0;

    ni = findnick(user->nick);

    if (ci->flags & CI_IDENT) {
        if (ni && !(ni->flags & NI_IDENTIFIED))
	    return 0;
    }

    if (ni && (ni->flags & NI_NEVEROP))
         return 0;

    if (get_access(user, ci) == 3) {
        send_cmd(MODE_SENDER, "MODE %s +v %s", chan, user->nick);
        return 1;
    }
    return 0;
}

/*************************************************************************/

/* Check whether a user should be halfop on a channel, and if so, do it.
 * Return 1 if the user was halfop, 0 otherwise. */
#ifdef DEFHALFOP
int check_should_halfop(User *user, const char *chan)
{
    ChannelInfo *ci = cs_findchan(chan);
    NickInfo *ni;
    ni = findnick(user->nick);

    if (!ci || (ci->flags & CI_CLOSED) ||  (ci->flags & CI_VERBOTEN) || !ci->levels[CA_AUTOHOP] ||
		*chan == '+')
	return 0;

    if (ni && (ni->flags & NI_NEVEROP))
         return 0;

    if (ci && ci->flags & CI_FREEZECHAN)
        return 0;

    if (ci && (ci->flags & CI_AUTOHOP) && !(ci->flags & CI_VERBOTEN)) {
        send_cmd(MODE_SENDER, "MODE %s +h %s", chan, user->nick);
        return 1;
    }

    if (ci->flags & CI_IDENT) {
        if (ni && !(ni->flags & NI_IDENTIFIED))
	    return 0;
    }


    if (get_access(user, ci) == 4) {
         send_cmd(MODE_SENDER, "MODE %s +h %s", chan, user->nick);
         return 1;
    }
    return 0;
}

#endif
/*************************************************************************/
/* Tiny helper routine to get ChanServ out of a channel after it went in. */

static void timeout_leave(Timeout *to)
{
    char *chan = to->data;
    send_cmd(s_ChanServ, "PART %s", chan);
    free(to->data);
}


static void timeout_unban(Timeout *to)
{
    char *chan = to->data;
    send_cmd(s_ChanServ, "MODE %s -b *!*@*", chan);
    free(to->data);
}

/* Check whether a user is permitted to be on a channel.  If so, return 0;
 * else, kickban the user with an appropriate message (could be either
 * AKICK or restricted access) and return 1.  Note that this is called
 * _before_ the user is added to internal channel lists (so do_kick() is
 * not called).
 */

int check_kick(User *user, const char *chan)
{
    ChannelInfo *ci;
    C_SuspendData *c_spn = get_c_suspend(chan);
    AutoKick *akick;
    unsigned int i,  isoper = is_oper(user->nick);
    NickInfo *ni;
    char *mask, *reason, *abadchan;
    Timeout *t;
    ci = cs_findchan(chan);

/*  Channel suspension check must come first because if the channel is
 *  not registered, services will not be able to kick because !ci returns 0.
 */


    if (!ci)
	return 0;

    if ((ci->botflag & CBI_BADCHAN) && (abadchan = inbadchannel(user->nick, ci)) && !isoper) {
       mask = create_mask(user);
       reason = "You have join badword channel";
       notice(s_ChanServ, user->nick, "(%s) You have join badword channel %s", ci->name, abadchan);
       goto kick;
    }

    if ((ci->botflag & CBI_BADNICK) && is_badnick(ci, user->nick, user->username, user->realhost, user->realname) && !isoper) {
       mask = create_mask(user);
       reason = "You have bad nick/identify/realname/host";
       goto kick;
    }

    if ((ci->flags & CI_CLOSED) && !isoper){
        mask = create_mask(user);
        reason = toknmsg[22];
        goto kick;
    }

    if ((ci->flags & CI_VERBOTEN) && !isoper) {
		mask = create_mask(user);
		reason = "This channel may not be used.";
		goto kick;
    }

    if ((c_spn && c_spn->time > CTime) && !isoper){
       mask = create_mask(user);
       reason = "Channel has been suspended due to abuse";
       goto kick;
    }

    if ((ci->flags & CI_FREEZECHAN) && !isoper)
        return 0;


    if ((ci->flags & CI_CODERONLY) && !rec_services_coder(user->nick)) {
        mask = create_mask(user);
        reason = "Only Services Masters are allowed to use this channel.";
        send_cmd(s_ChanServ, "MODE %s +A", chan);
        goto kick;
    }

    if ((ci->flags & CI_OPERONLY) && !isoper) {
	mask = create_mask(user);
	reason = "Only IRC Operators are allowed to use this channel.";
        send_cmd(s_ChanServ, "MODE %s +O", chan);
	goto kick;
    }
    if ((ci->flags & CI_SOPONLY) && !rec_services_oper(user->nick)) {
	mask = create_mask(user);
	reason = "Only Services Opers are allowed to use this channel.";
	goto kick;
    }
    if ((ci->flags & CI_SAONLY) && !rec_services_admin(user->nick)) {
	mask = create_mask(user);
	reason = "Only Services Admins are allowed to use this channel.";
        send_cmd(s_ChanServ, "MODE %s +O", chan);
	goto kick;
    }
    if ((ci->flags & CI_SRAONLY) && !rec_services_root(user->nick)) {
	mask = create_mask(user);
	reason = "Only Services Roots are allowed to use this channel.";
	goto kick;
    }

    if ((ci->flags & CI_ABUSEONLY) && !is_oper_cando(user->nick, 7)) {
        mask = create_mask(user);
        reason = "Only Abuse Team Members are allowed to use this channel.";
        goto kick;
    }

    if ((ci->flags & CI_RESTRICTED) && !isoper) {
         if (get_access(user, ci) < 3) {
             mask = create_mask(user);
             reason = "You are not permitted to be on this channel.";
	     goto kick;
         }
    }

    ni = findnick(user->nick);
    if ((ni == NULL) || !(ni->flags & (NI_IDENTIFIED | NI_RECOGNIZED)))
	ni = NULL;

    if ((get_access(user, ci) > 0) || isoper)
        return 0;

    for (akick = ci->akick, i = 0; i < ci->akickcount; ++akick, ++i) {
	if ((akick->is_nick > 0
			&& ni && stricmp(akick->name, user->nick) == 0) ||
			(!akick->is_nick && match_usermask(akick->name, user))
	) {
	    mask = akick->is_nick ? create_mask(user) : akick->name;
	    reason = akick->reason ? akick->reason : DEF_AKICK_REASON;
	    goto kick;
	}
    }

    return 0;

kick:


    if (debug) {
	log("debug: channel: AutoKicking %s!%s@%s",
		user->nick, user->username, user->host);
    }

    /* Remember that the user has not been added to our channel user list
     * yet, so we check whether the channel does not exist */


/* 
   should be fine to leave out timeout_unban since the empty
   channel will remove the mode anyway.
*/

    send_cmd(s_ChanServ, "JOIN %s", chan);
    change_cmode (s_ChanServ, chan, "+b", mask);
    kick_user(s_ChanServ, chan, user->nick, reason);
    t = add_timeout(CHANNEL_INHABIT, timeout_leave, 0);
    t->data = sstrdup(chan);
    return 1;
}

/*************************************************************************/

/* Record the current channel topic in the ChannelInfo structure. */

void record_topic(const char *chan)
{
    Channel *c;
    ChannelInfo *ci;

    if (readonly)
	return;
    c = findchan(chan);
    ci = cs_findchan(chan);
    if (!c || !ci)
	return;
    if (ci->flags & CI_FREEZECHAN)
        return;
    if (ci->last_topic)
		free(ci->last_topic);
    if (c->topic)
		ci->last_topic = sstrdup(c->topic);
    else
	ci->last_topic = NULL;
    strscpy(ci->last_topic_setter, c->topic_setter, NICKMAX);
    ci->last_topic_time = c->topic_time;
}

/*************************************************************************/

/* Restore the topic in a channel when it's created, if we should. */

void restore_topic(const char *chan)
{
    Channel *c = findchan(chan);
    ChannelInfo *ci = cs_findchan(chan);

    if (!c || !ci)
	return;

    if (ci->flags & CI_CLOSED) {
        send_cmd(MODE_SENDER, "TOPIC %s %s %lu :%s", chan,
		s_ChanServ, CTime, toknmsg[22]);
	    if (c->topic)
		free(c->topic);
	    c->topic = sstrdup(toknmsg[22]);
	return;
    }

    if (!(ci->flags & CI_KEEPTOPIC))
       return;

    if (c->topic) {
	if (ci->last_topic) {
		if (!stricmp(c->topic, ci->last_topic))
			return;
	}
    }

    if (c->topic)
	free(c->topic);

    if (ci->last_topic) {
		c->topic = sstrdup(ci->last_topic);
		strscpy(c->topic_setter, ci->last_topic_setter, NICKMAX);
		c->topic_time = ci->last_topic_time;
    } else {
		c->topic = NULL;
		strscpy(c->topic_setter, s_ChanServ, NICKMAX);
    }

    if (c->topic != NULL) {
      if (TOPIC_PROBS == 1)
		send_cmd(MODE_SENDER, "TOPIC %s %s %lu :%s", chan,
		c->topic_setter, c->topic_time, c->topic ? c->topic :"");
      else
       send_cmd(MODE_SENDER, "TOPIC %s %s %lu :%s (%s)", chan,
		c->topic_setter, c->topic_time, c->topic ? c->topic :"",
                ci->last_topic_setter);
    }

}

/*************************************************************************/

/* See if the topic is locked on the given channel, and return 1 (and fix
 * the topic) if so. */

int check_topiclock(const char *source, const char *chan)
{
    Channel *c = findchan(chan);
    ChannelInfo *ci = cs_findchan(chan);
    User *u;
    int ulev;

    if (!c || !ci || (!(ci->flags & CI_TOPICLOCK)))
	return 0;

    if (rec_services_admin(source))
	return 0;

    u = finduser(source);

    // None exist user(server) always override

    if (!u)
	return 0;

    // FREEZE or CLOSE channel no one can change topic

    if (ci->flags & (CI_FREEZECHAN|CI_CLOSED))
	return 1;

    if (ci->topic_allow <= (ulev = get_access(u, ci)))
        return 0;

    if (c->topic) {
	if (ci->last_topic) {
		if (!strcmp(c->topic, ci->last_topic))
			return 0;
	}
	free(c->topic);
    }

	
    if (ci->last_topic) {
	c->topic = sstrdup(ci->last_topic);
    } else {
	c->topic = NULL;
    }

    if (ci->last_topic_setter)
	    strscpy(c->topic_setter, ci->last_topic_setter, NICKMAX);

    c->topic_time = ci->last_topic_time;

#ifdef UNREAL
    send_cmd(MODE_SENDER, "TOPIC %s :%s (%s)", chan, c->topic ? c->topic:"", c->topic_setter);
#else
    send_cmd(MODE_SENDER, "TOPIC %s %s %lu :%s", chan,
		c->topic_setter, c->topic_time, c->topic ? c->topic :"");
#endif

    return 1;
}
/*************************************************************************/
static int isexpire(ChannelInfo *ci, time_t expire_time)
{
	time_t now = CTime;
	NickInfo *ni;

	if (ci->flags & CI_HELDCHAN)
		return 0;

	if (ci->flags & CI_VERBOTEN)
		return 0;

	ni = findnick(ci->founder);

	if (!ni) {
		if (ci->successor) {
			strscpy(ci->founder, ci->successor, NICKMAX);
		        free(ci->successor);
			ci->successor = NULL;
	                slog("CS X %s -> %s", ci->name, ci->founder);
			return 0;
		}
		return 1;
	}

        if (ci->last_used) {
		if ((now - ci->last_used) <= expire_time)
			return 0;
	}

	return 1;
}
/*************************************************************************/

/* Remove all channels which have expired. */

void expire_chans()
{
    ChannelInfo *ci, *next;
    const time_t expire_time = atoi(tokn[25])*24*60*60;
    unsigned int i;
    long count = 0;
    long xcount = 0;

    for (i = 33; i < 256; ++i) {
	for (ci = chanlists[i]; ci; ci = next) {
	    ++count;
	    next = ci->next;    
            if (isexpire(ci, expire_time)) {
			++xcount;
        	        slog("CS X %s", ci->name);
	                do_break_log("CS_X", "CS X %s", ci->name);
			log("Expiring channel %s", ci->name);
			delchan(ci);
	    }
	}
    }
  if(DISPLAY_UPDATES == 1)
     wallops(SERVER_NAME, "Completed Channel Expire (%d/%d)",xcount,count);
}

/*************************************************************************/

/* Remove a (deleted or expired) nickname from all channel access lists. */

void cs_remove_nick(const char *nick)
{
    unsigned int i;
    int j;
    ChannelInfo *ci;
    ChanAccess *ca;

    for (i = 33; i < 256; i++) {
	for (ci = chanlists[i]; ci; ci = ci->next) {
	    for (ca = ci->access, j = ci->accesscount; j > 0; ca++, j--) {
		if (ca->in_use && stricmp(ca->name, nick) == 0)
		    ca->in_use = 0;
	    }
	}
    }
}

/*************************************************************************/
/*********************** ChanServ private routines ***********************/
/*************************************************************************/

/* Return the ChannelInfo structure for the given channel, or NULL if the
 * channel isn't registered. */

ChannelInfo *cs_findchan(const char *chan)
{
    ChannelInfo *ci;
    for (ci = chanlists[tolower(chan[1])]; ci; ci = ci->next) { 
		if (stricmp(ci->name, chan) == 0) {
			return ci;
		}
    }
    return NULL;
}

/*************************************************************************/

/* Insert a channel alphabetically into the database. */

static void alpha_insert_chan(ChannelInfo *ci)
{
    ChannelInfo *ci2, *ci3;
    char *chan = ci->name;
#ifdef MERGE
	if (cs_findchan(chan)) {
		delchan(cs_findchan(chan));
		slog("OVERIDE %s for update", chan);
	}
#endif   

    for (ci3 = NULL, ci2 = chanlists[tolower(chan[1])];
			ci2 && stricmp(ci2->name, chan) < 0;
			ci3 = ci2, ci2 = ci2->next)
	;
    ci->prev = ci3;
    ci->next = ci2;
    if (!ci3) {
	chanlists[tolower(chan[1])] = ci;
    }
    else 
	ci3->next = ci;

    if (ci2)
	ci2->prev = ci;
}

/*************************************************************************/

/* Add a channel to the database.  Returns a pointer to the new ChannelInfo
 * structure if the channel was successfully registered, NULL otherwise.
 * Assumes channel does not already exist. */

static ChannelInfo *makechan(const char *chan)
{
    ChannelInfo *ci;

    ci = scalloc(sizeof(ChannelInfo), 1);
    strscpy(ci->name, chan, CHANMAX);
    ci->time_registered = CTime;
    reset_levels(ci);
    alpha_insert_chan(ci);
    return ci;
}

/*************************************************************************/

/* Remove a channel from the ChanServ database.  Return 1 on success, 0
 * otherwise. */

static int delchan(ChannelInfo *ci)
{
    unsigned int i;
    User *u;
    struct u_chaninfolist *c;

   for (u = userlist; u; u = u->next) {
      for (c = u->founder_chans; c; c = c->next) {
          if (c->chan == ci) {
             if (c->prev)
                c->prev->next = c->next;
             else
                u->founder_chans = c->next;
             if (c->next)
                c->next->prev = c->prev;
             free(c);
             break;
          }
       }
   }
    if (ci->next)
	ci->next->prev = ci->prev;

    if (ci->prev)
	ci->prev->next = ci->next;
    else
	chanlists[tolower(ci->name[1])] = ci->next;

    if (ci->desc)
	free(ci->desc);

    if (ci->newsline) {
        for (i = 0; i < ci->newsline; i++) {
            if (ci->news[i])
            free(ci->news[i]);
        }
    }

    if (ci->news)
	free(ci->news);

    if (ci->badwline) {
        for (i = 0; i < ci->badwline; i++) {
            if (ci->badwords[i])
            free(ci->badwords[i]);
        }
    }

    if (ci->badwords)
	free(ci->badwords);

    if (ci->mlock_key)
	free(ci->mlock_key);

    if (ci->mlock_flood)
	free(ci->mlock_flood);

    if (ci->mlock_link)
	free(ci->mlock_link);

    if (ci->last_topic)
	free(ci->last_topic);

    for (i = 0; i < ci->accesscount; ++i) {
	if (ci->access[i].name) 
		free(ci->access[i].name);
	if (ci->access[i].adder)
		free(ci->access[i].adder);
    }


    if (ci->access)
	free(ci->access);



    if (ci->akickcount) {
    for (i = 0; i < ci->akickcount; ++i) {
	free(ci->akick[i].name);
	if (ci->akick[i].reason)
	    free(ci->akick[i].reason);
    }

    if (ci->akick) {
	free(ci->akick);
    }
    }

    if (ci->levels)
        free(ci->levels);

    if (ci->welcome)
        free(ci->welcome);

    if (ci->hold)
        free(ci->hold);

    if (ci->mark)
        free(ci->mark);

    if (ci->freeze)
        free(ci->freeze);

    if (ci->forbid)
        free(ci->forbid);

    if (ci->successor)
        free(ci->successor);

    if (ci->bot)
        free(ci->bot);

    if (ci->markreason)
        free(ci->markreason);

    if (ci->freezereason)
        free(ci->freezereason);

    if (ci->holdreason)
        free(ci->holdreason);

    if (ci->lastgetpass)
        free(ci->lastgetpass);


    free(ci);
    return 1;

}

/*************************************************************************/

/* Reset defined access level values to their default state. */

static void reset_levels(ChannelInfo *ci)
{
    unsigned int i;

    if (ci->levels)
	free(ci->levels);
    ci->levels = smalloc(CA_SIZE * sizeof(*ci->levels));
    for (i = 0; def_levels[i][0] >= 0; i++)
	ci->levels[def_levels[i][0]] = def_levels[i][1];
}

/*************************************************************************/

/* Does the given user have founder access to the channel? */

static int is_founder(User *user, NickInfo *ni, ChannelInfo *ci, int set)
{
    unsigned int i;

    if (is_identified(user, ci))
	return 1;

    if (set && (ci->flags & CI_UNSECURE)) {
       if (ni && (ni->flags & NI_RECOGNIZED)
              && (stricmp(ni->nick, ci->founder) == 0))
          return 1;
    }

    if (ni && ((ni->flags & NI_RECOGNIZED) && (!(ci->flags & CI_IDENT)))
           && !set && (stricmp(ni->nick, ci->founder) == 0))
         return 1;

    for (i=0; user->id_nicks[i] && i < MAX_IDS; i++) {
       ni = findnick(user->id_nicks[i]);

       if (ni && !set && ((ni->flags & NI_IDENTIFIED) 
	   || ((ni->flags & NI_RECOGNIZED) && (!(ci->flags & CI_IDENT)))) 
	   && (stricmp(ni->nick, ci->founder) == 0)) {
           return 1;
       } else if (ni && set && ((ni->flags & NI_IDENTIFIED)
           || ((ni->flags & NI_RECOGNIZED) && (ci->flags & CI_UNSECURE)))
              && (stricmp(ni->nick, ci->founder) == 0)) {
           return 1;
	}
    }

    return 0;
}
/*************************************************************************/
static int is_successor(User *user, NickInfo *ni, ChannelInfo *ci, int set)
{
    int i;

    ni = findnick(user->nick);
    if (set && (ci->flags & CI_UNSECURE)) {
       if (ni && (ni->flags & NI_RECOGNIZED)
              && (stricmp(ni->nick, ci->successor) == 0))
          return 1;
    }
    
    if (ni && ((ni->flags & NI_RECOGNIZED) && (!(ci->flags & CI_IDENT)))
           && !set && (stricmp(ni->nick, ci->successor) == 0))
         return 1;


    for (i=0; user->id_nicks[i] && i < MAX_IDS; i++) {
       ni = findnick(user->id_nicks[i]);

       if (ni && !set && ((ni->flags & NI_IDENTIFIED)
	   || ((ni->flags & NI_RECOGNIZED) && (!(ci->flags & CI_IDENT)))) 
	   && (stricmp(user->nick, ci->successor) == 0))
           return 1;

       else if (ni && set && ((ni->flags & NI_IDENTIFIED)
           || ((ni->flags & NI_RECOGNIZED) && (ci->flags & CI_UNSECURE)))
              && (stricmp(user->nick, ci->successor) == 0))
           return 1;
    }

    return 0;
}
/*************************************************************************/

/* Has the given user password-identified as founder for the channel? */

static int is_identified(User *user, ChannelInfo *ci)
{
    struct u_chaninfolist *c;

    for (c = user->founder_chans; c; c = c->next) {
	if (c->chan == ci)
	    return 1;
    }
    return 0;
}
/*************************************************************************/
int is_relatenick(NickInfo *ni, const char *nick) {
	NickInfo *hni;
	NickInfo *hni1;

	if (!nick)
		return 0;

	if (!ni)
		return 0;

	if (stricmp(ni->nick, nick)==0)
		return 1;

	hni1 =  nickhost(ni);

	if (hni1 && (stricmp(hni1->nick, nick) == 0))
		return 1;

	hni = nickhost(findnick(nick));

	if (!hni)
		return 0;

	if (!stricmp(hni->nick, ni->nick))
		return 1;

	if (!stricmp(hni->nick, hni1->nick))
		return 1;

	return 0;
}
/*************************************************************************/

/* Return the access level the given user has on the channel.  If the
 * channel doesn't exist, the user isn't on the access list, or the channel
 * is CS_IDENT and the user hasn't IDENTIFY'd with NickServ, return 0. */

int get_access(User *user, ChannelInfo *ci)
{
    NickInfo *ni, *ni2;
    ChanAccess *access1;
    char **naccess;
    int i, i2, a=0, k=0;

    if (!ci)
        return 0;

    if (!user)
	return 0;

    ni = findnick(user->nick);

    for (access1 = ci->access, i2 = 0; i2 < ci->accesscount; ++access1, ++i2) {
       if (ni && ((ni->flags & NI_RECOGNIZED) && (!(ci->flags & CI_IDENT)))
             && (!(ni->flags & NI_IDENTIFIED))
             && is_relatenick(ni, access1->name)) {
	        if (isvalidzone(access1->accflag))
                if (access1->level > a)
                    a = access1->level;
                if (access1->level < 0)
                    k = access1->level;
       } else if (!(ci->flags & CI_IDENT)) {
           if (match_usermask(access1->name, user)) {
	       if (isvalidzone(access1->accflag))
               if (access1->level > a)
                  a = access1->level;
               if (access1->level < k)
                  k = access1->level;
           } else {
               ni2 = findnick(access1->name);
               if (ni2) {
                   for (naccess = ni2->access, i = 0; i < ni2->accesscount; ++naccess, ++i) {
                      if (is_on_access(user, ni2)) {
		       if (isvalidzone(access1->accflag))
                          if (access1->level > a)
                               a = access1->level;
                      }
                   }
               }
           }
       }
    }

    if (ci->successor)
	    if (is_successor(user, ni, ci, 0))
		return 14;

    if (is_founder(user, ni, ci, 0))
        return 15;

    for (i=0; i < MAX_IDS && user->id_nicks[i]; i++) {
      ni = findnick(user->id_nicks[i]);
	if (ni)
	for (access1 = ci->access, i2 = 0; i2 < ci->accesscount; ++access1, ++i2) {
              if (is_relatenick(ni, access1->name)) {
	       if (isvalidzone(access1->accflag))
                   if (access1->level > a)
                       a = access1->level;
                   if (access1->level < 0)
                       k = access1->level;
              }
       }
    } /* For i = 0 */

  if (a > 0) {
     return a;
  } else if ((a <= 0) && (k < 0)) {
     return k;
  } else {
     return 0;
  }
}
/*************************************************************************/
char *who_access(User *user, ChannelInfo *ci)
{
    NickInfo *ni, *ni2;
    ChanAccess *access1;
    char **naccess;
    int i, i2;

    if (!ci)
        return 0;
    ni = findnick(user->nick);

    if (is_founder(user, ni, ci, 0)) {
        return user->nick;
    }

    if (ci->successor)
	    if (is_successor(user, ni, ci, 0))
		return user->nick;

    for (access1 = ci->access, i2 = 0; i2 < ci->accesscount; ++access1, ++i2) {
       if (ni && ((ni->flags & NI_RECOGNIZED) && (!(ci->flags & CI_IDENT)))
             && (!(ni->flags & NI_IDENTIFIED))
             && (stricmp(ni->nick, access1->name) == 0)) {
                if (access1->level > 0)
			return access1->name;

       } else if (!(ci->flags & CI_IDENT)) {
           if (match_usermask(access1->name, user)) {
               if (access1->level > 0)
			return access1->name;
           } else {
               ni2 = findnick(access1->name);
               if (ni2) {
                   for (naccess = ni2->access, i = 0; i < ni2->accesscount; ++naccess, ++i) {
                      if (is_on_access(user, ni2)) {
                          if (access1->level > 0)
				return access1->name;
                      }
                   }
               }
           }
       }
    }

    for (i=0; i < MAX_IDS && user->id_nicks[i]; i++) {
      for (access1 = ci->access, i2 = 0; i2 < ci->accesscount; ++access1, ++i2) {
          ni = findnick(user->id_nicks[i]);
          if (ni && (ni->flags & NI_IDENTIFIED)
              && stricmp(ni->nick, access1->name) == 0) {
                   if (access1->level > 0)
			return access1->name;
          }
       }
    }

     return NULL;
}


/*************************************************************************/

/* Return 1 if the user's access level on the given channel falls into the
 * given category, 0 otherwise.  Note that this may seem slightly confusing
 * in some cases: for example, check_access(..., CA_NOJOIN) returns true if
 * the user does _not_ have access to the channel (i.e. matches the NOJOIN
 * criterion). */

int check_access(User *user, ChannelInfo *ci, int what)
{
    int level = get_access(user, ci);

    if (level == 15)
	return (what==CA_AUTODEOP || what==CA_NOJOIN) ? 0 : 1;
    if (ci->levels[what] == ACCESS_INVALID)
	return 0;
    if (what == CA_AUTODEOP || what == CA_NOJOIN)
	return level <= ci->levels[what];
    else
	return level >= ci->levels[what];
}

/*************************************************************************/
/*********************** ChanServ command routines ***********************/
/*************************************************************************/

static void do_ohelp(const char *source)
{
    const char *cmd = strtok(NULL, "");
    char buf[256];

    snprintf(buf, sizeof(buf), "%s%s", s_ChanServ, cmd ? " oper " :  " oper");
    strscpy(buf+strlen(buf), cmd ? cmd : "", sizeof(buf)-strlen(buf));
    helpserv(s_ChanServ, source, buf);
    if (!cmd)
        slog("CS - %s requested ohelp: (index)", source);

    if (cmd)
        slog("CS - %s requested ohelp: %s",
              source, cmd);
}

static void do_help(const char *source)
{
    const char *cmd = strtok(NULL, "");
    char buf[256];

    snprintf(buf, sizeof(buf), "%s%s", s_ChanServ, cmd ? " " : "");
    strscpy(buf+strlen(buf), cmd ? cmd : "", sizeof(buf)-strlen(buf));
    helpserv(s_ChanServ, source, buf);
    if (!cmd || (cmd && stricmp(cmd, "REGISTER") == 0))
        notice(s_ChanServ, source,
           "Channels will expire after \2%d days\2 of inactivity",
            atoi(tokn[25]));

}

/*************************************************************************/

void do_csregister(const char *source) {
	do_register(source);
}
static void do_register(const char *source)
{
    char *chan = strtok(NULL, " ");
    char *pass = strtok(NULL, " ");
    char *desc = strtok(NULL, "");
    NickInfo *ni = findnick(source), *hni = nickhost(ni);
    ChannelInfo *ci;
    User *u = finduser(source);
    struct u_chaninfolist *c;
    int x=0;

    if (readonly) {
	notice(s_ChanServ, source,
		"Sorry, channel registration is temporarily disabled.");
	return;
    }

    if (is_tokn(46)) {
	if (!is_oper(source)) {
		notice(s_ChanServ, source,
		"Sorry, channel registration is allow for IRCop only.");
		return;
	}
    }

    if (!chan || !desc) {

	notice(s_ChanServ, source,
                "Syntax: \2REGISTER\2 <#channel> <password> <description>");
	notice(s_ChanServ, source,
		"\2/msg %s HELP REGISTER\2 for more information.", s_ChanServ);
        return;

    } 

    if (*chan == '&') {

	notice(s_ChanServ, source, "Local channels cannot be registered.");
	return;

    }
    if (chan[1] == 0) {

	notice(s_ChanServ, source, "\2%s\2 is not a valid channel name.", chan);
	return;

    } 
    ci = cs_findchan(chan);
    if (!ni || !hni) {

	notice(s_ChanServ, source, "Your must register your nickname first.");
	notice(s_ChanServ, source,
		"\2/msg %s HELP\2 for information on registering nicknames.",
		s_NickServ);

    } else if (!(ni->flags & (NI_RECOGNIZED | NI_IDENTIFIED))) {

	notice(s_ChanServ, source,
		"Please identify with %s first, using the command:",
		s_NickServ);
	notice(s_ChanServ, source,
		"/msg %s IDENTIFY \37password\37", s_NickServ);

    } else if (ci) {

	if (ci->flags & CI_VERBOTEN) {
            slog("CS *R %s (%s!%s@%s) [FORBIDDEN]",
                chan, source, u->username, u->host);
            do_break_log("CS_R", "CS *R %s (%s!%s@%s) [FORBIDDEN]",
                chan, source, u->username, u->host);
	    log("%s: Attempt to register FORBIDden channel %s by %s!%s@%s",
			s_ChanServ, chan, source, u->username, u->host);
	    notice(s_ChanServ, source,
			"Channel \2%s\2 may not be registered.", chan);
	} else {
	    notice(s_ChanServ, source,
			"Channel \2%s\2 already registered!", chan);
	}

    } else if (!u) {

	log("%s: Attempt to register channel %s from nonexistent nick %s",
						s_ChanServ, chan, source);
	notice(s_ChanServ, source, "Sorry, registration failed.");

    } else if (!is_on_chan(source, chan)) {
	notice(s_ChanServ, source,
		"You must stay in channel to register the channel.");
    } else if (!is_chanop(source, chan) && !rec_services_admin(source)) {

	notice(s_ChanServ, source,
		"You must be a channel operator to register the channel.");

    } else if ((CHANNEL_MAXREG > 0) && (hni->channelcount >= CHANNEL_MAXREG)
		&& !(rec_services_admin(source))) {
	notice(s_ChanServ, source,
		"Sorry, you have already %s your limit of \2%d\2 channels.",
		hni->channelcount > CHANNEL_MAXREG ? "exceeded" : "reached",
		CHANNEL_MAXREG);

    } else if ((strlen(pass) < 5) || (stricmp(chan, pass) == 0)) {

        notice(s_ChanServ, source,
                "Please try again with a more obscure password.  Passwords"
                "should be at least five characters long, should not be "
                "something easily guessed (e.g. your real name or your "
                "nick), and cannot contain the space or tab characters.  "
                "\2/msg %s HELP REGISTER\2 for more information.",
                s_ChanServ);


    } else if (strlen(pass) > PASSMAX) {
           notice(s_ChanServ, source,
            "Sorry, channel passwords may not exceed %d characters in length",
                 PASSMAX);

    } else {
	ci = makechan(chan);
	if (ci) {
	    Channel *c1;
	    if (!(c1 = findchan(chan))) {
			log("%s: Channel %s not found for REGISTER", s_ChanServ, chan);
			notice(s_ChanServ, source, "Sorry, registration failed.");
			return;
	    }
	    csreg += 1;
	    ci->flags = CI_KEEPTOPIC;
	    if (is_tokn(22)) {
		    ci->flags = CI_CHANJOIN;
		    do_cs_join(chan);
	    }
	    ci->last_used = ci->time_registered;
	    strscpy(ci->founder, hni->nick, NICKMAX);
	    strscpy(ci->founderpass, pass, PASSMAX);
	    ci->desc = sstrdup(desc);
            ci->welcome = NULL;
	    ci->repeattimes = 4;
	    ci->ttb = 5;
	    ci->floodsecs = 2;
	    ci->capspercent = 25;
	    ci->floodlines = 5;
	    ci->capsmin = 10;
            ci->flags |= CI_MEMO_AV;
#ifdef UNREAL
	    if (tokn[30])
	        send_cmd (s_ChanServ, "MODE %s +%srq %s", chan, tokn[30], source);
	    else
	        send_cmd (s_ChanServ, "MODE %s +rq %s", chan, source);
#else
	    if (tokn[30])
	        send_cmd (s_ChanServ, "MODE %s +%sr", chan, tokn[30]);
	    else
	        send_cmd (s_ChanServ, "MODE %s +r", chan);
#endif

            if (tokn[30]) {
                char tmps[MODEMAX];
                strscpy (tmps, tokn[30], sizeof (tmps));
                strcat (tmps, "r");
                strscpy (ci->mlock_on, tmps, sizeof (ci->mlock_on));

            } 

	    if (c1->topic) {
			ci->last_topic = sstrdup(c1->topic);
			strscpy(ci->last_topic_setter, c1->topic_setter,NICKMAX);
			ci->last_topic_time = c1->topic_time;
	    }
	    if (hni->channelcount+1 > hni->channelcount)
		hni->channelcount++;

            slog("CS R %s (%s!%s@%s)",
                chan, u->nick, u->username, u->host);
            do_break_log("CS_R", "CS R %s (%s!%s@%s)",
                chan, u->nick, u->username, u->host);
	    log("%s: Channel %s registered by %s!%s@%s", s_ChanServ, chan,
			source, u->username, u->host);
#ifdef CYGWIN
	    winlog("%s: Channel %s registered by %s!%s@%s", s_ChanServ, chan,
			source, u->username, u->host);
#endif
	if (!is_tokn(33)) {
            notice(s_ChanServ, source,  CS_REGISTER,  chan, source);
            notice(s_ChanServ, source,  CS_REGISTER2,  ci->founderpass);
            if (x > 1)
              notice(s_ChanServ, source,  CS_REGISTER3,  chan, tokn[30]);
            notice(s_ChanServ, source, MISC_OFHELP, tokn[17]);
	    if (is_tokn(44)) {
            notice(s_ChanServ, source, "For more information on owning your own channel, go to:");
            notice(s_ChanServ, source, "%s", tokn[13]);
	    }
	} else {
	    do_sendcreg(source, pass, chan);
	}
	    if (is_tokn(4))
	    wallops(s_ChanServ, "Channel \2%s\2 is registered under nick %s.", chan, source);
            show_next_db(source, s_ChanServ);
	} else {
	    notice(s_ChanServ, source, "Sorry, registration failed.");
	} /* If Make Channel Success */

	c = smalloc(sizeof(*c));
	c->next = u->founder_chans;
	c->prev = NULL;
	if (u->founder_chans)
	    u->founder_chans->prev = c;
	u->founder_chans = c;
	c->chan = ci;
    } /* All condition */
    check_modes(chan, source);
}

/*************************************************************************/
#ifdef WEBSERVICE
void do_csidentify(const char *source)
{
	do_identify(source);
}
#endif

static void do_identify(const char *source)
{
    char *chan = strtok(NULL, " ");
    char *pass = strtok(NULL, " ");
    ChannelInfo *ci;
    struct u_chaninfolist *c;
    User *u = finduser(source);

    if (!pass) {

	notice(s_ChanServ, source,
                "Syntax: \2IDENTIFY\2 <#channel> <password>");
	notice(s_ChanServ, source,
		"\2/msg %s HELP IDENTIFY\2 for more information.", s_ChanServ);

    } else if (!(ci = cs_findchan(chan))) {
	notice(s_ChanServ, source, "Channel %s is not registered.", chan);
    } else if (ci && ci->freeze) {
	notice(s_ChanServ, source, "Channel %s is FROZEN can not identify.", chan);
    } else if (!u) {

	log("%s: IDENTIFY from nonexistent nick %s for %s",
						s_ChanServ, source, chan);
	notice(s_ChanServ, source, "Sorry, identification failed.");

    } else {

	int res;
	int is_force = (rec_services_root(source) && !stricmp(pass, "force"));
	if (is_force || (res = check_password(pass, ci->founderpass)) == 1) {
	    if (!is_identified(u, ci)) {
		c = smalloc(sizeof(*c));
		c->next = u->founder_chans;
		c->prev = NULL;
		if (u->founder_chans)
		    u->founder_chans->prev = c;
		u->founder_chans = c;
		c->chan = ci;
#ifdef UNREAL
		if (!(is_cfounder(source, chan)))
		        send_cmd(s_ChanServ, "MODE %s +q %s", chan, u->nick);
#endif
#ifdef CYGWIN
	    winlog("%s: %s!%s@%s ID %s", s_ChanServ,
		    source, u->username, u->host, chan);
#endif
		log("%s: %s!%s@%s identified for %s %s", s_ChanServ,
			source, u->username, u->host, chan,
			is_force ? "[Force]" : "");
                if (EXTRA_SNOOP && !is_force) {
                     slog("CS I %s (%s!%s@%s) %s",
                           chan, u->nick, u->username, u->host,
      			   is_force ? "[Force]" : "");
                     do_break_log("CS_I", "CS I %s (%s!%s@%s) %s",
                             chan, u->nick, u->username, u->host,
   			     is_force ? "[Force]" : "");
                }
		csid += 1;
	    }
	if (is_tokn(47)) {
		notice(s_ChanServ, source, "Password accepted for channel %s", chan);
	} else {
		send_cmd(server_name, "304 %s :Password accepted for channel %s", source, chan);
	}
//         notice(s_ChanServ, source,  CS_IDENTIFY,  chan);
	} else if (res < 0) {
            if (EXTRA_SNOOP) {
                 slog("CS *I %s (%s!%s@%s)",
                     chan, u->nick, u->username, u->host);
                 do_break_log("CS_I", "CS *I %s (%s!%s@%s)",
                     chan, u->nick, u->username, u->host);
            }
	    log("%s: check_password failed for %s", s_ChanServ, chan);
	    notice(s_ChanServ, source, "Sorry, identification failed.");
	    csidf += 1;
	} else {
	    log("%s: Failed IDENTIFY for %s by %s!%s@%s",
			s_ChanServ, chan, source, u->username, u->host);
            notice(s_ChanServ, source, toknmsg[1], BAD_PW_LIMIT - u->invalid_pw_count - 1);
	    if ((BAD_PW_LIMIT - u->invalid_pw_count - 1) == 1) {
                notice(s_NickServ, source, toknmsg[2], tokn[17]);
	    }

	    bad_password(u, chan);
	    csidf += 1;
	}

    } 
}
/*************************************************************************/

static void do_delete(const char *source)
{
    char *chan = strtok(NULL, " ");
    ChannelInfo *ci;
    User *u = finduser(source);

    if (readonly) {
        notice(s_ChanServ, source,
                "Sorry, channel deletion is temporarily disabled. (Read Only)");
	return;
    }

    if (!chan) {
       notice(s_ChanServ, source, "\2Delete\2: You MUST specify a channel");
       return;
    }

    if (!(ci = cs_findchan(chan))) {
        if (chan)
             notice(s_ChanServ, source, "Channel %s isn't registered.", chan);
        return;
    }
    botpart4(chan);
    delchan(ci);
    slog("CS +D %s (%s!%s@%s)", chan, source, u->username, u->host);
    do_break_log("CS_G", "CS +D %s (%s!%s@%s)", chan, source, u->username, u->host);
    log("%s: %s!%s@%s deleted channel %s", s_ChanServ,
            source, u->username, u->host, chan);
        notice(s_ChanServ, source, CS_DELETE, chan);
        wallops(s_ChanServ, "%s deleted channel \2%s\2", source, chan);
}

/*************************************************************************/

static void do_drop(const char *source)
{
    const char *chan = strtok(NULL, " ");
    C_SuspendData *c_spn;
    ChannelInfo *ci;
    NickInfo *ni;
    struct u_chaninfolist *c;
    User *u = finduser(source), *user;
    Timeout *t;

    if (readonly) {
	notice(s_ChanServ, source,
		"Sorry, channel de-registration is temporarily disabled.");
	return;
    }

    if (!chan) {
	        notice(s_ChanServ, source, "Syntax: \2DROP\2 <#channel>");
		notice(s_ChanServ, source,
		"\2/msg %s HELP DROP\2 for more information.", s_ChanServ);
	        return;
    }

    c_spn = get_c_suspend(chan);
    if (!(ci = cs_findchan(chan))) {
	notice(s_ChanServ, source, "Channel %s is not registered.", chan);
    } else if (ci->flags & CI_FREEZECHAN) {
         notice(s_ChanServ, source, "Channel %s is currently frozen", chan);
    } else if (c_spn && c_spn->time > CTime) {
      send_cmd(s_ChanServ, "JOIN %s", chan);
      send_cmd(s_ChanServ, "MODE %s +b *!*@*", chan);
      kick_user(s_ChanServ, chan, u->nick, "Channel is currently Suspended");
      t = add_timeout(CHANNEL_INHABIT, timeout_leave, 0);
      t->data = sstrdup(chan);
    } else if ((!u || !is_identified(u, ci)) && !rec_services_root(source)) {
            slog("CS *D %s (%s!%s@%s) [UNIDENTIFIED]",
                chan, u->nick, u->username, u->host);
            do_break_log("CS_O", "CS *D %s (%s!%s@%s) [UNIDENTIFIED]",
                chan, u->nick, u->username, u->host);
	notice(s_ChanServ, source,
		"Password authentication required for that command.");
	notice(s_ChanServ, source,
		"Retry after typing \2/msg %s IDENTIFY %s <password>.",
		s_ChanServ, chan);
    } else if (!u) {
	log("%s: DROP %s from nonexistent oper %s", s_ChanServ, chan, source);
	notice(s_ChanServ, source, "Can't find your user record!");
    } else {
	if (readonly) {
	    notice(s_ChanServ, source, "Warning: Services is in read-only "
	                               "mode; changes will not be saved.");
	}
	ni = findnick(ci->founder);

	if (ni) {
	    if (ni->channelcount > 0)
		ni->channelcount--;
	} else {
	    log("%s: Can't find founder nickname record for dropping %s",
			s_ChanServ, chan);
	}

	change_cmode (s_ChanServ, chan, "-r", "");

        for (user = userlist; user; user = user->next) {
          for(c = user->founder_chans; c && stricmp(ci->name, c->chan->name) != 0; c = c->next)
             ;
          if (c) {
             if (c->next)
                c->next->prev = c->prev;
             if (c->prev)
                c->prev->next = c->next;
             else
                user->founder_chans = c->next;
             free(c);
          }
        }

	botpart4(ci->name);
	do_cs_part(chan);
	delchan(ci);
	csdrop += 1;
        slog("CS D %s (%s!%s@%s)",
              chan, u->nick, u->username, u->host);
        do_break_log("CS_O", "CS D %s (%s!%s@%s)",
              chan, u->nick, u->username, u->host);
	log("%s: Channel %s dropped by %s!%s@%s", s_ChanServ, chan,
			source, u->username, u->host);
        notice(s_ChanServ, source,  CS_DROP,  chan);
    }
}

/*************************************************************************/

/* Main SET routine.  Calls other routines as follows:
 *	do_set_command(User *command-sender, ChannelInfo *ci, char *param);
 * Additional parameters can be retrieved using strtok(NULL, toks).
 * (Exception is do_set_held(), which takes only source nick and channel
 * name.)
 */
static void do_set(const char *source)
{
    NickInfo *ni = findnick(source);
    char *chan = strtok(NULL, " ");
    char *cmd  = strtok(NULL, " ");
    char *param;
    ChannelInfo *ci;
	int x=0;
    int acc=0;
	User *u = finduser(source);

    if (readonly) {
	notice(s_ChanServ, source,
		"Sorry, channel option setting is temporarily disabled.");
	return;
    }

    if (cmd) {
	if (stricmp(cmd, "DESC") == 0 || stricmp(cmd, "TOPIC") == 0 
	|| (stricmp(cmd,"WELCOME") == 0)
	|| (stricmp(cmd,"BADWORDS") == 0)
	|| stricmp(cmd,"NEWS") == 0)
	    param = strtok(NULL, "");
    else if (stricmp(cmd, "FOUNDER") == 0) {
            param = sstrdup(source);
 	    x = 1;
    } else if (stricmp(cmd, "UNSUCCESSOR") == 0) {
            param = sstrdup(source);
	    x = 1;
	} else
	    param = strtok(NULL, " ");
    } else
		param = NULL;
		csset += 1;
    if (!param) {
		notice(s_ChanServ, source,
                "Syntax: \2SET <#chan> <option> [<parameters>]");
		
		notice(s_ChanServ, source,
			"\2/msg %s HELP SET\2 for more information.", s_ChanServ);
    } else if (!ni) {
        notice(s_ChanServ, source,
             "Your nick is not registered!");
    } else if (!(ci = cs_findchan(chan))) {
		notice(s_ChanServ, source, "Channel %s is not registered.", chan);
    } else if (u && (!is_identified(u, ci) && !rec_services_root(source))) {
	    notice(s_ChanServ, source,
		"Password authentication required for that command.");
	    notice(s_ChanServ, source,
		"Retry after typing \2/msg %s IDENTIFY %s \37password\37.",
		s_ChanServ, chan);
    } else if (!u || (1 != (acc = is_founder(u, ni, ci, 1))
               && (get_access(u, ci) != 13))) {
		notice(s_ChanServ, source, toknmsg[26], chan);
    } else if (stricmp(cmd, "FOUNDER") == 0) {
        if (acc != 1) {
	    notice(s_ChanServ, source,
		"Password authentication required for that command.");
	    notice(s_ChanServ, source,
		"Retry after typing \2/msg %s IDENTIFY %s \37password\37.",
		s_ChanServ, chan);
	} else {
	    do_set_founder(u, ci);
	}

    } else if (stricmp(cmd, "PASSWORD") == 0) {
        if (acc != 1) {
	    notice(s_ChanServ, source,
		"Password authentication required for that command.");
	    notice(s_ChanServ, source,
		"Retry after typing \2/msg %s IDENTIFY %s \37password\37.",
		s_ChanServ, chan);
	} else {
	    do_set_password(u, ci, param);
	}
    } else if (stricmp(cmd, "PASSWD") == 0) {
        if (acc != 1) {
	    notice(s_ChanServ, source,
		"Password authentication required for that command.");
	    notice(s_ChanServ, source,
		"Retry after typing \2/msg %s IDENTIFY %s \37password\37.",
		s_ChanServ, chan);
	} else {
	    do_set_password(u, ci, param);
	}
    } else if (stricmp(cmd, "SUCCESSOR") == 0) {
        if (acc != 1) {
	    notice(s_ChanServ, source,
		"Password authentication required for that command.");
	    notice(s_ChanServ, source,
		"Retry after typing \2/msg %s IDENTIFY %s \37password\37.",
		s_ChanServ, chan);
	} else {
		do_set_successor(u, ci, param);
	}
    } else if (stricmp(cmd, "UNSUCCESSOR") == 0) {
        if (acc != 1) {
	    notice(s_ChanServ, source,
		"Password authentication required for that command.");
	    notice(s_ChanServ, source,
		"Retry after typing \2/msg %s IDENTIFY %s \37password\37.",
		s_ChanServ, chan);
	} else {
		do_unset_successor(u, ci, param);
	}

    } else if (stricmp(cmd, "WELCOME") == 0) {

        do_set_welcome(u, ci, param);

    } else if (stricmp(cmd, "DESC") == 0) {

		do_set_desc(u, ci, param);

    } else if (stricmp(cmd, "URL") == 0) {

		do_set_url(u, ci, param);

    } else if (stricmp(cmd, "EMAIL") == 0) {

		do_set_email(u, ci, param);

    } else if (stricmp(cmd, "TOPIC") == 0) {

		do_set_topic(u, ci, param);

    } else if (stricmp(cmd, "MEMO") == 0) {

        do_memolev(u, ci, param);

    } else if (stricmp(cmd, "MLOCK") == 0) {

		do_set_mlock(u, ci, param);

    } else if (stricmp(cmd, "KEEPTOPIC") == 0) {

		do_set_keeptopic(u, ci, param);

    } else if (stricmp(cmd, "AUTOVOP") == 0) {

		do_set_autovop(u, ci, param);

    } else if (stricmp(cmd, "AUTOHOP") == 0) {

		do_set_autohop(u, ci, param);

    } else if (stricmp(cmd, "AUTOOP") == 0) {

		do_set_autoop(u, ci, param);

    } else if (stricmp(cmd, "NEWSSET") == 0) {

		do_set_newsset(u, ci, param);

    } else if (stricmp(cmd, "LEAVEOP") == 0) {

		do_set_leaveop(u, ci, param);

    } else if (stricmp(cmd, "VERBOSE") == 0) {

		do_set_verbose(u, ci, param);

    } else if (stricmp(cmd, "BADCHAN") == 0) {

		do_set_badchan(u, ci, param);

    } else if (stricmp(cmd, "NOGB") == 0) {

		do_set_gb(u, ci, param);

    } else if (stricmp(cmd, "PROTECT") == 0) {

		do_set_protect(u, ci, param);

    } else if (stricmp(cmd, "BADNICK") == 0) {

		do_set_badnick(u, ci, param);

    } else if (stricmp(cmd, "TOPICLOCK") == 0) {

		do_set_topiclock(u, ci, param);

    } else if (stricmp(cmd, "PRIVATE") == 0) {

		do_set_private(u, ci, param);

    } else if (stricmp(cmd, "OPGUARD") == 0) {

        do_set_opguard(u, ci, param);
#ifdef DEFHALFOP
    } else if (stricmp(cmd, "HOPGUARD") == 0) {

        do_set_hopguard(u, ci, param);
#endif
    } else if (stricmp(cmd, "JOIN") == 0) {
    	if (!is_tokn(3) && (!rec_services_root(source))) {
           notice(s_ChanServ,source,"This options is disabled.");
	} else {
	   do_set_chanjoin(u, ci, param);
	}
    } else if (stricmp(cmd, "RESTRICTED") == 0) {

		do_set_restricted(u, ci, param);

    } else if (stricmp(cmd, "IDENT") == 0) {

		do_set_ident(u, ci, param);

    } else if (stricmp(cmd, "UNSECURE") == 0) {

		do_set_unsecure(u, ci, param);

    } else {

		notice(s_ChanServ, source,
			"Unknown SET option \2%s\2.", strupper(cmd));

    }
    if (x)
		free(param);
}
/*************************************************************************/
static void do_set_founder(User *u, ChannelInfo *ci)
{
    NickInfo *ni = findnick(u->nick);

    if (ni && ni->flags & NI_SLAVE) {
        notice(s_ChanServ, u->nick, "%s is a slave nick, please add nick %s a master of this nick.", ni->nick, ni->last_usermask);
        return;
    }

    if (!ni) {
       notice(s_ChanServ, u->nick,
           "You must be using a registered nick");
    } else if (!(ni->flags & NI_IDENTIFIED)) {
       notice(s_ChanServ, u->nick,
           "You must first identify to your nick before claiming  founder");
    } else {

        if ((ni->channelcount > 0) && (stricmp(ci->founder, u->nick)!=0))
            ni->channelcount++;

        slog("CS F %s (%s!%s@%s) [%s -> %s]",
           ci->name, u->nick, u->username, u->host, ci->founder, u->nick);
        do_break_log("CS_O", "CS F %s (%s!%s@%s) [%s -> %s]",
           ci->name, u->nick, u->username, u->host, ci->founder, u->nick);
        strscpy(ci->founder, u->nick, NICKMAX);
        notice(s_ChanServ, u->nick,
		"You are now the Founder of %s.", ci->name);
        show_u_next_db(u, s_ChanServ);
    }
}

/*************************************************************************/
static void do_set_password(User *u, ChannelInfo *ci, const char *param)
{

    if ((strlen(param) < 5) || (stricmp(param, ci->name) == 0)) {

        notice(s_ChanServ, u->nick,
                "Please try again with a more obscure password. Passwords"
                "should be at least five characters long, should not be "
                "something easily guessed (e.g. your real name or your "
                "chan name), and cannot contain the space or tab characters."
                "  \2/msg %s HELP REGISTER\2 for more information.",
                s_ChanServ);

    } else if (strlen(param) >= PASSMAX) {
           notice(s_ChanServ, u->nick,
            "Sorry, channel passwords may not exceed %d characters in length",
                 PASSMAX);

    } else {
	    strscpy(ci->founderpass, param, PASSMAX);
	    slog("CS P %s (%s!%s@%s)",
	    ci->name, u->nick, u->username, u->host);
	    do_break_log("CS_O", "CS P %s (%s!%s@%s)",
	       ci->name, u->nick, u->username, u->host);
	    notice(s_ChanServ, u->nick,
		"%s password changed to \2%s\2.", ci->name, ci->founderpass);
	    show_u_next_db(u, s_ChanServ);
    }
}

/*************************************************************************/

static void do_set_welcome(User *u, ChannelInfo *ci, const char *param)
{
    if (!stricmp(param,"none")) {
		if (ci->welcome)
			free(ci->welcome);
		ci->welcome = NULL;
        notice(s_ChanServ, u->nick, "Welcome message disabled for %s.",
            ci->name);
        slog("CS -W %s (%s!%s@%s)",
                ci->name, u->nick, u->username, u->host);
    } else {
		if (ci->welcome)
			free(ci->welcome);
        ci->welcome = sstrdup(param);
        notice(s_ChanServ, u->nick,
                    "Welcome Message for %s changed to \"\2%s\2\".", ci->name, ci->welcome);
        slog("CS W %s (%s!%s@%s) [%s]",
           ci->name, u->nick, u->username, u->host, ci->welcome);
        show_u_next_db(u, s_ChanServ);
    }
}

/*************************************************************************/

static void do_set_desc(User *u, ChannelInfo *ci, const char *param)
{
    free(ci->desc);
    ci->desc = sstrdup(param);
    notice(s_ChanServ, u->nick,
		"Description of %s changed to \2%s\2.", ci->name, param);
    show_u_next_db(u, s_ChanServ);
}

/*************************************************************************/

static void do_set_url(User *u, ChannelInfo *ci, const char *param)
{
    if (ci->url)
	free(ci->url);
    ci->url = sstrdup(param);
    notice(s_ChanServ, u->nick,
		"URL for %s changed to \2%s\2.", ci->name, param);
    show_u_next_db(u, s_ChanServ);
}

/*************************************************************************/

static void do_set_email(User *u, ChannelInfo *ci, const char *param)
{
    if (!strchr(param, '@')) {
        notice(s_ChanServ, u->nick,
             "E-Mail addressed must contain an '@'");
        return;
    }

    if (ci->email)
	free(ci->email);
    ci->email = sstrdup(param);
    notice(s_ChanServ, u->nick,
		"E-mail address for %s changed to \2%s\2.", ci->name, param);
    show_u_next_db(u, s_ChanServ);
}

/*************************************************************************/

static void do_set_topic(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;
    Channel *c = findchan(chan);
    int ulev2 = 0;

    if (!c) {
	log("%s: SET TOPIC for %s from %s: channel not found!",
		s_ChanServ, chan, source);
	notice(s_ChanServ, source, "Sorry, can't set topic.");
	return;
    }

    if (ci->topic_allow > 0) {
        if (ci->topic_allow > (ulev2 = get_access(u, ci))) {
             notice(s_ChanServ, source,
                 toknmsg[26], chan);

             return;
        }
    }


    if (ci->last_topic)
	free(ci->last_topic);
    if (*param)
	ci->last_topic = sstrdup(param);
    else
	ci->last_topic = NULL;

    if (c->topic) {
	free(c->topic);
	--c->topic_time;	/* to get around TS8 */
    } else
	c->topic_time = CTime;

    if (*param)
	c->topic = sstrdup(param);
    else
	c->topic = NULL;

    strscpy(ci->last_topic_setter, source, NICKMAX);
    strscpy(c->topic_setter, source, NICKMAX);
    ci->last_topic_time = c->topic_time;

    send_cmd(MODE_SENDER, "TOPIC %s %s %lu :%s",
                chan, source, c->topic_time, param);

}

/*************************************************************************/

static void do_set_mlock(User *u, ChannelInfo *ci, const char *param)
{
    char *s, c, mlock_on[MODEMAX], mlock_off[MODEMAX];
    int add = -1;	/* 1 if adding, 0 if deleting, -1 if neither */

    strscpy(mlock_on, "r", sizeof(mlock_on));
    strscpy(mlock_off, "", sizeof(mlock_off));
    ci->mlock_limit = 0;
    if (ci->mlock_key)
    {
        free (ci->mlock_key);
        ci->mlock_key = NULL;
    }
#ifdef UNREAL
    if (ci->mlock_link)
    {
        free (ci->mlock_link);
        ci->mlock_link = NULL;
    }
    if (ci->mlock_flood)
    {
        free (ci->mlock_flood);
        ci->mlock_flood = NULL;
    }
#endif

    while (*param)
    {
        if (*param != '+' && *param != '-' && add < 0)
        {
            ++param;
            continue;
        }
        switch ((c = *param++))
        {
        case '+':
            add = 1;
            break;
        case '-':
            add = 0;
            break;
        case 'r':
            break;
        case 'k':
            if (add)
            {
                if (!(s = strtok (NULL, " ")))
                {
                    notice (s_ChanServ, u->nick, toknmsg[15], 'k');
                    return;
                }

				ci->mlock_key = sstrdup (s);
                strscpy(mlock_on, changemode("k", mlock_on), sizeof(mlock_on));
            }
            else
  	    {
                if (ci->mlock_key)
                {
                    free (ci->mlock_key);
                    ci->mlock_key = NULL;
                }
                strscpy(mlock_off, changemode("k", mlock_off), sizeof(mlock_off));
            }
            break;
        case 'l':
            if (add)
            {
                if (!(s = strtok (NULL, " ")))
                {
                    notice (s_ChanServ, u->nick, toknmsg[15], 'l');
                    return;
                }
                if (atol (s) <= 0)
                {
                    notice (s_ChanServ, u->nick, toknmsg[16], 'l');
                    return;
                }
                ci->mlock_limit = atol (s);
                strscpy(mlock_on, changemode("l", mlock_on),sizeof(mlock_on));
            }
            else
            {
                strscpy(mlock_off, changemode("l", mlock_off), sizeof(mlock_off));
                ci->mlock_limit = 0;
            }
            break;
        case 'O':
	    if (!is_oper(u->nick))
		break;
        case 'A':
	    if (!is_admin(u->nick))
		break;
#ifdef UNREAL
        case 'Q':
	    if (!is_oper(u->nick))
		break;
        case 'H':
	    if (!is_admin(u->nick))
		break;
#endif
        default:
            if (add)
                strscpy(mlock_on, changemode(myctoa(c), mlock_on), sizeof(mlock_on));
            else
                strscpy(mlock_off, changemode(myctoa(c), mlock_off), sizeof(mlock_off));
        }
    }
    strscpy(ci->mlock_on, changemode("-bvo", mlock_on), sizeof(ci->mlock_on));
    strscpy(ci->mlock_off, changemode("-bvo", mlock_off), sizeof(ci->mlock_off));

#ifdef UNREAL
    strscpy(ci->mlock_on, changemode("-ehaq", mlock_on), sizeof(ci->mlock_on));
    strscpy(ci->mlock_off, changemode("-ehaq", mlock_off), sizeof(ci->mlock_off));
#endif

    if (strlen(ci->mlock_on) || strlen(ci->mlock_off))
    {
        notice (s_ChanServ, u->nick, toknmsg[17], ci->name,
                strlen(ci->mlock_on) ? "+" : "",
                strlen(ci->mlock_on) ? ci->mlock_on : "",
                strlen(ci->mlock_off) ? "-" : "",
                strlen(ci->mlock_off) ? ci->mlock_off : "");
    }
    else
        notice (s_ChanServ, u->nick, toknmsg[18], toknmsg[19], ci->name);
    check_modes (ci->name, u->nick);
}

/*************************************************************************/

static void do_set_keeptopic(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;

    if (stricmp(param, "ON") == 0) {

	ci->flags |= CI_KEEPTOPIC;
	notice(s_ChanServ, source,
		"Topic retention option is now \2ON\2.");
        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "OFF") == 0) {

	ci->flags &= ~CI_KEEPTOPIC;
	notice(s_ChanServ, source,
		"Topic retention option is now \2OFF\2.");
        show_u_next_db(u, s_ChanServ);

    } else {

	notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s KEEPTOPIC [ON|OFF]", chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP SET KEEPTOPIC\2 for more information.",
		s_ChanServ);
    }
}

/*************************************************************************/

static void do_set_topiclock(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;

    if (stricmp(param, "VOP") == 0) {

	ci->flags |= CI_TOPICLOCK;
        ci->topic_allow = 3;
	notice(s_ChanServ, source,
                "Topic lock option is now set to \2VOP\2.");
        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "HOP") == 0) {

	ci->flags |= CI_TOPICLOCK;
        ci->topic_allow = 4;
	notice(s_ChanServ, source,
                "Topic lock option is now set to \2HOP\2.");
        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "AOP") == 0) {

	ci->flags |= CI_TOPICLOCK;
        ci->topic_allow = 5;
	notice(s_ChanServ, source,
                "Topic lock option is now set to \2AOP\2.");
        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "SOP") == 0) {

	ci->flags |= CI_TOPICLOCK;
        ci->topic_allow = 10;
	notice(s_ChanServ, source,
                "Topic lock option is now set to \2SOP\2.");
        show_u_next_db(u, s_ChanServ);

    } else if ((stricmp(param, "CFOUNDER") == 0) || (stricmp(param,"CF") == 0)) {

	ci->flags |= CI_TOPICLOCK;
        ci->topic_allow = 13;
	notice(s_ChanServ, source,
                "Topic lock option is now set to \2Co-Founder\2.");
        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "FOUNDER") == 0) {

	ci->flags |= CI_TOPICLOCK;
        ci->topic_allow = 15;
	notice(s_ChanServ, source,
                "Topic lock option is now set to \2FOUNDER\2.");
        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "OFF") == 0) {

	ci->flags &= ~CI_TOPICLOCK;
        ci->topic_allow = 0;
	notice(s_ChanServ, source,
		"Topic lock option is now \2OFF\2.");
        show_u_next_db(u, s_ChanServ);

    } else {

	notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s TOPICLOCK [VOP|HOP|AOP|SOP|CFOUNDER|FOUNDER|OFF]", chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP SET TOPICLOCK\2 for more information.",	s_ChanServ);
    }
}

/*************************************************************************/

static void do_set_private(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick;
    char *chan = ci->name;

    if (stricmp(param, "ON") == 0) {

	ci->flags |= CI_PRIVATE;
	notice(s_ChanServ, source, "Private option is now \2ON\2.");
        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "OFF") == 0) {

	ci->flags &= ~CI_PRIVATE;
	notice(s_ChanServ, source, "Private option is now \2OFF\2.");
        show_u_next_db(u, s_ChanServ);

    } else {

	notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s PRIVATE [ON|OFF]", chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP SET PRIVATE\2 for more information.",
		s_ChanServ);
    }
}

/*************************************************************************/

static void do_set_opguard(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;

    if (!stricmp(param, "ON")) {

	ci->flags |= CI_OPGUARD;
	notice(s_ChanServ, source,
		"Secure ops option for %s is now \2ON\2.",chan);
        show_u_next_db(u, s_ChanServ);

    } else if (!stricmp(param, "OFF")) {

	ci->flags &= ~CI_OPGUARD;
	notice(s_ChanServ, source,
		"Op Guard option for %s is now \2OFF\2.",chan);
        show_u_next_db(u, s_ChanServ);

    } else {

	notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s OPGUARD [ON|OFF]", chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP SET OPGUARD\2 for more information.",
		s_ChanServ);
    }
}
#ifdef DEFHALFOP
static void do_set_hopguard(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;

    if (!stricmp(param, "ON")) {

	ci->botflag |= CBI_HOPGUARD;
	notice(s_ChanServ, source,
		"Secure halfops option for %s is now \2ON\2.",chan);
        show_u_next_db(u, s_ChanServ);

    } else if (!stricmp(param, "OFF")) {

	ci->botflag &= ~CBI_HOPGUARD;
	notice(s_ChanServ, source,
		"HOp Guard option for %s is now \2OFF\2.",chan);
        show_u_next_db(u, s_ChanServ);

    } else {

	notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s HOPGUARD [ON|OFF]", chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP SET HOPGUARD\2 for more information.",
		s_ChanServ);
    }
}
#endif

/*************************************************************************/

static void do_set_restricted(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;

    if (stricmp(param, "ON") == 0) {

	ci->flags |= CI_RESTRICTED;
	notice(s_ChanServ, source,
		"Restricted access option is now \2ON\2.");
        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "OFF") == 0) {

	ci->flags &= ~CI_RESTRICTED;
	notice(s_ChanServ, source,
		"Restricted access option is now \2OFF\2.");
        show_u_next_db(u, s_ChanServ);

    } else {

	notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s RESTRICTED [ON|OFF]", chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP SET RESTRICTED\2 for more information.",
		s_ChanServ);
    }
}

/*************************************************************************/

static void do_set_ident(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;

    if (stricmp(param, "ON") == 0) {

	ci->flags |= CI_IDENT;
	notice(s_ChanServ, source,
		"Ident option is now \2ON\2.");

        if (ci->flags & CI_UNSECURE) {
             ci->flags &= ~CI_UNSECURE;
             notice(s_ChanServ, source,
                 "UNSECURE setting automatically disabled when IDENT set to ON");
        }

        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "OFF") == 0) {

	ci->flags &= ~CI_IDENT;
	notice(s_ChanServ, source,
		"Ident option is now \2OFF\2.");
        show_u_next_db(u, s_ChanServ);

    } else {

	notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s IDENT [ON|OFF]", chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP SET IDENT\2 for more information.",
		s_ChanServ);
    }
}

/*************************************************************************/

static void do_set_unsecure(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;

    if (stricmp(param, "ON") == 0) {

        if (ci->flags & CI_IDENT) {
            notice(s_ChanServ, source,
                 "Can't set UNSECURE when IDENT is already set!");
            return;
        }

	ci->flags |= CI_UNSECURE;
	notice(s_ChanServ, source,
		"Channel %s is now UNSECURE.", chan);
        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "OFF") == 0) {

	ci->flags &= ~CI_UNSECURE;
	notice(s_ChanServ, source,
		"Channel %s now has regular security options enabled",
                         chan);
        show_u_next_db(u, s_ChanServ);

    } else {

	notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s UNSECURE [ON|OFF]", chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP SET UNSECURE\2 for more information.",
		s_ChanServ);
    }
}

/*************************************************************************/
void addbyauth(const char *nick, char *addinfo, char *chan, int alevel)
{
    ChannelInfo *ci;
    ChanAccess *access1;
    int i;

    if (!(ci = cs_findchan(chan)))
	return;
     for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
        if (access1->in_use && stricmp(access1->name, nick) == 0) {
                access1->level = alevel;
		if (access1->adder)
			free(access1->adder);
		access1->adder = sstrdup(addinfo);
		return;
        }
     }
     for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
    	if (!access1->in_use)
        	break;
     }

     if (i == ci->accesscount) {
       	    ++ci->accesscount;
            ci->access =
       	        srealloc(ci->access, sizeof(ChanAccess) * ci->accesscount);
            access1 = &ci->access[ci->accesscount-1];
     }
     access1->name = sstrdup(nick);
     access1->adder = sstrdup(addinfo);
     access1->in_use = 1;
     access1->level = alevel;
}
/*************************************************************************/
static void do_cfounder(const char *source)
{
    const char *chan = strtok(NULL, " ");
    const char *cmd  = strtok(NULL, " ");
    const char *nick = strtok(NULL, " ");
    char *s    = "1", *d;
    ChannelInfo *ci;
    NickInfo *ni;
    User *u;
    short ulev;
    int is_list = (cmd && !stricmp(cmd, "LIST"));
    int is_selfdel = 0;
    ChanAccess *access1;
    int i, f=0, z;

    if (!cmd || ((!stricmp(cmd, "LIST") == 0) && (!stricmp(cmd, "WIPE") == 0)
             && (!stricmp(cmd, "CLEAN") == 0) && !nick)) {
         notice(s_ChanServ, source,
           "Syntax: \2CFOUNDER\2 <#channel> [ADD|DEL|LIST|WIPE|CLEAN] [<nick>]");
         return;
    }

    if (!(ci = cs_findchan(chan))) {
        notice(s_ChanServ, source, "Channel %s is not registered.", chan);
	return;
    }
    if (!(u = finduser(source))) {
        notice(s_ChanServ, source, toknmsg[26], chan);
        log("%s: ACCESS command from nonexistent user %s", s_ChanServ, source);
    }
    if (cmd && nick && !stricmp(cmd, "DEL") && !stricmp(source, nick)) {
        is_selfdel = 1;
    }
    if (13 >= (ulev = get_access(u, ci))) {
        if (!ulev) {
                notice(s_ChanServ, source, toknmsg[26], chan);
                return;
        } else if (!is_selfdel && !is_list) {
                notice(s_ChanServ, source, toknmsg[26], chan);
                return;
        }
    }

    if (stricmp(cmd, "LIST") == 0) {
	unsigned int j = 0, k=0;
        if (check_access(u, ci, CA_AKICK))
                k=1;
        notice(s_ChanServ, source, "CFOUNDER list for \2%s\2:", chan);
        for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
            if ((nick && !match_wild(nick, access1->name)) ||
                                        (13 != access1->level))
                continue;
	    ni = findnick(access1->name);
            if (ni)
                s = ni->last_usermask;
            else
                s = NULL;

            if (access1->adder && (k==1))
                d = access1->adder;
            else
                d = NULL;
	    ++j;
            notice(s_ChanServ, source, " %d)  %s%s%s%s (%s)",
                        j, access1->name,
                        s ? " (" : "", s ? s : "", s ? ")" : "", d?d:"");
        }
	notice(s_ChanServ,source,"End of List");

    } else if (stricmp(cmd, "ADD") == 0) {
        if (readonly) {
            notice(s_ChanServ, source,
                "Sorry, channel access list modification is temporarily disabled");
            return;
        }
        ni = findnick(nick);
        if (!ni) {
            notice(s_ChanServ, source, "Nick %s is not registered.", nick);
            return;
        }

        if (ni && ni->forbid) {
           notice(s_ChanServ, source, "Forbidden nick %s not permitted to be added to channel access lists", ni->nick);
           return;
        }

        if (ni->flags & NI_FREEZE) {
           notice(s_ChanServ, source, "Frozen nick %s not permitted to be added to channel access lists", ni->nick);
           return;
        }
        for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
            if (access1->in_use && stricmp(access1->name, nick) == 0) {
	        if (ulev <= access1->level) {
	            notice(s_ChanServ, source, toknmsg[26], chan);
		    return;
	        }
                if (access1->level == 13) {
                    notice(s_ChanServ, source,
                        "\2%s\2 is already a CFOUNDER on \2%s\2.",
                        access1->name, chan);
                    return;
                }
		if (ni->flags & NI_AUTH) {
			do_addauth(who_access(finduser(source), ci), nick, chan, 6);
			notice(s_ChanServ, source, "Authorize have been request to nick %s", ni->nick);
			return;
		}
                if (ni && (ni->flags & NI_NOOP)) {
                    notice(s_ChanServ, source, "Since %s is already on the %s access list, regardless of NOOP setting, adding to Co-Founder list",
                       ni->nick, chan);
		    if (finduser(ni->nick))
		    if (ni->flags & NI_IDENTIFIED) 
		        notice(s_ChanServ, ni->nick, "\2%s\2 tried to added you as a Co Founder in channel \2%s\2.", source, chan);
		}
                else {
                	if (access1->level == 3) {
                    	notice(s_ChanServ, source,
              	"\2%s\2 has been moved from the VOP to the CFOUNDER list of \2%s\2.",
                        	access1->name, chan);
	                } else if (access1->level == 5) {
                    	notice(s_ChanServ, source,
              	"\2%s\2 has been moved from the AOP to the CFOUNDER list of \2%s\2.",
                        	access1->name, chan);
	                } else if (access1->level == 4) {
                    	notice(s_ChanServ, source,
              	"\2%s\2 has been moved from the HOP to the CFOUNDER list of \2%s\2.",
                        	access1->name, chan);
	                } else if (access1->level == 10) {
                    	notice(s_ChanServ, source,
              	"\2%s\2 has been moved from the SOP to the CFOUNDER list of \2%s\2.",
                        	access1->name, chan);
			} else 
                   notice(s_ChanServ, source,
                        "\2%s\2 was changed to a Co-Founder on \2%s\2.",
                        access1->name, chan);
                access1->level = 13;
		if (access1->adder)
			free(access1->adder);
		access1->adder = sstrdup(addedby(ci,source));
		if (ci->botflag & CBI_VERBOSE)
		opnotice (s_ChanServ, chan, "[VERBOSE] %s added %s to the CFOUNDER list.", source, access1->name);
		if (ni->flags & NI_IDENTIFIED) {
			do_lautoop(access1->name, chan, access1->level);
	        	notice(s_ChanServ, ni->nick, "\2%s\2 added you as Co Founder in channel \2%s\2.", source, chan);
		}
	      }
                show_next_db(source, s_ChanServ);
                return;
            }
        }
        if ((CHAN_ACCESS_MAX > 0) && (ci->accesscount > CHAN_ACCESS_MAX-1)) {
	    notice(s_ChanServ, source,
                    "Sorry, you may only have %d channel access enteries.",
                    CHAN_ACCESS_MAX);
            wallops(s_ChanServ, "%s tried to add another nick to the access list on %s",
                   source, chan);
	    return;
	}
        if (ni && (ni->flags & NI_NOOP)) {
             notice(s_ChanServ, source, "Sorry, %s has the NOOP option set.", ni->nick);
	    if (finduser(ni->nick))
	    if (ni->flags & NI_IDENTIFIED) 
	        notice(s_ChanServ, ni->nick, "\2%s\2 tried to added you as a Co Founder in channel \2%s\2.", source, chan);
             return;
        }
        for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
            if (!access1->in_use)
                break;
        }
        if (i == ci->accesscount) {
            ++ci->accesscount;
            ci->access =
                srealloc(ci->access, sizeof(ChanAccess) * ci->accesscount);
            access1 = &ci->access[ci->accesscount-1];
        }
        access1->name = sstrdup(ni->nick);
	access1->adder = sstrdup(addedby(ci,source));
        access1->in_use = 1;
        access1->accflag = 0;
        access1->level = 13;
        notice(s_ChanServ, source,
	  "\2%s\2 has been added to the Co-Founder list of \2%s\2.",
                access1->name, chan);
        show_next_db(source, s_ChanServ);
	if (ni->flags & NI_IDENTIFIED) {
		do_lautoop(access1->name, chan, access1->level);
	        notice(s_ChanServ, ni->nick, "\2%s\2 added you as Co Founder in channel \2%s\2.", source, chan);
	}
	if (ci->botflag & CBI_VERBOSE)
		opnotice (s_ChanServ, chan, "[VERBOSE] %s added %s to the CFOUNDER list.", source, access1->name);
    } else if (stricmp(cmd, "DEL") == 0) {

        if (readonly) {
            notice(s_ChanServ, source,
                "Sorry, channel access list modification is temporarily disabled");
            return;
        }
        /* Special case: is it a number?  Only do search if it isn't. */
        if (isNum(nick) && (i = atoi(nick)) > 0 && i <= ci->accesscount) {
            int j=0;
            for (access1 = ci->access, z = 0; z < ci->accesscount;
			++access1, ++z) {
                if (!(13 == access1->level))
                    continue;
	        j += 1;
                if (i == j) {
		    access1 = &ci->access[z];
		    break;
		}
            }
            if (!(i == j)) {
                notice(s_ChanServ, source,
                        "No such entry (#%d) on %s access list.", i, chan);
                return;
            }
        } else {

            for (access1 = ci->access, z = 0; z < ci->accesscount;
                                                        ++access1, ++z) {
                if ((stricmp(access1->name, nick) == 0)
                        && (access1->level == 13))
                    break;
            }
            if (z == ci->accesscount) {
                notice(s_ChanServ, source,
                        "\2%s\2 not found on %s Co-Founder list.", nick, chan);
                return;
            }
        }
        if (get_access(u, ci) <= access1->level) {
            notice(s_ChanServ, source, "Permission denied.");
        } else {
            notice(s_ChanServ, source,
      "\2%s\2 has been removed from the Co-Founder list of %s.", access1->name, chan);
            if (ci->botflag & CBI_VERBOSE)
                opnotice (s_ChanServ, chan, "[VERBOSE] %s removed %s from the CFOUNDER list.", source, access1->name);
            show_next_db(source, s_ChanServ);
            free(access1->name);
	    if (access1->adder)
	            free(access1->adder);
            access1->in_use = 0;
            access1->name = NULL;
            access1->adder = NULL;
              --ci->accesscount;
              if (z < ci->accesscount)
		memmove(access1, access1+1, sizeof(ChanAccess) * (ci->accesscount - z));
            if (!ci->accesscount) {
                 free(ci->access);
                 ci->access = NULL;
            }
        }

    } else if (stricmp(cmd, "CLEAN") == 0) {
        int check = 0;
        check = ci->accesscount;
        for (access1 = ci->access, i = 0; i < check; ++access1, ++i) {
              if ((13 == access1->level) && (!strchr(access1->name, '@'))
                 && (!findnick(access1->name))) {
                     free(access1->name);
		     if (access1->adder)
	                     free(access1->adder);
                     access1->name = NULL;
                     access1->adder = NULL;
                     access1->in_use = 0;
                     ++f;
                     --ci->accesscount;
                     if ((i-f) < ci->accesscount)
			memmove(access1, access1+1, sizeof(ChanAccess) * (ci->accesscount - (i-f)));
                     --access1;
              }
        }
        if (!(f > 0))
            notice(s_ChanServ, source,
               "No Expired nicknames found in the CFOUNDER list on \2%s\2",
                chan);
        else {
           if (!ci->accesscount) {
                 free(ci->access);
                 ci->access = NULL;
           }
           notice(s_ChanServ, source,
               "%d expired nicknames in the CFOUNDER list on \2%s\2 removed",
                f, chan);
           show_next_db(source, s_ChanServ);
       }
       f=0;


    } else if (stricmp(cmd, "WIPE") == 0) {
        int check = 0;
        check = ci->accesscount;
        for (access1 = ci->access, i = 0; i < check; ++access1, ++i) {
              if (13 == access1->level) {
                  free(access1->name);
		  if (access1->adder)
	                  free(access1->adder);
                  access1->name = NULL;
                  access1->adder = NULL;
                  access1->in_use = 0;
		  ci->accesscount--;
                  ++f;
              }
        }
//        ci->accesscount = 0;
        if (!(f > 0))
            notice(s_ChanServ, source,
               "No enteries found in the CFOUNDER list on \2%s\2",
                chan);

        else {
//           free(ci->access);
//           ci->access = NULL;
           if (!ci->accesscount) {
                 free(ci->access);
                 ci->access = NULL;
           }
           notice(s_ChanServ, source,
               "%d enter%s in the CFOUNDER list on \2%s\2 removed",
                f, f==1 ? "y" : "ies", chan);
           show_next_db(source, s_ChanServ);
       }
       f=0;
    } else {
        notice(s_ChanServ, source,
                "Syntax: \2CFOUNDER\2 %s [ADD|DEL|LIST|WIPE|CLEAN] [<nick>]\2",chan);
        notice(s_ChanServ, source,
                "\2/msg %s HELP SOP\2 for more information.", s_ChanServ);
    }
}

static void do_avoice(const char *source)
{
    const char *chan = strtok(NULL, " ");
    const char *cmd  = strtok(NULL, " ");
    const char *nick = strtok(NULL, " ");
    char *s    = "1", *d;
    ChannelInfo *ci;
    NickInfo *ni;
    User *u;
    short ulev;
    int is_list = (cmd && !stricmp(cmd, "LIST"));
    int is_selfdel = 0;
    ChanAccess *access1;
    int i, f=0, z;

    if (!cmd || ((!stricmp(cmd, "LIST") == 0) && (!stricmp(cmd, "WIPE") == 0)
             && (!stricmp(cmd, "CLEAN") == 0) && !nick)) {
         notice(s_ChanServ, source,
           "Syntax: \2VOP\2 <#channel> [ADD|DEL|LIST|WIPE|CLEAN] [<nick>]");
         return;
    }

    if (!(u = finduser(source))) {
        notice(s_ChanServ, source, toknmsg[26], chan);
        log("%s: ACCESS command from nonexistent user %s", s_ChanServ, source);
    }

    if (!(ci = cs_findchan(chan))) {
        notice(s_ChanServ, source, "Channel %s is not registered.", chan);
	return;
    }

    if (cmd && nick && !stricmp(cmd, "DEL") && !stricmp(source, nick)) {
	is_selfdel = 1;
    }

    if (5 >= (ulev = get_access(u, ci))) {
	if (!ulev) {
	        notice(s_ChanServ, source, toknmsg[26], chan);
		return;
	} else if (!is_selfdel && !is_list) {
	        notice(s_ChanServ, source, toknmsg[26], chan);
		return;
	}
    }

    if (stricmp(cmd, "LIST") == 0) {
	unsigned int j=0, k=0;
        if (check_access(u, ci, CA_AKICK))
                k=1;
        notice(s_ChanServ, source, "VOP list for \2%s\2:", chan);
        for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
            if ((nick && !match_wild(nick, access1->name)) ||
                                        (3 != access1->level))
                continue;
	     ni = findnick(access1->name);
            if (ni)
                s = ni->last_usermask;
            else
                s = NULL;

            if (access1->adder && (k==1))
                d = access1->adder;
            else
                d = NULL;

	    ++j;
            notice(s_ChanServ, source, " %d)  %s%s%s%s (%s)",
                        j, access1->name,
                        s ? " (" : "", s ? s : "", s ? ")" : "", d?d:"");
        }
        notice(s_ChanServ,source,"End of List");
    } else if (stricmp(cmd, "ADD") == 0) {
        ni = findnick(nick);
        if (!ni) {
           	notice(s_ChanServ, source, "Nick %s is not registered.", nick);
            	return;
        }

        if (ni && ni->forbid) {
           notice(s_ChanServ, source, "Forbidden nick %s not permitted to be added to channel access lists", ni->nick);
           return;
        }

        if (ni->flags & NI_FREEZE) {
           notice(s_ChanServ, source, "Frozen nick %s not permitted to be added to channel access lists", ni->nick);
           return;
        }
	if (ni->flags & NI_AUTH) {
		do_addauth(who_access(finduser(source), ci), nick, chan, 2);
		notice(s_ChanServ, source, "Authorize have been request to nick %s", ni->nick);
		return;
	}
        for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {

            if (access1->in_use && stricmp(access1->name, nick) == 0) {
	        if (ulev <= access1->level) {
        	    notice(s_ChanServ, source, toknmsg[26], chan);
		    return;
	        }
                if (access1->level == 3) {
                    notice(s_ChanServ, source,
                        "\2%s\2 is already an Auto-Voice on \2%s\2.",
                        access1->name, chan);
                    return;
                }
                
                if (ni && (ni->flags & NI_NOOP)) {
                    notice(s_ChanServ, source, "Since %s is already on the %s access list, regardless of NOOP setting, adding to VOP list",
                       ni->nick, chan);
		    if (finduser(ni->nick))
		    if (ni->flags & NI_IDENTIFIED) 
		        notice(s_ChanServ, ni->nick, "\2%s\2 tried to added you as a VOP in channel \2%s\2.", source, chan);
		}

                else {
                	if (access1->level == 4) {
                    	notice(s_ChanServ, source,
             	"\2%s\2 has been moved from the HOP to the VOP list of \2%s\2.",
                        	access1->name, chan);
	                } else if (access1->level == 5) {
                    	notice(s_ChanServ, source,
             	"\2%s\2 has been moved from the AOP to the VOP list of \2%s\2.",
                        	access1->name, chan);
	                } else if (access1->level == 10) {
                    	notice(s_ChanServ, source,
             	"\2%s\2 has been moved from the SOP to the VOP list of \2%s\2.",
                        	access1->name, chan);
	                } else if (access1->level == 13) {
                    	notice(s_ChanServ, source,
             	"\2%s\2 has been moved from the CFOUNDER to the VOP list of \2%s\2.",
                        	access1->name, chan);
			} else 
		        notice(s_ChanServ, source,
                        "\2%s\2 was changed to an VOP on \2%s\2.",
                        access1->name, chan);
                access1->level = 3;
		if (access1->adder)
			free(access1->adder);
		access1->adder = sstrdup(addedby(ci,source));
		if (ci->botflag & CBI_VERBOSE)
		opnotice (s_ChanServ, chan, "[VERBOSE] %s added %s to the VOP list.", source, access1->name);
		if (ni->flags & NI_IDENTIFIED) {
			do_lautoop(access1->name, chan, access1->level);
		        notice(s_ChanServ, ni->nick, "\2%s\2 added you as VOP in channel \2%s\2.", source, chan);
		}
	     }
                show_next_db(source, s_ChanServ);
                return;
            }
        }
        if ((CHAN_ACCESS_MAX > 0) && (ci->accesscount > CHAN_ACCESS_MAX-1)) {
	    notice(s_ChanServ, source,
                    "Sorry, you may only have %d channel access enteries.",
                    CHAN_ACCESS_MAX);
            wallops(s_ChanServ, "%s tried to add another nick to the access list on %s",
                   source, chan);
	    return;
	}
        if (ni && (ni->flags & NI_NOOP)) {
             notice(s_ChanServ, source, "Sorry, %s has the NOOP Option set",
                       ni->nick);
	    if (finduser(ni->nick))
	    if (ni->flags & NI_IDENTIFIED) 
	        notice(s_ChanServ, ni->nick, "\2%s\2 tried to added you as a VOP in channel \2%s\2.", source, chan);
             return;
        }

        for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
            if (!access1->in_use)
                break;
        }
        if (i == ci->accesscount) {
            ++ci->accesscount;
            ci->access =
                srealloc(ci->access, sizeof(ChanAccess) * ci->accesscount);
            access1 = &ci->access[ci->accesscount-1];
        }
        access1->name = sstrdup(ni->nick);
	access1->adder = sstrdup(addedby(ci,source));
        access1->in_use = 1;
        access1->accflag = 0;
        access1->level = 3;
        notice(s_ChanServ, source,
                "\2%s\2 has been added to the VOP list of \2%s\2.",
                access1->name, chan);
        show_next_db(source, s_ChanServ);
	if (ni->flags & NI_IDENTIFIED) {
		do_lautoop(access1->name, chan, access1->level);
	        notice(s_ChanServ, ni->nick, "\2%s\2 added you as VOP in channel \2%s\2.", source, chan);
	}
	if (ci->botflag & CBI_VERBOSE)
		opnotice (s_ChanServ, chan, "[VERBOSE] %s added %s to the VOP list.", source, access1->name);

    } else if (stricmp(cmd, "DEL") == 0) {

        if (readonly) {
            notice(s_ChanServ, source,
                "Sorry, channel access list modification is temporarily disabled");
            return;
        }

        /* Special case: is it a number?  Only do search if it isn't. */

        if (isNum(nick) && (i = atoi(nick)) > 0 && i <= ci->accesscount) {
            int j=0;
            for (access1 = ci->access, z = 0; z < ci->accesscount;
                        ++access1, ++z) {
                if (!(3 == access1->level))
                    continue;
                j += 1;
                if (i == j) {
                    access1 = &ci->access[z];
                    break;
                }
            }
            if (!(i == j)) {
                notice(s_ChanServ, source,
                        "No such entry (#%d) on %s access list.", i, chan);
                return;
            }
        } else {
            for (access1 = ci->access, z = 0; z < ci->accesscount;
                                                        ++access1, ++z) {
                if ((stricmp(access1->name, nick) == 0)
                        && (access1->level == 3))
                    break;
            }
            if (z == ci->accesscount) {
                notice(s_ChanServ, source,
                        "\2%s\2 not found on %s VOP list.", nick, chan);
                return;
            }
        }
        if (ulev <= access1->level && !is_selfdel) {
            notice(s_ChanServ, source, toknmsg[26], chan);
        } else {
            notice(s_ChanServ, source,
	  "\2%s\2 has been removed from the VOP list of %s.", access1->name, chan);

            if (ci->botflag & CBI_VERBOSE)
                opnotice (s_ChanServ, chan, "[VERBOSE] %s removed %s from the VOP list.", source, access1->name);

            show_next_db(source, s_ChanServ);
            free(access1->name);
	    if(access1->adder)
	            free(access1->adder);
            access1->in_use = 0;
            access1->name = NULL;
            access1->adder = NULL;
              --ci->accesscount;
              if (z < ci->accesscount)
		memmove(access1, access1+1, sizeof(ChanAccess) * (ci->accesscount-z));
            if (!ci->accesscount) {
                 free(ci->access);
                 ci->access = NULL;
            }
        }


    } else if (stricmp(cmd, "CLEAN") == 0) {
        int check = 0;
        check = ci->accesscount;
        for (access1 = ci->access, i = 0; i < check; ++access1, ++i) {
              if ((3 == access1->level) && (!strchr(access1->name, '@'))
                 && (!findnick(access1->name))) {
                     free(access1->name);
		     if (access1->adder)
	                     free(access1->adder);
                     access1->name = NULL;
                     access1->adder = NULL;
                     access1->in_use = 0;
                     ++f;
                     --ci->accesscount;
                     if ((i-f) < ci->accesscount)
			memmove(access1, access1+1, sizeof(ChanAccess) * (ci->accesscount - (i-f)));
                     --access1;
              }
        }
        if (!(f > 0))
            notice(s_ChanServ, source,
               "No Expired nicknames found in the VOP list on \2%s\2",
                chan);
        else {
            if (!ci->accesscount) {
                 free(ci->access);
                 ci->access = NULL;
            }
           notice(s_ChanServ, source,
               "%d expired nicknames in the VOP list on \2%s\2 removed",
                f, chan);
            if (ci->botflag & CBI_VERBOSE)
	            opnotice (s_ChanServ, chan, "[VERBOSE] %s clean the VOP list.", source);
           show_next_db(source, s_ChanServ);
       }
       f=0;


    } else if (stricmp(cmd, "WIPE") == 0) {
        int check = 0;
        check = ci->accesscount;
        for (access1 = ci->access, i = 0; i < check; ++access1, ++i) {
              if (3 == access1->level) {
                  free(access1->name);
 		  if (access1->adder)
	                  free(access1->adder);
                  access1->name = NULL;
                  access1->adder = NULL;
                  access1->in_use = 0;
		  ci->accesscount--;
                  ++f;
              }
        }
//	ci->accesscount = 0;
        if (!(f > 0))
            notice(s_ChanServ, source,
               "No enteries found in the VOP list on \2%s\2",
                chan);

        else {
//	   free(ci->access);
//	   ci->access = NULL;
           if (!ci->accesscount) {
                 free(ci->access);
                 ci->access = NULL;
           }
           notice(s_ChanServ, source,
               "%d entr%s in the VOP list on \2%s\2 removed",
                f, f==1 ? "y" : "ies", chan);
           show_next_db(source, s_ChanServ);
       }
       f=0;

    } else {

        notice(s_ChanServ, source,
                "Syntax: \2VOP\2 %s [ADD|DEL|LIST|WIPE|CLEAN] [<nick>]",chan);
        notice(s_ChanServ, source,
                "\2/msg %s HELP VOP\2 for more information.", s_ChanServ);
    }
}
#ifdef DEFHALFOP
static void do_hop(const char *source)
{
    const char *chan = strtok(NULL, " ");
    const char *cmd  = strtok(NULL, " ");
    const char *nick = strtok(NULL, " ");
    char *s    = "1", *d;
    ChannelInfo *ci;
    NickInfo *ni;
    User *u;
    short ulev;
    int is_list = (cmd && !stricmp(cmd, "LIST"));
    int is_selfdel = 0;
    ChanAccess *access1;
    int i, f=0, z;

    if (!cmd || ((!stricmp(cmd, "LIST") == 0) && (!stricmp(cmd, "WIPE") == 0)
             && (!stricmp(cmd, "CLEAN") == 0) && !nick)) {
         notice(s_ChanServ, source,
           "Syntax: \2HOP\2 <#channel> [ADD|DEL|LIST|WIPE|CLEAN] [<nick>]");
         return;
    }

    if (!(ci = cs_findchan(chan))) {
        notice(s_ChanServ, source, "Channel %s is not registered.", chan);
	return;
    }
    if (!(u = finduser(source))) {
        notice(s_ChanServ, source, toknmsg[26], chan);     
	log("%s: ACCESS command from nonexistent user %s", s_ChanServ, source);
    }
    if (cmd && nick && !stricmp(cmd, "DEL") && !stricmp(source, nick)) {
        is_selfdel = 1;
    }
    if (5 >= (ulev = get_access(u, ci))) {
        if (!ulev) {
                notice(s_ChanServ, source, toknmsg[26], chan);
                return;
        } else if (!is_selfdel && !is_list) {
                notice(s_ChanServ, source, toknmsg[26], chan);
                return;
        }
    }
    if (stricmp(cmd, "LIST") == 0) {
	unsigned int j=0, k=0;
        if (check_access(u, ci, CA_AKICK))
                k=1;
        notice(s_ChanServ, source, "HOP list for \2%s\2:", chan);
        for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
            if ((nick && !match_wild(nick, access1->name)) ||
                                        (4 != access1->level))
                continue;
	    ni = findnick(access1->name);
            if (ni)
                s = ni->last_usermask;
            else
                s = NULL;

            if (access1->adder && (k==1))
                d = access1->adder;
            else
                d = NULL;


	    ++j;
            notice(s_ChanServ, source, " %d)  %s%s%s%s (%s)",
                        j, access1->name,
                        s ? " (" : "", s ? s : "", s ? ")" : "", d?d:"");
        }
        notice(s_ChanServ,source,"End of List");

    } else if (stricmp(cmd, "ADD") == 0) {
        if (readonly) {
            notice(s_ChanServ, source,
                "Sorry, channel access list modification is temporarily disabled");
            return;
        }
        ni = findnick(nick);
        if (!ni) {
           	 notice(s_ChanServ, source, "Nick %s is not registered.", nick);
             	 return;
        }
        if (ni && ni->forbid) {
           notice(s_ChanServ, source, "Forbidden nick %s not permitted to be added to channel access lists", ni->nick);
           return;
        }

        if (ni->flags & NI_FREEZE) {
           notice(s_ChanServ, source, "Frozen nick %s not permitted to be added to channel access lists", ni->nick);
           return;
        }
	if (ni->flags & NI_AUTH) {
		do_addauth(who_access(finduser(source), ci), nick, chan, 3);
		notice(s_ChanServ, source, "Authorize have been request to nick %s", ni->nick);
		return;
	}
        for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
            if (access1->in_use && stricmp(access1->name, nick) == 0) {
	        if (ulev <= access1->level) {
        	    notice(s_ChanServ, source, toknmsg[26], chan);
		    return;
	        }
                if (access1->level == 4) {
                    notice(s_ChanServ, source,
                        "\2%s\2 is already an Auto-Halfop on \2%s\2.",
                        access1->name, chan);
                    return;
                }

                if (ni && (ni->flags & NI_NOOP)) {
                    notice(s_ChanServ, source, "Since %s is already on the %s access list, regardless of NOOP setting, adding to HOP list",
                       ni->nick, chan);
		    if (finduser(ni->nick))
		    if (ni->flags & NI_IDENTIFIED) 
		        notice(s_ChanServ, ni->nick, "\2%s\2 tried to added you as an HOP in channel \2%s\2.", source, chan);
		}
                else {
                	if (access1->level == 3) {
                    	notice(s_ChanServ, source,
              	"\2%s\2 has been moved from the VOP to the HOP list of \2%s\2.",
                        	access1->name, chan);
	                } else if (access1->level == 5) {
                    	notice(s_ChanServ, source,
              	"\2%s\2 has been moved from the AOP to the HOP list of \2%s\2.",
                        	access1->name, chan);
	                } else if (access1->level == 10) {
                    	notice(s_ChanServ, source,
              	"\2%s\2 has been moved from the SOP to the HOP list of \2%s\2.",
                        	access1->name, chan);
	                } else if (access1->level == 13) {
                    	notice(s_ChanServ, source,
              	"\2%s\2 has been moved from the CFOUNDER to the HOP list of \2%s\2.",
                        	access1->name, chan);
			} else 
                   notice(s_ChanServ, source,
                        "\2%s\2 was changed to an HOP on \2%s\2.",
                        access1->name, chan);
                access1->level = 4;
		if (access1->adder)
			free(access1->adder);
		access1->adder = sstrdup(addedby(ci,source));
		if (ci->botflag & CBI_VERBOSE)
		opnotice (s_ChanServ, chan, "[VERBOSE] %s added %s to the HOP list.", source, access1->name);
		if (ni->flags & NI_IDENTIFIED) {
			do_lautoop(access1->name, chan, access1->level);
	        	notice(s_ChanServ, ni->nick, "\2%s\2 added you as HOP in channel \2%s\2.", source, chan);
		}
	      }
                show_next_db(source, s_ChanServ);
                return;
            }
        }

        if ((CHAN_ACCESS_MAX > 0) && (ci->accesscount > CHAN_ACCESS_MAX-1)) {
	    notice(s_ChanServ, source,
                    "Sorry, you may only have %d channel access enteries.",
                    CHAN_ACCESS_MAX);
            wallops(s_ChanServ, "%s tried to add another nick to the access list on %s",
                   source, chan);
	    return;
	}
        if (ni && (ni->flags & NI_NOOP)) {
             notice(s_ChanServ, source, "Sorry, %s has the NOOP Option set",
                       ni->nick);
	    if (finduser(ni->nick))
	    if (ni->flags & NI_IDENTIFIED) 
	        notice(s_ChanServ, ni->nick, "\2%s\2 tried to added you as an HOP in channel \2%s\2.", source, chan);
             return;
        }

        for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
            if (!access1->in_use)
                break;
        }
        if (i == ci->accesscount) {
            ++ci->accesscount;
            ci->access =
                srealloc(ci->access, sizeof(ChanAccess) * ci->accesscount);
            access1 = &ci->access[ci->accesscount-1];
        }
        access1->name = sstrdup(ni->nick);
	access1->adder = sstrdup(addedby(ci,source));
        access1->in_use = 1;
        access1->accflag = 0;
        access1->level = 4;
        notice(s_ChanServ, source,
                "\2%s\2 has been added to the HOP list of \2%s\2.",
                access1->name, chan);
        show_next_db(source, s_ChanServ);

	if (ni->flags & NI_IDENTIFIED) {
		do_lautoop(access1->name, chan, access1->level);
	        notice(s_ChanServ, ni->nick, "\2%s\2 added you as HOP in channel \2%s\2.", source, chan);
	}
	if (ci->botflag & CBI_VERBOSE)
		opnotice (s_ChanServ, chan, "[VERBOSE] %s added %s to the HOP list.", source, access1->name);
    } else if (stricmp(cmd, "DEL") == 0) {

        if (readonly) {
            notice(s_ChanServ, source,
                "Sorry, channel access list modification is temporarily disabled");
            return;
        }
        /* Special case: is it a number?  Only do search if it isn't. */
        if (isNum(nick) && (i = atoi(nick)) > 0 && i <= ci->accesscount) {
            int j=0;
            for (access1 = ci->access, z = 0; z < ci->accesscount;
                        ++access1, ++z) {
                if (!(4 == access1->level))
                    continue;
                j += 1;
                if (i == j) {
                    access1 = &ci->access[z];
                    break;
                }
            }
            if (!(i == j)) {
                notice(s_ChanServ, source,
                        "No such entry (#%d) on %s access list.", i, chan);
                return;
            }
        } else {
            for (access1 = ci->access, z = 0; z < ci->accesscount;
                                                        ++access1, ++z) {
                if ((stricmp(access1->name, nick) == 0)
                        && (access1->level == 4))
                    break;
            }
            if (z == ci->accesscount) {
                notice(s_ChanServ, source,
                        "\2%s\2 not found on %s HOP list.", nick, chan);
                return;
            }
        }
        if (ulev <= access1->level && !is_selfdel) {
            notice(s_ChanServ, source, toknmsg[26], chan);
        } else {
            notice(s_ChanServ, source,
	  "\2%s\2 has been removed from the HOP list of %s.", access1->name, chan);
            if (ci->botflag & CBI_VERBOSE)
                opnotice (s_ChanServ, chan, "[VERBOSE] %s removed %s from the HOP list.", source, access1->name);
            show_next_db(source, s_ChanServ);
            free(access1->name);
	    if (access1->adder)
	            free(access1->adder);
            access1->in_use = 0;
            access1->name = NULL;
            access1->adder = NULL;
              --ci->accesscount;
              if (z < ci->accesscount)
		memmove(access1, access1+1, sizeof(ChanAccess) * (ci->accesscount-z));
            if (!ci->accesscount) {
                 free(ci->access);
                 ci->access = NULL;
            }
        }
    } else if (stricmp(cmd, "CLEAN") == 0) {
        int check = 0;
        check = ci->accesscount;
        for (access1 = ci->access, i = 0; i < check; ++access1, ++i) {
              if ((4 == access1->level) && (!strchr(access1->name, '%'))
                 && (!findnick(access1->name))) {
                     free(access1->name);
		     if (access1->adder)
	                     free(access1->adder);
                     access1->name = NULL;
                     access1->adder = NULL;
                     access1->in_use = 0;
                     ++f;
                     --ci->accesscount;
                     if ((i-f) < ci->accesscount)
			memmove(access1, access1+1, sizeof(ChanAccess) * (ci->accesscount - (i-f)));
                     --access1;
              }
        }
        if (!(f > 0))
            notice(s_ChanServ, source,
               "No Expired nicknames found in the HOP list on \2%s\2",
                chan);
        else {
           if (!ci->accesscount) {
                 free(ci->access);
                 ci->access = NULL;
           }
           notice(s_ChanServ, source,
               "%d expired nicknames in the HOP list on \2%s\2 removed",
                f, chan);
           show_next_db(source, s_ChanServ);
       }
       f=0;


    } else if (stricmp(cmd, "WIPE") == 0) {
        int check = 0;
        check = ci->accesscount;
        for (access1 = ci->access, i = 0; i < check; ++access1, ++i) {
              if (4 == access1->level) {
                  free(access1->name);
		  if (access1->adder)
	                  free(access1->adder);
                  access1->name = NULL;
                  access1->adder = NULL;
                  access1->in_use = 0;
		  ci->accesscount--;
                  ++f;
              }
        }
//	ci->accesscount = 0;
        if (!(f > 0))
            notice(s_ChanServ, source,
               "No enteries found in the HOP list on \2%s\2",
                chan);

        else {
           if (!ci->accesscount) {
                 free(ci->access);
                 ci->access = NULL;
           }
//           free(ci->access);
//           ci->access = NULL;
           notice(s_ChanServ, source,
               "%d entr%s in the HOP list on \2%s\2 removed",
                f, f==1 ? "y" : "ies", chan);
           show_next_db(source, s_ChanServ);
       }
       f=0;


    } else {

        notice(s_ChanServ, source,
                "Syntax: \2HOP\2 %s [ADD|DEL|LIST|WIPE|CLEAN] [<nick>]",chan);
        notice(s_ChanServ, source,
                "\2/msg %s HELP HOP\2 for more information.", s_ChanServ);
    }
}

#endif

static void do_sop(const char *source)
{
    const char *chan = strtok(NULL, " ");
    const char *cmd  = strtok(NULL, " ");
    const char *nick = strtok(NULL, " ");
    char *s    = "1", *d;
    ChannelInfo *ci;
    NickInfo *ni;
    User *u;
    short ulev;
    int is_list = (cmd && !stricmp(cmd, "LIST"));
    int is_selfdel = 0;
    ChanAccess *access1;
    int i, f=0, z;

    if (!cmd || ((!stricmp(cmd, "LIST") == 0) && (!stricmp(cmd, "WIPE") == 0)
             && (!stricmp(cmd, "CLEAN") == 0) && !nick)) {
         notice(s_ChanServ, source,
           "Syntax: \2SOP\2 <#channel> [ADD|DEL|LIST|WIPE|CLEAN] [<nick>]");
         return;
    }

    if (!(ci = cs_findchan(chan))) {
        notice(s_ChanServ, source, "Channel %s is not registered.", chan);
	return;
    }
    if (!(u = finduser(source))) {
        notice(s_ChanServ, source, toknmsg[26], chan);
        log("%s: ACCESS command from nonexistent user %s", s_ChanServ, source);
    }
    if (cmd && nick && !stricmp(cmd, "DEL") && !stricmp(source, nick)) {
        is_selfdel = 1;
    }
    if (10 >= (ulev = get_access(u, ci))) {
        if (!ulev) {
                notice(s_ChanServ, source, toknmsg[26], chan);
                return;
        } else if (!is_selfdel && !is_list) {
                notice(s_ChanServ, source, toknmsg[26], chan);
                return;
        }
    }

    if (stricmp(cmd, "LIST") == 0) {
	unsigned int j=0, k=0;
        if (check_access(u, ci, CA_AKICK))
                k=1;
        notice(s_ChanServ, source, "SOP list for \2%s\2:", chan);
        for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
            if ((nick && !match_wild(nick, access1->name)) ||
                                        (10 != access1->level))
                continue;
	    ni = findnick(access1->name);
            if (ni)
                s = ni->last_usermask;
            else
                s = NULL;

            if (access1->adder && (k==1))
                d = access1->adder;
            else
                d = NULL;

	    ++j;
            notice(s_ChanServ, source, " %d)  %s%s%s%s (%s)",
                        j, access1->name,
                        s ? " (" : "", s ? s : "", s ? ")" : "", d?d:"");
        }
        notice(s_ChanServ,source,"End of List");

    } else if (stricmp(cmd, "ADD") == 0) {
        if (readonly) {
            notice(s_ChanServ, source,
                "Sorry, channel access list modification is temporarily disabled");
            return;
        }
        ni = findnick(nick);
        if (!ni) {
           	notice(s_ChanServ, source, "Nick %s is not registered.", nick);
            	return;
        }

        if (ni && ni->forbid) {
           notice(s_ChanServ, source, "Forbidden nick %s not permitted to be added to channel access lists", ni->nick);
           return;
        }

        if (ni->flags & NI_FREEZE) {
           notice(s_ChanServ, source, "Frozen nick %s not permitted to be added to channel access lists", ni->nick);
           return;
        }
	if (ni->flags & NI_AUTH) {
		do_addauth(who_access(finduser(source), ci), nick, chan, 5);
		notice(s_ChanServ, source, "Authorize have been request to nick %s", ni->nick);
		return;
	}
        for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1,++i) {
            if (access1->in_use && stricmp(access1->name, nick) == 0) {
	        if (ulev <= access1->level) {
	            notice(s_ChanServ, source, toknmsg[26], chan);
		    return;
	        }
                if (access1->level == 10) {
                    notice(s_ChanServ, source,
                        "\2%s\2 is already a SOP on \2%s\2.",
                        access1->name, chan);
                    return;
                }
                if (ni && (ni->flags & NI_NOOP)) {
                    notice(s_ChanServ, source, "Since %s is already on the %s access list, regardless of NOOP setting, adding to SOP list",
                       ni->nick, chan);
		    if (finduser(ni->nick))
		    if (ni->flags & NI_IDENTIFIED) 
		        notice(s_ChanServ, ni->nick, "\2%s\2 tried to added you as a SOP in channel \2%s\2.", source, chan);
		}
                else {
                	if (access1->level == 3) {
                    	notice(s_ChanServ, source,
              	"\2%s\2 has been moved from the VOP to the SOP list of \2%s\2.",
                        	access1->name, chan);
	                } else if (access1->level == 5) {
                    	notice(s_ChanServ, source,
              	"\2%s\2 has been moved from the AOP to the SOP list of \2%s\2.",
                        	access1->name, chan);
	                } else if (access1->level == 4) {
                    	notice(s_ChanServ, source,
              	"\2%s\2 has been moved from the HOP to the SOP list of \2%s\2.",
                        	access1->name, chan);
	                } else if (access1->level == 13) {
                    	notice(s_ChanServ, source,
              	"\2%s\2 has been moved from the CFOUNDER to the SOP list of \2%s\2.",
                        	access1->name, chan);
			} else 
                    notice(s_ChanServ, source,
                        "\2%s\2 was changed to a SOP on \2%s\2.",
                        access1->name, chan);
	        access1->level = 10;
		if (access1->adder)
			free(access1->adder);
		access1->adder = sstrdup(addedby(ci,source));
		if (ci->botflag & CBI_VERBOSE)
		opnotice (s_ChanServ, chan, "[VERBOSE] %s added %s to the SOP list.", source, access1->name);
		if (ni->flags & NI_IDENTIFIED) {
			do_lautoop(access1->name, chan, access1->level);
		        notice(s_ChanServ, ni->nick, "\2%s\2 added you as SOP in channel \2%s\2.", source, chan);
		}
	      }
                show_next_db(source, s_ChanServ);
                return;
            }
        }
        if ((CHAN_ACCESS_MAX > 0) && (ci->accesscount > CHAN_ACCESS_MAX-1)) {
	    notice(s_ChanServ, source,
                    "Sorry, you may only have %d channel access enteries.",
                    CHAN_ACCESS_MAX);
            wallops(s_ChanServ, "%s tried to add another nick to the access list on %s",
                   source, chan);
	    return;
	}
        if (ni && (ni->flags & NI_NOOP)) {
             notice(s_ChanServ, source, "Sorry, %s has the NOOP option set.", ni->nick);
	    if (finduser(ni->nick))
	    if (ni->flags & NI_IDENTIFIED) 
	        notice(s_ChanServ, ni->nick, "\2%s\2 tried to added you as a SOP in channel \2%s\2.", source, chan);
             return;
        }
        for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
            if (!access1->in_use)
                break;
        }
        if (i == ci->accesscount) {
            ++ci->accesscount;

            ci->access =
                srealloc(ci->access, sizeof(ChanAccess) * ci->accesscount);
            access1 = &ci->access[ci->accesscount-1];
        }

        access1->name = sstrdup(ni->nick);
        access1->adder = sstrdup(addedby(ci,source));
        access1->in_use = 1;
        access1->accflag = 0;
        access1->level = 10;

        notice(s_ChanServ, source,
                "\2%s\2 has been added to the SOP list of \2%s\2.",
                access1->name, chan);
        show_next_db(source, s_ChanServ);

	if (ni->flags & NI_IDENTIFIED) {
		do_lautoop(access1->name, chan, access1->level);
	        notice(s_ChanServ, ni->nick, "\2%s\2 added you as SOP in channel \2%s\2.", source, chan);
	}
	if (ci->botflag & CBI_VERBOSE)
		opnotice (s_ChanServ, chan, "[VERBOSE] %s added %s to the SOP list.", source, access1->name);

    } else if (stricmp(cmd, "DEL") == 0) {

        if (readonly) {
            notice(s_ChanServ, source,
                "Sorry, channel access list modification is temporarily disabled");
            return;
        }
        /* Special case: is it a number?  Only do search if it isn't. */
        if (isNum(nick) && (i = atoi(nick)) > 0 && i <= ci->accesscount) {
            int j=0;
            for (access1 = ci->access, z = 0; z < ci->accesscount;
                        ++access1, ++z) {
                if (!(10 == access1->level))
                    continue;
                j += 1;
                if (i == j) {
                    access1 = &ci->access[z];
                    break;
                }
            }
            if (!(i == j)) {
                notice(s_ChanServ, source,
                        "No such entry (#%d) on %s access list.", i, chan);
                return;
            }
        } else {
            for (access1 = ci->access, z = 0; z < ci->accesscount;
                                                        ++access1, ++z) {
                if ((stricmp(access1->name, nick) == 0)
                        && (access1->level == 10))
                    break;
            }
            if (z == ci->accesscount) {
                notice(s_ChanServ, source,
                        "\2%s\2 not found on %s SOP list.", nick, chan);
                return;
            }
        }
        if (ulev <= access1->level && !is_selfdel) {
            notice(s_ChanServ, source, toknmsg[26], chan);
        } else {
            notice(s_ChanServ, source,
                "\2%s\2 has been removed from the SOP list of %s.", access1->name, chan);
            if (ci->botflag & CBI_VERBOSE)
                opnotice (s_ChanServ, chan, "[VERBOSE] %s removed %s from the SOP list.", source, access1->name);
            show_next_db(source, s_ChanServ);
            free(access1->name);
	    if (access1->adder)
	            free(access1->adder);	
            access1->in_use = 0;
            access1->name = NULL;
            access1->adder = NULL;
              --ci->accesscount;
              if (z < ci->accesscount)
		memmove(access1, access1+1, sizeof(ChanAccess) * (ci->accesscount - z));
            if (!ci->accesscount) {
                 free(ci->access);
                 ci->access = NULL;
            }

        }
    } else if (stricmp(cmd, "CLEAN") == 0) {
        int check = 0;
        check = ci->accesscount;
        for (access1 = ci->access, i = 0; i < check; ++access1, ++i) {
              if ((10 == access1->level) && (!strchr(access1->name, '@'))
                 && (!findnick(access1->name))) {
                     free(access1->name);
		     if (access1->adder)
	                     free(access1->adder);
                     access1->name = NULL;
                     access1->adder = NULL;
                     access1->in_use = 0;
                     ++f;
                     --ci->accesscount;
                     if ((i-f) < ci->accesscount)
			memmove(access1, access1+1, sizeof(ChanAccess) * (ci->accesscount - (i-f)));
                     --access1;
              }
        }
        if (!(f > 0))
            notice(s_ChanServ, source,
               "No Expired nicknames found in the SOP list on \2%s\2",
                chan);
        else {
           if (!ci->accesscount) {
                 free(ci->access);
                 ci->access = NULL;
           }
           notice(s_ChanServ, source,
               "%d expired nicknames in the SOP list on \2%s\2 removed",
                f, chan);
           show_next_db(source, s_ChanServ);
       }
       f=0;


    } else if (stricmp(cmd, "WIPE") == 0) {
        int check = 0;
        check = ci->accesscount;
        for (access1 = ci->access, i = 0; i < check; ++access1, ++i) {
              if (10 == access1->level) {
                  free(access1->name);
		  if (access1->adder)
	                  free(access1->adder);
                  access1->name = NULL;
                  access1->adder = NULL;
                  access1->in_use = 0;
		  ci->accesscount--;
                  ++f;
              }
        }
//        ci->accesscount = 0;
        if (!(f > 0))
            notice(s_ChanServ, source,
               "No enteries found in the SOP list on \2%s\2",
                chan);
        else {
//           free(ci->access);
//           ci->access = NULL;
           if (!ci->accesscount) {
                 free(ci->access);
                 ci->access = NULL;
           }
           notice(s_ChanServ, source,
               "%d entr%s in the SOP list on \2%s\2 removed",
                f, f==1 ? "y" : "ies", chan);
           show_next_db(source, s_ChanServ);
       }
       f=0;

    } else {

        notice(s_ChanServ, source,
                "Syntax: \2SOP\2 %s [ADD|DEL|LIST|WIPE|CLEAN] [<nick>]",chan);
        notice(s_ChanServ, source,
                "\2/msg %s HELP SOP\2 for more information.", s_ChanServ);
    }
}
/*****************************************************************/
static void do_set_news(const char *source)
{
    char *chan = strtok(NULL, " ");
    char *cmd = strtok(NULL," ");
    char *cnews = strtok(NULL,"");
    User *u = finduser(source);
    char **channews;
    int z, i, j=0;
    ChannelInfo *ci;

    if (!cmd) {
	 notice(s_ChanServ, source, "Syntax: NEWS ADD/DEL/LIST <messages or number>.");
    } else if (!(ci = cs_findchan(chan))) {
         notice(s_ChanServ, source, "Channel %s is not registerd.", chan);
    } else if (ci->flags & CI_FREEZECHAN) {
         notice(s_ChanServ, source, "Channel %s is currently frozen",chan);

    } else if (stricmp(cmd, "ADD")==0) {
	if (!cnews) {
		notice(s_ChanServ, source, "Syntax: NEWS ADD/DEL/LIST <messages or number>.");
	        return;
	}
       if (strlen(cnews) > 200) {
           notice(s_ChanServ, source, "Your news is to large to handle!");
           return;
       }
      if (!check_access(u, ci, CA_AKICK)) {
           notice(s_ChanServ, source, "You need to be SOP or higher to add news!");
           return;
      }

      if ((ci->newsline > 5) && !rec_services_admin(source)) {
            notice(s_ChanServ, source,
                 "Sorry, News list full for this channel");
            return;
      }
	if (ci->botflag & CBI_VERBOSE)
		opnotice (s_ChanServ, chan, "[VERBOSE] %s added \2%s\2 into news list.", source, cnews);
        ci->newsline++;
        ci->news = srealloc(ci->news, sizeof(char *) * ci->newsline);
        ci->news[ci->newsline-1] = sstrdup(cnews);
        notice(s_ChanServ, source, "\2%s\2 added to your news list.", cnews);
        show_next_db(source, s_ChanServ);

    } else if (stricmp(cmd, "DEL") == 0) {
	if (!cnews) {
		notice(s_ChanServ, source, "Syntax: NEWS DEL <number>.");
	        return;
	}
      if (!check_access(u, ci, CA_AKICK)) {
           notice(s_ChanServ, source, "You need to be SOP or higher to delete news!");
           return;
      }
        if (isNum(cnews) && (i = atoi(cnews)) > 0 && i <= ci->newsline) {

            for (channews = ci->news, z = 0; z < ci->newsline;
                        ++channews, ++z) {
               j += 1;
               if (i == j) {
                   channews = &ci->news[z];
                   break;
               }

            }

            if (!(i == j)) {
                notice(s_ChanServ, source,
                        "No such entry (#%d) on %s news list.", i, chan);
                return;
            }
            i = z;
	} else {
	        notice(s_ChanServ, source,
        	     "No more news to delete.");
		return;
	}

        notice(s_ChanServ, source,
             "\2%s\2 deleted from your news list.", *channews);
	if (ci->botflag & CBI_VERBOSE)
		opnotice (s_ChanServ, chan, "[VERBOSE] %s removed \2%s\2 into news list.", source, *channews);
        show_next_db(source, s_ChanServ);

        free(*channews);
        --ci->newsline;
        if (i < ci->newsline) 
		memmove(channews, channews+1, (ci->newsline-i) * sizeof(char *));
        if (ci->newsline)
            ci->news = srealloc(ci->news, ci->newsline * sizeof(char *));
        else {
            free(ci->news);
            ci->news = NULL;
        }
    } else if (stricmp(cmd, "LIST") == 0) {
        notice(s_ChanServ, source, "\2News list:\2");
        for (channews = ci->news, i = 0; i < ci->newsline; ++channews, ++i) {
            notice(s_ChanServ, source, " %d)  %s", i+1, *channews);
        }
        notice(s_ChanServ, source, ERR_EOL);
    } else {
	 notice(s_ChanServ, source, "Syntax: SET NEWS ADD/DEL/LIST <messages or number>.");
    }
}
/****************************************************/
static void do_set_badwords(const char *source)
{
    char *chan = strtok(NULL, " ");
    char *cmd = strtok(NULL," ");
    char *cnews = strtok(NULL," ");
    User *u = finduser(source);
    char **channews;
    int z, i, j=0;
    ChannelInfo *ci;

    if (!cmd || !chan) {
	 notice(s_ChanServ, source, "Syntax: BADWORDS ADD/DEL/LIST <badword or number>.");
    } else if (!(ci = cs_findchan(chan))) {
	 notice(s_ChanServ, source, "Channel %s is not registerd.", chan);
    } else if (ci->flags & CI_FREEZECHAN) {
         notice(s_ChanServ, source, "Channel %s is currently frozen",chan);
    } else if (stricmp(cmd, "ADD")==0) {
	if (!cnews) {
		notice(s_ChanServ, source, "Syntax: BADWORDS  ADD/DEL/LIST <messages or number>.");
	        return;
	}
       if (strlen(cnews) > 200) {
           notice(s_ChanServ, source, "Your badwords is to large to store!");
           return;
       }
      if (!check_access(u, ci, CA_AKICK)) {
	   notice(s_ChanServ, source, "You need to be SOP or higher to add badword!");
           return;
      }
      if ((ci->badwline > 30) && !rec_services_admin(source)) {
            notice(s_ChanServ, source,
                 "Sorry, Badwords list full for this channel");
            return;
      }
	if (ci->botflag & CBI_VERBOSE)
		opnotice (s_ChanServ, chan, "[VERBOSE] %s added word \2%s\2 into channel badword list.", source, cnews);
        ci->badwline++;
        ci->badwords = srealloc(ci->badwords, sizeof(char *) * ci->badwline);
        ci->badwords[ci->badwline-1] = sstrdup(cnews);
        notice(s_ChanServ, source, "\2%s\2 added to your badwords list.", cnews);
        show_next_db(source, s_ChanServ);

    } else if (stricmp(cmd, "DEL") == 0) {
	if (!cnews) {
		notice(s_ChanServ, source, "Syntax: BADWORDS  ADD/DEL/LIST <messages or number>.");
	        return;
	}
      if (!check_access(u, ci, CA_AKICK)) {
	   notice(s_ChanServ, source, "You need to be SOP or higher to delete badword!");
           return;
      }
        if (isNum(cnews) && (i = atoi(cnews)) > 0 && i <= ci->badwline) {

            for (channews = ci->badwords, z = 0; z < ci->badwline;
                        ++channews, ++z) {
               j += 1;
               if (i == j) {
                   channews = &ci->badwords[z];
                   break;
               }

            }

            if (!(i == j)) {
                notice(s_ChanServ, source,
                        "No such entry (#%d) on %s badwords list.", i, chan);
                return;
            }
            i = z;
	} else {
           for (channews = ci->badwords, i = 0; i < ci->badwline; ++channews, ++i) {
               if (strcmp(*channews, cnews) == 0)
                    break;
           }

           if (i == ci->badwline) {
               for (channews = ci->badwords, i = 0; i < ci->badwline;
                                                     ++channews, ++i) {
               if (stricmp(*channews, cnews) == 0)
                    break;
               }
           }

           if (i == ci->badwline) {
               notice(s_ChanServ, source,
                        "\2%s\2 not found on your badwords list.", cnews);
               return;
           }
	}

	if (ci->botflag & CBI_VERBOSE)
		opnotice (s_ChanServ, chan, "[VERBOSE] %s removed \2%s\2 into channel badword list.", source, *channews);

        notice(s_ChanServ, source,
             "\2%s\2 deleted from your badwords list.", *channews);

        show_next_db(source, s_ChanServ);

        free(*channews);
        --ci->badwline;
        if (i < ci->badwline) 
		memmove (channews, channews+1, (ci->badwline-i) * sizeof(char *));
        if (ci->badwline)
            ci->badwords = srealloc(ci->badwords, ci->badwline * sizeof(char *));
        else {
            free(ci->badwords);
            ci->badwords = NULL;
        }
    } else if (stricmp(cmd, "LIST") == 0) {
      if (!check_access(u, ci, CA_ACCESS_LIST)) {
	   notice(s_ChanServ, source, "You need to be SOP or higher to delete badword!");
           return;
      }
        notice(s_ChanServ, source, "\2Badwords list:\2");
        for (channews = ci->badwords, i = 0; i < ci->badwline; ++channews, ++i) {
            notice(s_ChanServ, source, " %d)  %s", i+1, *channews);
        }
        notice(s_ChanServ, source, ERR_EOL);
    }
}
/*********************************************/
static void do_timeop(const char *source)
{
    const char *chan  = strtok(NULL, " ");
    const char *cmd  = strtok(NULL, " ");
    const char *nick = strtok(NULL, " ");
    const char *zone = strtok(NULL, " ");
    ChannelInfo *ci;
    User *u;
    int ulev, i;
    ChanAccess *access1;
    
    if (!chan || !cmd || !nick) {
        notice(s_ChanServ, source, "Syntax: TIMEOP #<channel> ADD|DEL|VIEW <nick> [1|2|3|4]", chan);
	notice(s_ChanServ, source, "You are in zone: %d", getzone());
	return;
    }

    if (stricmp(cmd,"ADD") && stricmp(cmd,"DEL") && stricmp(cmd,"VIEW")) {
        notice(s_ChanServ, source, "Syntax: TIMEOP #<channel> ADD|DEL|VIEW <nick> [1|2|3|4]", chan);
	notice(s_ChanServ, source, "You are in zone: %d", getzone());
	return;
    }

    if (!(ci = cs_findchan(chan))) {
        notice(s_ChanServ, source, "Channel %s is not registered.", chan);
	return;
    }

    if (!(u = finduser(source))) {
        notice(s_ChanServ, source, toknmsg[26], chan);
        log("%s: ACCESS command from nonexistent user %s", s_ChanServ, source);
	return;
    }

    ulev = get_access(u, ci);

    if (5 > ulev) {
        notice(s_ChanServ, source, PMD);
	return;
    }
    if (!stricmp(cmd,"ADD")) {
    for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
            if (access1->in_use && !stricmp(access1->name, nick)) {
		if (access1->level >= ulev) {
		        notice(s_ChanServ, source, PMD);
			return;
		} else {
			if (!zone) {
			        notice(s_ChanServ, source, "Zone must be: 1 2 3 or 4");
				return;
			}
			if (!stricmp(zone,"1")) {
				if (access1->accflag & ACI_ZONE1) {
				        notice(s_ChanServ, source, "Zone1 already set for this nick");				
				} else {
					access1->accflag |= ACI_ZONE1;
        notice(s_ChanServ, source, "This op will have access in time zone 0->5am");
				}
			} else if (!stricmp(zone,"2")) {
				if (access1->accflag & ACI_ZONE2) {
				        notice(s_ChanServ, source, "Zone2 already set for this nick");				
				} else {
					access1->accflag |= ACI_ZONE2;
        notice(s_ChanServ, source, "This op will have access in time zone 6am->11am");
				}
			} else if (!stricmp(zone,"3")) {
				if (access1->accflag & ACI_ZONE3) {
				        notice(s_ChanServ, source, "Zone3 already set for this nick");				
				} else {
					access1->accflag |= ACI_ZONE3;
        notice(s_ChanServ, source, "This op will have access in time zone 12->17");
				}
			} else if (!stricmp(zone,"4")) {
				if (access1->accflag & ACI_ZONE4) {
				        notice(s_ChanServ, source, "Zone4 already set for this nick");				
				} else {
					access1->accflag |= ACI_ZONE4;
        notice(s_ChanServ, source, "This op will have access in time zone 18->23");
				}
			} else {
			        notice(s_ChanServ, source, "Invalid zone");
				notice(s_ChanServ, source, "You are in zone: %d", getzone());
			}
			return;
		} /* have access */
	    } /* Found that nick */
    } /* FOR */
    } else if (!stricmp(cmd,"DEL")) {
    for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
            if (access1->in_use && !stricmp(access1->name, nick)) {
		if (access1->level >= ulev) {
		        notice(s_ChanServ, source, PMD);
			return;
		} else {
			if (!zone) {
			        notice(s_ChanServ, source, "Zone must be: 1 2 3 or 4");
				return;
			}
			if (!stricmp(zone,"1")) {
				if (!(access1->accflag & ACI_ZONE1)) {
				        notice(s_ChanServ, source, "Zone1 already unset");
				} else {
					access1->accflag &= ~ACI_ZONE1;
        notice(s_ChanServ, source, "This op will have no access at 0->5am");
				}
			} else if (!stricmp(zone,"2")) {
				if (!(access1->accflag & ACI_ZONE2)) {
				        notice(s_ChanServ, source, "Zone2 already unset");				
				} else {
					access1->accflag &= ~ACI_ZONE2;
        notice(s_ChanServ, source, "This op will have no access at 6am->11am");
				}
			} else if (!stricmp(zone,"3")) {
				if (!(access1->accflag & ACI_ZONE3)) {
				        notice(s_ChanServ, source, "Zone3 already unset");				
				} else {
					access1->accflag &= ~ACI_ZONE3;
        notice(s_ChanServ, source, "This op will have no access at 12->17");
				}
			} else if (!stricmp(zone,"4")) {
				if (!(access1->accflag & ACI_ZONE4)) {
				        notice(s_ChanServ, source, "Zone4 already unset");				
				} else {
					access1->accflag &= ~ACI_ZONE4;
        notice(s_ChanServ, source, "This op will have no access at 18->23");
				}
			} else {
			        notice(s_ChanServ, source, "Invalid zone");
			}
			return;
		} /* have access */
	    } /* Found that nick */
    } /* FOR */
    } else if (!stricmp(cmd, "VIEW")) {
    for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
            if (access1->in_use && !stricmp(access1->name, nick)) {
	        notice(s_ChanServ, source, "Have access in: %s %s %s %s",
		(access1->accflag & ACI_ZONE1)?"0->5":"",
		(access1->accflag & ACI_ZONE2)?"6->11":"",
		(access1->accflag & ACI_ZONE3)?"12->17":"",
		(access1->accflag & ACI_ZONE4)?"18->23":"");
		return;
	    }
    }
    }
}
/*********************************************/
static int isvalidzone(int accflag) {
	if (accflag == 0) {
		return 1;
	}
	if (accflag & (ACI_ZONE1 | ACI_ZONE2 | ACI_ZONE3 | ACI_ZONE4)) {
		int myzone = getzone();
		if ((accflag & ACI_ZONE1) && (myzone == 1))
			return 1;
		if ((accflag & ACI_ZONE2) && (myzone == 2))
			return 1;
		if ((accflag & ACI_ZONE3) && (myzone == 3))
			return 1;
		if ((accflag & ACI_ZONE4) && (myzone == 4))
			return 1;
		return 0;		
	} else {
		return 1;
	}
}
/*********************************************/
static void do_aop(const char *source)
{
    char *chan   = strtok(NULL, " ");
    const char *cmd  = strtok(NULL, " ");
    const char *nick = strtok(NULL, " ");
    char *s    = "1", *d;
    ChannelInfo *ci;
    NickInfo *ni;
    User *u;
    short ulev = 0;
    int is_selfdel = 0;
    int is_list = (cmd && !stricmp(cmd, "LIST"));
    ChanAccess *access1;
    int i, f=0, z;

    if (!cmd || ((!stricmp(cmd, "LIST") == 0) && (!stricmp(cmd, "WIPE") == 0)
             && (!stricmp(cmd, "CLEAN") == 0) && !nick)) {
         notice(s_ChanServ, source,
           "Syntax: \2AOP <#channel> [ADD|DEL|LIST|WIPE|CLEAN] [<nick>]");
         return;
    }

    if (!(ci = cs_findchan(chan))) {
        notice(s_ChanServ, source, "Channel %s is not registered.", chan);
	return;
    }

    if (!(u = finduser(source))) {
        notice(s_ChanServ, source, toknmsg[26], chan);
        log("%s: ACCESS command from nonexistent user %s", s_ChanServ, source);
    }

    if (cmd && nick && !stricmp(cmd, "DEL") && !stricmp(source, nick)) {
        is_selfdel = 1;
    }

    if (5 >= (ulev = get_access(u, ci))) {
        if (!ulev) {
                notice(s_ChanServ, source, toknmsg[26], chan);
                return;
        } else if (!is_selfdel && !is_list) {
                notice(s_ChanServ, source, toknmsg[26], chan);
                return;
        }
    }

    if (stricmp(cmd, "LIST") == 0) {
	unsigned int j=0, k=0;
	if (check_access(u, ci, CA_AKICK))
		k=1;
        notice(s_ChanServ, source, "AOP list for \2%s\2:", chan);
        for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
            if ((nick && !match_wild(nick, access1->name)) ||
                                        (5 != access1->level))
                continue;
	    ni = findnick(access1->name);
            if (ni)
                s = ni->last_usermask;
            else
                s = NULL;

            if (access1->adder && (k==1))
                d = access1->adder;
            else
                d = NULL;

	    ++j;
            notice(s_ChanServ, source, " %d)  %s%s%s%s (%s)",
                        j, access1->name,
                        s ? " (" : "", s ? s : "", s ? ")" : "", d?d:"");
        }

        notice(s_ChanServ,source,"End of List");

    } else if (stricmp(cmd, "ADD") == 0) {
        ni = findnick(nick);
        if (!ni) {
           notice(s_ChanServ, source, "Nick %s is not registered.", nick);
           return;
        }

        if (ni && ni->forbid) {
           notice(s_ChanServ, source, "Forbidden nick %s not permitted to be added to channel access lists", ni->nick);
           return;
        }

        if (ni->flags & NI_FREEZE) {
           notice(s_ChanServ, source, "Frozen nick %s not permitted to be added to channel access lists", ni->nick);
           return;
        }

	if (ni->flags & NI_AUTH) {
		do_addauth(who_access(finduser(source), ci), nick, chan, 4);
		notice(s_ChanServ, source, "Authorize have been request to nick %s", ni->nick);
		return;
	}

/* Looking for exist access */ 
      for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
            if (access1->in_use && stricmp(access1->name, nick) == 0) {

	        if (ulev <= access1->level) {
        	    notice(s_ChanServ, source, toknmsg[26], chan);
		    return;
	        }

                if (access1->level == 5) {
                    notice(s_ChanServ, source,
                        "\2%s\2 is already an AOP on \2%s\2.",
                        access1->name, chan);
                    return;
                }
                if (ni && (ni->flags & NI_NOOP)) {
                    notice(s_ChanServ, source, "Since %s is already on the %s access list, regardless of NOOP setting, adding to AOP list",
                       ni->nick, chan);
		    if (finduser(ni->nick))
		    if (ni->flags & NI_IDENTIFIED) 
		        notice(s_ChanServ, ni->nick, "\2%s\2 tried to added you as an AOP in channel \2%s\2.", source, chan);
		} else {
                	if (access1->level == 3) {
                    	notice(s_ChanServ, source,
              	"\2%s\2 has been moved from the VOP to the AOP list of \2%s\2.",
                        	access1->name, chan);
	                } else if (access1->level == 4) {
                    	notice(s_ChanServ, source,
              	"\2%s\2 has been moved from the HOP to the AOP list of \2%s\2.",
                        	access1->name, chan);
	                } else if (access1->level == 10) {
                    	notice(s_ChanServ, source,
              	"\2%s\2 has been moved from the SOP to the AOP list of \2%s\2.",
                        	access1->name, chan);
	                } else if (access1->level == 13) {
                    	notice(s_ChanServ, source,
              	"\2%s\2 has been moved from the CFOUNDER to the AOP list of \2%s\2.",
				access1->name, chan);
			} else 
                    notice(s_ChanServ, source,
                        "\2%s\2 was changed to an AOP on \2%s\2.",
                        access1->name, chan);

                access1->level = 5;
		if (access1->adder)
			free(access1->adder);
	        access1->adder = sstrdup(addedby(ci,source));

		if (ci->botflag & CBI_VERBOSE)
			opnotice (s_ChanServ, chan, "[VERBOSE] %s added %s to the AOP list.", source, access1->name);

		if (ni->flags & NI_IDENTIFIED) {
			do_lautoop(access1->name, chan, access1->level);
		        notice(s_ChanServ, ni->nick, "\2%s\2 added you as AOP in channel \2%s\2.", source, chan);
		}
	      } /* NOOP */
                show_next_db(source, s_ChanServ);
                return;
           }
        }

        if ((CHAN_ACCESS_MAX > 0) && (ci->accesscount > CHAN_ACCESS_MAX-1)) {
	    notice(s_ChanServ, source,
                    "Sorry, you may only have %d channel access enteries.",
                    CHAN_ACCESS_MAX);
            wallops(s_ChanServ, "%s tried to add another nick to the access list on %s",
                   source, chan);
	    return;
	}

        if (ni && (ni->flags & NI_NOOP)) {
            notice(s_ChanServ, source,
                 "Sorry, %s has the NOOP option set", ni->nick);
	    if (finduser(ni->nick))
	    if (ni->flags & NI_IDENTIFIED) 
	        notice(s_ChanServ, ni->nick, "\2%s\2 tried to added you as an AOP in channel \2%s\2.", source, chan);
             return;
        }

        for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
            if (!access1->in_use)
                break;
        }

        if (i == ci->accesscount) {
            ++ci->accesscount;
            ci->access =
                srealloc(ci->access, sizeof(ChanAccess) * ci->accesscount);
            access1 = &ci->access[ci->accesscount-1];
        }

        access1->name = sstrdup(ni->nick);

        access1->adder = sstrdup(addedby(ci,source));
        access1->in_use = 1;
        access1->accflag = 0;
        access1->level = 5;
        notice(s_ChanServ, source,
                "\2%s\2 has been added to the AOP list of \2%s\2.",
                access1->name, chan);
        show_next_db(source, s_ChanServ);

	if (ni->flags & NI_IDENTIFIED) {
		do_lautoop(access1->name, chan, access1->level);
	        notice(s_ChanServ, ni->nick, "\2%s\2 added you as AOP in channel \2%s\2.", source, chan);
	}

	if (ci->botflag & CBI_VERBOSE)
		opnotice (s_ChanServ, chan, "[VERBOSE] %s added %s to the AOP list.", source, access1->name);

    } else if (stricmp(cmd, "DEL") == 0) {

        if (readonly) {
            notice(s_ChanServ, source,
                "Sorry, channel access list modification is temporarily disabled");
            return;
        }
        /* Special case: is it a number?  Only do search if it isn't. */
        if (isNum(nick) && (i = atoi(nick)) > 0 && i <= ci->accesscount) {
            int j=0;
            for (access1 = ci->access, z = 0; z < ci->accesscount;
                        ++access1, ++z) {
                if (!(5 == access1->level))
                    continue;
                j += 1;
                if (i == j) {
                    access1 = &ci->access[z];
                    break;
                }
            }
            if (!(i == j)) {
                notice(s_ChanServ, source,
                        "No such entry (#%d) on %s access list.", i, chan);
                return;
            }
        } else {

            for (access1 = ci->access, z = 0; z < ci->accesscount;
                                                        ++access1, ++z) {
                if ((stricmp(access1->name, nick) == 0)
			&& (access1->level == 5))
                    break;
            }
            if (z == ci->accesscount) {
                notice(s_ChanServ, source,
                        "\2%s\2 not found on %s AOP list.", nick, chan);
                return;
            }
        }
        if (ulev <= access1->level && !is_selfdel) {
            notice(s_ChanServ, source, toknmsg[26], chan);
        } else {
            notice(s_ChanServ, source,
                "\2%s\2 has been removed from the AOP list of %s.", access1->name, chan);
            if (ci->botflag & CBI_VERBOSE)
                opnotice (s_ChanServ, chan, "[VERBOSE] %s removed %s from the AOP list.", source, access1->name);
            show_next_db(source, s_ChanServ);
            free(access1->name);
	    if (access1->adder)
	            free(access1->adder);
            access1->in_use = 0;
            access1->name = NULL;
            access1->adder = NULL;
              --ci->accesscount;
              if (z < ci->accesscount)
		memmove(access1, access1+1, sizeof(ChanAccess) * (ci->accesscount - z));
            if (!ci->accesscount) {
                 free(ci->access);
                 ci->access = NULL;
            }

        }


    } else if (stricmp(cmd, "CLEAN") == 0) {
        int check = 0;
        check = ci->accesscount;
        for (access1 = ci->access, i = 0; i < check; ++access1, ++i) {
              if ((5 == access1->level) && (!strchr(access1->name, '@'))
                 && (!findnick(access1->name))) {
                     free(access1->name);
		     if (access1->adder)
	                     free(access1->adder);
                     access1->name = NULL;
                     access1->adder = NULL;
                     access1->in_use = 0;
                     ++f;
                     --ci->accesscount;
                     if ((i-f) < ci->accesscount)
			memmove(access1, access1+1, sizeof(ChanAccess) * (ci->accesscount - (i-f)));
                     --access1;
              }
        }
        if (!(f > 0))
            notice(s_ChanServ, source,
               "No Expired nicknames found in the AOP list on \2%s\2",
                chan);
        else {
           if (!ci->accesscount) {
                 free(ci->access);
                 ci->access = NULL;
           }
           notice(s_ChanServ, source,
               "%d expired nicknames in the AOP list on \2%s\2 removed",
                f, chan);
           show_next_db(source, s_ChanServ);
       }
       f=0;


    } else if (stricmp(cmd, "WIPE") == 0) {
        int check = 0;
        check = ci->accesscount;
        for (access1 = ci->access, i = 0; i < check; ++access1, ++i) {
              if (5 == access1->level) {
                  free(access1->name);
		  if (access1->adder)
	                  free(access1->adder);
                  access1->name = NULL;
                  access1->adder = NULL;
                  access1->in_use = 0;
		  ci->accesscount--;
                  ++f;
              }
        }
//	ci->accesscount = 0;
        if (!(f > 0))
            notice(s_ChanServ, source,
               "No enteries found in the AOP list on \2%s\2",
                chan);

        else {
//           free(ci->access);
//           ci->access = NULL;
           if (!ci->accesscount) {
                 free(ci->access);
                 ci->access = NULL;
           }
           notice(s_ChanServ, source,
               "%d entr%s in the AOP list on \2%s\2 removed",
                f, f==1 ? "y" : "ies", chan);
           show_next_db(source, s_ChanServ);
       }
       f=0;

    } else {

        notice(s_ChanServ, source,
                "Syntax: \2AOP\2 %s [ADD|DEL|LIST|WIPE|CLEAN] [<nick>]",chan);
        notice(s_ChanServ, source,
                "\2/msg %s HELP AOP\2 for more information.", s_ChanServ);
    }
}

/*************************************************************************/

static void do_akick(const char *source)
{
    char *chan   = strtok(NULL, " ");
    char *cmd    = strtok(NULL, " ");
    char *mask   = strtok(NULL, " ");
    char *reason = strtok(NULL, "");
    char *t;
    ChannelInfo *ci;
    NickInfo *ni;
    User *u = finduser(source);
    int i, k=0;
    AutoKick *akick;

    if (!cmd || (stricmp(cmd, "LIST") != 0 &&
       stricmp(cmd, "WIPE") != 0 && !mask)) {

	notice(s_ChanServ, source,
                "Syntax: \2AKICK\2 %s [ADD|DEL|WIPE|LIST] [<nick> or <usermask>]",
                chan ? chan : "<#channel>");
	notice(s_ChanServ, source,
		"\2/msg %s HELP AKICK\2 for more information.", s_ChanServ);

    } else if (!(ci = cs_findchan(chan))) {

	notice(s_ChanServ, source, "Channel %s is not registered.", chan);

    } else if (stricmp(cmd, "LIST") == 0) {

       if (!is_oper(source) &&
        (!u || !check_access(u, ci, CA_AKICK))
             && !(stricmp(cmd, "LIST") == 0 && rec_services_admin(source))) {

           notice(s_ChanServ, source, toknmsg[26], chan);

        } else {
 
	notice(s_ChanServ, source, "AKICK list for %s:", chan);
	for (akick = ci->akick, i = 0; i < ci->akickcount; ++akick, ++i) {
	    if (mask && !match_wild(mask, akick->name))
		continue;
	    if ((ni = findnick(akick->name)) && rec_services_admin(source))
		t = ni->last_usermask;
	    else
                t = NULL;
	    notice(s_ChanServ, source, " %d)  %s%s%s%s%s%s%s",
			i+1, akick->name,
			t ? " (" : "", t ? t : "", t ? ")" : "",
			akick->reason ? " (" : "",
			akick->reason ? akick->reason : "",
			akick->reason ? ")" : "");
	}
        notice(s_ChanServ,source,"End of List");
      }

    } else if ((!u || !check_access(u, ci, CA_AKICK))
	       && !(stricmp(cmd, "LIST") == 0 && rec_services_admin(source))) {

	notice(s_ChanServ, source, toknmsg[26], chan);

    } else if (stricmp(cmd, "WIPE") == 0) {

      if (get_access(u, ci) < 13)  {
          notice(s_ChanServ, source, toknmsg[26], chan);
          return;
      }

      for (akick = ci->akick, i = 0; ci->akickcount; ++akick, ++i) {
           free(akick->name);
           if (akick->reason)
               free(akick->reason);

             ++k;
             --ci->akickcount;
             if (!ci->akickcount) {
                 free(ci->akick);
                 ci->akick = NULL;
           }
      }
	if (ci->botflag & CBI_VERBOSE)
	opnotice (s_ChanServ, chan, "[VERBOSE] %s wipe AKICK list", source);
      notice(s_ChanServ, source, "%d enteries deleted from the %s AKICK list",
         k, chan);

    } else if (stricmp(cmd, "ADD") == 0) {
	char *nick, *user, *host;
	ni = findnick(mask);

        if ((AKICK_MAX != 0) && (ci->akickcount > AKICK_MAX-1)) {
	    notice(s_ChanServ, source,
                    "Sorry, you may only have %d AutoKick masks for a channel.",
		    AKICK_MAX);
            wallops(s_ChanServ,
                 "%s tried to add another akick to %s", source, chan);
	    return;
	}

	if (!ni) {
	    split_usermask(mask, &nick, &user, &host);
	    mask = smalloc(strlen(nick) + strlen(user) + strlen(host) + 3);
	    sprintf((char *)mask, "%s!%s@%s", nick, user, host);
	    free(nick);
	    free(user);
	    free(host);
	}

	for (akick = ci->akick, i = 0; i < ci->akickcount; ++akick, ++i) {
	    if ((akick->is_nick ? stricmp(akick->name,mask) :
						strcmp(akick->name,mask)) == 0) {
		notice(s_ChanServ, source,
			"\2%s\2 already exists on %s AKICK list.",
			akick->name, chan);
		return;
	    }
	}

	++ci->akickcount;
	ci->akick = srealloc(ci->akick, sizeof(AutoKick) * ci->akickcount);
	akick = &ci->akick[ci->akickcount-1];
	akick->name = ni ? sstrdup(mask) : (char *)mask;
	akick->is_nick = (ni != NULL);
	akick->pad = 0;
	if (reason)
	    akick->reason = sstrdup(reason);
	else
	    akick->reason = NULL;
	notice(s_ChanServ, source,
		"\2%s\2 added to %s AKICK list.", akick->name, chan);
	if (ci->botflag & CBI_VERBOSE)
	opnotice (s_ChanServ, chan, "[VERBOSE] %s add %s to AKICK list", source, akick->name);
        show_next_db(source, s_ChanServ);

    } else if (stricmp(cmd, "DEL") == 0) {

	if (readonly) {
	    notice(s_ChanServ, source,
		"Sorry, channel AutoKick list modification is temporarily disabled.");
	    return;
	}

	/* Special case: is it a number?  Only do search if it isn't. */
	if (isNum(mask) && (i=atoi(mask)) > 0 && i <= ci->akickcount) {
	    --i;
	    akick = &ci->akick[i];
	} else {
	    /* First try for an exact match; then, a case-insensitive one. */
	    for (akick = ci->akick, i = 0; i < ci->akickcount; ++akick, ++i) {
		if (strcmp(akick->name, mask) == 0)
		    break;
	    }
	    if (i == ci->akickcount) {
		for (akick = ci->akick, i = 0; i < ci->akickcount; ++akick, ++i) {
		    if (stricmp(akick->name, mask) == 0)
			break;
		}
	    }
	    if (i == ci->akickcount) {
		notice(s_ChanServ, source,
			"\2%s\2 not found on %s AKICK list.", mask, chan);
		return;
	    }
	}
	notice(s_ChanServ, source,
		"\2%s\2 has been removed from the Auto Kick list of %s.", akick->name, chan);
	if (ci->botflag & CBI_VERBOSE)
	opnotice (s_ChanServ, chan, "[VERBOSE] %s delete %s from AKICK list", source, akick->name);
        show_next_db(source, s_ChanServ);
        if (readonly)
             notice(s_ChanServ, source,
                   "Database changes temporarily disabled. Changes will not be saved!");

	free(akick->name);
	if (akick->reason)
	    free(akick->reason);
	--ci->akickcount;
	if (i < ci->akickcount)
		memmove(akick, akick+1, sizeof(AutoKick) * (ci->akickcount-i));
	if (ci->akickcount)
	    ci->akick = srealloc(ci->akick, sizeof(AutoKick) * ci->akickcount);
	else {
	    free(ci->akick);
	    ci->akick = NULL;
	}

    } else {

	notice(s_ChanServ, source,
                "Syntax: \2AKICK\2 %s [ADD|DEL|LIST|WIPE] [<nick> or <usermask>]",
		chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP AKICK\2 for more information.", s_ChanServ);

    }
}

/*************************************************************************/

static void do_info(const char *source)
{
    char *chan = strtok(NULL, " ");
    char *myextra = strtok(NULL, " ");
    ChannelInfo *ci;
    Channel *chan_s;
    NickInfo *ni;
    char s[BUFSIZE], *t, *end, timebuf[64];
    time_t tbuff;   

    if (!chan) {

        notice(s_ChanServ, source, "Syntax: \2INFO\2 <#channel>");
	notice(s_ChanServ, source,
		"\2/msg %s HELP INFO\2 for more information.", s_ChanServ);

    } else if (!(ci = cs_findchan(chan))) {

	notice(s_ChanServ, source, "Channel \2%s\2 is not registered.", chan);

    } else if (ci->flags & CI_VERBOTEN) {

	notice(s_ChanServ, source,
		"Channel \2%s\2 may not be registered or used.", chan);

    } else {
	struct tm tm;

if (!myextra) {
	notice(s_ChanServ, source, "Use \2/Msg %s INFO %s ALL\2  for more details",s_ChanServ,chan);
	notice(s_ChanServ, source, " ");
}
	notice(s_ChanServ, source, "\2Info for %s\2:", chan);

	ni = findnick(ci->founder);

	if (ni) {
        t = ni->last_usermask;
	notice(s_ChanServ, source,
		"Founder    : %s%s%s%s",
			ci->founder, t ? " (" : "", t ? t : "", t ? ")" : "");
	}
	if (ci->successor)
	notice(s_ChanServ, source,
		"Successor  : %s", ci->successor);
        notice(s_ChanServ, source,
                "Mode lock  : %s%s%s%s",strlen(ci->mlock_on)?"+":"", ci->mlock_on,strlen(ci->mlock_off)?"-":"",ci->mlock_off);

	notice(s_ChanServ, source,
		"Description: %s", ci->desc);

if (myextra) {
        if (ci->welcome)
            notice(s_ChanServ, source,
                "Welcome MSG: %s", ci->welcome);
}	

	if (!ci->flags)
	    strcpy(s, "None\n");
	else {
	    int need_comma = 0;
	    static const char commastr[] = ", ";
	    end = s;
	    if (ci->flags & CI_PRIVATE) {
		end += snprintf(end, sizeof(s)-(end-s), "Private");
		need_comma = 1;
	    }
	    if (ci->flags & CI_KEEPTOPIC) {
		end += snprintf(end, sizeof(s)-(end-s), "%sTopic Retention", need_comma ? commastr : "");
		need_comma = 1;
	    }
	    if (ci->flags & CI_TOPICLOCK) {
                if (ci->topic_allow == 3)
                    end += snprintf(end, sizeof(s)-(end-s), "%sTopic Lock(+v)", need_comma ? commastr : "");
                else if (ci->topic_allow == 4)
                    end += snprintf(end, sizeof(s)-(end-s), "%sTopic Lock(+h)", need_comma ? commastr : "");
                else if (ci->topic_allow == 5)
                    end += snprintf(end, sizeof(s)-(end-s), "%sTopic Lock(A)", need_comma ? commastr : "");
                else if (ci->topic_allow == 10)
                    end += snprintf(end, sizeof(s)-(end-s), "%sTopic Lock(S)", need_comma ? commastr : "");
                else if (ci->topic_allow == 13)
                    end += snprintf(end, sizeof(s)-(end-s), "%sTopic Lock(CF)", need_comma ? commastr : "");
                else if (ci->topic_allow == 15)
                    end += snprintf(end, sizeof(s)-(end-s), "%sTopic Lock(F)", need_comma ? commastr : "");
		need_comma = 1;
	    }
	    if (ci->flags & CI_OPGUARD) {
		end += snprintf(end, sizeof(s)-(end-s), "%sOp Guard", need_comma ? commastr : "");
		need_comma = 1;
	    }
	    if (ci->botflag & CBI_HOPGUARD) {
		end += snprintf(end, sizeof(s)-(end-s), "%sHalfOp Guard", need_comma ? commastr : "");
		need_comma = 1;
	    }
	    if (ci->flags & CI_LEAVEOPS) {
		end += snprintf(end, sizeof(s)-(end-s), "%sLeaveop", need_comma ? commastr : "");
		need_comma = 1;
	    }
	    if (ci->flags & CI_RESTRICTED) {
		end += snprintf(end, sizeof(s)-(end-s), "%sRestricted Access", need_comma ? commastr : "");
		need_comma = 1;
	    }
	    if (ci->flags & CI_IDENT) {
		end += snprintf(end, sizeof(s)-(end-s), "%sIdent", need_comma ? commastr : "");
		need_comma = 1;
	    }
	    if (ci->flags & CI_AUTOOP) {
		end += snprintf(end, sizeof(s)-(end-s), "%s+o", need_comma ? commastr : "");
		need_comma = 1;
	    }
	    if (ci->flags & CI_AUTOVOP) {
		end += snprintf(end, sizeof(s)-(end-s), "%s+v", need_comma ? commastr : "");
		need_comma = 1;
	    }
	    if (ci->flags & CI_AUTOHOP) {
		end += snprintf(end, sizeof(s)-(end-s), "%s+h", need_comma ? commastr : "");
		need_comma = 1;
	    }
	    if (ci->botflag & CBI_VERBOSE) {
		end += snprintf(end, sizeof(s)-(end-s), "%sVerbose", need_comma ? commastr : "");
		need_comma = 1;
	    }
	    if (ci->botflag & CBI_BADNICK) {
		end += snprintf(end, sizeof(s)-(end-s), "%sBadnick", need_comma ? commastr : "");
		need_comma = 1;
	    }
	    if (ci->botflag & CBI_BADCHAN) {
		end += snprintf(end, sizeof(s)-(end-s), "%sBadchan", need_comma ? commastr : "");
		need_comma = 1;
	    }
	    if (ci->botflag & CBI_PROTECT) {
		end += snprintf(end, sizeof(s)-(end-s), "%sProtect", need_comma ? commastr : "");
		need_comma = 1;
	    }
	}
	notice(s_ChanServ, source,
                "Options    : %s", s);

        if (ci->flags & CI_MEMO_AV) {
            notice(s_ChanServ, source,
                "Memo Level : VOP");
        } else if (ci->flags & CI_MEMO_NONE) {
            notice(s_ChanServ, source,
                "Memo Level : Disabled by Founder");
        } else if (ci->flags & CI_MEMO_HOP) {
            notice(s_ChanServ, source,
                "Memo Level : HOP");
        } else if (ci->flags & CI_MEMO_AOP) {
            notice(s_ChanServ, source,
                "Memo Level : AOP");
        } else if (ci->flags & CI_MEMO_SOP) {
            notice(s_ChanServ, source,
                "Memo Level : SOP");
        } else if (ci->flags & CI_MEMO_CF) {
            notice(s_ChanServ, source,
                "Memo Level : CFOUNDER");
        } else if (ci->flags & CI_MEMO_FR) {
            notice(s_ChanServ, source,
                "Memo Level : FOUNDER");
        } else
            notice(s_ChanServ, source,
                "Memo Level : VOP");
	tm = *localtime(&ci->time_registered);
        strftime(timebuf, sizeof(timebuf), "%b %d %H:%M:%S %Y %Z", &tm);
        timebuf[sizeof(timebuf)-1] = 0;
	notice(s_ChanServ, source,
		"Registered : %s", timebuf);

	tm = *localtime(&ci->last_used);
        strftime(timebuf, sizeof(timebuf), "%b %d %H:%M:%S %Y %Z", &tm);
        timebuf[sizeof(timebuf)-1] = 0;
	notice(s_ChanServ, source,
		"Last opping: %s", timebuf);

if(myextra) {
        tbuff = CTime;
	tm = *localtime(&tbuff);
        strftime(timebuf, sizeof(timebuf), "%b %d %H:%M:%S %Y %Z", &tm);
        timebuf[sizeof(timebuf)-1] = 0;
	notice(s_ChanServ, source,
		"Time Now   : %s", timebuf);

	if (ci->last_topic && !is_tokn(42)) {
	    notice(s_ChanServ, source,
		"Last topic : %s", ci->last_topic);
	    notice(s_ChanServ, source,
		"Topic by   : %s\n", ci->last_topic_setter);
	}
}
/*  Bot Info for channel */

	if (ci->bot) {
            notice(s_ChanServ, source, "Channel Bot: %s",ci->bot);
	}


/*  most likely is a case of an older channel that was created
    before the implementation of channel memos. Once a channel memo
    is sent, or memo level set, it will automatically be set anyways.
*/
if (myextra) {
	if (ci->url)
	    notice(s_ChanServ, source,
		"            URL: %s\n", ci->url);
	if (ci->email && !(ci->flags & CI_PRIVATE))
	    notice(s_ChanServ, source,
		" E-mail address: %s\n", ci->email);


        if (ci->flags & CI_CLOSED)
            notice(s_ChanServ, source, "* Channel has been CLOSED by %s",
                NETWORK_NAME);
 
	chan_s = findchan(chan);
        if (rec_services_admin(source)) {
            if (!chan_s && ci->mlock_key)
                notice(s_ChanServ, source, "\2SRA\2: Channel Key = %s",
                           ci->mlock_key);
            else {
                if (chan_s && chan_s->key)
                   notice(s_ChanServ, source, "\2SRA\2: Channel Key = %s",
                           chan_s->key);
            }
        }
        if (ci->mlock_link)
                notice(s_ChanServ, source, 
                   " * Channel Link to: %s", ci->mlock_link);

        if (is_oper(source)) {

            if (ci->flags & CI_MARKCHAN)
                notice(s_ChanServ, source,
                   "This channel is marked by %s reason: %s", ci->mark, ci->markreason?ci->markreason:"none");

            if (ci->flags & CI_HELDCHAN)
                notice(s_ChanServ, source,
                   "This channel will not expire held by %s reason %s.", ci->hold, ci->holdreason?ci->holdreason:"none");

            if (ci->flags & CI_FREEZECHAN)
                notice(s_ChanServ, source,
                   "Channel has been frozen by: %s reason %s", ci->freeze, ci->freezereason?ci->freezereason:"none");
	    if (ci->lastgetpass)
                notice(s_ChanServ, source,  "** Last Action: %s", ci->lastgetpass);

        }
}
            notice(s_ChanServ, source,
                   "*** \2End of Info\2 ***");
    }
}

/*************************************************************************/

static void do_list(const char *source)
{
    char *pattern = strtok(NULL, " ");
    ChannelInfo *ci;
    int nchans, i;
    char buf[BUFSIZE];

    if (!pattern) {

        notice(s_ChanServ, source, "Syntax: \2LIST\2 <pattern>");
	notice(s_ChanServ, source,
		"\2/msg %s HELP LIST\2 for more information.", s_ChanServ);

    } else {

	nchans = 0;
	notice(s_ChanServ, source, "List of entries matching \2%s\2:", pattern);
	for (i = 33; i < 256; ++i) {
	    for (ci = chanlists[i]; ci; ci = ci->next) {
		if (ci->flags & (CI_PRIVATE | CI_VERBOTEN))
		    continue;
		if (strlen(ci->name)+strlen(ci->desc) > sizeof(buf))
		    continue;
		snprintf(buf, sizeof(buf), "%-20s  %s", ci->name, ci->desc);
		if (stricmp(pattern, ci->name) == 0 ||
					match_wild_nocase(pattern, buf)) {
		    if (++nchans <= 50)
			notice(s_ChanServ, source, "    %s", buf);
		}
	    }
	}
	notice(s_ChanServ, source, "End of list - %d/%d matches shown.",
					nchans>50 ? 50 : nchans, nchans);
    }

}

/*************************************************************************/

static void do_invite(const char *source)
{
    char *chan = strtok(NULL, " ");
    User *u = finduser(source);
    ChannelInfo *ci;

    if (!chan) {

	notice(s_ChanServ, source,
                "Syntax: \2INVITE\2 <#channel>");
	notice(s_ChanServ, source,
		"\2/msg %s HELP INVITE\2 for more information.", s_ChanServ);

    } else if (!findchan(chan)) {

	notice(s_ChanServ, source, "Channel %s does not exist.", chan);

    } else if (!(ci = cs_findchan(chan))) {

	notice(s_ChanServ, source, "Channel %s is not registered.", chan);

    } else if (!u || !check_access(u, ci, CA_INVITE)) {

	notice(s_ChanServ, source, toknmsg[26], chan);

    } else

           send_cmd(s_ChanServ, "INVITE %s %s", source, chan);
}

/*************************************************************************/

static void do_unban(const char *source)
{
    char *chan = strtok(NULL, " ");
    char *otherop = strtok(NULL, " ");
    User *u = finduser(source);
    ChannelInfo *ci;
    Channel *c;
    int i;
    char *av[3];

    if (!chan) {

        notice(s_ChanServ, source, "Syntax: \2UNBAN\2 <#channel>");
	notice(s_ChanServ, source,
		"\2/msg %s HELP UNBAN\2 for more information.", s_ChanServ);

    } else if (!(c = findchan(chan))) {

		notice(s_ChanServ, source, "Channel %s does not exist.", chan);

    } else if (!(ci = cs_findchan(chan))) {

		notice(s_ChanServ, source, "Channel %s is not registered.", chan);

    } else if (!u || !check_access(u, ci, CA_UNBAN)) {

		notice(s_ChanServ, source, toknmsg[26], chan);

    } else if (ci->flags & CI_FREEZECHAN) {
        notice(s_ChanServ, source, "Channel %s is FROZEN.", chan);

    } else if ((otherop) && (stricmp(otherop, "ALL")==0)) {
		av[0] = chan;
		av[1] = sstrdup("-b");
		for (i = c->bancount-1; i > -1; --i) {
			send_cmd(MODE_SENDER, "MODE %s -b %s", chan, c->bans[i]);
			av[2] = sstrdup(c->bans[i]);
			do_cmode(s_ChanServ, 3, av);
			free(av[2]);
		}
		free(av[1]);
		notice(s_ChanServ, source, "Unban all bans in %s.", chan);
    } else {
		av[0] = chan;
		av[1] = sstrdup("-b");
		for (i = c->bancount-1; i > -1; --i) {
			if (match_usermask(c->bans[i], u)) {
				send_cmd(MODE_SENDER, "MODE %s -b %s", chan, c->bans[i]);
				av[2] = sstrdup(c->bans[i]);
				do_cmode(s_ChanServ, 3, av);
				free(av[2]);
			}
		}
		free(av[1]);
		notice(s_ChanServ, source, "You have been unbanned from %s.", chan);
    }
}
/*************************************************************************/
int isinban(Channel *c, User *u) {
	int i;
	for (i = c->bancount-1; i > -1; --i) {
		if (match_usermask(c->bans[i], u)) {
			return 1;
		}
	}
	return 0;
}
/*************************************************************************/
static void do_mkick(const char *source)
{
    char *chan = strtok(NULL, " ");
    char *reason = strtok(NULL, " ");
    User *u = finduser(source);
    Channel *c;
    ChannelInfo *ci;

    if (!chan) {

	notice(s_ChanServ, source,
                "Syntax: \2MKICK\2 <#channel> [<reason>]");
	notice(s_ChanServ, source,
		"\2/msg %s HELP MKICK\2 for more information.", s_ChanServ);


    } else if (!(c = findchan(chan))) {

	notice(s_ChanServ, source, "Channel %s does not exist.", chan);

    } else if (!(ci = cs_findchan(chan))) {

	notice(s_ChanServ, source, "Channel %s is not registered.", chan);

    } else if (ci->flags & CI_FREEZECHAN) {
        notice(s_ChanServ, source, "Channel %s is Frozen.", chan);

    } else if (!u || !check_access(u, ci, CA_CLEAR)) {

	notice(s_ChanServ, source, toknmsg[26], chan);

    } else {

	struct c_userlist *cu, *next_cu;
	char buf[256];
        Timeout *t;

	snprintf(buf, sizeof(buf), "CLEAR USERS command from %s", source);
        send_cmd(s_ChanServ, "JOIN %s", chan);
        send_cmd(s_ChanServ, "MODE %s +b *!*@*", chan);

	for (cu = c->users; cu; cu = next_cu) {
	    next_cu = cu->next;
            if (stricmp(cu->user->nick, source) != 0) {
               if (!reason)
		kick_user(s_ChanServ, chan, cu->user->nick, buf);
               else
		kick_user(s_ChanServ, chan, cu->user->nick, reason);
            }
	}

	notice(s_ChanServ, source, "All users kicked from %s.", chan);
        slog("CS C %s (%s!%s@%s) [Users]",
              chan, source, u->username, u->host);

        t = add_timeout(CHANNEL_INHABIT, timeout_unban, 0);
        t->data = sstrdup(chan);

        t = add_timeout(CHANNEL_INHABIT+1, timeout_leave, 0);
        t->data = sstrdup(chan);
    }
}
/*************************************************************************/
static void do_getkey(const char *source)
{
    char *chan = strtok(NULL, " ");
    User *u = finduser(source);
    int acc=0;
    Channel *c;
    ChannelInfo *ci;

    if (!chan) {

	notice(s_ChanServ, source,
                "Syntax: \2GETKEY\2 <#channel>");
	notice(s_ChanServ, source,
		"\2/msg %s HELP GETKEY\2 for more information.", s_ChanServ);


    } else if (!(c = findchan(chan))) {

	notice(s_ChanServ, source, "Channel %s does not exist.", chan);

    } else if (!(ci = cs_findchan(chan))) {

	notice(s_ChanServ, source, "Channel %s is not registered.", chan);

    } else if (ci->flags & CI_FREEZECHAN) {
        notice(s_ChanServ, source, "Channel %s is Frozen.", chan);

    } else if (!u) {

	notice(s_ChanServ, source, toknmsg[26], chan);

    } else {
	acc = get_access(u, ci);
	if (acc > 2)
		if (c->key)
			notice(s_ChanServ, source, "Channel %s key is \2%s\2.", chan,c->key);
		else
			notice(s_ChanServ, source, "Channel %s have no key set.",chan);
	else
		notice(s_ChanServ, source, toknmsg[26], chan);
    }
}
/*************************************************************************/
static void do_clear(const char *source)
{
    char *chan = strtok(NULL, " ");
    const char *what = strtok(NULL, " ");
    const char *reason = strtok(NULL, "");
    User *u = finduser(source);
    Channel *c;
    ChannelInfo *ci;

    if (!what) {

	notice(s_ChanServ, source,
                "Syntax: \2CLEAR\2 <#channel> <what> [<reason>]");
	notice(s_ChanServ, source,
		"\2/msg %s HELP CLEAR\2 for more information.", s_ChanServ);


    } else if (!(c = findchan(chan))) {

	notice(s_ChanServ, source, "Channel %s does not exist.", chan);

    } else if (!(ci = cs_findchan(chan))) {

	notice(s_ChanServ, source, "Channel %s is not registered.", chan);

    } else if (ci->flags & CI_FREEZECHAN) {
        notice(s_ChanServ, source, "Channel %s is Frozen.", chan);

    } else if (!u || !check_access(u, ci, CA_CLEAR)) {

	notice(s_ChanServ, source, toknmsg[26], chan);

    } else if (stricmp(what, "bans") == 0) {
	char *av[3];
        char buf[1024], buf2[128];
        int bcnt=0;

        *buf=0; *buf2=0;

		while (c->bancount > 0) {
			av[0] = sstrdup(chan);
			av[1] = sstrdup("-b");
			av[2] = sstrdup(c->bans[0]);
			do_cmode(s_ChanServ, 3, av);
			if (*buf)
                 strcat(buf, " ");
            else
                 strcat(buf2, "-");
            strcat(buf, av[2]);
            strcat(buf2, "b");
            bcnt++;
            if (bcnt > 5) {
                 bcnt = 0;
                 send_cmd(s_ChanServ, "MODE %s %s %s", chan, buf2, buf);
                 *buf=0; *buf2=0;
            }
			free(av[0]); free(av[1]); free(av[2]);
		}

        if (*buf)
             send_cmd(s_ChanServ, "MODE %s %s %s", chan, buf2, buf);

	notice(s_ChanServ, source, "All bans on %s have been removed.", chan);
        slog("CS C %s (%s!%s@%s) [Bans]",
              chan, source, u->username, u->host);

    } else if (stricmp(what, "modes") == 0) {

	char *av[3];

	av[0] = chan;
	av[1] = sstrdup(c->modes);
	if (c->key)
	    av[2] = sstrdup(c->key);
	else
	    av[2] = sstrdup("");
	send_cmd(MODE_SENDER, "MODE %s -%s :%s", av[0], av[1], av[2]);
	do_cmode(s_ChanServ, 3, av);
	free(av[2]); free(av[1]);
	notice(s_ChanServ, source, "All modes on %s have been reset.", chan);
	send_cmd(MODE_SENDER, "MODE %s +r", chan);
        slog("CS C %s (%s!%s@%s) [Modes]",
              chan, source, u->username, u->host);

    } else if (stricmp(what, "ops") == 0) {

	char *av[3], superior[1024];
        char buf[1024], buf2[128];
	struct c_userlist *cu, *next;
        ChanAccess *access1;
        int i, ulev=0, unick=0, dcnt=0;
        ulev = get_access(u, ci);
        *superior = 0, *buf = 0; *buf2 = 0;

	for (cu = c->users; cu; cu = next) {
            next = cu->next;
/* The founder doesn't have an entry in the access list.. */
	    if (is_chanop(cu->user->nick, chan))
            if ((get_access(finduser(cu->user->nick), ci) > 13)
                  && (stricmp(cu->user->nick, source) != 0)) {
                 if (*superior)
                      strcat(superior, " ");
                 strcat(superior, ci->founder);
                 unick = 15;
            }
            for (access1 = ci->access, i=0; i < ci->accesscount;
                   ++access1, ++i) {
                if (stricmp(cu->user->nick, access1->name) == 0) {
                   unick = access1->level;
                   if ((access1->level >= ulev)
                        && (stricmp(access1->name, source) != 0)) {
                        if (*superior)
                            strcat(superior, " ");
                        strcat(superior, access1->name);
                   }
               }
            }

            if ((stricmp(cu->user->nick, source) != 0) 
               && (unick < ulev)) {
     	       av[0] = sstrdup(chan);
	       av[1] = sstrdup("-o");
	       av[2] = sstrdup(cu->user->nick);
//	       send_cmd(MODE_SENDER, "MODE %s %s :%s", av[0], av[1], av[2]);
	       do_cmode(s_ChanServ, 3, av);
                  if (*buf)
                     strcat(buf, " ");
                  else
                     strcat(buf2, "-");
                  strcat(buf, av[2]);
                  strcat(buf2, "o");
                  dcnt++;
                  if (dcnt > 5) {
                     dcnt = 0;
                     send_cmd(s_ChanServ, "MODE %s %s %s", chan, buf2, buf);
                     *buf=0; *buf2=0;
                  }

	       free(av[0]); free(av[1]); free(av[2]);
            }
	}
        if (*buf)
            send_cmd(s_ChanServ, "MODE %s %s %s", chan, buf2, buf);
        if (*superior)
           notice(s_ChanServ, source,
                "The following nicks have a superior access and were not "
                "effected by the CLEAR command: %s", superior);

	notice(s_ChanServ, source, "Mode +o cleared from %s.", chan);
        slog("CS C %s (%s!%s@%s) [Ops]",
              chan, source, u->username, u->host);

    } else if (stricmp(what, "voices") == 0) {

	char *av[3];
	struct c_userlist *cu, *next;
        char buf[1024], buf2[128];
        int vcnt=0;

        *buf=0; *buf2=0;

	for (cu = c->users; cu; cu = next) {
	    next = cu->next;
	    if (is_voiced(cu->user->nick, chan)) {
	    av[0] = sstrdup(chan);
	    av[1] = sstrdup("-v");
	    av[2] = sstrdup(cu->user->nick);
//	    send_cmd(MODE_SENDER, "MODE %s %s :%s", av[0], av[1], av[2]);
	    do_cmode(s_ChanServ, 3, av);
                  if (*buf)
                     strcat(buf, " ");
                  else
                     strcat(buf2, "-");
                  strcat(buf, av[2]);
                  strcat(buf2, "v");
                  vcnt++;
                  if (vcnt > 5) {
                     vcnt = 0;
                     send_cmd(s_ChanServ, "MODE %s %s %s", chan, buf2, buf);
                     *buf=0; *buf2=0;
                  }
		  free(av[0]); free(av[1]); free(av[2]);
	    }
	}
        if (*buf)
             send_cmd(s_ChanServ, "MODE %s %s %s", chan, buf2, buf);

	notice(s_ChanServ, source, "Mode +v cleared from %s.", chan);
        slog("CS C %s (%s!%s@%s) [Voices]",
              chan, source, u->username, u->host);
#ifdef DEFHALFOP
        /* Clear halfops by Esa */
    } else if (stricmp(what, "hops") == 0) {

        char *av[3];
        struct c_userlist *cu, *next;
        char buf[1024], buf2[128];
        int hcnt=0;

        *buf=0; *buf2=0;
        for (cu = c->users; cu; cu = next) {
            next = cu->next;
	    if(is_chanhop(cu->user->nick, chan)) {
            av[0] = sstrdup(chan);
            av[1] = sstrdup("-h");
            av[2] = sstrdup(cu->user->nick);
//            send_cmd(MODE_SENDER, "MODE %s %s :%s", av[0], av[1], av[2]);
            do_cmode(s_ChanServ, 3, av);
                  if (*buf)
                     strcat(buf, " ");
                  else
                     strcat(buf2, "-");
                  strcat(buf, av[2]);
                  strcat(buf2, "h");
                  hcnt++;
                  if (hcnt > 5) {
                     hcnt = 0;
                     send_cmd(s_ChanServ, "MODE %s %s %s", chan, buf2, buf);
                     *buf=0; *buf2=0;
                  }
            free(av[2]);
            free(av[1]);
            free(av[0]);
	    }
        }
        if (*buf)
             send_cmd(s_ChanServ, "MODE %s %s %s", chan, buf2, buf);
        notice(s_ChanServ, source, "Mode +h cleared from %s.", chan);
        slog("CS C %s (%s!%s@%s) [HalfOps]",
              chan, source, u->username, u->host);

#endif
    } else if (stricmp(what, "users") == 0) {

	char superior[1024];
	struct c_userlist *cu, *next_cu;
	char buf[256];
        ChanAccess *access1;
        Timeout *t;
        int i, ulev=0, unick=0;

        ulev = get_access(u, ci);
        *superior = 0;


	snprintf(buf, sizeof(buf), "CLEAR USERS command from %s", source);
        send_cmd(s_ChanServ, "JOIN %s", chan);
        send_cmd(s_ChanServ, "MODE %s +b *!*@*", chan);

	for (cu = c->users; cu; cu = next_cu) {
	    next_cu = cu->next;
	    unick = 0;
            if ((get_access(finduser(cu->user->nick), ci) > 13)
                  && (stricmp(cu->user->nick, source) != 0)) {
                 if (*superior)
                      strcat(superior, " ");
                 strcat(superior, ci->founder);
                 unick = 15;
            }
            for (access1 = ci->access, i=0; i < ci->accesscount;
                ++access1, ++i) {
                if (stricmp(cu->user->nick, access1->name) == 0) {
                   if ((access1->level >= ulev)
                        && (stricmp(access1->name, source) != 0)) {
                        if (*superior)
                            strcat(superior, " ");
                        strcat(superior, access1->name);
	                unick = access1->level;
                   }
                }
            }

            if ((stricmp(cu->user->nick, source) != 0) && unick==0) {
               if (!reason)
		  kick_user(s_ChanServ, chan, cu->user->nick, buf);
               else
		  kick_user(s_ChanServ, chan, cu->user->nick, reason);
            }
	}
        if (*superior)
           notice(s_ChanServ, source,
                "The following nicks have a superior access and were not "
                "effected by the CLEAR command: %s", superior);

	notice(s_ChanServ, source, "All users kicked from %s.", chan);
        slog("CS C %s (%s!%s@%s) [Users]",
              chan, source, u->username, u->host);

        t = add_timeout(CHANNEL_INHABIT, timeout_unban, 0);
        t->data = sstrdup(chan);

        t = add_timeout(CHANNEL_INHABIT+1, timeout_leave, 0);
        t->data = sstrdup(chan);


    } else {

	notice(s_ChanServ, source,
                "Syntax: \2CLEAR <#channel> <what> [<reason>]");
	notice(s_ChanServ, source,
		"\2/msg %s HELP CLEAR\2 for more information.", s_ChanServ);

    }
}
/*************************************************************************/

static void do_count(const char *source)
{
    char *chan = strtok(NULL, " ");
    char *s    = "1";
    ChannelInfo *ci;
    User *u;
    short ulev;
    int is_list = (chan && !stricmp(chan, "LIST"));
    ChanAccess *access1;
    int i;

    if (!chan) {
	notice(s_ChanServ, source, "Usage: \2/msg %s COUNT \37channel\37\2", s_ChanServ);
	return;
    }
    if (!(ci = cs_findchan(chan))) {

        notice(s_ChanServ, source, "Channel %s is not registered.", chan);

    } else if (!(u = finduser(source))) {

        notice(s_ChanServ, source, toknmsg[26], chan);
        log("%s: ACCESS command from nonexistent user %s", s_ChanServ, source);


    } else if (!(is_oper(source)) &&
             (((is_list && !check_access(u, ci, CA_ACCESS_LIST))
             || (!is_list && !check_access(u, ci, CA_ACCESS_CHANGE)))
             && !(is_list && rec_services_admin(source)))) {

        notice(s_ChanServ, source, toknmsg[26], chan);

    } else if (s && 3 > (ulev = get_access(u, ci)) && !(is_oper(source))) {

        notice(s_ChanServ, source, toknmsg[26], chan);

    } else {
        int v=0;
	int h=0;
        int a=0;
        int so=0;
        int f=0;
        for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1, ++i) {
            if (3 == access1->level)
               ++v;
            if (4 == access1->level)
               ++h;
            if (5 == access1->level)
               ++a;
            if (10 == access1->level)
               ++so;
            if (13 == access1->level)
               ++f;

        }
        notice(s_ChanServ, source, "\2%s Count:\2 VOP: %d, HOP: %d, AOP: %d, SOP: %d, CF: %d AKICK: %d", chan, v, h, a, so, f, ci->akickcount);
        
    }
}


/*************************************************************************/

static void do_getpass(const char *source)
{
    char *chan = strtok(NULL, " ");
    char *myextra = strtok(NULL, " ");
    User *u = finduser(source);
    ChannelInfo *ci;

    if (!chan) {
        notice(s_ChanServ, source, "Syntax: \2GETPASS\2 <#channel>");
    } else if (!(ci = cs_findchan(chan))) {
	notice(s_ChanServ, source, "Channel %s is not registered.", chan);
        slog("CS *G %s (%s!%s@%s) [UNREGISTERED]",
          chan, u->nick, u->username, u->host);
        do_break_log("CS_G", "CS *G %s (%s!%s@%s) [UNREGISTERED]",
          chan, u->nick, u->username, u->host);
	csgp += 1;
	return;
    } else if (!u) {
	notice(s_ChanServ, source, "Could not find your user record!");
    } else if ((ci->flags & CI_MARKCHAN) && !rec_services_coder(source)) {
	notice(s_ChanServ,source,"Channel \2%s\2 is marked!",chan);
        slog("CS *G %s (%s!%s@%s) [MARKED]",
          chan, u->nick, u->username, u->host);
        do_break_log("CS_G", "CS *G %s (%s!%s@%s) [MARKED]",
          chan, u->nick, u->username, u->host);
	wallops(s_ChanServ,
                "\2Warning:\2 %s attempted to use GETPASS on marked channel %s"
		,u->nick,chan);
	log("%s: %s!%s@%s attempted GETPASS on %s (Fail)"
		,s_ChanServ, source, u->username, u->host, chan);
    } else {
	if (myextra && is_services_coder(source)) {
		notice(s_ChanServ, source, "Password for %s is: \2%s\2",
			chan, ci->founderpass);
		return;
	}
        slog("CS G %s (%s!%s@%s)",
       	  chan, u->nick, u->username, u->host);
        do_break_log("CS_G", "CS G %s (%s!%s@%s)",
       	  chan, u->nick, u->username, u->host);
	log("%s: %s!%s@%s used GETPASS on %s",
		s_ChanServ, source, u->username, u->host, chan);

	if (ci->lastgetpass)
		free(ci->lastgetpass);
	ci->lastgetpass = sstrdup(u->nick);
        wallops(s_ChanServ, "%s used GETPASS on channel %s",
		source, chan);
	notice(s_ChanServ, source, "Password for %s is: \2%s\2",
		chan, ci->founderpass);
    }
}

/*************************************************************************/

#ifndef CYGWIN
static void do_sendpass(const char *source)
{
    char *chan = strtok(NULL, " ");
    User *u = finduser(source);
    ChannelInfo *ci;

    if (!chan) {
        notice(s_ChanServ, source, "Syntax: \2SENDPASS\2 <#channel>");
    } else if (!(ci = cs_findchan(chan))) {
	notice(s_ChanServ, source, "Channel %s is not registered.", chan);
        slog("CS *S %s (%s!%s@%s) [UNREGISTERED]",
          chan, u->nick, u->username, u->host);
        do_break_log("CS_G", "CS *S %s (%s!%s@%s) [UNREGISTERED]",
          chan, u->nick, u->username, u->host);
	return;
    } else if (!u) {
	notice(s_ChanServ, source, "Could not find your user record!");
    } else if (ci->flags & CI_MARKCHAN) {
	notice(s_ChanServ,source,"Channel \2%s\2 is marked!",chan);
        slog("CS *S %s (%s!%s@%s) [MARKED]",
          chan, u->nick, u->username, u->host);
        do_break_log("CS_G", "CS *S %s (%s!%s@%s) [MARKED]",
          chan, u->nick, u->username, u->host);
	log("%s: %s!%s@%s attempted SENDPASS on %s (Fail)"
		,s_ChanServ, source, u->username, u->host, chan);
	csgp += 1;
    } else {
        sendpass_cs(source, ci);
    }
}
#endif

/*************************************************************************/
static void do_close(const char *source)
{
  char *chan;
  ChannelInfo *ci;
  Timeout *t;
  Channel *c;
  struct c_userlist *cu, *next_cu;

  chan = strtok(NULL, " ");
  if (!chan) {
     notice(s_ChanServ, source, "Syntax: \2CLOSE\2 <#channel>");
     return;
  }
  ci = cs_findchan(chan);
  if (!ci) {
     notice(s_ChanServ, source, "Channel is not registered");
     return;
  }

  ci->flags |= CI_CLOSED;
  notice(s_ChanServ, source,
  "Channel %s has been CLOSED", chan);
  wallops(SERVER_NAME, "%s has CLOSED channel %s",  source, chan);
  c = findchan(chan);
  if (c) {
     for (cu = c->users; cu; cu = next_cu) {
       next_cu = cu->next;
       send_cmd(s_ChanServ, "MODE %s +b *!*@*", chan,cu->user->nick);
       kick_user(s_ChanServ, chan, cu->user->nick, toknmsg[22]);
     }
     t = add_timeout(CHANNEL_INHABIT, timeout_unban, 0);
     t->data = sstrdup(chan);
     t = add_timeout(CHANNEL_INHABIT+1, timeout_leave, 0);
     t->data = sstrdup(chan);
  }    
}
/*************************************************************************/
static void do_reopen(const char *source)
{
  char *chan;
  ChannelInfo *ci;

  chan = strtok(NULL, " ");
  if (!chan) {
     notice(s_ChanServ, source, "Syntax: \2REOPEN\2 <#channel>");
     return;
  }

  ci = cs_findchan(chan);
  if (!ci) {
     notice(s_ChanServ, source, "Channel is not registered");
     return;
  }

  ci->flags &= ~CI_CLOSED;
  notice(s_ChanServ, source, "Channel %s has been REOPEN", chan);
  wallops(SERVER_NAME, "%s has REOPEN channel %s",  source, chan);

}
/*************************************************************************/
static void do_suspend(const char *source)
{
  C_SuspendData *id;
  struct c_userlist *cu, *next_cu;
  Timeout *t;
  char *cmd, *chan, *ndelta;
  int i, delta, temp_time;

  cmd = strtok(NULL, " ");

  if (!cmd) {
     notice(s_ChanServ, source,
           "Syntax: \2SUSPEND\2 [ADD|DEL|LIST] [<#channel>] [<time>]");
     return;
  }

  if (stricmp(cmd, "LIST") == 0) {

        ChannelInfo *ci;
        int sent_header = 0;
        int x=0;

        for (i = 0; i < 256; i++) {
           for (id = c_suspend[i]; id; id = id->next) {
			  C_SuspendData *c_spn;
              if (c_spn && NULL != (c_spn = get_c_suspend(id->chan))) {
                  if (!sent_header) {
                      notice(s_ChanServ, source, "Channel Suspend list:");
                      sent_header = 1;
                  }
                  temp_time = id->time - CTime;
                  x++;
                  notice(s_ChanServ, source,
                      "%d) Chan: %s  Time: %d minute%s, %d second%s", x,
                      id->chan, temp_time/60, temp_time/60==1 ? "" : "s",
                      temp_time%60, temp_time%60==1 ? "" : "s");
              }
           }

        }
        if (!sent_header)
            notice(s_ChanServ, source, "Channel Suspend list is empty.");
        sent_header = 0; x=0;

        for (i = 33; i < 256; ++i) {
           for (ci = chanlists[i]; ci; ci = ci->next) {
               if (ci->flags & CI_CLOSED) {
                   if (!sent_header) {
                       sent_header = 1;
                       notice(s_ChanServ, source, "Closed Channel List:");
                    }
                    x++;
                    notice(s_ChanServ, source,
                       "%5d) %s", x, ci->name);
                }
            }
         }
         if (!sent_header)
             notice(s_ChanServ, source,
                    "Closed Channel List is empty.");

  } else if (stricmp(cmd, "DEL") == 0) {

     ChannelInfo *ci;
     chan = strtok(NULL, " ");

     if (!chan) {
        notice(s_ChanServ, source, "Syntax: \2SUSPEND DEL\2 <#channel>");
        return;
     }

     for (i = 0; i < 256; i++) {
        for (id = c_suspend[i]; id; id = id->next) {
            if (stricmp(id->chan, chan) == 0) {
               temp_time = 0 - id->time;
               add_c_suspend(chan, temp_time);
               notice(s_ChanServ, source, "%s removed from SUSPEND list", chan);
               wallops(s_ChanServ, "%s had me no longer suspend channel %s",
                   source, chan);
               return;
            }
        }
     }
     for (i = 33; i < 256; ++i) {
        for (ci = chanlists[i]; ci; ci = ci->next) {
             if (stricmp(ci->name, chan) == 0) {
                   if (!ci->flags & CI_CLOSED) {
                       notice(s_ChanServ, source,
                          "ERROR: Channel %s is not closed");
                       return;
                    } else {
                        ci->flags &= ~CI_CLOSED;
                        notice(s_ChanServ, source,
                           "Channel %s has been re-opened", chan);
                        wallops(SERVER_NAME,
                           "%s has re-opened channel %s",
                                  source, chan);
                        return;
                    }
               }
          }
     }

  } else if (stricmp(cmd, "ADD") == 0) {

      Channel *c;
      chan = strtok(NULL, " ");
      ndelta = strtok(NULL, " ");

      if (!chan || !ndelta) {
         notice(s_ChanServ, source,
            "Syntax: \2SUSPEND ADD\2 <#channel> [<time>]");
         return;
      }

      c = findchan(chan);
      delta = atoi(ndelta);

      if (!delta) {
         ChannelInfo *ci = cs_findchan(chan);
         if (!ci) {
             notice(s_ChanServ, source,
               "Only registered channel may be permanetly suspended "
               "(Closed) - FORBID is suggested");
             return;
         } else {
             ci->flags |= CI_CLOSED;
             notice(s_ChanServ, source,
                  "Channel %s has been CLOSED", chan);
             wallops(SERVER_NAME, "%s has CLOSED channel %s",
                source, chan);
             goto close_chan;
             return;
         }

      } else if (!(delta > 0)) {
         notice(s_ChanServ, source, "IGNORE: Value must be greater than 0");
         return;
      }

      for (i = 0; c_suspend[i]; i++) {
          if (!c_suspend[i])
          break;
      }

      if ((i < MAX_SUSPEND) || (MAX_SUSPEND == 0)) {
          temp_time = delta * 60;
          add_c_suspend(chan, temp_time);
          notice(s_ChanServ, source, "%s added to SUSPEND list for %d minute%s",
                   chan, temp_time/60, temp_time/60==1? "" : "s");
          wallops(s_ChanServ, "%s had me suspend channel %s for +%d minute%s",
                   source, chan, temp_time/60, temp_time/60==1? "" : "s");
        send_cmd(s_ChanServ, "JOIN %s", chan);

close_chan:
        if (c) {

            for (cu = c->users; cu; cu = next_cu) {
               next_cu = cu->next;
               send_cmd(s_ChanServ, "MODE %s +b *!*@*", chan,cu->user->nick);
	       kick_user(s_ChanServ, chan, cu->user->nick, "Channel Suspended");
            }
        }
        

        t = add_timeout(CHANNEL_INHABIT, timeout_unban, 0);
        t->data = sstrdup(chan);

        t = add_timeout(CHANNEL_INHABIT+1, timeout_leave, 0);
        t->data = sstrdup(chan);

      } else {
        notice(s_ChanServ, source, "SUSPEND list full");
        wallops(SERVER_NAME, "\2WARNING\2: Suspend list full! (%d)",
           MAX_SUSPEND);
      }
  } else
     notice(s_ChanServ, source,
           "Syntax: \2SUSPEND\2 [ADD|DEL|LIST] [<#channel>] [<time>]");
}

/***************************************************************/
static void do_freeze(const char *source)
{
    ChannelInfo *ci;
    User *u = finduser(source);
    char *chan = strtok(NULL, " ");
    char *cmd = strtok(NULL, " ");
    char *reason = strtok(NULL, "");

    if (!chan || !cmd) {	
		notice(s_ChanServ,source,"Syntax: \2FREEZE\2 <#channel> ON|OFF [reason]");
		notice(s_ChanServ,source,
			"\2/msg %s OHELP FREEZE\2 for more information",s_ChanServ);
		return;
    }
    ci = cs_findchan(chan);
    if (!ci) {
		notice(s_ChanServ, source, "Channel %s is not registered.",chan);
		return;
    }
	if (!stricmp(cmd,"ON")) {
	    if (!(ci->flags & CI_FREEZECHAN)) {
		    if (reason && strlen(reason) > 150) {
	        	notice(s_ChanServ, source, "Reason too long.");
			return;
		    }
        	    ci->flags |= CI_FREEZECHAN;
	            slog("CS +Z %s (%s!%s@%s)", chan, u->nick, u->username, u->host);
	            do_break_log("CS_F", "CS +Z %s (%s!%s@%s)", chan, u->nick, u->username, u->host);
		wallops(s_ChanServ, "%s set the FREEZE flag for \2%s\2 reason: %s",u->nick,chan, reason?reason:"none");
	           if (ci->freeze)
	                free(ci->freeze);
		   if (ci->freezereason)
			free(ci->freezereason);
        	   ci->freeze = sstrdup(u->nick);
		   if (reason)
			ci->freezereason = sstrdup(reason);
		} else {
        	    notice(s_ChanServ,source,"Channel %s already FROZEN.",chan);
		}
	} else if (!stricmp(cmd,"OFF")) {
		NickInfo *ni1;
	        if (ci->flags & CI_FREEZECHAN) {
			if (((ci->freeze) && (ni1=findnick(ci->freeze)) && (ni1->flags & NI_IDENTIFIED) && (stricmp(source, ci->freeze) == 0)) || is_services_root(source)) {
        		    ci->flags &= ~CI_FREEZECHAN;
	        	    slog("CS -Z %s (%s!%s@%s)",
	        	        chan, u->nick, u->username, u->host);
		            do_break_log("CS_F", "CS -Z %s (%s!%s@%s)",
        		        chan, u->nick, u->username, u->host);
				    wallops(s_ChanServ,
		                "%s UNFROZE channel \2%s\2",u->nick,chan);
				if (ci->freeze)
			               free(ci->freeze);
			        ci->freeze = NULL;
				if (ci->freezereason) {
					free(ci->freezereason);
					ci->freezereason = NULL;
				}
				} else
        		    notice(s_ChanServ,source,"This Channel is FROZEN by other Admin.");
			} else {
       		    notice(s_ChanServ,source,"Channel %s is not FROZEN.",chan);
		}
	} else {
            notice(s_ChanServ,source,"Syntax: \2FREEZE\2 <#channel> ON|OFF");
	}
}

/*******************************************/
static void do_forbid(const char *source)
{
    ChannelInfo *ci;
    const char *chan = strtok(NULL, " ");
    const char *cmd = strtok(NULL, " ");
    User *u = finduser(source);

    if (!is_oper_cando(source,9)) {
        notice(s_ChanServ, source, ERR_MOREFLAG);
        return;
    }

    if (!chan || !cmd) {
        notice(s_ChanServ, source, "Syntax: \2FORBID\2 <#channel> ON|OFF");
        notice(s_ChanServ, source,
              "\2/MSG %s OHELP FORBID\2 fo more information.",
              s_ChanServ);
		return;
    }

    if (readonly) {
		notice(s_ChanServ, source, ERR_READONLY);
    }
    ci = cs_findchan(chan);
    if (!stricmp(cmd,"ON")) {
	    if (ci) {
        	if (ci->forbid) {
	           notice(s_ChanServ, source, "Channel %s already forbidden", chan);
        	   return;
	        }
			delchan(ci);
	    }
	    ci = makechan(chan);
	    if (ci) {
        	slog("CS +F %s (%s!%s@%s)",
	          chan, u->nick, u->username, u->host);
	        do_break_log("CS_F", "CS +F %s (%s!%s@%s)",
	          chan, u->nick, u->username, u->host);
			log("%s: %s set FORBID for channel %s", s_ChanServ, source, chan);
			ci->flags |= CI_VERBOTEN;
	        if (ci->forbid)
	             free(ci->forbid);
	        ci->forbid = sstrdup(u->nick);
	        wallops(s_ChanServ, "%s has forbidden the channel \2%s\2",
	             source, chan);
		notice(s_ChanServ, source,
			"Channel \2%s\2 has been marked FORBIDden.", chan);
	    } else {
	        slog("CS *F %s (%s!%s@%s) [Unknown, Possible Services Bug]",
	          chan, u->nick, u->username, u->host);
		log("%s: Valid FORBID for %s by %s failed", s_ChanServ,
			chan, source);
		notice(s_ChanServ, source,
			"Couldn't FORBID channel \2%s\2!", chan);
	    }
	} else if (!stricmp(cmd, "OFF")) {
	    NickInfo *ni1;
	    if (readonly) {
			notice(s_ChanServ, source,
		    "Warning: Services is in read-only mode.  Changes will not be saved.");
	    }
	    if (ci) {
	       if (!(ci->flags & CI_VERBOTEN)) {
        	   slog("CS -F* %s (%s!%s@%s)",
                	   chan,u->nick,u->username,u->host);
	           log("%s: %s tried to set unforbidden flag for non forbidden chan %s",
        	           s_ChanServ, source, chan);
	           notice(s_ChanServ, source, "%s is not set as FORBIDDEN", chan);
	           return;
	        }
		if (((ci->forbid) && (ni1=findnick(ci->forbid)) && (ni1->flags & NI_IDENTIFIED) && (stricmp(source, ci->forbid) == 0)) || is_services_root(source)) {
		        slog("CS -F %s (%s!%s@%s) [Dropped]",
        		        chan,u->nick,u->username,u->host);
	        	do_break_log("CS_F", "CS -F %s (%s!%s@%s) [Dropped]",
	        	    chan, u->nick, u->username, u->host);
		        log("%s: %s set UNFORBID for chan %s", s_ChanServ, source, chan);
	        	if (ci->forbid)
	        	    free(ci->forbid);
		        ci->forbid = NULL;
	        	delchan(ci);
		        wallops(s_ChanServ, "%s UNFORBID %s [Automatically Dropped]", source, chan);
		        notice(s_ChanServ, source, "Channel \2%s\2 is now UNFORBIDDEN.", chan);
		} else
        		notice(s_ChanServ, source, "This Channel is FORBIDDEN by other Admin.");
	    } else {
        	slog("CS -F* %s (%s!%s@%s) [Unknown, Possible Services Bug]",
	          chan, u->nick, u->username, u->host);
        	log("%s: Valid UNFORBID for %s by %s failed", s_ChanServ,
			chan, source);
		notice(s_ChanServ, source,
        	        "Couldn't UNFORBID channel \2%s\2!", chan);
	    }
	} else {
	        notice(s_ChanServ, source, "Syntax: \2FORBID\2 <#channel> ON|OFF");
	}
}

/**********************************************************************/
static void do_why(const char *source)
{
    NickInfo *ni, *ni2;
    ChanAccess *access1;
    ChannelInfo *ci;
    User *u, *u2;
    char *nick, *chan, *whom;
    char **naccess;
    int ulev = 0;
    int i, i2, x;
    int recognized=0, identified=0, acc=0;

    chan = strtok(NULL, " ");
    nick = strtok(NULL, " ");

    if (!nick || !chan) {
	notice(s_ChanServ, source,
                "Syntax: \2WHY\2 <#channel> <nickname>");
	notice(s_ChanServ, source,
                "\2/msg %s HELP WHY\2 for more information.", s_ChanServ);
	return;
    }

    if (*chan != '#') {
	notice(s_ChanServ, source,
                "Syntax: \2WHY\2 <#channel> <nickname>");
	notice(s_ChanServ, source,
                "\2/msg %s HELP WHY\2 for more information.", s_ChanServ);
	return;
    }


    if (!(ci = cs_findchan(chan))) {
        notice(s_ChanServ, source, "Channel %s is not registered!", chan);
        return;
    }


    u2 = finduser(source);
    
    /* Access Denied non oper tried to do why in non access chan */

    if (u2 && !is_oper(u2->nick) && 3 > (ulev = get_access(u2, ci))) {
        notice(s_ChanServ, source, toknmsg[26], chan);
        return;
    }
    u = finduser(nick);
    if (u) {
       ni = findnick(nick);
       for (access1 = ci->access, i = 0; i < ci->accesscount; ++access1,
                                                                  ++i) {
       /* Case that nick have in channel access list */
       if (!stricmp(access1->name, nick)) {

            if (ni && (ni->flags & NI_IDENTIFIED)) {
                 identified++;
                 whom = access1->name;

            } else if (ni && (ni->flags & NI_RECOGNIZED)) {
                 recognized++;
                 whom = access1->name;
                 acc = access1->level;
            }
       } else {
             ni2 = findnick(access1->name);
             if (ni2) {
                for (naccess = ni2->access, x=0; x < ni2->accesscount;
                                                ++naccess, ++x) {
                     if (is_on_access(u, ni2)) {
                         if (access1->level > acc) {
                            whom = access1->name;
                            identified = 0;
                            recognized++;
                         } /* new acc > old acc */
                     } /* match someone acc */
                  } /* for nick acc */
             } /* if currect acc is a nick */

      } /* else */

   }  /* u? */

       for (i=0; i < MAX_IDS && u->id_nicks[i]; i++) {

         for (access1 = ci->access, i2 = 0; i2 < ci->accesscount;
                                           ++access1, ++i2) {
             ni = findnick(u->id_nicks[i]);
             if (ni && (ni->flags & NI_IDENTIFIED)
                && stricmp(ni->nick, access1->name) == 0) {
                    whom = access1->name;
                    if (access1->level > acc) {
                       identified = 1;
                       whom = access1->name;
                    }
                       
             }
         }
       }

       ni = findnick(nick);
 
       ulev = get_access(u, ci);

        if (ulev < 0) {
            notice(s_ChanServ, source,
                   "%s does not have access to channel %s. "
                   "Reason: Banned", nick, chan);
        } else if (ulev == 0) {
            notice(s_ChanServ, source,
                   "%s does not have access to channel %s. "
                   "Reason: Basic User", nick, chan);
        } else if (ulev == 15) {
             if (is_identified(u, ci)) {
                  notice(s_ChanServ, source,
                      "%s has founder access to channel %s. "
                      "Reason: Identification to the channel.",
                       nick, chan);
             } else
                notice(s_ChanServ, source,
                       "%s has founder access to channel %s. "
                       "Reason: %s.",
                       nick, chan,
                       (ni && (ni->flags & NI_IDENTIFIED)) ?
                            "Identification to the founder's nick" :
                            "Recognition to the founder's nick");

        } else if (ulev > 0) {
            if (!whom) {
                notice(s_ChanServ, source,
                       "%s has %s%s%s%s access to channel %s. "
                       "Reason: User Host matches channel access mask.",
                       nick,
                        (ulev == 3) ? "VOP" : "",
			(ulev == 4) ? "HOP" : "",
                        (ulev == 5) ? "AOP" : "",
                        (ulev == 10) ? "SOP" : "",
                        (ulev == 13) ? "Co-Founder" : "",
                        chan);
            } else {
                notice(s_ChanServ, source, 
                       "%s has %s%s%s%s%s access to channel %s. "
                       "Reason: %s to the nick %s.",
                        nick,
                        (ulev == 3) ? "VOP" : "",
			(ulev == 4) ? "HOP" : "",
                        (ulev == 5) ? "AOP" : "",
                        (ulev == 10) ? "SOP" : "",
                        (ulev == 13) ? "Co-Founder" : "",
                        chan,
                        (identified)
                             ? "Identification" : "Recognition",
                        whom);
            }
        } else {
            notice(s_ChanServ, source, "Channel: \2%s\2 Nick: \2%s\2 (%s@%s) Access: Unknown", chan, nick, u->username, u->host);
        }
    } else {
       notice(s_ChanServ, source, "Nick %s not online", nick);
    }
}

static void do_flist(const char *source)
{
    char *cmd = strtok(NULL, " ");
    ChannelInfo *ci;
    unsigned int i;
    unsigned int totalaccess = 0;

    if (!cmd) {
        notice(s_ChanServ,source,"Syntax: \2FLIST\2 [HELD|MARKED|FORBIDDEN|FROZEN]");
        notice(s_ChanServ,source,"Syntax: \2FLIST\2 [AUTOOP|AUTOHOP|AUTOVOP|CHANJOIN]");
	notice(s_ChanServ,source,
	    "\2/msg %s OHELP FLIST\2 for more information",s_ChanServ);

    } else if (stricmp(cmd, "HELD") == 0) {
	notice(s_ChanServ,source,"\2HELD\2 channel listing:");
        for (i = 0; i < 256; ++i) {
            for (ci = chanlists[i]; ci; ci = ci->next) {
              if (ci->hold) {
                 notice(s_ChanServ,source,"%-20s %s",ci->name,ci->desc);
                 notice(s_ChanServ, source,"Set by: %s",ci->hold);
		 ++totalaccess;
              }
	    }
	}
	notice(s_ChanServ,source,"\2%d channels found, End of List\2", totalaccess);
    } else if (stricmp(cmd, "MARKED") == 0) {
        notice(s_ChanServ,source,"\2MARKED\2 channel listing:");
        for (i = 0; i < 256; ++i) {
            for (ci = chanlists[i]; ci; ci = ci->next) {
              if (ci->mark) {
                 notice(s_ChanServ,source,"%-20s  %s",ci->name,ci->desc);
                 notice(s_ChanServ, source,"Set by: %s",ci->mark);
		 ++totalaccess;
              }
            }
        }
	notice(s_ChanServ,source,"\2%d channels found, End of List\2", totalaccess);

    } else if (stricmp(cmd, "FROZEN") == 0) {
        notice(s_ChanServ,source,"\2FROZEN\2 channel listing:");
        for (i = 0; i < 256; ++i) {
            for (ci = chanlists[i]; ci; ci = ci->next) {
               if (ci->freeze) {
                  notice(s_ChanServ,source,"%-20s  %s",ci->name, ci->desc);
                 notice(s_ChanServ, source,"Set by: %s",ci->freeze);
		 ++totalaccess;
              }
            }
        }
	notice(s_ChanServ,source,"\2%d channels found, End of List\2", totalaccess);


    } else if (stricmp(cmd, "FORBIDDEN") == 0) {
        notice(s_ChanServ,source,"\2FORBIDDEN\2 channel listing:");
        for (i = 0; i < 256; ++i) {
            for (ci = chanlists[i]; ci; ci = ci->next) {
               if (ci->forbid) {
                 notice(s_ChanServ,source,"%s",ci->name);
                 notice(s_ChanServ, source,"Set by: %s",ci->forbid);
		 ++totalaccess;
              }
            }
        }
	notice(s_ChanServ,source,"\2%d channels found, End of List\2", totalaccess);


    } else if (stricmp(cmd, "AUTOOP") == 0) {
        notice(s_ChanServ,source,"\2AUTOOP\2 channel listing:");
        for (i = 0; i < 256; ++i) {
            for (ci = chanlists[i]; ci; ci = ci->next) {
               if (ci->flags & CI_AUTOOP) {
                 notice(s_ChanServ,source,"%s",ci->name);
		 ++totalaccess;
              }
            }
        }
	notice(s_ChanServ,source,"\2%d channels found, End of List\2", totalaccess);

    } else if (stricmp(cmd, "AUTOHOP") == 0) {
        notice(s_ChanServ,source,"\2AUTOHOP\2 channel listing:");
        for (i = 0; i < 256; ++i) {
            for (ci = chanlists[i]; ci; ci = ci->next) {
               if (ci->flags & CI_AUTOHOP) {
                 notice(s_ChanServ,source,"%s",ci->name);
		 ++totalaccess;
              }
            }
        }
	notice(s_ChanServ,source,"\2%d channels found, End of List\2", totalaccess);


    } else if (stricmp(cmd, "AUTOVOP") == 0) {
        notice(s_ChanServ,source,"\2AUTOVOP\2 channel listing:");
        for (i = 0; i < 256; ++i) {
            for (ci = chanlists[i]; ci; ci = ci->next) {
               if (ci->flags & CI_AUTOVOP) {
                 notice(s_ChanServ,source,"%s",ci->name);
		 ++totalaccess;
              }
            }
        }
	notice(s_ChanServ,source,"\2%d channels found, End of List\2", totalaccess);
  

    } else if (stricmp(cmd, "CHANJOIN") == 0) {
        notice(s_ChanServ,source,"\2CHANJOIN\2 channel listing:");
        for (i = 0; i < 256; ++i) {
            for (ci = chanlists[i]; ci; ci = ci->next) {
               if (ci->flags & CI_CHANJOIN) {
                 notice(s_ChanServ,source,"%s",ci->name);
		 ++totalaccess;
              }
            }
        }
	notice(s_ChanServ,source,"\2%d channels found, End of List\2", totalaccess);
  
    }
}

static void do_ostopic(const char *source)
{
    char *chan = strtok(NULL, " ");
    char *itopic = strtok(NULL, "");


    if (!chan || !itopic) {
       notice(s_ChanServ, source, "Syntax: \2TOPIC\2 <#channel> <topic>");

    } else if (!(findchan(chan))) {
       notice(s_ChanServ, source, "Channel %s doesn't exist!", chan);

    } else {

    send_cmd(s_ChanServ, "TOPIC %s %s 0 :%s (%s)", chan,
                source, itopic, source);
  }

}



static void do_level(const char *source)
{
    char *chan = strtok(NULL," ");
    char *who = strtok(NULL," ");
    ChannelInfo *ci;
    User *u = finduser(source);

    if (!chan || !who) {
        notice(s_ChanServ,source,"Syntax: \2LEVEL\2 <#channel> "
                "<to-whom>");
        notice (s_ChanServ,source,"Type: \2/msg %s HELP LEVEL\2 "
		"for more information.",s_ChanServ);
	return;
    }
    ci = cs_findchan(chan);
    if (!ci) {
	notice(s_ChanServ,source,"%s isnt registered.",chan);
	return;
    }
    if (!u)
	return;
    if (get_access(u,ci) < 13) {
	notice(s_ChanServ,source,"Permission Denied.");
	return;
    }
    if (stricmp(who,"OPERS") == 0) {
	if (ci->flags & CI_OPERONLY)
	    ci->flags &= ~CI_OPERONLY;
	if (ci->flags & CI_SOPONLY)
	    ci->flags &= ~CI_SOPONLY;
	if (ci->flags & CI_SAONLY)
	    ci->flags &= ~CI_SAONLY;
	if (ci->flags & CI_SRAONLY)
	    ci->flags &= ~CI_SRAONLY;
	if (ci->flags & CI_CODERONLY)
	    ci->flags &= ~CI_CODERONLY;
        if (ci->flags & CI_ABUSEONLY)
            ci->flags &= ~CI_ABUSEONLY;
	ci->flags |= CI_OPERONLY;
        notice(s_ChanServ,source,"LEVEL for \2%s\2 set to \2%s\2",
		chan,who);
	return;
    } else if (stricmp(who,"SOP") == 0) {
        if (ci->flags & CI_OPERONLY)
            ci->flags &= ~CI_OPERONLY;
        if (ci->flags & CI_SOPONLY)
            ci->flags &= ~CI_SOPONLY;
        if (ci->flags & CI_SAONLY)
            ci->flags &= ~CI_SAONLY;
        if (ci->flags & CI_SRAONLY)
            ci->flags &= ~CI_SRAONLY;
        if (ci->flags & CI_CODERONLY)
            ci->flags &= ~CI_CODERONLY;
        if (ci->flags & CI_ABUSEONLY)
            ci->flags &= ~CI_ABUSEONLY;
        ci->flags |= CI_SOPONLY;
        notice(s_ChanServ,source,"LEVEL for \2%s\2 set to \2%s\2",
                chan,who);
        return;
    } else if (stricmp(who,"SA") == 0) {
        if (ci->flags & CI_OPERONLY)
            ci->flags &= ~CI_OPERONLY;
        if (ci->flags & CI_SOPONLY)
            ci->flags &= ~CI_SOPONLY;
        if (ci->flags & CI_SAONLY)
            ci->flags &= ~CI_SAONLY;
        if (ci->flags & CI_SRAONLY)
            ci->flags &= ~CI_SRAONLY;
        if (ci->flags & CI_CODERONLY)
            ci->flags &= ~CI_CODERONLY;
        if (ci->flags & CI_ABUSEONLY)
            ci->flags &= ~CI_ABUSEONLY;
        ci->flags |= CI_SAONLY;
        notice(s_ChanServ,source,"LEVEL for \2%s\2 set to \2%s\2",
                chan,who);
        return;
    } else if (stricmp(who,"SRA") == 0) {
        if (ci->flags & CI_OPERONLY)
            ci->flags &= ~CI_OPERONLY;
        if (ci->flags & CI_SOPONLY)
            ci->flags &= ~CI_SOPONLY;
        if (ci->flags & CI_SAONLY)
            ci->flags &= ~CI_SAONLY;
        if (ci->flags & CI_SRAONLY)
            ci->flags &= ~CI_SRAONLY;
        if (ci->flags & CI_CODERONLY)
            ci->flags &= ~CI_CODERONLY;
        if (ci->flags & CI_ABUSEONLY)
            ci->flags &= ~CI_ABUSEONLY;
        ci->flags |= CI_SRAONLY;
        notice(s_ChanServ,source,"LEVEL for \2%s\2 set to \2%s\2",
                chan,who);
        return;
    } else if (stricmp(who,"MASTERS") == 0) {
        if (ci->flags & CI_OPERONLY)
            ci->flags &= ~CI_OPERONLY;
        if (ci->flags & CI_SOPONLY)
            ci->flags &= ~CI_SOPONLY;
        if (ci->flags & CI_SAONLY)
            ci->flags &= ~CI_SAONLY;
        if (ci->flags & CI_SRAONLY)
            ci->flags &= ~CI_SRAONLY;
        if (ci->flags & CI_CODERONLY)
            ci->flags &= ~CI_CODERONLY;
	if (ci->flags & CI_ABUSEONLY)
	    ci->flags &= ~CI_ABUSEONLY;
        ci->flags |= CI_CODERONLY;
        notice(s_ChanServ,source,"LEVEL for \2%s\2 set to \2%s\2",
                chan,who);
        return;
    } else if (stricmp(who,"ABUSE") == 0) {
        if (ci->flags & CI_OPERONLY)
            ci->flags &= ~CI_OPERONLY;
        if (ci->flags & CI_SOPONLY)
            ci->flags &= ~CI_SOPONLY;
        if (ci->flags & CI_SAONLY)
            ci->flags &= ~CI_SAONLY;
        if (ci->flags & CI_SRAONLY)
            ci->flags &= ~CI_SRAONLY;
        if (ci->flags & CI_CODERONLY)
            ci->flags &= ~CI_CODERONLY;
        if (ci->flags & CI_ABUSEONLY)
            ci->flags &= ~CI_ABUSEONLY;
        ci->flags |= CI_ABUSEONLY;
        notice(s_ChanServ,source,"LEVEL for \2%s\2 set to \2%s\2",
                chan,who);
        return;
    } else if (stricmp(who,"NONE") == 0) {
        if (ci->flags & CI_OPERONLY)
            ci->flags &= ~CI_OPERONLY;
        if (ci->flags & CI_SOPONLY)
            ci->flags &= ~CI_SOPONLY;
        if (ci->flags & CI_SAONLY)
            ci->flags &= ~CI_SAONLY;
        if (ci->flags & CI_SRAONLY)
            ci->flags &= ~CI_SRAONLY;
        if (ci->flags & CI_CODERONLY)
            ci->flags &= ~CI_CODERONLY;
        if (ci->flags & CI_ABUSEONLY)
            ci->flags &= ~CI_ABUSEONLY;
        notice(s_ChanServ,source,"LEVEL for \2%s\2 set to \2%s\2",
                chan,who);
        return;
    } else
        notice(s_ChanServ,source,"Unknown LEVEL who setting");
}
/*************************************************************************/

static void do_hold(const char *source)
{
	char *chan = strtok(NULL, " ");
	char *cmd = strtok(NULL, " ");
	char *reason = strtok(NULL, "");
	ChannelInfo *ci;
	User *u = finduser(source);

	if (!is_oper_cando(source, 3)) {
		notice(s_ChanServ, source, ERR_MOREFLAG);
		return;
	}

	if (!chan || !cmd) {
            notice(s_ChanServ,source,"Syntax: \2HOLD\2 <#channel> ON|OFF [reason]");
	    notice(s_ChanServ,source,"\2/msg %s OHELP HOLD\2 for more information.",s_ChanServ);
            return;
        }
	if (!(ci = cs_findchan(chan))) {
	    notice(s_ChanServ, source, "Channel %s is not registered.", chan);
	    return;
	}

	if (!stricmp(cmd,"ON")) {
	        if (!(ci->flags & CI_HELDCHAN)) {
		    if (reason && strlen(reason) > 150) {
	        	notice(s_ChanServ, source, "Reason too long.");
			return;
		    }
        	    ci->flags |= CI_HELDCHAN;
	            if (ci->hold)
        	          free(ci->hold);
	            ci->hold = sstrdup(u->nick);
		    if (ci->holdreason)
			  free(ci->holdreason);

		    if (reason)
			ci->holdreason = sstrdup(reason);

        	    wallops(s_ChanServ,"%s set the HELD flag for \2%s\2 reason: %s",u->nick,chan, reason?reason:"none");
	            slog("CS +H %s (%s!%s@%s)",
	                chan, u->nick, u->username, u->host);
        	    do_break_log("CS_F", "CS +H %s (%s!%s@%s)",
	                chan, u->nick, u->username, u->host);
		} else {
		    notice(s_ChanServ,source,"Channel \2%s\2 is already held",chan);
		}
	} else if (!stricmp(cmd,"OFF")) {
	    	 NickInfo *ni1;
		if (ci->flags & CI_HELDCHAN) {
		if (((ci->hold) && (ni1=findnick(ci->hold)) && (ni1->flags & NI_IDENTIFIED) && (stricmp(source, ci->hold) == 0)) || is_services_root(source)) {
        	  ci->flags &= ~CI_HELDCHAN;
	          if (ci->hold)
        	      free(ci->hold);
		  if (ci->holdreason)
			free(ci->holdreason);
	          ci->hold = NULL;
	          slog("CS -H %s (%s!%s@%s)",
        	      chan,u->nick,u->username,u->host);
	          do_break_log("CS_F", "CS -H %s (%s!%s@%s)",
        	      chan, u->nick, u->username, u->host);
	          wallops(s_ChanServ,
        	      "%s unset the HELD flag for \2%s\2",u->nick,chan);
		} else
        	  notice(s_ChanServ,source,"This Channel is held by other Admin.",chan);
	     } else {
        	  notice(s_ChanServ,source,"Channel \2%s\2 is not held.",chan);
	     }
	} else {
            notice(s_ChanServ,source,"Syntax: \2HOLD\2 <#channel> ON|OFF");
	}
}

/*************************************************************************/
static void do_mark(const char *source)
{
        char *chan = strtok(NULL, " ");
        char *cmd = strtok(NULL, " ");
        char *reason = strtok(NULL, "");
        ChannelInfo *ci;
        User *u = finduser(source);

        if (!chan || !cmd) {
            notice(s_ChanServ,source,"Syntax: \2MARK\2 <#channel> ON|OFF [reason]");
            notice(s_ChanServ,source,
		"\2/msg %s HELP MARK\2 for more information",s_ChanServ);
            return;
        }

	        if (!(ci = cs_findchan(chan))) { 
        	    notice(s_ChanServ, source, "Channel %s is not registered.",chan);
			return;
		}
		if (!stricmp(cmd,"ON")) {
	        if (!(ci->flags & CI_MARKCHAN)) {
		    if (reason && strlen(reason) > 150) {
	        	notice(s_ChanServ, source, "Reason too long.");
			return;
		    }
        	    ci->flags |= CI_MARKCHAN;
	            if (ci->mark)
        	        free(ci->mark);
		    if (ci->markreason)
			free(ci->markreason); 
	            ci->mark = sstrdup(u->nick);

		    if (reason)
			ci->markreason = sstrdup(reason);

        	    slog("CS +M %s (%s!%s@%s)",
	                chan, u->nick, u->username, u->host);
	            do_break_log("CS_F", "CS +M %s (%s!%s@%s)",
        	        chan, u->nick, u->username, u->host);
		wallops(s_ChanServ,
        	        "%s set the MARK flag for \2%s\2 reason: %s",u->nick,chan, reason?reason:"none");
			} else {
			    notice(s_ChanServ,source,"Channel \2%s\2 already marked.",chan);
			}
		} else if (!stricmp(cmd,"OFF")) {
			if (ci->flags & CI_MARKCHAN) {
				if (((ci->mark) && is_online(ci->mark) && (stricmp(source, ci->mark) == 0)) || is_services_root(source)) {
					ci->flags &= ~CI_MARKCHAN;
	        		if (ci->mark)
					free(ci->mark);
					ci->mark = NULL;
				if (ci->markreason) {
					free(ci->markreason);
					ci->markreason = NULL;
				}
        			slog("CS -M %s (%s!%s@%s)",
					chan,u->nick,u->username,u->host);
        			do_break_log("CS_F", "CS -M %s (%s!%s@%s)",
					chan, u->nick, u->username, u->host);
        			wallops(s_ChanServ,
					"%s unmarked the channel \2%s\2",u->nick,chan);
				} else
					notice(s_ChanServ,source,"This Channel is marked by another Admin.");
			} else {
        		  notice(s_ChanServ,source,"Channel \2%s\2 is not marked.",chan);
			}
		} else {
			notice(s_ChanServ,source,"Syntax: \2MARK\2 <#channel> ON|OFF");
		}
}

/*************************************************************************/

static void do_memolev(User *u, ChannelInfo *ci, const char *param)
{
   if (!param) {
      notice(s_ChanServ, u->nick,
        "Syntax: \2MEMO\2 <#channel> <level>");
      notice(s_ChanServ, u->nick,
         "For Help, Type \"/msg %s HELP SET MEMO\" for help.",
           s_MemoServ);
      return;
   }

   if (get_access(u, ci) < 13) {
      notice(s_ChanServ, u->nick, toknmsg[26], ci->name);
      return;
   }

   if (!(stricmp(param, "NONE") == 0) && (stricmp(param, "VOP") == 0)
      && (stricmp(param, "HOP") == 0) && (stricmp(param, "AOP") == 0) 
      && (stricmp(param, "SOP") == 0)
      && (stricmp(param, "CFOUNDER") == 0) && (stricmp(param, "CF") == 0)
      && (stricmp(param, "FOUNDER") == 0)) {
          notice(s_ChanServ, u->nick,
             "\2MEMO\2 options may only be NONE, VOP, HOP, AOP, SOP, CFOUNDER, or FOUNDER");
          return;
   }

   if (ci->flags & CI_MEMO_AV)
       ci->flags &= ~CI_MEMO_AV;
   if (ci->flags & CI_MEMO_HOP)
       ci->flags &= ~CI_MEMO_HOP;
   if (ci->flags & CI_MEMO_AOP)
       ci->flags &= ~CI_MEMO_AOP;
  if (ci->flags & CI_MEMO_SOP)
      ci->flags &= ~CI_MEMO_SOP;
  if (ci->flags & CI_MEMO_CF)
      ci->flags &= ~CI_MEMO_CF;
  if (ci->flags & CI_MEMO_FR)
      ci->flags &= ~CI_MEMO_FR;
  if (ci->flags & CI_MEMO_NONE)
      ci->flags &= ~CI_MEMO_NONE;

   if (stricmp(param, "NONE") == 0) {
       ci->flags |= CI_MEMO_NONE;
       notice(s_ChanServ, u->nick,
          "Channel Memos for %s are now disabled", ci->name);

   } else if (stricmp(param, "VOP") == 0) {
       ci->flags |= CI_MEMO_AV;
       notice(s_ChanServ, u->nick,
          "Memo level for %s is now set to \2%s\2", ci->name, param);

   } else if (stricmp(param, "HOP") == 0) {
       ci->flags |= CI_MEMO_HOP;
       notice(s_ChanServ, u->nick,
          "Memo level for %s is now set to \2%s\2", ci->name, param);

   } else if (stricmp(param, "AOP") == 0) {
       ci->flags |= CI_MEMO_AOP;
       notice(s_ChanServ, u->nick,
          "Memo level for %s is now set to \2%s\2", ci->name, param);

   } else if (stricmp(param, "SOP") == 0) {
       ci->flags |= CI_MEMO_SOP;
       notice(s_ChanServ, u->nick,
          "Memo level for %s is now set to \2%s\2", ci->name, param);

   } else if (stricmp(param, "CFOUNDER") == 0 || stricmp(param, "CF") == 0) {
       ci->flags |= CI_MEMO_CF;
       notice(s_ChanServ, u->nick,
          "Memo level for %s is now set to \2%s\2", ci->name, param);

   } else if (stricmp(param, "FOUNDER") == 0) {
       ci->flags |= CI_MEMO_FR;
       notice(s_ChanServ, u->nick,
          "Memo level for %s is now set to \2%s\2", ci->name, param);
   }
}

/*************************************************************************/

static void do_wipe(const char *source)
{
   ChannelInfo *ci;
   const char *chan = strtok(NULL, " ");
   const char *what = strtok(NULL, " ");
   ChanAccess *access1;
   AutoKick *akick;
   int i, c=0, c2=0, check=0, lev=0;

   if (!chan || !what) {
      notice(s_ChanServ, source,
         "Syntax: \2WIPE\2 <#channel> [CFOUNDER|SOP|AOP|HOP|VOP|AKICK|ALL]");
      return;

   }
   if (!(ci = cs_findchan(chan))) {
       notice(s_ChanServ, source,
          "Channel %s is not registered", chan);
       return;
   }

   if ((stricmp(what, "AKICK") == 0) || (stricmp(what, "ALL") == 0)) {
       for (akick = ci->akick, i = 0; ci->akickcount; ++akick, ++i) {
           free(akick->name);
           akick->name = NULL;
           if (akick->reason)
               free(akick->reason);
           ++c;
           --ci->akickcount;
          if (!ci->akickcount) {
              free(ci->akick);
              ci->akick = NULL;
          }
       }
   }

   if (stricmp(what, "CFOUNDER") == 0)
         (unsigned int)lev = 13;
   else if (stricmp(what, "SOP") == 0)
         (unsigned int)lev = 10;
   else if (stricmp(what, "AOP") == 0)
         (unsigned int)lev = 5;
   else if (stricmp(what, "HOP") == 0)
         (unsigned int)lev = 4;
   else if (stricmp(what, "VOP") == 0)
         (unsigned int)lev = 3;
   else if (stricmp(what, "ALL") == 0)
         (unsigned int)lev = 1;
   else if (stricmp(what, "AKICK") == 0)
         (unsigned int)lev = 0;
   else {
       notice(s_ChanServ, source,
           "Syntax: \2WIPE\2 <#channel> [CFOUNDER|SOP|AOP|HOP|VOP|AKICK|ALL]");
       return;
   }

   check = ci->accesscount;

   for (access1 = ci->access, i = 0; i < check; ++access1,++i) {

       if (!lev)
           break;

       if ((lev != access1->level) && (lev != 1))
           continue;

            free(access1->name);
            access1->name = NULL;
            free(access1->adder);
            access1->adder = NULL;
            access1->in_use = 0;
            ++c, ++c2;
            --ci->accesscount;
	   if (!ci->accesscount) {
        	   free(ci->access);
	           ci->access = NULL;
	           break;
	   }

            if ((i-c2) < ci->accesscount) {
		memmove(access1, access1+1, sizeof(ChanAccess) * (ci->accesscount - (i-c2)));
            --access1;
	    }
       } 


   switch(lev) {

	case 13:
	         wallops(s_ChanServ,
        	    "%s had me wipe the CFOUNDER list on %s [%d deleted]",
	            source, chan, c);
		return;
	case 10:
	         wallops(s_ChanServ,
	            "%s had me wipe the SOP list on %s [%d deleted]",
	            source, chan, c);
		return;
	case 5:
	         wallops(s_ChanServ,
	            "%s had me wipe the AOP list on %s [%d deleted]",
	            source, chan, c);
		return;
	case 4:
	         wallops(s_ChanServ,
	            "%s had me wipe the HOP list on %s [%d deleted]",
	            source, chan, c);
		return;
	case 3:
	         wallops(s_ChanServ,
	            "%s had me wipe the VOP list on %s [%d deleted]",
		    source, chan, c);
		return;
	case 1:
        	 wallops(s_ChanServ,
	            "%s had me wipe ALL access lists on %s [%d deleted]",
        	    source, chan, c);
		return;
	case 0:
	         wallops(s_ChanServ,
	            "%s had me wipe the akick list on %s [%d deleted]",
	            source, chan, c);
		return;
	}
}
/*************************************************************************/

int check_opguard(User *user, const char *chan, int newchan)
{
   ChannelInfo *ci;

    if (!(ci = cs_findchan(chan)))
        return 0;

    if ((newchan == 1) && ci->flags & CI_LEAVEOPS)
       	 return 0;

    if (ci->flags & CI_OPGUARD || (newchan == 1)) {
         if (!is_on_id_list(user->nick, user->nick))
              return 0;
         else if (check_access(user, ci, CA_AUTOVOICE))
              return 1;
         else
              return 0;
    } else

         return 1;

}

static int newcheck_opguard(ChannelInfo *ci, User *user, const char *chan, int newchan)
{

    if (ci->flags & CI_OPGUARD || (newchan == 1)) {
         if (!is_on_id_list(user->nick, user->nick))
              return 0;
         else if (check_access(user, ci, CA_AUTOVOICE))
              return 1;
         else
              return 0;
    } else

         return 1;

}

#ifdef DEFHALFOP
int check_hopguard(User *user, const char *chan, int newchan)
{
   ChannelInfo *ci;

    if (!(ci = cs_findchan(chan)))
        return 0;

    if (ci->botflag & CBI_HOPGUARD) {
         if (!is_on_id_list(user->nick, user->nick))
              return 0;
         else if (check_access(user, ci, CA_AUTOVOICE))
              return 1;
         else
              return 0;
    } else

       return 1;
}
#endif

/*************************************************************************/

int check_invite(User *user, const char *chan)
{
   ChannelInfo *ci;
   struct u_chanlist *c;
   Timeout *t;

   if (!(ci = cs_findchan(chan)))
        return 0;

   if (is_oper(user->nick))
	return 0;

   if (get_access(user, ci) > 0)
        return 1;

   if (hasmode("i", ci->mlock_on)) {
        send_cmd(s_ChanServ, "JOIN %s", chan);
        send_cmd(s_ChanServ, "MODE %s +b *!*@*", chan);
        t = add_timeout(CHANNEL_INHABIT, timeout_leave, 0);
        t->data = sstrdup(chan); 
        kick_user(s_ChanServ, chan, user->nick, "Sorry, Channel is invite only");
        for (c = user->chans; c && stricmp(chan, c->chan->name) != 0;
                                                               c = c->next)
            ;
        if (c)
           chan_deluser(user, c->chan);
        return 0;

   }
   return 1;

}

/**********************************************************/
void do_cs_join(const char *chan) {
	ChannelInfo *ci = cs_findchan (chan);
	if((ci) && (ci->flags & CI_CHANJOIN)) {
		send_cmd (s_ChanServ, "JOIN %s", chan);
		send_cmd (s_ChanServ, "MODE %s +oa %s %s", chan, s_ChanServ, s_ChanServ);
	}
}
/***********************************************************/
void do_cs_part(const char *chan) {
   ChannelInfo *ci = cs_findchan (chan);
	if((ci) && (ci->flags & CI_CHANJOIN)) {
		send_cmd (s_ChanServ, "PART %s :No more users in channel", chan);
	}
}
/***********************************************************/
static void do_setpass(const char *source)
{
    ChannelInfo *ci;
    char *chan = strtok(NULL, " ");
    char *newpass = strtok(NULL, " ");
    User *u = finduser(source);

    if ((!chan) || (!newpass)) {
        notice(s_ChanServ, source, "Syntax: \2SETPASS\2 <#channel> <password>");
        notice(s_ChanServ, source,
              "\2/MSG %s OHELP SETPASS\2 fo more information.",
              s_ChanServ);
	return;
    }
    if (readonly) {
	notice(s_ChanServ, source,
	    "Warning: Services is in read-only mode.  Changes will not be saved.");
    }

    if (!(ci = cs_findchan(chan)) || ci->forbid) {
           notice(s_ChanServ, source, "Channel %s is not registered", chan);
           return;
    }

    if(strlen(newpass) >= PASSMAX) { // Check len newpass
	notice(s_ChanServ, source, "New password %s too long", chan);
        return;
    }

    strscpy(ci->founderpass, newpass, PASSMAX);
    notice(s_ChanServ, u->nick,	"%s password changed to \2%s\2.", ci->name, ci->founderpass);
    show_u_next_db(u, s_ChanServ);
}

/***********************************************************************/
void do_doop(const char *source, NickInfo *ni)
{
    User *u = finduser(source);
    ChannelInfo *ci;
    struct u_chanlist *c1, *c2;

    if (u->chans != NULL) {
       c1 = u->chans;
       while (c1) {
        c2 = c1->next;
	if ((ci = cs_findchan(c1->chan->name)) && !(ci->flags & CI_FREEZECHAN)) {
		cimassop(u, ci, ni, c1->chan);
	}
	c1 = c2;
      }
    }


}
/************************************************************************/
char *inbadchannel(const char *source, ChannelInfo *ci)
{
    User *u = finduser(source);
    struct u_chanlist *c1, *c2;

    if (u->chans != NULL) {
       c1 = u->chans;
       while (c1) {
        c2 = c1->next;
	if (is_chanbadwords(ci, c1->chan->name))
		return c1->chan->name;
	c1 = c2;
      }
    }
	return NULL;
}
/************************************************************************/
void do_glist(const char *source)
{
    char *nick = strtok(NULL, " ");
    ChannelInfo *ci;
    NickInfo *ni, *hni;
    ChanAccess *access1;
    int i, i2=0;
    int totalaccess = 0;

    if (nick && (rec_services_admin(source) || is_on_id_list(source,nick))) {
	ni = findnick(nick);
    } else {
	ni = findnick(source);
    }
        if (!ni) {
                notice(s_NickServ,source,"Nick is not registerd.");
        } else {
	hni = nickhost(ni);
	if (hni) {
	notice(s_NickServ,source,"\2*** Access Listing ***\2");

        for (i = 33; i < 256; ++i) {
            for (ci = chanlists[i]; ci; ci = ci->next) {       
		if ((ci->founder) && (stricmp(hni->nick, ci->founder) == 0)) {
notice(s_NickServ, source,"\2Founder\2    in \37%s\37", ci->name);
	                 ++totalaccess;
		} else if ((ci->successor) && (stricmp(hni->nick, ci->successor) == 0)) {
	                 ++totalaccess;
notice(s_NickServ, source,"\2Successor\2  in \37%s\37", ci->name);
		} else {
		    for (access1 = ci->access, i2 = 0; i2 < ci->accesscount; ++access1, ++i2)
			if ((stricmp(hni->nick, access1->name) == 0)) {
		              if (access1->level == 3) {
notice(s_NickServ, source,"Vop        in %s (%s)",
ci->name, access1->adder?access1->adder:"Old Peoples");
		                 ++totalaccess;
		              } else if (access1->level == 4) {
notice(s_NickServ, source,"Hop        in %s (%s)",
ci->name, access1->adder?access1->adder:"Old Peoples");
		                 ++totalaccess;
		              } else if (access1->level ==  5) {
		                 ++totalaccess;
notice(s_NickServ, source,"Aop        in %s (%s)", 
ci->name, access1->adder?access1->adder:"Old Peoples");
		              } else if (access1->level == 10) {
		                 ++totalaccess;
notice(s_NickServ, source,"\37Sop\37        in \37%s\37 (%s)",
ci->name, access1->adder?access1->adder:"Old Peoples");
		              } else if (access1->level == 13) {
		                 ++totalaccess;
notice(s_NickServ, source,"\37CFounder\37   in \37%s\37 (%s)",
ci->name, access1->adder?access1->adder:"Old Peoples");
		              } else { }
			break;
			}
		}
            } /* End for ci */
        } /* End For i */
	notice(s_NickServ,source,"*** There are %d access found. --\2End of List\2",totalaccess);
        } /* if hni */
	} /* If ni */
}
/************************************************************************/
void do_expireabot(const char *nick)
{
    ChannelInfo *ci;
    int i;
    for (i = 0; i < 256; ++i)
	    for (ci = chanlists[i]; ci; ci = ci->next) {
		if (ci->bot && stricmp(ci->bot, nick)==0){
			ci->bot = NULL;
		}
	    }
}
/************************************************************************/
static void do_set_chanjoin(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;

    if (!stricmp(param, "ON")) {
	ci->flags |= CI_CHANJOIN;
	notice(s_ChanServ, source,"ChanServ will join %s.",chan);
        show_u_next_db(u, s_ChanServ);
		send_cmd (s_ChanServ, "JOIN %s", chan);
		send_cmd (s_ChanServ, "MODE %s +oa %s %s", chan, s_ChanServ, s_ChanServ);
    } else if (!stricmp(param, "OFF")) {

		ci->flags &= ~CI_CHANJOIN;
		notice(s_ChanServ, source, "Disable joining of ChanServ in %s.",chan);
		send_cmd (s_ChanServ, "PART %s :Leaving", chan);
        show_u_next_db(u, s_ChanServ);

    } else {
		notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s JOIN [ON|OFF]", chan);
		notice(s_ChanServ, source,
			"\2/msg %s HELP SET JOIN\2 for more information.", s_ChanServ);
    }
}
/************************************************************************/
static void do_voice (const char *source)
{
    char *chan = strtok (NULL, " ");
    char *op_params = strtok (NULL, " ");
    User *u = finduser (source);
    ChannelInfo *ci;

    if (!chan)
    {
        notice(s_ChanServ, source,"Syntax: \2VOICE\2 <#channel> <nick>");
        notice(s_ChanServ, source,"\2/msg %s HELP VOICE\2 for more information.", s_ChanServ);
    }

    else if (!findchan (chan))
        notice(s_ChanServ, source,
              "Channel %s does not currently exist (empty)", chan);

    else if (!is_on_chan((op_params) ? op_params : source, chan))
        if (op_params)
            notice (s_ChanServ, source, "User %s is not in %s", op_params, chan);
	else
            notice (s_ChanServ, source, "User %s is not in %s", source, chan);
    
    else if (!(ci = cs_findchan (chan)))
        notice (s_ChanServ, source, "Channel %s is not registered.", chan);

    else if (ci->flags & CI_VERBOTEN)
        notice (s_ChanServ, source, "Channel %s is forbid channel.", chan);

    else if (is_voiced((op_params) ? op_params : source, chan))
        if (op_params)
            notice (s_ChanServ, source, "%s already got voiced in %s", op_params, chan);
        else
            notice (s_ChanServ, source, "You already got voice in %s", chan);

    else if (!u || (get_access(u, ci) < 3))
            notice (s_ChanServ, source, toknmsg[26], chan);

    else if (ci->flags & CI_FREEZECHAN)
            notice (s_ChanServ, source, "This channel is freezed.");

    else if (!op_params)
    {
        change_cmode (s_ChanServ, chan, "+v", source);
	send_cmd(s_ChanServ, "NOTICE @%%+%s :%s used ChanServ VOICE: %s",
              chan, u->nick, source);
    }

    else if (finduser (op_params))
    {
        change_cmode (s_ChanServ, chan, "+v", finduser(op_params)->nick);
        notice (s_ChanServ, op_params, "You were voiced in %s by %s", chan, source);
	send_cmd(s_ChanServ, "NOTICE @%%+%s :%s used ChanServ VOICE: %s",
              chan, u->nick, op_params);
    }

    else
        notice (s_ChanServ, source, "Channel \2%s\2 is not currently in use.", op_params);
}
/****************************************************************************/
static void do_devoice (const char *source)
{
    char *chan = strtok (NULL, " ");
    char *op_params = strtok (NULL, " ");
    User *u = finduser (source);
    ChannelInfo *ci;

    if (!chan)
    {
        notice(s_ChanServ, source,"Syntax: \2DEVOICE\2 <#channel> <nick>");
        notice(s_ChanServ, source,"\2/msg %s HELP DEVOICE\2 for more information.", s_ChanServ);
    }

    else if (!findchan (chan))
        notice(s_ChanServ, source,
              "Channel %s does not currently exist (empty)", chan);

    else if (!is_on_chan((op_params) ? op_params : source, chan))
        if (op_params)
            notice (s_ChanServ, source, "User %s is not in %s", op_params, chan);
	else
            notice (s_ChanServ, source, "User %s is not in %s", source, chan);
    
    else if (!(ci = cs_findchan (chan)))
        notice (s_ChanServ, source, "Channel %s is not registered.", chan);

    else if (ci->flags & CI_VERBOTEN)
        notice (s_ChanServ, source, "Channel %s is forbid channel.", chan);

    else if (!is_voiced((op_params) ? op_params : source, chan))
        if (op_params)
            notice (s_ChanServ, source, "%s don't have voiced in %s yet.", op_params, chan);
        else
            notice (s_ChanServ, source, "You don't have voiced in %s yet.", chan);

    else if (!u || (get_access(u, ci) < 3))
            notice (s_ChanServ, source, toknmsg[26], chan);

    else if (ci->flags & CI_FREEZECHAN)
            notice (s_ChanServ, source, "This channel is freezed.");

    else if (!op_params)
    {
        change_cmode (s_ChanServ, chan, "-v", source);
	send_cmd(s_ChanServ, "NOTICE @%%+%s :%s used ChanServ DEVOICE: %s",
              chan, u->nick, source);
    }

    else if (finduser (op_params))
    {
        change_cmode (s_ChanServ, chan, "-v", finduser(op_params)->nick);
        notice (s_ChanServ, op_params, "You were devoiced in %s by %s", chan, source);
	send_cmd(s_ChanServ, "NOTICE @%%+%s :%s used ChanServ DEVOICE: %s",
              chan, u->nick, op_params);
    }

    else
        notice (s_ChanServ, source, "Channel \2%s\2 is not currently in use.", op_params);
}

/****************************************************************************/
#ifdef DEFHALFOP
static void do_halfop (const char *source)
{
    char *chan = strtok (NULL, " ");
    char *op_params = strtok (NULL, " ");
    User *u = finduser (source);
    ChannelInfo *ci;

    if (!chan)
    {
        notice(s_ChanServ, source,"Syntax: \2HALFOP\2 <#channel> <nick>");
        notice(s_ChanServ, source,"\2/msg %s HELP HALFOP\2 for more information.", s_ChanServ);
    }

    else if (!findchan (chan))
        notice(s_ChanServ, source,
              "Channel %s does not currently exist (empty)", chan);

    else if (!is_on_chan((op_params) ? op_params : source, chan))
        if (op_params)
            notice (s_ChanServ, source, "User %s is not in %s", op_params, chan);
	else
            notice (s_ChanServ, source, "User %s is not in %s", source, chan);
    
    else if (!(ci = cs_findchan (chan)))
        notice (s_ChanServ, source, "Channel %s is not registered.", chan);

    else if (ci->flags & CI_VERBOTEN)
        notice (s_ChanServ, source, "Channel %s is forbid channel.", chan);

    else if (is_chanhop((op_params) ? op_params : source, chan))
        if (op_params)
            notice (s_ChanServ, source, "%s already got halfop in %s", op_params, chan);
        else
            notice (s_ChanServ, source, "You already got halfop in %s", chan);

    else if (!u || (get_access(u, ci) < 4))
            notice (s_ChanServ, source, toknmsg[26], chan);

    else if (ci->flags & CI_FREEZECHAN)
            notice (s_ChanServ, source, "This channel is freezed.");

    else if (!op_params)
    {
        change_cmode (s_ChanServ, chan, "+h", source);
	send_cmd(s_ChanServ, "NOTICE @%%+%s :%s used ChanServ HALFOP: %s",
              chan, u->nick, source);
    }

    else if (finduser (op_params))
    {
        change_cmode (s_ChanServ, chan, "+h", finduser(op_params)->nick);
        notice (s_ChanServ, op_params, "You were halfop in %s by %s", chan, source);
	send_cmd(s_ChanServ, "NOTICE @%%+%s :%s used ChanServ HALFOP: %s",
              chan, u->nick, op_params);
    }

    else
        notice (s_ChanServ, source, "Channel \2%s\2 is not currently in use.", op_params);
}
/****************************************************************************/
static void do_dehalfop (const char *source)
{
    char *chan = strtok (NULL, " ");
    char *op_params = strtok (NULL, " ");
    User *u = finduser (source);
    ChannelInfo *ci;

    if (!chan)
    {
        notice(s_ChanServ, source,"Syntax: \2DEHALFOP\2 <#channel> <nick>");
        notice(s_ChanServ, source,"\2/msg %s HELP DEHALFOP\2 for more information.", s_ChanServ);
    }

    else if (!findchan (chan))
        notice(s_ChanServ, source,
              "Channel %s does not currently exist (empty)", chan);

    else if (!is_on_chan((op_params) ? op_params : source, chan))
        if (op_params)
            notice (s_ChanServ, source, "User %s is not in %s", op_params, chan);
	else
            notice (s_ChanServ, source, "User %s is not in %s", source, chan);
    
    else if (!(ci = cs_findchan (chan)))
        notice (s_ChanServ, source, "Channel %s is not registered.", chan);

    else if (ci->flags & CI_VERBOTEN)
        notice (s_ChanServ, source, "Channel %s is forbid channel.", chan);

    else if (!is_chanhop((op_params) ? op_params : source, chan))
        if (op_params)
            notice (s_ChanServ, source, "%s don't have halfop in %s yet.", op_params, chan);
        else
            notice (s_ChanServ, source, "You don't have halfop in %s yet.", chan);

    else if (!u || (get_access(u, ci) < 4))
            notice (s_ChanServ, source, toknmsg[26], chan);

    else if (ci->flags & CI_FREEZECHAN)
            notice (s_ChanServ, source, "This channel is freezed.");

    else if (!op_params)
    {
        change_cmode (s_ChanServ, chan, "-h", source);
	send_cmd(s_ChanServ, "NOTICE @%%+%s :%s used ChanServ DEHALFOP: %s",
              chan, u->nick, source);
    }

    else if (finduser (op_params))
    {
        change_cmode (s_ChanServ, chan, "-h", finduser(op_params)->nick);
        notice (s_ChanServ, op_params, "You were dehalfop in %s by %s", chan, source);
	send_cmd(s_ChanServ, "NOTICE @%%+%s :%s used ChanServ DEHALFOP: %s",
              chan, u->nick, op_params);
    }

    else
        notice (s_ChanServ, source, "Channel \2%s\2 is not currently in use.", op_params);
}
#endif
/***************************************************************************/

/* 
** Thanks for Wrecked Services Source Code :)
** You have better idea skold :P
*/

static void do_op (const char *source)
{
    char *chan = strtok (NULL, " ");
    char *op_params = strtok (NULL, " ");
    User *u = finduser (source);
    ChannelInfo *ci;

    if (!chan) {
        notice(s_ChanServ, source,"Syntax: \2OP\2 <#channel> <nick>");
        notice(s_ChanServ, source,"\2/msg %s HELP OP\2 for more information.", s_ChanServ);
    } else if (!findchan (chan))
        notice(s_ChanServ, source,
              "Channel %s does not currently exist (empty)", chan);
    else if (!is_on_chan((op_params) ? op_params : source, chan))
        if (op_params)
            notice (s_ChanServ, source, "User %s is not in %s", op_params, chan);
	else
            notice (s_ChanServ, source, "User %s is not in %s", source, chan);
        else if (!(ci = cs_findchan (chan)))
        notice (s_ChanServ, source, "Channel %s is not registered.", chan);
    else if (ci->flags & CI_VERBOTEN)
        notice (s_ChanServ, source, "Channel %s is forbid channel.", chan);

    else if (is_chanop((op_params) ? op_params : source, chan))
        if (op_params)
            notice (s_ChanServ, source, "%s already got op in %s", op_params, chan);
        else
            notice (s_ChanServ, source, "You already got op in %s", chan);
    else if (!u || (get_access(u, ci) < 5))
            notice (s_ChanServ, source, toknmsg[26], chan);
    else if (ci->flags & CI_FREEZECHAN)
            notice (s_ChanServ, source, "This channel is freezed.");
    else if (!op_params) {
        change_cmode (s_ChanServ, chan, "+o", source);
    } else if (finduser (op_params)) {
        change_cmode (s_ChanServ, chan, "+o", finduser(op_params)->nick);
        notice (s_ChanServ, op_params, "You were op in %s by %s", chan, source);
	send_cmd(s_ChanServ, "NOTICE @%%+%s :%s used ChanServ OP: %s",
              chan, u->nick, op_params);
    } else
        notice (s_ChanServ, source, "Channel \2%s\2 is not currently in use.", op_params);
}
/****************************************************************************/
static void do_deop (const char *source)
{
    char *chan = strtok (NULL, " ");
    char *op_params = strtok (NULL, " ");
    User *u2, *u = finduser (source);
    ChannelInfo *ci;

    if (op_params) {
	u2 = finduser (op_params);
    }
    if (!chan) {
        notice(s_ChanServ, source,"Syntax: \2DEOP\2 <#channel> <nick>");
        notice(s_ChanServ, source,"\2/msg %s HELP DEOP\2 for more information.", s_ChanServ);
    } else if (!findchan (chan))
        notice(s_ChanServ, source,
              "Channel %s does not currently exist (empty)", chan);

    else if (!is_on_chan((op_params) ? op_params : source, chan))
        if (op_params)
            notice (s_ChanServ, source, "User %s is not in %s", op_params, chan);
	else
            notice (s_ChanServ, source, "User %s is not in %s", source, chan);
    
    else if (!(ci = cs_findchan (chan)))
        notice (s_ChanServ, source, "Channel %s is not registered.", chan);

    else if (ci->flags & CI_VERBOTEN)
        notice (s_ChanServ, source, "Channel %s is forbid channel.", chan);

    else if (!is_chanop((op_params) ? op_params : source, chan))
        if (op_params)
            notice (s_ChanServ, source, "%s don't have op in %s yet.", op_params, chan);
        else
            notice (s_ChanServ, source, "You don't have op in %s yet.", chan);

    else if (!u || (get_access(u, ci) < 5))
            notice (s_ChanServ, source, toknmsg[26], chan);
    else if (ci->flags & CI_FREEZECHAN)
            notice (s_ChanServ, source, "This channel is freezed.");
    else if (!op_params) {
        change_cmode (s_ChanServ, chan, "-o", source);
    } else if (u2) {
	if (get_access(u, ci) < get_access(u2, ci)) {
        notice (s_ChanServ, source, toknmsg[30]);
	} else {
        change_cmode (s_ChanServ, chan, "-o", finduser(op_params)->nick);
        notice (s_ChanServ, op_params, "You were deop in %s by %s", chan, source);
	send_cmd(s_ChanServ, "NOTICE @%%+%s :%s used ChanServ DEOP: %s",
              chan, u->nick, op_params);
	}
    }
    else
        notice (s_ChanServ, source, "Channel \2%s\2 is not currently in use.", op_params);
}
/***************************************************************************/
#ifdef DEFPROTECT
static void do_protect (const char *source)
{
    char *chan = strtok (NULL, " ");
    char *op_params = strtok (NULL, " ");
    User *u = finduser (source);
    ChannelInfo *ci;

    if (!chan)
    {
        notice(s_ChanServ, source,"Syntax: \2PROTECT\2 <#channel> <nick>");
        notice(s_ChanServ, source,"\2/msg %s HELP PROTECT\2 for more information.", s_ChanServ);
    }

    else if (!findchan (chan))
        notice(s_ChanServ, source,
              "Channel %s does not currently exist (empty)", chan);

    else if (!is_on_chan((op_params) ? op_params : source, chan))
        if (op_params)
            notice (s_ChanServ, source, "User %s is not in %s", op_params, chan);
	else
            notice (s_ChanServ, source, "User %s is not in %s", source, chan);
    
    else if (!(ci = cs_findchan (chan)))
        notice (s_ChanServ, source, "Channel %s is not registered.", chan);

    else if (ci->flags & CI_VERBOTEN)
        notice (s_ChanServ, source, "Channel %s is forbid channel.", chan);

    else if (is_prots((op_params) ? op_params : source, chan))
        if (op_params)
            notice (s_ChanServ, source, "%s already got protect in %s", op_params, chan);
        else
            notice (s_ChanServ, source, "You already got protect in %s", chan);

    else if (!u || (get_access(u, ci) < 10))
            notice (s_ChanServ, source, toknmsg[26], chan);

    else if (ci->flags & CI_FREEZECHAN)
            notice (s_ChanServ, source, "This channel is freezed.");

    else if (!op_params)
    {
#if defined(LIQUID) || defined(RAGEIRCD)
        change_cmode (s_ChanServ, chan, "+u", source);
#else
        change_cmode (s_ChanServ, chan, "+a", source);
#endif
    }

    else if (finduser (op_params))
    {
#if defined(LIQUID) || defined(RAGEIRCD)
        change_cmode (s_ChanServ, chan, "+u", finduser(op_params)->nick);
#else
        change_cmode (s_ChanServ, chan, "+a", finduser(op_params)->nick);
#endif
        notice (s_ChanServ, op_params, "You were protected in %s by %s", chan, source);
	send_cmd(s_ChanServ, "NOTICE @%%+%s :%s used ChanServ PROTECT: %s",
              chan, u->nick, op_params);
    }
    else
        notice (s_ChanServ, source, "Channel \2%s\2 is not currently in use.", op_params);
}

/***************************************************************************/
static void do_deprotect (const char *source)
{
    char *chan = strtok (NULL, " ");
    char *op_params = strtok (NULL, " ");
    User *u = finduser (source);
    ChannelInfo *ci;

    if (!chan)
    {
        notice(s_ChanServ, source,"Syntax: \2DEPROTECT\2 <#channel> <nick>");
        notice(s_ChanServ, source,"\2/msg %s HELP DEPROTECT\2 for more information.", s_ChanServ);
    }

    else if (!findchan (chan))
        notice(s_ChanServ, source,
              "Channel %s does not currently exist (empty)", chan);

    else if (!is_on_chan((op_params) ? op_params : source, chan))
        if (op_params)
            notice (s_ChanServ, source, "User %s is not in %s", op_params, chan);
	else
            notice (s_ChanServ, source, "User %s is not in %s", source, chan);
    
    else if (!(ci = cs_findchan (chan)))
        notice (s_ChanServ, source, "Channel %s is not registered.", chan);

    else if (ci->flags & CI_VERBOTEN)
        notice (s_ChanServ, source, "Channel %s is forbid channel.", chan);

    else if (!is_prots((op_params) ? op_params : source, chan))
        if (op_params)
            notice (s_ChanServ, source, "%s don't have protect in %s yet.", op_params, chan);
        else
            notice (s_ChanServ, source, "You don't have protect in %s yet.", chan);

    else if (!u || (get_access(u, ci) < 10))
            notice (s_ChanServ, source, toknmsg[26], chan);

    else if (ci->flags & CI_FREEZECHAN)
            notice (s_ChanServ, source, "This channel is freezed.");

    else if (!op_params)
    {
#if defined(LIQUID) || defined(RAGEIRCD)
        change_cmode (s_ChanServ, chan, "-u", source);
#else
        change_cmode (s_ChanServ, chan, "-a", source);
#endif
    }

    else if (finduser (op_params))
    {
#if defined(LIQUID) || defined(RAGEIRCD)
        change_cmode (s_ChanServ, chan, "-u", finduser(op_params)->nick);
#else
        change_cmode (s_ChanServ, chan, "-a", finduser(op_params)->nick);
#endif
        notice (s_ChanServ, op_params, "You were deprotect in %s by %s", chan, source);
	send_cmd(s_ChanServ, "NOTICE @%%+%s :%s used ChanServ DEPROTECT: %s",
              chan, u->nick, op_params);
    }

    else
        notice (s_ChanServ, source, "Channel \2%s\2 is not currently in use.", op_params);
}
#endif
/***************************************************************************/
static void do_setfounder(const char *source)
{
    ChannelInfo *ci;
    NickInfo *ni;
    char *chan = strtok(NULL, " ");
    char *newfounder = strtok(NULL, " ");
    User *u = finduser(source);

    if (!chan || !newfounder) {
        notice(s_ChanServ, source, "Syntax: \2SETFOUNDER\2 <#channel> <nick>");
        notice(s_ChanServ, source,
              "\2/MSG %s OHELP SETFOUNDER\2 fo more information.",
              s_ChanServ);
	return;
    }
    if (readonly) {
	notice(s_ChanServ, source,
	    "Warning: Services is in read-only mode.  Changes will not be saved.");
    }

    ci = cs_findchan(chan);
    if (!ci) {
           notice(s_ChanServ, source, "channel %s is not registered.", chan);
	   return;
    }
    if (ci->forbid) {
          notice(s_ChanServ, source, "Channel %s is not registered", chan);
          return;
        }
    ni = findnick(newfounder);

    if (!ni) {
           notice(s_ChanServ, source, "Nick %s is not registered.", newfounder);
	   return;
    }
    strscpy(ci->founder, newfounder, NICKMAX);
    notice(s_ChanServ, u->nick,	"%s founder transfer to \2%s\2.", ci->name, ci->founder);
    show_u_next_db(u, s_ChanServ);
}
/******************************************************************/
static void do_set_successor(User *u, ChannelInfo *ci, const char *param)
{
    NickInfo *ni;

    if (!param) {
	return;
    } else if (stricmp(param,  "NONE")==0) {
        notice(s_ChanServ, u->nick, "Clean Successor on \2%s\2.", ci->name);
        ci->successor = NULL;
        show_u_next_db(u, s_ChanServ);
	return;
    }

    ni = findnick(param);

    if (!ni) {
       notice(s_ChanServ, u->nick,
           "You must be using a registered nick");
    } else {
	if (stricmp(ni->nick, ci->founder) == 0) {
	       notice(s_ChanServ, u->nick,
        	   "Trying to add yourself?");
		return;
	}
        if (ni->flags & NI_NOOP) {
	        notice(s_ChanServ, u->nick,
        	   "Current user have NOOP flag set.");
		return;
	}

        if (ni && ni->forbid) {
           notice(s_ChanServ, u->nick, "Forbidden nick %s not permitted to be added to channel access lists", ni->nick);
           return;
        }

        if (ni->flags & NI_SLAVE) {
           notice(s_ChanServ, u->nick, "%s is a slave nick, please add nick %s a master of this nick.", ni->nick, ni->last_usermask);
           return;
        }

        if (ni->flags & NI_FREEZE) {
           notice(s_ChanServ, u->nick, "Frozen nick %s not permitted to be added to channel access lists", ni->nick);
           return;
        }

        ci->successor = ni->nick;
        notice(s_ChanServ, u->nick,
                        "\2%s\2 was add to a Successor on \2%s\2.",
                        ni->nick, ci->name);
	if (ci->botflag & CBI_VERBOSE)
	opnotice (s_ChanServ, ci->name, "[VERBOSE] %s added %s to channel Successor.", u->nick, ni->nick);
	if (ni && finduser(ni->nick))
	    if (ni->flags & NI_IDENTIFIED) {
		if (is_on_chan(ni->nick, ci->name))
			if (!is_chanop(ni->nick, ci->name))
				send_cmd(s_ChanServ, "MODE %s +o %s", ci->name, ni->nick);
	        notice(s_ChanServ, ni->nick, "\2%s\2 added you as Successor in channel \2%s\2.", u->nick, ci->name);
	    }
        show_u_next_db(u, s_ChanServ);
    }

}
/***********************************************************************/
static void do_unset_successor(User *u, ChannelInfo *ci, char *param)
{
        notice(s_ChanServ, u->nick, "Clean Successor on \2%s\2.", ci->name);
        ci->successor = NULL;
	if (ci->botflag & CBI_VERBOSE)
	opnotice (s_ChanServ, ci->name, "[VERBOSE] %s set channel unset Successor.", u->nick);
        show_u_next_db(u, s_ChanServ);
}
/**************************************************************************/
void expire_ur_chans()
{
    ChannelInfo *ci, *next;
    int i;
    NickInfo *ni;

    for (i = 33; i < 256; ++i) {
	for (ci = chanlists[i]; ci; ci = next) {
	    next = ci->next;
            ni = findnick(ci->founder);
	    if (!(ni) && (ci->successor) && !(ci->flags & CI_VERBOTEN)) {
		ni = findnick(ci->successor);
		if(ni) {
			strcpy(ci->founder, ci->successor);
			ci->successor = NULL;
	                slog("CS X %s -> %s", ci->name, ci->founder);
		}
	    }

            if (!(ni) && !(ci->flags & CI_VERBOTEN)) {
                slog("CS X %s", ci->name);
                do_break_log("CS_X", "CS X %s", ci->name);
		log("Expiring channel %s", ci->name);
		delchan(ci);
	    }
	}
    }
}
/*****************************************************************/
static void do_set_autovop(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;

    if (stricmp(param, "ON") == 0) {

	ci->flags |= CI_AUTOVOP;
	if (ci->flags & CI_AUTOOP)
		ci->flags &= ~CI_AUTOOP;
	if (ci->flags & CI_AUTOHOP)
		ci->flags &= ~CI_AUTOHOP;
	notice(s_ChanServ, source,
		"ChanServ now auto +v to all user on join.");
        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "OFF") == 0) {

	ci->flags &= ~CI_AUTOVOP;
	notice(s_ChanServ, source,
		"Auto +v is now \2OFF\2.");
        show_u_next_db(u, s_ChanServ);

    } else {

	notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s AUTOVOP [ON|OFF]", chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP SET AUTOVOP\2 for more information.",
		s_ChanServ);
    }
}
/*******************************************************************/
static void do_set_autoop(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;

    if (stricmp(param, "ON") == 0) {

	ci->flags |= CI_AUTOOP;
	if (ci->flags & CI_AUTOHOP)
		ci->flags &= ~CI_AUTOHOP;
	if (ci->flags & CI_AUTOVOP)
		ci->flags &= ~CI_AUTOVOP;
	notice(s_ChanServ, source,
		"ChanServ now auto +o to all user on join.");
        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "OFF") == 0) {

	ci->flags &= ~CI_AUTOOP;
	notice(s_ChanServ, source,
		"Auto +o is now \2OFF\2.");
        show_u_next_db(u, s_ChanServ);

    } else {

	notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s AUTOOP [ON|OFF]", chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP SET AUTOOP\2 for more information.",
		s_ChanServ);
    }
}
/*********************************************************************/
static void do_set_autohop(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;

    if (stricmp(param, "ON") == 0) {

	ci->flags |= CI_AUTOHOP;
	if (ci->flags & CI_AUTOOP)
		ci->flags &= ~CI_AUTOOP;
	if (ci->flags & CI_AUTOVOP)
		ci->flags &= ~CI_AUTOVOP;
	notice(s_ChanServ, source,
		"ChanServ now auto +h to all user on join.");
        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "OFF") == 0) {

	ci->flags &= ~CI_AUTOHOP;
	notice(s_ChanServ, source,
		"Auto +h is now \2OFF\2.");
        show_u_next_db(u, s_ChanServ);

    } else {

	notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s AUTOHOP [ON|OFF]", chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP SET AUTOHOP\2 for more information.",
		s_ChanServ);
    }
}
/***********************************************************************/
char whoadded[512];
char *addedby(ChannelInfo *ci, const char *nick)
{
	User *u = finduser(nick);
        char timebuf[64];
        struct tm tm;
        tm = *localtime(&CTime);
	strftime (timebuf, sizeof (timebuf), "%a %b %d %H:%M:%S %Y %Z", &tm);
        timebuf[sizeof(timebuf)-1] = 0;

	*whoadded = 0;
	if (!u)
		return "I Don't know ;P";
	sprintf(whoadded, "%s \2via:\2%s - (%s) - %s", nick, who_access(u,ci), u->host, timebuf);
	return whoadded;
}

/*end*/


/*****************************************************/
static void do_set_newsset(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;

    if (stricmp(param, "ON") == 0) {
	ci->botflag |= CBI_NORMALMSG;
	notice(s_ChanServ, source,
		"Channel news now show in Normal Message.");

        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "OFF") == 0) {
	ci->botflag &= ~CBI_NORMALMSG;
	notice(s_ChanServ, source,
		"Channel news now show in notice messages.");
        show_u_next_db(u, s_ChanServ);

    } else {
	notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s NEWSSET [ON|OFF]", chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP SET NEWSSET\2 for more information.",
		s_ChanServ);
    }
}
/*******************************************************/
static void do_set_leaveop(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;

    if (stricmp(param, "ON") == 0) {
	ci->flags |= CI_LEAVEOPS;
	notice(s_ChanServ, source,
		"Enable LeaveOP flag..");

        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "OFF") == 0) {
	ci->flags &= ~CI_LEAVEOPS;
	notice(s_ChanServ, source,
		"Disable LeaveOP flag.");
        show_u_next_db(u, s_ChanServ);

    } else {
	notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s LEAVEOP [ON|OFF]", chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP SET LEAVEOP\2 for more information.",
		s_ChanServ);
    }
}
/*******************************************************/
static void do_set_verbose(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;

    if (stricmp(param, "ON") == 0) {
	ci->botflag |= CBI_VERBOSE;
	notice(s_ChanServ, source,
		"Enable VERBOSE flag..");

        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "OFF") == 0) {
	ci->botflag &= ~CBI_VERBOSE;
	notice(s_ChanServ, source,
		"Disable VERBOSE flag.");
        show_u_next_db(u, s_ChanServ);

    } else {
	notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s VERBOSE [ON|OFF]", chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP SET VERBOSE\2 for more information.",
		s_ChanServ);
    }
}
/*******************************************************/
static void do_set_badchan(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;

    if (stricmp(param, "ON") == 0) {
	ci->botflag |= CBI_BADCHAN;
	notice(s_ChanServ, source,
		"ChanServ will akick user who have join badword channel.");

        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "OFF") == 0) {
	ci->botflag &= ~CBI_BADCHAN;
	notice(s_ChanServ, source,
		"Badword channel detect off.");
        show_u_next_db(u, s_ChanServ);

    } else {
	notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s BADCHAN [ON|OFF]", chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP SET BADCHAN\2 for more information.",
		s_ChanServ);
    }
}
/*******************************************************/
static void do_set_gb(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;

    if (stricmp(param, "ON") == 0) {
	ci->botflag |= CBI_NOGB;
	notice(s_ChanServ, source,
		"ChanServ will not using Global Badword in this channel.");

        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "OFF") == 0) {
	ci->botflag &= ~CBI_NOGB;
	notice(s_ChanServ, source,
		"Global Badword is using in this channel.");
        show_u_next_db(u, s_ChanServ);

    } else {
	notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s NOGB [ON|OFF]", chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP SET NOGB\2 for more information.",
		s_ChanServ);
    }
}
/*******************************************************/
static void do_set_protect(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;

    if (stricmp(param, "ON") == 0) {
	ci->botflag |= CBI_PROTECT;
	notice(s_ChanServ, source,
		"ChanServ will re-op when user trying to deop an AOP.");

        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "OFF") == 0) {
	ci->botflag &= ~CBI_PROTECT;
	notice(s_ChanServ, source,
		"Protect AOP off.");
        show_u_next_db(u, s_ChanServ);

    } else {
	notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s PROTECT [ON|OFF]", chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP SET PROTECT\2 for more information.",
		s_ChanServ);
    }
}
/*******************************************************/
static void do_set_badnick(User *u, ChannelInfo *ci, const char *param)
{
    char *source = u->nick, *chan = ci->name;

    if (stricmp(param, "ON") == 0) {
	ci->botflag |= CBI_BADNICK;
	notice(s_ChanServ, source,
		"ChanServ will akick user who have bad identify/nick/realhost/realname.");

        show_u_next_db(u, s_ChanServ);

    } else if (stricmp(param, "OFF") == 0) {
	ci->botflag &= ~CBI_BADNICK;
	notice(s_ChanServ, source,
		"No akicking user who have bad nick.");
        show_u_next_db(u, s_ChanServ);

    } else {
	notice(s_ChanServ, source,
                "Syntax: \2SET\2 %s BADNICK [ON|OFF]", chan);
	notice(s_ChanServ, source,
		"\2/msg %s HELP SET BADNICK\2 for more information.",
		s_ChanServ);
    }
}
/*******************************************************/
void do_lautoop (const char *nick, const char *chan, int acc) {
        User *u;

        if (!(u = finduser(nick)))
                return;

        if (is_on_chan(nick, chan)) {
        if (acc > 4) {
		if (!is_chanop(nick, chan))
		change_cmode (s_ChanServ, chan, "+o", nick);
#ifdef DEFHALFOP
        } else if (acc == 4) {
		if (!is_chanhop(nick, chan))
		change_cmode (s_ChanServ, chan, "+h", nick);
#endif
        } else if (acc == 3) {
		if (!is_voiced(nick, chan))
		change_cmode (s_ChanServ, chan, "+v", nick);
	} }
}
/****************************************************************/


/*************************************************************************/
void do_checkbot()
{
    ChannelInfo *ci;
    unsigned int i;
    for (i = 33; i < 256; ++i)
        for (ci = chanlists[i]; ci; ci = ci->next) {
		if (ci->botflag & CBI_BOTSTAY)
			botjoin2(ci);
	}
}
/*****************************************/
void do_checkbot2(char *nick)
{
    ChannelInfo *ci;
    unsigned int i;
    for (i = 33; i < 256; ++i)
        for (ci = chanlists[i]; ci; ci = ci->next)
		if (ci->bot && (stricmp(nick, ci->bot) == 0))
			botjoin2(ci);
}
/*****************************************/
void do_checkbotpart(char *nick, char *newbot)
{
    ChannelInfo *ci;
    unsigned int i;
    for (i = 33; i < 256; ++i)
        for (ci = chanlists[i]; ci; ci = ci->next)
		if (ci->bot && (stricmp(nick, ci->bot) == 0))
			botpart2(ci, newbot);
}

/********************************************************************/
int is_badnick(ChannelInfo *ci, char *text1, char *text2, char *text3, char *text4)
{
        int i;
        char **chanbads;

        if (!ci->badwords)
                return 0;

        for (chanbads = ci->badwords, i = 0; i < ci->badwline; ++chanbads, ++i) {
                if (match_wild_nocase(*chanbads, text1)
		||  match_wild_nocase(*chanbads, text2)
		||  match_wild_nocase(*chanbads, text3)
		||  match_wild_nocase(*chanbads, text4))
                        return 1;
        }
        return 0;
}


