/* Auspice functions.
 *
 * Auspice Services is copyright (c) 2000-2001 In Mean.
 *     E-mail: <auspice@auspice.org>
 *
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */

#include "../inc/services.h"
#ifdef WEBSERVICE
static void m_wwhois (const char *source);

char *s_WebServ = "WebServ";

void webserv (const char *source, char *buf)
{
    char *cmd, *s;
    char orig[BUFSIZE];
    char *tempstr = strtok(orig, " ");
    User *u = finduser(source);
    int x=0;
    if (!u)
	return;

    strscpy (orig, buf, sizeof (orig));
    cmd = strtok(buf, " ");
    if (u && (u->iswebtv==0)) {
	u->iswebtv=1;
	x=1;
    }
    if (!cmd) {
      	notice(s_WebServ, source, "Syntax: WebServ command");
    } else if (stricmp (cmd, "\1PING") == 0) {
        if (!(s = strtok (NULL, "")))
             s = "\1";
      	notice(s_WebServ, source, "\1PING %s", s);
    } else if (!stricmp (cmd, "\1VERSION\1")) {
       	if (!(s = strtok (NULL, "")))
            s = "\1";
        notice(s_WebServ, source, "%sVERSION Auspice IRC Services %s", s, s);
    } else if (!stricmp (cmd, "NICK")) {
/*
	char *subcmd = strtok(NULL, " ");
	if (!subcmd) {
	      	notice(s_WebServ, source, "NICK newnick");
	} else if (strlen(subcmd)>31) {
	      	notice(s_WebServ, source, "Your nick too long");
	} else if (is_badwords(subcmd)) {
	      	notice(s_WebServ, source, "This nick contain badword.");
	} else if (finduser(subcmd)) {
	      	notice(s_WebServ, source, "This nick already used.");
	} else if (is_servbot(subcmd)) {
	      	notice(s_WebServ, source, "This nick already used.");
	} else if (match_wild_nocase("*serv", subcmd)) {
	      	notice(s_WebServ, source, "This nick reserved for services.");
	} else {
	      	notice(s_WebServ, source, "Your nick is now %s.", subcmd);
		send_cmd(NULL, "SVSNICK %s %s :%lu", source, subcmd, CTime);
	}
*/
      	notice(s_WebServ, source, "Temperary down");

    } else if (!stricmp (cmd, "WHOIS")) {
	m_wwhois(source);
    } else if (!stricmp (cmd, "VERIFY")) {
	char *chan = strtok(NULL, " ");
	char *nick = strtok(NULL, " ");
	if (chan && nick) {
		Channel *c = findchan(chan);
		User *u = finduser(nick);
		if (c && u) {
		        struct u_chanlist *uc;
		        for (uc = u->chans; uc; uc = uc->next)
	                if (uc->chan == c) {
if (uc->status & CSTATUS_OP)
notice(s_WebServ, source, "%s(%s): OP",c->name, u->nick);
if (uc->status & CSTATUS_VOICE)
notice(s_WebServ, source, "%s(%s): VOICE",c->name, u->nick);
#ifdef DEFHALFOP
if (uc->status & CSTATUS_HALFOP)
notice(s_WebServ, source, "%s(%s): HALFOP",c->name, u->nick);
#endif
#ifdef DEFPROTECT
if (uc->status & CSTATUS_OWNER)
notice(s_WebServ, source, "%s(%s): OWNER",c->name, u->nick);
#endif
#ifdef UNREAL
if (uc->status & CSTATUS_PROTECT)
notice(s_WebServ, source, "%s(%s): PROTECT",c->name, u->nick);
#endif
			}
		}
	}
    } else if (!stricmp (cmd, "IDENTIFY")) {
	char *subcmd = strtok(NULL, " ");
	if (!subcmd) {
	      	notice(s_WebServ, source, "IDENTIFY <nick|chan>");
	} else if (*subcmd == '#') {
		tempstr = strtok(orig, " ");
		do_csidentify(source);
	} else {
		tempstr = strtok(orig, " ");
		do_nsidentify(source);
	}
    } else if (!stricmp (cmd, "REGISTER")) {
	char *subcmd = strtok(NULL, " ");
	if (!subcmd) {
	      	notice(s_WebServ, source, "REGISTER <nick|chan>");
	} else if (*subcmd == '#') {
		tempstr = strtok(orig, " ");
		do_csregister(source);
	} else {
		tempstr = strtok(orig, " ");
		do_nsregister(source);
	}
    } else if (!stricmp (cmd, "HELP")) {
        notice(s_WebServ, source, "IDENTIFY");
        notice(s_WebServ, source, "REGISTER");
        notice(s_WebServ, source, "WHOIS");
        notice(s_WebServ, source, "NICK");
    }
    if (x)
	u->iswebtv=0;
}
/*******************************************/
void m_wwhois (const char *source) {
	char *nick = strtok(NULL, " ");
        if (!nick) {
                notice(s_WebServ, source, "Syntax: /Msg WebServ WHOIS \2<Nick>\2");
                return;
        } else {
           User *u = finduser(nick);

           if(!u) {
                notice(s_WebServ, source, "%s: No Such nick",nick);
           } else {
                NickInfo *ani;
                int temp_time;
                notice(s_WebServ, source, "[ %s ] (%s@%s) : %s", nick, u->username, u->host, u->realname);
                if (is_oper(source))
                notice(s_WebServ, source, "[ %s ] real host: %s", nick, u->realhost);
                ani = findnick(nick);
                if (ani) {
                        if (ani->flags & NI_IDENTIFIED)
                                notice(s_WebServ, source, "[ %s ] is Identified",nick);
                        else
                                notice(s_WebServ, source, "[ %s ] is not Identified yet",nick);
                } else {
                notice(s_WebServ, source, "[ %s ] is not a registered nick",nick);
                }
#ifdef UNREAL
                if (!is_invisible(source)) {
#endif
                if (u->chans == NULL)
                        notice(s_WebServ, source, "[ %s ] not join any channel",nick);
                else {
                    struct u_chanlist *c, *c2;
                    char sbuf[512];
                    *sbuf = 0;
                    c = u->chans;
                    while (c) {
                        c2 = c->next;
                        if (*sbuf)
                            strcat(sbuf, ", ");
                        strcat(sbuf, c->chan->name);
                        c = c2;
                     }
                        notice(s_WebServ, source, "[ %s ] %s", nick, sbuf);
                }
                        notice(s_WebServ, source, "[ %s ] is on : %s", nick, u->server);
#ifdef UNREAL
}
                        if (!is_hideoper(source)) {
                        if (is_netadmin(nick))
                                notice(s_WebServ, source, "[ %s ] a Network Administrator",nick);
                        else if (is_techadmin(nick))
                                notice(s_WebServ, source, "[ %s ] a Technical Administrator",nick);
                        else if (is_admin(nick))
                                notice(s_WebServ, source, "[ %s ] a Server Administrator",nick);
                        else if (is_oper(nick))
#endif
                                notice(s_WebServ, source, "[ %s ] an IRC Operator",nick);
                        if (is_oper(nick) && is_services_admin(nick))
                                notice(s_WebServ, source, "[ %s ] a Services Administrator",nick);
#ifdef UNREAL
                        }
#endif
                     temp_time = 0;
                     temp_time = CTime - u->signon;
                     if (temp_time > 3600) {
                        temp_time /= 60;
                        notice(s_WebServ, source, "[ %s ] Online Time: %d hour%s %d minute%s",nick,

                           temp_time/60, temp_time/60==1 ? "" : "s",
                           temp_time%60, temp_time%60==1 ? "" : "s");
                     } else {
                        notice(s_WebServ, source, "[ %s ] Online Time: %d minute%s %d second%s",nick,
                        temp_time/60, temp_time/60==1 ? "" : "s",
                        temp_time%60, temp_time%60==1 ? "" : "s");
                     }

                        notice(s_WebServ, source, "[ %s ] Game Score: %d", nick, u->games);
                        notice(s_WebServ, source, "[ %s ] End of WHOIS list", nick);

            }
        } /* End of !nick */
}
#endif
