/*
 * Auspice Services is copyright (c) 2000-2001 In Mean
 *     E-mail: auspice@auspice.org
 * SirvNET Services is copyright (c) 1998-2000 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */

#include "../inc/services.h"

void save_netconf(void);
void save_msgconf(void);
int netconfnum = 46;
int netmsgnum = 29;
char *REMOTE_SERVER = NULL;
unsigned long REMOTE_PORT = 0;
char *PASSWORD = NULL;
char *SERVER_NAME = NULL;
char *SERVER_DESC = NULL;
char *SERVICES_USER = NULL;
char *SERVICES_HOST = NULL;
char *NETWORK_NAME = NULL;
char *SERVICES_MASTER = NULL;
char *server_num = "254";

char *remote_server = NULL;    /* -remote server[:port] */
unsigned long remote_port = 0;
char *password = NULL;
char *server_name = NULL;        /* -name servername */
char *server_desc = NULL;        /* -desc serverdesc */
char *services_user = NULL;    /* -user username */
char *services_host = NULL;    /* -host hostname */

char *NICKSERV_NAME = "NickServ";
char *CHANSERV_NAME = "ChanServ";
char *MEMOSERV_NAME = "MemoServ";
char *HELPSERV_NAME = "HelpServ";
char *OPERSERV_NAME = "OperServ";
char *ROOTSERV_NAME = "RootServ";
char *GLOBAL_NOTICER_NAME = "Global";
char *AGENT_NAME = "Agent";

char *sendmail_path = "/usr/sbin/sendmail";
char *html_path = "";
char *netstats_path = "";
short ishtml = 0;
char *SpamUser = "sophoan";
char *Spamhost = "pl-32.camnet.com.kh";
char *Spamreal = "ircII User";

int   BSKeepData = 600;
int   BSMinUsers = 2;

char *s_NickServ = "NickServ";
char *s_ChanServ = "ChanServ";
char *s_MemoServ = "MemoServ";
char *s_HelpServ = "HelpServ";
char *s_OperServ = "OperServ";
char *s_RootServ = "RootServ";
char *s_HostServ = "HostServ";
char *s_BotServ = "BotServ";
char *s_AdminServ = "AdminServ";
char *s_SpamChecker = "Guest19263";
char *s_GlobalNoticer = "Global";
#ifndef NONSUPER
char *s_ServicesX = "X";
char *s_ServicesW = "W";
char *s_MassServ = "MassServ";
#endif
char *s_Agent = "Agent";

char *netconfig = "auspice.conf";
char *msgconfig = "auspice.msg";
char *tokn[64];
char *toknmsg[64];

char *TIMEZONE = "GMT";
char *SLOG_FILENAME = "./logs/services.log";
char *HELPSERV_DIR = "helpfiles";
unsigned long UPDATE_TIMEOUT = 1800;
short TIMEOUT_CHECK = 2;
short READ_TIMEOUT = 9;
short BAD_PW_LIMIT = 5;
short BAD_PW_TIMEOUT = 3600;
short CHANNEL_MAXREG = 20;
short AKICK_MAX = 100;
char *DEF_AKICK_REASON = "User has been banned from the channel";
short NS_REG_DELAY = 15;
short RELEASE_TIMEOUT = 30;
short DEF_MAX_MEMOS = 50;
short MEMO_SEND_WAIT = 5;
short MAX_SERVROOTS = 32;
short MAX_SERVADMINS = 32;
short MAX_SERVOPERS = 32;
short MAX_HELPOPS = 32;
short MAX_AUTOKILLS = 256;
short MAX_JUPES = 12;
short MAX_TRIGGERS = 128;
int AKILL_DEF_EXPIRY = (24*60*60);
int IGNORE_DEF_EXPIRY = (24*60*60);
short CLONE_WARNING_DELAY = 10;
short MAX_MEMO_LENGTH = 255;
short ENABLE_LOGS = 1;
short CHAN_ACCESS_MAX = 900;
short USER_ACCESS_MAX = 20;
short MAX_SUSPEND = 256;
short ENABLE_R_MODES = 0;
short ENABLE_UMODE_a = 1;
short MAX_QLINES = 64;
short MAX_GLINES = 64;
short MAX_ZLINES = 128;
short ALLOW_EMAIL = 1;
short F_TLEV = 10;
short F_RESET = 15;
short BACKUP_DB = 10;
short INCLUDE_AKILL_REASON = 1;
short EXTRA_SNOOP = 1;
char *snoopchan = "#Snoop";
short REG_SAVES = 0;
short DISPLAY_UPDATES = 0;
short CHANNEL_INHABIT = 15;
short MOTD_UPTIME = 1;
short MOTD_UPDATE = 1;
// char *DEF_MLOCKS = "nt";
char *spyhost;
short TOPIC_PROBS = 0;

short NS_KILL = 0;
short NS_SECURE = 0;
short NS_PRIVATE = 0;
short NS_DACCESS = 0;
short FIRSTUSED = 1;
short DATAUP = 0;
int news_size = -1L;
short shouldwritenew = 0;

short numserver;

char *asource;
char *adest;
short aspychan;
short asockcheck = 0;

// Auto Settings

short clone_detect = 1;                   /* -clone detection */

short readonly = 0;			/* -readonly */
short snoop = 0;
short dumplog = 1;
short allow_ignore = 1;

// *Auto Settings

char *time_zone = "GMT";
char *slog_filename = "./logs/services.log";
unsigned long update_timeout = 1800;

static int conf_break();

void init_conf(void)
{
  FILE *conf;
  unsigned char linbuff[1024];
  char *pargv[100];
  char *tmp;
  int p;

  if ((conf = fopen(CONFIG_FILE, "rb")) == NULL)
  {
    fatal_perror("Error opening configuration file = services.conf");
  }

  while (!feof(conf))
  {
     if ((fgets(linbuff, 1024, conf)) == NULL)
     {
         break;
     }
     p = 0;
     tmp = strtok(linbuff, ": \n\r,");

     if (tmp != NULL)
     {
         pargv[p++] = tmp;
         while ((tmp = strtok(NULL, ": \n\r,")) != NULL)
         {
            pargv[p++] = tmp;
            if (p > 100) {
               break;
            }
         }
         if (conf_break(p, pargv) == -1) {
            slog("Services Terminated on illegal configuration");
            exit(1);
         }
    }
  }
  fclose(conf);
  if (!REMOTE_SERVER) {
     fatal_perror("ERROR: Missing S: line");
     exit(1);
  } else if (!REMOTE_PORT) {
     fatal_perror("ERROR: Missing P: line");
     exit(1);
  } else if (!PASSWORD) {
     fatal_perror("ERROR: Missing X: line");
     exit(1);
  } else if (!SERVER_NAME) {
     fatal_perror("ERROR: Missing N: line");
     exit(1);
  } else if (!SERVER_DESC) {
     fatal_perror("ERROR: Missing D: line");
     exit(1);
  } else if (!SERVICES_USER) {
     fatal_perror("ERROR: Missing U: line");
     exit(1);
  } else if (!SERVICES_HOST) {
     fatal_perror("ERROR: Missing H: line");
     exit(1);
  } else if (!NETWORK_NAME) {
     fatal_perror("ERROR: Missing A: line");
     exit(1);
  } else if (!SERVICES_MASTER) {
     fatal_perror("ERROR: Missing M: line");
     exit(1);
  } else
     return;
}


int conf_break(int pargc, char **pargv)
{
  char buf[64];
  int i;

   *buf=0;

   if (strlen(pargv[0]) > 1) {

     strcat(buf, pargv[0]);

     if (pargc != 2) {
        fatal_perror("Error in Option \"%s\"", pargv[0]);
        return -1;
     }
     if (!stricmp(buf, "NICKSERV") || !stricmp(buf, "NS")) {
         NICKSERV_NAME = sstrdup(pargv[1]);
         s_NickServ = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "CHANSERV") || !stricmp(buf, "CS")) {
         CHANSERV_NAME = sstrdup(pargv[1]);
         s_ChanServ = sstrdup(pargv[1]);
         return 0;
     
     } else if (!stricmp(buf, "MEMOSERV") || !stricmp(buf, "MS")) {
         MEMOSERV_NAME = sstrdup(pargv[1]);
         s_MemoServ = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "HELPSERV") || !stricmp(buf, "HS")) {
         HELPSERV_NAME = sstrdup(pargv[1]);
         s_HelpServ = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "OPERSERV") || !stricmp(buf, "OS")) {
         OPERSERV_NAME = sstrdup(pargv[1]);
         s_OperServ = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "ROOTSERV") || !stricmp(buf, "RS")) {
         ROOTSERV_NAME = sstrdup(pargv[1]);
         s_RootServ = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "GLOBAL")) {
         GLOBAL_NOTICER_NAME = sstrdup(pargv[1]);
         s_GlobalNoticer = sstrdup(pargv[1]);
         return 0;


     } else if (!stricmp(buf, "TIMEZONE") || !stricmp(buf, "TZ")) {
         TIMEZONE = sstrdup(pargv[1]);
         time_zone = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "LOG")) {
         SLOG_FILENAME = sstrdup(pargv[1]);
         slog_filename = sstrdup(pargv[1]);
         return 0;


     } else if (!stricmp(buf, "HELP")) {
          HELPSERV_DIR = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "UPDATE")) {
         UPDATE_TIMEOUT = atoi(pargv[1]);
         update_timeout = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "TIMEOUT")) {
         TIMEOUT_CHECK = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "READ")) {
         READ_TIMEOUT = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "PW_LIMIT")) {
         BAD_PW_LIMIT = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "PW_TIMEOUT")) {
         BAD_PW_TIMEOUT = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "CHANREG")) {
         CHANNEL_MAXREG = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "AKICK")) {
         AKICK_MAX = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "AKICK_REASON")) {
         DEF_AKICK_REASON = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "NICKREG")) {
         NS_REG_DELAY = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "RELEASE")) {
         RELEASE_TIMEOUT = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "MEMOMAX")) {
         DEF_MAX_MEMOS = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "MEMO_WAIT")) {
         MEMO_SEND_WAIT = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "ROOTS")) {
         MAX_SERVROOTS = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "ADMINS")) {
         MAX_SERVADMINS = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "OPERS")) {
         MAX_SERVOPERS = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "HELPOPS")) {
         MAX_HELPOPS = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "AKILLS")) {
         MAX_AUTOKILLS = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "JUPES")) {
         MAX_JUPES = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "TRIGGERS")) {
         MAX_TRIGGERS = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "AKILLEXP")) {
         AKILL_DEF_EXPIRY = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "IGNEXP")) {
         IGNORE_DEF_EXPIRY = atoi(pargv[1]);
         return 0;


     } else if (!stricmp(buf, "CLONE_WARN")) {
         CLONE_WARNING_DELAY = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "MEMO_LEN")) {
         MAX_MEMO_LENGTH = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "LOGS")) {
         ENABLE_LOGS = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "C_ACC_MAX")) {
         CHAN_ACCESS_MAX = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "U_ACC_MAX")) {
         USER_ACCESS_MAX = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SUSPEND")) {
         MAX_SUSPEND = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "R_MODES")) {
         ENABLE_R_MODES = atoi(pargv[1]);
         return 0;
     
     } else if (!stricmp(buf, "UMODE_a")) {
         ENABLE_UMODE_a = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "QLINES")) {
         MAX_QLINES = atoi(pargv[1]);
         return 0;
     
     } else if (!stricmp(buf, "ZLINES")) {
         MAX_ZLINES = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "EMAIL")) {
         ALLOW_EMAIL = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "TLEV")) {
         F_TLEV = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "RESET")) {
         F_RESET = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "BACKUP")) {
         BACKUP_DB = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SNOOPCHAN")) {
         snoopchan = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SET_IGNORE")) {
         allow_ignore = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SET_RO")) {
         readonly = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SET_CLONES")) {
         clone_detect = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SET_LOG")) {
         dumplog = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SET_SNOOP")) {
         snoop = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "AKILL_REASON")) {
         INCLUDE_AKILL_REASON = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "EXTRA_SNOOP")) {
         EXTRA_SNOOP = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "REG_SAVES")) {
         REG_SAVES = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "DISPLAY_UPDATES")) {
         DISPLAY_UPDATES = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "CHANNEL_INHABIT")) {
         CHANNEL_INHABIT = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "UPTIME")) {
         MOTD_UPTIME = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "MOTD_UPDATE")) {
         MOTD_UPDATE = atoi(pargv[1]);
         return 0;
     } else if (!stricmp(buf, "TOPICFIX")) {
         TOPIC_PROBS = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "KILL")) {
         NS_KILL = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SECURE")) {
         NS_SECURE = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "PRIVATE")) {
         NS_PRIVATE = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "ACCESS")) {
         NS_DACCESS = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SENDMAIL_PATH")) {
         sendmail_path = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "HTML_PATH")) {
         html_path = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "NET")) {
         netconfig = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "NETMSG")) {
         msgconfig = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "NETSTATS_PATH")) {
         netstats_path = sstrdup(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "HTML")) {
         ishtml = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "FIRSTUSED")) {
         FIRSTUSED = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SOCKCHECK")) {
         asockcheck = atoi(pargv[1]);
         return 0;

     } else if (!stricmp(buf, "SPAMNICK")) {
          s_SpamChecker = sstrdup(pargv[1]);
          return 0;

     } else if (!stricmp(buf, "SPAMUSER")) {
          SpamUser = sstrdup(pargv[1]);
          return 0;
     } else if (!stricmp(buf, "SPAMHOST")) {
          Spamhost = sstrdup(pargv[1]);
          return 0;
     } else {
//        fatal_perror("Unknown Option \"%s\"", pargv[0]);
//        return -1;
    }

   return 0;
  }

  switch (pargv[0][0])
  {
     case '#':
       {
          return 0;
       }
     case 'S':
       {
          if (pargc != 2) {
             fatal_perror("Invalid S: line");
             return -1;
          }
          REMOTE_SERVER = sstrdup(pargv[1]);
          remote_server = sstrdup(pargv[1]);
          return 0;
       }
     case 'P':
       {
          if (pargc != 2) {
             fatal_perror("Invalid P: line");
             return -1;
          }
          REMOTE_PORT = atoi(pargv[1]);
          remote_port = atoi(pargv[1]);
          return 0;
       }
     case 'X':
       {
          if (pargc != 2) {
             fatal_perror("Invalid X: line");
             return -1;
          }
          PASSWORD = sstrdup(pargv[1]);
          password = sstrdup(pargv[1]);
          return 0;
       }
     case 'N':
       {
          if (pargc != 2) {
             fatal_perror("Invalid N: line");
             return -1;
          }
          SERVER_NAME = sstrdup(pargv[1]);
          server_name = sstrdup(pargv[1]);

          return 0;
       }
     case 'D':
       {
          if (pargc == 0) {
            fatal_perror("Invalid D: line, DESC must contain atleast 1 param");
            return -1;
          }
          *buf = 0;
          i=1;

          while(i < pargc) {
             strcat(buf, pargv[i]);
             i++;
             if (i < pargc)
                strcat(buf, " ");
          }

          SERVER_DESC = sstrdup(buf);
          server_desc = sstrdup(buf);
          return 0;
       }
     case 'U':
       {
          if (pargc != 2) {
             fatal_perror("Invalid U: line");
             return -1;
          }
           SERVICES_USER = sstrdup(pargv[1]);
           services_user = sstrdup(pargv[1]);
          return 0;
       }
     case 'H':
       {
          if (pargc != 2) {
             fatal_perror("Invalid H: line");
             return -1;
          }
          SERVICES_HOST = sstrdup(pargv[1]);
          services_host = sstrdup(pargv[1]);
          return 0;
       }
     case 'A':
       {
          if (pargc != 2) {
             fatal_perror("Invalid A: line");
             return -1;
          }
          NETWORK_NAME = sstrdup(pargv[1]);
          return 0;
       }
     case 'R':
       {
          if (pargc != 2) {
             fatal_perror("Invalid R: line");
             return -1;
          }
          server_num = sstrdup(pargv[1]);
          return 0;
       }
     case 'M':
       {
          if (pargc != 2) {
             fatal_perror("Invalid M: line");
             return -1;
          }
          SERVICES_MASTER = sstrdup(pargv[1]);
          return 0;
       }
     default:
       {
         fatal_perror("Unknown Field in conf file: (%c)\n",  pargv[0][0]);
         return -1;
       }
   }

  return 0;
}

/*
 * 
 */

void init_netconf(void)
{
    FILE *f;
    char readconf[128];
    char netcpath[32];
    int j, i, x;
    j = 0;
    i = 0;
    log("Load Net Config");
    f = fopen("../networks/auspice.conf", "r");
    if (f) {
	    while(fgets(readconf, sizeof(readconf), f)) {
		tokn[j] = sstrdup(strtok(readconf, "\n"));
		if (i==0) {
			i = 1;
		} else {
			i = 0;
			j++;
		}
	    }
            fclose(f);
     } else {
         fatal_perror("Missing Default Network file auspice.conf\n");
     }

     /* Working on your old network file */

    j = 0;
    i = 0;
    x = 0;
    sprintf(netcpath,"../networks/%s",netconfig);
    f = fopen(netcpath, "r");
    if (f) {
	    while(fgets(readconf, sizeof(readconf), f)) {
		if (j <= x) {
			if (tokn[j]) {
				free(tokn[j]);
				tokn[j] = NULL;
			}
			tokn[j] = sstrdup(strtok(readconf, "\n"));

			if (i==0) {
				i = 1;
			} else {
				i = 0;
				if (j==0)
					x = atoi(tokn[j]);
				j++;
			}
	        }
	    }
	    fclose(f);
     }
     *readconf = 0;
     *netcpath = 0;
}

void init_msgconf(void)
{
    FILE *f;
    char readconf[128];
    char netcpath[32];
    int j, i, x;
    j = 0;
    i = 0;
    log("Load Msg Config");
    f = fopen("../networks/auspice.msg", "r");
    if (f) {
	    while(fgets(readconf, sizeof(readconf), f)) {
		toknmsg[j] = sstrdup(strtok(readconf, "\n"));
		if (i==0) {
			i = 1;
		} else {
			i = 0;
			j++;
		}
	    }
            fclose(f);
     } else {
         fatal_perror("Missing Default Network file auspice.msg\n");
     }

     /* Working on your old network file */

    j = 0;
    i = 0;
    x = 0;
    sprintf(netcpath,"../networks/%s",msgconfig);

    f = fopen(netcpath, "r");
    if (f) {
	    while(fgets(readconf, sizeof(readconf), f)) {
		if (j <= x) {
			if (toknmsg[j]) {
				free(toknmsg[j]);
				toknmsg[j] = NULL;
			}
			toknmsg[j] = sstrdup(strtok(readconf, "\n"));
			if (i==0) {
				i = 1;
			} else {
				i = 0;
				if (j==0)
					x = atoi(toknmsg[j]);
				j++;
			}
	        }
	    }
	    fclose(f);
     }
     *readconf = 0;
     *netcpath = 0;
}

void save_netconf(void)
{
    FILE *f;
    int i;
    char netcpath[32];
    sprintf(netcpath,"../networks/%s",netconfig);
    f = fopen(netcpath, "w");
    if (f) {
        fprintf(f, "# Numeric 0\n");
        fprintf(f, "%d\n", netconfnum+1);
	for (i=1; i<=netconfnum; i++) {
	        fprintf(f, "# Numeric %d\n", i);
	        fprintf(f, "%s\n", tokn[i]);
	}
	slog("Write Network config file was saved successfully");
        wallops(s_Agent,
            "Network file was saved successfully");

    }
    fclose(f);
    *netcpath = 0;
}

void save_msgconf(void)
{
    FILE *f;
    int i;
    char netcpath[32];
    sprintf(netcpath,"../networks/%s",msgconfig);
    f = fopen(netcpath, "w");
    if (f) {
        fprintf(f, "# Numeric 0\n");
        fprintf(f, "%d\n", netmsgnum+1);
	for (i=1; i<=netmsgnum; i++) {
	        fprintf(f, "# Numeric %d\n", i);
	        fprintf(f, "%s\n", toknmsg[i]);
	}
	slog("Write Network Messages file successful.");
        wallops(s_Agent,
            "Network Messages file save successfuly");

    }
    fclose(f);
    *netcpath = 0;   
}

short is_tokn(short tnum)
{
	if (stricmp(tokn[tnum], "ON") == 0)
		return 1;

	return 0;
}
