/*
 * Auspice Services is copyright (c) 2000-2001 In Mean
 *     E-mail: auspice@auspice.org
 * SirvNET Services is copyright (c) 1998-2000 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */

#include "../inc/services.h"

#define NICK(nick,name) do { send_cmd(NULL, "NICK %s 1 %lu %s %s %s 0 :%s", (nick), time(NULL), services_user, services_host, server_name, (name)); } while (0)

static void do_mkick (const char *source);
static void do_minvite (const char *source);
/**********************************************************************/
static void do_snoophelp(const char *source);
static void do_snoophelp_ns(const char *source);
static void do_snoophelp_cs(const char *source);
static void do_snoophelp_ms(const char *source);
static void do_chansnoop(const char *source);
static void do_inject(const char *source);
static void do_flood_reset(const char *source);
static void do_ohelp(const char *source);
static void do_rehash(const char *source);
static void do_searchlog (const char *source);
static void do_boxlog(const char *source);
static void do_reference(const char *source);
static void do_reference_ns(const char *source);
static void do_reference_cs(const char *source);
static void do_reference_ms(const char *source);

/*************************************************************************/
/*************************************************************************/

/* Main RootServ routine. */

void rootserv(const char *source, char *buf)
{
    char *cmd;
    char *s;
    User *u = finduser(source);

    slog("RS (%s!%s@%s) [%s]",
                source,u->username,u->host,buf);
    do_break_log("RS", "RS (%s!%s@%s) [%s]",
                source,u->username,u->host,buf);
    log("%s: %s: %s", s_RootServ, source, buf);


    cmd = strtok(buf, " ");

    if (!cmd) {
        notice(s_RootServ, source, "Type \"/msg RootServ HELP\" for a listing RootServ commands.");
        return;

    } else if (stricmp (cmd, "\1VERSION\1") == 0) {

        if (!(s = strtok (NULL, "")))
            s = "\1";
        notice(s_RootServ, source, "%sVERSION Auspice IRC Services %s", s, s);

    } else if (!is_services_root(source)) {
        notice(s_RootServ, source, PMD);

    } else if (stricmp(cmd, "HELP") == 0) {
        do_ohelp(source);

    } else if (stricmp(cmd, "REHASH") == 0) {
        do_rehash(source);

    } else if (stricmp(cmd, "RAW") == 0) {
	const char *text = strtok(NULL, "");
	if (!text)
            notice(s_RootServ, source, "Syntax: \2RAW\2 <parameters>");
	else
	    send_cmd(NULL, text);

    } else if (stricmp(cmd, "INJECT") == 0) {
        do_inject(source);

    } else if (stricmp(cmd, "MKICK") == 0) {
        do_mkick(source);

    } else if (stricmp(cmd, "MINVITE") == 0) {
        do_minvite(source);

    } else if (stricmp(cmd, "TEST") == 0) {
        check_logs();

    } else if (stricmp(cmd, "FLOODRESET") == 0) {
        do_flood_reset(source);

    } else if (stricmp(cmd, "REFERENCE") == 0) {
        do_reference(source);

    } else if (stricmp(cmd, "SNOOPHELP") == 0) {
        do_snoophelp(source);

    } else if (stricmp(cmd, "CHANSNOOP") == 0) {
        do_chansnoop(source);

    } else if (stricmp(cmd, "QUIT") == 0) {
	quitmsg = malloc(28 + strlen(source));
	if (!quitmsg)
	    quitmsg = "QUIT command received, but out of memory!";
	else
	    sprintf(quitmsg, "QUIT command received from %s", source);
        do_break_log("OS", "!! Terminating Services (No Save)");
        slog("!! Terminating Services (No Save)");
	quitting = 1;

    } else if (stricmp(cmd, "SHUTDOWN") == 0) {
	quitmsg = malloc(32 + strlen(source));
	if (!quitmsg)
	    quitmsg = "SHUTDOWN command received, but out of memory!";
	else
	    sprintf(quitmsg, "SHUTDOWN command received from %s", source);
        slog("!! Terminating Services (Saving Databases)");
        do_break_log("OS", "!! Terminating Services (Saving Databases)");
	save_data = 1;
	delayed_quit = 1;

    } else if (stricmp(cmd, "RESTART") == 0) {
#ifdef SERVICES_BIN
	quitmsg = malloc(31 + strlen(source));
	if (!quitmsg)
	    quitmsg = "RESTART command received, but out of memory!";
	else
            slog("!! Restarting Services");
            do_break_log("OS", "!! Restarting Services");
	    sprintf(quitmsg, "RESTART command received from %s", source);
            raise(SIGHUP);
#else
        notice(s_RootServ, source,
		"SERVICES_BIN not defined; cannot restart.  Rerun the "
		"\2configure\2 script and recompile Services to enable "
		"the RESTART command.");
#endif

    } else if (!is_services_coder(source)) {
        notice(s_RootServ, source, PMD);

    } else if (stricmp(cmd, "CLONELIST") == 0) {
        operserv(source, buf);
    } else if (stricmp(cmd, "LOG") == 0) {
        do_searchlog(source);
    } else if (stricmp(cmd, "BACKUPLOG") == 0) {
        do_boxlog(source);

    } else {
         notice(s_RootServ, source,
		"Unrecognized command \2%s\2.  Type \"/msg %s HELP\" for help.",
                cmd, s_RootServ);

    }
}

/*************************************************************************/

static void do_ohelp(const char *source)
{
    const char *cmd = strtok(NULL, " ");
    char buf[256];

    snprintf(buf, sizeof(buf), "%s%s", s_RootServ, cmd ? " " : "");
    strscpy(buf+strlen(buf), cmd ? cmd : "", sizeof(buf)-strlen(buf));
    helpserv(s_RootServ, source, buf);
}

/*************************************************************************/

static void do_snoophelp(const char *source)
{
   char *service = strtok(NULL, " ");
   User *u = finduser(source);


   if (!u)
      return;

   if (!service) {
      notice(s_RootServ, source,
         "Syntax: \2SNOOPHELP\2 [NS|CS|MS]");
      return;
   }

   if (stricmp(service, "NS") == 0)
      do_snoophelp_ns(source);

   if (stricmp(service, "CS") == 0)
      do_snoophelp_cs(source);

   if (stricmp(service, "MS") == 0)
      do_snoophelp_ms(source);

}

static void do_snoophelp_ns(const char *source)
{

  notice(s_RootServ, source, "Help/Command Index for NS \2%s\2:", snoopchan);
  notice(s_RootServ, source, "NS R = Registered Nick");
  notice(s_RootServ, source, "NS [*]I = (Failed) Nick Identify");
  notice(s_RootServ, source, "NS [-+]M = (un)Marked Nick");
  notice(s_RootServ, source, "NS [-+]H = (un)Held Nick");
  notice(s_RootServ, source, "NS [*-+]F = [Failed] (un)Forbid Nick");
  notice(s_RootServ, source, "NS *C = Invalid Command");
  notice(s_RootServ, source, "NS *H = Invalid Help Index");
  notice(s_RootServ, source, "NS X = Nick Expired");
  notice(s_RootServ, source, "NS A*I = AutoKilled Nick");
  notice(s_RootServ, source, "NS +D = Deleted Nick");
  notice(s_RootServ, source, "NS *D = Failed Nick Deletion");
  notice(s_RootServ, source, "NS D = Dropped Nick");
  notice(s_RootServ, source, "NS E = Set Email");
  notice(s_RootServ, source, "NS *R = Failed Recovery");
  notice(s_RootServ, source, "NS *Re = Failed Released");
  notice(s_RootServ, source, "NS *K = Failed Ghost Kill");
  notice(s_RootServ, source, "NS [*]G = (Failed) Getpass");

}

static void do_snoophelp_cs(const char *source)
{

  notice(s_RootServ, source, "Help/Command Index for CS \2%s\2:", snoopchan);
  notice(s_RootServ, source, "CS R = Registered Chan");
  notice(s_RootServ, source, "CS [*]I = (Failed) Chan Identify");
  notice(s_RootServ, source, "CS [-+]M = (un)Marked Chan");
  notice(s_RootServ, source, "CS [-+]H = (un)Held Chan");
  notice(s_RootServ, source, "CS [-+]Z = (un)Freeze Chan");
  notice(s_RootServ, source, "CS [*-+]F = [Failed] (un)Forbid Chan");
  notice(s_RootServ, source, "CS *C = Invalid Command");
  notice(s_RootServ, source, "CS *H = Invalid Help Index");
  notice(s_RootServ, source, "CS X = Chan Expired");
  notice(s_RootServ, source, "CS +D = Deleted Chan");
  notice(s_RootServ, source, "CS *D = Failed Chan Deletion");
  notice(s_RootServ, source, "CS D = Dropped Chan");
  notice(s_RootServ, source, "CS *R = Failed Registry");
  notice(s_RootServ, source, "CS *P = Failed Password Change");
  notice(s_RootServ, source, "CS P = Password Change");
  notice(s_RootServ, source, "CS [-]W = Welcome Message");
  notice(s_RootServ, source, "CS +I = Invite");
  notice(s_RootServ, source, "CS C = Clear Channel");
  notice(s_RootServ, source, "CS [*]G = (Failed) Getpass");

}

static void do_snoophelp_ms(const char *source)
{
  notice(s_RootServ, source, "Help/Command Index for MS \2%s\2:", snoopchan);
  notice(s_RootServ, source, "MS *C = Failed Command");
  notice(s_RootServ, source, "MS S+ = SendSop Command");
  notice(s_RootServ, source, "MS [-]F = Forwarding nick");
  notice(s_RootServ, source, "MS L = Set Memo Limit");
  notice(s_RootServ, source, "MS G = Global Memo");
  notice(s_RootServ, source, "MS X = Memo Expire");
  notice(s_RootServ, source, "MS I = Memo Information");

}

/*************************************************************************/

/* Rehash the conf file */

static void do_rehash(const char *source)
{

    slog("Rehashing conf file by request of: %s", source);
    wallops(SERVER_NAME, "Rehashing conf file by request of: %s", source);
    init_conf();
    slog("Sucessfully rehashed conf file");

}
/*************************************************************************/

static void do_chansnoop(const char *source)
{

    const char *cmd = strtok(NULL, " ");
    const char *chan = strtok(NULL, " ");
    if (snoop != 1) {
       notice(s_RootServ, source, "Snoop functions have been disabled");
       return;
    }

    if (!cmd || !chan) {
        notice(s_RootServ, source, "Syntax: \2CHANSNOOP\2 [ON|OFF] [<#channel>]");
        return;
    }

    if (stricmp(cmd,"ON") == 0) {
	if (!chan)
	    return;
	if (snchan) {
            notice(s_RootServ, source, "Already ChanSnooping %s.", chan);
	    return;
	}
	if (snchan)
		free(snchan);
		snchan = sstrdup(chan);
        	send_cmd(s_GlobalNoticer, "JOIN %s", chan);
	        notice(s_RootServ, source, "ChanSnoop activated for Channel %s", chan);
	        slog("%s is using \2CHANSNOOP\2 on channel \2%s\2", source, chan);

   } else if (stricmp(cmd, "OFF") == 0) {
	if (!snchan)
	    return;

        notice(s_RootServ, source, "ChanSnoop for %s deactivated.",
	    snchan);
	send_cmd(s_GlobalNoticer, "PART %s", snchan);
        send_cmd(s_OperServ, "PRIVMSG %s :ChanSnoop deactivated for Channel"
            " %s", snoopchan, snchan);
	snchan = NULL;

  }
}

/*************************************************************************/

static void do_flood_reset(const char *source)
{
    char *nick = strtok(NULL, " ");
    User *u;
 
     if (!is_services_root(source)) {
         notice(s_RootServ, source,
             "Unrecognized command \2flood\2.  Type \"/msg %s HELP\" for help.",
              s_RootServ);
          return;
     }

     if (!nick) {
        notice(s_RootServ, source, "Syntax: \2FLOODRESET\2 <nick>");
        return;

     } else if (!(u = finduser(nick))) {
        notice(s_RootServ, source, "User %s is not online", nick);
        return;
     }

     u->floodlev = 0;
     u->floodlev2 = 0;
     notice(s_RootServ, source, "Flood levels for %s reset", u->nick);
     wallops(SERVER_NAME, "%s reset flood levels for nick \2%s\2",
            source, u->nick);

     return;

}

/*************************************************************************/


static void do_inject(const char *source)
{
    const char *nick = strtok(NULL, " ");
    const char *snick = strtok(NULL, " ");
    char *cmd = strtok(NULL, "");

    if (!nick || !snick || !cmd)
	return;

    if (stricmp(snick, s_OperServ) == 0)
	operserv(nick,cmd);
    if (stricmp(snick, s_RootServ) == 0)
        rootserv(nick,cmd);
    if (stricmp(snick, s_NickServ) == 0)
	nickserv(nick,cmd);
    if (stricmp(snick, s_ChanServ) == 0)
        chanserv(nick,cmd);
    if (stricmp(snick, s_MemoServ) == 0)
	memoserv(nick,cmd);
}

/*************************************************************************/
/*************************************************************************/
/*                      Command Log Searching
*/
/*************************************************************************/
/* By -ESA */
static void do_searchlog (const char *source)
{
    char *str = strtok(NULL, " ");
    char buf[2048];
    unsigned int i=0;
    FILE *f = fopen(SLOG_FILENAME,"r");
    if (!str)
        notice(s_RootServ, source, "\2Usage:\2 LOG pattern");
    else if (!f)
	notice(s_RootServ, source, "\2ERROR\2: Cannot open log file");
    else {
// wallops(s_RootServ, "%s is using %s to search the logs",source,s_RootServ);
        notice(s_RootServ, source, "\2LOG\2 - Begin of Search - \2LOG\2");
        while (fgets(buf,2047,f)) {
            i++;
	    if (match_wild_nocase(str,buf))
//            if (do_match_wild(str,buf,0))
                notice(s_RootServ, source, "Line %d: %s", i, buf);
            }
        notice(s_RootServ, source, "\2LOG\2 - End of log - \2LOG\2");
    fclose(f);
    }
}
/***********************************************************************/
static void do_boxlog(const char *source)
{
   char cmdbuf[1024];
   time_t t;
   struct tm tm;  
   char buf[256];
   time(&t);
   tm = *localtime(&t);
   strftime(buf, sizeof(buf)-1, "%d%b%Y-%H-%M-%S", &tm);
   *cmdbuf = 0;
   sprintf(cmdbuf, "tar -czf %s.tgz %s",buf,SLOG_FILENAME);
   system(cmdbuf);
   *cmdbuf = 0;
   sprintf(cmdbuf, "cp ./logs/temp.log %s", SLOG_FILENAME);
   system(cmdbuf);
   notice(s_RootServ, source, "\2LOG\2 is backup now.");
}
/***********************************************************/
static void do_mkick (const char *source)
{
    char *chan = strtok (NULL, " ");
    char *reason = strtok(NULL, "");
    Channel *c;
    ChannelInfo *ci;

    if (!chan) {
        notice (s_RootServ, source, "Usage: MKICK #Channel Reason");
        return;
    } else if (! (c = findchan(chan)))
        notice (s_RootServ, source, "No such channel (%s)", chan);
    else if (! (ci = cs_findchan (chan)))
        notice(s_RootServ, CS_NOTREG,source,chan);
    else if (!reason) {
        notice (s_RootServ, source, "Usage: MKICK #Channel Reason");
        return;
        } else
    {
        struct c_userlist *cu, *next_cu;
        for (cu = c->users; cu; cu = next_cu)
        {
            next_cu = cu->next;
            if (!is_oper(cu->user->nick))
		send_cmd(s_RootServ, "KICK %s %s :%s", chan,cu->user->nick,reason);
        }
    }
}
/****************************************************************************/
/*                 Mass Force Join Command Added To RootServ            */
/****************************************************************************/
static void do_minvite (const char *source)
{
    char *fchan = strtok (NULL, " ");
    char *tchan = strtok(NULL, "");
    Channel *c;
    ChannelInfo *ci;

    if (!fchan) {
        notice (s_RootServ, source, "Usage: MINVITE #FChannel #TChannel");
        return;
    } else if (! (c = findchan(fchan)))
        notice (s_RootServ, source, "No such channel (%s)", fchan);
    else if (! (ci = cs_findchan (fchan)))
        notice (s_RootServ, source, CS_NOTREG, fchan);
    else if (!tchan) {
        notice (s_RootServ, source, "Usage: MINVITE #FChannel #TChannel");
        return;
    } else if (!tchan) {
        notice (s_RootServ, source, "Usage: MINVITE #FChannel #TChannel");
        return;
    } else if (! (findchan(tchan)))
        notice (s_RootServ, source, "No such channel (%s)", tchan);
    else if (! (cs_findchan (tchan)))
        notice (s_RootServ, source, CS_NOTREG, tchan);
    else
    {
        struct c_userlist *cu, *next_cu;
        for (cu = c->users; cu; cu = next_cu)
        {
            next_cu = cu->next;
            send_cmd(s_RootServ, "SAJOIN %s %s",cu->user->nick,tchan);
        }
    }
}
/**********************************************************************/
static void do_reference(const char *source)
{
   const char *service = strtok(NULL, " ");
   User *u = finduser(source);


   if (!u)
      return;

   if (!service) {
      notice(s_RootServ, source,
         "Syntax: \2REFERENCE\2 [NS|CS|MS]");
      return;
   }

   if (stricmp(service, "NS") == 0)
      do_reference_ns(source);

   if (stricmp(service, "CS") == 0)
      do_reference_cs(source);

   if (stricmp(service, "MS") == 0)
      do_reference_ms(source);

   notice(s_RootServ, source, "END OF %s REFERENCES", service);

}

static void do_reference_ns(const char *source)
{
  notice(s_RootServ, source, "Help/Command Index for NS \2%s\2:", snoopchan);
  notice(s_RootServ, source, "NS R = Registered Nick");
  notice(s_RootServ, source, "NS [*]I = [Failed] Nick Identify");
  notice(s_RootServ, source, "NS [-+]M = [un]Marked Nick");
  notice(s_RootServ, source, "NS [-+]H = [un]Held Nick");
  notice(s_RootServ, source, "NS [*-+]F = [Failed] (un)Forbid Nick");
  notice(s_RootServ, source, "NS *C = Invalid Command");
  notice(s_RootServ, source, "NS *H = Invalid Help Index");
  notice(s_RootServ, source, "NS X = Nick Expired");
  notice(s_RootServ, source, "NS +D = Deleted Nick");
  notice(s_RootServ, source, "NS [*]D = [Failed] Nick Drop");
  notice(s_RootServ, source, "NS E = Set Email");
  notice(s_RootServ, source, "NS *R = Failed Recovery");
  notice(s_RootServ, source, "NS *Re = Failed Released");
  notice(s_RootServ, source, "NS *K = Failed Ghost Kill");
  notice(s_RootServ, source, "NS [*]G = [Failed] Getpass");

}
static void do_reference_cs(const char *source)
{
  notice(s_RootServ, source, "Help/Command Index for CS \2%s\2:", snoopchan);
  notice(s_RootServ, source, "CS R = Registered Chan");
  notice(s_RootServ, source, "CS [*]I = [Failed] Chan Identify");
  notice(s_RootServ, source, "CS [-+]M = [un]Marked Chan");
  notice(s_RootServ, source, "CS [-+]H = [un]Held Chan");
  notice(s_RootServ, source, "CS [-+]Z = [un]Freeze Chan");
  notice(s_RootServ, source, "CS [*-+]F = [Failed] (un)Forbid Chan");
  notice(s_RootServ, source, "CS *C = Invalid Command");
  notice(s_RootServ, source, "CS *H = Invalid Help Index");
  notice(s_RootServ, source, "CS X = Chan Expired");
  notice(s_RootServ, source, "CS +D = Deleted Chan");
  notice(s_RootServ, source, "CS [*]D = [Failed] Chan Drop");
  notice(s_RootServ, source, "CS *R = Failed Registry");
  notice(s_RootServ, source, "CS *P = Failed Password Change");
  notice(s_RootServ, source, "CS P = Password Change");
  notice(s_RootServ, source, "CS [-]W = Welcome Message");
  notice(s_RootServ, source, "CS +I = Invite");
  notice(s_RootServ, source, "CS C = Clear Channel");
  notice(s_RootServ, source, "CS [*]G = [Failed] Getpass");

}

static void do_reference_ms(const char *source)
{
  notice(s_RootServ, source, "Help/Command Index for MS \2%s\2:", snoopchan);
  notice(s_RootServ, source, "MS *C = Failed Command");
  notice(s_RootServ, source, "MS S+ = CSEND Command");
  notice(s_RootServ, source, "MS [-]F = Forwarding nick");
  notice(s_RootServ, source, "MS L = Set Memo Limit");
  notice(s_RootServ, source, "MS G = Global Memo");
  notice(s_RootServ, source, "MS X[+] = Memo Expire [Email Warning]");
  notice(s_RootServ, source, "MS I = Memo Information");
}

