/*
 * Auspice Services is copyright (c) 2000-2001 In Mean
 *  http://www.auspice.org
 * Originally based on SirvNET Services(c) by Trevor Klingbeil.
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */

#include "../inc/services.h"

Channel *chanlist = NULL;

#ifdef SJOIN
static int smembers = 1;
static int ssize = 0;
static int schans = 0;

static struct sjoin_list {
   char *nick;
} *slist = NULL;
static void extract_nicks();
void get_sjoin_list(char *list, int newchan);
static void add_suser(char *nick, char *channel);
static void scheck_ops(char *chan, char **checklist, int count);
static void update_last_used(const char *chan);
#endif

#ifdef SJOIN
/*************************************************************************/
void load_sjoin_mem()
{
       slist = smalloc(sizeof(*slist) * 1024);
       ssize = 1024;
}
/*************************************************************************/
void do_sjoin(char *source, int ac, char **av)
{
   Channel *chan;
#if (BAH_V >= 150) || defined(RAGEIRCD)
   int sf = 1;
#else
   int sf = 0;
#endif
   char *schan = av[2-sf];
   char *s, *who, *tmpwho;
   char *mv[3], *checklist[1024];
   int args = 0, start = 4;
   int newchan = 0, bogus=0, check=0, inmean = 0, x = 0;
   User *user;
   chan = findchan(av[2-sf]);
   if (!chan) {
      if (debug)
           log("Creating new channel %s via sjoin", av[2-sf]);

      chan = scalloc(sizeof(Channel), 1);
      chan->next = chanlist;
      if (chanlist)
          chanlist->prev = chan;
      chanlist = chan;
      strscpy(chan->name, av[2-sf], sizeof(chan->name));
      chan->creation_time = CTime;
      chan->ngames = 1;
      chan->wgames = 1;
      newchan = 1;
   }


#if BAH_V >= 150
   if (!strchr(source, '.')) {
        if (!(user = finduser(source))) {
             bogus=0; smembers=0;
             goto bogus_join;
        }
        chan_adduser(user, schan);
        add_suser(source, chan->name);
        mv[0] = sstrdup(schan); mv[1] = "+o"; mv[2] = sstrdup(source);
        do_cmode(source, 3, mv);
        free(mv[0]); free(mv[2]);
        return;
   }
#endif

#ifdef RAGEIRCD
	sf = 0;
#endif

   if (stricmp(av[3-sf], "0") == 0)
      goto skipmodes;

   s = av[3-sf];
   strscpy(chan->modes, changemode(s, chan->modes), sizeof(chan->modes));
   while (*s) {
        switch(*s++) {
            case 'l':
                if (chan->limit > 0)
                   chan->limit = 0;
                chan->limit = atoi(av[4-sf]);
		inmean++;
                break;
            case 'k':
                if (chan->key) {
                   free(chan->key);
                   chan->key = NULL;
                }
		inmean++;
                chan->key = sstrdup(av[4-sf+inmean]);
                args++;
                break;
        }
   }

   strscpy(chan->modes, changemode("-lk", chan->modes), sizeof(chan->modes));
   check_modes(chan->name, source);

   if (stricmp(av[3-sf], "+") != 0) {

       if (chan->key && (chan->limit > 0))
           start += 2;
       else if ((!chan->key && (chan->limit > 0)) ||
                 (chan->key && (chan->limit == 0)))
           start++;
   }

skipmodes:

   mv[0] = sstrdup(chan->name);
   get_sjoin_list(av[start-sf], newchan);

   for (x = 0; x < smembers; x++) {

         if (strchr(slist[x].nick, '@') && strchr(slist[x].nick, '+')) {
       	     if (!(user = finduser(strtok(slist[x].nick, "@+")))) {
                bogus++; continue;
             }
             mv[2] = sstrdup(user->nick);
             add_suser(mv[2], mv[0]);
             if (check_valid_op(user, mv[0], 1)) {
                mv[1] = "+o";
                do_cmode(source, 3, mv);
             } else {
                 send_cmd(s_ChanServ, "MODE %s -o %s", mv[0], mv[2]);
                 notice(s_ChanServ, mv[2], toknmsg[25], chan->name, s_ChanServ);
             }

             mv[1] = "+v";
             do_cmode(source, 3, mv);

	 } else if (strchr(slist[x].nick, '@')) {
             if (!(user = finduser(strtok(slist[x].nick, "@")))) {
                bogus++; continue;
             }
             mv[2] = sstrdup(user->nick);
             add_suser(mv[2], mv[0]);
             if (check_valid_op(user, mv[0], 1)) {
	         mv[1] = sstrdup("+o");
       	         do_cmode(source, 3, mv);
             } else {
                 send_cmd(s_ChanServ, "MODE %s -o %s", mv[0], mv[2]);
                 notice(s_ChanServ, mv[2], toknmsg[25], chan->name, s_ChanServ);
             }
#ifdef DEFHALFOP
	 } else if (strchr(slist[x].nick, '%')) {
             if (!(user = finduser(strtok(slist[x].nick, "%")))) {
                bogus++; continue;
             }
             mv[2] = sstrdup(user->nick);
             mv[1] = sstrdup("+h");
             add_suser(mv[2], mv[0]);
             do_cmode(source, 3, mv);
#endif
#ifdef DEFPROTECT
	 } else if (strchr(slist[x].nick, '^')) {
             if (!(user = finduser(strtok(slist[x].nick, "^")))) {
                bogus++; continue;
             }
             mv[2] = sstrdup(user->nick);
             mv[1] = sstrdup("+a");
             add_suser(mv[2], mv[0]);
             do_cmode(source, 3, mv);
#endif
#ifdef UNREAL
	} else if (strchr(slist[x].nick, '*')) {
             if (!(user = finduser(strtok(slist[x].nick, "*")))) {
                bogus++; continue;
             }
             mv[2] = sstrdup(user->nick);
             mv[1] = sstrdup("+q");
             add_suser(mv[2], mv[0]);
             do_cmode(source, 3, mv);

#endif

	 } else if (strchr(slist[x].nick, '+')) {
             if (!(user = finduser(strtok(slist[x].nick, "+")))) {
                bogus++; continue;
             }
             mv[2] = sstrdup(user->nick);
             mv[1] = sstrdup("+v");
             add_suser(mv[2], mv[0]);
             do_cmode(source, 3, mv);

         } else {
             if (!(user = finduser(slist[x].nick))) {
                bogus++; continue;
             }
             mv[2] = sstrdup(slist[x].nick);
             add_suser(mv[2], mv[0]);
	}

         if ((bogus == smembers) && newchan)
             goto bogus_join;

      user = finduser(mv[2]);

      if (!user)
	return;

      if (!is_chanop(mv[2], schan))
           chan_adduser(user, schan);

      free(slist[x].nick); slist[x].nick = sstrdup(mv[2]);
      free(mv[2]);

      check_welcome(user, chan->name);

/* do_join removed - as I said, I got around to improving it :P */

      if (newchan && (x < 1)) { /* x to prevent repeated topics */
            restore_topic(chan->name);
#if defined(BAHAMUT) || defined(RAGEIRCD)
	    if (!chan->havebot)
		    botjoin(chan->name);
	    do_cs_join(chan->name);
#endif

      }

      mv[1] = NULL;
   }
   if (checklist[0]) {
      scheck_ops(mv[0], checklist, check);
      checklist[0] = 0;
   }
   free(mv[0]);

bogus_join:

   if ((bogus == smembers) && newchan) {
       if (chan->next)
            chan->next->prev = chan->prev;
       if (chan->prev)
            chan->prev->next = chan->next;
       else
            chanlist = chan->next;
       free(chan); free(mv[2]);
   }

   for (x = 0; x < smembers; x++) {
       user = finduser(slist[x].nick);
       if (user) {
           check_kick(user, chan->name);
           check_invite(user, chan->name);
       }
           free(slist[x].nick);
   }

}

/*************************************************************************/
void get_sjoin_list(char *list, int newchan)
{
    char *tmp = strtok(list, " ");
    smembers = 1;

    slist[0].nick = sstrdup(tmp);
    if (newchan)
      ++schans;

    extract_nicks();
}
/*************************************************************************/

void extract_nicks()
{
   char *tmp;
   int i = 1;

   while ((tmp = strtok(NULL, " ")) != NULL)
   {
       slist[i++].nick = sstrdup(tmp);

   }
   smembers = i;
  
}

#endif /* If SJOIN */
/*************************************************************************/

/* Return statistics.  Pointers are assumed to be valid. */

void get_channel_stats(long *nrec, long *memuse)
{
    long count = 0, mem = 0;
    Channel *chan;
    struct c_userlist *cu;
    int i;

    for (chan = chanlist; chan; chan = chan->next) {
	count++;
	mem += sizeof(*chan);
	if (chan->topic)
	    mem += strlen(chan->topic)+1;
	if (chan->key)
	    mem += strlen(chan->key)+1;
	if (chan->flood)
	    mem += strlen(chan->flood)+1;
	if (chan->link)
	    mem += strlen(chan->link)+1;
	if (chan->wgame)
	    mem += strlen(chan->wgame)+1;
	mem += sizeof(char *) * chan->bansize;
	for (i = 0; i < chan->bancount; i++) {
	    if (chan->bans[i])
		mem += strlen(chan->bans[i])+1;
	}
	for (cu = chan->users; cu; cu = cu->next) {
            if (cu->ud) {
                mem += sizeof(*cu->ud);
               if (cu->ud->lastline) mem += strlen(cu->ud->lastline)+1;
            }
	 	mem += sizeof(*cu);
	}
    }
    *nrec = count;
    *memuse = mem;
}

/*************************************************************************/

/* Return the Channel structure corresponding to the named channel, or NULL
 * if the channel was not found. */

Channel *findchan(const char *chan)
{
    Channel *c = chanlist;

    while (c) {
	if (stricmp(c->name, chan) == 0)
	    return c;
	c = c->next;
    }
    return NULL;
}
/*************************************************************************/
int has_chan_status(User *u, Channel *c, int status)
{
        struct u_chanlist *uc;

        if (!u || !c) return 0;

        for (uc = u->chans; uc; uc = uc->next)
                if (uc->chan == c)
                        return (uc->status & status);

        return 0;
}
/***********************************************************************/
void remove_chan_status(User *u, Channel *c, int status)
{
        struct u_chanlist *uc;

        if (!u || !c) return;

        for (uc = u->chans; uc; uc = uc->next) {
                if (uc->chan == c) {
                        uc->status &= ~status;
                        break;
                }
        }
}
/***********************************************************************/
void set_chan_status(User *u, Channel *c, int status)
{
        struct u_chanlist *uc;

        if (!u || !c) return;
        for (uc = u->chans; uc; uc = uc->next) {
                if (uc->chan == c) {
                        uc->status |= status;
                        break;
                }
        }
}

/*************************************************************************/
/* Add/remove a user to/from a channel, creating or deleting the channel as
 * necessary. */

void chan_adduser(User *user, const char *chan)
{
    Channel *c = findchan(chan);
    int newchan = !c;
    struct c_userlist *u;

#ifndef BAHSJOIN
    if (newchan) {
	if (debug)
	    log("debug: Creating channel %s", chan);
	/* Allocate pre-cleared memory */

	c = scalloc(sizeof(Channel), 1);
	c->next = chanlist;
	if (chanlist)
	    chanlist->prev = c;
	chanlist = c;
	strscpy(c->name, chan, sizeof(c->name));
	c->creation_time = CTime;
	/* This will restore locked modes and saved topic */
        check_invite(user, chan);
	check_modes(chan,user->nick);
	restore_topic(chan);
	botjoin(c->name);
        do_cs_join(chan);
    }
#endif

#ifndef BAHSJOIN
    u = scalloc(sizeof(struct c_userlist),1);
    u->next = c->users;
    u->prev = NULL;
    if (c->users)
	c->users->prev = u;
    c->users = u;
    u->user = user;
    u->ud = scalloc(sizeof(UserData), 1);
    u->ud->last_use = CTime;
    c->usercount++;
#endif

#ifdef UNREAL
        if (check_should_founderize(user, chan)) {
        	set_chan_status(user, c, CSTATUS_OWNER);
	} else
#endif
#ifdef DEFPROTECT
	if (check_should_protect(user, chan)) {
	        set_chan_status(user, c, CSTATUS_PROTECT);
        }
#endif
	if (!check_opguard(user, chan, c->usercount))
     	;
	else if (check_should_op(user, chan)) {
        	set_chan_status(user, c, CSTATUS_OP);
	} 
#ifdef DEFHALFOP
	if (check_should_halfop(user, chan)) {
	        set_chan_status(user, c, CSTATUS_HALFOP);
	} else 
#endif
	if (check_should_voice(user, chan)) {
	        set_chan_status(user, c, CSTATUS_VOICE);
	}

}

void chan_deluser(User *user, Channel *c)
{
    struct c_userlist *u;
    struct c_userlist *u2;

    if (!user || !c)
       return;

    u2 = c->users;
    if (!u2)
      return;

    for (u = c->users; u && u->user != user; u = u->next)
        ;
    if (!u)
	return;

    if (u->ud)
    {
        if (u->ud->lastline) {
                free(u->ud->lastline);
	}
        free(u->ud);
    }

    if (u->next)
	u->next->prev = u->prev;
    if (u->prev)
	u->prev->next = u->next;
    else
	c->users = u->next;
    free(u);

    if (c->usercount)
	    c->usercount--;

    if (!c->users) {
#ifdef SJOIN
        --schans;
#endif
	do_cs_part(c->name);
	botpart(c->name);
	if (debug)
	    log("debug: Deleting channel %s", c->name);

	if (c->topic)
	    free(c->topic);
	if (c->key)
	    free(c->key);
	if (c->link)
	    free(c->link);
	if (c->flood)
	    free(c->flood);
	if (c->wgame)
	    free(c->wgame);
	if (c->bancount) {
	    int i;
	    for (i = 0; i < c->bancount; ++i)
		if (c->bans[i])
			free(c->bans[i]);
	}
	if (c->bansize)
	    free(c->bans);
	if (c->next)
	    c->next->prev = c->prev;
	if (c->prev)
	    c->prev->next = c->next;
	else
	    chanlist = c->next;
	free(c);
    }
}

/*************************************************************************/

/* Handle a channel MODE command. */

void do_cmode(const char *source, int ac, char **av)
{
    Channel *chan;
    User *user;
    char *s, *nick;
    int add = 1, recheck = 0;		/* 1 if adding modes, 0 if deleting */
    char *modestr = av[1];
    chan = findchan(av[0]);

    if (!chan) {
	log("channel: MODE %s for nonexistent channel %s",
                                     merge_args(ac-1, av+1), av[0]);
	return;
    }

    if (strchr(source, '.') && !modestr[strcspn(modestr, cmodeless)]) {
        if (CTime != chan->server_modetime) {
            chan->server_modecount = 0;
            chan->server_modetime = CTime;
        }
        chan->server_modecount++;
    }

    s = modestr;
    ac -= 2;
    av += 2;
   
    while (*s) {

	switch (*s++) {

	case '+':
	    add = 1; break;

	case '-':
	    add = 0; break;

	case 'k':
	    if (add) {
			if (chan->key) {
				free(chan->key);
				chan->key = NULL;
  			}
			chan->key = sstrdup(*av++);
	    }
	    recheck = 1;
	    break;

	case 'l':
	    if (add) {
			chan->limit = atoi(*av++);
	    } else {
			chan->limit = 0;
	    }
 	    recheck = 1;

	    break;

#ifdef UNREAL
        case 'L':
            if (--ac < 0) {
                log("channel: MODE %s %s: missing parameter for %cL",
                                        chan->name, modestr, add ? '+': '-');
                break;
            }
            if (add && *av) {
	        if (chan->link) {
		        free(chan->link);
		        chan->link = NULL;
		}
		chan->link = sstrdup(*av++);

	    }
 	    recheck = 1;

            break;
#endif
#if defined(UNREAL)  || defined(ULTIMATE)
        case 'f':
            if (--ac < 0) {
                log("channel: MODE %s %s: missing parameter for %cf",
                                        chan->name, modestr, add ? '+': '-');
                break;
            }

            if (add && *av) {
		if (chan->flood) {
	                free(chan->flood);
	                chan->flood = NULL;
                }
	                chan->flood = sstrdup(*av++);
		}
 	    recheck = 1;

		break;
#endif
	case 'b':
	    if (--ac < 0) {
		log("channel: MODE %s %s: missing parameter for %cb",
					chan->name, modestr, add ? '+' : '-');
		break;
	    }
	    if (add) {
		if (chan->bancount >= chan->bansize) {
		    chan->bansize += 8;
		    chan->bans = srealloc(chan->bans,
					sizeof(char *) * chan->bansize);
		}
		chan->bans[chan->bancount++] = sstrdup(*av++);
	    } else {
		char **s1 = chan->bans;
		int i = 0;
		while (i < chan->bancount && strcmp(*s1, *av) != 0) {
		    ++i; ++s1;
		}
		if (i < chan->bancount) {
		    --chan->bancount;
		    if (i < chan->bancount)
			bcopy(s1+1, s1, sizeof(char *) * (chan->bancount-i));
		}
		++av;
	    }

	    break;
	case 'o':
	    if (--ac < 0) {
		log("channel: MODE %s %s: missing parameter for %co",
					chan->name, modestr, add ? '+' : '-');
		break;
	    }
	    nick = *av++;
	    if (add) {
		user = finduser(nick);
		if (!user) {
		    log("channel: MODE %s +o for nonexistent user %s",
							chan->name, nick);
		    break;
		}

		if (debug)
		    log("debug: Setting +o on %s for %s", chan->name, nick);

		set_chan_status(user, chan, CSTATUS_OP);
	    } else {
		user = finduser(nick);
		if (!user)
			break;
		remove_chan_status(user, chan, CSTATUS_OP);
	    }

	    break;
#ifdef DEFHALFOP
	case 'h':
	    if (--ac < 0) {
		log("channel: MODE %s %s: missing parameter for %ch",
					chan->name, modestr, add ? '+' : '-');
		break;
	    }
	    nick = *av++;
	    if (add) {
		user = finduser(nick);
		if (!user) {
		    log("channel: MODE %s +h for nonexistent user %s",
							chan->name, nick);
		    break;
		}
		if (debug)
		    log("debug: Setting +h on %s for %s", chan->name, nick);
		set_chan_status(user, chan, CSTATUS_HALFOP);
	    } else {
		user = finduser(nick);
		if (!user)
			break;
		remove_chan_status(user, chan, CSTATUS_HALFOP);
	    }
	    break;
#endif
	case 'v':
	    if (--ac < 0) {
		log("channel: MODE %s %s: missing parameter for %cv",
					chan->name, modestr, add ? '+' : '-');
		break;
	    }
	    nick = *av++;
	    if (add) {
		user = finduser(nick);
		if (!user) {
		    log("channel: MODE %s +v for nonexistent user %s",
							chan->name, nick);
		    break;
		}
		if (debug)
		    log("debug: Setting +v on %s for %s", chan->name, nick);
		set_chan_status(user, chan, CSTATUS_VOICE);
	    } else {
		user = finduser(nick);
		if (!user)
			break;
		remove_chan_status(user, chan, CSTATUS_VOICE);
	    }
	    break;
#ifdef UNREAL
	case 'q':
	    if (--ac < 0) {
		log("channel: MODE %s %s: missing parameter for %cq",
					chan->name, modestr, add ? '+' : '-');
		break;
	    }
	    nick = *av++;
	    if (add) {
		user = finduser(nick);
		if (!user) {
		    log("channel: MODE %s +q for nonexistent user %s",
							chan->name, nick);
		    break;
		}
		if (debug)
		    log("debug: Setting +q on %s for %s", chan->name, nick);

                if (!check_valid_op(user, chan->name, !!strchr(source, '.'))) {
                       send_cmd(s_ChanServ, "MODE %s -q %s", chan->name, nick);
                       break;
                } else {
		set_chan_status(user, chan, CSTATUS_OWNER);
		}
	    } else {
		user = finduser(nick);
		if (!user)
			break;
		remove_chan_status(user, chan, CSTATUS_OWNER);
	    }
	    break;
#endif
#ifdef DEFPROTECT
#if defined(UNREAL) || defined(RAGEIRCD) || defined(ULTIMATE)
	case 'a':
#elif defined(LIQUID)
	case 'u':
#endif
	    if (--ac < 0) {
			log("channel: MODE %s %s: missing parameter for %ca",
					chan->name, modestr, add ? '+': '-');
			break;
	    }
	    nick = *av++;
	    if (add) {
			user = finduser(nick);
		if (!user) {
		    log("channel: MODE %s +a for nonexistent user %s",
							chan->name, nick);
		    break;
		}
		if (debug)
		    log("debug: Setting +a on %s for %s", chan->name, nick);

                if (!check_valid_op(user, chan->name, !!strchr(source, '.'))) {
#ifdef UNREAL
                       send_cmd(s_ChanServ, "MODE %s -a %s", chan->name, nick);
#endif
#if defined(LIQUID) || defined(RAGEIRCD)
                       send_cmd(s_ChanServ, "MODE %s -u %s", chan->name, nick);
#endif
                       break;
                } else {
		set_chan_status(user, chan, CSTATUS_PROTECT);
		}
	    } else {
		user = finduser(nick);
		if (!user)
			break;
		remove_chan_status(user, chan, CSTATUS_PROTECT);
	    }
	    break;
#endif /* If DEFINE PRO */
	default:
 	    recheck = 1;

	} /* switch */

    } /* while (*s) */

/* Merge chan->modes and modestr */
    strscpy(chan->modes, changemode(modestr, chan->modes), sizeof(chan->modes));

/* Merge remove some cmode from chan->modes like a o h v... */
    strscpy(chan->modes, changemode(cmodeless, chan->modes), sizeof(chan->modes));

    /* Check modes against ChanServ mode lock */

    if (!is_servbot(source) && recheck)
         check_modes(chan->name, source);
}

/*************************************************************************/

/* Handle a TOPIC command. */

void do_topic(const char *source, int ac, char **av)
{
    Channel *c = findchan(av[0]);

    if (!c)
	return;
    
    strscpy(c->topic_setter, av[1], sizeof(c->topic_setter));

    c->topic_time = atol(av[2]);

    if (ac > 3 && *av[3]) {
	if (c->topic)
		free(c->topic);
	c->topic = sstrdup(av[3]);

    }
    if (!strchr(source, '.')) {
        if (check_topiclock(source, av[0])) {
            return;
	}
	record_topic(av[0]);
    } else {
	return;
    }
}

/*************************************************************************/

/* Does the given channel have only one user? */

/* Note:  This routine is not currently used, but is kept around in case it
 * might be handy someday. */

//#if 0

int only_one_user(const char *chan)
{
    Channel *c;

    for (c = chanlist; c; c = c->next) {
	if (stricmp(c->name, chan) == 0)
	    return (c->users && !c->users->next) ? 1 : 0;
    }
    return 0;
}

//#endif

int isin_chan(char *nick, const char *chan)
{
    Channel *c;
    struct c_userlist *cu;

    for (c = chanlist; c; c = c->next) {
        if (stricmp(c->name, chan) == 0) {
	    for (cu = c->users; cu; cu = c->users->next) {
		if (stricmp(cu->user->nick, nick) == 0)
		    return 1;
	    }
	    return 0;
	}
    }
    return 0;
}
/*************************************************************************/
int channel_form()
{
    Channel *c;
    int i = 0;
    for (c = chanlist; c; c = c->next)
	i++;
    return i;
}
/*************************************************************************/
void change_cmode (const char *who, const char *chan, const char *mode, const char *pram)
{
    char *av[3];
    av[0] = sstrdup (chan);
    av[1] = sstrdup (mode);
    av[2] = sstrdup (pram);
    send_cmd (who, "MODE %s %s %s", chan, mode, pram);
    do_cmode (who, 3, av);
    free (av[2]);
    free (av[1]);
    free (av[0]);
}
/****************************************************/
void kick_user (const char *who, const char *chan, const char *nick, const char *reason)
{
    char *av[3];
    av[0] = sstrdup (chan);
    av[1] = sstrdup (nick);
    av[2] = sstrdup (reason);
    send_cmd (who, "KICK %s %s :%s", chan, nick, reason);
    do_kick (who, 3, av);
    free (av[2]);
    free (av[1]);
    free (av[0]);
}
/***************************************************/
#ifdef SJOIN
static void add_suser(char *nick, char *channel)
{
   Channel *chan = findchan(channel);
   struct c_userlist *u;
   struct u_chanlist *c;
   User *user = finduser(nick);

      u = smalloc(sizeof(struct c_userlist));
      u->next = chan->users;
      u->prev = NULL;
      if (chan->users)
         chan->users->prev = u;
      chan->users = u;
      u->user = user;

      c = smalloc(sizeof(*c));
      c->next = user->chans;
      c->prev = NULL;
      if (user->chans)
          user->chans->prev = c;
      user->chans = c;
      c->chan = findchan(chan->name);
}
#endif
/***************************************************************/
char *filter_modes (char *chan, char *on, char *off)
{
    Channel *c = findchan (chan);
    ChannelInfo *ci = cs_findchan (chan);
    char *current = c->modes;
    char new_on[64];
    char new_off[64];
    char filtered[64];

    if (!c || !ci)
        return NULL;

    *filtered = *new_on = *new_off = 0;

    if (strchr (on, 'c') && !strchr (current, 'c') && !strchr (off, 'c'))
        strcat (new_on, "c");
    if (strchr (off, 'c') && strchr (current, 'c') && !strchr (on, 'c'))
        strcat (new_off, "c");

    if (strchr (on, 'i') && !strchr (current, 'i') && !strchr (off, 'i'))
        strcat (new_on, "i");
    if (strchr (off, 'i') && strchr (current, 'i') && !strchr (on, 'i'))
        strcat (new_off, "i");

    if (strchr (on, 'k') && !strchr (current, 'k') && !strchr (off, 'k'))
        strcat (new_on, "k");
    if (strchr (off, 'k') && strchr (current, 'k') && !strchr (on, 'k'))
        strcat (new_off, "k");


    if (strchr (on, 'l') && !strchr (current, 'l') && !strchr (off, 'l'))
        strcat (new_on, "l");
    if (strchr (off, 'l') && strchr (current, 'l') && !strchr (on, 'l'))
        strcat (new_off, "l");


    if (strchr (on, 'm') && !strchr (current, 'm') && !strchr (off, 'm'))
        strcat (new_on, "m");
    if (strchr (off, 'm') && strchr (current, 'm') && !strchr (on, 'm'))
        strcat (new_off, "m");


    if (strchr (on, 'n') && !strchr (current, 'n') && !strchr (off, 'n'))
        strcat (new_on, "n");
    if (strchr (off, 'n') && strchr (current, 'n') && !strchr (on, 'n'))
        strcat (new_off, "n");

    if (strchr (on, 'p') && !strchr (current, 'p') && !strchr (off, 'p'))
        strcat (new_on, "p");
    if (strchr (off, 'p') && strchr (current, 'p') && !strchr (on, 'p'))
        strcat (new_off, "p");

    if (strchr (on, 'r') && !strchr (current, 'r') && !strchr (off, 'r'))
        strcat (new_on, "r");
    if (strchr (off, 'r') && strchr (current, 'r') && !strchr (on, 'r'))
        strcat (new_off, "r");


    if (strchr (on, 'R') && !strchr (current, 'R') && !strchr (off, 'R'))
        strcat (new_on, "R");
    if (strchr (off, 'R') && strchr (current, 'R') && !strchr (on, 'R'))
        strcat (new_off, "R");

    if (strchr (off, 's') && strchr (current, 's') && !strchr (on, 's'))
        strcat (new_off, "s");
    if (strchr (on, 's') && !strchr (current, 's') && !strchr (off, 's'))
        strcat (new_on, "s");

    if (strchr (on, 't') && !strchr (current, 't') && !strchr (off, 't'))
        strcat (new_on, "t");
    if (strchr (off, 't') && strchr (current, 't') && !strchr (on, 't'))
        strcat (new_off, "t");

    if (strlen (new_on))
    {
        strcat (filtered, "+");
        strcat (filtered, new_on);
    }
    if (strlen (new_off))
    {
        strcat (filtered, "-");
        strcat (filtered, new_off);
    }
    if (ci->mlock_limit && c->limit != ci->mlock_limit)
        if (strlen (new_on))
            if (strchr (new_on, 'l'))
            {
                strcat (filtered, " ");
                strcat (filtered, myitoa(ci->mlock_limit));
            }
    if (ci->mlock_key && (!c->key || !strcmp (c->key, ci->mlock_key)))
        if (strlen (new_on))
            if (strchr (new_on, 'k'))
            {
                strcat (filtered, " ");
                strcat (filtered, ci->mlock_key);
            }
    if (strlen (new_off))
        if (strchr (new_off, 'k'))
        {
            strcat (filtered, " ");
            strcat (filtered, c->key);
        }
    if (strlen (filtered))
        change_cmode (s_ChanServ, c->name, filtered, "");

    return NULL;
}

/***************************************************/
#ifdef SJOIN
static void scheck_ops(char *chan, char **checklist, int count)
{
  ChannelInfo *ci = cs_findchan(chan);
  Channel *c = findchan(chan);
  struct c_userlist *u;
  char buf[1024], buf2[128];
  User *user;
  int i, modes=0, acc=0;

  *buf=0; *buf2=0;

  if (!ci)
    return;

  for (i = 0; i < count; i++) {
    user = finduser(checklist[i]);
    if (!user)
        continue;

    acc = get_access(user, ci);

    if (acc == 3) {
        if (*buf)
           strcat(buf, " ");
        else
           strcat(buf2, "+");
        strcat(buf, user->nick);
        strcat(buf2, "v");
        modes++;
	if (c)
		set_chan_status(user, c, CSTATUS_VOICE);
    }
    if (acc > 3) {
        update_last_used(chan);
        if (*buf)
           strcat(buf, " ");
        else
           strcat(buf2, "+");


        strcat(buf, user->nick);
        strcat(buf2, "o");
        modes++;
	if (c)
		set_chan_status(user, c, CSTATUS_OP);
    }
    if (modes > 5) {
       send_cmd(s_ChanServ, "MODE %s %s %s", chan, buf2, buf);
       modes = 0;
       *buf = 0; *buf2 = 0;
    }
  }
  if (*buf)
     send_cmd(s_ChanServ, "MODE %s %s %s", chan, buf2, buf);
}
#endif
/*************************************************/
#ifdef SJOIN
static void update_last_used(const char *chan)
{
   ChannelInfo *ci = cs_findchan(chan);

   if (!ci)
      return;
   else
      ci->last_used = CTime;
}
#endif
