#if defined(BAHAMUT)
# define cmodeless       "-ovb"
#elif defined(UNREAL)
# define cmodeless       "-ohvbaqe"
#elif defined(IRC_DALNET)
# define cmodeless       "-ovb"
#else
# define cmodeless       "-ovub"
#endif

#ifdef CR
# define RMODE	"+R"
#else
# define RMODE	"+r"
#endif
#if defined(BAHAMUT)
# define NEWNICK(nick,user,host,real,modes,qline) \
    do { \
        send_cmd(NULL, "NICK %s 1 %ld %s %s %s %s 0 :%s", (nick), time(NULL), (modes), \
                (user), (host), SERVER_NAME, (real)); \
        if ((qline)) send_cmd(NULL, "SQLINE %s :Reserved for services", (nick)); \
    } while (0)
# define CNEWNICK(nick,user,host,real,modes,qline) \
    do { \
        send_cmd(NULL, "NICK %s 1 0 %s %s %s 1 + * :%s", (nick),\
                (user), (host), SERVER_NAME, (real)); \
    } while (0)

#elif defined(UNREAL)
# define NEWNICK(nick,user,host,real,modes,qline) \
    do { \
        send_cmd(NULL, "NICK %s 1 %ld %s %s %s 0 %s %s :%s", (nick), time(NULL),\
                (user), (host), SERVER_NAME, (modes), (host), (real)); \
        if (strcmp(modes, "+")) send_cmd((nick), "MODE %s %s", (nick), (modes)); \
        if ((qline)) send_cmd(NULL, "SQLINE %s :Reserved for services", (nick)); \
    } while (0)
# define CNEWNICK(nick,user,host,real,modes,qline) \
    do { \
        send_cmd(NULL, "NICK %s 1 0 %s %s %s 0 + %s :%s", (nick), \
                (user), (host), SERVER_NAME, (host), (real)); \
    } while (0)
#else
# define NEWNICK(nick,user,host,real,modes,qline) \
    do { \
        send_cmd(NULL, "NICK %s 1 %ld %s %s %s 0 :%s", (nick), time(NULL),\
                (user), (host), SERVER_NAME, (real)); \
        if (strcmp(modes, "+")) send_cmd((nick), "MODE %s %s", (nick), (modes)); \
        if ((qline)) send_cmd(NULL, "SQLINE %s :Reserved for services", (nick)); \
    } while (0)
# define CNEWNICK(nick,user,host,real,modes,qline) \
    do { \
        send_cmd(NULL, "NICK %s 1 0 %s %s %s 0 :%s", (nick), \
                (user), (host), SERVER_NAME, (real)); \
    } while (0)
#endif


typedef struct author_ Auths;
struct author_ {
        char *who;              /* Who request Auth */
        char *chan;				/* Request for chan */
        long flags;				/* What kind of request ? */
        time_t time;
	long number;
};

typedef struct authlist_ AuthList;

struct authlist_ {
    AuthList *next, *prev;
    char nick[NICKMAX]; /* Owner of the auth */
    long n_memos;       /* Number of auth */
    Auths *memos;        /* The auth themselves */
};

#define AUTH_UOP	0x00000001  /* Add to UOP */
#define AUTH_VOP	0x00000002  /* Add to VOP */
#define AUTH_HOP	0x00000004
#define AUTH_AOP	0x00000008
#define AUTH_SOP	0x00000010
#define AUTH_CFOUNDER	0x00000020

typedef struct admininfo_ AdminInfo;
struct admininfo_ {
        AdminInfo *next, *prev;
        char *nick;             /* Admin Nickname*/
        char *host;             /* Admin host */
        char *who;		/* Who add this admin */
	char *server;
	char **mark;		/* Make by Services Root flag mark */
	long markline;
        long adflags;           /* Admin Flags */
        long flags;		/* What this Admin Can Do ? */
        time_t added;
};

#define ADF_HELPOP		0x00000001
#define ADF_SERVICEOP		0x00000002
#define ADF_SERVICEADMIN	0x00000004
#define ADF_SERVICEROOT		0x00000008

#define AI_ADDSRA		0x00000001 /* Can add SRA */
#define AI_ADDSA		0x00000002 /* Can add SA */
#define AI_HOLD		0x00000004 /* can do hold */
#define AI_GLOBAL		0x00000008 /* can send global message */
#define AI_SINGLE		0x00000010 /* Only have access in his own server */
#define AI_SUPEROP	0x00000020 /* Always AOP */
#define AI_AKILL		0x00000040 /* can do akill */
#define AI_FORCEJOIN	0x00000080 /* can do force join */
#define AI_ABUSETM	0x00000100 /* Abuse Team */
#define AI_QUIT		0x00000200 /* Suspend From Rank */
#define AI_FORBID		0x00000400 /* Can do forbid */

extern void load_admin_db(void);
extern void save_admin_db(void);
extern AdminInfo *findadmin(const char *nick);
extern void adminserv(const char *source, char *buf);
extern char *s_AdminServ;
extern AdminInfo *adminlists[256];
extern int is_oper_cando(const char *source, int operflag);
extern void do_lautoop (const char *nick, const char *chan, int acc);
extern void do_sendaccept(const char *source, char *nick, char *chan, int alevel);
extern int get_file_version(FILE *f, char *filename);
extern void kill_user(const char *source, const char *user, const char *reason);
extern unsigned char char_atribs[];
extern time_t          CTime;
#define MAXLEN      512
#define HOSTLEN     64
#define PRINT		1
#define CNTRL		2
#define ALPHA		4
#define PUNCT		8
#define DIGIT		16
#define SPACE		32
#define ALLOW		64
#define isallowed(c) (char_atribs[(u_char)(c)]&ALLOW)
#define isNum(num) (!(strspn(num,"0123456789") - strlen(num)) && strlen(num))
