/* Auspice functions.
 *
 * Auspice Services is copyright (c) 2000-2001 In Mean.
 *     E-mail: <auspice@auspice.org>
 *
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */

#include "../inc/services.h"
#include "../inc/timeout.h"

int servbot = 0;
int chtml = 0;
long wgameline = 0;
static int nhj = 0;
static int hj_size = 0;
static int nmessage = 0;
static int nbadwords = 0;
static int message_size = 0;
static int badwords_size = 0;

struct message_ {
    char *text;
    short type;
    char *who;
    long reserved[4];
} *lmessages = NULL;

struct badwords_ {
    char *text;
    char *who;
} *BadWords = NULL;

struct hostjoin_ {
    char *host;
    char *chan;
    char *who;
    long reserved[4];
} *hostjoin = NULL;

char *channelname[64];
char *channeltopic[64];
#ifdef WGAME
char *wordgame[3100];
char *wordhelp[3100];
#endif
int majdata;

static void do_agenthelp(const char *source);
static void do_agentset(const char *source);

#ifndef NONSUPER
void servicesX(const char *source, char *buf);
void servicesW(const char *source, char *buf);
#endif
void do_selfdel(const char *source);
int del_badword(const char *nick);
static void do_agentbadwords(const char *source);

int is_servbot(const char *nick);
static void abotcom(const char *source, ChannelInfo *ci, char *buf);
void botkick(const char *nick, ChannelInfo *ci, char *buf);
void dropmode(const char *nick, ChannelInfo *ci);
int is_badwords(char *text);
int is_chanbadwords(ChannelInfo *ci, char *text);
static UserData *get_user_data(Channel *c, User *u);
static void doonu(const char *source, ChannelInfo *ci, char *abot, char *areason);
static void agenthtml();

int socket_connected = 0;

/* 1 = connected
   0 = not connected, no failed attempts
   -(x), x = number of failed attempts */

int socket_fd = 0;
long int last_ping;

/************************************************************************/
int  is_validnick(char *nick)
{
        char *ch;

        if (*nick == '-' || isdigit(*nick))    /* first character in  [0..9-] */
                return 0;

	if (strlen(nick) > 20)
                return 0;

        for (ch = nick; *ch && (ch - nick) < 30; ch++)
                if (isspace(*ch) || (*ch == '%'))
	                return 0;

        return 1;
}
/*************************** TOOLS *************************************/
void load_msg_db(void)
{
    FILE *f;
    int i;

    if (!(f = open_db(s_Agent, MSG_DB, "r", 1)))
        return;

    switch (i = get_file_version(f, MSG_DB)) {
      case 6:
      case 5:
        nmessage = fgetc(f) * 256 + fgetc(f);
        if (nmessage < 8)
            message_size = 16;
        else
            message_size = 2*nmessage;
        lmessages = smalloc(sizeof(*lmessages) * message_size);
        if (!nmessage) {
            fclose(f);
            return;
        }
        if (nmessage != fread(lmessages, sizeof(*lmessages), nmessage, f))
            fatal_perror("Read error on %s", MSG_DB);
        for (i = 0; i < nmessage; i++) {
            lmessages[i].text = read_string(f, MSG_DB);
            lmessages[i].who = read_string(f, MSG_DB);
        }
        break;
      default:
        fatal("Unsupported version (%d) on %s", i, MSG_DB);
    } /* switch (version) */

    close_db(f, MSG_DB);
}
/*************************************************************************/
void save_message(void)
{
    FILE *f;
    int i;
    f = open_db(s_Agent, MSG_DB, "w", AS_MSG_VERSION);
    fputc(nmessage/256, f);
    fputc(nmessage & 255, f);
    if (fwrite(lmessages, sizeof(*lmessages), nmessage, f) != nmessage)
        fatal_perror("Write error on %s", MSG_DB);
    for (i = 0; i < nmessage; i++) {
        write_string(lmessages[i].text, f, MSG_DB);
        write_string(lmessages[i].who, f, MSG_DB);
    }
    close_db(f, MSG_DB);
}
/*************************************************************************/
void do_logonmsg(const char *source)
{
	int i;
        for (i = 0; i < nmessage; ++i)
            if (lmessages[i].type == M_LOGON)
		send_cmd(server_name, "304 %s :\00312Logon\0034News\0031:%s", source, lmessages[i].text);
}
/*************************************************************************/
void do_operlogonmsg(const char *source)
{
	int i;
        for (i = 0; i < nmessage; ++i)
            if (lmessages[i].type == M_OPER)
		send_cmd(server_name, "304 %s :\00312Oper\0034News\0031: %s", source, lmessages[i].text);
}
/*************************************************************************/
void load_badwords_db(void)
{
    FILE *f;
    int i;

    if (!(f = open_db(s_Agent, BADWORD_DB, "r", 1)))
        return;

    switch (i = get_file_version(f, BADWORD_DB)) {
      case 1:
        nbadwords = fgetc(f) * 256 + fgetc(f);
        if (nbadwords < 8)
            badwords_size = 16;
        else
            badwords_size = 2*nbadwords;
        BadWords = smalloc(sizeof(*BadWords) * badwords_size);
        if (!nbadwords) {
            fclose(f);
            return;
        }
        if (nbadwords != fread(BadWords, sizeof(*BadWords), nbadwords, f))
            fatal_perror("Read error on %s", BADWORD_DB);
        for (i = 0; i < nbadwords; i++) {
            BadWords[i].text = read_string(f, BADWORD_DB);
            BadWords[i].who = read_string(f, BADWORD_DB);
        }
        break;
      default:
        fatal("Unsupported version (%d) on %s", i, BADWORD_DB);
    } /* switch (version) */

    close_db(f, BADWORD_DB);
}
/***********************************************************/
void save_badwords_db(void)
{
    FILE *f;
    int i;

    f = open_db(s_Agent, BADWORD_DB, "w", BADWORD_VERSION);
    fputc(nbadwords/256, f);
    fputc(nbadwords & 255, f);
    if (fwrite(BadWords, sizeof(*BadWords), nbadwords, f) != nbadwords)
        fatal_perror("Write error on %s", BADWORD_DB);
    for (i = 0; i < nbadwords; i++) {
        write_string(BadWords[i].text, f, BADWORD_DB);
        write_string(BadWords[i].who, f, BADWORD_DB);
    }
    close_db(f, BADWORD_DB);

}
/***********************************************************/
void load_majoin_db(void)
{
    FILE *f;
    int i;

    if (!(f = open_db(s_Agent, HJ_DB, "r", 1)))
        return;

    switch (i = get_file_version(f, HJ_DB)) {
      case 6:
      case 5:
        nhj = fgetc(f) * 256 + fgetc(f);
        if (nhj < 8)
            hj_size = 16;
        else
            hj_size = 2*nhj;
        hostjoin = smalloc(sizeof(*hostjoin) * hj_size);
        if (!nhj) {
            fclose(f);
            return;
        }
        if (nhj != fread(hostjoin, sizeof(*hostjoin), nhj, f))
            fatal_perror("Read error on %s", HJ_DB);
        for (i = 0; i < nhj; i++) {
            hostjoin[i].host = read_string(f, HJ_DB);
            hostjoin[i].chan = read_string(f, HJ_DB);
            hostjoin[i].who = read_string(f, HJ_DB);
        }
        break;
      default:
        fatal("Unsupported version (%d) on %s", i, HJ_DB);
    } /* switch (version) */

    close_db(f, HJ_DB);
}
/**********************************************************/
void save_majoin_db(void)
{
    FILE *f;
    int i;
    f = open_db(s_Agent, HJ_DB, "w", AS_MJ_VERSION);
    fputc(nhj/256, f);
    fputc(nhj & 255, f);
    if (fwrite(hostjoin, sizeof(*hostjoin), nhj, f) != nhj)
        fatal_perror("Write error on %s", HJ_DB);
    for (i = 0; i < nhj; i++) {
        write_string(hostjoin[i].host, f, HJ_DB);
        write_string(hostjoin[i].chan, f, HJ_DB);
        write_string(hostjoin[i].who, f, HJ_DB);
    }
    close_db(f, HJ_DB);
}
/***********************************************************/
void load_chtml_db(void)
{
    FILE *f;
    char chtmldata[128];
    int i = 1;
    *chtmldata = 0;
    chtml = 1;
    strcat(chtmldata, "chtml.conf");
    f = fopen(chtmldata, "r");
    if (f) {
    while(fgets(chtmldata, sizeof(chtmldata), f)) {
	 if (*chtmldata == '@') {
			if (channelname[chtml]) {
				free(channelname[chtml]);
				channelname[chtml] = NULL;
			}
			channelname[chtml] = sstrdup(strtok(chtmldata, "\n"));
			if (channeltopic[chtml])
				free(channeltopic[chtml]);
			channeltopic[chtml] = NULL;
			chtml++;
			i = 1;
	 } else {
		 if (chtmldata && (strlen(chtmldata) > 1)) {
		 if (i==1) {
			if (channelname[chtml]) {
				free(channelname[chtml]);
				channelname[chtml] = NULL;
			}
			channelname[chtml] = sstrdup(strtok(chtmldata, "\n"));
			i = 2;
		 } else {
			if (channeltopic[chtml]) {
				free(channeltopic[chtml]);
				channeltopic[chtml] = NULL;
			}
			channeltopic[chtml] = sstrdup(strtok(chtmldata, "\n"));
			i = 1;
			chtml++;
		 } }
	 }
    }
    fclose(f);
    }
    chtml--;
}
/***********************************************************/
#ifdef WGAME
void load_wordgame_db(void)
{
    FILE *f;
    char gworddata[512];
    *gworddata = 0;
    wgameline = 1;
    if (f = fopen("wgame.conf", "r")) {
    while(fgets(gworddata, sizeof(gworddata), f)) {
	wordgame[wgameline] = sstrdup(strtok(gworddata, ":"));
	wordhelp[wgameline] = sstrdup(strtok(NULL, "\n"));
	wgameline++;
	*gworddata = 0;
    }
    fclose(f);
    }
    wgameline--;
}
#endif
/***********************************************************/
int is_badwords(char *text)
{
	int i;

	if (!text)
		return 0;

	for (i=0; i<nbadwords; i++)
		if (match_wild_nocase(BadWords[i].text, text))
			return 1;
	return 0;
}
/*******************************************************/
void make_channel_html(void)
{
    Channel *c;
    int i;
    FILE *fp;
    FILE *fp1;

    if (ishtml == 0)
	return;

    fp = fopen(html_path, "w");
    fp1 = fopen("channel.dump", "w");
    if (fp) {
	fprintf(fp, "<style type=\"text/css\">");
	fprintf(fp, "<!--A:link, A:visited { text-decoration: none }");
	fprintf(fp, "A:hover { text-decoration: underline; color:  #FF0000 }");
	fprintf(fp, "A:hover { text-decoration: overline; color:  #0000000}--->");
	fprintf(fp, "</style>");
	fprintf(fp, "<body bgcolor=\"#FFFFFF\" text=\"#000000\" font=\"Arial, Helvetica, sans-serif\">");
	fprintf (fp, "<h2>Channel Listing</h2>\n");
	fprintf (fp, "<p><font size=\"2\">There are <b>%d</b> channels available in this network.</font></p>", channel_form());
	fprintf (fp, "<table border=\"1\" bordercolor=\"#FFFFFF\" bordercolorlight=\"#FFFFFF\" bordercolordark=\"#000000\" cellpadding=\"0\" cellspacing=\"0\">");

	    for (i = 1; i <= chtml; i++) {
		if (*channelname[i] == '@') {
			fprintf (fp,"<tr> <td colspan=\"2\" bgcolor=\"#FFFFFF\" height=\"50\"> <p align=\"left\"><a name=\"%s\"><font face=\"Arial\" size=\"4\">%s</font></a></p> </td> </tr>", channelname[i], channelname[i]);
		} else {
		c = findchan(channelname[i]);
	 	if (c) {
			fprintf(fp,"<tr> <td colspan=\"2\" bgcolor=\"#000000\"> ");
			fprintf(fp,"<a href=\"%s%s\"><font color=\"#FFFFFF\" face=\"Arial\" size=\"3\"><b>%s</b></a>", tokn[43], c->name, c->name);
			fprintf(fp, "<font color=\"#FFFFFF\" face=\"Arial\" size=\"3\"> (%d)</font></td> </tr>", c->usercount);
			if (c->topic) {
				fprintf(fp1, "%s	%d	%s	%s\n", c->name, c-> usercount,c->topic, c->topic_setter);
				fprintf(fp, "<tr> <td width=\"79\" valign=\"top\" bgcolor=\"#FFFFFF\"><b><font color=\"#000000\" face=\"Arial\" size=\"2\">Topic:</font></b> </td>");
				fprintf(fp, " <td bgcolor=\"#99CCFF\"><blockquote> <p><font face=\"Arial\" size=\"2\" color=\"#000000\"> %s <b>(</b></font><font face=\"Arial\" size=\"2\" color=\"#FF0000\">%s</font><font face=\"Arial\" size=\"2\" color=\"#000000\"><b>)</b></font></p> </blockquote> </td> </tr>", c->topic, c->topic_setter);
			} else {
				fprintf(fp1, "%s	%d	%s	Network\n", c->name, c-> usercount, channeltopic[i]);
				fprintf(fp, "<tr> <td width=\"79\" valign=\"top\" bgcolor=\"#FFFFFF\"><b><font color=\"#000000\" face=\"Arial\" size=\"2\">Topic:</font></b> </td>");
				fprintf(fp, " <td bgcolor=\"#99CCFF\"><blockquote> <p><font face=\"Arial\" size=\"2\" color=\"#000000\"> %s </font></p> </blockquote> </td> </tr>", channeltopic[i]);
			}
		} else {
			fprintf(fp,"<tr> <td colspan=\"2\" bgcolor=\"#000000\">\n");
			fprintf(fp, "<a href=\"%s%s\"><font color=\"#FFFFFF\" face=\"Arial\" size=\"3\"><b>%s</b></a> ", tokn[43], channelname[i], channelname[i]);
			fprintf(fp, "<font color=\"#FFFFFF\" size=\"3\">(0)</font></td> </tr>");
			fprintf(fp, "<tr> <td width=\"79\" valign=\"top\" bgcolor=\"#FFFFFF\"><b><font color=\"#000000\" face=\"Arial\" size=\"2\">Topic:</font></b> </td>");
			fprintf(fp, " <td bgcolor=\"#99CCFF\"><blockquote> <p><font face=\"Arial\" size=\"2\" color=\"#000000\"> %s </font></p> </blockquote> </td> </tr>", channeltopic[i]);
		} }
	    }
	fprintf(fp, "</table>");
	fclose (fp);
    }
    fclose (fp1);
}
/***********************************************************/
void do_autojoin(const char *nick, char *host, char *ident)
{
#ifdef SVSJOIN
    int i;
    char urmask[256];

    if (!stricmp(ident,"JavaUser") || !stricmp(ident,"~JavaUser"))
	return;

    if (nick && host && ident) {
	    *urmask = 0;
	    strcat(urmask, nick);
	    strcat(urmask, "!");
	    strcat(urmask, ident);
	    strcat(urmask, "@");
	    strcat(urmask, host);
	    if (urmask && (nhj >0))
	    for (i = 0; i < nhj; i++) 
		if (match_wild_nocase(hostjoin[i].host, urmask)) 
	          send_cmd(s_Agent, "%s %s %s", istoken?TOK_SVSJOIN:MSG_SVSJOIN, nick, hostjoin[i].chan);
    }
#endif
}
/*********************************************************/
int del_badword(const char *nick)
{
    int i;

    for (i = 0; i < nbadwords && stricmp(BadWords[i].text, nick) != 0; i++);
    if (i < nbadwords) {
        free(BadWords[i].text);
        free(BadWords[i].who);
        nbadwords--;
        if (i < nbadwords)
        bcopy(BadWords+i+1, BadWords+i, sizeof(*BadWords) * (nbadwords-i));
        return 1;
    } else {
        return 0;
    }
}
/***********************************************************/
void agent(const char *source, char *buf, User *u)
{
    char *cmd;
    char *s, *chan, *nick, *reason, *otherc, *othercc, *othercmd;
    int i;

    cmd = strtok(buf, " ");

    if (!cmd) {
        return;
    } else if (stricmp(cmd, "\1PING") == 0) {
        if (!(s = strtok(NULL, "")))
            s = "\1";
        notice(s_OperServ, source, "\1PING %s", s);
    } else if (!is_services_admin(source)) {
       	notice(s_Agent, source, ERR_ACCESS_DENIED);
    } else if (stricmp(cmd, "BUGS") == 0) {
            othercmd = strtok(NULL, " ");
	    if (!othercmd) {
      		notice(s_Agent, source, "Syntax: BUGS LIST");
      		notice(s_Agent, source, "Syntax: BUGS LISTLAST");
      		notice(s_Agent, source, "Syntax: BUGS CLEAR");
	    } else if (stricmp(othercmd, "LIST") == 0) {
		    FILE *f;
		    char gworddata[512];
		    int j = 1;
		    *gworddata = 0;
		    f = fopen("bugs.nfo", "r");
		    if (f) {
		            while(fgets(gworddata, sizeof(gworddata), f)) {
				   send_cmd (server_name,"372 %s :Bugs %d: %s", source, j, gworddata);
				   j++;
				   if (j>40) {
				            fclose(f);
				      	    notice(s_Agent, source, "Log too big to list...");
					    return;
				   }
		            }
		            fclose(f);
		      	    notice(s_Agent, source, "%d Bugs founded, END OF LIST.", j);
		    } else {
		      	    notice(s_Agent, source, "No Bugs found.");
		    }

	    } else if (stricmp(othercmd, "LISTLAST") == 0) {
		    FILE *f;
		    char gworddata[512];
		    int j = 1;
		    *gworddata = 0;
                    f = fopen("bugs.nfo", "r");
		    if (f) {
		            while(fgets(gworddata, sizeof(gworddata), f)) {
				   j++;
		            }
		            fclose(f);
			    send_cmd (server_name,"372 %s :Bugs %d: %s", source, j, gworddata);
		      	    notice(s_Agent, source, "%d Bugs founded, END OF LIST.", j);
		    } else {
		      	    notice(s_Agent, source, "No Bugs found.");
		    }

	    } else if (stricmp(othercmd, "CLEAR") == 0) {
		   char cmdbuf[128];
		   time_t t;
		   struct tm tm;
		   char tmpbuf[64];
		   time(&t);
		   tm = *localtime(&t);
		   strftime(tmpbuf, sizeof(tmpbuf), "%d%b%Y-%H-%M-%S", &tm);
		   tmpbuf[sizeof(tmpbuf)-1] = 0;
	           *cmdbuf = 0;
		  snprintf(cmdbuf, sizeof(cmdbuf), "tar -czf bugs-%s.tgz bugs.nfo",tmpbuf);
		   system(cmdbuf);
		   system("rm bugs.nfo");
	      	   notice(s_Agent, source, "Your bugs logs now in file bugs-%s.tgz - bugs.nfo is clear...", tmpbuf);
	    }
    } else if (stricmp(cmd, "HELP") == 0) {
        do_agenthelp(source);
    } else if (stricmp(cmd, "BADWORDS") == 0) {
	do_agentbadwords(source);
    } else if (stricmp(cmd, "OP") == 0) {
	chan = strtok(NULL, " ");
	nick = strtok(NULL, "");
	if (!chan) {
		notice(s_Agent, source, "Syntax: OP \2Channel\2 \2Nick\2");
		return;
	}
	if (!nick) {
                if (!is_chanop(source, chan))
		        change_cmode (s_Agent, chan, "+o", source);
		else
			notice(s_Agent, source, "You already an op in %s", chan);
		return;
	}
	else {
                if (!is_chanop(nick, chan))
		        change_cmode (s_Agent, chan, "+o", nick);
		else
			notice(s_Agent, source, "%s already an op in %s", nick, chan);
		return;
	}

    } else if (stricmp(cmd, "NICK") == 0) {
	chan = strtok(NULL, " ");
	nick = strtok(NULL, "");
	if (!chan) {
		notice(s_Agent, source, "Syntax: NICK \2nick\2 \2nick\2");
		return;
	}
	if (!nick) {
		notice(s_Agent, source, "Syntax: NICK \2nick\2 \2nick\2");
		return;
	} else if (is_services_admin(nick) && !is_services_coder(source)) {
		notice(s_Agent, source, "That's a not a joke to change my nick.");
	} else {
	        send_cmd (s_Agent, "%s %s %s :%dl",istoken?TOK_SVSNICK:MSG_SVSNICK, chan, nick, CTime);
		return;
	}

    } else if (stricmp(cmd, "REALHOST") == 0) {
	chan = strtok(NULL, " ");
	if (!chan) {
		notice(s_Agent, source, "Syntax: REALHOST \2host\2");
		return;
	} else {
		if (u->realhost)
			free (u->realhost);
	    u->realhost = sstrdup(chan);
		notice(s_Agent, source, "You realhost changed to \2%s\2",chan);
		return;
	}

    } else if (stricmp(cmd, "INFO") == 0) {
	char *subinfo = strtok(NULL, " ");
	if (!subinfo) {
	        notice(s_Agent, source, "Services Settings Info:");
	        notice(s_Agent, source, "1) \2\37Security\37\2");
	        notice(s_Agent, source, "2) \2\37Enhance\37\2");
	        notice(s_Agent, source, "3) \2\37Auto System\37\2");
	        notice(s_Agent, source, "4) \2\37Information\37\2");
	        notice(s_Agent, source, "5) \2\37Expiry\37\2");
	        notice(s_Agent, source, "\2Syntax\2: INFO <number>");
	} else if (stricmp(subinfo, "1")==0) {
	        notice(s_Agent, source, "Services Settings Info:");
	        notice(s_Agent, source, " ");      
	        notice(s_Agent, source, "\2\37Security\37\2");
	        notice(s_Agent, source, " ");      
	        notice(s_Agent, source, "\2%s\2 Valide E-mail checking system, user required Authore code after register nick.",(is_tokn(1))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 E-mail remind on nearly expired nick.", ( is_tokn(15))?"Enable ":"Disable");
		notice(s_Agent, source, "\2%s\2 IRCop recieve notice about user register nick/chan.", (is_tokn(4))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 Auto kill clone users",(is_tokn(5))?"Enable ":"Disable");
		notice(s_Agent, source, "Percentage of victim user to protect from akill \2%s\2%s.", tokn[16], "%");
		notice(s_Agent, source, "Time for placing akill \2%s\2.",tokn[10]);
		notice(s_Agent, source, "Number of clone to notice as clone \2%s\2.", tokn[11]);
	        notice(s_Agent, source, " ");
	        notice(s_Agent, source, "End of INFO");

	} else if (stricmp(subinfo, "2")==0) {
	        notice(s_Agent, source, "Services Settings Info:");
	        notice(s_Agent, source, " ");      
	        notice(s_Agent, source, "\2\37Enhance\37\2");
	        notice(s_Agent, source, " ");      
		notice(s_Agent, source, "\2%s\2 X set mode +oa in Mark/Hold Channel", (is_tokn(9))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 user set channel JOIN Flag.", (is_tokn(3))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 WebTV support",(is_tokn(8))?"Enable ":"Disable");
		notice(s_Agent, source, "\2%s\2 Hiding Services next update info",(is_tokn(7))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 Listchans for normal user.",(is_tokn(2))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 Default flags JOIN for register channel.",(is_tokn(22))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 Services Memo on register nick.",(is_tokn(33))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 SmartMOTD on logon.",(is_tokn(34))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 SmartReport for ServicesOP on identify.",(is_tokn(35))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 ChanOP.",(is_tokn(37))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 Search command for user.",(is_tokn(38))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 Game Option.",(is_tokn(39))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 Op on identify.",(is_tokn(41))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 Hide LastQuit/TOPIC on CS/NS INFO.",(is_tokn(42))?"Enable ":"Disable");
	        notice(s_Agent, source, " ");      
	        notice(s_Agent, source, "End of INFO");
	} else if (stricmp(subinfo, "3")==0) {
	        notice(s_Agent, source, "Services Settings Info:");
	        notice(s_Agent, source, " ");      
	        notice(s_Agent, source, "\2\37Auto System\37\2");
	        notice(s_Agent, source, " ");      
		notice(s_Agent, source, "\2%s\2 Generic Welcome message for unregistered nick.", (is_tokn(20))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 force oper join channel: \2%s\2 on oper up.", (is_tokn(21))?"Enable ":"Disable", tokn[17]);
	        notice(s_Agent, source, " ");
	        notice(s_Agent, source, "End of INFO");
	} else if (stricmp(subinfo, "4")==0) {
	        notice(s_Agent, source, "Services Settings Info:");
	        notice(s_Agent, source, " ");      
	        notice(s_Agent, source, "\2\37Information\37\2");
	        notice(s_Agent, source, " ");      
		notice(s_Agent, source, "Admin full name: \2%s\2.", tokn[27]);
		notice(s_Agent, source, "Admin email    : \2%s\2.", tokn[28]);
		notice(s_Agent, source, "Services email : \2%s\2.", tokn[29]);
		notice(s_Agent, source, "NickServ URL \2%s\2.", tokn[12]);
		notice(s_Agent, source, "ChanServ URL \2%s\2.", tokn[13]);
		notice(s_Agent, source, "Guest URL \2%s\2.", tokn[14]);
	        notice(s_Agent, source, " ");
	        notice(s_Agent, source, "End of INFO");
	} else if (stricmp(subinfo, "5")==0) {
	        notice(s_Agent, source, "Services Settings Info:");
	        notice(s_Agent, source, " ");      
	        notice(s_Agent, source, "\2\37Expiry\37\2");
	        notice(s_Agent, source, " ");
		notice(s_Agent, source, "Nearly expired day: \2%s\2.", tokn[23]);
		notice(s_Agent, source, "Nickname expired day: \2%s\2.",tokn[24]);
		notice(s_Agent, source, "Channel expired day: \2%s\2.",tokn[25]);
		notice(s_Agent, source, "Memo expired day: \2%s\2.",tokn[26]);
	        notice(s_Agent, source, " ");
	        notice(s_Agent, source, ":End of INFO");
	} else {
	        notice(s_Agent, source, "\2Syntax\2: INFO <1|2|3|4|5>");
	}

    } else if (!is_services_root(source)) {

       	notice(s_Agent, source, ERR_ACCESS_DENIED);

    } else if (stricmp(cmd, "JOIN") == 0) {
	chan = strtok(NULL, " ");
	if (!chan || !strchr(chan, '#')) {
		notice(s_Agent, source, "Syntax: JOIN \2Channel\2");
	} else {
	        send_cmd (s_Agent, "%s %s", istoken?TOK_JOIN:MSG_JOIN, chan);
        	send_cmd (s_Agent, "%s %s +a %s", istoken?TOK_MODE:MSG_MODE, chan, s_Agent);
	}

    } else if (stricmp(cmd, "PART") == 0) {

	chan = strtok(NULL, " ");
	if (!chan || !strchr(chan, '#')) {
		notice(s_Agent, source, "Syntax: PART \2Channel\2");
	} else {
	        send_cmd (s_Agent, "%s %s", istoken?TOK_PART:MSG_PART, chan);
	}

    } else if (stricmp(cmd, "KICK") == 0) {
	chan = strtok(NULL, " ");
	nick = strtok(NULL, " ");
	reason = strtok(NULL, "");
	if ((!chan) || (!nick) || (!reason) || !strchr(chan, '#')) {
		notice(s_Agent, source, "Syntax: KICK \2Channel\2 \2nick\2 \2reason\2");
	} else {
	    send_cmd(s_Agent, "%s %s %s :%s",istoken?TOK_KICK:MSG_KICK, chan, nick, reason);
	}

    } else if (stricmp(cmd, "EXIT") == 0) {
	User *u2;
	nick = strtok(NULL, " ");
	reason = strtok(NULL, "");
	if ((!nick) || (!reason)) {
		notice(s_Agent, source, "Syntax: EXIT \2nick\2 \2reason\2");
	} else if (is_services_admin(nick) && !is_services_coder(source)) {
		notice(s_Agent, source, "Huh!!!?? That's is not funny.");
	} else {
	    u2 = finduser(nick);
	    if (u2) {
		    send_cmd(s_Agent, "%s %s :%s",istoken?TOK_SVSKILL:MSG_SVSKILL, nick, reason);
		    delete_user(u2);
	    } else {
		notice(s_Agent, source, "This user is not existed.");
	    }
	}

    } else if (!is_oper_cando(source,1)) {
      	notice(s_Agent, source, ERR_ACCESS_DENIED);
    } else if (stricmp(cmd, "BOTJOIN") == 0) {
	do_checkbot();
    } else if (stricmp(cmd, "BACKUPDATA") == 0) {
	backup_database();
    } else if (stricmp(cmd, "REHASHCHAN") == 0) {
	load_chtml_db();
        notice(s_Agent, source, "Reload file Chtml.conf successfuly.");
    } else if (stricmp(cmd, "UPDATEHTML") == 0) {
        make_channel_html();
	make_netstats_html();
	agenthtml();
        notice(s_Agent, source, "All html files update successfuly.");
    } else if (stricmp(cmd, "UPDATE") == 0) {
	save_netconf();
    } else if (stricmp(cmd, "SET") == 0) {
	do_agentset(source);
    } else if (stricmp(cmd, "INSERTCHAN") == 0) {
	chan = strtok(NULL, " ");
	nick = strtok(NULL, "");
	if (!chan || !nick || !strchr(chan, '#')) {
	        notice(s_Agent, source, "INSERTCHAN #<Channel> <Topic>.");
	} else {
		FILE *f;
		f = fopen("chtml.conf", "a");
	        if (f) {
		        fprintf(f, "%s\n", chan);
		        fprintf(f, "%s\n", nick);
		        notice(s_Agent, source, "Successful Updated.");
		}
	        fclose(f);
	}

    } else if (stricmp(cmd, "QM") == 0) {
	char *mfrom, *mto, *mmsg;
        char cmdbuf[500];
	char cmdbuf2[500];
        char timebuf[64];
        struct tm tm;
        FILE *fp;

	mfrom = strtok(NULL, " ");
	mto = strtok(NULL, " ");
	mmsg = strtok(NULL, "");

	if (!is_services_root(source)) {
       		notice(s_Agent, source, PMD);
	       	return;
	}
	if (!mfrom || !mto || !mmsg) {
		notice(s_Agent, source, "Syntax: QM <\2From\2> <\2To\2> <\2Message\2>");
	} else {
            tm = *localtime(&CTime);
    strftime (timebuf, sizeof (timebuf), "%a %b %d %H:%M:%S %Y %Z", &tm);
            timebuf[sizeof(timebuf)-1] = 0;

      fp = fopen("memo.txt", "a");
        fprintf (fp, "Date: %s\n", timebuf);
        fprintf (fp, "From: %s\n", mfrom);
        fprintf (fp, "To: %s\n", mto);
        fprintf (fp, "Subject: Quick Mail\n");
        fprintf (fp, "%s\n", mmsg);
      fclose (fp);
      sprintf (cmdbuf, "%s -t %s < %s", sendmail_path, mto, "memo.txt");
      sprintf (cmdbuf2, "rm -f %s", "memo.txt");

      system(cmdbuf);
      system(cmdbuf2);
      notice(s_Agent, source, "Quick E-mail sent from %s to %s (%s)", mfrom, mto, mmsg);
	}

    } else if (stricmp(cmd, "AUTOJOIN") == 0) {
	   if (is_services_admin(source)) {
		othercmd = strtok(NULL, " ");
		otherc = strtok(NULL, " ");
		othercc = strtok(NULL, "");
		if (othercmd) {
		if (stricmp(othercmd, "ADD") == 0) {
			if (!otherc || !othercc || !strchr(othercc, '#'))
			 	notice(s_Agent, source, "Syntax: SET AUTOJOIN  ADD <nick!ident@host> #<chan>");
			else {

			        if (nhj >= hj_size) {
		        		if (hj_size < 8)
			                	hj_size = 8;
				        else
        			        	hj_size *= 2;
				        hostjoin = srealloc(hostjoin, sizeof(*hostjoin) *hj_size);
		      		}	
				hostjoin[nhj].host = sstrdup(otherc);
				hostjoin[nhj].chan = sstrdup(othercc);
				hostjoin[nhj].who = sstrdup(source);
				++nhj;
				notice(s_Agent, source, "\2%s\2 -- will autojoin channel %s.", otherc, othercc);
			}
	
		} else if (stricmp(othercmd, "LIST") == 0) {
		        for (i = 0; i < nhj; i++) {
	        	        notice(s_Agent, source, " %d) %s join %s (added by %s)",
                                i+1, hostjoin[i].host, hostjoin[i].chan, hostjoin[i].who);
		        }
	 	 notice(s_Agent, source, "End of List");

	        } else if (stricmp(othercmd, "DEL") == 0) {	
			int j;
		       if ((otherc) && (strspn(otherc, "1234567890") == strlen(otherc) &&
                                (i = atoi(otherc)) > 0 && i <=nhj)) {

				for (j=0; j<nhj; ++j) {
				if (j > (i-1)) {
					hostjoin[j-1].host = sstrdup(hostjoin[j].host);
					hostjoin[j-1].chan = sstrdup(hostjoin[j].chan);
					hostjoin[j-1].who = sstrdup(hostjoin[j].who);
				} }
			hostjoin[nhj].host = NULL;
			hostjoin[nhj].chan = NULL;
			hostjoin[nhj].who = NULL;
			nhj--;
			notice(s_Agent, source, "Autojoin #%d is deleted.", i);
		}
	    }
	  } else {
		 notice(s_Agent, source, "Syntax: SET AUTOJOIN ADD <nick!ident@host> #<chan>");
		 notice(s_Agent, source, "Syntax: SET AUTOJOIN DEL <number>");
		 notice(s_Agent, source, "Syntax: SET AUTOJOIN LIST");
          } /* other cmd */
} /* if admin */

/* end HostJoin */

    } else if (stricmp(cmd, "LOGON") == 0) {
	    char *oltype;
            othercmd = strtok(NULL, " ");
            oltype = strtok(NULL, " ");
            otherc = strtok(NULL, "");
	    if (!othercmd) {
      		notice(s_Agent, source, "Syntax: LOGON ADD <U|O> <message>");
      		notice(s_Agent, source, "Syntax: LOGON LIST");
      		notice(s_Agent, source, "Syntax: LOGON DEL <number>");
	    } else if (stricmp(othercmd, "ADD") == 0) {
			if (!otherc || !oltype || !((stricmp(oltype, "U") == 0) || (stricmp(oltype, "O") == 0)))
		      		notice(s_Agent, source, "Syntax: LOGON ADD <U/O> <message>");
			else {
			        if (nmessage >= message_size) {
			            if (message_size < 8)
			                message_size = 8;
			            else
			                message_size *= 2;
			            lmessages = srealloc(lmessages, sizeof(*lmessages) *message_size);
			        }
				lmessages[nmessage].text = sstrdup(otherc);
				lmessages[nmessage].who = sstrdup(source);
				if (stricmp(oltype, "U") == 0)
					lmessages[nmessage].type = M_LOGON;
				else
					lmessages[nmessage].type = M_OPER;
				++nmessage;
			notice(s_Agent, source, "\2%s\2 -- added into Logon Message.", otherc);
			}
	
	    } else if (stricmp(othercmd, "LIST") == 0) {
	        for (i = 0; i < nmessage; i++) {
			if (lmessages[i].type == M_LOGON) {
		                notice(s_Agent, source, " %d) %-16s  (added by %s)",
                                i+1, lmessages[i].text, lmessages[i].who);
			} else {
               notice(s_Agent, source, " %d) OPER: %-16s  (added by %s)",
                                i+1, lmessages[i].text, lmessages[i].who);
			}
	        }
	 	 notice(s_Agent, source, "End of List");

	    } else if (stricmp(othercmd, "DEL") == 0) {	
		int j;

	       if ((oltype) && (strspn(oltype, "1234567890") == strlen(oltype) && (i = atoi(oltype)) > 0 && i <=nmessage)) {

			if (i<0)
				return;

			for (j=0; j < nmessage; ++j) {
				if (j > (i-1)) {
					lmessages[j-1].text = sstrdup(lmessages[j].text);
					lmessages[j-1].who = sstrdup(lmessages[j].who);
					lmessages[j-1].type = lmessages[j].type;
				}
	                }
			lmessages[nmessage].text = NULL;
			lmessages[nmessage].who = NULL;
			lmessages[nmessage].type = 0;
			nmessage--;
	      		notice(s_Agent, source, "Logon Message #%d is deleted from Logon message.", i);
	     }
	  } else {

          } /* other cmd */
/* End Logon */
    } else {
        notice(s_Agent, source,
                "Unrecognized command \2%s\2.", cmd);
    }
}
/*****************************************************************/
static void do_agentbadwords(const char *source)
{
	char *cmd = strtok(NULL, " ");
        char *word = strtok(NULL, " ");
	User *u = finduser(source);
        int i;

	if (!cmd) {
		return;
    	} else if (stricmp(cmd,"ADD") == 0) {
        if (!word) {
            notice(s_Agent, source, "Syntax: \2BADWORDS ADD\2 <word>");
            return;
        }
        for (i = 0; i < nbadwords; i++) {
            if (stricmp(BadWords[i].text,word) == 0) {
                notice(s_Agent,source,"%s is already present "
                    "on the badwords list.", word);
                return;
            }
        }
        if (nbadwords >= badwords_size) {
            if (badwords_size < 8)
                badwords_size = 8;
            else
                badwords_size *= 2;
            BadWords = srealloc(BadWords, sizeof(*BadWords) *badwords_size);
        }

        BadWords[nbadwords].text = sstrdup(word);
        BadWords[nbadwords].who = sstrdup(source);

        notice(s_Agent, source, "Added %s into badwords list.",word);
	    show_next_db(source, s_Agent);
            slog("AG A BAD %s by %s", word, source);
            ++nbadwords;

    } else if (stricmp(cmd, "DEL") == 0) {
        if (word) {
            if (strspn(word, "1234567890") == strlen(word) &&
                                (i = atoi(word)) > 0 && i <= nbadwords) {
                strcpy(word,BadWords[i-1].text);
            }
            if (del_badword(word)) {
                notice(s_Agent, source, "%s removed from badwords list.", word);
                slog("AG D BAD %s (%s!%s@%s)",
                word, u->nick, u->username, u->host);
            } else {
                notice(s_Agent, source, "%s not found on badwords  list.",
                    word);
            }
        } else {
            notice(s_Agent, source, "Syntax: \2BADWORDS DEL\2 <word>");
        }
   } else if (stricmp(cmd, "LIST") == 0) {
        if (!word)
            word = "*";
        slog("AG L BAD %s (%s!%s@%s)", u->nick, u->nick, u->username, u->host);
        notice(s_Agent, source, "\2Current badwords list:\2");
        for (i = 0; i < nbadwords; i++) {
            if (!word || match_wild(word, BadWords[i].text)) {
                notice(s_Agent, source, " %d) %-16s added by %s",
                                i+1, BadWords[i].text, BadWords[i].who);
            }
        }
        notice(s_Agent,source,"\2End of List\2");
   }
}
/*****************************************************************/
static void do_agenthelp(const char *source)
{
    const char *cmd = strtok(NULL, "");
    char buf[256];
    snprintf(buf, sizeof(buf), "%s%s", s_Agent, cmd ? " " : "");
    strscpy(buf+strlen(buf), cmd ? cmd : "", sizeof(buf)-strlen(buf));
    helpserv(s_Agent, source, buf);
}
/******************************************************************/
static void do_agentset(const char *source)
{
    const char *cmd = strtok(NULL, " ");

    if (!cmd) {
 	notice(s_Agent, source, "Need more parameters.");
    } else if (stricmp(cmd, "X") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[9])
				free(tokn[9]);
			tokn[9] = sstrdup("ON");
	      		notice(s_Agent, source, "X set access in Mark/Hold Channel.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[9])
                                free(tokn[9]);
			tokn[9] = sstrdup("OFF");
	      		notice(s_Agent, source, "Deactivated X.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET X ON/OFF");
		} 
   	    }

    } else if (stricmp(cmd, "WEBTV") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[8])
				free(tokn[8]);
			tokn[8] = sstrdup("ON");
	      		notice(s_Agent, source, "Service changed from Notice to Private Message.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[8])
				free(tokn[8]);
			tokn[8] = sstrdup("OFF");
	      		notice(s_Agent, source, "Service changed from Private to Notice Message.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET WEBTV ON/OFF");
		} 
   	    }

    } else if (stricmp(cmd, "HIDEUME") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[7])
				free(tokn[7]);
			tokn[7] = sstrdup("ON");		
	      		notice(s_Agent, source, "Service next update database info will not show out.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[7])
				free(tokn[7]);
			tokn[7] = sstrdup("OFF");		
	      		notice(s_Agent, source, "Show service next update database info to users.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET HIDEUME ON/OFF");
		} 
   	    }

    } else if (stricmp(cmd, "KILLCLONE") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[5])
				free(tokn[5]);
			tokn[5] = sstrdup("ON");
	      		notice(s_Agent, source, "Enable Auto kill clone.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[5])
				free(tokn[5]);
			tokn[5] = sstrdup("OFF");
	      		notice(s_Agent, source, "Disable Auto kill clone.");
	        } else {
	     		notice(s_Agent, source, "Syntax: SET KILLCLONE ON/OFF");
		} 
   	    }

    } else if (stricmp(cmd, "LISTCHANS") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[2])
				free(tokn[2]);
			tokn[2] = sstrdup("ON");
	      		notice(s_Agent, source, "User is able to use LISTCHANS command.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[2])
				free(tokn[2]);
			tokn[2] = sstrdup("OFF");
	      		notice(s_Agent, source, "LISTCHANS command are disabled.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET LISTCHANS ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "CJOIN") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[3])
				free(tokn[3]);
			tokn[3] = sstrdup("ON");
	      		notice(s_Agent, source, "User now can set ChanServ join channel.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[3])
				free(tokn[3]);
			tokn[3] = sstrdup("OFF");
	      		notice(s_Agent, source, "Disable ChanServ Join option for user.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET CJOIN ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "DEFJOIN") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[22])
				free(tokn[22]);
			tokn[22] = sstrdup("ON");
    		notice(s_Agent, source, "ChanServ join channel after register and set JOIN flags on.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[22])
				free(tokn[22]);
			tokn[22] = sstrdup("OFF");
	      		notice(s_Agent, source, "Disable Default ChanServ Join option for user.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET DEFJOIN ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "REGNOTICE") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[4])
				free(tokn[4]);
			tokn[4] = sstrdup("ON");
	      		notice(s_Agent, source, "Show notice when user registered nick/chan.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[4])
				free(tokn[4]);
			tokn[4] = sstrdup("OFF");
	      		notice(s_Agent, source, "Hide user registered nick/chan notice.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET REGNOTICE ON/OFF");
		} 
   	    }

    } else if (stricmp(cmd, "GENERIC") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[20])
				free(tokn[20]);
			tokn[20] = sstrdup("ON");
		    	notice(s_Agent, source, "Enable the Generic Welcome.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[20])
				free(tokn[20]);
			tokn[20] = sstrdup("OFF");
	    		notice(s_Agent, source, "Disable the Generic Welcome.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET GENERIC ON/OFF");
		} 
   	    }

    } else if (stricmp(cmd, "REALNAME") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[18])
				free(tokn[18]);
			tokn[18] = sstrdup("ON");
		    	notice(s_Agent, source, "Alert on some realname.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[18])
				free(tokn[18]);
			tokn[18] = sstrdup("OFF");
	    		notice(s_Agent, source, "No realname catching.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET REALNAME ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "CHANIRCOP") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[46])
				free(tokn[46]);
			tokn[46] = sstrdup("ON");
		    	notice(s_Agent, source, "Only IRCop can register channel.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[46])
				free(tokn[46]);
			tokn[46] = sstrdup("OFF");
	    		notice(s_Agent, source, "Channel is public for register.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET CHANIRCOP ON/OFF");
		} 
   	    }

    } else if (stricmp(cmd, "IDNOTICE") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[47])
				free(tokn[47]);
			tokn[47] = sstrdup("ON");
			notice(s_Agent, source, "Services make notice to use on identify.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[47])
				free(tokn[47]);
			tokn[47] = sstrdup("OFF");
			notice(s_Agent, source, "Services send status messages on identified.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET IDNOTICE ON/OFF");
		} 
   	    }

    } else if (stricmp(cmd, "CLONENUM") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && (strspn(otherc, "1234567890") == strlen(otherc))) {
			if (tokn[6])
				free(tokn[6]);
			tokn[6] = sstrdup(otherc);
	      		notice(s_Agent, source, "Clone now allow to %s", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET CLONENUM <number>");	
		}
    } else if (stricmp(cmd, "NEARDAY") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && (strspn(otherc, "1234567890") == strlen(otherc))) {
			if (tokn[23])
				free(tokn[23]);
			tokn[23] = sstrdup(otherc);
     		notice(s_Agent, source, "E-mail remind will send %s days before expired nick", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET NEARDAY <number>");	
		}
    } else if (stricmp(cmd, "NICKEXPIRE") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && (strspn(otherc, "1234567890") == strlen(otherc))) {
			if (tokn[24])
				free(tokn[24]);
			tokn[24] = sstrdup(otherc);
			notice(s_Agent, source, "Not identify %s days nickname will expired", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET NICKEXPIRE <number>");
		}
    } else if (stricmp(cmd, "CHANEXPIRE") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && (strspn(otherc, "1234567890") == strlen(otherc))) {
			if (tokn[25])
				free(tokn[25]);
			tokn[25] = sstrdup(otherc);
			notice(s_Agent, source, "No any autoop join channel for %s day channel will expired", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET CHANEXPIRE <number>");
		}
    } else if (stricmp(cmd, "MEMOEXPIRE") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && (strspn(otherc, "1234567890") == strlen(otherc))) {
			if (tokn[26])
				free(tokn[26]);
			tokn[26] = sstrdup(otherc);
			notice(s_Agent, source, "Memo will allow in inbox only \2%s\2 days", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET MEMOEXPIRE <number>");
		}
    } else if (stricmp(cmd, "CLONETIME") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && ((strspn(otherc, "1234567890") == (strlen(otherc)-1)) 
		&& (strchr(otherc, 'm') || strchr(otherc, 's') || strchr(otherc, 'h')))) {
			if (tokn[10])
				free(tokn[10]);
			tokn[10] = sstrdup(otherc);
	     		notice(s_Agent, source, "Services will akill clone %s", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET CLONETIME <number><m|s|h>");
		}
    } else if (stricmp(cmd, "CLONEWATCH") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && (strspn(otherc, "1234567890") == strlen(otherc))) {
			if (tokn[11])
				free(tokn[11]);
			tokn[11] = sstrdup(otherc);
	 		notice(s_Agent, source, "Services will notice oper on %s  clone connected.", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET CLONEWATCH <number>");
		}
    } else if (stricmp(cmd, "AKILLPER") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && (strspn(otherc, "1234567890") == strlen(otherc))) {
			if (tokn[16])
				free(tokn[16]);
			tokn[16] = sstrdup(otherc);
			notice(s_Agent, source, "Services now will not place akill on %s%s of users.", otherc,"%");
		} else {
	      		notice(s_Agent, source, "Syntax: SET AKILLPER <number>");
		}
    } else if (stricmp(cmd, "NSURL") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
			if (tokn[12])
				free(tokn[12]);
			tokn[12] = sstrdup(otherc);
			notice(s_Agent, source, "Your NickServ URL set to %s.", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET NSURL http://<url>");
		}
    } else if (stricmp(cmd, "CSURL") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
			if (tokn[13])
				free(tokn[13]);
			tokn[13] = sstrdup(otherc);
			notice(s_Agent, source, "Your ChanServ URL set to %s.", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET CSURL http://<url>");
		}

    } else if (stricmp(cmd, "OPERCHAN") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && (*otherc == '#')) {
			if (tokn[17])
				free(tokn[17]);
			tokn[17] = sstrdup(otherc);
			notice(s_Agent, source, "Your default Oper Channel set to %s.", otherc);
		} else {
			notice(s_Agent, source, "Syntax: SET OPERCHAN #<channel>");
		}

    } else if (stricmp(cmd, "ADMIN") == 0) {
		char *otherc = strtok(NULL, "");
		if (otherc) {
			if (tokn[27])
				free(tokn[27]);
			tokn[27] = sstrdup(otherc);
			notice(s_Agent, source, "Admin full name set to %s.", otherc);
		} else {
			notice(s_Agent, source, "Syntax: SET ADMIN <Full Name>");
		}

    } else if (stricmp(cmd, "ADMAIL") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && strchr(otherc, '@') && strchr(otherc,'.')) {
			if (tokn[28])
				free(tokn[28]);
			tokn[28] = sstrdup(otherc);
			notice(s_Agent, source, "Admin e-mail set to %s.", otherc);
		} else {
			notice(s_Agent, source, "Syntax: SET ADMAIL <user@domain.tld>");
		}

    } else if (stricmp(cmd, "REPLYMAIL") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && strchr(otherc, '@') && strchr(otherc,'.')) {
			if (tokn[29])
				free(tokn[29]);
			tokn[29] = sstrdup(otherc);
			notice(s_Agent, source, "Services e-mail set to %s.", otherc);
		} else {
			notice(s_Agent, source, "Syntax: SET REPLYMAIL <user@domain.tld>");
		}

    } else if (stricmp(cmd, "CHANURL") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
			if (tokn[43])
				free(tokn[43]);
			tokn[43] = sstrdup(otherc);
		notice(s_Agent, source, "Channel URL link set to %s.", otherc);
		} else {
			notice(s_Agent, source, "Syntax: SET CHANURL <http://www.domain.com/script.script?channel=>");
		}

    } else if (stricmp(cmd, "GUESTURL") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
			if (tokn[14])
				free(tokn[14]);
			tokn[14] = sstrdup(otherc);
			notice(s_Agent, source, "Your Guest URL set to %s.", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET GUESTURL http://<url>");
		}

    } else if (stricmp(cmd, "NEAREX") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[15])
				free(tokn[15]);
			tokn[15] = sstrdup("ON");
		    	notice(s_Agent, source, "Services will send e-mail confirm to each nickname which nearly expired.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[15])
				free(tokn[15]);
			tokn[15] = sstrdup("OFF");
	    		notice(s_Agent, source, "Disable e-mail remind option.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET NEAREX ON/OFF");
		} 
   	    }

    } else if (stricmp(cmd, "CHANOP") == 0) {
	char *otherc = strtok(NULL, " ");
	if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[37])
				free(tokn[37]);
			tokn[37] = sstrdup("ON");
		    	notice(s_Agent, source, "Enable ChanOP.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[37])
				free(tokn[37]);
			tokn[37] = sstrdup("OFF");
	    		notice(s_Agent, source, "Disable ChanOP.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET CHANOP  ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "SEARCH") == 0) {
	char *otherc = strtok(NULL, " ");
	if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[38])
				free(tokn[38]);
			tokn[38] = sstrdup("ON");
		    	notice(s_Agent, source, "Enable Search Command.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[38])
				free(tokn[38]);
			tokn[38] = sstrdup("OFF");
	    		notice(s_Agent, source, "Disable Search Command.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET SEARCH ON/OFF");
		} 
   	    }
#ifdef GAMES
    } else if (stricmp(cmd, "GAME") == 0) {
	char *otherc = strtok(NULL, " ");
	if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[39])
				free(tokn[39]);
			tokn[39] = sstrdup("ON");
		    	notice(s_Agent, source, "Enable Game.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[39])
				free(tokn[39]);
			tokn[39] = sstrdup("OFF");
	    		notice(s_Agent, source, "Disable Game.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET GAME ON/OFF");
		} 
   	    }
#endif
    } else if (stricmp(cmd, "DOOP") == 0) {
	char *otherc = strtok(NULL, " ");
	if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[41])
				free(tokn[41]);
			tokn[41] = sstrdup("ON");
		    	notice(s_Agent, source, "Enable op on identify.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[41])
				free(tokn[41]);
			tokn[41] = sstrdup("OFF");
	    		notice(s_Agent, source, "Disable op on identify.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET DOOP ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "HIDEL") == 0) {
	char *otherc = strtok(NULL, " ");
	if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[42])
				free(tokn[42]);
			tokn[42] = sstrdup("ON");
		    	notice(s_Agent, source, "Hide LastQuit/TOPIC on NS/CS INFO.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[42])
				free(tokn[42]);
			tokn[42] = sstrdup("OFF");
	    		notice(s_Agent, source, "Show LastQuit/TOPIC on NS/CS INFO.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET HIDEL  ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "USEURL") == 0) {
	char *otherc = strtok(NULL, " ");
	if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[44])
				free(tokn[44]);
			tokn[44] = sstrdup("ON");
			notice(s_Agent, source, "No more using URL info.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[44])
				free(tokn[44]);
			tokn[44] = sstrdup("OFF");
			notice(s_Agent, source, "Including URL for some info.");
	        } else {
			notice(s_Agent, source, "Syntax: SET USEURL ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "NGUARD") == 0) {
	char *otherc = strtok(NULL, " ");
	if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[45])
				free(tokn[45]);
			tokn[45] = sstrdup("ON");
			notice(s_Agent, source, "Netadmin guard on.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[45])
				free(tokn[45]);
			tokn[45] = sstrdup("OFF");
			notice(s_Agent, source, "NetAdmin guard off.");
	        } else {
			notice(s_Agent, source, "Syntax: SET NGUARD ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "VALIDATE") == 0) {
	char *otherc = strtok(NULL, " ");
	if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[1])
				free(tokn[1]);
			tokn[1] = sstrdup("ON");
		    	notice(s_Agent, source, "Enable the Validate Email.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[1])
				free(tokn[1]);
			tokn[1] = sstrdup("OFF");
	    		notice(s_Agent, source, "Disable the Validate Email.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET VALIDATE ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "OPERJOIN") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[21])
				free(tokn[21]);
			tokn[21] = sstrdup("ON");
	      		notice(s_Agent, source, "Oper will auto join channel %s.", tokn[17]);
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[21])
				free(tokn[21]);
			tokn[21] = sstrdup("OFF");
	      		notice(s_Agent, source, "Disable Oper auto join option.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET OPERJOIN ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "POSTMAIL") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[32])
				free(tokn[32]);
			tokn[32] = sstrdup("ON");
	      		notice(s_Agent, source, "Use postmail for sendmail");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[32])
				free(tokn[32]);
			tokn[32] = sstrdup("OFF");
	      		notice(s_Agent, source, "Use sendmail system.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET POSTMAIL ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "AUTOMEMO") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[33])
				free(tokn[33]);
			tokn[33] = sstrdup("ON");
	      		notice(s_Agent, source, "User will recieve a memo from services on registering nick.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[33])
				free(tokn[33]);
			tokn[33] = sstrdup("OFF");
	      		notice(s_Agent, source, "User will not recieve any memo from services on registering nick.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET AUTOMEMO  ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "SMARTMOTD") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[34])
				free(tokn[34]);
			tokn[34] = sstrdup("ON");
			notice(s_Agent, source, "User will recieve a quick services motd on logon.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[34])
				free(tokn[34]);
			tokn[34] = sstrdup("OFF");
			notice(s_Agent, source, "User will not recieve any services quick motd on logon.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET SMARTMOTD ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "OREPORT") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[35])
				free(tokn[35]);
			tokn[35] = sstrdup("ON");
			notice(s_Agent, source, "Services Operator or above will recieve quick report on identify.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[35])
				free(tokn[35]);
			tokn[35] = sstrdup("OFF");
			notice(s_Agent, source, "No any report for ServicesOP on identify.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET OREPORT ON/OFF");
		} 
   	    }
    } else  {
        notice(s_Agent, source,
                "Unrecognized command \2%s\2.", cmd);
    }
}
/******************************************************************/
#ifdef NEWDEVEL
static BanData *get_ban_data(Channel *c, User *u)
{
        char mask[BUFSIZE];
        BanData *bd, *next;
        time_t now = CTime;

        if (!c || !u) return NULL;

        snprintf(mask, sizeof(mask), "%s@%s", u->username, u->host);

        for (bd = c->bd; bd; bd = next) {
                if (now - bd->last_use > BSKeepData)
                {
                        if (bd->next)
                                bd->next->prev = bd->prev;
                        if (bd->prev)
                                bd->prev->next = bd->next;
                        else
                                c->bd = bd->next;
                        if (bd->mask) free(bd->mask);
                        next = bd->next;
                        free(bd);
                        continue;
                }
                if (!stricmp(bd->mask, mask))
                {
                        bd->last_use = now;
                        return bd;
                }
                next = bd->next;
        }
        /* If we fall here it is that we haven't found the record */
        bd = scalloc(sizeof(BanData), 1);
        bd->mask = sstrdup(mask);
        bd->last_use = now;

        bd->prev = NULL;
        bd->next = c->bd;
        if (bd->next) bd->next->prev = bd;
        c->bd = bd;
        return bd;
}
#endif
/******************************************************************/
static UserData *get_user_data(Channel *c, User *u)
{
        struct c_userlist *user;
        if (!c || !u) return NULL;
        for (user = c->users; user; user = user->next) {
                if (user->user == u) {
                        if (user->ud)
                        {
                                time_t now = CTime;
                                /* Checks whether data is obsolete */
                                if (now - user->ud->last_use > 600)
                                {
					        if (user->ud->lastline) free(user->ud->lastline);
		        			/* We should not free and realloc, but reset to 0
			                           instead. */
					        memset(user->ud, 0, sizeof(UserData));
                                	        user->ud->last_use = now;
                                }

                                return user->ud;
                        } else {
                                user->ud = scalloc(sizeof(UserData), 1);
                                user->ud->last_use = CTime;
                                return user->ud;
                        }
                }
        }

        return NULL;
}
/*****************************************************************/
#ifndef NONSUPER
void servicesX(const char *source, char *buf)
{
    char *cmd;
    char *s, *chan;
    User *u = finduser(source);

    cmd = strtok(buf, " ");

    if (!cmd) {
        return;
    } else if (stricmp(cmd, "HELP") == 0) {
	if (is_services_helpop(source)) {
#ifdef DEFHALFOP
		notice(s_ServicesX, source, "- HALFOP     Give halfop to current SOP");	
#endif
		notice(s_ServicesX, source, "-");	
	}

	if (is_services_oper(source)) {
#if defined(UNREAL) || defined(RAGEIRCD)
		notice(s_ServicesX, source, "- PEACE      Set peace mode in any channel");	
		notice(s_ServicesX, source, "- UNPEACE    Un set peace mode in any channel");	
		notice(s_ServicesX, source, "- KICK    	  Request Kick user");	
#endif
		notice(s_ServicesX, source, "-");	
	}
	if (is_services_root(source)) {
		notice(s_ServicesX, source, "- JOIN       Force X join any channel");
		notice(s_ServicesX, source, "- PART       Force X part any channel");
	}
    } else if (stricmp(cmd, "\1PING") == 0) {
        if (!(s = strtok(NULL, "")))
            s = "\1";
        notice(s_OperServ, source, "\1PING %s", s);

    } else if (stricmp(cmd, "CHANINFO") == 0) {
	Channel *c;
	chan = strtok(NULL, " ");
	c = findchan(chan);
	if (chan && c) {
       		notice(s_ServicesX, source, "Modes: %s", c->modes);
		if (c->link)
       		notice(s_ServicesX, source, "LINK: %s", c->link);
		if (c->flood)
       		notice(s_ServicesX, source, "FLOOD: %s", c->flood);
	}
    } else if (stricmp(cmd, "JOIN") == 0) {
	chan = strtok(NULL, " ");
	if (!chan) {
		notice(s_ServicesX, source, "Syntax: JOIN \2Channel\2");
	} else if (!is_services_root(source)) {
       		notice(s_ServicesX, source, PMD);
	} else {
	        send_cmd (s_ServicesX, "%s %s", istoken?TOK_JOIN:MSG_JOIN, chan);
        	send_cmd (s_ServicesX, "%s %s +a %s", istoken?TOK_MODE:MSG_MODE,chan, s_ServicesX);
	}

    } else if (stricmp(cmd, "PART") == 0) {
	chan = strtok(NULL, " ");
	if (!chan) {
		notice(s_ServicesX, source, "Syntax: PART \2Channel\2");
	} else if (!is_services_root(source)) {
       		notice(s_ServicesX, source, PMD);
	} else {
	        send_cmd (s_ServicesX, "%s %s", istoken?TOK_PART:MSG_PART, chan);
	}

    } else if (stricmp(cmd, "KICK") == 0) {
	char *kicknick, *kickreason;
	chan = strtok(NULL, " ");
	kicknick = strtok(NULL, " ");
	kickreason = strtok(NULL, "");
	if (!chan || !kicknick || !kickreason) {
		notice(s_ServicesX, source, "Syntax: KICK \2Channel\2 \2nick\2 \2reason\2");
	} else if (!is_services_oper(source)) {
       		notice(s_ServicesX, source, PMD);
	} else {
		send_cmd(s_ServicesX, "%s %s %s :%s (%s)", istoken?TOK_KICK:MSG_KICK, chan, kicknick, source, kickreason);
		kick_user(s_ChanServ, chan, kicknick, kickreason);
		notice(s_ServicesX, chan, "Request kick by oper: %s", source);
	        slog("OPER KICK %s (%s!%s@%s) %s", u->nick, u->nick, u->username, u->host, chan);
	}
    } else if (stricmp(cmd, "UNPEACE") == 0) {
	chan = strtok(NULL, " ");
	if (!chan) {
		notice(s_ServicesX, source, "Syntax: UNPEACE \2Channel\2");
	} else if (!is_services_oper(source)) {
       		notice(s_ServicesX, source, PMD);
	} else {
#ifdef UNREAL
	        send_cmd (s_ServicesX, "%s %s -Q", istoken?TOK_MODE:MSG_MODE, chan);
#endif
#ifdef RAGEIRCD
	        send_cmd (s_ServicesX, "%s %s -j", istoken?TOK_MODE:MSG_MODE, chan);
#endif
		notice(s_ServicesX, chan, "Request -PEACE by oper: %s", source);
	        slog("OPER -PEACE %s (%s!%s@%s) %s", u->nick, u->nick, u->username, u->host, chan);
	}
    } else if (stricmp(cmd, "PEACE") == 0) {
	chan = strtok(NULL, " ");
	if (!chan) {
		notice(s_ServicesX, source, "Syntax: UNPEACE \2Channel\2");
	} else if (!is_services_oper(source)) {
       		notice(s_ServicesX, source, PMD);
	} else {
#ifdef UNREAL
	        send_cmd (s_ServicesX, "%s %s -Q", istoken?TOK_MODE:MSG_MODE, chan);
#endif
#ifdef RAGEIRCD
	        send_cmd (s_ServicesX, "%s %s -j", istoken?TOK_MODE:MSG_MODE, chan);
#endif
		notice(s_ServicesX, chan, "Request -PEACE by oper: %s", source);
	        slog("OPER -PEACE %s (%s!%s@%s) %s", u->nick, u->nick, u->username, u->host, chan);
	}
#ifdef DEFHALFOP
    } else if (stricmp(cmd, "HALFOP") == 0) {
	chan = strtok(NULL, " ");
	if (!chan) {
		notice(s_ServicesX, source, "Syntax: HALFOP \2Channel\2");
	} else if (!is_services_helpop(source)) {
       		notice(s_ServicesX, source, PMD);
	} else {
                if (!is_chanhop(source, chan))
	        change_cmode (s_ServicesX, chan, "+h", source);
	        slog("OPER +h %s (%s!%s@%s) %s", u->nick, u->nick, u->username, u->host, chan);
	}
#endif
    } else {
        notice(s_ServicesX, source,
                "Unrecognized command \2%s\2.", cmd);
    }
}

/***************************************************************/
void servicesW(const char *source, char *buf)
{
    char *cmd;
    char *s;

    cmd = strtok(buf, " ");

    if (!cmd) {
	return;
    } else if (stricmp(cmd, "HELP") == 0) {
	if (is_services_root(source)) {
		notice(s_ServicesW, source, "- JOIN       Force W join any channel");
		notice(s_ServicesW, source, "- PART       Force W part any channel");
		notice(s_ServicesW, source, "- SPY        Check all action taken by current host.");
	}
    } else if (stricmp(cmd, "\1PING") == 0) {
        if (!(s = strtok(NULL, "")))
            s = "\1";
        notice(s_OperServ, source, "\1PING %s", s);

    } else if (stricmp(cmd, "JOIN") == 0) {
	char *chan = strtok(NULL, " ");
	if (!is_services_root(source)) {
       		notice(s_ServicesW, source, PMD);
	       	return;
	}
	if (!chan) {
		notice(s_ServicesW, source, "Syntax: JOIN \2Channel\2");
	} else {
	        send_cmd (s_ServicesW, "%s %s",istoken?TOK_JOIN:MSG_JOIN, chan);
        	send_cmd (s_ServicesW, "%s %s +a %s", istoken?TOK_MODE:MSG_MODE,chan, s_ServicesW);
	}

    } else if (stricmp(cmd, "PART") == 0) {
	char *chan = strtok(NULL, " ");
	if (!is_services_root(source)) {
       		notice(s_ServicesW, source, PMD);
	       	return;
	}
	if (!chan) {
		notice(s_ServicesW, source, "Syntax: PART \2Channel\2");
	} else {
	        send_cmd (s_ServicesW, "%s %s", istoken?TOK_PART:MSG_PART, chan);
	}

    } else if (stricmp(cmd, "SPY") == 0) {
	if (!is_services_root(source)) {
       		notice(s_ServicesW, source, PMD);
	}
	spyhost = strtok(NULL, " ");
	if (!spyhost) {
		notice(s_ServicesW, source, "Syntax: SPYHOST \2<Host>\2");
	} else {
		notice(s_ServicesX, source, "All action taken by host: \2%s\2 will show in #debug.", spyhost);
	}

   }
}
#endif /* Non Super */
/***********************************************************************/
/*
 * Code from Sirv
 */
void do_selfdel(const char *source)
{
    ChannelInfo *ci;
    char *chan = strtok(NULL, " ");
    User *u = finduser(source);
    int i, x=0, check=0, z=0;
    ChanAccess *access1;

    if (!chan) {
        notice(s_NickServ, source, "Syntax: \2SELFDEL\2 <#channel>");
        notice(s_NickServ, source,
              "\2/MSG %s HELP SELFDEL\2 fo more information.",
	      s_NickServ);
	return;
    }

    if (readonly) {
	notice(s_ChanServ, source,
	    "Warning: Services is in read-only mode.  Changes will not be saved.");
    }

    if (!(ci = cs_findchan(chan))) {
        notice(s_NickServ, source,"Channel %s not registered", chan);
	    return;
    }

	   if (0 < (x = get_access(u, ci))) {
	       if (x==15) {
	          notice(s_ChanServ, source,
	             "The REMOVE command may not be used by the founder");
	          return;
	       }
	       check = ci->accesscount;
	       for (access1 = ci->access, i = 0; i < check; ++access1,++i) {
	           if (stricmp(access1->name, source) == 0) {
		      csremove += 1;
	              free(access1->name);
        	      access1->in_use = 0;
	              access1->name = NULL;
	              --ci->accesscount;
	              if (i < ci->accesscount)
	                  bcopy(access1+1, access1, sizeof(ChanAccess)
	                                        * (ci->accesscount - i));

		           z=1;
		           break;
		      }
	       }
	   }
	   if (z)
	   notice(s_ChanServ, source,
	      "Your nick (%s) has been removed from the %s %s%s%s%s list",
	         source, chan,
	         x==3 ? "AVOICE" : "", x==5 ? "AOP" : "",
	         x==10 ? "SOP" : "", x==13 ? "CFOUNDER" : "");
	   else
	   notice(s_ChanServ, source,
	       "Your nick (%s) was not found on any %s access list",
	        source, chan);

	    show_u_next_db(u, s_ChanServ);
}
/**********************************************************************/
void SpamCheck(const char *source, char *buf)
{
    char *cmd, *s, *chan;
    char orig[BUFSIZE];
    strscpy (orig, buf, sizeof (orig));
    cmd = strtok(buf, " ");

    if (cmd) {
	    if (stricmp (cmd, "\1PING") == 0)
	    {
	        if (!(s = strtok (NULL, "")))
	            s = "\1";
	        notice(s_OperServ, source, "\1PING %s", s);

	    } else if (stricmp (cmd, "\1VERSION\1") == 0) {
	        if (!(s = strtok (NULL, "")))
        	    s = "\1";
	        notice(s_SpamChecker, source, "\1VERSION ircII-2.8.2-EPIC4pre1.001");

	    } else if (stricmp(cmd, "JOIN") == 0) {

		if (!is_services_root(source)) {
		       	return;
		}
		chan = strtok(NULL, " ");
		if (!chan) {
			notice(s_SpamChecker, source, "Syntax: JOIN \2Channel\2");
		} else {
		        send_cmd (s_SpamChecker, "%s %s", istoken?TOK_JOIN:MSG_JOIN, chan);
		}

	    } else if (stricmp(cmd, "PART") == 0) {

		if (!is_services_root(source)) {
		       	return;
		}
		chan = strtok(NULL, " ");
		if (!chan) {
			notice(s_SpamChecker, source, "Syntax: PART  \2Channel\2");
		} else {
		        send_cmd (s_SpamChecker, "%s %s", istoken?TOK_PART:MSG_PART, chan);
		}

	    } else
	       if (!is_services_helpop(source))
		       wallops(s_OperServ, "Possible spam from \2%s\2: %s", source, orig);
	}
}
/*********************************************************************/
int check_password(const char *plaintext, const char *password1)
{
    if (strcmp(plaintext, password1) == 0)
	return 1;
    else
        return 0;
}
/*******************************************************************/
void botjoin(char *chan)
{
	ChannelInfo *ci = cs_findchan(chan);
	botjoin2(ci);
}
/*******************************************************************/
void botpart(char *chan)
{
	ChannelInfo *ci;
	Channel *c;
	ci = cs_findchan(chan);
	if (ci && ci->bot && !(ci->botflag & CBI_BOTSTAY)) {
	        send_cmd(ci->bot, "%s %s", istoken?TOK_PART:MSG_PART, ci->name);	
		c= findchan(chan);
		if (c) c->havebot = 0;
	}
}

void botpart3(char *chan)
{
	ChannelInfo *ci;
	Channel *c = findchan(chan);
	ci = cs_findchan(chan);
	if (ci && ci->bot)
	        send_cmd(ci->bot, "%s %s", istoken?TOK_PART:MSG_PART, ci->name);	
	if (c)
		c->havebot = 0;
}
void botpart4(char *chan)
{
	ChannelInfo *ci;
	Channel *c = findchan(chan);
	ci = cs_findchan(chan);
	if (ci && ci->bot)
	        send_cmd(ci->bot, "%s %s", istoken?TOK_PART:MSG_PART, ci->name);	
	if (c) {
		c->havebot = 0;
		change_cmode (s_ChanServ, chan, "-r", "");
	}
}
/*******************************************************************/
void botserv(const char *source, const char *thebot, char *buf)
{
    char *cmd, *s, *chan, *bmsg;
    char orig[BUFSIZE];
    NickInfo *ni;
    BotInfo *bi;
    strscpy (orig, buf, sizeof (orig));
    cmd = strtok(buf, " ");

    if (cmd) {
            if (stricmp (cmd, "\1PING") == 0) {
                if (!(s = strtok (NULL, "")))
                    s = "\1";
                notice(thebot, source, "\1PING %s", s);

            } else if (stricmp (cmd, "\1VERSION\1") == 0) {
                if (!(s = strtok (NULL, "")))
                    s = "\1";
             notice(thebot, source, "%sVERSION Auspice IRC Services %s", s, s);
	
           } else if (!is_services_admin(source)) {
        	chan = strtok(NULL, "");
		bi = findbot(thebot);
		if (bi) {
		    	ni = findnick(bi->master);

		    	if (ni && finduser(bi->master))
		            	if ((ni->flags & NI_IDENTIFIED) && (ni->flags & NI_BOTMSG))
				     	send_cmd(thebot, "%s %s :(%s) %s %s", istoken?TOK_PRIVATE:MSG_PRIVATE, ni->nick, source, cmd, (chan)?chan:"");
		}
	    	return;
          
            } else if (stricmp(cmd, "JOIN") == 0) {
                chan = strtok(NULL, " ");
                if (!chan) {
                        notice(thebot, source, "Syntax: JOIN \2Channel\2");
                } else {
			if (is_botowner(source, thebot) || is_services_root(source))
	                        send_cmd (thebot, "%s %s", istoken?TOK_JOIN:MSG_JOIN, chan);
			else
	                        notice(thebot, source, "Sorry you are not my master.");		
                }
            } else if (stricmp(cmd, "HELP") == 0) {
		if (is_botowner(source, thebot) || is_services_root(source)) {
		notice(thebot, source, "- JOIN      Join channel");	
		notice(thebot, source, "- PART      Part channel");	
		notice(thebot, source, "- SAY       Say in channel");	
		notice(thebot, source, "- ACT       Act in channel");	
		notice(thebot, source, "- QUIT      Quit the Bot");	
	        notice(thebot, source, "\2ENF OF HELP\2");
		} else
	                notice(thebot, source, "Sorry you are not my master.");		
 

            } else if (stricmp(cmd, "SAY") == 0) {
                chan = strtok(NULL, " ");
		bmsg = strtok(NULL, "");
                if (!chan || !bmsg) {
                        notice(thebot, source, "Syntax: SAY \2Channel\2 \2Message\2");
                } else {
			if (is_botowner(source, thebot) || is_services_root(source))
			     if (finduser(chan) || findchan(chan))
				send_cmd (thebot, "%s %s :%s", istoken?TOK_PRIVATE:MSG_PRIVATE, chan, bmsg);
			     else
	                        notice(thebot, source, "Can not send to non exist channel or any services bots.");
			else
	                        notice(thebot, source, "Sorry you are not my master.");	
                }

            } else if (stricmp(cmd, "ACT") == 0) {
                chan = strtok(NULL, " ");
		bmsg = strtok(NULL, "");
                if (!chan || !bmsg) {
                        notice(thebot, source, "Syntax: ACT \2Channel\2 \2Message\2");
                } else {
			if (is_botowner(source, thebot) || is_services_root(source))
			     if (finduser(chan) || findchan(chan))
				send_cmd (thebot, "%s %s :ACTION %s",istoken?TOK_PRIVATE:MSG_PRIVATE, chan, bmsg);
			     else
	                        notice(thebot, source, "Can not send to non exist channel or any services bots.");					

			else
	                        notice(thebot, source, "Sorry you are not my master.");		
                }

            } else if (stricmp(cmd, "PART") == 0) {
	        ChannelInfo *ci;
                chan = strtok(NULL, " ");	
		if (!chan)  {
                       	notice(thebot, source, "Syntax: PART \2Channel\2");
			return;
		}

		ci = cs_findchan(chan);
		
       	        if (!chan || !ci) {
                       	notice(thebot, source, "Syntax: PART \2Channel\2");
		} else if (ci->bot && (stricmp(ci->bot,thebot)==0)) {
       	                notice(thebot, source, "Sorry, this bot have been assigned for this channel already.");
                } else {
			if (is_botowner(source, thebot) || is_services_root(source))
        	                send_cmd (thebot, "%s %s", istoken?TOK_PART:MSG_PART, chan);
			else
                	        notice(thebot, source, "Sorry you are not my master.");
                }
            }
	 }
}
/*****************************************************************/
/***********************************************************************/
int is_servbot(const char *nick)
{
      if (stricmp(nick, s_ChanServ) == 0)
		return 1;

      if ((stricmp(nick, s_OperServ) == 0)
	   || (stricmp(nick, s_RootServ) == 0)
	   || (stricmp(nick, s_NickServ) == 0)
	   || (stricmp(nick, s_MemoServ) == 0)
	   || (stricmp(nick, s_HelpServ) == 0)
	   || (stricmp(nick, s_Agent) == 0)
#ifndef NONSUPER
	   || (stricmp(nick, s_ServicesX) == 0)
	   || (stricmp(nick, s_MassServ) == 0)
	   || (stricmp(nick, s_ServicesW) == 0)
	   || (stricmp(nick, "ChanOP") == 0)
#endif
#ifdef DEFHOSTSERV
	   || (stricmp(nick, s_HostServ) == 0)
#endif
	   || (stricmp(nick, s_BotServ) == 0)
	   || (stricmp(nick, s_SpamChecker) == 0)
	   || (check_ifbot(nick) == 1))
		return 1;
	return 0;
		
} 
/***********************************************************************/

/************************************************************************/
static void doonu(const char *source, ChannelInfo *ci, char *abot, char *areason) {

	if (!is_oper(source)) {
	if (
#ifdef DEFHALFOP
	is_chanhop(source, ci->name) || 
#endif
	is_chanop(source, ci->name)) {
		notice(abot, source,areason);
		dropmode(source, ci);
	} else {
		botkick(source, ci, areason);
	}
	}
}
/************************************************************************/
void bmsgchan(const char *source, char *chan, char *buf, User *u)
{
	int cha;
	ChannelInfo *ci;
	char *cmd;
	Channel *c = findchan(chan);
    char *nick = sstrdup(source);
	int i = 0;
    char *s = buf;
	char morebuf[BUFSIZE];
    UserData *ud;

	ci = cs_findchan(chan);

    if (ci && (ci->flags & CI_CLOSED))
		goto botend;

	if ((aspychan == 1) && !stricmp(chan,asource))
	     send_cmd(s_OperServ, "%s %s :<%s/%s> %s", istoken?TOK_PRIVATE:MSG_PRIVATE, adest, source, chan, buf);

	if (!ci || !u || !c) goto botend;

	*morebuf = 0;
	strscpy(morebuf, buf, sizeof(BUFSIZE));
	cmd = strtok(morebuf, " ");

	if (ci && !(ci->bot)) {

		goto botend;

	} else {

		if (!((ci->botflag & CBI_PROTOP) && (is_voiced(source,chan) || is_chanop(source, chan) 
#ifdef DEFHALFOP
		|| is_chanhop(source, chan) 
#endif
#ifdef DEFPROTECT
		|| is_prots(source, (const char *)chan)
#endif
		))) {
/************************************* REPEAT ************************/
			if (ci->botflag & CBI_KICKREPEAT) {

                        ud = get_user_data(c, u);
                        if (!ud) return;

                        if (ud->lastline && stricmp(ud->lastline, buf)) {
                                free(ud->lastline);
                                ud->lastline = sstrdup(buf);
                                ud->times = 0;
                        } else {
                                if (!ud->lastline) ud->lastline = sstrdup(buf);
                                ud->times++;
                        }
                        if (ud->times >= 4)
                        {
					doonu(source,ci, ci->bot, "Don't repeat");
					goto botend;
                        }
			}
		/********** END REPEAT **************/
			if (ci->botflag & CBI_KICKFLOOD) {
				time_t now = CTime;
                        ud = get_user_data(c, u);

                        if (!ud) return;

                        if (now - ud->last_start > ci->floodsecs)
                        {
                                ud->last_start = CTime;
                                ud->lines = 0;
                        }

                        ud->lines++;
			if (ud->lines > ci->floodlines)
				ud->lines = 0;

                        if (ud->lines >= ci->floodlines)
                        {
					doonu(source,ci, ci->bot, "Don't flood");
					goto botend;
                        }
			}
		/***************** CAP *******************/
			if ((ci->botflag & CBI_KICKCAP) && (cha = strlen(buf) > 10)) {
				do {
		       		if (isallowed(*s))
						if (isupper(*s)) i++;
				} while (*s++);
	
				cha = strlen(buf);

				if (i >= ci->capsmin && i*100/cha>= ci->capspercent)
				{
					doonu(source,ci, ci->bot, "Please turn caps lock OFF!");
					goto botend;
				}
			}
		/********** END CAP **************/
                /********** BOLDS ****************/
			if ((ci->botflag & CBI_KICKBOLDS) && strchr(buf, 2)) {
				doonu(source,ci, ci->bot, "Don't use bolds on this channel!");
				goto botend;
			}
                /***************** END BOLD **************/
		/***************** COLORS ****************/
			if ((ci->botflag & CBI_KICKCOLORS) && strchr(buf, 3)) {
				doonu(source,ci, ci->bot, "Don't use colors on this channel!");
				goto botend;
			}
                /******************** END COLOR ******************/           
		/******************** REVERSES *******************/
			if ((ci->botflag & CBI_KICKREVERSES) && strchr(buf, 22)) {
				doonu(source,ci, ci->bot, "Don't use reverses on this channel!");
				goto botend;
			}
		/******************** END REVERSES *******************/
		/******************** UNDERLINES *********************/
			if ((ci->botflag & CBI_KICKUNDERLINES) && strchr(buf, 31)) {
				doonu(source,ci, ci->bot, "Don't use underlines on this channel!");
				goto botend;
			}
		/******************* END UNDERLINES ******************/
			if ((ci->botflag & CBI_KICKBADWORDS) && is_chanbadwords(ci, buf)) {
				doonu(source,ci, ci->bot, "Don't use bad word on this channel!!");
				goto botend;
			}
		}	
		/******************** BOT COMMAND ****************/
		if (ci->botflag & CBI_BOTCOM) {
			abotcom(source, ci, buf);
		}
	}
botend:
	free(nick);
}
/************************************************************************/
void botkick(const char *nick, ChannelInfo *ci, char *buf)
{
	if (is_on_chan(nick, ci->name) && ci->bot) {
	        User *u2 = finduser(nick);
		if (u2) {
			char mask[BUFSIZE];
			bcreate_mask(u2, 1, mask, sizeof(mask));
			change_cmode(ci->bot, ci->name, "+b", mask);
			kick_user(ci->bot, ci->name, nick, buf);
		}
	}
}
/************************************************************************/
void dropmode(const char *nick, ChannelInfo *ci)
{
	if (is_on_chan(nick, ci->name)) {
		if (is_chanop(nick, ci->name))
		change_cmode (ci->bot, ci->name, "-o", nick);
#ifdef DEFPROTECT
		if (is_prots(nick, ci->name))
		change_cmode (ci->bot, ci->name, "-a", nick);
#endif
#ifdef DEFHALFOP
		if (is_chanhop(nick, ci->name))
		change_cmode (ci->bot, ci->name, "-h", nick);
#endif
		if (is_voiced(nick, ci->name))
		change_cmode (ci->bot, ci->name, "-v", nick);
	}		
}
/************************************************************************/
static void abotcom(const char *source, ChannelInfo *ci, char *buf)
{
   char *chan = ci->name;
   User *u = finduser (source);
   char *cmd, *param;
   cmd = strtok(buf, " ");
		
   if(u && cmd) {
        /******************** OP Command ********************/

	if ((stricmp(cmd,"!op")==0) || (stricmp(cmd,"!up")==0) || (stricmp(cmd,"`up")==0)) {
	   param = strtok(NULL, " ");

	   if (!is_chanop(source, chan) && (get_access(u, ci) < 5)) {
		notice(ci->bot, source,"You don't have access.");
		return;
	   } 

	  if (!param) {
		if (!is_on_chan(source, chan))
			notice(ci->bot, source,"You are not in channel %s.", chan);
		else if (is_chanop(source, chan))
			notice(ci->bot, source,"You already have op in %s.", chan);
		else
		        change_cmode (ci->bot, chan, "+o", source);

	  } else {
		User *u2 = finduser(param);
		if (!u2 || !is_on_chan(param, chan))
			notice(ci->bot, source,"User %s is not in %s.",param,chan);
		else if ((ci->flags & CI_OPGUARD) && (get_access(u2, ci) < 5))
			notice(ci->bot, source,"Channel %s set opguard on please respect founder.",chan);
		else if (is_chanop(param, chan))
			notice(ci->bot, source,"User %s already have op in %s.",param,chan);
		else
		        change_cmode (ci->bot, chan, "+o", param);
	  }

	}

       /********************* END OP *************************/
        else if (stricmp(cmd,"!mass")==0) {
		Channel *c;
		param = strtok(NULL, " ");

		if (!param) {
		        notice (ci->bot, source, ERR_MORE_INFO, s_ChanServ, "MASS");
#ifdef DEFHALFOP
		        notice (ci->bot, source,"Syntax: \2MASS\2 \2<op|deop|halfop|dehalfop|voice|devoice|kick|msg|notice>\2");
#else
		        notice (ci->bot, source,"Syntax: \2MASS\2 \2<op|deop|voice|devoice|kick|msg|notice>\2");
#endif
			return;
		}

		if (!(c = findchan (chan)))
		        notice (ci->bot, source,"Channel %s is not in use", chan);
		else if(!is_on_chan(source, chan))
			notice(ci->bot, source,"You are not in channel %s.", chan);
		else if (get_access(u, ci) < 10)
		        notice(ci->bot, source,"You don't have access to use mass command.");
		else if (ci->flags & CI_FREEZECHAN)
		        notice (ci->bot, source,"Sorry the channel is frozen");
		else if (stricmp (param, "deop") == 0) {
		        struct c_userlist *cu, *next;
		        for (cu = c->users; cu; cu = next) {
		            next = cu->next;
	        	    if (is_chanop(cu->user->nick, chan))
			            change_cmode (ci->bot, chan, "-o", cu->user->nick);
		        }
			send_cmd(ci->bot, "%s %s :%s has used the \2MassDEOP\2 command on channel %s", istoken?TOK_NOTICE:MSG_NOTICE, chan,source,chan);
			notice (ci->bot, source, "All the OPs (+o) in %s has been removed",chan);
		} else if (stricmp (param, "devoice") == 0) {
		        struct c_userlist *cu, *next;
		        for (cu = c->users; cu; cu = next) {
		            next = cu->next;
		            if (is_voiced(cu->user->nick, chan))
		            	change_cmode (ci->bot, chan, "-v", cu->user->nick);
		        }
			send_cmd(ci->bot, "%s %s :%s has used the \2MassDEVOICE\2 command on the channel %s",istoken?TOK_NOTICE:MSG_NOTICE, chan,source,chan);
			notice (ci->bot, source, "All the voices (+v) in %s has been removed",chan);

		} 
		else if (stricmp (param, "kick") == 0) {
		        struct c_userlist *cu, *next_cu;
		        char abuf[BUFSIZE];
			char *reason = strtok (NULL, "");
			snprintf (abuf, sizeof (abuf), "(ChanServ) MassKick by %s", source);
			send_cmd(ci->bot, "%s %s :%s has used the \2MassKICK\2 command on the channel %s",istoken?TOK_NOTICE:MSG_NOTICE,chan,source,chan);
			for (cu = c->users; cu; cu = next_cu)  {
		            next_cu = cu->next;
		            if (stricmp(cu->user->nick, source) !=0) {
		             if(!reason)
				kick_user(ci->bot, chan, cu->user->nick, abuf);
		             else
				kick_user(ci->bot, chan, cu->user->nick, reason);
	               } /* FOR */
	        }
		notice (ci->bot, source, "All the users in %s have been removed",chan);
	    } else if (stricmp (param, "op") == 0) {
		struct c_userlist *cu, *next;
	        for (cu = c->users; cu; cu = next) {
	            next = cu->next;
        	    if (!is_chanop(cu->user->nick, chan))
                	change_cmode (ci->bot, chan, "+o", cu->user->nick);
		}
		send_cmd(ci->bot, "%s %s :%s has used the \2MassOP\2 command on the channel %s",istoken?TOK_NOTICE:MSG_NOTICE,chan,source,chan);
		notice (ci->bot, source, "All the users in %s has got the Channel Op (+o) status.",chan);
#ifdef DEFHALFOP
	    }  else if (stricmp (param, "hop") == 0) {
		struct c_userlist *cu, *next;
	        for (cu = c->users; cu; cu = next) {
		    next = cu->next;
	            if (!is_chanhop(cu->user->nick, chan))
	                change_cmode (ci->bot, chan, "+h", cu->user->nick);
        	}
		send_cmd(ci->bot, "%s %s :%s has used the \2MassHOP\2 command on the channel %s",istoken?TOK_NOTICE:MSG_NOTICE,chan,source,chan);
		notice (ci->bot, source, "All the users in %s has got the Channel HOP (+h) status.",chan);
	} else if (stricmp (param, "dehop") == 0) {
	        struct c_userlist *cu, *next;
        	for (cu = c->users; cu; cu = next) {
	            next = cu->next;
        	    if (!is_chanhop(cu->user->nick, chan))
	               change_cmode (ci->bot, chan, "-h", cu->user->nick);
        	}
		send_cmd(ci->bot, "%s %s :%s has used the \2MassDEOP\2 command on channel %s",istoken?TOK_NOTICE:MSG_NOTICE,chan,source,chan);
		notice (ci->bot, source, "All the OPs (+h) in %s has been removed",chan);
#endif
	} else if (stricmp (param, "voice") == 0) {
	        struct c_userlist *cu, *next;
	        for (cu = c->users; cu; cu = next) {
			next = cu->next;
	            if (!is_voiced(cu->user->nick, chan))
                	change_cmode (ci->bot, chan, "+v", cu->user->nick);
	        }
		send_cmd(ci->bot, "%s %s :%s has used the \2MassVOICE\2 command on the channel %s",istoken?TOK_NOTICE:MSG_NOTICE,chan,source,chan);
		notice (ci->bot, source, "All the users in %s has got the Channel Voice (+v) status.",chan);
	} else if (stricmp (param, "msg") == 0) {
	        struct c_userlist *cu, *next;
		char *extra = strtok (NULL, "");
        	if (!extra) {
	            notice (ci->bot, source,
        	        "Syntax: \2MASS \37%s\37 \37MSG\37 message\2",chan);
	            notice (ci->bot, source, ERR_MORE_INFO, s_ChanServ, "MASS");
	        } else {
	            for (cu = c->users; cu; cu = next) {
	                next = cu->next;
			send_cmd(ci->bot, "%s %s :(MassMSG from %s): %s", istoken?TOK_PRIVATE:MSG_PRIVATE, cu->user->nick,source ,extra);
                    }
		notice(ci->bot, source, "All the users in %s has got your message.",chan);
	        }
	} else if (stricmp (param, "notice") == 0) {
	        struct c_userlist *cu, *next;
		char *extra = strtok (NULL, "");
        	if (!extra) {
	            notice (ci->bot, source,
        	        "Syntax: \2MASS \37%s\37 \37NOTICE\37 message\2",chan);
	            notice (ci->bot, source, ERR_MORE_INFO, s_ChanServ, "MASS");
	        } else {
	            for (cu = c->users; cu; cu = next) {
	                next = cu->next;
			send_cmd(ci->bot, "%s %s :(MassNOTICE from %s): %s",istoken?TOK_NOTICE:MSG_NOTICE,cu->user->nick,source ,extra);
                    }
		notice(ci->bot, source, "All the users in %s has got your notice.",chan);
	        }
       } else {
  	      notice (ci->bot, source,
                "Syntax: \2MASS \37what\37\2");
	      notice (ci->bot, source, ERR_MORE_INFO, s_ChanServ, "MASS");
	}         
   }
       /********************** DEOP *************************/
	else if ((stricmp(cmd,"!deop")==0) || (stricmp(cmd,"!down")==0) || (stricmp(cmd,"`deop")==0)) {
	   param = strtok(NULL, " ");
	   if (!is_chanop(source, chan) && (get_access(u, ci) < 5)) {
		notice(ci->bot, source,"You don't have access.");
		return;
	   }

	  if (!param) {
		if (!is_on_chan(source, chan))
			notice(ci->bot, source,"You are not in channel %s.", chan);
		else if (!is_chanop(source, chan))
			notice(ci->bot, source,"You already deop in %s.", chan);
		else
		        change_cmode (ci->bot, chan, "-o", source);

	  } else {
		if (!is_on_chan(param, chan))
			notice(ci->bot, source,"User %s is not in %s.",param,chan);
		else if (!is_chanop(param, chan))
			notice(ci->bot, source,"User %s already deop in %s.",param,chan);
		else
		        change_cmode (ci->bot, chan, "-o", param);
	  }
       }
         /*************************** End Deop *********************/
         /*************************** molest ***********************/
	else if (stricmp(cmd,"!molest")==0) {

	if (!is_on_chan(source, chan))
		notice(ci->bot, source,"You are not in channel %s.", chan);
	else
		dropmode(source, ci);

       }
         /*************************** End MoLest *******************/
         /*************************** seen ***********************/
/*
	else if (stricmp(cmd,"!seen")==0) {
	   NickInfo *ni;
	   param = strtok(NULL, " ");
	   if (param) {
		ni = findnick(param);
		if (ni)

	   }
       }
*/
         /*************************** Voice ************************/
	else if (stricmp(cmd,"!voice")==0) {
	   param = strtok(NULL, " ");

	   if (!is_chanop(source, chan) && (get_access(u, ci) < 4)) {
		notice(ci->bot, source,"You don't have access.");
		return;
	   }

	  if (!param) {
		if (!is_on_chan(source, chan))
			notice(ci->bot, source,"You are not in channel %s.", chan);
		else if (is_voiced(source, chan))
			notice(ci->bot, source,"You already have voice in %s.", chan);
		else
		        change_cmode (ci->bot, chan, "+v", source);

	  } else {
		if (!is_on_chan(param, chan))
			notice(ci->bot, source,"User %s is not in %s.",param,chan);
		else if (is_voiced(param, chan))
			notice(ci->bot, source,"User %s already have voice in %s.",param,chan);
		else
		        change_cmode (ci->bot, chan, "+v", param);
	  }
	}
         /*************************** End Voice ********************/
         /*************************** De Voice *********************/
	else if (stricmp(cmd,"!devoice")==0) {
	   param = strtok(NULL, " ");

	   if (!is_chanop(source, chan) && (get_access(u, ci) < 4)) {
		notice(ci->bot, source,"You don't have access.");
		return;
	   }

	  if (!param) {
		if (!is_on_chan(source, chan))
			notice(ci->bot, source,"You are not in channel %s.", chan);
		else if (!is_voiced(source, chan))
			notice(ci->bot, source,"You already devoice in %s.", chan);
		else
		        change_cmode (ci->bot, chan, "-v", source);

	  } else {
		if (!is_on_chan(param, chan))
			notice(ci->bot, source,"User %s is not in %s.",param,chan);
		else if (!is_voiced(param, chan))
			notice(ci->bot, source,"User %s already devoice in %s.",param,chan);
		else
		        change_cmode (ci->bot, chan, "-v", param);
	  }
	}
         /*************************** End DeVoice ******************/

         /*************************** Invite *********************/
	else if (stricmp(cmd,"!invite")==0) {
	   param = strtok(NULL, " ");

	   if (!is_chanop(source, chan) && get_access(u, ci) < 4) {
		notice(ci->bot, source,"You don't have access.");
		return;
	   }

	  if (!param) {
		notice(ci->bot, source,"Syntax: !INVITE <nick>");
	  } else {
		send_cmd(ci->bot, "%s %s %s", istoken?TOK_INVITE:MSG_INVITE, param, chan);
		notice(ci->bot, source,"Invited %s join %s", param, chan);
	  }
	}
         /*************************** End INVITE ******************/

         /*************************** Halfop ***********************/
#ifdef DEFHALFOP
	else if (!stricmp(cmd,"!halfop") || !stricmp(cmd,"!hop")) {
	   param = strtok(NULL, " ");

	   if (!is_chanop(source, chan) && (get_access(u, ci) < 5)) {
		notice(ci->bot, source,"You don't have access.");
		return;
	   }

	  if (!param) {
		if (!is_on_chan(source, chan))
			notice(ci->bot, source,"You are not in channel %s.", chan);
		else if (is_chanhop(source, chan))
			notice(ci->bot, source,"You already have halfop in %s.", chan);
		else
		        change_cmode (ci->bot, chan, "+h", source);

	  } else {
		User *u2 = finduser(param);
		if (!is_on_chan(param, chan))
			notice(ci->bot, source,"User %s is not in %s.",param,chan);
		else if ((ci->flags & CI_OPGUARD) && (get_access(u2, ci) < 4))
			notice(ci->bot, source,"Channel %s set opguard on please respect founder.",chan);
		else if (is_chanhop(param, chan))
			notice(ci->bot, source,"User %s already have halfop in %s.",param,chan);
		else
		        change_cmode (ci->bot, chan, "+h", param);
	  }
	}
         /*************************** End Halfop *******************/
	else if (!stricmp(cmd,"!dehalfop") || !stricmp(cmd,"!dehop")) {
	   param = strtok(NULL, " ");

	   if (!is_chanop(source, chan) && (get_access(u, ci) < 5)) {
		notice(ci->bot, source,"You don't have access.");
		return;
	   }

	  if (!param) {
		if (!is_on_chan(source, chan))
			notice(ci->bot, source,"You are not in channel %s.", chan);
		else if (!is_chanhop(source, chan))
			notice(ci->bot, source,"You already dehalfop in %s.", chan);
		else
		        change_cmode (ci->bot, chan, "-h", source);

	  } else {
		if (!is_on_chan(param, chan))
			notice(ci->bot, source,"User %s is not in %s.",param,chan);
		else if (!is_chanhop(param, chan))
			notice(ci->bot, source,"User %s already dehalfop in %s.",param,chan);
		else
		        change_cmode (ci->bot, chan, "-h", param);
	  }

	}
#endif
         /*************************** DeHalfop *********************/
         /*************************** Kick *************************/
	else if (stricmp(cmd,"!kick")==0) {
	   char *reason;
	   param = strtok(NULL, " ");
	   reason = strtok(NULL, " ");

	   if (!is_chanop(source, chan) && (get_access(u, ci) < 4)) {
		notice(ci->bot, source,"You don't have access.");
		return;
	   }

	  if (!param) {
		notice(ci->bot, source,"Syntax: !KICK <nick> [<reason>]");
	  } else {
		if (!is_on_chan(param, chan))
			notice(ci->bot, source,"User %s is not in %s.",param,chan);
		else if (
#ifdef DEFHALFOP
is_chanhop(param, chan) || 
#endif
is_chanop(param, chan) 
#ifdef DEFPROTECT
|| is_prots(param, chan)
#endif
)
			notice(ci->bot, source,"I don't kick op or protected user.");
		else {
		       char *av[3];
	               av[0] = sstrdup(chan);
	               av[1] = sstrdup(param);
	               if (!reason)
						av[2] = sstrdup(buf);
	               else
	                  av[2] = sstrdup(reason);
			send_cmd(ci->bot, "%s %s %s :%s",istoken?TOK_KICK:MSG_KICK, av[0], av[1], av[2]);
	               do_kick(ci->bot, 3, av);
	               free(av[2]);
	               free(av[1]);
	               free(av[0]);
                }		
	  }
	}
         /************************** End Kick **********************/
         /************************** Ban ***************************/
	else if (stricmp(cmd,"!ban")==0) {
	   char *btype;
	   param = strtok(NULL, " ");
	   btype = strtok(NULL, " ");

	   if (!is_chanop(source, chan) && (get_access(u, ci) < 4)) {
		notice(ci->bot, source,"You don't have access.");
		return;
	   }

	  if (!param) {
		notice(ci->bot, source,"Syntax: !BAN <nick> ![<type>]");
	  } else {
		if (!is_on_chan(param, chan))
			notice(ci->bot, source,"User %s is not in %s.",param,chan);
		else if (
#ifdef DEFHALFOP
is_chanhop(param, chan) || 
#endif
is_chanop(param, chan) 
#ifdef DEFPROTECT
|| is_prots(param, chan)
#endif
)
			notice(ci->bot, source,"I don't ban op or protected user.");
		else {
		       User *u2 = finduser(param);
			if (u2) {
			if (btype && *btype == '!') {
				char mask[BUFSIZE];
		               if (!stricmp(btype,"!1")) {
				bcreate_mask(u2,1,mask, sizeof(mask));
				change_cmode(ci->bot, chan, "+b", mask);
	        	       } else {
				bcreate_mask(u2,2,mask, sizeof(mask));
				change_cmode(ci->bot, chan, "+b", mask);
				}
		       } else {
				char mask[BUFSIZE];
				bcreate_mask(u2,1,mask, sizeof(mask));
				change_cmode(ci->bot, chan, "+b", mask);
			} }
                }		
	  }
	}
         /************************** End Ban ***********************/
         /************************** BKICK *************************/
	else if (stricmp(cmd,"!bkick")==0) {
	   char *reason, *btype;
	   param = strtok(NULL, " ");
	   btype = strtok(NULL, " ");
	   reason = strtok(NULL, "");

	   if (!is_chanop(source, chan) && (get_access(u, ci) < 4)) {
		notice(ci->bot, source,"You don't have access.");
		return;
	   }

	  if (!param) {
		notice(ci->bot, source,"Syntax: !BKICK <nick> ![<type>] [<reason>]");
	  } else {
		if (!is_on_chan(param, chan))
			notice(ci->bot, source,"User %s is not in %s.",param,chan);
		else if (
#ifdef DEFUNREAL
is_chanhop(param, chan) || 
#endif
is_chanop(param, chan)
#ifdef DEFPROTECT
|| is_prots(param, chan)
#endif
)
			notice(ci->bot, source,"I don't ban kick op or protected user.");
		else {
		       User *u2 = finduser(param);

		       if (btype && *btype == '!') {
			char mask[BUFSIZE];
		               if (!stricmp(btype,"!1")) {
				bcreate_mask(u2,1,mask, sizeof(mask));
				change_cmode(ci->bot, chan, "+b", mask);
		               } else {
				bcreate_mask(u2,2,mask, sizeof(mask));
				change_cmode(ci->bot, chan, "+b", mask);
				}
		       } else {
			char mask[BUFSIZE];
			bcreate_mask(u2,1,mask, sizeof(mask));
			change_cmode(ci->bot, chan, "+b", mask);
			}

/* Come check again */
	               if (!reason) {
		          if (btype && !(*btype == '!'))
				kick_user(ci->bot, chan, param, btype);
			  else
				kick_user(ci->bot, chan, param, "Ban kick requested");
		       } else {
		          if (!(*btype == '!')) {
				char *newreason = malloc(strlen(btype) + strlen(reason) + 1);
				sprintf(newreason, "%s %s", btype, reason);
				kick_user(ci->bot, chan, param, newreason);
				free(newreason);
			   } else
				kick_user(ci->bot, chan, param, reason);
		       }
                }		
	  }
	}
         /************************** Ban Kick **********************/
         /************************** Un Ban ************************/
	else if (stricmp(cmd,"!unban")==0) {
	   char *btype;
	   param = strtok(NULL, " ");
	   btype = strtok(NULL, " ");

	   if (!is_chanop(source, chan) && (get_access(u, ci) < 4)) {
		notice(ci->bot, source,"You don't have access.");
		return;
	   }

	  if (!param) {
		notice(ci->bot, source,"Syntax: !UNBAN <nick> or <mask>");
	  } else {
	       User *u2 = finduser(param);
	       Channel *c= findchan(chan);
	       int i;
	       if (c) {
	       if (u2) {
		       for (i = c->bancount-1; i > -1; --i) {
		       if (match_usermask(c->bans[i], u2))
				change_cmode(ci->bot, chan, "-b", c->bans[i]);
		        }
		} else {
		       for (i = c->bancount-1; i > -1; --i) {
		       if (match_wild_nocase(param, c->bans[i]))
				change_cmode(ci->bot, chan, "-b", c->bans[i]);
		       }
		} }
	  }
	}
         /************************** End Unban *********************/

         /************************** HELP **************************/
	else if (stricmp(cmd,"!help")==0) {

	   if (!is_chanop(source, chan) && (get_access(u, ci) < 4)) {
		notice(ci->bot, source,"You don't have access.");
		return;
	   }

		if (!is_on_chan(source, chan))
			notice(ci->bot, source,"You are not in channel %s.", chan);
		else {
		    const char *hcmd = strtok(NULL, "");
		    char hbuf[BUFSIZE];
		    snprintf(hbuf, sizeof(hbuf), "botcom%s", hcmd ? " " : "");
		    strscpy(hbuf+strlen(hbuf), hcmd ? hcmd : "", sizeof(hbuf)-strlen(hbuf));
		    helpserv(ci->bot, source, hbuf);
		}
       }
         /************************** End Help **********************/
     else if(stricmp(cmd,"!topic")==0) {
         Channel *c = findchan(chan);
         param = strtok(NULL, "");

        if (!ci || !c)
        return;

        if(get_access(u, ci) < 5) {
                notice(ci->bot, source,"You don't have access.");
                return;
        }

        if (ci->flags & CI_TOPICLOCK) {
        if(get_access(u, ci) < ci->topic_allow) {
                notice(ci->bot, source,"You don't have access.");
                return;
        } }
        if (ci->flags & CI_FREEZECHAN) {
            notice(ci->bot, source,"Error the channel is forzen");
     } else if (!param) {
        notice(ci->bot, source,"Syntax: \2!TOPIC\2 topic");
     } else if (strlen(param) > 300) {
        notice(ci->bot, source,"Topic too long make it shorter than 300 chars.");
     } else {
        send_cmd(ci->bot, "%s %s :%s (%s)",istoken?TOK_TOPIC:MSG_TOPIC, chan,param,source);
        if (c->topic)
                free(c->topic);
        c->topic = sstrdup(param);
        if (ci->last_topic)
                free(ci->last_topic);
        ci->last_topic = sstrdup(param);
        strscpy(c->topic_setter, ci->last_topic_setter, NICKMAX);
        c->topic_time = ci->last_topic_time;
    }
}
#ifdef GAMES
	else if (!is_tokn(39)) {
	// Disable Game option
	}
	/***********************************************************/
	else if (((stricmp(cmd,"`gnum")==0) || (stricmp(cmd,"!gnum")==0)) && (ci->botflag & CBI_GUESSNUM)){
	   unsigned int theguess;
	   param = strtok(NULL, " ");
	   if (!param) {
		notice(ci->bot, source,"Please Enter 4 digits number.");
		return;
	   } else if (strlen(param) > 4) {
		notice(ci->bot, source,"Please Enter 4 digits number.");
		return;
	   } else {
	        Channel *c = findchan(chan);
		theguess = atoi(param);
		if (theguess > c->ngames) {
			send_cmd (ci->bot, "%s %s :ACTION %s \2%d\2 is too big",istoken?TOK_PRIVATE:MSG_PRIVATE,chan,source, theguess);
		} else if (theguess == c->ngames) {
		     double x =  RAND_MAX + 1.0;
		     srand(time(NULL));
		     c->ngames = 1 + rand() * (999/x);
		     u->games++;
		     send_cmd (ci->bot, "PRIVMSG %s :ACTION \37%s\37 \2have Won\2, your score is %d",chan,source, u->games);
		     send_cmd (ci->bot, "NOTICE @%s :Answer is \2%d\2",chan,c->ngames);
	       	send_cmd (ci->bot, "NOTICE %s :New Game start, type \2!GNum <number>\2 to make guess!!",chan);

		} else {
		     send_cmd (ci->bot, "PRIVMSG %s :ACTION \37%s\37 \2%d\2 is too small",chan,source, theguess);
		}
	   } }
       /*****************************************************/
	else if (((stricmp(cmd,"`nextnum")==0) || (stricmp(cmd,"!nextnum")==0)) && (ci->botflag & CBI_GUESSNUM)){
	        Channel *c = findchan(chan);
	        double x =  RAND_MAX + 1.0;
		if (!is_chanop(source, chan)) {
			notice(ci->bot, source,"Only op can do.");
			return;
		}
 	        srand(time(NULL));
	        c->ngames = 1 + rand() * (999/x);
	        send_cmd (ci->bot, "NOTICE @%s :Answer is \2%d\2",chan,c->ngames);
	        send_cmd (ci->bot, "NOTICE %s :New Game start, type \2!GNum <number>\2 to make guess!!",chan);
	   }
       /*****************************************************/
#ifdef WGAME
	else if (((stricmp(cmd,"`gword")==0) || (stricmp(cmd,"!gword")==0)) && (ci->botflag & CBI_GUESSWRD)){
	   param = strtok(NULL, " ");
	   if (!param) {
		notice(ci->bot, source,"Syntax: !GWord <word or char>.");
		return;
	   } else if (strlen(param) > 50) {
		notice(ci->bot, source,"There are no any word longer than 50 chars.");
		return;
	   } else {
	        Channel *c = findchan(chan);
		if (!c->wgames || !c->wgame) {
		     send_cmd (ci->bot, "PRIVMSG %s :ACTION Game yet start, to start game one of the op must type \2!nextword\2.", chan);
		} else 	if (stricmp(param, wordgame[c->wgames]) == 0) {
		     char *wordsss;
		     unsigned short i;
		     double x =  RAND_MAX + 1.0;
		     srand(time(NULL));
		     c->wgames = 1 + rand() * (wgameline/x);
		     u->games++;
		     send_cmd (ci->bot, "PRIVMSG %s :ACTION %s \2have Won Guessing Word  Game\2, your Score now is %d",chan,source, u->games);
		     send_cmd (ci->bot, "NOTICE %s :New Word Guessing Game start, type \2!GWord <word or char>\2 to make guess!!",chan);
		     if (c->wgame)
				free(c->wgame);
		     c->wgame = sstrdup(wordgame[c->wgames]);		    
		     wordsss = c->wgame;
		     *wordsss++;
		     for (i=2; i< strlen(wordgame[c->wgames]); i++)
			*wordsss++ = '*';
		     send_cmd (ci->bot, "NOTICE %s :The new word is \2%s\2 Hints: \37%s\37.",chan,c->wgame,wordhelp[c->wgames]);
		     send_cmd (ci->bot, "NOTICE @%s :Answer is \2%s\2",chan,wordgame[c->wgames]);
		     *wordsss = 0;
		} else {
		     char *wordsss, *fakes;
		     unsigned short i;
		     wordsss = c->wgame;
		     fakes = wordgame[c->wgames];
		     for (i=1; i <= strlen(wordgame[c->wgames]); i++) {
			*fakes++;
			*wordsss++;
		        if (toupper(*fakes) == toupper(*param))
		             *wordsss = *param;
		     }
		     send_cmd (ci->bot, "PRIVMSG %s :ACTION The word now is \2%s\2 Hints: \37%s\37.",chan,c->wgame,wordhelp[c->wgames]);
		     *fakes = 0;
		     *wordsss = 0;
		}
	   }
	}
	/*******************************************************/
	else if (((stricmp(cmd,"`nextword")==0) || (stricmp(cmd,"!nextword")==0)) && (ci->botflag & CBI_GUESSWRD)){
	        Channel *c = findchan(chan);
	        double x =  RAND_MAX + 1.0;
		char *thisgame;
	        unsigned short i;
		if (
#ifdef DEFHALFOP
is_chanhop(source, chan) || 
#endif
		is_chanop(source,chan)) {
		     srand(time(NULL));
		     c->wgames = 1 + rand() * (wgameline/x);
		     send_cmd (ci->bot, "NOTICE %s :New Word Guessing Game start, type \2!GWord <word or char>\2 to make guess!!",chan);

		     if (c->wgame)
				free(c->wgame);
		     c->wgame = sstrdup(wordgame[c->wgames]);
		     thisgame = c->wgame;
		     *thisgame++;
		     for (i=2; i< strlen(wordgame[c->wgames]); i++)
			*thisgame++ = '*';
		     send_cmd (ci->bot, "NOTICE %s :The new word is \2%s\2 Hints: \37%s\37.",chan,c->wgame,wordhelp[c->wgames]);
		     send_cmd (ci->bot, "NOTICE @%s :Answer is \2%s\2",chan,wordgame[c->wgames]);
		} else {
			notice(ci->bot, source,"Only op can do.");
			return;
		}   
	   }
#endif /* WGAME */

#endif  /* Games */
   } else {
   }
}

/******************************************************************/

int is_chanbadwords(ChannelInfo *ci, char *text)
{
	int i;
	char **chanbads;

	if (!(ci->botflag & CBI_NOGB))
		if (is_badwords(text))
			return 1;

	if (!ci->badwords)
		return 0;

	for (chanbads = ci->badwords, i = 0; i < ci->badwline; ++chanbads, ++i) {
		if (match_wild_nocase(*chanbads, text))
			return 1;
	}
	return 0;
}

/*************************************************/
int is_online(const char *source)
{
	NickInfo *ni = findnick(source);
	if (!ni)
		return 0;
	if (ni->flags & NI_IDENTIFIED)
		return 1;
	return 0;
}
/**************************************************/
static void agenthtml() {
    FILE *fp;

    if (ishtml == 0)
	return;

    fp = fopen("agent.html", "w");
    if (fp) {
	fprintf(fp, "<style type=\"text/css\">");
	fprintf(fp, "<!--A:link, A:visited { text-decoration: none }");
	fprintf(fp, "A:hover { text-decoration: underline; color:  #FF0000 }");
	fprintf(fp, "A:hover { text-decoration: overline; color:  #0000000}--->");
	fprintf(fp, "</style>");
	fprintf(fp, "<body bgcolor=\"#FFFFFF\" text=\"#000000\" font=\"Arial, Helvetica, sans-serif\">");
	fprintf (fp, "<h2>Network Information</h2>\n");
	fprintf (fp, "<p>For changing setting use this command /msg agent set <option> <param></p>\n");
	fprintf (fp, "<p>Network Services Master: %s <B>ADMIN</B></p>\n", tokn[27]);
	fprintf (fp, "<p>Services Master E-mail : %s <B>ADMAIL</B></p>\n", tokn[28]);
	fprintf (fp, "<p>Services Reply E-mail  : %s <B>REPLYMAIL</B></p>\n", tokn[29]);
	fprintf (fp, "<p>Services Channel       : %s <B>OPERCHAN</B></p>\n", tokn[17]);
	fprintf (fp, "<hr><p>Enable URL?:  %s <B>USEURL</B></p>\n", tokn[44]);
	fprintf (fp, "<<p>NickServ register tour URL: %s <B>NSURL</B></p>\n", tokn[12]);
	fprintf (fp, "<p>ChanServ register tour URL: %s <B>CSURL</B></p>\n", tokn[13]);
	fprintf (fp, "<p>Becoming guest reason URL : %s <B>GUESTURL</B></p>\n", tokn[14]);
	fprintf (fp, "</body>\n");
	fclose (fp);
    }
}
